

#include "Include.h"
//#include "TM035HFZGZx.h"

#define Gray_1bpp    0 
#define Gray_2bpp    1

#define GrayLevel   Gray_2bpp

#define TFT_TM035     0
#define TFT_TYW        1

#define TFT_USE      TFT_TYW//TFT_TM035

/******************************************************************************

******************************************************************************/
void LCD_Init(void)
{
#if (TFT_USE == TFT_TYW)
  uint16_t i;
  
  Sim_8080_Init();
  
  LCD_nRST = 0;
  LCD_Wait_ms(5);
  LCD_nRST = 1;
  LCD_Wait_ms(10);
  
  Sim_8080_Command_Write(0x5E);
  Sim_8080_Data_Write(0xA5);
  LCD_Wait_ms(5);

  Sim_8080_Command_Write(0x49);//VCOM normalization
  Sim_8080_Data_Write(0x0E);
  Sim_8080_Data_Write(0x00);
  Sim_8080_Data_Write(0x00);
  Sim_8080_Data_Write(0xA5);

  Sim_8080_Command_Write(0x61);//-- all PWR on
  Sim_8080_Data_Write(0x8F);
  Sim_8080_Data_Write(0x44);
  Sim_8080_Data_Write(0x02);
  Sim_8080_Data_Write(0xA5);  

  Sim_8080_Command_Write(0x5A);//-- TEST
  Sim_8080_Data_Write(0x20);
  Sim_8080_Data_Write(0x71);
  Sim_8080_Data_Write(0xA5);
  Sim_8080_Data_Write(0xA5);    

  Sim_8080_Command_Write(0x71);//-- VCOM/VGH/VGL setting
  Sim_8080_Data_Write(0x3D);
  Sim_8080_Data_Write(0x0B);//updata this parameter by tianma 2015.3.31
  Sim_8080_Data_Write(0x0B);
  Sim_8080_Data_Write(0xA5);    

  Sim_8080_Command_Write(0x72);//-- GVDD/GVCL
  Sim_8080_Data_Write(0x19);
  Sim_8080_Data_Write(0x19);
  Sim_8080_Data_Write(0xA5);
  Sim_8080_Data_Write(0xA5);  
  

  Sim_8080_Command_Write(0x91);
  Sim_8080_Data_Write(0x01);
  Sim_8080_Data_Write(0x3F);
  Sim_8080_Data_Write(0x00);
  Sim_8080_Data_Write(0xEF);
	
  Sim_8080_Command_Write(0x92);
  Sim_8080_Data_Write(0x32);
  Sim_8080_Data_Write(0x02);
  Sim_8080_Data_Write(0x00);
  Sim_8080_Data_Write(0x01);
	
  Sim_8080_Command_Write(0x93);
  Sim_8080_Data_Write(0x0A);
  Sim_8080_Data_Write(0x28);
  Sim_8080_Data_Write(0x0C);
  Sim_8080_Data_Write(0x26);
    
  Sim_8080_Command_Write(0x21);
  #if( IC_PCB_Current  ==  PCB_537)
  Sim_8080_Data_Write(0x01);//--MV = 0; MX=1; MY=1
  #elif(IC_PCB_Current  ==  PCB_517)
  Sim_8080_Data_Write(0x00);//--MV = 0; MX=1; MY=1
  #else 
  
  #endif
  Sim_8080_Data_Write(0xA5);
  Sim_8080_Data_Write(0xA5);
  Sim_8080_Data_Write(0xA5);   
	
  Sim_8080_Command_Write(0x24);
  Sim_8080_Data_Write(0x00); 
  Sim_8080_Data_Write(0xA5);
  Sim_8080_Data_Write(0xA5);
  Sim_8080_Data_Write(0xA5);
  
  Sim_8080_Command_Write(0x25);
  #if (GrayLevel == Gray_1bpp)
  Sim_8080_Data_Write(0x00);
  #elif(GrayLevel == Gray_2bpp)
  Sim_8080_Data_Write(0x01);
  #endif
  Sim_8080_Data_Write(0xA5);
  Sim_8080_Data_Write(0xA5);
  Sim_8080_Data_Write(0xA5);
    
  Sim_8080_Command_Write(0x26);
  Sim_8080_Data_Write(0x00);
  Sim_8080_Data_Write(0x00);
  Sim_8080_Data_Write(0x00);
  Sim_8080_Data_Write(0xA5);
    
  Sim_8080_Command_Write(0xA2);//-- Gate Set VGPP = Inside; ScanDir = Normal; scan mode = scan mode 1
  #if( IC_PCB_Current  ==  PCB_537)
  Sim_8080_Data_Write(0x00);//180ȷת
  #elif(IC_PCB_Current  ==  PCB_517)
  Sim_8080_Data_Write(0x10);//180ȷת
  #else 
  
  #endif          
  Sim_8080_Data_Write(0xA5);
  Sim_8080_Data_Write(0xA5);
  Sim_8080_Data_Write(0xA5);

  Sim_8080_Command_Write(0x69);//-- ACSET
  Sim_8080_Data_Write(0x00);
  Sim_8080_Data_Write(0xA5);
  Sim_8080_Data_Write(0xA5);
  Sim_8080_Data_Write(0xA5);  
    
  Sim_8080_Command_Write(0xA1);
  Sim_8080_Data_Write(0x00);
  Sim_8080_Data_Write(0xA5);
  Sim_8080_Data_Write(0xA5);
  Sim_8080_Data_Write(0xA5);
  
  #if (GrayLevel == Gray_1bpp)
  Sim_8080_Command_Write(0x86);
  Sim_8080_Data_Write(0x00);
  Sim_8080_Data_Write(0x3F);
  Sim_8080_Data_Write(0x00);
  Sim_8080_Data_Write(0x3F);
  
  #elif(GrayLevel == Gray_2bpp)
  Sim_8080_Command_Write(0x85); //-- Gamma Set 2bpp Positive
  Sim_8080_Data_Write(0x00);
  Sim_8080_Data_Write(0x20);
  Sim_8080_Data_Write(0x2A);
  Sim_8080_Data_Write(0x3F);

  Sim_8080_Command_Write(0x8D);  //-- Gamma Set 2bpp Negative
  Sim_8080_Data_Write(0x00);
  Sim_8080_Data_Write(0x20);
  Sim_8080_Data_Write(0x2A);
  Sim_8080_Data_Write(0x3F);
  #endif	

  
  LCD_Wait_ms(2);
	
  Sim_8080_Command_Write(0x13);
  Sim_8080_Data_Write(0xA5);
	
  LCD_Wait_ms(5);
  
  Sim_8080_Command_Write(0x12);
  Sim_8080_Data_Write(0xA5);
  
  LCD_ClearFull(); 
//  for (i = 0; i < 19200; i++)
//    Sim_8080_Data_Write(0x00);

#elif(TFT_USE == TFT_TM035)  
  uint16_t i;

  Sim_8080_Init();
  
  LCD_nRST = 0;
  LCD_Wait_ms(5);
  LCD_nRST = 1;
  LCD_Wait_ms(10);
  
  Sim_8080_Command_Write(0x5E);
  Sim_8080_Data_Write(0xA5);

  Sim_8080_Command_Write(0x91);
  Sim_8080_Data_Write(0x01);
  Sim_8080_Data_Write(0x3F);
  Sim_8080_Data_Write(0x00);
  Sim_8080_Data_Write(0xEF);
	
  Sim_8080_Command_Write(0x92);
  Sim_8080_Data_Write(0x32);
  Sim_8080_Data_Write(0x02);
  Sim_8080_Data_Write(0x80);
  Sim_8080_Data_Write(0x01);
	
  Sim_8080_Command_Write(0x93);
  Sim_8080_Data_Write(0x0A);
  Sim_8080_Data_Write(0x28);
  Sim_8080_Data_Write(0x0C);
  Sim_8080_Data_Write(0x26);
    
  Sim_8080_Command_Write(0x21);
  Sim_8080_Data_Write(0x00);
  Sim_8080_Data_Write(0xA5);
  Sim_8080_Data_Write(0xA5);
  Sim_8080_Data_Write(0xA5);   
	
  Sim_8080_Command_Write(0x24);
  Sim_8080_Data_Write(0x00); 
  Sim_8080_Data_Write(0xA5);
  Sim_8080_Data_Write(0xA5);
  Sim_8080_Data_Write(0xA5);
  
  Sim_8080_Command_Write(0x25);
#if (GrayLevel == Gray_1bpp)
  Sim_8080_Data_Write(0x00);
#elif(GrayLevel == Gray_2bpp)
  Sim_8080_Data_Write(0x01);
#endif
  Sim_8080_Data_Write(0xA5);
  Sim_8080_Data_Write(0xA5);
  Sim_8080_Data_Write(0xA5);
    
  Sim_8080_Command_Write(0x26);
  Sim_8080_Data_Write(0x00);
  Sim_8080_Data_Write(0x00);
  Sim_8080_Data_Write(0x00);
  Sim_8080_Data_Write(0xA5);
    
  Sim_8080_Command_Write(0xA2);
  Sim_8080_Data_Write(0x00);
  Sim_8080_Data_Write(0xA5);
  Sim_8080_Data_Write(0xA5);
  Sim_8080_Data_Write(0xA5);
    
  Sim_8080_Command_Write(0xA1);
  Sim_8080_Data_Write(0x00);
  Sim_8080_Data_Write(0xA5);
  Sim_8080_Data_Write(0xA5);
  Sim_8080_Data_Write(0xA5);
  
#if (GrayLevel == Gray_1bpp)
  Sim_8080_Command_Write(0x86);
  Sim_8080_Data_Write(0x00);
  Sim_8080_Data_Write(0x3F);
  Sim_8080_Data_Write(0x00);
  Sim_8080_Data_Write(0x3F);
  
#elif(GrayLevel == Gray_2bpp)
  Sim_8080_Command_Write(0x85); //-- Gamma Set 2bpp Positive
  Sim_8080_Data_Write(0x00);
  Sim_8080_Data_Write(0x14);
  Sim_8080_Data_Write(0x1A);
  Sim_8080_Data_Write(0x3F);

  Sim_8080_Command_Write(0x8D);  //-- Gamma Set 2bpp Negative
  Sim_8080_Data_Write(0x00);
  Sim_8080_Data_Write(0x14);
  Sim_8080_Data_Write(0x1A);
  Sim_8080_Data_Write(0x3F);
#endif	

  Sim_8080_Command_Write(0x71);
  Sim_8080_Data_Write(0x0E);
  Sim_8080_Data_Write(0x0E);
  Sim_8080_Data_Write(0x18);
  Sim_8080_Data_Write(0x18);
   
  Sim_8080_Command_Write(0x72);
  Sim_8080_Data_Write(0x00); 
  Sim_8080_Data_Write(0x18);
  Sim_8080_Data_Write(0x91);
  Sim_8080_Data_Write(0xA5);	
	
  Sim_8080_Command_Write(0x61);
  Sim_8080_Data_Write(0x5F);
  Sim_8080_Data_Write(0x01);
  Sim_8080_Data_Write(0x00);
  Sim_8080_Data_Write(0xA5);
  
  LCD_Wait_ms(2);
	
  Sim_8080_Command_Write(0x13);
  Sim_8080_Data_Write(0xA5);
	
  LCD_Wait_ms(5);
  
  Sim_8080_Command_Write(0x12);
  Sim_8080_Data_Write(0xA5);
  
  Sim_8080_Command_Write(0x22);
  Sim_8080_Data_Write(0);
  Sim_8080_Data_Write(0x4F);
  Sim_8080_Data_Write(0x00);
  Sim_8080_Data_Write(0xA5);
    
  Sim_8080_Command_Write(0x23); 
  Sim_8080_Data_Write(0);
  Sim_8080_Data_Write(0);
  Sim_8080_Data_Write(0);
  Sim_8080_Data_Write(0xEF);
  
 // Sim_8080_Command_Write(0x3A);
  //Sim_8080_Data_Write(0xA5); 
  
  LCD_ClearFull();
#endif
}
  
void LCD_ClearFull(void)
{
  uint16_t i;
  LCD_Set_Window(0, 0, 239, 79);
  
  Sim_8080_Command_Write(0x3A);
  Sim_8080_Data_Write(0xA5); 
  
  for (i = 0; i < 19200; i++)
    Sim_8080_Data_Write(0x00);
}  
  
  
void LCD_Shutdown(void)
{
  Sim_8080_Command_Write(0x11);
  Sim_8080_Data_Write(0xA5);
  Sim_8080_Command_Write(0x14);      
  Sim_8080_Data_Write(0xA5);
  
  LCD_Wait_ms(1);
  LCD_nRST = 0;
  LCD_Wait_ms(5);
  LCD_nRST = 1;
  SIM_8080_P_nCS = 1;
  SIM_8080_P_DATA = 0;
  
}

void LCD_Set_Window(uint8_t StartCol, uint8_t StartPage, uint8_t EndCol, uint8_t EndPage) 
{
  Sim_8080_Command_Write(0x22);
  Sim_8080_Data_Write(StartPage);
  Sim_8080_Data_Write(EndPage);
  Sim_8080_Data_Write(0x00);
  Sim_8080_Data_Write(0xA5);
    
  Sim_8080_Command_Write(0x23); 
  Sim_8080_Data_Write(0);
  Sim_8080_Data_Write(StartCol);
  Sim_8080_Data_Write(0);
  Sim_8080_Data_Write(EndCol);
}  
  
void LCD_Start_Data_Writing(void)
{
  Sim_8080_Command_Write(0x3A);
  Sim_8080_Data_Write(0xA5);   
}


void LCD_Write_Data(uint8_t Data)
{
  Sim_8080_Data_Write(Data);
} 
  
void LCD_Start_Data_Reading(void)
{
  Sim_8080_Command_Write(0x39);
  Sim_8080_Data_Write(0xA5);  
}  
  
uint8_t LCD_Read_Data(void)
{
  return Sim_8080_Data_Read();
}


/******************************************************************************
???y????LCD_Wait_ms
??  ??????????????
??  ?y??msCnt?????????,????ms
?????????
******************************************************************************/
void LCD_Wait_ms(uint8_t msCnt)
{
  uint16_t Dst;
  
  Dst  = (uint16_t)msCnt;
  Dst  = Dst * (1000 / API_INT_CYCLE);
  Dst += API_ROLLING_COUNTER;
  
  while (Dst != API_ROLLING_COUNTER);
}

