#include "Include.h"
INT8U g_u8SelfLampTimes;
INT8U Acu_Led = 0;
INT8U Acu_Led_Old = 0;
INT8U Airbag_LampTimes = 0;
INT8U ACU_LampTimes = 0;

//1.��ת
void LeftTurn_Lamp(void)
{
	if (CAN_MSG_Status(CAN_CH0, CAN_CH0_ID_BCM_light_Msg_Count) == CAN_MSG_LOST)
	{
		LED_Driver_Channel_Set(Channel_1, LampCh1_LeftTurn, Lamp_Off);
	}
	else
	{
		if ((Get_CAN_CH0_ID_18FE4021_Sig_BCM_LeftTurnSignalLights() == 1) || (Get_CAN_CH0_ID_18FE4021_Sig_BCM_LeftTurnSignalLights() == 2))
		{
			LED_Driver_Channel_Set(Channel_1, LampCh1_LeftTurn, Lamp_On);
		}
		else
		{
			LED_Driver_Channel_Set(Channel_1, LampCh1_LeftTurn, Lamp_Off);
		}
	}
}

//2.��ת��
void RightTurn_Lamp(void)
{
	if (CAN_MSG_Status(CAN_CH0, CAN_CH0_ID_BCM_light_Msg_Count) == CAN_MSG_LOST)
	{
		LED_Driver_Channel_Set(Channel_0, LampCh0_RightTurn, Lamp_Off);
	}
	else
	{
		if ((Get_CAN_CH0_ID_18FE4021_Sig_BCM_RightTurnSignalLights() == 1) || (Get_CAN_CH0_ID_18FE4021_Sig_BCM_RightTurnSignalLights() == 2))
		{
			LED_Driver_Channel_Set(Channel_0, LampCh0_RightTurn, Lamp_On);
		}
		else
		{
			LED_Driver_Channel_Set(Channel_0, LampCh0_RightTurn, Lamp_Off);
		}
	}
}

//19.����ָʾ��
void LowBeam_Lamp(void)
{
	if(SYS_OPR_STAT_IGN_ON)
	{
		if (CAN_MSG_Status(CAN_CH0, CAN_CH0_ID_BCM_light_Msg_Count) == CAN_MSG_LOST)
		{
			LED_Driver_Channel_Set(Channel_0, LampCh0_Low_Beam, Lamp_Off);
		}
		else
		{
			if ((Get_CAN_CH0_ID_18FE4021_Sig_BCM_LowBeamHeadLightData() == 1) || (Get_CAN_CH0_ID_18FE4021_Sig_BCM_LowBeamHeadLightData() == 2))
			{
				LED_Driver_Channel_Set(Channel_0, LampCh0_Low_Beam, Lamp_On);
			}
			else
			{
				LED_Driver_Channel_Set(Channel_0, LampCh0_Low_Beam, Lamp_Off);
			}
		}
	}
	else
	{
		LED_Driver_Channel_Set(Channel_0, LampCh0_Low_Beam, Lamp_Off);	
	}
}

//3.Զ���
void HighBeam_Lamp(void)
{
	if (CAN_MSG_Status(CAN_CH0, CAN_CH0_ID_BCM_light_Msg_Count) == CAN_MSG_LOST)
	{
		LED_Driver_Channel_Set(Channel_1, LampCh1_HighBeam, Lamp_Off);
	}
	else
	{
		if ((Get_CAN_CH0_ID_18FE4021_Sig_BCM_HighBeamHeadLightData() == 1) || (Get_CAN_CH0_ID_18FE4021_Sig_BCM_HighBeamHeadLightData() == 2))
		{
			LED_Driver_Channel_Set(Channel_1, LampCh1_HighBeam, Lamp_On);
		}
		else
		{
			LED_Driver_Channel_Set(Channel_1, LampCh1_HighBeam, Lamp_Off);
		}
	}
}

//ǰ����
void FrontFog_Lamp(void)
{
	if(SYS_OPR_STAT_IGN_ON)
	{
		if (CAN_MSG_Status(CAN_CH0, CAN_CH0_ID_BCM_light_Msg_Count) == CAN_MSG_LOST)
		{
			LED_Driver_Channel_Set(Channel_1, LampCh1_FrontFog, Lamp_Off);
		}
		else
		{
			if ((Get_CAN_CH0_ID_18FE4021_Sig_BCM_TractorFrontFogLights() == 1) || (Get_CAN_CH0_ID_18FE4021_Sig_BCM_TractorFrontFogLights() == 2))
			{
				LED_Driver_Channel_Set(Channel_1, LampCh1_FrontFog, Lamp_On);
			}
			else
			{
				LED_Driver_Channel_Set(Channel_1, LampCh1_FrontFog, Lamp_Off);
			}
		}
	}
	else
	{
		LED_Driver_Channel_Set(Channel_1, LampCh1_FrontFog, Lamp_Off);	
	}
}


//5.������ָʾ
void RearFog_Lamp(void)
{
	if (CAN_MSG_Status(CAN_CH0, CAN_CH0_ID_BCM_light_Msg_Count) == CAN_MSG_LOST)
	{
		LED_Driver_Channel_Set(Channel_1, LampCh1_RearFog, Lamp_Off);
	}
	else
	{
		if (SYS_OPR_STAT_IGN_ON)
		{
			if ((Get_CAN_CH0_ID_18FE4021_Sig_BCM_RearFogLights() == 1) || (Get_CAN_CH0_ID_18FE4021_Sig_BCM_RearFogLights() == 2))
			{
				LED_Driver_Channel_Set(Channel_1, LampCh1_RearFog, Lamp_On);
			}
			else
			{
				LED_Driver_Channel_Set(Channel_1, LampCh1_RearFog, Lamp_Off);
			}
		}
		else
		{
			LED_Driver_Channel_Set(Channel_1, LampCh1_RearFog, Lamp_Off);
		}
	}
}
//6  �ռ��г���
void Running_Lamp(void)
{
	if (CAN_MSG_Status(CAN_CH0, CAN_CH0_ID_BCM_light_Msg_Count) == CAN_MSG_LOST)
	{
		LED_Driver_Channel_Set(Channel_1, LampCh1_DayRunning, Lamp_Off);
	}
	else
	{
		if (SYS_OPR_STAT_IGN_ON)
		{
			if ((Get_CAN_CH0_ID_18FE4021_Sig_BCM_RunningLight() == 1) || (Get_CAN_CH0_ID_18FE4021_Sig_BCM_RunningLight() == 2))
			{
				LED_Driver_Channel_Set(Channel_1, LampCh1_DayRunning, Lamp_On);
			}
			else
			{
				LED_Driver_Channel_Set(Channel_1, LampCh1_DayRunning, Lamp_Off);
			}
		}
		else
		{
			LED_Driver_Channel_Set(Channel_1, LampCh1_DayRunning, Lamp_Off);
		}
	}
}

//λ�õ�
void Position_Lamp(void)
{
	if (CAN_MSG_Status(CAN_CH0, CAN_CH0_ID_BCM_light_Msg_Count) == CAN_MSG_LOST)
	{
		LED_Driver_Channel_Set(Channel_1, LampCh1_Position, Lamp_Off);
	}
	else
	{
		if ((Get_CAN_CH0_ID_18FE4021_Sig_BCM_TractorMarkerLight() == 1) || (Get_CAN_CH0_ID_18FE4021_Sig_BCM_TractorMarkerLight() == 2))
		{
			LED_Driver_Channel_Set(Channel_1, LampCh1_Position, Lamp_On);
		}
		else
		{
			LED_Driver_Channel_Set(Channel_1, LampCh1_Position, Lamp_Off);
		}
	}
}

//��ѹDCDC����
void Low_DC_DC_Lamp(void)
{
	if (SYS_OPR_STAT_IGN_ON)
	{
		if (Line_In_Get_Status(LINE_IN_LowDCFlt))
		{
			LED_Driver_Channel_Set(Channel_0, LampCh0_Low_DC_DC, Lamp_On);
		}
		else
		{
			LED_Driver_Channel_Set(Channel_0, LampCh0_Low_DC_DC, Lamp_Off);
		}
	}
	else
	{
		LED_Driver_Channel_Set(Channel_0, LampCh0_Low_DC_DC, Lamp_Off);
	}
}

//�ƶ�ϵͳ����ָʾ��
void Brake_System_Failure_Lamp(void)
{
	if (g_u8SelfLampTimes < LED_SELF_CHECK_TIME)
	{
		LED_Driver_Channel_Set(Channel_1, LampCh1_Brake_System_Failure, Lamp_On);
	}
	else
	{
		if (SYS_OPR_STAT_IGN_ON)
		{
			if (CAN_MSG_Status(CAN_CH0, CAN_CH0_ID_PMS_18FAB027_Msg_Count) == CAN_MSG_LOST)
			{
				LED_Driver_Channel_Set(Channel_1, LampCh1_Brake_System_Failure, Lamp_On);
			}
			else
			{
				if (Get_CAN_CH0_ID_18FAB027_Sig_PMS_BrkSysErr() == 1) 
				{
					LED_Driver_Channel_Set(Channel_1, LampCh1_Brake_System_Failure, Lamp_On);
				}
				else
				{
					LED_Driver_Channel_Set(Channel_1, LampCh1_Brake_System_Failure, Lamp_Off);
				}
			}
		}
		else
		{
			LED_Driver_Channel_Set(Channel_1, LampCh1_Brake_System_Failure, Lamp_Off);
		}
	}
}

//����פ��
void Electronic_parking_Lamp(void)
{
	if ((Val_EOL_F110_EPB_Air() == 1)&&(Val_EOL_F110_EPB_Liquid() == 0))//��ɲ
	{
		if (g_u8SelfLampTimes < LED_SELF_CHECK_TIME)
		{
			LED_Driver_Channel_Set(Channel_1, LampCh1_Electronic_parking, Lamp_On);
		}
		else
		{
			if (SYS_OPR_STAT_IGN_ON)
			{
				if ((CAN_MSG_Status(CAN_CH0, CAN_CH0_ID_EPB_StsInfor_Msg_Count) == CAN_MSG_LOST)||(CAN_MSG_Status(CAN_CH0, CAN_CH0_ID_PMS_18FAB027_Msg_Count) == CAN_MSG_LOST))
				{
					LED_Driver_Channel_Set(Channel_1, LampCh1_Electronic_parking, Lamp_Off);
				}
				else
				{
					if((Get_CAN_CH0_ID_18FFB88F_Sig_EPB_ParkBrakeSts() == 1)&&((Get_CAN_CH0_ID_18FFB88F_Sig_EPB_FltLevel() == 1)||(Get_CAN_CH0_ID_18FFB88F_Sig_EPB_FltLevel() == 2)||(Get_CAN_CH0_ID_18FFB88F_Sig_EPB_FltLevel() == 3)))
					{
						LED_Driver_Channel_Set(Channel_1, LampCh1_Electronic_parking, Lamp_Blink_1Hz);
					}
					else 
					{
						if(((Get_CAN_CH0_ID_18FFB88F_Sig_EPB_ParkBrakeSts() == 1)&&(Get_CAN_CH0_ID_18FFB88F_Sig_EPB_FltLevel() == 0))||(Get_CAN_CH0_ID_18FAB027_Sig_PMS_HandbrakeSts() == 1))
						{
							LED_Driver_Channel_Set(Channel_1, LampCh1_Electronic_parking, Lamp_On);
						}
						else
						{
							LED_Driver_Channel_Set(Channel_1, LampCh1_Electronic_parking, Lamp_Off);
						}
					}	
				}
			}
			else
			{
				LED_Driver_Channel_Set(Channel_1, LampCh1_Electronic_parking, Lamp_Off);
			}
		}
	}
	else
	{
		if((Val_EOL_F110_EPB_Liquid() == 1)&&(Val_EOL_F110_EPB_Air() == 0))
		{
			if (g_u8SelfLampTimes < LED_SELF_CHECK_TIME)
			{
				LED_Driver_Channel_Set(Channel_1, LampCh1_Electronic_parking, Lamp_On);
			}
			else
			{
				if (SYS_OPR_STAT_IGN_ON)
				{
					if ((CAN_MSG_Status(CAN_CH0, CAN_CH0_ID_EPB_0CFABF8F_Msg_Count) == CAN_MSG_LOST)&&(CAN_MSG_Status(CAN_CH0, CAN_CH0_ID_PMS_18FAB027_Msg_Count) == CAN_MSG_LOST))
					{
						LED_Driver_Channel_Set(Channel_1, LampCh1_Electronic_parking, Lamp_Off);
					}
					else
					{
						if((Get_CAN_CH0_ID_0CFABF8F_Sig_EPB_ParkLampState() == 1)||(Get_CAN_CH0_ID_18FAB027_Sig_PMS_HandbrakeSts() == 1))
						{
							LED_Driver_Channel_Set(Channel_1, LampCh1_Electronic_parking, Lamp_On);
						}
						else 
						{
							LED_Driver_Channel_Set(Channel_1, LampCh1_Electronic_parking, Lamp_Off);
						}	
					}
				}
				else
				{
					LED_Driver_Channel_Set(Channel_1, LampCh1_Electronic_parking, Lamp_Off);
				}
			}
		}
		else
		{
			if ((Val_EOL_F110_EPB_Liquid() == 0)&&(Val_EOL_F110_EPB_Air() == 0))//Һɲ
			{
				if (g_u8SelfLampTimes < LED_SELF_CHECK_TIME)
				{
					LED_Driver_Channel_Set(Channel_1, LampCh1_Electronic_parking, Lamp_On);
				}
				else
				{
					if (SYS_OPR_STAT_IGN_ON)
					{
						if (CAN_MSG_Status(CAN_CH0, CAN_CH0_ID_PMS_18FAB027_Msg_Count) == CAN_MSG_LOST)
						{
							LED_Driver_Channel_Set(Channel_1, LampCh1_Electronic_parking, Lamp_Off);
						}
						else
						{
							if(Get_CAN_CH0_ID_18FAB027_Sig_PMS_HandbrakeSts() == 1)
							{
								LED_Driver_Channel_Set(Channel_1, LampCh1_Electronic_parking, Lamp_On);
							}
							else 
							{
								LED_Driver_Channel_Set(Channel_1, LampCh1_Electronic_parking, Lamp_Off);
							}	
						}
					}
					else
					{
						LED_Driver_Channel_Set(Channel_1, LampCh1_Electronic_parking, Lamp_Off);
					}
				}
			}
			else
			{
				LED_Driver_Channel_Set(Channel_1, LampCh1_Electronic_parking, Lamp_Off);
			}
		}
	}
}

//ABS
void ABS_Lamp(void)
{
	if (Val_EOL_F110_ABS() == 1)
	{
		if (g_u8SelfLampTimes < LED_SELF_CHECK_TIME)
		{
			LED_Driver_Channel_Set(Channel_1, LampCh1_ABS, Lamp_On);
		}
		else
		{
			if (SYS_OPR_STAT_IGN_ON)
			{
				if (CAN_MSG_Status(CAN_CH0, CAN_CH0_ID_ABS_EBS_EBC1_Msg_Count) == CAN_MSG_LOST)
				{
					LED_Driver_Channel_Set(Channel_1, LampCh1_ABS, Lamp_On);
				}
				else
				{
					if (Get_CAN_CH0_ID_18F0010B_Sig_EBS_ABS_AmberWarningState() == 1)
					{
						LED_Driver_Channel_Set(Channel_1, LampCh1_ABS, Lamp_On);
					}
					else
					{
						LED_Driver_Channel_Set(Channel_1, LampCh1_ABS, Lamp_Off);
					}
				}
			}
			else
			{
				LED_Driver_Channel_Set(Channel_1, LampCh1_ABS, Lamp_Off);
			}
		}
	}
	else
	{
		LED_Driver_Channel_Set(Channel_1, LampCh1_ABS, Lamp_Off);
	}
}

//�Զ�פ���ƣ������
void AutoHold_Lamp(void)  
{
	if ((Val_EOL_F101_AutoHold() == 2)&&(Val_EOL_F101_Break() == 1))//Һɲ
	{
		LED_Driver_Channel_Set(Channel_1, LampCh1_AutoHold_G, Lamp_Off);
		LED_Driver_Channel_Set(Channel_1, LampCh1_AutoHold_R, Lamp_Off);
	}
	else
	{
		if ((Val_EOL_F101_AutoHold() == 2)&&(Val_EOL_F101_Break() == 2))//��ɲ
		{
			if (SYS_OPR_STAT_IGN_ON)
			{
				if (CAN_MSG_Status(CAN_CH0, CAN_CH0_ID_EPB_StsInfor_Msg_Count) == CAN_MSG_LOST)
				{
					LED_Driver_Channel_Set(Channel_1, LampCh1_AutoHold_G, Lamp_Off);
					LED_Driver_Channel_Set(Channel_1, LampCh1_AutoHold_R, Lamp_Off);
				}
				else
				{
					if((Get_CAN_CH0_ID_18FFB88F_Sig_EPB_TemParkActive() == 1)&&(Get_CAN_CH0_ID_18FFB88F_Sig_EPB_TemParkBrakeSts() == 1))
					{
						LED_Driver_Channel_Set(Channel_1, LampCh1_AutoHold_G, Lamp_Blink_1Hz);
						LED_Driver_Channel_Set(Channel_1, LampCh1_AutoHold_R, Lamp_Off);
					}
					else 
					{
						if (Get_CAN_CH0_ID_18FFB88F_Sig_EPB_TemParkActive() == 2)
						{
							LED_Driver_Channel_Set(Channel_1, LampCh1_AutoHold_G, Lamp_Off);
							LED_Driver_Channel_Set(Channel_1, LampCh1_AutoHold_R, Lamp_On);
						}
						else
						{
							if (Get_CAN_CH0_ID_18FFB88F_Sig_EPB_TemParkActive() == 1)
							{
								LED_Driver_Channel_Set(Channel_1, LampCh1_AutoHold_G, Lamp_On);
								LED_Driver_Channel_Set(Channel_1, LampCh1_AutoHold_R, Lamp_Off);
							}
							else
							{
								LED_Driver_Channel_Set(Channel_1, LampCh1_AutoHold_G, Lamp_Off);
								LED_Driver_Channel_Set(Channel_1, LampCh1_AutoHold_R, Lamp_Off);
							}
						}
					}
				}
			}
			else
			{
				LED_Driver_Channel_Set(Channel_1, LampCh1_AutoHold_G, Lamp_Off);
				LED_Driver_Channel_Set(Channel_1, LampCh1_AutoHold_R, Lamp_Off);
			}
		}
	}
	
}

//READYָʾ��
void READY_Lamp(void)
{
	if(SYS_OPR_STAT_IGN_ON)
	{
		if (CAN_MSG_Status(CAN_CH0, CAN_CH0_ID_PMS_18FAB027_Msg_Count) == CAN_MSG_LOST)
		{
			LED_Driver_Channel_Set(Channel_0, LampCh0_Ready, Lamp_Off);
		}
		else
		{
			if ((Get_CAN_CH0_ID_18FAB027_Sig_PMS_PTReadyInd() == 1))
			{
				LED_Driver_Channel_Set(Channel_0, LampCh0_Ready, Lamp_On);
			}
			else
			{
				LED_Driver_Channel_Set(Channel_0, LampCh0_Ready, Lamp_Off);
			}
		}
	}
	else
	{
		LED_Driver_Channel_Set(Channel_0, LampCh0_Ready, Lamp_Off);	
	}
}


//ˮ��ָʾ��

void EWP_Lamp(void)
{
	if (Val_EOL_F110_EMS() == 1)
	{
		if (g_u8SelfLampTimes < LED_SELF_CHECK_TIME)
		{
			LED_Driver_Channel_Set(Channel_1, LampCh1_Water_Pump_Fault, Lamp_On);
		}
		else
		{
			if(SYS_OPR_STAT_IGN_ON)
			{
				if (CAN_MSG_Status(CAN_CH0, CAN_CH0_ID_PMS_18FAA527_Msg_Count) == CAN_MSG_LOST)
				{
					LED_Driver_Channel_Set(Channel_1, LampCh1_Water_Pump_Fault, Lamp_On);
				}
				else
				{ 
				
					if ((Get_CAN_CH0_ID_18FAA527_Sig_PMS_HBCP_FaultFB() == 25)&&(Get_CAN_CH0_ID_18FAA527_Sig_PMS_ECPM_FaultFB() == 25)&&(Get_CAN_CH0_ID_18FAA527_Sig_PMS_EDCP_FaultFB() == 25))
					{
						LED_Driver_Channel_Set(Channel_1, LampCh1_Water_Pump_Fault, Lamp_Off);
					}
					else
					{
						LED_Driver_Channel_Set(Channel_1, LampCh1_Water_Pump_Fault, Lamp_On);
					}
				}
			}
			else
			{
				LED_Driver_Channel_Set(Channel_1, LampCh1_Water_Pump_Fault, Lamp_Off);	
			}
		}
	}
	else if (Val_EOL_F110_EMS() == 0)
	{
		if (g_u8SelfLampTimes < LED_SELF_CHECK_TIME)
		{
			LED_Driver_Channel_Set(Channel_1, LampCh1_Water_Pump_Fault, Lamp_On);
		}
		else
		{
			if(SYS_OPR_STAT_IGN_ON)
			{
				if (CAN_MSG_Status(CAN_CH0, CAN_CH0_ID_PMS_18FAA527_Msg_Count) == CAN_MSG_LOST)
				{
					LED_Driver_Channel_Set(Channel_1, LampCh1_Water_Pump_Fault, Lamp_On);
				}
				else
				{
					if ((Get_CAN_CH0_ID_18FAA527_Sig_PMS_HBCP_FaultFB() == 25)&&(Get_CAN_CH0_ID_18FAA527_Sig_PMS_EDCP_FaultFB() == 25))
					{
						LED_Driver_Channel_Set(Channel_1, LampCh1_Water_Pump_Fault, Lamp_Off);
					}
					else
					{
						LED_Driver_Channel_Set(Channel_1, LampCh1_Water_Pump_Fault, Lamp_On);
					}
				}
			}
			else
			{
				LED_Driver_Channel_Set(Channel_1, LampCh1_Water_Pump_Fault, Lamp_Off);	
			}
		}
	}
	else
	{
		LED_Driver_Channel_Set(Channel_1, LampCh1_Water_Pump_Fault, Lamp_Off);
	}
}

//�������ָʾ��
void Motor_Failure_Lamp(void)
{
	if (g_u8SelfLampTimes < LED_SELF_CHECK_TIME)
	{
		LED_Driver_Channel_Set(Channel_0, LampCh0_Motor_Failure, Lamp_On);
	}
	else
	{
		if(SYS_OPR_STAT_IGN_ON)
		{
			if (CAN_MSG_Status(CAN_CH0, CAN_CH0_ID_MCU_18FA02EF_Msg_Count) == CAN_MSG_LOST)
			{
				LED_Driver_Channel_Set(Channel_0, LampCh0_Motor_Failure, Lamp_On);
			}
			else
			{
				if ((Get_CAN_CH0_ID_18FA02EF_Sig_MCU_MotorFltLevel() == 2)||(Get_CAN_CH0_ID_18FA02EF_Sig_MCU_MotorFltLevel() == 3))
				{
					LED_Driver_Channel_Set(Channel_0, LampCh0_Motor_Failure, Lamp_On);
				}
				else
				{
					LED_Driver_Channel_Set(Channel_0, LampCh0_Motor_Failure, Lamp_Off);
				}
			}
		}
		else
		{
			LED_Driver_Channel_Set(Channel_0, LampCh0_Motor_Failure, Lamp_Off);	
		}
	}
	
}


//��ѹDCDC����
void High_DC_DC_Lamp(void) 
{
	if (SYS_OPR_STAT_IGN_ON)  
	{
		if ((CAN_MSG_Status(CAN_CH0, CAN_CH0_ID_PMS_18FAB027_Msg_Count) == CAN_MSG_LOST)||(CanReceive.Can_18FAB027 != 1))
		{
			LED_Driver_Channel_Set(Channel_1, LampCh1_High_DC_DC, Lamp_Off);
		}
		else
		{
			if(Get_CAN_CH0_ID_18FAB027_Sig_PMS_DCDC_WorkSts() == 0)
			{
				LED_Driver_Channel_Set(Channel_1, LampCh1_High_DC_DC, Lamp_On);
			}
			else
			{			
				LED_Driver_Channel_Set(Channel_1, LampCh1_High_DC_DC, Lamp_Off);				
			}
		}
	}
	else
	{
		LED_Driver_Channel_Set(Channel_1, LampCh1_High_DC_DC, Lamp_Off);
	}
}


//������ع���

void BatteryFault_Lamp(void)
{
	if (g_u8SelfLampTimes < LED_SELF_CHECK_TIME)
	{
		LED_Driver_Channel_Set(Channel_0, LampCh0_BatteryFault, Lamp_On);
	}
	else
	{
		if(SYS_OPR_STAT_IGN_ON)
		{
			if (CAN_MSG_Status(CAN_CH0, CAN_CH0_ID_EMS_18FA40F4_Msg_Count) == CAN_MSG_LOST)
			{
				LED_Driver_Channel_Set(Channel_0, LampCh0_BatteryFault, Lamp_On);
			}
			else
			{
				
				if ((Get_CAN_CH0_ID_18FA40F4_Sig_BMS_FaultLevel() == 2)||(Get_CAN_CH0_ID_18FA40F4_Sig_BMS_FaultLevel() == 3))
				{
					LED_Driver_Channel_Set(Channel_0, LampCh0_BatteryFault, Lamp_On);
				}
				else
				{
					LED_Driver_Channel_Set(Channel_0, LampCh0_BatteryFault, Lamp_Off);
				}
			}
		}
		else
		{
			LED_Driver_Channel_Set(Channel_0, LampCh0_BatteryFault, Lamp_Off);	
		}
	}
}

//��������жϹ���
void BatteryCutOff_Lamp(void)
{
	if (g_u8SelfLampTimes < LED_SELF_CHECK_TIME)
	{
		LED_Driver_Channel_Set(Channel_0, LampCh0_BatteryCutOff, Lamp_On);
	}
	else
	{
		if (SYS_OPR_STAT_IGN_ON)
		{
			if (CAN_MSG_Status(CAN_CH0, CAN_CH0_ID_PMS_18FAB027_Msg_Count) == CAN_MSG_LOST)
			{
				LED_Driver_Channel_Set(Channel_0, LampCh0_BatteryCutOff, Lamp_On);
			}
			else
			{
				if (Get_CAN_CH0_ID_18FAB027_Sig_PMS_DrivePwrCircuitInd() == 0) 
				{
					LED_Driver_Channel_Set(Channel_0, LampCh0_BatteryCutOff, Lamp_On);
				}
				else
				{
					LED_Driver_Channel_Set(Channel_0, LampCh0_BatteryCutOff, Lamp_Off);
				}
			}
		}
		else
		{
			LED_Driver_Channel_Set(Channel_0, LampCh0_BatteryCutOff, Lamp_Off);
		}
	}
}

//������ص�����
void BatteryLow_Lamp(void)
{
	if (g_u8SelfLampTimes < LED_SELF_CHECK_TIME)
	{
		LED_Driver_Channel_Set(Channel_0, LampCh0_BatteryLow_Y, Lamp_On);
		LED_Driver_Channel_Set(Channel_0, LampCh0_BatteryLow_W, Lamp_Off);
	}
	else
	{
		if(SYS_OPR_STAT_IGN_ON)
		{
			if (CAN_MSG_Status(CAN_CH0, CAN_CH0_ID_BMS_18FA42F4_Msg_Count) == CAN_MSG_LOST)
			{
				LED_Driver_Channel_Set(Channel_0, LampCh0_BatteryLow_Y, Lamp_Blink_1Hz);//��
				LED_Driver_Channel_Set(Channel_0, LampCh0_BatteryLow_W, Lamp_Off);
			}
			else
			{
				if ((Get_CAN_CH0_ID_18FA42F4_Sig_BMS_BattSOCFault() == 1))
				{
					LED_Driver_Channel_Set(Channel_0, LampCh0_BatteryLow_Y, Lamp_On);
					LED_Driver_Channel_Set(Channel_0, LampCh0_BatteryLow_W, Lamp_Off);
				}
				else
				{
					LED_Driver_Channel_Set(Channel_0, LampCh0_BatteryLow_Y, Lamp_Off);
					LED_Driver_Channel_Set(Channel_0, LampCh0_BatteryLow_W, Lamp_On);
				}
			}
		}
		else
		{
			LED_Driver_Channel_Set(Channel_0, LampCh0_BatteryLow_Y, Lamp_Off);
			LED_Driver_Channel_Set(Channel_0, LampCh0_BatteryLow_W, Lamp_Off);
		}
	}
}

//��������¶ȸ�
void BatteryTempHigh_Lamp(void)
{
	if(SYS_OPR_STAT_IGN_ON)
	{
		if (CAN_MSG_Status(CAN_CH0, CAN_CH0_ID_BMS_18FA42F4_Msg_Count) == CAN_MSG_LOST)
		{
			LED_Driver_Channel_Set(Channel_0, LampCh0_BatteryTempHigh, Lamp_On);
		}
		else
		{
			if ((Get_CAN_CH0_ID_18FA42F4_Sig_BMS_BattTempFault() == 2))
			{
				LED_Driver_Channel_Set(Channel_0, LampCh0_BatteryTempHigh, Lamp_On);
			}
			else
			{
				LED_Driver_Channel_Set(Channel_0, LampCh0_BatteryTempHigh, Lamp_Off);
			}
		}
	}
	else
	{
		LED_Driver_Channel_Set(Channel_0, LampCh0_BatteryTempHigh, Lamp_Off);	
	}
}

//��������¶ȵ�
void BatteryTempLow_Lamp(void)
{
	if(SYS_OPR_STAT_IGN_ON)
	{
		if (CAN_MSG_Status(CAN_CH0, CAN_CH0_ID_BMS_18FA42F4_Msg_Count) == CAN_MSG_LOST)
		{
			LED_Driver_Channel_Set(Channel_0, LampCh0_BatteryTempLow, Lamp_Off);
		}
		else
		{
			if ((Get_CAN_CH0_ID_18FA42F4_Sig_BMS_BattTempFault() == 1))
			{
				LED_Driver_Channel_Set(Channel_0, LampCh0_BatteryTempLow, Lamp_On);
			}
			else
			{
				LED_Driver_Channel_Set(Channel_0, LampCh0_BatteryTempLow, Lamp_Off);
			}
		}
	}
	else
	{
		LED_Driver_Channel_Set(Channel_0, LampCh0_BatteryTempLow, Lamp_Off);	
	}
}


//���״ָ̬ʾ��
void ChargeBatterySta_Lamp(void)
{
	if (g_u8SelfLampTimes < LED_SELF_CHECK_TIME)
	{
		LED_Driver_Channel_Set(Channel_0, LampCh0_ChargeBatterySta, Lamp_On);
	}
	else
	{
		if (CAN_MSG_Status(CAN_CH0, CAN_CH0_ID_BMS_18FA3EF4_Msg_Count) == CAN_MSG_LOST)
		{
			LED_Driver_Channel_Set(Channel_0, LampCh0_ChargeBatterySta, Lamp_Off);
		}
		else
		{
			if((Get_CAN_CH0_ID_18FA3EF4_Sig_BMS_ChgStatus() == 1)||(Get_CAN_CH0_ID_18FA3EF4_Sig_BMS_ChgStatus() == 4)||(Get_CAN_CH0_ID_18FA3EF4_Sig_BMS_ChgStatus() == 5))
			{
				LED_Driver_Channel_Set(Channel_0, LampCh0_ChargeBatterySta, Lamp_On);
			}
			else
			{
				LED_Driver_Channel_Set(Channel_0, LampCh0_ChargeBatterySta, Lamp_Off);
			}
		}
	}
}

// �������ָʾ��
void BatChargeConnect_Lamp(void)
{
	if (g_u8SelfLampTimes < LED_SELF_CHECK_TIME)
	{
		LED_Driver_Channel_Set(Channel_0, LampCh0_BatChargeConnect, Lamp_On);
	}
	else
	{
		if (CAN_MSG_Status(CAN_CH0, CAN_CH0_ID_BMS_18FA3EF4_Msg_Count) == CAN_MSG_LOST)
		{
			LED_Driver_Channel_Set(Channel_0, LampCh0_BatChargeConnect, Lamp_Off);
		}
		else
		{
			if((Get_CAN_CH0_ID_18FA3EF4_Sig_BMS_DCChgPlugSts() == 1))
			{
				LED_Driver_Channel_Set(Channel_0, LampCh0_BatChargeConnect, Lamp_On);
			}
			else
			{
				LED_Driver_Channel_Set(Channel_0, LampCh0_BatChargeConnect, Lamp_Off);
			}
		}
	}
}


//�޹���ָʾ��
void Limit_Power_Lamp(void)
{
	if (g_u8SelfLampTimes < LED_SELF_CHECK_TIME)
	{
		LED_Driver_Channel_Set(Channel_1, LampCh1_Limit_Power_Lamp, Lamp_On);
	}
	else
	{
		if(SYS_OPR_STAT_IGN_ON)
		{
			if(CAN_MSG_Status(CAN_CH0, CAN_CH0_ID_PMS_18FA1727_Msg_Count) == CAN_MSG_LOST)
			{
				if(CAN_MSG_Status(CAN_CH0, CAN_CH0_ID_PMS_18FAB027_Msg_Count) == CAN_MSG_LOST)
				{
					LED_Driver_Channel_Set(Channel_1, LampCh1_Limit_Power_Lamp, Lamp_Blink_1Hz);
				}
				else
				{
					if(Get_CAN_CH0_ID_18FAB027_Sig_PMS_TurtleLampReq() == 1)
					{
						LED_Driver_Channel_Set(Channel_1, LampCh1_Limit_Power_Lamp, Lamp_On);
					}
					else
					{
						LED_Driver_Channel_Set(Channel_1, LampCh1_Limit_Power_Lamp, Lamp_Off);
					}
				}
			}
			else//1727����
			{
				if(Get_CAN_CH0_ID_18FA1727_Sig_PMS_SpdLmtLevelReq() == 0)//һ��
				{
					LED_Driver_Channel_Set(Channel_1, LampCh1_Limit_Power_Lamp, Lamp_Blink_2Hz);
				}
				else//������
				{
					if(CAN_MSG_Status(CAN_CH0, CAN_CH0_ID_PMS_18FAB027_Msg_Count) == CAN_MSG_LOST)
					{
						LED_Driver_Channel_Set(Channel_1, LampCh1_Limit_Power_Lamp, Lamp_Blink_1Hz);
					}
					else
					{
						if(Get_CAN_CH0_ID_18FAB027_Sig_PMS_TurtleLampReq() == 1)
						{
							LED_Driver_Channel_Set(Channel_1, LampCh1_Limit_Power_Lamp, Lamp_On);
						}
						else
						{
							LED_Driver_Channel_Set(Channel_1, LampCh1_Limit_Power_Lamp, Lamp_Off);
						}
					}
				}
			}
		}
		else
		{
			LED_Driver_Channel_Set(Channel_1, LampCh1_Limit_Power_Lamp, Lamp_Off);
		}
	}
}

//��ѹϵͳ���ϱ�����
void System_Failt_Lamp(void)
{
	if (g_u8SelfLampTimes < LED_SELF_CHECK_TIME)
	{
		LED_Driver_Channel_Set(Channel_1, LampCh1_System_Failt_Lamp, Lamp_On);
	}
	else
	{
		if(SYS_OPR_STAT_IGN_ON)
		{
			if (CAN_MSG_Status(CAN_CH0, CAN_CH0_ID_PMS_18FAB027_Msg_Count) == CAN_MSG_LOST)
			{
				LED_Driver_Channel_Set(Channel_1, LampCh1_System_Failt_Lamp, Lamp_On);
			}
			else
			{
				if(Get_CAN_CH0_ID_18FAB027_Sig_PMS_PTHVSysErrorLampStsInd() == 1)
				{
					LED_Driver_Channel_Set(Channel_1, LampCh1_System_Failt_Lamp, Lamp_On);
				}
				else
				{
					LED_Driver_Channel_Set(Channel_1, LampCh1_System_Failt_Lamp, Lamp_Off);
				}
			}
		}
		else
		{
			LED_Driver_Channel_Set(Channel_1, LampCh1_System_Failt_Lamp, Lamp_Off);
		}
	}
}

//  ��Ե����ָʾ��
void Insulation_Fault_Lamp(void)
{
	if (g_u8SelfLampTimes < LED_SELF_CHECK_TIME)
	{
		LED_Driver_Channel_Set(Channel_1, LampCh1_Insulation_Fault, Lamp_On);
	}
	else
	{
		if(SYS_OPR_STAT_IGN_ON)
		{
			if (CAN_MSG_Status(CAN_CH0, CAN_CH0_ID_BMS_18FA41F4_Msg_Count) == CAN_MSG_LOST)
			{
				LED_Driver_Channel_Set(Channel_1, LampCh1_Insulation_Fault, Lamp_On);
			}
			else
			{
				if((Get_CAN_CH0_ID_18FA41F4_Sig_BMS_HVIsolationSts() == 1)||(Get_CAN_CH0_ID_18FA41F4_Sig_BMS_HVIsolationSts() == 2))
				{
					LED_Driver_Channel_Set(Channel_1, LampCh1_Insulation_Fault, Lamp_On);
				}
				else
				{
					LED_Driver_Channel_Set(Channel_1, LampCh1_Insulation_Fault, Lamp_Off);
				}
			}
		}
		else
		{
			LED_Driver_Channel_Set(Channel_1, LampCh1_Insulation_Fault, Lamp_Off);
		}
	}
}


void SafeBelt_Lamp(void)
{
	if (g_u8SelfLampTimes < LED_SELF_CHECK_TIME)
	{
		LED_Driver_Channel_Set(Channel_0, LampCh0_DriverSafeBelt, Lamp_On);
	}
	else
	{
		if (SYS_OPR_STAT_IGN_ON)
		{
			if(g_stSafeBelt.u8Lamp_Warn == 1)
			{
				LED_Driver_Channel_Set(Channel_0, LampCh0_DriverSafeBelt, Lamp_On);
			}
			else  if(g_stSafeBelt.u8Lamp_Warn == 2 )
			{
				LED_Driver_Channel_Set(Channel_0, LampCh0_DriverSafeBelt, Lamp_Blink_1Hz);
			}
			else
			{
				LED_Driver_Channel_Set(Channel_0, LampCh0_DriverSafeBelt, Lamp_Off);	
			}	
		}
		else
		{
			LED_Driver_Channel_Set(Channel_0, LampCh0_DriverSafeBelt, Lamp_Off);
		}
	}
}

uint8_t Get_Airbag_Fault = 0;
void Get_Airbag_Fault_Service(void)
{
	if(((LED_Driver_Channel_Fault_Get(0, 4, 0) & 0x04) == 0)&&((LED_Driver_Channel_Fault_Get(0, 4, 1) & 0x04) == 0))
	{
	    Get_Airbag_Fault = 0;
	}
	else
	{
	    Get_Airbag_Fault = 1;
	}
}

//Airbag_Lamp
void Airbag_Lamp(void)
{
	if((Val_EOL_F110_ACU() == 1)&&(Val_EOL_F101_CollisionSystem()==2))
	{
		if (g_u8SelfLampTimes < LED_SELF_CHECK_TIME)
		{
			LED_Driver_Channel_Set(Channel_0, LampCh0_AirBag, Lamp_On);
			Acu_Led = 1;
		}
		else
		{
			if(SYS_OPR_STAT_IGN_ON)
			{
				if(Airbag_LampTimes < 80)
				{
					Airbag_LampTimes++;
					LED_Driver_Channel_Set(Channel_0, LampCh0_AirBag, Lamp_Off);
					Acu_Led = 0;
				}
				else
				{
					if (CAN_MSG_Status(CAN_CH0, CAN_CH0_ID_ACU_18FAC490_Msg_Count) == CAN_MSG_LOST)
					{
						LED_Driver_Channel_Set(Channel_0, LampCh0_AirBag, Lamp_On);
						Acu_Led = 1;
					}
					else
					{
						if((Get_CAN_CH0_ID_18FAC490_Sig_ACU_AirbagWarningStatus() == 1))
						{
							LED_Driver_Channel_Set(Channel_0, LampCh0_AirBag, Lamp_On);
							Acu_Led = 1;
						}
						else if((Get_CAN_CH0_ID_18FAC490_Sig_ACU_AirbagWarningStatus() == 2))
						{
							LED_Driver_Channel_Set(Channel_0, LampCh0_AirBag, Lamp_Blink_1Hz);
							Acu_Led = 2;
						}
						else
						{
							LED_Driver_Channel_Set(Channel_0, LampCh0_AirBag, Lamp_Off);
							Acu_Led = 0;
						}
					}
				}
				
				if(Acu_Led_Old != Get_CAN_CH0_ID_18FAC490_Sig_ACU_AirbagWarningStatus())
				{
					if(Get_CAN_CH0_ID_18FAC490_Sig_ACU_AirbagWarningStatus() == 1)
					{
						LED_Driver_Scan_Refresh();
            			LED_Driver_Service_Immediate();
            			LED_Driver_Work_Check();
            			LED_Driver_Service_Immediate();
						Get_Airbag_Fault_Service();
					}
				}
				Acu_Led_Old = Get_CAN_CH0_ID_18FAC490_Sig_ACU_AirbagWarningStatus();
			}
			else
			{
				LED_Driver_Channel_Set(Channel_0, LampCh0_AirBag, Lamp_Off);
				Acu_Led = 0;
			}
		}
	}
	else
	{
		LED_Driver_Channel_Set(Channel_0, LampCh0_AirBag, Lamp_Off);
		Acu_Led = 0;
	}
}

//ACU_Lamp
void ACU_Lamp(void)
{
	if((Val_EOL_F110_ACU() == 1)&&(Val_EOL_F101_CollisionSystem()==1))
	{
		if(SYS_OPR_STAT_IGN_ON)
		{
			if(ACU_LampTimes < 140)
			{
				ACU_LampTimes++;
				LED_Driver_Channel_Set(Channel_1, LampCh1_ACU, Lamp_Off);
			}
			else
			{
				if (CAN_MSG_Status(CAN_CH0, CAN_CH0_ID_ACU_18FAC490_Msg_Count) == CAN_MSG_LOST)
				{
					LED_Driver_Channel_Set(Channel_1, LampCh1_ACU, Lamp_On);
				}
				else
				{
					if((Get_CAN_CH0_ID_18FAC490_Sig_ACU_AirbagWarningStatus() == 1))
					{
						LED_Driver_Channel_Set(Channel_1, LampCh1_ACU, Lamp_On);
					}
					else if((Get_CAN_CH0_ID_18FAC490_Sig_ACU_AirbagWarningStatus() == 2))
					{
						LED_Driver_Channel_Set(Channel_1, LampCh1_ACU, Lamp_Blink_1Hz);
					}
					else
					{
						LED_Driver_Channel_Set(Channel_1, LampCh1_ACU, Lamp_Off);
					}
				}
			}
		}
		else
		{
			LED_Driver_Channel_Set(Channel_1, LampCh1_ACU, Lamp_Off);
		}
	}
	else
	{
		LED_Driver_Channel_Set(Channel_1, LampCh1_ACU, Lamp_Off);
	}
}

//̥ѹϵͳ���ϵ�
void TPMS_Lamp(void)
{
	if(Val_EOL_F110_TPMS() == 1)
	{
		if (SYS_OPR_STAT_IGN_ON)
		{
			if (g_u8SelfLampTimes < LED_SELF_CHECK_TIME) //g_stTyrePress
			{
				Trye_Lamp.StmFlt_timer1 = 0;
				Trye_Lamp.StmFlt_timer3 = 0;
				Trye_Lamp.StmFlt_timerlost = 0;
				LED_Driver_Channel_Set(Channel_0, LampCh0_TPMS, Lamp_On);
			}
			else
			{
				if (CAN_MSG_Status(CAN_CH0, CAN_CH0_ID_TPMS_TireInfor_Msg_Count) == CAN_MSG_LOST)
				{
					Trye_Lamp.StmFlt_timer1 = 0;
					Trye_Lamp.StmFlt_timer3 = 0;
					if (Trye_Lamp.StmFlt_timerlost <= 1200)
					{
						Trye_Lamp.StmFlt_timerlost++;
						LED_Driver_Channel_Set(Channel_0, LampCh0_TPMS, Lamp_Blink_1Hz);
					}
					else
					{
						if (Lamp_Blink_1Hz)
						{
							LED_Driver_Channel_Set(Channel_0, LampCh0_TPMS, Lamp_On);
						}
					}
				}
				else
				{
					if (Get_CAN_CH0_ID_18FFE033_Sig_TPMS_SystemFault() == 0X01)
					{
						Trye_Lamp.StmFlt_timer3 = 0;
						Trye_Lamp.StmFlt_timerlost = 0;

						if (Trye_Lamp.StmFlt_timer1 <= 1200)
						{
							Trye_Lamp.StmFlt_timer1++;
							LED_Driver_Channel_Set(Channel_0, LampCh0_TPMS, Lamp_Blink_1Hz);
						}
						else
						{
							if (Lamp_Blink_1Hz)
							{
								LED_Driver_Channel_Set(Channel_0, LampCh0_TPMS, Lamp_On);
							}
						}
					}
					else if (Get_CAN_CH0_ID_18FFE033_Sig_TPMS_SystemFault() == 0X02)
					{
						Trye_Lamp.StmFlt_timer1 = 0;
						Trye_Lamp.StmFlt_timer3 = 0;
						Trye_Lamp.StmFlt_timerlost = 0;
						if (Lamp_Blink_1Hz)
						{
							LED_Driver_Channel_Set(Channel_0, LampCh0_TPMS, Lamp_On);
						}
					}
					else if (Get_CAN_CH0_ID_18FFE033_Sig_TPMS_SystemFault() == 0X03)
					{
						Trye_Lamp.StmFlt_timer1 = 0;
						Trye_Lamp.StmFlt_timerlost = 0;
						if (Trye_Lamp.StmFlt_timer3 <= 1200)
						{
							Trye_Lamp.StmFlt_timer3++;
							LED_Driver_Channel_Set(Channel_0, LampCh0_TPMS, Lamp_Blink_1Hz);
						}
						else
						{
							if (Lamp_Blink_1Hz)
							{
								LED_Driver_Channel_Set(Channel_0, LampCh0_TPMS, Lamp_On);
							}
						}
					}
					else
					{
						LED_Driver_Channel_Set(Channel_0, LampCh0_TPMS, Lamp_Off);
						Trye_Lamp.StmFlt_timer1 = 0;
						Trye_Lamp.StmFlt_timer3 = 0;
						Trye_Lamp.StmFlt_timerlost = 0;
					}
				}
			}
		}
		else
		{
			Trye_Lamp.StmFlt_timer1 = 0;
			Trye_Lamp.StmFlt_timer3 = 0;
			Trye_Lamp.StmFlt_timerlost = 0;
			LED_Driver_Channel_Set(Channel_0, LampCh0_TPMS, Lamp_Off);
		}
	}
	else
	{
		Trye_Lamp.StmFlt_timer1 = 0;
		Trye_Lamp.StmFlt_timer3 = 0;
		Trye_Lamp.StmFlt_timerlost = 0;
		LED_Driver_Channel_Set(Channel_0, LampCh0_TPMS, Lamp_Off);
	}
}

//����δ��ָʾ��
void DoorOpen_Lamp(void)
{
	if (CAN_MSG_Status(CAN_CH0, CAN_CH0_ID_BCM_DoorControl2_Msg_Count) == CAN_MSG_LOST)
	{
		LED_Driver_Channel_Set(Channel_0, LampCh0_Door_NotClosed, Lamp_On);
	}
	else
	{
	    if(SYS_OPR_STAT_IGN_ON)
	    {
	        if (((Get_CAN_CH0_ID_18FDA521_Sig_BCM_FrontLeftDoorAjarStatus() == 1)) ||
			    ((Get_CAN_CH0_ID_18FDA521_Sig_BCM_FrontRightDoorAjarStatus() == 1))|| 
				((Get_CAN_CH0_ID_18FDA521_Sig_BCM_RearLeftDoorAjarStatus() == 1))  || 
				((Get_CAN_CH0_ID_18FDA521_Sig_BCM_RearRightDoorAjarStatus() == 1)))
			{
				LED_Driver_Channel_Set(Channel_0, LampCh0_Door_NotClosed, Lamp_On);
			}
			else
			{
				LED_Driver_Channel_Set(Channel_0, LampCh0_Door_NotClosed, Lamp_Off);
			}
	    }
	    else 
	    {
	        if((DoorOpen.u16OffTimer < 300 ) && 
			  (((Get_CAN_CH0_ID_18FDA521_Sig_BCM_FrontLeftDoorAjarStatus() == 1)) ||
			   ((Get_CAN_CH0_ID_18FDA521_Sig_BCM_FrontRightDoorAjarStatus() == 1))|| 
			   ((Get_CAN_CH0_ID_18FDA521_Sig_BCM_RearLeftDoorAjarStatus() == 1))  || 
			   ((Get_CAN_CH0_ID_18FDA521_Sig_BCM_RearRightDoorAjarStatus() == 1))))
	        {
	        	LED_Driver_Channel_Set(Channel_0, LampCh0_Door_NotClosed, Lamp_On);	
	        }
	        else
	        {
	        	LED_Driver_Channel_Set(Channel_0, LampCh0_Door_NotClosed, Lamp_Off);		
	        }
	    }
	}
}

//ά�ޱ�����
void Maint_Lamp(void)
{
	if(Val_EOL_F101_ServiceMaintain() == 2)
	{
		if (g_u8SelfLampTimes < LED_SELF_CHECK_TIME)
		{
			LED_Driver_Channel_Set(Channel_1, LampCh1_Maint, Lamp_On);	
		}
		else
		{
			if (SYS_OPR_STAT_IGN_ON)
			{
				if( (DataServiceWarning == 1) )
				{
					LED_Driver_Channel_Set(Channel_1, LampCh1_Maint, Lamp_On);
				}
				else
				{
					LED_Driver_Channel_Set(Channel_1, LampCh1_Maint, Lamp_Off);
				}
			}
			else
			{
				LED_Driver_Channel_Set(Channel_1, LampCh1_Maint, Lamp_Off);
			}
		}
	}
	else
	{
		if((Val_EOL_F110_EMS() == 1)&&(Val_EOL_F101_ServiceMaintain() == 2))
		{
			if (g_u8SelfLampTimes < LED_SELF_CHECK_TIME)
			{
				LED_Driver_Channel_Set(Channel_1, LampCh1_Maint, Lamp_On);	
			}
			else
			{
				if (SYS_OPR_STAT_IGN_ON)
				{
					//if()
					//{
					//	LED_Driver_Channel_Set(Channel_1, LampCh1_Maint, Lamp_On);
					//}
					//else
					//{
					//	LED_Driver_Channel_Set(Channel_1, LampCh1_Maint, Lamp_Off);
					//}
				}
				else
				{
					LED_Driver_Channel_Set(Channel_1, LampCh1_Maint, Lamp_Off);
				}
			}
		}
		else
		{
			LED_Driver_Channel_Set(Channel_1, LampCh1_Maint, Lamp_Off);
		}
	}
}




//Զ������ָʾ��
void Rmtlock_Lamp(void)
{
	if (g_u8SelfLampTimes < LED_SELF_CHECK_TIME)
	{
		LED_Driver_Channel_Set(Channel_0, LampCh0_Rmtlock, Lamp_On);
	}
	else
	{
		if(SYS_OPR_STAT_IGN_ON)
		{
			if (CAN_MSG_Status(CAN_CH0, CAN_CH0_ID_PMS_18FF5D27_Msg_Count) == CAN_MSG_LOST)
			{
				LED_Driver_Channel_Set(Channel_0, LampCh0_Rmtlock, Lamp_Off);
			}
			else
			{
				if((Get_CAN_CH0_ID_18FF5D27_Sig_PMS_LockVehSts() == 1))
				{
					LED_Driver_Channel_Set(Channel_0, LampCh0_Rmtlock, Lamp_On);
				}
				else
				{
					LED_Driver_Channel_Set(Channel_0, LampCh0_Rmtlock, Lamp_Off);
				}
			}
		}
		else
		{
			LED_Driver_Channel_Set(Channel_0, LampCh0_Rmtlock, Lamp_Off);
		}
	}
}

//��ʻ��δ��ָʾ��
void DriverNotClosed_Lamp(void)
{
	if (g_u8SelfLampTimes < LED_SELF_CHECK_TIME)
	{
		LED_Driver_Channel_Set(Channel_0, LampCh0_DriverNotClosed, Lamp_On);
	}
	else
	{
		if (Line_In_Get_Status(LINE_IN_CabLock))
		{
			LED_Driver_Channel_Set(Channel_0, LampCh0_DriverNotClosed, Lamp_On);
		}
		else
		{
			LED_Driver_Channel_Set(Channel_0, LampCh0_DriverNotClosed, Lamp_Off);
		}
	}
}


//AVAS����ָʾ��
void AVAS_Lamp(void)//����
{
	if(Val_EOL_F110_AVAS() == 1)
	{
		if (g_u8SelfLampTimes < LED_SELF_CHECK_TIME)
		{
			LED_Driver_Channel_Set(Channel_0, LampCh0_AVAS, Lamp_On);
		}
		else
		{
			if(SYS_OPR_STAT_IGN_ON)
			{
				if (CAN_MSG_Status(CAN_CH0, CAN_CH0_ID_AVAS_18FFC095_Msg_Count) == CAN_MSG_LOST)
				{
					LED_Driver_Channel_Set(Channel_0, LampCh0_AVAS, Lamp_Off);
				}
				else
				{
					if((Get_CAN_CH0_ID_18FFC095_Sig_AVAS_AVASDisabledSts() == 1))
					{
						LED_Driver_Channel_Set(Channel_0, LampCh0_AVAS, Lamp_On);
					}
					else
					{
						LED_Driver_Channel_Set(Channel_0, LampCh0_AVAS, Lamp_Off);
					}
				}
			}
			else
			{
				LED_Driver_Channel_Set(Channel_0, LampCh0_AVAS, Lamp_Off);
			}
		}
	}
	else
	{
		LED_Driver_Channel_Set(Channel_0, LampCh0_AVAS, Lamp_Off);
	}
}

void Tired_Sys_Fault_Lamp(void)
{
	if(Val_EOL_F110_DMM() == 1)
	{
		if(SYS_OPR_STAT_IGN_ON)
		{
			if (CAN_MSG_Status(CAN_CH0, CAN_CH0_ID_DMM_StsInfor_Msg_Count) == CAN_MSG_LOST)
			{
				LED_Driver_Channel_Set(Channel_1, LampCh1_Tired_Sys_Closed, Lamp_On);
			}
			else
			{
				if(Get_CAN_CH0_ID_18FAD084_Sig_DMM_SystemFault() == 1)
				{
					LED_Driver_Channel_Set(Channel_1, LampCh1_Tired_Sys_Closed, Lamp_On);
				}
				else
				{
					LED_Driver_Channel_Set(Channel_1, LampCh1_Tired_Sys_Closed, Lamp_Off);
				}
			}
		}
		else
		{
			LED_Driver_Channel_Set(Channel_1, LampCh1_Tired_Sys_Closed, Lamp_Off);
		}
	}
	else
	{
		LED_Driver_Channel_Set(Channel_1, LampCh1_Tired_Sys_Closed, Lamp_Off);
	}
}

#if 1 //without can
//��ƣ��ϵͳ�ر�ָʾ��
void Tired_Sys_Closed_Lamp(void)//����
{
	if(Val_EOL_F110_DMM() == 1)
	{
		if(SYS_OPR_STAT_IGN_ON)
		{
			if (CAN_MSG_Status(CAN_CH0, CAN_CH0_ID_DMM_StsInfor_Msg_Count) == CAN_MSG_LOST)
			{
				LED_Driver_Channel_Set(Channel_1, LampCh1_Tired_Sys_Closed, Lamp_Off);
			}
			else
			{
				if(Get_CAN_CH0_ID_18FAD084_Sig_DMM_WorkSts() == 0)
				{
					LED_Driver_Channel_Set(Channel_1, LampCh1_Tired_Sys_Closed, Lamp_On);
				}
				else
				{
					LED_Driver_Channel_Set(Channel_1, LampCh1_Tired_Sys_Closed, Lamp_Off);
				}
			}
		}
		else
		{
			LED_Driver_Channel_Set(Channel_1, LampCh1_Tired_Sys_Closed, Lamp_Off);
		}
	}
	else
	{
		LED_Driver_Channel_Set(Channel_1, LampCh1_Tired_Sys_Closed, Lamp_Off);
	}
}
#endif

//�ƶ�Һλ�ͱ�����
void Brake_Fluid_Low_Lamp(void)//����
{
	if ((Val_EOL_F101_Break() == 1))//Һɲ
	{
		if (g_u8SelfLampTimes < LED_SELF_CHECK_TIME)
		{
			LED_Driver_Channel_Set(Channel_0, LampCh0_Brake_Fluid_Low, Lamp_On);
		}
		else
		{
			if(SYS_OPR_STAT_IGN_ON)
			{
				if (Line_In_Get_Status(LINE_IN_BrakeLiquid))
				{
					LED_Driver_Channel_Set(Channel_0, LampCh0_Brake_Fluid_Low, Lamp_On);
				}
				else
				{
					LED_Driver_Channel_Set(Channel_0, LampCh0_Brake_Fluid_Low, Lamp_Off);
				}
			}
			else
			{
				LED_Driver_Channel_Set(Channel_0, LampCh0_Brake_Fluid_Low, Lamp_Off);
			}
		}
	}
	else
	{
		LED_Driver_Channel_Set(Channel_0, LampCh0_Brake_Fluid_Low, Lamp_Off);
	}
	
}

//EPB���ϱ�����
void EPB_Lamp(void)//����
{
	if (Val_EOL_F110_EPB_Air() == 1)
	{
		if (g_u8SelfLampTimes < LED_SELF_CHECK_TIME)
		{
			LED_Driver_Channel_Set(Channel_0, LampCh0_EPB, Lamp_On);
		}
		else
		{
			if (SYS_OPR_STAT_IGN_ON)
			{
				if (CAN_MSG_Status(CAN_CH0, CAN_CH0_ID_EPB_StsInfor_Msg_Count) == CAN_MSG_LOST)
				{
					LED_Driver_Channel_Set(Channel_0, LampCh0_EPB, Lamp_On);
				}
				else
				{
					if ((Get_CAN_CH0_ID_18FFB88F_Sig_EPB_FltLevel() == 1) || (Get_CAN_CH0_ID_18FFB88F_Sig_EPB_FltLevel() == 2) || (Get_CAN_CH0_ID_18FFB88F_Sig_EPB_FltLevel() == 3))
					{
						LED_Driver_Channel_Set(Channel_0, LampCh0_EPB, Lamp_On);
					}
					else
					{
						LED_Driver_Channel_Set(Channel_0, LampCh0_EPB, Lamp_Off);
					}
				}
			}
			else
			{
				LED_Driver_Channel_Set(Channel_0, LampCh0_EPB, Lamp_Off);
			}
		}
	}
	else 
	{	
		if (Val_EOL_F110_EPB_Liquid() == 1)
		{
			if (g_u8SelfLampTimes < LED_SELF_CHECK_TIME)
			{
				LED_Driver_Channel_Set(Channel_0, LampCh0_EPB, Lamp_On);
			}
			else
			{
				if (SYS_OPR_STAT_IGN_ON)
				{
					#if 1 //without can
					if (CAN_MSG_Status(CAN_CH0, CAN_CH0_ID_EPB_0CFABF8F_Msg_Count) == CAN_MSG_LOST)
					{
						LED_Driver_Channel_Set(Channel_0, LampCh0_EPB, Lamp_On);
					}
					else
					{
						if ((Get_CAN_CH0_ID_0CFABF8F_Sig_EPB_WarningLampState() == 1))
						{
							LED_Driver_Channel_Set(Channel_0, LampCh0_EPB, Lamp_On);
						}
						else
						{
							LED_Driver_Channel_Set(Channel_0, LampCh0_EPB, Lamp_Off);
						}
					}
					#endif
				}
				else
				{
					LED_Driver_Channel_Set(Channel_0, LampCh0_EPB, Lamp_Off);
				}
			}
		}
		else 
		{	
			LED_Driver_Channel_Set(Channel_0, LampCh0_EPB, Lamp_Off);
		}
	}
}

//EPS���ϱ�����
void EPS_Lamp(void)//����
{
	if (Val_EOL_F110_EPS() == 1)
	{
		if (g_u8SelfLampTimes < LED_SELF_CHECK_TIME)
		{
			LED_Driver_Channel_Set(Channel_1, LampCh1_EPS, Lamp_On);
		}
		else
		{
			if (SYS_OPR_STAT_IGN_ON)
			{
				if (CAN_MSG_Status(CAN_CH0, CAN_CH0_ID_EPS_0CFABA13_Msg_Count) == CAN_MSG_LOST)
				{
					LED_Driver_Channel_Set(Channel_1, LampCh1_EPS, Lamp_Off);
				}
				else
				{
					if ((Get_CAN_CH0_ID_0CFABA13_Sig_EPS_WarningLamp() == 1))
					{
						LED_Driver_Channel_Set(Channel_1, LampCh1_EPS, Lamp_On);
					}
					else if ((Get_CAN_CH0_ID_0CFABA13_Sig_EPS_WarningLamp() == 2))
					{
						LED_Driver_Channel_Set(Channel_1, LampCh1_EPS, Lamp_Blink_1Hz);
					}
					else
					{
						LED_Driver_Channel_Set(Channel_1, LampCh1_EPS, Lamp_Off);
					}
				}
			}
			else
			{
				LED_Driver_Channel_Set(Channel_1, LampCh1_EPS, Lamp_Off);
			}
		}
	}
	else
	{
		LED_Driver_Channel_Set(Channel_1, LampCh1_EPS, Lamp_Off);
	}
}


//ESC����/���ϵ�
void ESC_Active_Lamp(void)//����
{
	if ((Val_EOL_F110_ESC_W() == 1)&&(Val_EOL_F110_EPB_Air() == 1))
	{
		if (g_u8SelfLampTimes < LED_SELF_CHECK_TIME)
		{
			LED_Driver_Channel_Set(Channel_1, LampCh1_ESC_Active, Lamp_On);
		}
		else
		{
			if (SYS_OPR_STAT_IGN_ON)
			{
				#if 1//without can
				if (CAN_MSG_Status(CAN_CH0, CAN_CH0_ID_ESC_18FE4F0B_Msg_Count) == CAN_MSG_LOST)
				{
					LED_Driver_Channel_Set(Channel_1, LampCh1_ESC_Active, Lamp_On);
				}
				else
				{
					if ((Get_CAN_CH0_ID_18FE4F0B_Sig_ESC_VDCInformationSignal() == 1)&&(Get_CAN_CH0_ID_18FE4F0B_Sig_ESC_VDCFullyOperational() == 0))
					{
						LED_Driver_Channel_Set(Channel_1, LampCh1_ESC_Active, Lamp_On);
					}
					else if ((Get_CAN_CH0_ID_18FE4F0B_Sig_ESC_VDCInformationSignal() == 1)&&(Get_CAN_CH0_ID_18FE4F0B_Sig_ESC_VDCFullyOperational() == 1))
					{
						LED_Driver_Channel_Set(Channel_1, LampCh1_ESC_Active, Lamp_Blink_2Hz);
					}
					else
					{
						LED_Driver_Channel_Set(Channel_1, LampCh1_ESC_Active, Lamp_Off);
					}
				}
				#endif
			}
			else
			{
				LED_Driver_Channel_Set(Channel_1, LampCh1_ESC_Active, Lamp_Off);
			}
		}
	}

	if ((Val_EOL_F110_ESC_W() == 1)&&(Val_EOL_F110_EPB_Liquid() == 1))
	{
		LED_Driver_Channel_Set(Channel_1, LampCh1_ESC_Active, Lamp_Off);
	}
	
}


//ESC OFF
void ESC_OFF_Lamp(void)//����
{
	if ((Val_EOL_F110_ESC_W() == 1)&&(Val_EOL_F101_BrakeSupplier() == 1))
	{
		if (g_u8SelfLampTimes < LED_SELF_CHECK_TIME)
		{
			LED_Driver_Channel_Set(Channel_1, LampCh1_ESC_Off, Lamp_On);
		}
		else
		{
			if (SYS_OPR_STAT_IGN_ON)
			{
				if (CAN_MSG_Status(CAN_CH0, CAN_CH0_ID_ABS_EBS_EBC1_Msg_Count) == CAN_MSG_LOST)
				{
					LED_Driver_Channel_Set(Channel_1, LampCh1_ESC_Off, Lamp_Off);
				}
				else
				{
					if ((Get_CAN_CH0_ID_18F0010B_Sig_EBS_TractionControlOverrideSwitch() == 1))
					{
						LED_Driver_Channel_Set(Channel_1, LampCh1_ESC_Off, Lamp_On);
					}
					else
					{
						LED_Driver_Channel_Set(Channel_1, LampCh1_ESC_Off, Lamp_Off);
					}
				}
			}
			else
			{
				LED_Driver_Channel_Set(Channel_1, LampCh1_ESC_Off, Lamp_Off);
			}
		}
	}
	else
	{
		LED_Driver_Channel_Set(Channel_1, LampCh1_ESC_Off, Lamp_Off);
	}
	
}

//EBS
void EBS_Lamp(void)
{
	if (Val_EOL_F110_EBS() == 1)
	{
		if (g_u8SelfLampTimes < LED_SELF_CHECK_TIME)
		{
			LED_Driver_Channel_Set(Channel_0, LampCh0_EBS, Lamp_On);
		}
		else
		{
			if (SYS_OPR_STAT_IGN_ON)
			{
				if (CAN_MSG_Status(CAN_CH0, CAN_CH0_ID_ABS_EBS_EBC1_Msg_Count) == CAN_MSG_LOST)
				{
					LED_Driver_Channel_Set(Channel_0, LampCh0_EBS, Lamp_On);
				}
				else
				{
					if (Get_CAN_CH0_ID_18F0010B_Sig_EBS_EBSRedWarningState() == 1)
					{
						LED_Driver_Channel_Set(Channel_0, LampCh0_EBS, Lamp_On);
					}
					else
					{
						LED_Driver_Channel_Set(Channel_0, LampCh0_EBS, Lamp_Off);
					}
				}
			}
			else
			{
				LED_Driver_Channel_Set(Channel_0, LampCh0_EBS, Lamp_Off);
			}
		}
	}
	else
	{
		LED_Driver_Channel_Set(Channel_0, LampCh0_EBS, Lamp_Off);
	}
}

//EHPS������
void EHPS_Lamp(void)
{
	if (SYS_OPR_STAT_IGN_ON)
	{
		if (CAN_MSG_Status(CAN_CH0, CAN_CH0_ID_PMS_CFAB127_Msg_Count) == CAN_MSG_LOST)
		{
			LED_Driver_Channel_Set(Channel_1, LampCh1_EHPS, Lamp_Off);
		}
		else
		{
			if ((Get_CAN_CH0_ID_0CFAB127_Sig_PMS_SDCACStopFault() == 1))
			{
				LED_Driver_Channel_Set(Channel_1, LampCh1_EHPS, Lamp_On);
			}
			else
			{
				LED_Driver_Channel_Set(Channel_1, LampCh1_EHPS, Lamp_Off);
			}
		}
	}
	else
	{
		LED_Driver_Channel_Set(Channel_1, LampCh1_EHPS, Lamp_Off);
	}
}

//CC������������ָʾ��
void CC_Cruise_Control_Lamp(void)//����
{
	if ((Val_EOL_F101_Cruise() == 2)/*&&(Val_EOL_F101_CruiseSpeed() == 1)*/)
	{
		if (SYS_OPR_STAT_IGN_ON)
		{
			if (CAN_MSG_Status(CAN_CH0, CAN_CH0_ID_PMS_0CFAA627_Msg_Count) == CAN_MSG_LOST)
			{
				LED_Driver_Channel_Set(Channel_1, LampCh1_CC_Cruise_Control, Lamp_Off);
			}
			else
			{
				if(Get_CAN_CH0_ID_0CFAA627_Sig_PMS_ControlSetSpeed() > 0)
				{
					if ((Get_CAN_CH0_ID_0CFAA627_Sig_PMS_CruiseControlSts()  == 2))
					{
						LED_Driver_Channel_Set(Channel_1, LampCh1_CC_Cruise_Control, Lamp_On);
					}
					else
					{
						LED_Driver_Channel_Set(Channel_1, LampCh1_CC_Cruise_Control, Lamp_Off);
					}
				}
				else
				{
					LED_Driver_Channel_Set(Channel_1, LampCh1_CC_Cruise_Control, Lamp_Off);
				}
			}
		}
		else
		{
			LED_Driver_Channel_Set(Channel_1, LampCh1_CC_Cruise_Control, Lamp_Off);
		}
	}
	else
	{
		LED_Driver_Channel_Set(Channel_1, LampCh1_CC_Cruise_Control, Lamp_Off);
	}
}


//CC Override 
void CC_Overtake_Lamp(void)//����
{
	if ((Val_EOL_F101_Cruise() == 2)/*&&(Val_EOL_F101_CruiseSpeed() == 1)*/)
	{
		if (SYS_OPR_STAT_IGN_ON)
		{
			if (CAN_MSG_Status(CAN_CH0, CAN_CH0_ID_PMS_0CFAA627_Msg_Count) == CAN_MSG_LOST)
			{
				LED_Driver_Channel_Set(Channel_1, LampCh1_CC_Overtake, Lamp_Off);
			}
			else
			{
				if(Get_CAN_CH0_ID_0CFAA627_Sig_PMS_ControlSetSpeed() > 0)
				{
					if ((Get_CAN_CH0_ID_0CFAA627_Sig_PMS_CruiseControlSts()  == 3))
					{
						LED_Driver_Channel_Set(Channel_1, LampCh1_CC_Overtake, Lamp_On);
					}
					else
					{
						LED_Driver_Channel_Set(Channel_1, LampCh1_CC_Overtake, Lamp_Off);
					}
				}
				else
				{
					LED_Driver_Channel_Set(Channel_1, LampCh1_CC_Overtake, Lamp_Off);
				}
			}
		}
		else
		{
			LED_Driver_Channel_Set(Channel_1, LampCh1_CC_Overtake, Lamp_Off);
		}
	}
	else
	{
		LED_Driver_Channel_Set(Channel_1, LampCh1_CC_Overtake, Lamp_Off);
	}
	
}

//TBOX����״̬
void Vehicle_Online_Sta_Lamp(void)//����
{
	if (Val_EOL_F101_TBOX() == 1)
	{
		if (g_u8SelfLampTimes < LED_SELF_CHECK_TIME)
		{
			LED_Driver_Channel_Set(Channel_1, LampCh1_Vehicle_Online_G, Lamp_On);
			if (CAN_MSG_Status(CAN_CH0, CAN_CH0_ID_TBOX_HeartBeatMsg_Msg_Count) == CAN_MSG_LOST)
			{
				LED_Driver_Channel_Set(Channel_1, LampCh1_Vehicle_Online_Sta, Lamp_On);
			}
			else
			{
				if ((Get_CAN_CH0_ID_18FF789F_Sig_TBOX_LineDiscntSts() == 0))
				{
					LED_Driver_Channel_Set(Channel_1, LampCh1_Vehicle_Online_Sta, Lamp_On);
				}
			}
		}
		else
		{
			if (SYS_OPR_STAT_IGN_ON)
			{
				if (CAN_MSG_Status(CAN_CH0, CAN_CH0_ID_TBOX_HeartBeatMsg_Msg_Count) == CAN_MSG_LOST)
				{
					LED_Driver_Channel_Set(Channel_1, LampCh1_Vehicle_Online_Sta, Lamp_On);
					LED_Driver_Channel_Set(Channel_1, LampCh1_Vehicle_Online_G, Lamp_Off);
				}
				else
				{
					if ((Get_CAN_CH0_ID_18FF789F_Sig_TBOX_LineDiscntSts() == 1))
					{
						LED_Driver_Channel_Set(Channel_1, LampCh1_Vehicle_Online_G, Lamp_On);
						LED_Driver_Channel_Set(Channel_1, LampCh1_Vehicle_Online_Sta, Lamp_Off);
					}
					else if ((Get_CAN_CH0_ID_18FF789F_Sig_TBOX_LineDiscntSts() == 0))
					{
						LED_Driver_Channel_Set(Channel_1, LampCh1_Vehicle_Online_G, Lamp_Off);
						LED_Driver_Channel_Set(Channel_1, LampCh1_Vehicle_Online_Sta, Lamp_On);
					}
					else
					{
						LED_Driver_Channel_Set(Channel_1, LampCh1_Vehicle_Online_G, Lamp_Off);
						LED_Driver_Channel_Set(Channel_1, LampCh1_Vehicle_Online_Sta, Lamp_Off);
					}
				}
			}
			else
			{
				LED_Driver_Channel_Set(Channel_1, LampCh1_Vehicle_Online_G, Lamp_Off);
				LED_Driver_Channel_Set(Channel_1, LampCh1_Vehicle_Online_Sta, Lamp_Off);
			}
		}
	}
	else
	{
		LED_Driver_Channel_Set(Channel_1, LampCh1_Vehicle_Online_G, Lamp_Off);
		LED_Driver_Channel_Set(Channel_1, LampCh1_Vehicle_Online_Sta, Lamp_Off);
	}
}

void Oil_Low_Warning_Lamp(void)
{
	if((Val_EOL_F101_ConfigType() == 1)||(Val_EOL_F101_ConfigType() == 3)||(Val_EOL_F101_ConfigType() == 4)||(Val_EOL_F101_ConfigType() == 6))
	{
		if (SYS_OPR_STAT_IGN_ON)
		{
			if (FuelData.Sensor_State == FuelSensorNormal)
			{
				if ((FuelData.Step_Get <= 20)&&(FuelData.Flag))
				{
					LED_Driver_Channel_Set(Channel_0, LampCh0_Oillow, Lamp_On);
				}
				else
				{
					LED_Driver_Channel_Set(Channel_0, LampCh0_Oillow, Lamp_Off);
				}
			}
			else  
			{
				if((FuelData.Sensor_State == FuelSensorShortCircuit)||(FuelData.Sensor_State == FuelSensorOpenCircuit))
				{
					LED_Driver_Channel_Set(Channel_0, LampCh0_Oillow, Lamp_Blink_1Hz);
				}
				else
				{
				  	LED_Driver_Channel_Set(Channel_0, LampCh0_Oillow, Lamp_Off);
				}
			}
		}
		else
		{
			LED_Driver_Channel_Set(Channel_0, LampCh0_Oillow, Lamp_Off);
		}
	}
	else 
	{
		LED_Driver_Channel_Set(Channel_0, LampCh0_Oillow, Lamp_Off);
	}
}

void Coolant_TempHigh_Lamp(void)
{
	if((Val_EOL_F101_ConfigType() == 1)||(Val_EOL_F101_ConfigType() == 3)||(Val_EOL_F101_ConfigType() == 4)||(Val_EOL_F101_ConfigType() == 6))
	{
		if (SYS_OPR_STAT_IGN_ON)
		{
			if (CAN_MSG_Status(CAN_CH0, CAN_CH0_ID_EMS_18FA92D0_Msg_Count) == CAN_MSG_LOST)
			{
				LED_Driver_Channel_Set(Channel_0, LampCh1_CooltLiquid_High, Lamp_Blink_1Hz);
			}
			else
			{
				if (bsp_GetMotorStep(Motor_1) >= 1100 )
				{      
					LED_Driver_Channel_Set(Channel_0, LampCh1_CooltLiquid_High, Lamp_On);
				}
				else if(bsp_GetMotorStep(Motor_1) <= 1040 )
				{
					LED_Driver_Channel_Set(Channel_0, LampCh1_CooltLiquid_High, Lamp_Off);
				}
				else
				{
				}    
			}
		}
		else
		{
			LED_Driver_Channel_Set(Channel_0, LampCh1_CooltLiquid_High, Lamp_Off);
		}
	}
	else
	{
		LED_Driver_Channel_Set(Channel_0, LampCh1_CooltLiquid_High, Lamp_Off);
	}
}

void OilPressure_Low_Lamp(void)
{
	if(Val_EOL_F110_EMS() == 1)
	{
		if (g_u8SelfLampTimes < LED_SELF_CHECK_TIME)
		{
			LED_Driver_Channel_Set(Channel_0, LampCh0_EngOilPress, Lamp_On);
		}
		else
		{
			if (SYS_OPR_STAT_IGN_ON)
			{
				if (CAN_MSG_Status(CAN_CH0, CAN_CH0_ID_EMS_18FA92D0_Msg_Count) == CAN_MSG_LOST)
				{
					LED_Driver_Channel_Set(Channel_0, LampCh0_EngOilPress, Lamp_On);
				}
				else
				{
					if(Get_CAN_CH0_ID_18FA92D0_Sig_EMS_OilPressureWarning() == 1)
					{
						LED_Driver_Channel_Set(Channel_0, LampCh0_EngOilPress, Lamp_On);
					}
					else
					{
						LED_Driver_Channel_Set(Channel_0, LampCh0_EngOilPress, Lamp_Off);
					}
				}
			}
			else
			{
				LED_Driver_Channel_Set(Channel_0, LampCh0_EngOilPress, Lamp_Off);
			}
		}
	}
	else
	{
		LED_Driver_Channel_Set(Channel_0, LampCh0_EngOilPress, Lamp_Off);
	}
}

void Engine_Sys_Fault_Lamp(void)
{
	if(Val_EOL_F110_EMS() == 1)
	{
		if (SYS_OPR_STAT_IGN_ON)
		{
			if (CAN_MSG_Status(CAN_CH0, CAN_CH0_ID_EMS_18FA92D0_Msg_Count) == CAN_MSG_LOST)
			{
				LED_Driver_Channel_Set(Channel_1, LampCh1_Engine_System_Failt, Lamp_On);
			}
			else
			{
				if(Get_CAN_CH0_ID_18FA92D0_Sig_EMS_EngineSVSTelltale() == 1)
				{
					LED_Driver_Channel_Set(Channel_1, LampCh1_Engine_System_Failt, Lamp_On);
				}
				else
				{
					LED_Driver_Channel_Set(Channel_1, LampCh1_Engine_System_Failt, Lamp_Off);
				}
			}
		}
		else
		{
			LED_Driver_Channel_Set(Channel_1, LampCh1_Engine_System_Failt, Lamp_Off);
		}
	}
	else
	{
		LED_Driver_Channel_Set(Channel_1, LampCh1_Engine_System_Failt, Lamp_Off);
	}
}

void Engine_Emission_Fault_Lamp(void)
{
	if((Val_EOL_F110_EMS() == 1)&&((Val_EOL_F101_EmissionsStandards() == 1)||(Val_EOL_F101_EmissionsStandards() == 1)))
	{
		if (g_u8SelfLampTimes < LED_SELF_CHECK_TIME)
		{
			LED_Driver_Channel_Set(Channel_1, LampCh1_Engine_Emission_Failt, Lamp_Off);	
		}
		else
		{
			if (SYS_OPR_STAT_IGN_ON)
			{
				if ((CAN_MSG_Status(CAN_CH0, CAN_CH0_ID_PMS_18FAB027_Msg_Count) == CAN_MSG_LOST)||(CAN_MSG_Status(CAN_CH0, CAN_CH0_ID_PMS_18FF5F27_Msg_Count) == CAN_MSG_LOST))
				{
					LED_Driver_Channel_Set(Channel_1, LampCh1_Engine_Emission_Failt, Lamp_On);
				}
				else
				{
					if(Get_CAN_CH0_ID_18FAB027_Sig_PMS_PTReadyInd() == 0)
					{
						LED_Driver_Channel_Set(Channel_1, LampCh1_Engine_Emission_Failt, Lamp_On);
					}
					else if(Get_CAN_CH0_ID_18FAB027_Sig_PMS_PTReadyInd() == 1)
					{
						if(Get_CAN_CH0_ID_18FF5F27_Sig_PMS_MILTelltale() == 1)
						{
							LED_Driver_Channel_Set(Channel_1, LampCh1_Engine_Emission_Failt, Lamp_On);
						}
						else if(Get_CAN_CH0_ID_18FF5F27_Sig_PMS_MILTelltale() == 2)
						{
							LED_Driver_Channel_Set(Channel_1, LampCh1_Engine_Emission_Failt, Lamp_Blink_1Hz);
						}
						else
						{
							LED_Driver_Channel_Set(Channel_1, LampCh1_Engine_Emission_Failt, Lamp_Off);
						}
					}
					else
					{
						LED_Driver_Channel_Set(Channel_1, LampCh1_Engine_Emission_Failt, Lamp_Off);
					}
				}
			}
			else
			{
				LED_Driver_Channel_Set(Channel_1, LampCh1_Engine_Emission_Failt, Lamp_Off);
			}
		}
	}
	else
	{
		LED_Driver_Channel_Set(Channel_1, LampCh1_Engine_Emission_Failt, Lamp_Off);
	}
}

void ASR_Lamp(void)
{
	if ((Val_EOL_F101_ASR() == 2)&&(Val_EOL_F101_BrakeSupplier() == 1))
	{
		if (SYS_OPR_STAT_IGN_ON)
		{
			if (CAN_MSG_Status(CAN_CH0, CAN_CH0_ID_ABS_EBS_EBC1_Msg_Count) == CAN_MSG_LOST)
			{
				LED_Driver_Channel_Set(Channel_1, LampCh1_ASR_Lamp, Lamp_Off);
			}
			else
			{
				if((Get_CAN_CH0_ID_18F0010B_Sig_EBS_ASREngineControlActive() == 1) && (Get_CAN_CH0_ID_18F0010B_Sig_EBS_ASR_Off_RoadSwitch() == 0))
				{
					LED_Driver_Channel_Set(Channel_1, LampCh1_ASR_Lamp, Lamp_Blink_1Hz);
				}
				else
				{
					LED_Driver_Channel_Set(Channel_1, LampCh1_ASR_Lamp, Lamp_Off);
				}
			}
		}
		else
		{
			LED_Driver_Channel_Set(Channel_1, LampCh1_ASR_Lamp, Lamp_Off);
		}
	}
	else
	{
		LED_Driver_Channel_Set(Channel_1, LampCh1_ASR_Lamp, Lamp_Off);
	}
}

void ASR_Off_Lamp(void)
{
	if (Val_EOL_F101_ASR() == 2)
	{
		if (SYS_OPR_STAT_IGN_ON)
		{
			if (CAN_MSG_Status(CAN_CH0, CAN_CH0_ID_ABS_EBS_EBC1_Msg_Count) == CAN_MSG_LOST)
			{
				LED_Driver_Channel_Set(Channel_1, LampCh1_ASR_Off, Lamp_Off);
			}
			else
			{
				if (Get_CAN_CH0_ID_18F0010B_Sig_EBS_ASR_Off_RoadSwitch() == 1)
				{
					LED_Driver_Channel_Set(Channel_1, LampCh1_ASR_Off, Lamp_On);
				}
				else
				{
					LED_Driver_Channel_Set(Channel_1, LampCh1_ASR_Off, Lamp_Off);
				}
			}
		}
		else
		{
			LED_Driver_Channel_Set(Channel_1, LampCh1_ASR_Off, Lamp_Off);
		}
	}
	else
	{
		LED_Driver_Channel_Set(Channel_1, LampCh1_ASR_Off, Lamp_Off);
	}
}




#if 0

//���س��״ָ̬ʾ��
void BatteryCharge_Lamp(void)
{
	if (SYS_OPR_STAT_IGN_ON)
	{
		if (g_u8SelfLampTimes < LED_SELF_CHECK_TIME)
		{
			LED_Driver_Channel_Set(Channel_0, LampCh0_BatCharge, 255);
		}
		else
		{
			LED_Driver_Channel_Set(Channel_0, LampCh0_BatCharge, Lamp_Off);
		}
	}
	else
	{
		LED_Driver_Channel_Set(Channel_0, LampCh0_BatCharge, Lamp_Off);
	}
}

//8.ȼ�ͱ�����Ӳ����ֵ
void FuelWarning_Lamp(void)
{
	if (SYS_OPR_STAT_IGN_ON)
	{
		if (g_u8SelfLampTimes < LED_SELF_CHECK_TIME)
		{												        
			LED_Driver_Channel_Set(Channel_0, LampCh0_Fuel_Y,Lamp_Off );
			LED_Driver_Channel_Set(Channel_0, LampCh0_Fuel_W,Lamp_FuelOn );
		}
		else
		{
			if (FuelData.Sensor_State == FuelSensorNormal)
			{
				if ((FuelData.Step_Get <= 20)&&(FuelData.Flag))
				{
					LED_Driver_Channel_Set(Channel_0, LampCh0_Fuel_Y, Lamp_FuelOn);
					LED_Driver_Channel_Set(Channel_0, LampCh0_Fuel_W, Lamp_Off);
				}
				else
				{
					LED_Driver_Channel_Set(Channel_0, LampCh0_Fuel_Y, Lamp_Off);
					LED_Driver_Channel_Set(Channel_0, LampCh0_Fuel_W, Lamp_FuelOn);
				}
			}
			else  if((FuelData.Sensor_State == FuelSensorShortCircuit)||(FuelData.Sensor_State == FuelSensorOpenCircuit))
			{
				LED_Driver_Channel_Set(Channel_0, LampCh0_Fuel_Y, Lamp_AjustBlink_1Hz);
				LED_Driver_Channel_Set(Channel_0, LampCh0_Fuel_W, Lamp_Off);
			}
			else
			{
			  	LED_Driver_Channel_Set(Channel_0, LampCh0_Fuel_Y, Lamp_Off);
				LED_Driver_Channel_Set(Channel_0, LampCh0_Fuel_W, Lamp_FuelOn);
			}
		}
	}
	else
	{
		LED_Driver_Channel_Set(Channel_0, LampCh0_Fuel_Y, Lamp_Off);
		LED_Driver_Channel_Set(Channel_0, LampCh0_Fuel_W, Lamp_Off);
	}
}

//10.ˮ�¸�ָʾ��
void CoolantWarning_Lamp(void)
{
	if (SYS_OPR_STAT_IGN_ON)
	{
		if (g_u8SelfLampTimes < LED_SELF_CHECK_TIME)
		{
			LED_Driver_Channel_Set(Channel_1, LampCh1_CooltLiquid_R, Lamp_FuelOn);
			LED_Driver_Channel_Set(Channel_1, LampCh1_CooltLiquid_W, Lamp_Off);
		}
		else
		{
			if (CANMsg_18FEEE00_Status.BIT.Function_Lost == CAN_MSG_LOST)
			{
				LED_Driver_Channel_Set(Channel_1, LampCh1_CooltLiquid_R, Lamp_AjustBlink_1Hz);
				LED_Driver_Channel_Set(Channel_1, LampCh1_CooltLiquid_W, Lamp_Off);
			}
			else
			{
				if (bsp_GetMotorStep(Motor_1) >= 1100 )
				{      
					LED_Driver_Channel_Set(Channel_1, LampCh1_CooltLiquid_R, Lamp_FuelOn);
					LED_Driver_Channel_Set(Channel_1, LampCh1_CooltLiquid_W, Lamp_Off);
				}
				else if(bsp_GetMotorStep(Motor_1) <= 1040 )
				{
					LED_Driver_Channel_Set(Channel_1, LampCh1_CooltLiquid_R, Lamp_Off);
					LED_Driver_Channel_Set(Channel_1, LampCh1_CooltLiquid_W, Lamp_FuelOn);
				}
				else
				{
					
				}    
			}
		}
	}
	else
	{
		LED_Driver_Channel_Set(Channel_1, LampCh1_CooltLiquid_R, Lamp_Off);
		LED_Driver_Channel_Set(Channel_1, LampCh1_CooltLiquid_W, Lamp_Off);
	}
}

//11  ����ѹ����ָʾ��
void OilPressure_Lamp(void)
{}

//12  ������һ�����ָʾ��
void Engine_General_Fault_Lamp(void)
{
	if((Val_EOL_F101_Engine() == 1)|| (Val_EOL_F101_Engine() == 3))//����
	{
		if(g_u8SelfLampTimes < LED_SELF_CHECK_TIME)
		{
			LED_Driver_Channel_Set(Channel_1, LampCh1_EngGeneral_Flt, Lamp_On);
		}
		else
		{
			if(SYS_OPR_STAT_IGN_ON)
			{
				if(CANMsg_18FD0700_Status.BIT.Function_Lost == CAN_MSG_LOST)
				{
					LED_Driver_Channel_Set(Channel_1, LampCh1_EngGeneral_Flt, Lamp_On);	
				}
				else
				{
					if(EMS_ProtectLamp_Sts == 1)
					{
						LED_Driver_Channel_Set(Channel_1, LampCh1_EngGeneral_Flt, Lamp_On);
					}
					else
					{
						LED_Driver_Channel_Set(Channel_1, LampCh1_EngGeneral_Flt, Lamp_Off);	
					}
				}
			}
			else
			{
				LED_Driver_Channel_Set(Channel_1, LampCh1_EngGeneral_Flt, Lamp_Off);		
			}
		}
	}
	else if(Val_EOL_F101_Engine() == 2)	 //����˹
	{
		if(g_u8SelfLampTimes < LED_SELF_CHECK_TIME)
		{
			LED_Driver_Channel_Set(Channel_1, LampCh1_EngGeneral_Flt, Lamp_On);
		}
		else
		{
			if(SYS_OPR_STAT_IGN_ON)
			{
				if(CANMsg_18FD0700_5s_Status.Lost == CAN_MSG_LOST)
				{
					LED_Driver_Channel_Set(Channel_1, LampCh1_EngGeneral_Flt, Lamp_On);
				}
				else
				{
					if(CANMsg_18FD0700_5s.BIT.EMS_AmberWarningLamp == 1)
					{
						LED_Driver_Channel_Set(Channel_1, LampCh1_EngGeneral_Flt, Lamp_On);
					}
					else
					{
						LED_Driver_Channel_Set(Channel_1, LampCh1_EngGeneral_Flt, Lamp_Off);
					}
				}
			}
			else
			{
				LED_Driver_Channel_Set(Channel_1, LampCh1_EngGeneral_Flt, Lamp_Off);
			}
		}
	}
	else
	{
		LED_Driver_Channel_Set(Channel_1, LampCh1_EngGeneral_Flt, Lamp_Off);
	}
}

//13.OBD�������ŷŹ���
void OBD_EngineEmissionFault(void)
{
	if((Val_EOL_F101_Engine() == 1)|| (Val_EOL_F101_Engine() == 3)) //����
	{
		if(g_u8SelfLampTimes < LED_SELF_CHECK_TIME)
		{
			LED_Driver_Channel_Set(Channel_1, LampCh1_Eng_ExhaustFlt, Lamp_On);
		}
		else
		{
			if(SYS_OPR_STAT_IGN_ON)
			{
				if (CANMsg_18FD0700_Status.BIT.Function_Lost == CAN_MSG_LOST)
				{
					LED_Driver_Channel_Set(Channel_1, LampCh1_Eng_ExhaustFlt, Lamp_On);
				}
				else
				{
					if (EMS_OBDMalfunctionIndicator_Lamp == 1)
					{
						LED_Driver_Channel_Set(Channel_1, LampCh1_Eng_ExhaustFlt, Lamp_On);
					}
					else
					{
						LED_Driver_Channel_Set(Channel_1, LampCh1_Eng_ExhaustFlt, Lamp_Off);
					}
				}
			}
			else 
			{
				LED_Driver_Channel_Set(Channel_1, LampCh1_Eng_ExhaustFlt, Lamp_Off);	
			}
		}
	}
	else if(Val_EOL_F101_Engine() == 2) //����˹
	{
		if(g_u8SelfLampTimes < LED_SELF_CHECK_TIME)
		{
			LED_Driver_Channel_Set(Channel_1, LampCh1_Eng_ExhaustFlt, Lamp_On);
		}
		else
		{
		         if(SYS_OPR_STAT_IGN_ON)
		         {
				if(CANMsg_18FD0700_5s_Status.Lost == CAN_MSG_LOST)
				{
					LED_Driver_Channel_Set(Channel_1, LampCh1_Eng_ExhaustFlt, Lamp_On);
				}
				else
				{
					if(CANMsg_18FD0700_5s.BIT.EMS_OBDMalfunctionIndicatorLamp == 1 )
					{
						LED_Driver_Channel_Set(Channel_1, LampCh1_Eng_ExhaustFlt, Lamp_On);
					}
					else
					{
						LED_Driver_Channel_Set(Channel_1, LampCh1_Eng_ExhaustFlt, Lamp_Off);
					}
				}				         
			}
			else
			{
				LED_Driver_Channel_Set(Channel_1, LampCh1_Eng_ExhaustFlt, Lamp_Off);	
			}
		}
	}
	else
	{
		LED_Driver_Channel_Set(Channel_1, LampCh1_Eng_ExhaustFlt, Lamp_Off);
	}
}



//15  פ���ƶ��ƣ������

void Parking_Brake_Lamp()
{
	if (Val_EOL_F110_EPB_Air() == 1)
	{
		if (g_u8SelfLampTimes < LED_SELF_CHECK_TIME)
		{
			LED_Driver_Channel_Set(Channel_1, LampCh1_ParkingBrake, Lamp_On);
		}
		else
		{
			if (SYS_OPR_STAT_IGN_ON)
			{
				if (CANMsg_18FFB88F_Status.BIT.Function_Lost == CAN_MSG_LOST)
				{
					LED_Driver_Channel_Set(Channel_1, LampCh1_ParkingBrake, Lamp_Off);
				}
				else
				{
					if (EPB_ParkBrake_Sts == 1)
					{
						LED_Driver_Channel_Set(Channel_1, LampCh1_ParkingBrake, Lamp_On);
					}
					else
					{
						LED_Driver_Channel_Set(Channel_1, LampCh1_ParkingBrake, Lamp_Off);
					}
				}
			}
			else
			{
				LED_Driver_Channel_Set(Channel_1, LampCh1_ParkingBrake, Lamp_Off);
			}
		}
	}
	else if (Val_EOL_F110_EPB_Air() == 0)
	{
		if (g_u8SelfLampTimes < LED_SELF_CHECK_TIME)
		{
			LED_Driver_Channel_Set(Channel_1, LampCh1_ParkingBrake, Lamp_On);
		}
		else
		{
			if (SYS_OPR_STAT_IGN_ON)
			{
				if (Line_In_Get_Status(LINE_IN_Parking_Brake))
				{
					LED_Driver_Channel_Set(Channel_1, LampCh1_ParkingBrake, Lamp_On);
				}
				else
				{
					LED_Driver_Channel_Set(Channel_1, LampCh1_ParkingBrake, Lamp_Off);
				}
			}
			else
			{
				LED_Driver_Channel_Set(Channel_1, LampCh1_ParkingBrake, Lamp_Off);
			}
		}
	}
	else
	{
		LED_Driver_Channel_Set(Channel_1, LampCh1_ParkingBrake, Lamp_Off);
	}
}



//17��ȫ������50ms����
void Safe_Belt_Warning_Processing(void)
{
	if (g_u8SelfLampTimes < LED_SELF_CHECK_TIME)
	{
		LED_Driver_Channel_Set(Channel_0, LampCh0_DriverSafeBelt, Lamp_On);
	}
	else
	{
		if (SYS_OPR_STAT_IGN_ON)
		{
			if (Line_In_Get_Status(LINE_IN_Driver_SafeBelt))
			{
				if (DataVSpeedDisp >= 100)
				{
					g_stSafeBelt.u8Flag  = 1;
					g_stSafeBelt.u8Warning = Warning_level_2;
				}
				else if ((DataVSpeedDisp < 20))
				{
					g_stSafeBelt.u8Flag  = 0;
					g_stSafeBelt.u8Warning = Warning_level_1;
				}
				else
				{
					if(g_stSafeBelt.u8Flag )
					{
						g_stSafeBelt.u8Warning = Warning_level_2;	
					}
					else 
					{
						g_stSafeBelt.u8Warning = Warning_level_1;	
					}
				}
			}
			else
			{
			         g_stSafeBelt.u8Flag  = 0;
				g_stSafeBelt.u8Warning = Warning_Non;
			}

			if (g_stSafeBelt.u8Warning == Warning_level_2)
			{
				LED_Driver_Channel_Set(Channel_0, LampCh0_DriverSafeBelt, Lamp_Blink_1Hz);
			}
			else if (g_stSafeBelt.u8Warning == Warning_level_1)
			{
				LED_Driver_Channel_Set(Channel_0, LampCh0_DriverSafeBelt, Lamp_On);
			}
			else
			{
				LED_Driver_Channel_Set(Channel_0, LampCh0_DriverSafeBelt, Lamp_Off);
			}
		}
		else
		{
			g_stSafeBelt.u8Flag  = 0;	
			g_stSafeBelt.u8Warning = Warning_Non;
			LED_Driver_Channel_Set(Channel_0, LampCh0_DriverSafeBelt, Lamp_Off);
		}
	}
}

//18.��Ƭĥ�p����
void BrakeShoeWear_Lamp(void)
{
	if (g_u8SelfLampTimes < LED_SELF_CHECK_TIME)
	{
		LED_Driver_Channel_Set(Channel_0, LampCh0_Brake_ShoeWear, Lamp_On);
	}
	else
	{
		if (SYS_OPR_STAT_IGN_ON)
		{
			if (Line_In_Get_Status(LINE_IN_BrakeShoeWear))
			{
				LED_Driver_Channel_Set(Channel_0, LampCh0_Brake_ShoeWear, Lamp_On);
			}
			else
			{
				LED_Driver_Channel_Set(Channel_0, LampCh0_Brake_ShoeWear, Lamp_Off);
			}
		}
		else
		{
			LED_Driver_Channel_Set(Channel_0, LampCh0_Brake_ShoeWear, Lamp_Off);
		}
	}
}



//20.̥ѹ����ָʾ��

void TirePressure_Lamp(void)
{
	if(((Val_EOL_F101_TPMSType() == 1) || (Val_EOL_F101_TPMSType() == 2)) && (Val_EOL_F110_TPMS() == 1))
	{
		if (SYS_OPR_STAT_IGN_ON)
		{
			if (g_u8SelfLampTimes < LED_SELF_CHECK_TIME) //g_stTyrePress
			{
				Trye_Lamp.StmFlt_timer1 = 0;
				Trye_Lamp.StmFlt_timer3 = 0;
				Trye_Lamp.StmFlt_timerlost = 0;
				LED_Driver_Channel_Set(Channel_0, LampCh0_TPMS_Fault, Lamp_On);
			}
			else
			{
				if (CANMsg_18FFE033_Status.BIT.Function_Lost == CAN_MSG_LOST)
				{
					Trye_Lamp.StmFlt_timer1 = 0;
					Trye_Lamp.StmFlt_timer3 = 0;
					if (Trye_Lamp.StmFlt_timerlost <= 1200)
					{
						Trye_Lamp.StmFlt_timerlost++;
						LED_Driver_Channel_Set(Channel_0, LampCh0_TPMS_Fault, Lamp_Blink_1Hz);
					}
					else
					{
						if (Lamp_Blink_1Hz)
						{
							LED_Driver_Channel_Set(Channel_0, LampCh0_TPMS_Fault, Lamp_On);
						}
					}
				}
				else
				{
					if (TPMS_System_Fault == 0X01)
					{
						Trye_Lamp.StmFlt_timer3 = 0;
						Trye_Lamp.StmFlt_timerlost = 0;

						if (Trye_Lamp.StmFlt_timer1 <= 1200)
						{
							Trye_Lamp.StmFlt_timer1++;
							LED_Driver_Channel_Set(Channel_0, LampCh0_TPMS_Fault, Lamp_Blink_1Hz);
						}
						else
						{
							if (Lamp_Blink_1Hz)
							{
								LED_Driver_Channel_Set(Channel_0, LampCh0_TPMS_Fault, Lamp_On);
							}
						}
					}
					else if (TPMS_System_Fault == 0X02)
					{
						Trye_Lamp.StmFlt_timer1 = 0;
						Trye_Lamp.StmFlt_timer3 = 0;
						Trye_Lamp.StmFlt_timerlost = 0;
						if (Lamp_Blink_1Hz)
						{
							LED_Driver_Channel_Set(Channel_0, LampCh0_TPMS_Fault, Lamp_On);
						}
					}
					else if (TPMS_System_Fault == 0X03)
					{
						Trye_Lamp.StmFlt_timer1 = 0;
						Trye_Lamp.StmFlt_timerlost = 0;
						if (Trye_Lamp.StmFlt_timer3 < 1200)
						{
							Trye_Lamp.StmFlt_timer3++;
							LED_Driver_Channel_Set(Channel_0, LampCh0_TPMS_Fault, Lamp_Blink_1Hz);
						}
						else
						{
							if (Lamp_Blink_1Hz)
							{
								LED_Driver_Channel_Set(Channel_0, LampCh0_TPMS_Fault, Lamp_On);
							}
						}
					}
					else
					{
						LED_Driver_Channel_Set(Channel_0, LampCh0_TPMS_Fault, Lamp_Off);
						Trye_Lamp.StmFlt_timer1 = 0;
						Trye_Lamp.StmFlt_timer3 = 0;
						Trye_Lamp.StmFlt_timerlost = 0;
					}
				}
			}
		}
		else
		{
			Trye_Lamp.StmFlt_timer1 = 0;
			Trye_Lamp.StmFlt_timer3 = 0;
			Trye_Lamp.StmFlt_timerlost = 0;
			LED_Driver_Channel_Set(Channel_0, LampCh0_TPMS_Fault, Lamp_Off);
		}
	}
	else
	{
		Trye_Lamp.StmFlt_timer1 = 0;
		Trye_Lamp.StmFlt_timer3 = 0;
		Trye_Lamp.StmFlt_timerlost = 0;
		LED_Driver_Channel_Set(Channel_0, LampCh0_TPMS_Fault, Lamp_Off);
	}
}



//22.LDW����/����ָʾ��
void LDWS_Lamp(void)
{
	if ((Val_EOL_F101_LDW() == 0x02) && (Val_EOL_F110_FCS() == 0x01))
	{
		if (g_u8SelfLampTimes < LED_SELF_CHECK_TIME)
		{
			LED_Driver_Channel_Set(Channel_0, LampCh0_LDWFlt_Y, Lamp_Off);
			LED_Driver_Channel_Set(Channel_0, LampCh0_LDWFlt_G, Lamp_On);
		}
		else
		{
			if (SYS_OPR_STAT_IGN_ON)
			{
				if (CANMsg_18FE5BE8_Status.BIT.Function_Lost != CAN_MSG_LOST)
				{
					if ((FCS_LDWSystem_State == 0x00) || (FCS_LDWSystem_State == 0x01) || (FCS_LDWSystem_State == 0x03) ||
						(FCS_LDWSystem_State == 0x04) || (FCS_LDWSystem_State == 0x05))
					{
						LED_Driver_Channel_Set(Channel_0, LampCh0_LDWFlt_Y, Lamp_Off);
						LED_Driver_Channel_Set(Channel_0, LampCh0_LDWFlt_G, Lamp_On);
					}
					else if ((FCS_LDWSystem_State == 0x0E) || (FCS_LDWSystem_State == 0x0F))
					{
						LED_Driver_Channel_Set(Channel_0, LampCh0_LDWFlt_Y, Lamp_On);
						LED_Driver_Channel_Set(Channel_0, LampCh0_LDWFlt_G, Lamp_Off);
					}
					else
					{
						LED_Driver_Channel_Set(Channel_0, LampCh0_LDWFlt_Y, Lamp_Off);
						LED_Driver_Channel_Set(Channel_0, LampCh0_LDWFlt_G, Lamp_Off);
					}
				}
				else
				{
					LED_Driver_Channel_Set(Channel_0, LampCh0_LDWFlt_Y, Lamp_On);
					LED_Driver_Channel_Set(Channel_0, LampCh0_LDWFlt_G, Lamp_Off);
				}
			}
			else
			{
				LED_Driver_Channel_Set(Channel_0, LampCh0_LDWFlt_Y, Lamp_Off);
				LED_Driver_Channel_Set(Channel_0, LampCh0_LDWFlt_G, Lamp_Off);
			}
		}
	}
	else
	{
		LED_Driver_Channel_Set(Channel_0, LampCh0_LDWFlt_Y, Lamp_Off);
		LED_Driver_Channel_Set(Channel_0, LampCh0_LDWFlt_G, Lamp_Off);
	}
}
//23.����
void Maint_LAMP(void)
{
	if (g_u8SelfLampTimes < LED_SELF_CHECK_TIME)
	{
		LED_Driver_Channel_Set(Channel_1, LampCh1_Maint, Lamp_On);	
	}
	else
	{
		if (SYS_OPR_STAT_IGN_ON)
		{
			if( (Menu_Item_Select_Get(MENU_ITEM_SET_MAINT_OPEN) == 1u)&&(DataServiceWarning == 1) )
			{
				LED_Driver_Channel_Set(Channel_1, LampCh1_Maint, Lamp_On);
			}
			else
			{
				LED_Driver_Channel_Set(Channel_1, LampCh1_Maint, Lamp_Off);
			}
		}
		else
		{
			LED_Driver_Channel_Set(Channel_1, LampCh1_Maint, Lamp_Off);
		}
	}
}
//24.Ѳ��ָʾ��
void Cruise_Lamp(void)
{
	if((Val_EOL_F101_Cruise() == 2)&&(Val_EOL_F101_Engine() == 1))  //����
	{
		if (g_u8SelfLampTimes < LED_SELF_CHECK_TIME)
		{
			LED_Driver_Channel_Set(Channel_1, LampCh1_Cruise_W, Lamp_Off);
			LED_Driver_Channel_Set(Channel_1, LampCh1_Cruise_G, Lamp_On);
		}
		else
		{
			if (SYS_OPR_STAT_IGN_ON)
			{
				if((CANMsg_18FEF100_Status.BIT.Function_Lost == CAN_MSG_LOST)&&(CANMsg_18FF2200_Status.BIT.Function_Lost == CAN_MSG_LOST))
				{
					LED_Driver_Channel_Set(Channel_1, LampCh1_Cruise_W, Lamp_Off);
					LED_Driver_Channel_Set(Channel_1, LampCh1_Cruise_G, Lamp_Off);
				}
				else if((CANMsg_18FEF100_Status.BIT.Function_Lost == CAN_MSG_LOST)&&(CANMsg_18FF2200_Status.BIT.Function_Lost != CAN_MSG_LOST))
				{ 
					LED_Driver_Channel_Set(Channel_1, LampCh1_Cruise_G, Lamp_Off);
					if(Com_stCrCUIMain_On == 1)
					{
						LED_Driver_Channel_Set(Channel_1, LampCh1_Cruise_W, Lamp_On);	
					}
					else
					{
						LED_Driver_Channel_Set(Channel_1, LampCh1_Cruise_W, Lamp_Off);		
					}
				}
				else if((CANMsg_18FEF100_Status.BIT.Function_Lost != CAN_MSG_LOST)&&(CANMsg_18FF2200_Status.BIT.Function_Lost == CAN_MSG_LOST))
			 	{
			 		LED_Driver_Channel_Set(Channel_1, LampCh1_Cruise_W, Lamp_Off);
					if(EMS_CruiseCtrl_Active == 1)
					{
						LED_Driver_Channel_Set(Channel_1, LampCh1_Cruise_G, Lamp_On);
					}
					else
					{
						LED_Driver_Channel_Set(Channel_1, LampCh1_Cruise_G, Lamp_Off);	
					}
			 	}
			 	else
			 	{
				 	if((EMS_CruiseCtrl_Active == 1)&&(Com_stCrCUIMain_On == 1))
				 	{
						LED_Driver_Channel_Set(Channel_1, LampCh1_Cruise_W, Lamp_Off);
						LED_Driver_Channel_Set(Channel_1, LampCh1_Cruise_G, Lamp_On);
				 	}
				 	else	 
				 	{
						if(EMS_CruiseCtrl_Active == 1)
						{
							LED_Driver_Channel_Set(Channel_1, LampCh1_Cruise_G, Lamp_On);
						}
						else
						{
							LED_Driver_Channel_Set(Channel_1, LampCh1_Cruise_G, Lamp_Off);	
						}
					         
					         if(Com_stCrCUIMain_On == 1)
					         {
					         	LED_Driver_Channel_Set(Channel_1, LampCh1_Cruise_W, Lamp_On);	
					         }
					         else
					         {
					         	LED_Driver_Channel_Set(Channel_1, LampCh1_Cruise_W, Lamp_Off);		
					         }
				 	}
			 	}
			}
			else
			{
				LED_Driver_Channel_Set(Channel_1, LampCh1_Cruise_W, Lamp_Off);
				LED_Driver_Channel_Set(Channel_1, LampCh1_Cruise_G, Lamp_Off);
			}
		}
	}
	else if((Val_EOL_F101_Cruise() == 2)&&(Val_EOL_F101_Engine() == 2))	  //����˹
	{
		if (g_u8SelfLampTimes < LED_SELF_CHECK_TIME)
		{
			LED_Driver_Channel_Set(Channel_1, LampCh1_Cruise_W, Lamp_Off);
			LED_Driver_Channel_Set(Channel_1, LampCh1_Cruise_G, Lamp_On);
		}
		else
		{
			if (SYS_OPR_STAT_IGN_ON)
			{
				if(CANMsg_18FEF100_Status.BIT.Function_Lost == CAN_MSG_LOST)
				{
					LED_Driver_Channel_Set(Channel_1, LampCh1_Cruise_W, Lamp_Off);
					LED_Driver_Channel_Set(Channel_1, LampCh1_Cruise_G, Lamp_Off);
				}
			 	else
			 	{
				 	if((EMS_CruiseCtrl_Active == 1)&&(EMS_CruiseControlEnable_Switch == 1))
				 	{
						LED_Driver_Channel_Set(Channel_1, LampCh1_Cruise_W, Lamp_Off);
						LED_Driver_Channel_Set(Channel_1, LampCh1_Cruise_G, Lamp_On);
				 	}
				 	else	 
				 	{
						if(EMS_CruiseCtrl_Active == 1)
						{
							LED_Driver_Channel_Set(Channel_1, LampCh1_Cruise_G, Lamp_On);
						}
						else
						{
							LED_Driver_Channel_Set(Channel_1, LampCh1_Cruise_G, Lamp_Off);	
						}
					         
					         if(EMS_CruiseControlEnable_Switch == 1)
					         {
					         	LED_Driver_Channel_Set(Channel_1, LampCh1_Cruise_W, Lamp_On);	
					         }
					         else
					         {
					         	LED_Driver_Channel_Set(Channel_1, LampCh1_Cruise_W, Lamp_Off);		
					         }
				 	}
			 	}
			}
			else
			{
				LED_Driver_Channel_Set(Channel_1, LampCh1_Cruise_W, Lamp_Off);
				LED_Driver_Channel_Set(Channel_1, LampCh1_Cruise_G, Lamp_Off);
			}
		}
	}
	else
	{
		LED_Driver_Channel_Set(Channel_1, LampCh1_Cruise_W, Lamp_Off);
		LED_Driver_Channel_Set(Channel_1, LampCh1_Cruise_G, Lamp_Off);
	}
}

//25�������ȴ�����ָʾ��(Ԥ��)
void Engine_Wait_StartStop_Lamp(void)
{
	if (g_u8SelfLampTimes < LED_SELF_CHECK_TIME)
	{
		LED_Driver_Channel_Set(Channel_1, LampCh1_Preheat, Lamp_On);
	}
	else
	{
		if (SYS_OPR_STAT_IGN_ON)
		{
			if (CANMsg_18FEE400_Status.BIT.Function_Lost == CAN_MSG_LOST)
			{
				LED_Driver_Channel_Set(Channel_1, LampCh1_Preheat, Lamp_Off);
			}
			else
			{
				if (EMS_EngWaitToStart_Lamp == 1)
				{
					LED_Driver_Channel_Set(Channel_1, LampCh1_Preheat, Lamp_On);
				}
				else
				{
					LED_Driver_Channel_Set(Channel_1, LampCh1_Preheat, Lamp_Off);
				}
			}
		}
		else
		{
			LED_Driver_Channel_Set(Channel_1, LampCh1_Preheat, Lamp_Off);
		}
	}
}
//26 ����Һλ��
void LowUreaLevel_Lamp(void)
{}
//27��ˮ����ָʾ��
void OilWaterSeparation_Lamp(void)
{
	if (g_u8SelfLampTimes < LED_SELF_CHECK_TIME)
	{
		LED_Driver_Channel_Set(Channel_1, LampCh1_OilWater_Separation, Lamp_On);
	}
	else
	{
		if (SYS_OPR_STAT_IGN_ON)
		{
			if (CANMsg_18FEFF00_Status.BIT.Function_Lost == CAN_MSG_LOST)
			{
				LED_Driver_Channel_Set(Channel_1, LampCh1_OilWater_Separation, Lamp_On);
			}
			else
			{
				if (EMS_WaterInFuel_Indicator == 1)
				{
					LED_Driver_Channel_Set(Channel_1, LampCh1_OilWater_Separation, Lamp_On);
				}
				else
				{
					LED_Driver_Channel_Set(Channel_1, LampCh1_OilWater_Separation, Lamp_Off);
				}
			}
		}
		else
		{
			LED_Driver_Channel_Set(Channel_1, LampCh1_OilWater_Separation, Lamp_Off);
		}
	}
}

//28.DPF����ָʾ��
void DPF_Lamp(void)
{
	if (g_u8SelfLampTimes < LED_SELF_CHECK_TIME)
	{
		LED_Driver_Channel_Set(Channel_0, LampCh0_DPF_Y, Lamp_On);
		LED_Driver_Channel_Set(Channel_0, LampCh0_DPF_R, Lamp_Off);
	}
	else
	{
		if (SYS_OPR_STAT_IGN_ON)
		{
			if (CANMsg_18FD7C00_Status.BIT.Function_Lost == CAN_MSG_LOST)
			{
				LED_Driver_Channel_Set(Channel_0, LampCh0_DPF_Y, Lamp_Off);
				LED_Driver_Channel_Set(Channel_0, LampCh0_DPF_R, Lamp_On);
			}
			else
			{
				if (EMS_DPF_Lamp_Status == 1)
				{
					LED_Driver_Channel_Set(Channel_0, LampCh0_DPF_Y, Lamp_On);
					LED_Driver_Channel_Set(Channel_0, LampCh0_DPF_R, Lamp_Off);
				}
				else if (EMS_DPF_Lamp_Status == 2)
				{
					LED_Driver_Channel_Set(Channel_0, LampCh0_DPF_Y, Lamp_Off);
					LED_Driver_Channel_Set(Channel_0, LampCh0_DPF_R, Lamp_On);
				}
				else if (EMS_DPF_Lamp_Status == 4)
				{
					LED_Driver_Channel_Set(Channel_0, LampCh0_DPF_Y, Lamp_Blink_1Hz);
					LED_Driver_Channel_Set(Channel_0, LampCh0_DPF_R, Lamp_Off);
				}
				else
				{
					LED_Driver_Channel_Set(Channel_0, LampCh0_DPF_Y, Lamp_Off);
					LED_Driver_Channel_Set(Channel_0, LampCh0_DPF_R, Lamp_Off);
				}
			}
		}
		else
		{
			LED_Driver_Channel_Set(Channel_0, LampCh0_DPF_Y, Lamp_Off);
			LED_Driver_Channel_Set(Channel_0, LampCh0_DPF_R, Lamp_Off);
		}
	}
}
//29.DPF������ָֹʾ��
void DPF_Forbidden_Lamp(void)
{
	if(Val_EOL_F101_Engine() == 1) 
	{
		if (g_u8SelfLampTimes < LED_SELF_CHECK_TIME)
		{
			LED_Driver_Channel_Set(Channel_0, LampCh0_DPF_Forbid, Lamp_On);
		}
		else
		{
			if (SYS_OPR_STAT_IGN_ON)
			{
				if (CANMsg_18FD7C00_Status.BIT.Function_Lost == CAN_MSG_LOST)
				{
					LED_Driver_Channel_Set(Channel_0, LampCh0_DPF_Forbid, Lamp_On);
				}
				else
				{
					if (EMS_DPF_LampForbidden_Sts == 1)
					{
						LED_Driver_Channel_Set(Channel_0, LampCh0_DPF_Forbid, Lamp_On);
					}
					else
					{
						LED_Driver_Channel_Set(Channel_0, LampCh0_DPF_Forbid, Lamp_Off);
					}
				}
			}
			else
			{
				LED_Driver_Channel_Set(Channel_0, LampCh0_DPF_Forbid, Lamp_Off);
			}
		}
	}
	else if((Val_EOL_F101_Engine() == 2)||(Val_EOL_F101_Engine() == 3))
	{
		if (g_u8SelfLampTimes < LED_SELF_CHECK_TIME)
		{
			LED_Driver_Channel_Set(Channel_0, LampCh0_DPF_Forbid, Lamp_On);
		}
		else
		{
			if (SYS_OPR_STAT_IGN_ON)
			{
				if (CANMsg_18FD7C00_Status.BIT.Function_Lost == CAN_MSG_LOST)
				{
					LED_Driver_Channel_Set(Channel_0, LampCh0_DPF_Forbid, Lamp_On);
				}
				else
				{
					if (KMS_DPF_LampForbidden_Sts == 1)
					{
						LED_Driver_Channel_Set(Channel_0, LampCh0_DPF_Forbid, Lamp_On);
					}
					else
					{
						LED_Driver_Channel_Set(Channel_0, LampCh0_DPF_Forbid, Lamp_Off);
					}
				}
			}
			else
			{
				LED_Driver_Channel_Set(Channel_0, LampCh0_DPF_Forbid, Lamp_Off);
			}
		}
	}
	else
	{
		LED_Driver_Channel_Set(Channel_0, LampCh0_DPF_Forbid, Lamp_Off);
	}
}
//30  �����¶ȸ߱�����
void Exhaust_temHigh_Lamp(void)
{
	if (g_u8SelfLampTimes < LED_SELF_CHECK_TIME)
	{
		LED_Driver_Channel_Set(Channel_1, LampCh1_EhtTempHigh, Lamp_On);
	}
	else
	{
		if (SYS_OPR_STAT_IGN_ON)
		{
			if (CANMsg_18FD7C00_Status.BIT.Function_Lost == CAN_MSG_LOST)
			{
				LED_Driver_Channel_Set(Channel_1, LampCh1_EhtTempHigh, Lamp_Off);
			}
			else
			{
				if (EMS_ExhaustSystemHighTempLamp_Cmd == 1)
				{
					LED_Driver_Channel_Set(Channel_1, LampCh1_EhtTempHigh, Lamp_On);
				}
				else
				{
					LED_Driver_Channel_Set(Channel_1, LampCh1_EhtTempHigh, Lamp_Off);
				}
			}
		}
		else
		{
			LED_Driver_Channel_Set(Channel_1, LampCh1_EhtTempHigh, Lamp_Off);
		}
	}
}
//31  �����ƶ���
void ExhaustBrake_Lamp(void)
{
	if(Val_EOL_F101_Engine() == 1) //����
	{
		if (g_u8SelfLampTimes < LED_SELF_CHECK_TIME)
		{
			LED_Driver_Channel_Set(Channel_1, LampCh1_ExhaustBrake, Lamp_On);
		}
		else
		{
			if (SYS_OPR_STAT_IGN_ON)
			{
				if (CANMsg_18F00029_Status.BIT.Function_Lost == CAN_MSG_LOST)
				{
					LED_Driver_Channel_Set(Channel_1, LampCh1_ExhaustBrake, Lamp_Off);
				}
				else
				{
					if (EMS_RetarderReqBrake_Light == 1)
					{
						LED_Driver_Channel_Set(Channel_1, LampCh1_ExhaustBrake, Lamp_On);
					}
					else
					{
						LED_Driver_Channel_Set(Channel_1, LampCh1_ExhaustBrake, Lamp_Off);
					}
				}
			}
			else
			{
				LED_Driver_Channel_Set(Channel_1, LampCh1_ExhaustBrake, Lamp_Off);
			}
		}
	}
	else if (Val_EOL_F101_Engine() == 2) //����˹
	{
		if (g_u8SelfLampTimes < LED_SELF_CHECK_TIME)
		{
			LED_Driver_Channel_Set(Channel_1, LampCh1_ExhaustBrake, Lamp_On);
		}
		else
		{
			if (SYS_OPR_STAT_IGN_ON)
			{
				if (CANMsg_18FD0700_5s_Status.Lost == CAN_MSG_LOST)
				{
					LED_Driver_Channel_Set(Channel_1, LampCh1_ExhaustBrake, Lamp_Off);
				}
				else
				{
					if (CANMsg_18FD0700_5s.BIT.EMS_EngBrakeActiveLamp == 1)
					{
						LED_Driver_Channel_Set(Channel_1, LampCh1_ExhaustBrake, Lamp_On);
					}
					else
					{
						LED_Driver_Channel_Set(Channel_1, LampCh1_ExhaustBrake, Lamp_Off);
					}
				}
			}
			else
			{
				LED_Driver_Channel_Set(Channel_1, LampCh1_ExhaustBrake, Lamp_Off);
			}
		}
	}  
	else if(Val_EOL_F101_Engine() == 3) //Ϋ��
	{
		if (g_u8SelfLampTimes < LED_SELF_CHECK_TIME)
		{
			LED_Driver_Channel_Set(Channel_1, LampCh1_ExhaustBrake, Lamp_On);
		}
		else
		{
			if (SYS_OPR_STAT_IGN_ON)
			{
				if(CANMsg_18F0000F_Status.BIT.Function_Lost)
				{
					LED_Driver_Channel_Set(Channel_1, LampCh1_ExhaustBrake, Lamp_Off);
				}
				else
				{
					if (WeichaiEMS_RetarderReqBrake_Light == 1)
					{
						LED_Driver_Channel_Set(Channel_1, LampCh1_ExhaustBrake, Lamp_On);
					}
					else
					{
						LED_Driver_Channel_Set(Channel_1, LampCh1_ExhaustBrake, Lamp_Off);
					}
				}
			}
			else
			{
				LED_Driver_Channel_Set(Channel_1, LampCh1_ExhaustBrake, Lamp_Off);
			}
		}
	}
	else
	{
		LED_Driver_Channel_Set(Channel_1, LampCh1_ExhaustBrake, Lamp_Off);
	}
}
//32  PTOָʾ��
void PTO_Lamp(void)
{
	if (g_u8SelfLampTimes < LED_SELF_CHECK_TIME)
	{
		LED_Driver_Channel_Set(Channel_0, LampCh0_PTO, Lamp_On);
	}
	else
	{
		if (SYS_OPR_STAT_IGN_ON)
		{
			if (CANMsg_18FEF100_Status.BIT.Function_Lost == CAN_MSG_LOST)
			{
				LED_Driver_Channel_Set(Channel_0, LampCh0_PTO, Lamp_Off);
			}
			else
			{
				if ((EMS_PTOGovernor_State == 1) || (EMS_PTOGovernor_State == 5) ||
					(EMS_PTOGovernor_State == 6) || (EMS_PTOGovernor_State == 8))
				{
					LED_Driver_Channel_Set(Channel_0, LampCh0_PTO, Lamp_On);
				}
				else
				{
					LED_Driver_Channel_Set(Channel_0, LampCh0_PTO, Lamp_Off);
				}
			}
		}
		else
		{
			LED_Driver_Channel_Set(Channel_0, LampCh0_PTO, Lamp_Off);
		}
	}
}

//33.��ʻԱϵͳ�����
void DriverSystemWarning_Lamp(void)
{
	if((Val_EOL_F101_Engine() == 1)|| (Val_EOL_F101_Engine() == 3)) //����
	{
		if (g_u8SelfLampTimes < LED_SELF_CHECK_TIME)
		{
			LED_Driver_Channel_Set(Channel_0, LampCh0_DriverFlt_Y, Lamp_On);
			LED_Driver_Channel_Set(Channel_0, LampCh0_DriverFlt_R, Lamp_On);
		}
		else
		{
			if (SYS_OPR_STAT_IGN_ON)
			{
				if (CANMsg_18FEFF00_Status.BIT.Function_Lost == CAN_MSG_LOST)
				{
					LED_Driver_Channel_Set(Channel_0, LampCh0_DriverFlt_Y, Lamp_Off);
					LED_Driver_Channel_Set(Channel_0, LampCh0_DriverFlt_R, Lamp_On);
				}
				else
				{
					if (EMS_ECSOpIn_Severity == 1)
					{
						if (EMS_DWarnSysIndicator_Sts == 1)
						{
							LED_Driver_Channel_Set(Channel_0, LampCh0_DriverFlt_Y, Lamp_On);
							LED_Driver_Channel_Set(Channel_0, LampCh0_DriverFlt_R, Lamp_Off);
						}
						else if (EMS_DWarnSysIndicator_Sts == 4)
						{
							LED_Driver_Channel_Set(Channel_0, LampCh0_DriverFlt_Y, Lamp_Blink_1Hz);
							LED_Driver_Channel_Set(Channel_0, LampCh0_DriverFlt_R, Lamp_Off);
						}
						else
						{
							LED_Driver_Channel_Set(Channel_0, LampCh0_DriverFlt_Y, Lamp_Off);
							LED_Driver_Channel_Set(Channel_0, LampCh0_DriverFlt_R, Lamp_Off);
						}
					}
					else if (EMS_ECSOpIn_Severity == 2)
					{
						LED_Driver_Channel_Set(Channel_0, LampCh0_DriverFlt_Y, Lamp_Blink_1Hz);
						LED_Driver_Channel_Set(Channel_0, LampCh0_DriverFlt_R, Lamp_Off);
					}
					else if ((EMS_ECSOpIn_Severity == 3) || (EMS_ECSOpIn_Severity == 4))
					{
						LED_Driver_Channel_Set(Channel_0, LampCh0_DriverFlt_Y, Lamp_Blink_1Hz);
						LED_Driver_Channel_Set(Channel_0, LampCh0_DriverFlt_R, Lamp_On);
					}
					else if (EMS_ECSOpIn_Severity == 5)
					{
						LED_Driver_Channel_Set(Channel_0, LampCh0_DriverFlt_Y, Lamp_Blink_1Hz);
						LED_Driver_Channel_Set(Channel_0, LampCh0_DriverFlt_R, Lamp_Blink_1Hz);
					}
					else
					{
						if (EMS_DWarnSysIndicator_Sts == 4)
						{
							LED_Driver_Channel_Set(Channel_0, LampCh0_DriverFlt_Y, Lamp_Blink_1Hz);
							LED_Driver_Channel_Set(Channel_0, LampCh0_DriverFlt_R, Lamp_Off);
						}
						else
						{
							LED_Driver_Channel_Set(Channel_0, LampCh0_DriverFlt_Y, Lamp_Off);
							LED_Driver_Channel_Set(Channel_0, LampCh0_DriverFlt_R, Lamp_Off);
						}
					}
				}
			}
			else
			{
				LED_Driver_Channel_Set(Channel_0, LampCh0_DriverFlt_Y, Lamp_Off);
				LED_Driver_Channel_Set(Channel_0, LampCh0_DriverFlt_R, Lamp_Off);
			}
		}
	}
	else if (Val_EOL_F101_Engine() == 2) //����˹
	{
		LED_Driver_Channel_Set(Channel_0, LampCh0_DriverFlt_R, Lamp_Off);

		if (g_u8SelfLampTimes < LED_SELF_CHECK_TIME)
		{
			LED_Driver_Channel_Set(Channel_0, LampCh0_DriverFlt_Y, Lamp_On);
		}
		else
		{
			if (SYS_OPR_STAT_IGN_ON)
			{
				if (CANMsg_18FEFF00_Status.BIT.Function_Lost == CAN_MSG_LOST)
				{
					LED_Driver_Channel_Set(Channel_0, LampCh0_DriverFlt_Y, Lamp_Off);
				}
				else
				{
					if (EMS_DWarnSysIndicator_Sts == 1)
					{
						LED_Driver_Channel_Set(Channel_0, LampCh0_DriverFlt_Y, Lamp_On);
					}
					else if (EMS_DWarnSysIndicator_Sts == 4)
					{
						LED_Driver_Channel_Set(Channel_0, LampCh0_DriverFlt_Y, Lamp_Blink_1Hz);
					}
					else
					{
						LED_Driver_Channel_Set(Channel_0, LampCh0_DriverFlt_Y, Lamp_Off);
					}
				}
			}
			else
			{
				LED_Driver_Channel_Set(Channel_0, LampCh0_DriverFlt_Y, Lamp_Off);
			}
		}
	}
	else
	{
		LED_Driver_Channel_Set(Channel_0, LampCh0_DriverFlt_Y, Lamp_Off);
		LED_Driver_Channel_Set(Channel_0, LampCh0_DriverFlt_R, Lamp_Off);
	}
}
INT8U EMSLockVeh_Sts = 0;
INT8U LockVeh_Sts = 0;
INT8U LockVeh_Sts_Flg;
//34  Զ��������
void Remotely_LockCar_Lamp(void)
{
         if(Val_EOL_F101_Engine() == 1)    //����
         {
		LockVeh_Sts_Flg = 0; 
		EMSLockVeh_Sts = 0;		
		if (g_u8SelfLampTimes < LED_SELF_CHECK_TIME)
		{
			LED_Driver_Channel_Set(Channel_0, LampCh0_Rmtlock, Lamp_On);
		}
		else
		{
			if (SYS_OPR_STAT_IGN_ON)
			{
				if ((EMS_Encrypt_FB == 3) && ((EMS_LockVeh_Sts == 0) || (EMS_LockVeh_Sts == 1) || (EMS_LockVeh_Sts == 2)))
				{
					LockVeh_Sts = 1;		
				}
				else if (EMS_LockVeh_Sts == 0x03)
				{
					LockVeh_Sts = 0;
				}
				else
				{
				}
				if(LockVeh_Sts)
				{
					LED_Driver_Channel_Set(Channel_0, LampCh0_Rmtlock, Lamp_On);	
				}
				else
				{
					LED_Driver_Channel_Set(Channel_0, LampCh0_Rmtlock, Lamp_Off);	
				}
			}
			else
			{
				LED_Driver_Channel_Set(Channel_0, LampCh0_Rmtlock, Lamp_Off);
			}
		}         
	}
	else if(Val_EOL_F101_Engine() == 2)	//����˹
	{
	         LockVeh_Sts_Flg = 0; 
	         LockVeh_Sts = 0 ;
			
		if(g_u8SelfLampTimes < LED_SELF_CHECK_TIME)
		{
			LED_Driver_Channel_Set(Channel_0, LampCh0_Rmtlock, Lamp_On);	
		}
		else
		{
			if(SYS_OPR_STAT_IGN_ON)
			{
				if((EMS_TBOX1_LockVehSts == 1) || (EMS_TBOX1_LockVehSts == 2))
				{
					EMSLockVeh_Sts = 1;		
				}
				else
				{
					EMSLockVeh_Sts = 0;
				}

				if(EMSLockVeh_Sts)
				{
					LED_Driver_Channel_Set(Channel_0, LampCh0_Rmtlock, Lamp_On);	
				}
				else
				{
					LED_Driver_Channel_Set(Channel_0, LampCh0_Rmtlock, Lamp_Off);	
				}
			}
			else
			{
				LED_Driver_Channel_Set(Channel_0, LampCh0_Rmtlock, Lamp_Off);	
			}
		}
	}
	else if(Val_EOL_F101_Engine() == 3)
	{
		LockVeh_Sts = 0;
		EMSLockVeh_Sts = 0;
		if(g_u8SelfLampTimes < LED_SELF_CHECK_TIME)
		{
			LED_Driver_Channel_Set(Channel_0, LampCh0_Rmtlock, Lamp_On);	
		}
		else
		{
			if(SYS_OPR_STAT_IGN_ON)
			{
				if(CANMsg_18FF0800_Status.BIT.Function_Lost == CAN_MSG_LOST)
				{
					if(LockVeh_Sts_Flg)
					{
						LED_Driver_Channel_Set(Channel_0, LampCh0_Rmtlock, Lamp_On);	
					}
					else
					{
						LED_Driver_Channel_Set(Channel_0, LampCh0_Rmtlock, Lamp_Off);	
					}
				}
				else
				{
					if(WeichaiEMS_LockVeh_Sts == 1)
					{
						LockVeh_Sts_Flg = 1;
					}
					else
					{
						LockVeh_Sts_Flg = 0;			
					}
					if(LockVeh_Sts_Flg)
					{
						LED_Driver_Channel_Set(Channel_0, LampCh0_Rmtlock, Lamp_On);	
					}
					else
					{
						LED_Driver_Channel_Set(Channel_0, LampCh0_Rmtlock, Lamp_Off);	
					}
				}
			}
			else
			{
				LED_Driver_Channel_Set(Channel_0, LampCh0_Rmtlock, Lamp_Off);		
			}
		}		
	}
	else
	{
		LockVeh_Sts = 0;
		LockVeh_Sts_Flg = 0;
		EMSLockVeh_Sts = 0;	
		LED_Driver_Channel_Set(Channel_0, LampCh0_Rmtlock, Lamp_Off);			
	}
}
// 35  ������ָֹͣʾ�ƣ������
void Engine_Stop_Lamp(void)
{
	if (Val_EOL_F101_Engine() == 1)	 //����
	{
		LED_Driver_Channel_Set(Channel_0, LampCh0_EngStop, Lamp_Off);
	}
	else if((Val_EOL_F101_Engine() == 2)|| (Val_EOL_F101_Engine() == 3))    //����˹	  Ϋ��
	{
		if (g_u8SelfLampTimes < LED_SELF_CHECK_TIME)
		{
			LED_Driver_Channel_Set(Channel_0, LampCh0_EngStop, Lamp_On);
		}
		else
		{
			if (SYS_OPR_STAT_IGN_ON)
			{
				if(CANMsg_18FD0700_5s_Status.Lost == CAN_MSG_LOST)
				{
					LED_Driver_Channel_Set(Channel_0, LampCh0_EngStop, Lamp_On);
				}
				else
				{
					if(CANMsg_18FD0700_5s.BIT.EMS_RedStopLamp == 1)
					{
						LED_Driver_Channel_Set(Channel_0, LampCh0_EngStop, Lamp_On);
					}
					else
					{
						LED_Driver_Channel_Set(Channel_0, LampCh0_EngStop, Lamp_Off);
					}
				}
			}
			else
			{
				LED_Driver_Channel_Set(Channel_0, LampCh0_EngStop, Lamp_Off);
			}
		}
	}
	else
	{
		LED_Driver_Channel_Set(Channel_0, LampCh0_EngStop, Lamp_Off);  
	}
}


//37  EPB���ϵƣ������
void EPB_Lamp(void)
{
	if (Val_EOL_F110_EPB_Air() == 1)
	{
		if (g_u8SelfLampTimes < LED_SELF_CHECK_TIME)
		{
			LED_Driver_Channel_Set(Channel_0, LampCh0_EPB, Lamp_On);
		}
		else
		{
			if (SYS_OPR_STAT_IGN_ON)
			{
				if (CANMsg_18FFB88F_Status.BIT.Function_Lost == CAN_MSG_LOST)
				{
					LED_Driver_Channel_Set(Channel_0, LampCh0_EPB, Lamp_On);
				}
				else
				{
					if ((EPB_Flt_Level == 1) || (EPB_Flt_Level == 2) || (EPB_Flt_Level == 3))
					{
						LED_Driver_Channel_Set(Channel_0, LampCh0_EPB, Lamp_On);
					}
					else
					{
						LED_Driver_Channel_Set(Channel_0, LampCh0_EPB, Lamp_Off);
					}
				}
			}
			else
			{
				LED_Driver_Channel_Set(Channel_0, LampCh0_EPB, Lamp_Off);
			}
		}
	}
	else
	{
		LED_Driver_Channel_Set(Channel_0, LampCh0_EPB, Lamp_Off);
	}
}
//38  DMS���ϵƣ������
void DMS_Lamp(void)
{
	if (Val_EOL_F110_DMM() == 1)
	{
		if (g_u8SelfLampTimes < LED_SELF_CHECK_TIME)
		{
			LED_Driver_Channel_Set(Channel_1, LampCh1_FtgSys_Flt, Lamp_On);
		}
		else
		{
			if (SYS_OPR_STAT_IGN_ON)
			{
				if (CANMsg_18FAD084_Status.BIT.Function_Lost == CAN_MSG_LOST)
				{
					LED_Driver_Channel_Set(Channel_1, LampCh1_FtgSys_Flt, Lamp_On);
				}
				else
				{
					if ( (DMM_System_Fault == 1)&&(DMM_Valid) )
					{
						LED_Driver_Channel_Set(Channel_1, LampCh1_FtgSys_Flt, Lamp_On);
					}
					else
					{
						LED_Driver_Channel_Set(Channel_1, LampCh1_FtgSys_Flt, Lamp_Off);
					}
				}
			}
			else
			{
				LED_Driver_Channel_Set(Channel_1, LampCh1_FtgSys_Flt, Lamp_Off);
			}
		}
	}
	else
	{
		LED_Driver_Channel_Set(Channel_1, LampCh1_FtgSys_Flt, Lamp_Off);
	}
}

//39  DMS�رգ������
void DMS_Off_Lamp(void)
{
	if (Val_EOL_F110_DMM() == 1)
	{
		if (g_u8SelfLampTimes < LED_SELF_CHECK_TIME)
		{
			LED_Driver_Channel_Set(Channel_1, LampCh1_FtgSys_Off, Lamp_On);
		}
		else
		{
			if (SYS_OPR_STAT_IGN_ON)
			{
				if (CANMsg_18FAD084_Status.BIT.Function_Lost == CAN_MSG_LOST)
				{
					LED_Driver_Channel_Set(Channel_1, LampCh1_FtgSys_Off, Lamp_On);
				}
				else
				{
					if ((DMM_Work_Sts != 1)&&(DMM_Valid) )
					{
						LED_Driver_Channel_Set(Channel_1, LampCh1_FtgSys_Off, Lamp_On);
					}
					else
					{
						LED_Driver_Channel_Set(Channel_1, LampCh1_FtgSys_Off, Lamp_Off);
					}
				}
			}
			else
			{
				LED_Driver_Channel_Set(Channel_1, LampCh1_FtgSys_Off, Lamp_Off);
			}
		}
	}
	else
	{
		LED_Driver_Channel_Set(Channel_1, LampCh1_FtgSys_Off, Lamp_Off);
	}
}

//39  �ƶ� Һλ��
void BrakeLiquid_Low_Lamp(void)
{
	if (g_u8SelfLampTimes < LED_SELF_CHECK_TIME)
	{
		LED_Driver_Channel_Set(Channel_0, LampCh0_BrakeLiquid_Low, Lamp_On);
	}
	else
	{
		if (SYS_OPR_STAT_IGN_ON)
		{
			if (Line_In_Get_Status(LINE_IN_BrakeLiquid))
			{
				LED_Driver_Channel_Set(Channel_0, LampCh0_BrakeLiquid_Low, Lamp_On);
			}
			else
			{
				LED_Driver_Channel_Set(Channel_0, LampCh0_BrakeLiquid_Low, Lamp_Off);
			}
		}
		else
		{
			LED_Driver_Channel_Set(Channel_0, LampCh0_BrakeLiquid_Low, Lamp_Off);
		}
	}
}

//41  ǰ��ײԤ��ָʾ��
void FCW_On_Fft_Lamp(void)
{
	if ((Val_EOL_F110_FCS() == 1) && (Val_EOL_F101_FCW_AEB() == 2))
	{
		if (g_u8SelfLampTimes < LED_SELF_CHECK_TIME)
		{
			LED_Driver_Channel_Set(Channel_0, LampCh0_FCW_Flt_Y, Lamp_Off);
			LED_Driver_Channel_Set(Channel_0, LampCh0_FCW_Open_G, Lamp_On);
		}
		else
		{
			if (SYS_OPR_STAT_IGN_ON)
			{
				if (CANMsg_0CF02FA0_Status.BIT.Function_Lost == CAN_MSG_LOST)
				{
					LED_Driver_Channel_Set(Channel_0, LampCh0_FCW_Flt_Y, Lamp_On);
					LED_Driver_Channel_Set(Channel_0, LampCh0_FCW_Open_G, Lamp_Off);
				}
				else
				{
					if ((FCS_AEB_State == 0) || (FCS_AEB_State == 1) || (FCS_AEB_State == 3) ||
						(FCS_AEB_State == 4) || (FCS_AEB_State == 5) || (FCS_AEB_State == 6) || (FCS_AEB_State == 7))
					{
						LED_Driver_Channel_Set(Channel_0, LampCh0_FCW_Flt_Y, Lamp_Off);
						LED_Driver_Channel_Set(Channel_0, LampCh0_FCW_Open_G, Lamp_On);
					}
					else if ((FCS_AEB_State == 0xE) || (FCS_AEB_State == 0xF))
					{
						LED_Driver_Channel_Set(Channel_0, LampCh0_FCW_Flt_Y, Lamp_On);
						LED_Driver_Channel_Set(Channel_0, LampCh0_FCW_Open_G, Lamp_Off);
					}
					else
					{
						LED_Driver_Channel_Set(Channel_0, LampCh0_FCW_Flt_Y, Lamp_Off);
						LED_Driver_Channel_Set(Channel_0, LampCh0_FCW_Open_G, Lamp_Off);
					}
				}
			}
			else
			{
				LED_Driver_Channel_Set(Channel_0, LampCh0_FCW_Flt_Y, Lamp_Off);
				LED_Driver_Channel_Set(Channel_0, LampCh0_FCW_Open_G, Lamp_Off);
			}
		}
	}
	else
	{
		LED_Driver_Channel_Set(Channel_0, LampCh0_FCW_Flt_Y, Lamp_Off);
		LED_Driver_Channel_Set(Channel_0, LampCh0_FCW_Open_G, Lamp_Off);
	}
}

//42 ǰ��ײԤ���ر�ָʾ��
void FCW_OFF_Lamp(void)
{
	if ((Val_EOL_F110_FCS() == 1) && (Val_EOL_F101_FCW_AEB() == 2))
	{
		if (g_u8SelfLampTimes < LED_SELF_CHECK_TIME)
		{
			LED_Driver_Channel_Set(Channel_0, LampCh0_FCW_Off, Lamp_On);
		}
		else
		{
			if (SYS_OPR_STAT_IGN_ON)
			{
				if (CANMsg_0CF02FA0_Status.BIT.Function_Lost == CAN_MSG_LOST)
				{
					LED_Driver_Channel_Set(Channel_0, LampCh0_FCW_Off, Lamp_Off);
				}
				else
				{
					if (FCS_AEB_State == 2)
					{
						LED_Driver_Channel_Set(Channel_0, LampCh0_FCW_Off, Lamp_On);
					}
					else
					{
						LED_Driver_Channel_Set(Channel_0, LampCh0_FCW_Off, Lamp_Off);
					}
				}
			}
			else
			{
				LED_Driver_Channel_Set(Channel_0, LampCh0_FCW_Off, Lamp_Off);
			}
		}
	}
	else
	{
		LED_Driver_Channel_Set(Channel_0, LampCh0_FCW_Off, Lamp_Off);
	}
}

//42 ��������ָʾ��
void Emptyfilter_Block_Lamp(void)	    
{
	if (Val_EOL_F101_Engine() == 2)    //����˹
	{
		if (g_u8SelfLampTimes < LED_SELF_CHECK_TIME)
		{
			LED_Driver_Channel_Set(Channel_1, LampCh1_Emptyfilter_Block, Lamp_On);
		}
		else								   
		{
			if (SYS_OPR_STAT_IGN_ON)
			{
				if (Line_In_Get_Status(LINE_IN_Emptyfilter_Block) )
				{
					LED_Driver_Channel_Set(Channel_1, LampCh1_Emptyfilter_Block, Lamp_On);
				}
				else
				{
					LED_Driver_Channel_Set(Channel_1, LampCh1_Emptyfilter_Block, Lamp_Off);
				}
			}
			else
			{
				LED_Driver_Channel_Set(Channel_1, LampCh1_Emptyfilter_Block, Lamp_Off);
			}
		}
	}
	else
	{
		LED_Driver_Channel_Set(Channel_1, LampCh1_Emptyfilter_Block, Lamp_Off);
	}
}

//43 ASRָʾ��
void ASR_Lamp(void)
{
	if((Val_EOL_F110_EPB_Air() == 1)&&(Val_EOL_F101_ASR() == 2 ) )   //��ɲ
	{
		if (g_u8SelfLampTimes < LED_SELF_CHECK_TIME)
		{
			LED_Driver_Channel_Set(Channel_1, LampCh1_ASR, Lamp_On);
		}
		else
		{
			if (SYS_OPR_STAT_IGN_ON)
			{
				if (CANMsg_18F0010B_Status.BIT.Function_Lost == CAN_MSG_LOST)
				{
					LED_Driver_Channel_Set(Channel_1, LampCh1_ASR, Lamp_On);
				}
				else
				{
					if((EBS_ATC_ASRLamp_State != 1 ) &&(EBS_ASREngineControl_Active != 1)&&(EBS_ASRBrakeControl_Active != 1))
					{
					  	LED_Driver_Channel_Set(Channel_1, LampCh1_ASR, Lamp_Off);
					}
					else
					{
						if(EBS_ATC_ASRLamp_State == 1)
						{
							LED_Driver_Channel_Set(Channel_1, LampCh1_ASR, Lamp_On);	
						}
						else if(EBS_ASREngineControl_Active == 1)
						{
							LED_Driver_Channel_Set(Channel_1, LampCh1_ASR, Lamp_Blink_2Hz);	
						}
						else if (EBS_ASRBrakeControl_Active == 1)
						{
							LED_Driver_Channel_Set(Channel_1, LampCh1_ASR, Lamp_Blink_2Hz);	
						}
						else
						{
							
						}
					}
				}
			}
			else
			{
				LED_Driver_Channel_Set(Channel_1, LampCh1_ASR, Lamp_Off);
			}
		}
	}
	else
	{
		LED_Driver_Channel_Set(Channel_1, LampCh1_ASR, Lamp_Off);
	}
}

//44 ECOָʾ��
void ECO_Lamp(void)
{
	if((Val_EOL_F101_Engine() == 1)||(Val_EOL_F101_Engine() == 3))    //���� Ϋ��	  PTO_Swt_st
	{
		if (SYS_OPR_STAT_IGN_ON)
		{
			if (CANMsg_18FF2200_Status.BIT.Function_Lost == CAN_MSG_LOST)
			{
				LED_Driver_Channel_Set(Channel_1, LampCh1_ECO, Lamp_Off);
			}
			else
			{
				if(PTO_Swt_st == 2)
				{
					LED_Driver_Channel_Set(Channel_1, LampCh1_ECO, Lamp_On);
				}
				else
				{
					LED_Driver_Channel_Set(Channel_1, LampCh1_ECO, Lamp_Off);	
				}
			}
		}
		else
		{
			LED_Driver_Channel_Set(Channel_1, LampCh1_ECO, Lamp_Off);	
		}
	}
	else
	{
		LED_Driver_Channel_Set(Channel_1, LampCh1_ECO, Lamp_Off);
	}
}

//45 ��ʻ��δ��ָֹʾ��
void CabLock_Lamp(void)
{
	if (SYS_OPR_STAT_IGN_ON)
	{
		if(Line_In_Get_Status(LINE_IN_CabLock) ) 	       
		{
			LED_Driver_Channel_Set(Channel_0, LampCh0_Not_CabLock, Lamp_On);
		}
		else
		{
			LED_Driver_Channel_Set(Channel_0, LampCh0_Not_CabLock, Lamp_Off);
		}
	}
	else
	{
		LED_Driver_Channel_Set(Channel_0, LampCh0_Not_CabLock, Lamp_Off);
	}
}

//46 ASR�ر�ָʾ��
void ASROff_Lamp(void)
{
	if((Val_EOL_F110_EPB_Air() == 1)&&(Val_EOL_F101_ASR() == 2 ) )   //��ɲ
	{
		if (g_u8SelfLampTimes < LED_SELF_CHECK_TIME)
		{
			LED_Driver_Channel_Set(Channel_1, LampCh1_ASR_Off, Lamp_On);
		}
		else
		{
			if (SYS_OPR_STAT_IGN_ON)
			{
				if (CANMsg_18F0010B_Status.BIT.Function_Lost == CAN_MSG_LOST)
				{
					LED_Driver_Channel_Set(Channel_1, LampCh1_ASR_Off, Lamp_On);     	
				}
				else
				{
					if(EBS_TractionControlOverride_Switch == 1)
					{
						LED_Driver_Channel_Set(Channel_1, LampCh1_ASR_Off, Lamp_On);   	
					}
					else
					{
						LED_Driver_Channel_Set(Channel_1, LampCh1_ASR_Off, Lamp_Off);   	
					}
				}
			}
			else
			{
				LED_Driver_Channel_Set(Channel_1, LampCh1_ASR_Off, Lamp_Off);   		
			}
		}
	}
	else
	{
		LED_Driver_Channel_Set(Channel_1, LampCh1_ASR_Off, Lamp_Off);   	
	}
}

//47 ��������״ָ̬ʾ�ƣ����ߣ�
void TBOX_OnLine_Lamp(void)
{
	if(Val_EOL_F101_TBOX() == 1u) 
	{
		if (g_u8SelfLampTimes < LED_SELF_CHECK_TIME)
		{
			LED_Driver_Channel_Set(Channel_1, LampCh1_TBOX_OnLine, Lamp_On);
		}
		else
		{
			if (SYS_OPR_STAT_IGN_ON)
			{
				if (CANMsg_18FF789F_Status.BIT.Function_Lost == CAN_MSG_LOST)
				{
					LED_Driver_Channel_Set(Channel_1, LampCh1_TBOX_OnLine, Lamp_Off);     	
				}
				else
				{
					if(TBOX_LineDiscnt_Sts == 1)
					{
						LED_Driver_Channel_Set(Channel_1, LampCh1_TBOX_OnLine, Lamp_On); 
					}
					else
					{
						LED_Driver_Channel_Set(Channel_1, LampCh1_TBOX_OnLine, Lamp_Off);  
					}
				}
			}
			else
			{
				LED_Driver_Channel_Set(Channel_1, LampCh1_TBOX_OnLine, Lamp_Off);   	
			}
		}	
	}
	else
	{
		LED_Driver_Channel_Set(Channel_1, LampCh1_TBOX_OnLine, Lamp_Off);   		
	}
}

//48 ��������״ָ̬ʾ�ƣ������ߣ�
void TBOX_LostLine_Lamp(void)
{
         if(Val_EOL_F101_TBOX() == 1u) 
         {
         	if (g_u8SelfLampTimes < LED_SELF_CHECK_TIME)
		{
			LED_Driver_Channel_Set(Channel_1, LampCh1_TBOX_LostLine, Lamp_On);
		}
		else
		{
			if (SYS_OPR_STAT_IGN_ON)
			{
				if (CANMsg_18FF789F_Status.BIT.Function_Lost == CAN_MSG_LOST)
				{
					LED_Driver_Channel_Set(Channel_1, LampCh1_TBOX_LostLine, Lamp_On);
				}
				else
				{
					if(TBOX_LineDiscnt_Sts == 0)
					{
						LED_Driver_Channel_Set(Channel_1, LampCh1_TBOX_LostLine, Lamp_On);  	
					}
					else
					{
						LED_Driver_Channel_Set(Channel_1, LampCh1_TBOX_LostLine, Lamp_Off);  	 		
					}
				}
			}
			else
			{
				LED_Driver_Channel_Set(Channel_1, LampCh1_TBOX_LostLine, Lamp_Off);  	 	
			}
		}	
        	}
        	else
        	{
        		LED_Driver_Channel_Set(Channel_1, LampCh1_TBOX_LostLine, Lamp_Off);  		
        	}	
}

 #endif
void Close_All_Lamps(void)
{
	uint8_t i=0;
	for ( i = 0; i < 36; i++)
	{
		LED_Driver_Channel_Set(Channel_0, i, Lamp_Off);
		LED_Driver_Channel_Set(Channel_1, i, Lamp_Off);
	}
	
	// LED_Driver_Channel_Set(Channel_0, LampCh0_Rmtlock, Lamp_Off);
	// LED_Driver_Channel_Set(Channel_0, LampCh0_RightTurn, Lamp_Off);

	// LED_Driver_Channel_Set(Channel_0, LampCh0_Low_Beam, Lamp_Off);
	// LED_Driver_Channel_Set(Channel_0, LampCh0_Low_DC_DC, Lamp_Off);
	// LED_Driver_Channel_Set(Channel_0, LampCh0_DriverSafeBelt, Lamp_Off);

	// LED_Driver_Channel_Set(Channel_0, LampCh0_EngOilPress, Lamp_Off);
	// LED_Driver_Channel_Set(Channel_0, LampCh0_BatChargeConnect, Lamp_Off);
	// LED_Driver_Channel_Set(Channel_0, LampCh0_Motor_Failure, Lamp_Off);
	// LED_Driver_Channel_Set(Channel_0, LampCh0_EPB, Lamp_Off);
	// LED_Driver_Channel_Set(Channel_0, LampCh0_BatteryTempHigh, Lamp_Off);

	// LED_Driver_Channel_Set(Channel_0, LampCh0_Oillow_W, Lamp_Off);
	// LED_Driver_Channel_Set(Channel_0, LampCh0_Oillow, Lamp_Off);
	// LED_Driver_Channel_Set(Channel_0, LampCh0_BatteryTempLow, Lamp_Off);
	// LED_Driver_Channel_Set(Channel_0, LampCh0_BatteryFault, Lamp_Off);
	// LED_Driver_Channel_Set(Channel_0, LampCh0_Door_NotClosed, Lamp_Off);

	// LED_Driver_Channel_Set(Channel_0, LampCh0_Ready, Lamp_Off);
	
	// LED_Driver_Channel_Set(Channel_0, LampCh0_BatteryCutOff, Lamp_Off);
	// LED_Driver_Channel_Set(Channel_0, LampCh0_Brake_Fluid_Low, Lamp_Off);
	// LED_Driver_Channel_Set(Channel_0, LampCh0_EBS, Lamp_Off);
	// LED_Driver_Channel_Set(Channel_0, LampCh0_ChargeBatterySta, Lamp_Off);
	// LED_Driver_Channel_Set(Channel_0, LampCh0_BatteryLow_W, Lamp_Off);

	// LED_Driver_Channel_Set(Channel_0, LampCh0_BatteryLow_Y, Lamp_Off);
	// LED_Driver_Channel_Set(Channel_0, LampCh0_AVAS, Lamp_Off);
	// LED_Driver_Channel_Set(Channel_0, LampCh0_DriverNotClosed, Lamp_Off);
	// LED_Driver_Channel_Set(Channel_0, LampCh0_TPMS, Lamp_Off);
	// LED_Driver_Channel_Set(Channel_0, LampCh0_AirBag, Lamp_Off);

	// LED_Driver_Channel_Set(Channel_1, LampCh1_AutoHold_G, Lamp_Off);
	// LED_Driver_Channel_Set(Channel_1, LampCh1_Water_Pump_Fault, Lamp_Off);
	// LED_Driver_Channel_Set(Channel_1, LampCh1_CC_Cruise_Control, Lamp_Off);

	// LED_Driver_Channel_Set(Channel_1, LampCh1_CC_Overtake, Lamp_Off);
	// LED_Driver_Channel_Set(Channel_1, LampCh1_Limit_Power_Lamp, Lamp_Off);
	// LED_Driver_Channel_Set(Channel_1, LampCh1_ESC_Active, Lamp_Off);
	// LED_Driver_Channel_Set(Channel_1, LampCh1_ESC_Off, Lamp_Off);
	// LED_Driver_Channel_Set(Channel_1, LampCh1_High_DC_DC, Lamp_Off);

	// LED_Driver_Channel_Set(Channel_1, LampCh1_Position, Lamp_Off);
	// LED_Driver_Channel_Set(Channel_1, LampCh1_DayRunning, Lamp_Off);
	// LED_Driver_Channel_Set(Channel_1, LampCh1_FrontFog, Lamp_Off);
	// LED_Driver_Channel_Set(Channel_1, LampCh1_RearFog, Lamp_Off);
	// LED_Driver_Channel_Set(Channel_1, LampCh1_HighBeam, Lamp_Off);

	// LED_Driver_Channel_Set(Channel_1, LampCh1_EPS, Lamp_Off);
	// LED_Driver_Channel_Set(Channel_1, LampCh1_LeftTurn, Lamp_Off);
	// LED_Driver_Channel_Set(Channel_1, LampCh1_Tired_Sys_Closed, Lamp_Off);
	// LED_Driver_Channel_Set(Channel_1, LampCh1_ABS, Lamp_Off);
	// LED_Driver_Channel_Set(Channel_1, LampCh1_ACU, Lamp_Off);

	// LED_Driver_Channel_Set(Channel_1, LampCh1_Insulation_Fault, Lamp_Off);
	// LED_Driver_Channel_Set(Channel_1, LampCh1_Engine_System_Failt, Lamp_Off);
	// LED_Driver_Channel_Set(Channel_1, LampCh1_Engine_Emission_Failt, Lamp_Off);
	// LED_Driver_Channel_Set(Channel_1, LampCh1_Maint, Lamp_Off);
	// LED_Driver_Channel_Set(Channel_1, LampCh1_CooltLiquid_High_W, Lamp_Off);

	// LED_Driver_Channel_Set(Channel_1, LampCh1_CooltLiquid_High, Lamp_Off);
	// LED_Driver_Channel_Set(Channel_1, LampCh1_AutoHold_R, Lamp_Off);
	// LED_Driver_Channel_Set(Channel_1, LampCh1_Electronic_parking, Lamp_Off);
	// LED_Driver_Channel_Set(Channel_1, LampCh1_Brake_System_Failure, Lamp_Off);
	// LED_Driver_Channel_Set(Channel_1, LampCh1_EHPS, Lamp_Off);

	// LED_Driver_Channel_Set(Channel_1, LampCh1_ASR_Off, Lamp_Off);
	// LED_Driver_Channel_Set(Channel_1, LampCh1_ASR_Lamp, Lamp_Off);
	// LED_Driver_Channel_Set(Channel_1, LampCh1_Vehicle_Online_G, Lamp_Off);
	// LED_Driver_Channel_Set(Channel_1, LampCh1_Vehicle_Online_Sta, Lamp_Off);
    // 	LED_Driver_Channel_Set(Channel_1, LampCh1_System_Failt_Lamp, Lamp_Off);   
     		
 }



void Lamp_Init(void)
{
	g_u8SelfLampTimes = 0;
	Airbag_LampTimes = 0;
	ACU_LampTimes = 0;
	Trye_Lamp.StmFlt_timer1 = 0;
	Trye_Lamp.StmFlt_timer3 = 0;
	Trye_Lamp.StmFlt_timerlost = 0;
}


void Lamp_Management_Service(void)
{
	if ((SYS_OPR_STAT_HALT)||(Bus_Sleep_Mode_Delay_Time >= BusSleep_Wait_Mode_Time))
	{
		Close_All_Lamps();
		return;
	}
	
	if (SYS_OPR_STAT_IGN_ON)
	{
		if (g_u8SelfLampTimes < LED_SELF_CHECK_TIME)
		{
			g_u8SelfLampTimes++;
		}
		else
		{
			g_u8SelfLampTimes = LED_SELF_CHECK_TIME;
		}
	}
	else
	{
		g_u8SelfLampTimes = LED_SELF_CHECK_TIME;
	}

	//��ת
	RightTurn_Lamp();
	//��ת
	LeftTurn_Lamp();

	//����ָʾ��
	LowBeam_Lamp();
	//Զ��ָʾ��
	HighBeam_Lamp();
    //ǰ����
    FrontFog_Lamp();
	//������ָʾ
	RearFog_Lamp();
	//�ռ��г���
	Running_Lamp();
	//λ�õ�
	Position_Lamp();

	//��ѹDCDC����
    Low_DC_DC_Lamp();
	//�ƶ�ϵͳ����ָʾ��
	Brake_System_Failure_Lamp();
	//����פ��
	Electronic_parking_Lamp();
	//ABS
	ABS_Lamp();
    //�Զ�פ���ƣ������
	AutoHold_Lamp();
	//READYָʾ��
    READY_Lamp();
	//ˮ��ָʾ��
	EWP_Lamp();
    //�������ָʾ��
	Motor_Failure_Lamp();
	//��ѹDCDC����
    High_DC_DC_Lamp();
	//������ع���
	BatteryFault_Lamp();
    //��������жϹ���
    BatteryCutOff_Lamp();
	//������ص�����
	BatteryLow_Lamp();
	//��������¶ȸ�
	BatteryTempHigh_Lamp();
	//��������¶ȵ�
	BatteryTempLow_Lamp();
	//���״ָ̬ʾ��
    	ChargeBatterySta_Lamp();
	// �������ָʾ��
	BatChargeConnect_Lamp();
	//�޹���ָʾ��
	Limit_Power_Lamp();
	//��ѹϵͳ���ϱ�����
	System_Failt_Lamp();
    //��Ե����ָʾ��
	Insulation_Fault_Lamp();
	//���ݰ�ȫ��δϵ������
 	SafeBelt_Lamp();
	Airbag_Lamp();
	//Get_Airbag_Fault_Service();
	ACU_Lamp();
	//̥ѹϵͳ���ϵ�
 	TPMS_Lamp();
	//����δ��ָʾ��
 	DoorOpen_Lamp();
	//ά�ޱ�����
 	Maint_Lamp();
	//Զ������ָʾ��
 	Rmtlock_Lamp();
	//��ʻ��δ��ָʾ��
 	DriverNotClosed_Lamp();
	//AVAS����ָʾ��
 	AVAS_Lamp();
	Tired_Sys_Fault_Lamp();
	//��ƣ��ϵͳ�ر�ָʾ��
 	Tired_Sys_Closed_Lamp();
	//�ƶ�Һλ�ͱ�����
 	Brake_Fluid_Low_Lamp();
	//EPB���ϱ�����
 	EPB_Lamp();
	//EPS���ϱ�����
 	EPS_Lamp();
	//ESC����/���ϵ�
 	ESC_Active_Lamp();
	//ESC OFF
 	ESC_OFF_Lamp();
	EBS_Lamp();
	//EHPS������
 	EHPS_Lamp();
	//CC������������ָʾ��
 	CC_Cruise_Control_Lamp();
	//CC Override 
 	CC_Overtake_Lamp();
	//TBOX����״̬
 	Vehicle_Online_Sta_Lamp();

	Oil_Low_Warning_Lamp();
	Coolant_TempHigh_Lamp();
	OilPressure_Low_Lamp();
	Engine_Sys_Fault_Lamp();
	Engine_Emission_Fault_Lamp();
	ASR_Lamp();
	ASR_Off_Lamp();
	#if 0
	//���س��״ָ̬ʾ��
	BatteryCharge_Lamp();

	//ȼ�����ͱ�����
	//FuelWarning_Lamp();
	//��ȴҺ�¶ȱ�����
	//CoolantWarning_Lamp();
	//����ѹ��ָʾ��
	//OilPressure_Lamp();
	//11  ������һ�����ָʾ��
	//Engine_General_Fault_Lamp();
	//OBD�������ŷŹ���
	//OBD_EngineEmissionFault();

	
	//15פ���ƶ�
	Parking_Brake_Lamp();
	
	//17��ȫ��δϵ
	Safe_Belt_Warning_Processing();
	// 18  �ƶ���Ƭĥ���
	BrakeShoeWear_Lamp();
	
	//20̥ѹ
	TirePressure_Lamp();

	//22LDWS
	LDWS_Lamp();
	//23.����
	Maint_LAMP();
	//24����Ѳ��ָʾ��
	Cruise_Lamp();
	//25������ͣ��ָʾ��
	Engine_Wait_StartStop_Lamp();
	//26����
	LowUreaLevel_Lamp();
	//27��ˮ����ָʾ��
	OilWaterSeparation_Lamp();
	//28.DPF����ָʾ��
	DPF_Lamp();
	//29.DPF������ָֹʾ��
	DPF_Forbidden_Lamp();
	//30  �����¶ȸ߱�����
	Exhaust_temHigh_Lamp();
	//31 �����ƶ�ָʾ��
	ExhaustBrake_Lamp();
	//32 PTOָʾ�� (Ԥ��)
	//PTO_Lamp();
	//33 ��ʻԱϵͳ�����
	DriverSystemWarning_Lamp();
	//34  Զ��������
	Remotely_LockCar_Lamp();
	// 35  ������ָֹͣʾ�ƣ������
	Engine_Stop_Lamp();
	//36  �Զ�פ���ƣ������
	AutoHold_Lamp();
	//37  EPB���ϵƣ������
	EPB_Lamp();
	//38  DMS���ϵƣ������
	DMS_Lamp();
	//39  DMS���ϵƣ������
	DMS_Off_Lamp();
	//40  �ƶ�Һλ��
	//BrakeLiquid_Low_Lamp();
	//41ǰ��ײԤ������/����ָʾ��
	FCW_On_Fft_Lamp();
	//42 ǰ��ײԤ���ر�ָʾ��
	FCW_OFF_Lamp();
	//42 ��������ָʾ��
	Emptyfilter_Block_Lamp();
	//43  ASRָʾ��	
	ASR_Lamp();
	//44  ECOָʾ��	
	ECO_Lamp();
	//45 ��ʻԱδ��ָֹʾ��	
	CabLock_Lamp();
	//46 ASR�ر�ָʾ��
	ASROff_Lamp();	
	//47 48��������״ָ̬ʾ�ƣ����ߣ�
	TBOX_OnLine_Lamp();
	//48��������״ָ̬ʾ�ƣ������ߣ�
	TBOX_LostLine_Lamp();	
	#endif
}
