/**************************************************************************//**
  * \file      Analog_Signals.h
  * \brief     Analog signal processing
  * \attention
  *
  * This file is automatically generated by analog signals configuration tool.
  * Date         : 2022/11/30 10:31:26
  * Cfg Tool Ver : 1.1.0
  * Engineer     : YZHD
  * (c) Heilongjiang TYW electronics co., LTD
  *
******************************************************************************/

#ifndef _ANALOG_SIGNALS_H_
#define _ANALOG_SIGNALS_H_

/* Includes -----------------------------------------------------------------*/
#include "ADC.h"
#include "Analog_Circuits.h"

/* C binding of definitions if building with C++ compiler */
#ifdef __cplusplus
extern  {
#endif
/*! @{ */

/* Exported types ------------------------------------------------------------*/
enum ADCChName
{
    ADC_CH_KL30_V = 0,
    ADC_CH_KL15_V,
    ADC_CH_AIR_PRESSURE_1,
    ADC_CH_AIR_PRESSURE_2,
    ADC_CH_FUEL1_R,
    ADC_CH_KEY_R,
    ADC_CH_CH3_R,
};

/* Exported macro ------------------------------------------------------------*/
#define   ADC_TOTAL_CH_NUMBER               (7U)
#define   ADC_SIGNAL_CH_NUMBER  ADC_TOTAL_CH_NUMBER              
#define   ADC_REF_VOLTAGE                   u16ADCRefVoltage

/* Exported variables --------------------------------------------------------*/
extern volatile uint16_t u16ADCRefVoltage;

/* Exported functions --------------------------------------------------------*/
extern void Analog_Signal_Conv_Init(void);
extern void Analog_Signal_Conv_Stop(void);

extern void Analog_Signal_Conv_Service(void);

extern uint16_t ADC_Read_Signal(uint8_t u8ADCCh);
extern uint8_t  ADC_Read_Signal_Valid(uint8_t u8ADCCh);
uint16_t ADC_Conv_Single_Channel(uint8_t u8ADCCh);


/*! @} */
#ifdef __cplusplus
}
#endif

#endif /* _ANALOG_SIGNALS_H_ */