
#include "Include.h"

uint8_t Sleep_Timer_100ms = 0;
uint8_t CAN_Timer_100ms = 0;


void WDT_Init(void)
{

  wdt_reset();
  COPCTL     = WDT_PERIOD;    
  PLLCTL_PCE = 1;          
}

void WDT_Reset_Service(void)
{
  wdt_reset();
}

void bsp_Clk_Init(void)
{
    INT32U  dwTime = 0;
    
    MODE = 0x80;            //QTC 2016-11-16
    
    CLKSEL_PLLSEL  = 0;
    PLLCTL_PLLON   = 0;
    
    SYNR       = 0x43;               //?????
    REFDV      = 0x80;               //??????  2??
    POSTDIV    = 0x00;               //??????
    
    PLLCTL_PLLON = 1;
    
    while(!CRGFLG_LOCK)  ;            //??????
    //{
    //    dwTime++;
    //    
    //    if(dwTime > 15000)
    //    {
    //        break;
    //    }
    //}
    if (FCLKDIV == 0)
    FCLKDIV = 0x07;           //FCLK = OSCCLK / 7 = 8M / 7 = 1.1238MHz

    DFPROT = 0xFF;              //Disable any protection set on DFlash        

    
    COPCTL     = 0x47;               //?????
    PLLCTL_PRE     = 1;                  //1 RTI continues running during Pseudo Stop Mode.
    PLLCTL_PCE     = 1;                  //1 COP continues running during Pseudo Stop Mode
    PLLCTL_SCME    = 0;     //QTC 2016-11-6
    PLLCTL_CME     = 1;     //QTC 2016-11-6
    //PLLCTL_FM      = 3;     //4%
    
    CLKSEL_PLLSEL  = 1;             //1 System clocks are derived from PLLCLK (fBUS = fPLL / 2).
    CLKSEL_PSTP    = 1;             //???????????
    CLKSEL_RTIWAI  = 0;                  //RTI WAIT??????
    CLKSEL_COPWAI  = 0;                  //0 COP keeps running in Wait Mode.
    CLKSEL_PLLWAI  = 0;                  //0 IPLL keeps running in Wait Mode.
    
    VREGHTCL      = 0;              //??????
    //??
    CRGINT_SCMIE  = 0;              //Osc
    CRGINT_LOCKIE = 0;              //Lock
    //RTI
    RTICTL_RTDEC  = 1;                    //???
    RTICTL_RTR    = 0x5F;                 //200*10^3  4M:0x53;
    
   // CRGINT_RTIE   = 1;               //RTI
    VREGCTRL_LVIE = 0;               //LV
    IRQCR         = 0;              //IRQ
}   
   
  //
void Clock_Init(void)              //    INT8U onoff        if(onoff==0)     return;
{
          bsp_Clk_Init();
           /*
          return;
          
        //????OSCCLK??????
        CLKSEL = 0x00;

        //?????????
        PLLCTL_SCME = 0;
        PLLCTL_CME  = 1;

        //             (SYNDIV+1)
        //fVCO=2*fOSC*-----------
        //             (REFDIV+1)

        //          fVCO
        //fPLL=-------------
        //       2*POSTDIV

        //fBUS=fPLL/2=32MHz 

        #if (OSCCLK == 4000000)
        SYNR    = 0x47;
        REFDV   = 0x40;
        POSTDIV = 0x00;
        #else
        SYNR    = 0x43;
        REFDV   = 0x80;
        POSTDIV = 0x00;
        #endif

        while (!CRGFLG_LOCK);       //?? fVCO ????
        CLKSEL_PLLSEL = 1;          //??PLLCLK??????

        while (!FSTAT_CCIF);        //wait for FTM reset to complete/

        #if (OSCCLK == 4000000) 
        if (FCLKDIV == 0)
        FCLKDIV = 0x03;           //FCLK = OSCCLK / 3 = 4M / 3 = 1.333MHz
        #else
        if (FCLKDIV == 0)
        FCLKDIV = 0x07;           //FCLK = OSCCLK / 7 = 8M / 7 = 1.1238MHz
        #endif

        DFPROT = 0xFF;              //Disable any protection set on DFlash

        CLKSEL_PSTP = 1;            //Oscillator?Stop???????(Pseudo Stop)

        COPCTL     = 0x47;               //?????WDT_Init();
        PLLCTL_PCE = 1;             //????Pseudo Stop???????
        
         PLLCTL_PRE=1;               // 1 RTI continues running during Pseudo Stop Mode.       
         */ 
}     
void CheckOSC(void)
{
     //��������ڲ�RC�𵴣��������³�ʼ��ʱ��
   if((_CRGFLG.Bits.SCM == 1) || (CLKSEL_PLLSEL  == 0))  
   {
        DisableInterrupts;
       Clock_Init();
       EnableInterrupts;
   }
}

/******************************************************************************
???:Enter_Stop_Mode
?  ?:??????
?  ?:?
???:?
******************************************************************************/
void Enter_Stop_Mode(void)
{
     
 
  asm ANDCC #0x7F;
  asm STOP;
}

/******************************************************************************
��������
��  �ܣ���ʼ��RTI
��  ������
����ֵ����
******************************************************************************/
void RTI_Init(void)
{
  RealTimeClock.RollingCounter = 0;
  RealTimeClock.BackupCounter  = 0;
  RealTimeClock.Year           = RTC_DEFAULT_YEAR;
  RealTimeClock.BackupYear     = RTC_DEFAULT_YEAR;
  RealTimeClock.Month          = RTC_DEFAULT_MONTH;
  RealTimeClock.Date           = RTC_DEFAULT_DATE;
  RealTimeClock.Hour           = RTC_DEFAULT_HOUR;
  RealTimeClock.Minute         = RTC_DEFAULT_MINUTE;
  RealTimeClock.Second         = RTC_DEFAULT_SECOND;
  RealTimeClock.LeapYear       = Determine_Leap_Year(RealTimeClock.Year);
  
  PLLCTL_PRE  = 1;            //1 RTI continues running during Pseudo Stop Mode.
   
  //Real Time ʱ��Ƶ������                                                             
  RTICTL      = 0xDF;         //Real Time = 8M / 800000 = 10HZ  (100MS)
  CRGINT_RTIE = 1;	        
}

/******************************************************************************
��������
��  �ܣ�RTIʵʱ��ʱ����
��  ������
����ֵ����
*******************************************************************************
ע  �⣺�÷���������ÿ100ms������һ��
******************************************************************************/
void RTI_Timing_Service(void)
{
  uint16_t  Counter;
  uint16_t  SecInc;
  
  if (RealTimeClock.Year != RealTimeClock.BackupYear) 
  {
    RealTimeClock.LeapYear = Determine_Leap_Year(RealTimeClock.Year);
    RealTimeClock.BackupYear = RealTimeClock.Year;
  }
  
  Counter = RealTimeClock.RollingCounter;
  
  if (Counter - RealTimeClock.BackupCounter >= 10)
  {
    SecInc = (Counter - RealTimeClock.BackupCounter) / 10;
    RealTimeClock.BackupCounter += SecInc * 10;
    
    RealTimeClock.Second += (uint8_t)(SecInc % 60);
    RealTimeClock.Minute += (uint8_t)(SecInc / 60);
    
    if (RealTimeClock.Second >= 60)
    {
      RealTimeClock.Minute += RealTimeClock.Second / 60;
      RealTimeClock.Second  = RealTimeClock.Second % 60;
    }
    
    if (RealTimeClock.Minute >= 60)
    {
      RealTimeClock.Hour   += RealTimeClock.Minute / 60;
      RealTimeClock.Minute  = RealTimeClock.Minute % 60;
    }
    
    if (RealTimeClock.Hour >= 24)
    {
      RealTimeClock.Date += RealTimeClock.Hour / 24;
      RealTimeClock.Hour  = RealTimeClock.Hour % 24;
    }
    
    switch (RealTimeClock.Month)
    {
      case 1  :
      case 3  :
      case 5  :
      case 7  :
      case 8  :
      case 10 :
      case 12 : if (RealTimeClock.Date > 31)
                {
                  RealTimeClock.Date = 1;
                  RealTimeClock.Month++;
                }
                break;
                
      case 4  :
      case 6  :
      case 9  :
      case 11 : if (RealTimeClock.Date > 30)
                {
                  RealTimeClock.Date = 1;
                  RealTimeClock.Month++;
                }
                break;
                 
      case 2  : if (RealTimeClock.LeapYear)
                {
                  if (RealTimeClock.Date > 29)
                  {
                    RealTimeClock.Date = 1;
                    RealTimeClock.Month++;
                  }
                }
                else
                {
                  if (RealTimeClock.Date > 28)
                  {
                    RealTimeClock.Date = 1;
                    RealTimeClock.Month++;
                  }
                }
                break; 
    }
    
    if (RealTimeClock.Month > 12)
    {
    	RealTimeClock.Month = 1;
		RealTimeClock.Year++;
		RealTimeClock.LeapYear = Determine_Leap_Year(RealTimeClock.Year);
		RealTimeClock.BackupYear = RealTimeClock.Year;
    }
  }
}

/******************************************************************************
��������
��  �ܣ�������
��  ����Year����
����ֵ��1 - ������ 0 -��������
******************************************************************************/
uint8_t Determine_Leap_Year(uint16_t Year)
{
  if (Year % 4 == 0)
  {
    if (Year % 100 != 0)
      return 1;
    else if (Year % 400 == 0)
      return 1;
  }

  return 0;
}

// uint8_t Timer5sFlag;
// extern uint8_t DiagnosticReceived;
#pragma CODE_SEG __NEAR_SEG NON_BANKED
/******************************************************************************
 ��������
 ��  �ܣ�RTI�жϷ�����
         RTIÿ100ms�����жϺ�,��������������Զ���1
         RTI�жϻ����Խ���������˯���л���
 ��  ������
 ����ֵ����    2017��5��27��16:47:20       
******************************************************************************/
void interrupt RTI_ISR(void)
{
   CAN_Timer_100ms = 1;
   Sleep_Timer_100ms = 1;
   	
   RealTimeClock.RollingCounter++;
   TIME_100MS = 1;
   //PowerDN_Time_Add();
   Data_Mileage_Rolling_Counter_Update_ISR();


   
  CRGFLG_RTIF = 1;           
}
#pragma CODE_SEG DEFAULT
