#include "Include.h"

#define LINE_IN_IGNON 1u
#define LINE_IN_IGNOFF 0u
#define LINE_IN_IGNONOFF 2u

#define LINE_IN_HIGH_LEVEL 1U
#define LINE_IN_LOW_LEVEL 0U
/*Ӳ�������������������*/
#define LINE_IN_CYCLE 10U

typedef struct
{
	/* INT8U u8Enable;     Ӳ���Ƿ�ʹ��*/
	INT8U u8Status;		/*Ӳ��������״̬*/
	INT16U u16TimeCount;  /*������ʱ����*/
	INT8U u8PinInput;	  /*ʵ��Ӳ����������*/
	INT8U u8PinInputLast; /*ʵ��Ӳ���������ż������һ��״̬*/
} LineInControl;

typedef struct
{																					      
	//    INT8U *u8PinInput;    /*ָ��ʵ��Ӳ����������*/
	INT8U u8ValidLevel;	   /*��Ч��ƽ*/
	INT16U u16ValidTime;   /*����Ч����Ч������ʱ�� ms*/
	INT16U u16InvalidTime; /*����Ч����Ч������ʱ��*/
	INT8U u8PowerStatus;   /*��Դ״̬,�ݶ�1��ʾIGNON,0��ʾignoff��2������*/

} LineInAttribute_st_t;													         


/*���Ա���Ӳ��������һһ��Ӧ*/
const LineInAttribute_st_t g_stLineInAttribute[LINE_IN_MAX] =
{
	//{LINE_IN_LOW_LEVEL, 200u, 0u, LINE_IN_IGNON,},   /*I_MCU_��������������-��_Ԥ��  */
	//{LINE_IN_LOW_LEVEL, 200u, 0u, LINE_IN_IGNON,},   /*I_MCU_���س�ŵ磨-��_Ԥ��*/       
	{LINE_IN_LOW_LEVEL, 200u, 0u, LINE_IN_IGNONOFF ,},  /*��ʻ��δ��*/	 
	{LINE_IN_LOW_LEVEL, 200u, 0u, LINE_IN_IGNON   ,}, /*��ѹDCDC����*/
	{LINE_IN_LOW_LEVEL, 200u, 0u, LINE_IN_IGNON   ,}, /*����ȫ��*/

	//{LINE_IN_LOW_LEVEL,  200u, 0u, LINE_IN_IGNON   ,}, 	/*פ���ƶ�*/
	//{LINE_IN_HIGH_LEVEL,  200u, 0u, LINE_IN_IGNON   ,}, 	/*I_MCU_��绽��_Ԥ��*/
	{LINE_IN_LOW_LEVEL,  200u, 0u, LINE_IN_IGNON   ,}, 	/*�ƶ�Һλ�ͱ�����*/
	//{LINE_IN_HIGH_LEVEL,  200u, 0u, LINE_IN_IGNON   ,}, 	/*��Ƭĥ�𾯸�*/   
	{LINE_IN_LOW_LEVEL,  200u, 0u, LINE_IN_IGNON   ,},     /*����ȫ��*/	     //Ԥ�� 
	
	//{LINE_IN_LOW_LEVEL, 200u, 20u, LINE_IN_IGNON   ,},  /*ת��Һλ��*/  //Ԥ��
	{LINE_IN_LOW_LEVEL, 200u, 0u, LINE_IN_IGNON   ,}, /*ȡ��������ָʾ��*/ //Ԥ��
	//{LINE_IN_LOW_LEVEL, 200u, 0u, LINE_IN_IGNON   ,}, /*��������*/
	//{LINE_IN_LOW_LEVEL, 200u, 0u, LINE_IN_IGNON   ,}, /*I_MCU_�ּ������������-��_Ԥ��*/	
};


LineInControl g_stLineInControl[LINE_IN_MAX];

INT8U g_u8LineInPowerStatus;

void Line_In_Real_Time_Input(void)
{
	////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	//g_stLineInControl[LINE_IN_DifferentialLock].u8PinInput = DifferentialLock_IN_P;  
	//g_stLineInControl[LINE_IN_BatteryCharge].u8PinInput = BatteryCharge_IN_P; 
	g_stLineInControl[LINE_IN_CabLock].u8PinInput = CabLock_IN_P;
	g_stLineInControl[LINE_IN_LowDCFlt].u8PinInput = LowDCFlt_IN_P;	     	
	g_stLineInControl[LINE_IN_Driver_SafeBelt].u8PinInput = Driver_SafeBelt_IN_P;   
	
	//g_stLineInControl[LINE_IN_Parking_Brake].u8PinInput = Parking_Brake_IN_P;	  
	//g_stLineInControl[LINE_IN_ChargeWakeup].u8PinInput = ChargeWakeup_IN_P;	 	
	g_stLineInControl[LINE_IN_BrakeLiquid].u8PinInput = BrakeLiquid_IN_P;	  
	//g_stLineInControl[LINE_IN_BrakeShoeWear].u8PinInput = BrakeShoeWear_IN_P;  	 
	g_stLineInControl[LINE_IN_Passenger_SafeBelt].u8PinInput = Passenger_SafeBelt_IN_P;
	
	//g_stLineInControl[LINE_IN_SteerLiquid].u8PinInput = SteerLiquid_IN_P;	  
	g_stLineInControl[LINE_IN_Middle_SafeBelt].u8PinInput = Middle_SafeBelt_IN_P;  
	//g_stLineInControl[LINE_IN_Emptyfilter_Block].u8PinInput = Emptyfilter_Block_P;  
	//g_stLineInControl[LINE_IN_Wheel_DifferentialLock].u8PinInput = Wheel_DifferentialLock_P;  
	
	
}

void Line_In_Debounce_Handle(LineInChannel Channel)
{
	if (g_stLineInControl[Channel].u8PinInputLast != g_stLineInControl[Channel].u8PinInput)
	{
		g_stLineInControl[Channel].u16TimeCount = 0u;
		g_stLineInControl[Channel].u8PinInputLast = g_stLineInControl[Channel].u8PinInput;
	}
	else
	{
		/*Ӳ�����������Ч��ƽ*/
		if (g_stLineInAttribute[Channel].u8ValidLevel == g_stLineInControl[Channel].u8PinInput)
		{
			g_stLineInControl[Channel].u16TimeCount += LINE_IN_CYCLE;
			if (g_stLineInControl[Channel].u16TimeCount >= g_stLineInAttribute[Channel].u16ValidTime)
			{
				g_stLineInControl[Channel].u16TimeCount = 0u;
				g_stLineInControl[Channel].u8Status = 1u;
			}
		}
		else
		{
			g_stLineInControl[Channel].u16TimeCount += LINE_IN_CYCLE;
			if (g_stLineInControl[Channel].u16TimeCount >= g_stLineInAttribute[Channel].u16InvalidTime)
			{
				g_stLineInControl[Channel].u16TimeCount = 0u;
				g_stLineInControl[Channel].u8Status = 0u;
			}
		}
	}
}
//�Ƽ�ֵ10ms
void Line_In_Debounce_Service(void)
{
	INT8U i = 0;
	Line_In_Real_Time_Input();
	for (i = 0; i < LINE_IN_MAX; i++)
	{
		if (LINE_IN_IGNONOFF == g_stLineInAttribute[i].u8PowerStatus)
		{
			Line_In_Debounce_Handle(i);
		}
		else if (LINE_IN_IGNON == g_stLineInAttribute[i].u8PowerStatus)
		{
			if (LINE_IN_IGNON == g_u8LineInPowerStatus)
			{
				Line_In_Debounce_Handle(i);
			}
			else /*�л���Դ״̬ʱ�Ѿ���������*/
			{
			}
		}
		else //if(LINE_IN_IGNOFF==g_stLineInAttribute[i].u8PowerStatus)
		{
			if (LINE_IN_IGNOFF == g_u8LineInPowerStatus)
			{
				Line_In_Debounce_Handle(i);
			}
			else /*�л���Դ״̬ʱ�Ѿ���������*/
			{
			}
		}
	}
}
/*1��ʾӲ����Ч��0Ӳ����Ч*/
INT8U Line_In_Get_Status(LineInChannel Channel)
{
	return g_stLineInControl[Channel].u8Status;
}
void Line_In_KL30_Init(void)
{
	INT8U i = 0;
	g_u8LineInPowerStatus = 0u;
	for (i = 0; i < LINE_IN_MAX; i++)
	{
		g_stLineInControl[i].u16TimeCount = 0;
		g_stLineInControl[i].u8PinInputLast = 0;
		g_stLineInControl[i].u8Status = 0;
	}
}
void Line_In_KL15_ON_Init(void)
{
	INT8U i = 0;
	g_u8LineInPowerStatus = LINE_IN_IGNON;
	for (i = 0; i < LINE_IN_MAX; i++)
	{ /*Ӳ���ڵ�ǰ��Դ״̬�²�����*/
		if (LINE_IN_IGNOFF == g_stLineInAttribute[i].u8PowerStatus)

		{
			g_stLineInControl[i].u8Status = 0;
			g_stLineInControl[i].u16TimeCount = 0;
		}
	}
}
void Line_In_KL15_OFF_Init(void)
{
	INT8U i = 0;
	g_u8LineInPowerStatus = LINE_IN_IGNOFF;
	for (i = 0; i < LINE_IN_MAX; i++)
	{ /*Ӳ���ڵ�ǰ��Դ״̬�²�����*/
		if (LINE_IN_IGNON == g_stLineInAttribute[i].u8PowerStatus)

		{
			g_stLineInControl[i].u8Status = 0;
			g_stLineInControl[i].u16TimeCount = 0;
		}
	}
}
void Line_In_Wakeup_Init(void)
{
}
void Line_In_Sleep_Init(void)
{
}
/*����û�У�����Ӳ��Ԥ���Ŀ���ѡ����ʱ�ر�
��Ŀ��ʵ����Ҫ�����ģ�ִ�п�������*/
/*
void Line_In_Enable(LineChannelType LineChannel)
{
    p_stLine[LineChannel].LineEnable = 1;
    p_stLine[LineChannel].LineSTATUS = 0;
    p_stLine[LineChannel].LineTimeCount = 0;
}
void Line_In_Disable(LineChannelType LineChannel)
{
    p_stLine[LineChannel].LineEnable = 0;
    p_stLine[LineChannel].LineSTATUS = 0;
    p_stLine[LineChannel].LineTimeCount = 0;
}
*/
/*��Դ״̬,�ݶ�1��ʾIGNON,0��ʾignoff��2������
�����Ե��ε���*/
/*
void Line_IN_Set_Power_Status(INT8U Status)
{
    INT8U i = 0;
    g_u8LineInPowerStatus = Status;
    for (i = 0; i < LINE_IN_MAX; i++)
    { 
        if (((LINE_IN_IGNON == g_u8LineInPowerStatus) && (LINE_IN_IGNOFF == g_stLineInAttribute[i].u8PowerStatus)) ||
            ((LINE_IN_IGNOFF == g_u8LineInPowerStatus) && (LINE_IN_IGNON == g_stLineInAttribute[i].u8PowerStatus)))
        {
            g_stLineInControl[i].u8Status = 0;
            g_stLineInControl[i].u16TimeCount = 0;
        }
    }
}
*/