#include  "CAN_CH0_CAN_Communication_Matrix.h"
#include "Include.h"
/* 2023/01/12 10:45:30 */
st_CanMsgOp CAN_CH0_CanMsgOp;
st_CanMsgTxOp CAN_CH0_CanMsgTxOp;

const st_CAN_SendAttribute    CAN_CH0_CANSendAttr[CAN_CH0_ID_SEND_TOTAL] =
{
    {0x0CFE6C17ul,  50ul * 1000ul,  0ul, 0u, MSG_EXT, 2u, 8u, CAN_MSG_TX_CYCLE, Can_Set_Buff_0CFE6C17, (void *)0},
    {0x18FF4017ul,  100ul * 1000ul, 0ul, 0u, MSG_EXT, 3u, 8u, CAN_MSG_TX_CYCLE, Can_Set_Buff_18FF4017, (void *)0},
    {0x18FF4117ul,  100ul * 1000ul, 0ul, 0u, MSG_EXT, 4u, 8u, CAN_MSG_TX_CYCKE_EVENT, Can_Set_Buff_18FF4117, (void *)0},
    {0x18FEC117ul, 1000ul * 1000ul, 0ul, 0u, MSG_EXT, 5u, 8u, CAN_MSG_TX_CYCLE, Can_Set_Buff_18FEC117, (void *)0},
    {0x18FF6F17ul,  100ul * 1000ul, 0ul, 0u, MSG_EXT, 6u, 8u, CAN_MSG_TX_CYCKE_EVENT, Can_Set_Buff_18FF6F17, (void *)0},
    {0x18FEE617ul,  500ul * 1000ul, 0ul, 0u, MSG_EXT, 7u, 8u, CAN_MSG_TX_CYCLE, Can_Set_Buff_18FEE617, (void *)0},
};

void Can_Set_Buff_0CFE6C17(canlib_uint8_t CopyData [])
{
    uint32_t u32temp = 0;

	if(SYS_OPR_STAT_IGN_ON)
	{
		if(DataVSpeedValid)
		{
			u32temp = DataVSpeedDisp;
			u32temp *= 256;
			u32temp /= 10;
			if(u32temp >= 0XFFFF)
			{
				u32temp = 0XFFFF;
			}

			if(DataVSpeedDisp >= 10)
			{
				CopyData[6] = (uint8_t)(u32temp & 0xFF);
				CopyData[7] = (uint8_t)((u32temp >> 8) & 0xFF);
			}
			else
			{
				CopyData[6] = 0;
				CopyData[7] = 0; 
			}
		}
		else
		{
			CopyData[6] = 0;
			CopyData[7] = 0; 
		}
	}
	else
	{
        CopyData[6] = 0;
		CopyData[7] = 0; 
	}
    CopyData[0] = 0xFFu;
    CopyData[1] = 0xFFu;
    CopyData[2] = 0xFFu;
    CopyData[3] = 0xFFu;
    CopyData[4] = 0xFFu;
    CopyData[5] = 0xFFu;
}
void Can_Set_Buff_18FF4017(canlib_uint8_t CopyData [])
{
    uint16_t u16AvgSpd = 0;
	uint16_t u16Maintodo = 0;
    uint16_t u16AirPress_Front = 0;
	uint16_t u16AirPress_Rear = 0;
    uint8_t IC_DrvSeatbeltBucklestatus = 0;
    uint8_t IC_PassSeatbeltWarning = 0;
    uint8_t IC_PassSeatMidPosbeltWarning = 0;
    uint8_t IC_BrakeFuleLowWarn = 0;
    uint8_t IC_LanguageMode = 0;
    uint8_t IC_MaintanceWarningSts = 0;
    uint8_t IC_AirbagUnitLEDSts = 0;
    uint8_t IC_FuelLevelLowWarn = 0;
    uint8_t IC_FuelLevelSts = 0;
    uint8_t IC_FuelLevelStsInvalid = 0;
    uint8_t IC_FuelSensorSTGFault = 0;
    uint8_t IC_FuelSensorOCFault = 0;
    IC_FuelLevelSts  =  FuelData.Capacity_Get/5;

    
    u16Maintodo = (INT16U )(DataServiceInterval/10);
	if(u16Maintodo >50000)
	{
		u16Maintodo = 50000;	
	}
			     
	if((DataServiceWarning == 1)||(DataServiceDistanceWarning == 1))
	{
		IC_MaintanceWarningSts = 0x01;
	}
	else
	{
		IC_MaintanceWarningSts = 0x00;	
	}
    IC_LanguageMode = MenuData.Language;
    if(SYS_OPR_STAT_IGN_ON)
	{
        if(FuelData.Sensor_State == FuelSensorShortCircuit)
        {
            IC_FuelSensorSTGFault = 2;
        }
        else
        {
            IC_FuelSensorSTGFault = 1;
        }
        if(FuelData.Sensor_State == FuelSensorOpenCircuit)
        {
            IC_FuelSensorOCFault = 2;
        }
        else
        {
            IC_FuelSensorOCFault = 1;
        }

        if(FuelData.Sensor_State == FuelSensorNormal)
	    {
	    	IC_FuelLevelStsInvalid = 0;
    
	    	if((FuelData.Step_Get <= 20)&&(DataAirPressEn))
	    	{
	    		IC_FuelLevelLowWarn   = 1;
	    	}
	    	else
	    	{
	    		IC_FuelLevelLowWarn   = 0;	
	    	}
	    }
	    else
	    {
	    	IC_FuelLevelStsInvalid = 1;	
	    }

		if(Line_In_Get_Status(LINE_IN_Driver_SafeBelt))
		{
			IC_DrvSeatbeltBucklestatus = 0x01;
		}
		else
		{
			IC_DrvSeatbeltBucklestatus = 0x00;
		}

		if(Line_In_Get_Status(LINE_IN_Passenger_SafeBelt))
		{
			IC_PassSeatbeltWarning = 0x01;
		}
		else											    
		{
			IC_PassSeatbeltWarning = 0x00;
		}

		if(Line_In_Get_Status(LINE_IN_Middle_SafeBelt))
		{
			IC_PassSeatMidPosbeltWarning = 0x01;
		}
		else
		{
			IC_PassSeatMidPosbeltWarning = 0x00;
		}

		if ((Val_EOL_F101_Break() == 1))//Һɲ
		{
			if (Line_In_Get_Status(LINE_IN_BrakeLiquid))
			{
				IC_BrakeFuleLowWarn = 1;
			}
			else
			{
				IC_BrakeFuleLowWarn = 0;
			}
		}
		else
		{
			IC_BrakeFuleLowWarn = 0;
		}

		if(Val_EOL_F101_Break() == 2)
		{
			if(AirPress_Front.u8_PressValid == 1)
			{
				u16AirPress_Front = AirPress_Front.u16Press_Val/5;
			}
			else
			{
				u16AirPress_Front = 1250/5;	
			}	 

			if(AirPress_Rear.u8_PressValid == 1)
			{
				u16AirPress_Rear = AirPress_Rear.u16Press_Val/5;
			}
			else
			{
				u16AirPress_Rear = 1250/5;	
			}
		}
		else
		{
			u16AirPress_Front = 0;
			u16AirPress_Rear = 0;
		}			

		if(DataAvgSpd.Display_Valid)
		{
			u16AvgSpd = DataAvgSpd.Display_Value;
		}
		else
		{
			u16AvgSpd = 0;
		}

        if(Acu_Led != 0)
        {
            if(Get_Airbag_Fault == 0)
            {
                IC_AirbagUnitLEDSts = Acu_Led;
            }
            else
            {
                IC_AirbagUnitLEDSts = 3;
            }
        }
        else//==0
        {
            if(Get_Airbag_Fault == 0)
            {
                IC_AirbagUnitLEDSts = 0;
            }
            else
            {
                IC_AirbagUnitLEDSts = 3;
            }
        }
	}
	else
	{
		//u16Maintodo = 0;
        u16AvgSpd = 0;
	    //u16Maintodo = 0;
	    u16AirPress_Front = 0;
	    u16AirPress_Rear = 0;
        IC_DrvSeatbeltBucklestatus = 0;
        IC_PassSeatbeltWarning = 0;
        IC_PassSeatMidPosbeltWarning = 0;
        IC_BrakeFuleLowWarn = 0;
        //IC_MaintanceWarningSts = 0;
        IC_AirbagUnitLEDSts = 0;
        IC_FuelLevelLowWarn = 0;
        IC_FuelLevelStsInvalid = 1;	
        IC_FuelSensorSTGFault = 0;
        IC_FuelSensorOCFault = 0;
	}

    
    CopyData[0] = IC_FuelLevelSts;
    CopyData[1] = u16AvgSpd;
    CopyData[2] = (uint8_t)(u16Maintodo & 0xFF);
    CopyData[3] = (uint8_t)((u16Maintodo >> 8) & 0xFF);
    CopyData[4] = (IC_PassSeatbeltWarning << 7)|(IC_DrvSeatbeltBucklestatus << 6)|(IC_BrakeFuleLowWarn << 5)|(IC_FuelLevelLowWarn << 4)|(IC_LanguageMode << 1)|(IC_MaintanceWarningSts);
    CopyData[5] = u16AirPress_Front;
    CopyData[6] = u16AirPress_Rear;
    CopyData[7] = (IC_PassSeatMidPosbeltWarning << 7)|(IC_AirbagUnitLEDSts << 5)|(IC_FuelLevelStsInvalid << 4)|(IC_FuelSensorOCFault << 2)|(IC_FuelSensorSTGFault);
}
void Can_Set_Buff_18FF4117(canlib_uint8_t CopyData [])
{
    uint8_t IC_DriveCabReverseSW = 0;
    uint8_t IC_Backlightadjust = 0;
    uint8_t IC_ResetAveragePowerConsumption = 0;
    uint8_t IC_OTA_InfoShowStatus = 0; 
	uint8_t IC_OTA_DownloadSelected = 0;
	uint8_t IC_OTA_UpdateSelected = 0;
	uint8_t IC_OTA_UpdateResultConfirm = 0;
	uint8_t IC_OTA_DeclimerSelected = 0;

    if (Line_In_Get_Status(LINE_IN_CabLock))
	{
		IC_DriveCabReverseSW = 1;
	}
	else
	{
		IC_DriveCabReverseSW = 0;
	}

    if(SYS_OPR_STAT_IGN_ON)
    {
        if((Get_CAN_CH0_ID_18FE4021_Sig_BCM_TractorMarkerLight() ==1)||(Get_CAN_CH0_ID_18FE4021_Sig_BCM_TractorMarkerLight() == 2))
	    {
	    	IC_Backlightadjust  = BackLightCtrl.Level;
	    }
	    else
	    {
	    	IC_Backlightadjust  = 0;
	    }  
        IC_ResetAveragePowerConsumption_Service();
        IC_OTA_InfoShowStatus_Service();
        IC_OTA_DownloadSelected_Service();
        IC_OTA_UpdateSelected_Service();
        IC_OTA_UpdateResultConfirm_Service();
        IC_OTA_DeclimerSelected_Service();
        IC_ResetAveragePowerConsumption = AvgEVCons.ResetAveragePowerConsumption;
        IC_OTA_InfoShowStatus = IC_OTA.IC_OTA_InfoShowStatus; 
        IC_OTA_DownloadSelected = IC_OTA.IC_OTA_DownloadSelected;
        IC_OTA_UpdateSelected = IC_OTA.IC_OTA_UpdateSelected;
        IC_OTA_UpdateResultConfirm = IC_OTA.IC_OTA_UpdateResultConfirm;
        IC_OTA_DeclimerSelected = IC_OTA.IC_OTA_DeclimerSelected;
    }
    else
    {
        IC_Backlightadjust  = 0;
        IC_ResetAveragePowerConsumption = 0;
        IC_OTA_InfoShowStatus = 0; 
        IC_OTA_DownloadSelected = 0;
        IC_OTA_UpdateSelected = 0;
        IC_OTA_UpdateResultConfirm = 0;
        IC_OTA_DeclimerSelected = 0;
    }

	
    CopyData[0] = (0x80)|(IC_ResetAveragePowerConsumption << 6)|(IC_Backlightadjust << 1)|(0x01);
    CopyData[1] = (0xFE)|(IC_DriveCabReverseSW);
    CopyData[2] = (IC_OTA_DownloadSelected << 6)|(IC_OTA_InfoShowStatus << 4)|(0x0F);
    CopyData[3] = (0xE0)|(IC_OTA_DeclimerSelected << 3)|(IC_OTA_UpdateResultConfirm << 2)|(IC_OTA_UpdateSelected);
    CopyData[4] = 0xFFu;
    CopyData[5] = 0xFFu;
    CopyData[6] = 0xFFu;
    CopyData[7] = 0xFFu;
}
void Can_Set_Buff_18FEC117(canlib_uint8_t CopyData [])
{
    uint32_t u32temp_Odo = 0;	     
    uint32_t u32temp_Trip = 0;

	u32temp_Odo = NVM_ODO_VALUE;       
	u32temp_Odo *= 20;

	u32temp_Trip = DispTrip;
	u32temp_Trip *= 20;
	
    CopyData[0] = (uint8_t)(u32temp_Odo & 0xFF);
    CopyData[1] = (uint8_t)((u32temp_Odo >> 8) & 0xFF);
    CopyData[2] = (uint8_t)((u32temp_Odo >> 16) & 0xFF);
    CopyData[3] = (uint8_t)((u32temp_Odo >> 24) & 0xFF);
    CopyData[4] = (uint8_t)(u32temp_Trip & 0xFF);
    CopyData[5] = (uint8_t)((u32temp_Trip >> 8) & 0xFF);
    CopyData[6] = (uint8_t)((u32temp_Trip >> 16) & 0xFF);
    CopyData[7] = (uint8_t)((u32temp_Trip >> 24) & 0xFF);
}

void Can_Set_Buff_18FF6F17(canlib_uint8_t CopyData [])
{
    uint8_t IC_Manual_Learn_Location = 0;
    uint8_t IC_Manual_Learn_Set = 0;
    if(SYS_OPR_STAT_IGN_ON)
	{
		if(TMPS_Learnning_Flag == TMPS_Export_LF)
		{
			IC_Manual_Learn_Location =  0x17;
			IC_Manual_Learn_Set  = 0x01;
		}
		else if(TMPS_Learnning_Flag == TMPS_Export_RF)
		{
			IC_Manual_Learn_Location = 0x19;	
			IC_Manual_Learn_Set  = 0x01;
		}
		else if(TMPS_Learnning_Flag == TMPS_Export_LR)
		{
			IC_Manual_Learn_Location = 0x26;	
			IC_Manual_Learn_Set  = 0x01;
		}
		else if(TMPS_Learnning_Flag == TMPS_Export_MLR)
		{
			IC_Manual_Learn_Location = 0x27;
			IC_Manual_Learn_Set  = 0x01;	
		}
		else if(TMPS_Learnning_Flag == TMPS_Export_MRR)
		{
			IC_Manual_Learn_Location = 0x29;	
			IC_Manual_Learn_Set  = 0x01;
		}
		else if(TMPS_Learnning_Flag == TMPS_Export_RR)
		{
			IC_Manual_Learn_Location = 0x2A;	
			IC_Manual_Learn_Set  = 0x01;
		}
		else if(TMPS_Learnning_Flag == TMPS_Export_Over)
		{
		 	IC_Manual_Learn_Set  = 0x00;
		}
	}

    CopyData[0] = IC_Manual_Learn_Location;
    CopyData[1] = IC_Manual_Learn_Set;
    CopyData[2] = 0xFFu;
    CopyData[3] = 0xFFu;
    CopyData[4] = 0xFFu;
    CopyData[5] = 0xFFu;
    CopyData[6] = 0xFFu;
    CopyData[7] = 0xFFu;
}

void Can_Set_Buff_18FEE617(canlib_uint8_t CopyData [])
{
    uint8_t TX_Second;
    uint8_t TX_Minute;
    uint8_t TX_Hour;
    uint8_t TX_Day;
    uint8_t TX_Month;
    uint16_t TX_Year;
    
    TX_Second = RTC_SECOND*4 ;
	TX_Minute = RTC_MINUTE ;
	TX_Hour = RTC_HOUR ;
	TX_Day = RTC_DATE*4 ;
	TX_Month = RTC_MONTH ;
	if(RTC_YEAR < 1985)
	{
		TX_Year = 0;	
	}
	else
	{
		TX_Year = RTC_YEAR-1985 ;	
	}
    CopyData[0] = TX_Second;
    CopyData[1] = TX_Minute;
    CopyData[2] = TX_Hour;
    CopyData[3] = TX_Month;
    CopyData[4] = TX_Day;
    CopyData[5] = TX_Year;
    CopyData[6] = 0xFFu;
    CopyData[7] = 0xFFu;
}

const st_CANMsgAttribute CAN_CH0_CAN_MSG_CONST_ARRAY[CAN_CH0_ID_TOTAL_MAX] =
{
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        500ul,
        0x18FE4021ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        500ul,
        0x18F0010Bul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        1000ul,
        0x18FFE033ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        500ul,
        0x18FDA521ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    //{
    //    {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
    //    {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
    //    {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
    //    500ul,
    //    0x18FE5BE8ul,//黑
    //    (( void * )0),
    //    (( void * )0),
    //    (( void * )0),
    //},
    //{
    //    {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
    //    {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
    //    {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
    //    50000ul,
    //    0x18FEFF00ul,//无
    //    (( void * )0),
    //    (( void * )0),
    //    (( void * )0),
    //},
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        500ul,
        0x18FFB88Ful,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        500ul,
        0x18FAD084ul,//无
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x18FEE69Ful,
        (( void * )0),
        (( void * )Can_18FEE69F_Receive),
        (( void * )0),
    },
    /*{
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        250ul,
        0xCFE6CEEul,//无
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x18FEC1EEul,//无
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0xCFE6C17ul,//外发
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x18FF4117ul,//外发
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x18FFFA17ul,//外发
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x18FEE617ul,//外发
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x18FF4017ul,//外发
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x18FF4217ul,//外发
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x18FF6F17ul,//外发
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x18FEFC17ul,//无
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        250ul,
        0x10F007E8ul,//黑
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },*/
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        250ul,
        0xCFF1ADAul,
        (( void * )0),
        (( void * )Can_0CFF1ADA_Receive),
        (( void * )0),
    },
    //{
    //    {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
    //    {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
    //    {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
    //    5000ul,
    //    0x18FEAE30ul,//无
    //    (( void * )0),
    //    (( void * )0),
    //    (( void * )0),
    //},
    //{
    //    {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
    //    {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
    //    {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
    //    250ul,
    //    0xCF02FA0ul,//黑
    //    (( void * )0),
    //    (( void * )0),
    //    (( void * )0),
    //},
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        500ul,
        0x18FFDD21ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x18FFE133ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        2500ul,
        0x18FF639Ful,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x18FF789Ful,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        250ul,
        0xCFAB127ul,
        (( void * )0),
        (( void * )Can_0CFAB127_Receive),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        500ul,
        0x18FA40F4ul,
        (( void * )0),
        (( void * )Can_18FA40F4_Receive),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        500ul,
        0x18FAB027ul,
        (( void * )0),
        (( void * )Can_18FAB027_Receive),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        500ul,
        0x18FA92D0ul,//无
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    /*{
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        500ul,
        0x18FA6489ul,//无
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        500ul,
        0x18FA6389ul,//无
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x18FEE6EEul,//外发
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },*/
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        500ul,
        0x18FF2319ul,
        (( void * )0),
        (( void * )Can_18FF2319_Receive),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x18FAB227ul,
        (( void * )0),
        (( void * )Can_18FAB227_Receive),
        (( void * )0),
    },
    //{
    //    {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
    //    {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
    //    {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
    //    5000ul,
    //    0x18FEC117ul,//外发
    //    (( void * )0),
    //    (( void * )0),
    //    (( void * )0),
    //},
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x18FAB327ul,
        (( void * )0),
        (( void * )Can_18FAB327_Receive),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x18FA48F4ul,
        (( void * )0),
        (( void * )Can_18FA48F4_Receive),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        250ul,
        0xCFAA627ul,
        (( void * )0),
        (( void * )Can_0CFAA627_Receive),
        (( void * )0),
    },
    //{
    //    {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
    //    {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
    //    {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
    //    500ul,
    //    0x18FACA2Aul,//无
    //    (( void * )0),
    //    (( void * )0),
    //    (( void * )0),
    //},
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x18FF629Ful,
        (( void * )0),
        (( void * )Can_18FF629F_Receive),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x18FAA027ul,
        (( void * )0),
        (( void * )Can_18FAA027_Receive),
        (( void * )0),
    },
    //{
    //    {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
    //    {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
    //    {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
    //    500ul,
    //    0x18FA60D5ul,//无
    //    (( void * )0),
    //    (( void * )0),
    //    (( void * )0),
    //},
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x18FA4AF4ul,
        (( void * )0),
        (( void * )Can_18FA4AF4_Receive),
        (( void * )0),
    },
    /*{
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x18FACAE8ul,//无
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },*/
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        500ul,
        0x18FF0BDFul,//无
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        500ul,
        0x18FA42F4ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        250ul,
        0xCFABF8Ful,//无
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        500ul,
        0x18FA3EF4ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        1000ul,
        0x18FAC490ul,//黑
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x18FAAE27ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        500ul,
        0xC012705ul,//黑
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        500ul,
        0x18FA41F4ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    /*{
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        500ul,
        0x18FF4A41ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },*/
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        500ul,
        0x18FA02EFul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    /*{
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        500ul,
        0x18FA63D5ul,//无
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },*/
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x18FA98D0ul,//无
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        250ul,
        0xCFFB303ul,//无
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        500ul,
        0x18FA1727ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    /*{
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        500ul,
        0x18FF649Ful,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x18FF5241ul,//事件
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x18FF5141ul,//事件
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },*/
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x18FC03F4ul,
        (( void * )0),
        (( void * )Can_18FC03F4_Receive),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        500ul,
        0x18FF5F27ul,//无
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        500ul,
        0x18FAA527ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    /*{
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        250ul,
        0xCFA90D0ul,//无
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },*/
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        500ul,
        0x18FFC095ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        500ul,
        0x18FF4C41ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    /*{
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        500ul,
        0x18FFB403ul,//无
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },*/
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        500ul,
        0x18FF5D27ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        250ul,
        0xCFABA13ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        500ul,
        0x18FE4F0Bul,//无
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    /*{
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x18FECAE8ul,//无
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },*/
};

uint8_t  Get_CAN_CH0_ID_18FE4021_Sig_BCM_LightLeftOn(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_BCM_light_Msg_Count, 4u) >> 2u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_18FE4021_Sig_BCM_RearFogLights(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_BCM_light_Msg_Count, 4u) >> 0u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_18FE4021_Sig_BCM_TractorMarkerLight(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_BCM_light_Msg_Count, 3u) >> 6u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_18FE4021_Sig_BCM_LeftStopLight(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_BCM_light_Msg_Count, 2u) >> 6u) & 0x03u));
}

//uint8_t  Get_CAN_CH0_ID_18FE4021_Sig_BCM_RightStopLight(void)
//{
//    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_BCM_light_Msg_Count, 2u) >> 4u) & 0x03u));
//}

//uint8_t  Get_CAN_CH0_ID_18FE4021_Sig_BCM_CenterStopLight(void)
//{
//    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_BCM_light_Msg_Count, 2u) >> 2u) & 0x03u));
//}

uint8_t  Get_CAN_CH0_ID_18FE4021_Sig_BCM_BackUpLightAndAlarmHorn(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_BCM_light_Msg_Count, 2u) >> 0u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_18FE4021_Sig_BCM_LeftTurnSignalLights(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_BCM_light_Msg_Count, 1u) >> 6u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_18FE4021_Sig_BCM_RightTurnSignalLights(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_BCM_light_Msg_Count, 1u) >> 4u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_18FE4021_Sig_BCM_TractorFrontFogLights(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_BCM_light_Msg_Count, 1u) >> 0u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_18FE4021_Sig_BCM_HighBeamHeadLightData(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_BCM_light_Msg_Count, 0u) >> 6u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_18FE4021_Sig_BCM_LowBeamHeadLightData(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_BCM_light_Msg_Count, 0u) >> 4u) & 0x03u));
}

//uint8_t  Get_CAN_CH0_ID_18FE4021_Sig_BCM_AlternateBeamHeadLightData(void)
//{
//    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_BCM_light_Msg_Count, 0u) >> 2u) & 0x03u));
//}

uint8_t  Get_CAN_CH0_ID_18FE4021_Sig_BCM_RunningLight(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_BCM_light_Msg_Count, 0u) >> 0u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_18F0010B_Sig_EBS_EBSRedWarningState(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ABS_EBS_EBC1_Msg_Count, 5u) >> 2u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_18F0010B_Sig_EBS_ASR_Off_RoadSwitch(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ABS_EBS_EBC1_Msg_Count, 2u) >> 2u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_18F0010B_Sig_EBS_TractionControlOverrideSwitch(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ABS_EBS_EBC1_Msg_Count, 2u) >> 6u) & 0x03u));
}

/*uint8_t  Get_CAN_CH0_ID_18F0010B_Sig_EBS_ATC_ASRLampState(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ABS_EBS_EBC1_Msg_Count, 5u) >> 6u) & 0x03u));
}*/

uint8_t  Get_CAN_CH0_ID_18F0010B_Sig_EBS_ABS_AmberWarningState(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ABS_EBS_EBC1_Msg_Count, 5u) >> 4u) & 0x03u));
}

/*uint8_t  Get_CAN_CH0_ID_18F0010B_Sig_EBS_ASRBrakeControlActive(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ABS_EBS_EBC1_Msg_Count, 0u) >> 2u) & 0x03u));
}*/

uint8_t  Get_CAN_CH0_ID_18F0010B_Sig_EBS_ASREngineControlActive(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ABS_EBS_EBC1_Msg_Count, 0u) >> 0u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_18FFE033_Sig_TPMS_TirePreSts(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_TPMS_TireInfor_Msg_Count, 6u) >> 0u) & 0x07u));
}

/*uint8_t  Get_CAN_CH0_ID_18FFE033_Sig_TPMS_ECUSts(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_TPMS_TireInfor_Msg_Count, 5u) >> 6u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_18FFE033_Sig_TPMS_TireLockSts(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_TPMS_TireInfor_Msg_Count, 5u) >> 4u) & 0x03u));
}*/

uint8_t  Get_CAN_CH0_ID_18FFE033_Sig_TPMS_BatterySts(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_TPMS_TireInfor_Msg_Count, 5u) >> 2u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_18FFE033_Sig_TPMS_TempSts(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_TPMS_TireInfor_Msg_Count, 5u) >> 0u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_18FFE033_Sig_TPMS_SystemFault(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_TPMS_TireInfor_Msg_Count, 4u) >> 6u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_18FFE033_Sig_TPMS_FastPrLossSts(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_TPMS_TireInfor_Msg_Count, 4u) >> 4u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_18FFE033_Sig_TPMS_SensorFaultSts(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_TPMS_TireInfor_Msg_Count, 4u) >> 2u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_18FFE033_Sig_TPMS_SingallMissingSts(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_TPMS_TireInfor_Msg_Count, 4u) >> 0u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_18FFE033_Sig_TPMS_TireTemp(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_TPMS_TireInfor_Msg_Count, 3u) >> 0u) & 0xFFu));
}

uint16_t Get_CAN_CH0_ID_18FFE033_Sig_TPMS_TirePressure(void)
{
    return (((uint16_t)((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_TPMS_TireInfor_Msg_Count, 2u) >> 0u) & 0xFFu) << 8u) + \
    ((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_TPMS_TireInfor_Msg_Count, 1u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_18FFE033_Sig_TPMS_Wheel_location_ID(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_TPMS_TireInfor_Msg_Count, 0u) >> 0u) & 0x7Fu));
}

uint8_t  Get_CAN_CH0_ID_18FDA521_Sig_BCM_RearRightDoorAjarStatus(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_BCM_DoorControl2_Msg_Count, 2u) >> 4u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_18FDA521_Sig_BCM_RearLeftDoorAjarStatus(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_BCM_DoorControl2_Msg_Count, 1u) >> 6u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_18FDA521_Sig_BCM_FrontRightDoorAjarStatus(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_BCM_DoorControl2_Msg_Count, 1u) >> 0u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_18FDA521_Sig_BCM_FrontLeftDoorAjarStatus(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_BCM_DoorControl2_Msg_Count, 0u) >> 2u) & 0x03u));
}

/*uint8_t  Get_CAN_CH0_ID_18FE5BE8_Sig_FCS_LDWEnableStatus(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_FCS_FLI2_Msg_Count, 0u) >> 6u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_18FE5BE8_Sig_FCS_LDWCameraStatus(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_FCS_FLI2_Msg_Count, 1u) >> 4u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_18FE5BE8_Sig_FCS_LaneTrackingStatusLeftSide(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_FCS_FLI2_Msg_Count, 0u) >> 4u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_18FE5BE8_Sig_FCS_LaneTrackingStatusRightSide(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_FCS_FLI2_Msg_Count, 0u) >> 2u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_18FE5BE8_Sig_FCS_LDWSystemState(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_FCS_FLI2_Msg_Count, 1u) >> 0u) & 0x0Fu));
}*/

/*uint8_t  Get_CAN_CH0_ID_18FEFF00_Sig_EMS_DWarnSysIndicatorSts(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_EMS_OI_Msg_Count, 1u) >> 0u) & 0x07u));
}

uint8_t  Get_CAN_CH0_ID_18FEFF00_Sig_EMS_ECSOpInSeverity(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_EMS_OI_Msg_Count, 1u) >> 3u) & 0x07u));
}

uint8_t  Get_CAN_CH0_ID_18FEFF00_Sig_EMS_WaterInFuelIndicator(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_EMS_OI_Msg_Count, 0u) >> 0u) & 0x03u));
}*/

uint8_t  Get_CAN_CH0_ID_18FFB88F_Sig_EPB_SafeBeltNotTiedLmtReleaseWarning(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_EPB_StsInfor_Msg_Count, 5u) >> 6u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_18FFB88F_Sig_EPB_FltLevel(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_EPB_StsInfor_Msg_Count, 3u) >> 0u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_18FFB88F_Sig_EPB_LowPreReleaseParkLimit(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_EPB_StsInfor_Msg_Count, 2u) >> 2u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_18FFB88F_Sig_EPB_ChildLockActive(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_EPB_StsInfor_Msg_Count, 2u) >> 0u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_18FFB88F_Sig_EPB_TemParkActive(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_EPB_StsInfor_Msg_Count, 0u) >> 4u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_18FFB88F_Sig_EPB_TemParkBrakeSts(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_EPB_StsInfor_Msg_Count, 0u) >> 2u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_18FFB88F_Sig_EPB_ParkBrakeSts(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_EPB_StsInfor_Msg_Count, 0u) >> 0u) & 0x03u));
}

/*uint8_t  Get_CAN_CH0_ID_18FAD084_Sig_DMM_CheckSum(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_DMM_StsInfor_Msg_Count, 7u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_18FAD084_Sig_DMM_AliveCounter(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_DMM_StsInfor_Msg_Count, 6u) >> 0u) & 0x0Fu));
}*/

uint8_t  Get_CAN_CH0_ID_18FAD084_Sig_DMM_Occlusion_Alarm(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_DMM_StsInfor_Msg_Count, 1u) >> 4u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_18FAD084_Sig_DMM_UnsafeAct_Warning_Status(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_DMM_StsInfor_Msg_Count, 1u) >> 2u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_18FAD084_Sig_DMM_Fatigue_Warning_Status(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_DMM_StsInfor_Msg_Count, 1u) >> 0u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_18FAD084_Sig_DMM_SystemFault(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_DMM_StsInfor_Msg_Count, 0u) >> 2u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_18FAD084_Sig_DMM_WorkSts(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_DMM_StsInfor_Msg_Count, 0u) >> 0u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_18FEE69F_Sig_TBOX_Year(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_TBOX_TD_Msg_Count, 5u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_18FEE69F_Sig_TBOX_Day(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_TBOX_TD_Msg_Count, 4u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_18FEE69F_Sig_TBOX_Month(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_TBOX_TD_Msg_Count, 3u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_18FEE69F_Sig_TBOX_Hour(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_TBOX_TD_Msg_Count, 2u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_18FEE69F_Sig_TBOX_Minute(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_TBOX_TD_Msg_Count, 1u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_18FEE69F_Sig_TBOX_Second(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_TBOX_TD_Msg_Count, 0u) >> 0u) & 0xFFu));
}

/*uint16_t Get_CAN_CH0_ID_0CFE6CEE_Sig_IC_TachographOutputShaftSpeed(void)
{
    return (((uint16_t)((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_IC_TCO1_Msg_Count, 5u) >> 0u) & 0xFFu) << 8u) + \
    ((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_IC_TCO1_Msg_Count, 4u) >> 0u) & 0xFFu));
}

uint16_t Get_CAN_CH0_ID_0CFE6CEE_Sig_IC_TachographVehicleSpeed(void)
{
    return (((uint16_t)((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_IC_TCO1_Msg_Count, 7u) >> 0u) & 0xFFu) << 8u) + \
    ((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_IC_TCO1_Msg_Count, 6u) >> 0u) & 0xFFu));
}

uint32_t Get_CAN_CH0_ID_18FEC1EE_Sig_IC_TripDistance(void)
{
    return (((uint32_t)((uint32_t)((uint32_t)((uint32_t)((uint32_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_IC_VDHR_Msg_Count, 7u) >> 0u) & 0xFFu) << 8u) + \
    ((uint32_t)((uint32_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_IC_VDHR_Msg_Count, 6u) >> 0u) & 0xFFu) << 8u) + \
    ((uint32_t)((uint32_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_IC_VDHR_Msg_Count, 5u) >> 0u) & 0xFFu) << 8u) + \
    ((uint32_t)((uint32_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_IC_VDHR_Msg_Count, 4u) >> 0u) & 0xFFu));
}

uint32_t Get_CAN_CH0_ID_18FEC1EE_Sig_IC_TotalVehicleDistance(void)
{
    return (((uint32_t)((uint32_t)((uint32_t)((uint32_t)((uint32_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_IC_VDHR_Msg_Count, 3u) >> 0u) & 0xFFu) << 8u) + \
    ((uint32_t)((uint32_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_IC_VDHR_Msg_Count, 2u) >> 0u) & 0xFFu) << 8u) + \
    ((uint32_t)((uint32_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_IC_VDHR_Msg_Count, 1u) >> 0u) & 0xFFu) << 8u) + \
    ((uint32_t)((uint32_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_IC_VDHR_Msg_Count, 0u) >> 0u) & 0xFFu));
}

uint16_t Get_CAN_CH0_ID_0CFE6C17_Sig_IC_TachographVehicleSpeed(void)
{
    return (((uint16_t)((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_IC_TCO_Msg_Count, 7u) >> 0u) & 0xFFu) << 8u) + \
    ((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_IC_TCO_Msg_Count, 6u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_18FF4117_Sig_IC_OTA_DeclimerSelected(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_IC_StatusInfor2_Msg_Count, 3u) >> 3u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_18FF4117_Sig_IC_OTA_UpdateResultConfirm(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_IC_StatusInfor2_Msg_Count, 3u) >> 2u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_18FF4117_Sig_IC_OTA_UpdateSelected(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_IC_StatusInfor2_Msg_Count, 3u) >> 0u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_18FF4117_Sig_IC_OTA_DownloadSelected(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_IC_StatusInfor2_Msg_Count, 2u) >> 6u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_18FF4117_Sig_IC_OTA_InfoShowStatus(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_IC_StatusInfor2_Msg_Count, 2u) >> 4u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_18FF4117_Sig_IC_DriveCabReverseSW(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_IC_StatusInfor2_Msg_Count, 1u) >> 0u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_18FF4117_Sig_IC_ResetAverageFuelConsumption(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_IC_StatusInfor2_Msg_Count, 0u) >> 7u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_18FF4117_Sig_IC_ResetAveragePowerConsumption(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_IC_StatusInfor2_Msg_Count, 0u) >> 6u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_18FF4117_Sig_IC_Backlightadjust(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_IC_StatusInfor2_Msg_Count, 0u) >> 1u) & 0x1Fu));
}

uint8_t  Get_CAN_CH0_ID_18FF4117_Sig_IC_BrakeShoeWearWarn(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_IC_StatusInfor2_Msg_Count, 0u) >> 0u) & 0x01u));
}

uint32_t Get_CAN_CH0_ID_18FFFA17_Sig_IC_Stayawake_reasons(void)
{
    return (((uint32_t)((uint32_t)((uint32_t)((uint32_t)((uint32_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_IC_NWM_Msg_Count, 7u) >> 0u) & 0xFFu) << 8u) + \
    ((uint32_t)((uint32_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_IC_NWM_Msg_Count, 6u) >> 0u) & 0xFFu) << 8u) + \
    ((uint32_t)((uint32_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_IC_NWM_Msg_Count, 5u) >> 0u) & 0xFFu) << 8u) + \
    ((uint32_t)((uint32_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_IC_NWM_Msg_Count, 4u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_18FFFA17_Sig_IC_NMSts(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_IC_NWM_Msg_Count, 3u) >> 0u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_18FFFA17_Sig_IC_Wakeup_reasons(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_IC_NWM_Msg_Count, 2u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_18FFFA17_Sig_IC_AWB(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_IC_NWM_Msg_Count, 1u) >> 4u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_18FFFA17_Sig_IC_RMR(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_IC_NWM_Msg_Count, 1u) >> 0u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_18FFFA17_Sig_IC_Address(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_IC_NWM_Msg_Count, 0u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_18FEE617_Sig_IC_Year(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_IC_TD_Msg_Count, 5u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_18FEE617_Sig_IC_Day(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_IC_TD_Msg_Count, 4u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_18FEE617_Sig_IC_Month(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_IC_TD_Msg_Count, 3u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_18FEE617_Sig_IC_Hour(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_IC_TD_Msg_Count, 2u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_18FEE617_Sig_IC_Minute(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_IC_TD_Msg_Count, 1u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_18FEE617_Sig_IC_Second(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_IC_TD_Msg_Count, 0u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_18FF4017_Sig_IC_BrakeFuleLowWarn(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_IC_StatusInfor_Msg_Count, 4u) >> 5u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_18FF4017_Sig_IC_PassSeatMidPosbeltWarning(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_IC_StatusInfor_Msg_Count, 7u) >> 7u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_18FF4017_Sig_IC_AirbagUnitLEDSts(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_IC_StatusInfor_Msg_Count, 7u) >> 5u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_18FF4017_Sig_IC_FuelLevelStsInvalid(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_IC_StatusInfor_Msg_Count, 7u) >> 4u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_18FF4017_Sig_IC_FuelSensorOCFault(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_IC_StatusInfor_Msg_Count, 7u) >> 2u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_18FF4017_Sig_IC_FuelSensorSTGFault(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_IC_StatusInfor_Msg_Count, 7u) >> 0u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_18FF4017_Sig_IC_RearAirTankPressure(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_IC_StatusInfor_Msg_Count, 6u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_18FF4017_Sig_IC_FrontAirTankPressure(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_IC_StatusInfor_Msg_Count, 5u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_18FF4017_Sig_IC_PassSeatbeltWarning(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_IC_StatusInfor_Msg_Count, 4u) >> 7u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_18FF4017_Sig_IC_DrvSeatbeltBucklestatus(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_IC_StatusInfor_Msg_Count, 4u) >> 6u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_18FF4017_Sig_IC_FuelLevelLowWarn(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_IC_StatusInfor_Msg_Count, 4u) >> 4u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_18FF4017_Sig_IC_LanguageMode(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_IC_StatusInfor_Msg_Count, 4u) >> 1u) & 0x07u));
}

uint8_t  Get_CAN_CH0_ID_18FF4017_Sig_IC_MaintanceWarningSts(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_IC_StatusInfor_Msg_Count, 4u) >> 0u) & 0x01u));
}

uint16_t Get_CAN_CH0_ID_18FF4017_Sig_IC_ServiceMaintainInterval(void)
{
    return (((uint16_t)((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_IC_StatusInfor_Msg_Count, 3u) >> 0u) & 0xFFu) << 8u) + \
    ((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_IC_StatusInfor_Msg_Count, 2u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_18FF4017_Sig_IC_AverageVehSpd(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_IC_StatusInfor_Msg_Count, 1u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_18FF4017_Sig_IC_FuelLevelSts(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_IC_StatusInfor_Msg_Count, 0u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_18FF4217_Sig_IC_PFCU_IdleTypeSet(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_IC_SettingInfomation_Msg_Count, 4u) >> 0u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_18FF6F17_Sig_IC_Manual_LearnSet(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_IC_TPMS_Manual_Learn_Req_Msg_Count, 1u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_18FF6F17_Sig_IC_Manual_LearnLocation(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_IC_TPMS_Manual_Learn_Req_Msg_Count, 0u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_18FEFC17_Sig_IC_FuelLevel1(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_IC_DD_Msg_Count, 1u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_10F007E8_Sig_FCS_LaneDepartureLeftSide(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_FCS_FLI1_Msg_Count, 0u) >> 6u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_10F007E8_Sig_FCS_LaneDepartureRightSide(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_FCS_FLI1_Msg_Count, 0u) >> 4u) & 0x03u));
}*/

uint8_t  Get_CAN_CH0_ID_0CFF1ADA_Sig_PDC_Warning_Frq(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_PDC_Status_Msg_Count, 4u) >> 0u) & 0x07u));
}

uint8_t  Get_CAN_CH0_ID_0CFF1ADA_Sig_PDC_Distance_RR(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_PDC_Status_Msg_Count, 3u) >> 0u) & 0x3Fu));
}

uint8_t  Get_CAN_CH0_ID_0CFF1ADA_Sig_PDC_Distance_RCR(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_PDC_Status_Msg_Count, 2u) >> 0u) & 0x3Fu));
}

uint8_t  Get_CAN_CH0_ID_0CFF1ADA_Sig_PDC_Distance_RCL(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_PDC_Status_Msg_Count, 1u) >> 0u) & 0x3Fu));
}

uint8_t  Get_CAN_CH0_ID_0CFF1ADA_Sig_PDC_SystemState(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_PDC_Status_Msg_Count, 0u) >> 7u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_0CFF1ADA_Sig_PDC_VirtualDisplaySts(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_PDC_Status_Msg_Count, 0u) >> 6u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_0CFF1ADA_Sig_PDC_Distance_RL(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_PDC_Status_Msg_Count, 0u) >> 0u) & 0x3Fu));
}

//uint8_t  Get_CAN_CH0_ID_18FEAE30_Sig_IC_ServiceBrakeCircuit2AirPre(void)
//{
//    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_IC_AIR1_Msg_Count, 3u) >> 0u) & 0xFFu));
//}
//
//uint8_t  Get_CAN_CH0_ID_18FEAE30_Sig_IC_ServiceBrakeCircuit1AirPre(void)
//{
//    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_IC_AIR1_Msg_Count, 2u) >> 0u) & 0xFFu));
//}

/*uint8_t  Get_CAN_CH0_ID_0CF02FA0_Sig_FCS_CollisionWarningLevel(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_FCS_AEBS1_Msg_Count, 0u) >> 4u) & 0x0Fu));
}

uint8_t  Get_CAN_CH0_ID_0CF02FA0_Sig_FCS_AEBState(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_FCS_AEBS1_Msg_Count, 0u) >> 0u) & 0x0Fu));
}*/

/*uint8_t  Get_CAN_CH0_ID_18FFDD21_Sig_BCM_TankFlapSts(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_BCM_StateUpdate_Msg_Count, 4u) >> 4u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_18FFDD21_Sig_BCM_FuLidNotClsd(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_BCM_StateUpdate_Msg_Count, 2u) >> 4u) & 0x01u));
}*/

uint8_t  Get_CAN_CH0_ID_18FFDD21_Sig_BCM_KeyInwithDrvDoorAjar(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_BCM_StateUpdate_Msg_Count, 3u) >> 3u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_18FFE133_Sig_TPMS_Manual_LearnSts(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_TPMS_ManualLearnResp_Msg_Count, 1u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_18FFE133_Sig_TPMS_Manual_LearnLocation(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_TPMS_ManualLearnResp_Msg_Count, 0u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_18FF639F_Sig_TBOX_OTA_DisclaimerWarning(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_T_BOX_OTAStatus_Msg_Count, 3u) >> 0u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_18FF639F_Sig_TBOX_OTA_PreConditionDetect(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_T_BOX_OTAStatus_Msg_Count, 2u) >> 7u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_18FF639F_Sig_TBOX_OTA_FailedReason_HVStatus(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_T_BOX_OTAStatus_Msg_Count, 2u) >> 6u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_18FF639F_Sig_TBOX_OTA_FailedReason_ChgStatus(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_T_BOX_OTAStatus_Msg_Count, 2u) >> 5u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_18FF639F_Sig_TBOX_OTA_FailedReason_HandBrake(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_T_BOX_OTAStatus_Msg_Count, 2u) >> 4u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_18FF639F_Sig_TBOX_OTA_FailedReason_BattVo(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_T_BOX_OTAStatus_Msg_Count, 2u) >> 3u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_18FF639F_Sig_TBOX_OTA_FailedReason_VehicleSpd(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_T_BOX_OTAStatus_Msg_Count, 2u) >> 2u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_18FF639F_Sig_TBOX_OTA_FailedReason_GearPos(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_T_BOX_OTAStatus_Msg_Count, 2u) >> 1u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_18FF639F_Sig_TBOX_OTA_FailedReason_PowerMode(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_T_BOX_OTAStatus_Msg_Count, 2u) >> 0u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_18FF639F_Sig_TBOX_OTA_DownloadProgress(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_T_BOX_OTAStatus_Msg_Count, 1u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_18FF639F_Sig_TBOX_OTA_Mode(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_T_BOX_OTAStatus_Msg_Count, 0u) >> 7u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_18FF639F_Sig_TBOX_OTA_UpdateState(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_T_BOX_OTAStatus_Msg_Count, 0u) >> 4u) & 0x07u));
}

uint8_t  Get_CAN_CH0_ID_18FF639F_Sig_TBOX_OTA_UpdateRequest(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_T_BOX_OTAStatus_Msg_Count, 0u) >> 3u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_18FF639F_Sig_TBOX_OTA_DownloadState(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_T_BOX_OTAStatus_Msg_Count, 0u) >> 1u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_18FF639F_Sig_TBOX_OTA_DownloadRequest(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_T_BOX_OTAStatus_Msg_Count, 0u) >> 0u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_18FF789F_Sig_TBOX_LineDiscntSts(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_TBOX_HeartBeatMsg_Msg_Count, 0u) >> 0u) & 0x03u));
}

//uint8_t  Get_CAN_CH0_ID_0CFAB127_Sig_PMS_EnergyModeIndication(void)
//{
//    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_PMS_CFAB127_Msg_Count, 6u) >> 4u) & 0x07u));
//}

uint8_t  Get_CAN_CH0_ID_0CFAB127_Sig_PMS_VehicleSpd_flag(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_PMS_CFAB127_Msg_Count, 6u) >> 3u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_0CFAB127_Sig_PMS_ePTRegencyLevInd(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_PMS_CFAB127_Msg_Count, 3u) >> 0u) & 0x07u));
}

uint16_t Get_CAN_CH0_ID_0CFAB127_Sig_PMS_VehicleSpd(void)
{
    return (((uint16_t)((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_PMS_CFAB127_Msg_Count, 2u) >> 0u) & 0xFFu) << 8u) + \
    ((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_PMS_CFAB127_Msg_Count, 1u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_0CFAB127_Sig_PMS_SDCACStopFault(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_PMS_CFAB127_Msg_Count, 0u) >> 3u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_0CFAB127_Sig_PMS_DriverOperationReminder(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_PMS_CFAB127_Msg_Count, 0u) >> 0u) & 0x07u));
}

uint8_t  Get_CAN_CH0_ID_18FA40F4_Sig_BMS_FaultLevel(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_EMS_18FA40F4_Msg_Count, 6u) >> 6u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_18FA40F4_Sig_BMS_BattSOC(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_EMS_18FA40F4_Msg_Count, 4u) >> 0u) & 0xFFu));
}

uint16_t Get_CAN_CH0_ID_18FA40F4_Sig_BMS_BattCurr(void)
{
    return (((uint16_t)((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_EMS_18FA40F4_Msg_Count, 3u) >> 0u) & 0xFFu) << 8u) + \
    ((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_EMS_18FA40F4_Msg_Count, 2u) >> 0u) & 0xFFu));
}

uint16_t Get_CAN_CH0_ID_18FA40F4_Sig_BMS_BattVol(void)
{
    return (((uint16_t)((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_EMS_18FA40F4_Msg_Count, 1u) >> 0u) & 0xFFu) << 8u) + \
    ((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_EMS_18FA40F4_Msg_Count, 0u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_18FAB027_Sig_PMS_BrkSysErr(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_PMS_18FAB027_Msg_Count, 5u) >> 6u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_18FAB027_Sig_PMS_VehicleSlipWarning(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_PMS_18FAB027_Msg_Count, 5u) >> 2u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_18FAB027_Sig_PMS_HandbrakeSts(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_PMS_18FAB027_Msg_Count, 5u) >> 0u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_18FAB027_Sig_PMS_GearPositionInd(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_PMS_18FAB027_Msg_Count, 4u) >> 0u) & 0xFFu));
}

uint16_t Get_CAN_CH0_ID_18FAB027_Sig_PMS_PTSysElecPwrInd(void)
{
    return (((uint16_t)((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_PMS_18FAB027_Msg_Count, 3u) >> 0u) & 0xFFu) << 8u) + \
    ((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_PMS_18FAB027_Msg_Count, 2u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_18FAB027_Sig_PMS_GearOperateErr(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_PMS_18FAB027_Msg_Count, 1u) >> 6u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_18FAB027_Sig_PMS_PTHVSysErrorLampStsInd(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_PMS_18FAB027_Msg_Count, 1u) >> 4u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_18FAB027_Sig_PMS_DCDC_WorkSts(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_PMS_18FAB027_Msg_Count, 1u) >> 2u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_18FAB027_Sig_PMS_TurtleLampReq(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_PMS_18FAB027_Msg_Count, 1u) >> 0u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_18FAB027_Sig_PMS_DrivePwrCircuitInd(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_PMS_18FAB027_Msg_Count, 0u) >> 6u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_18FAB027_Sig_PMS_PTReadyInd(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_PMS_18FAB027_Msg_Count, 0u) >> 4u) & 0x03u));
}

/*uint8_t  Get_CAN_CH0_ID_18FAB027_Sig_PMS_PTModeInd(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_PMS_18FAB027_Msg_Count, 0u) >> 2u) & 0x03u));
}*/

uint8_t  Get_CAN_CH0_ID_18FAB027_Sig_PMS_DriveModeInd(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_PMS_18FAB027_Msg_Count, 0u) >> 0u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_18FA92D0_Sig_EMS_PresReliefReady(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_EMS_18FA92D0_Msg_Count, 4u) >> 6u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_18FA92D0_Sig_EMS_FTIVFault(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_EMS_18FA92D0_Msg_Count, 4u) >> 5u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_18FA92D0_Sig_EMS_GPFRegenerationInd(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_EMS_18FA92D0_Msg_Count, 1u) >> 6u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_18FA92D0_Sig_EMS_OilPressureWarning(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_EMS_18FA92D0_Msg_Count, 1u) >> 5u) & 0x01u));
}

/*uint8_t  Get_CAN_CH0_ID_18FA92D0_Sig_EMS_EngineMILTelltale(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_EMS_18FA92D0_Msg_Count, 1u) >> 2u) & 0x01u));
}*/

uint8_t  Get_CAN_CH0_ID_18FA92D0_Sig_EMS_EngineSVSTelltale(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_EMS_18FA92D0_Msg_Count, 1u) >> 1u) & 0x01u));
}

/*uint8_t  Get_CAN_CH0_ID_18FA92D0_Sig_EMS_EngineCoolantTemperatureinvalid(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_EMS_18FA92D0_Msg_Count, 1u) >> 0u) & 0x01u));
}*/

uint8_t  Get_CAN_CH0_ID_18FA92D0_Sig_EMS_EngineCoolantTemperature(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_EMS_18FA92D0_Msg_Count, 0u) >> 0u) & 0xFFu));
}

/*uint8_t  Get_CAN_CH0_ID_18FA6489_Sig_HMS_FltLevel(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_HMS_18FA6489_Msg_Count, 2u) >> 4u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_18FA6489_Sig_HMS_FillStatus(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_HMS_18FA6489_Msg_Count, 2u) >> 0u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_18FA6489_Sig_HMS_H2SOC(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_HMS_18FA6489_Msg_Count, 1u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_18FA6489_Sig_HMS_ErrorCode(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_HMS_18FA6489_Msg_Count, 0u) >> 2u) & 0x3Fu));
}

uint8_t  Get_CAN_CH0_ID_18FA6489_Sig_HMS_HighPressSts(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_HMS_18FA6489_Msg_Count, 0u) >> 0u) & 0x03u));
}

uint16_t Get_CAN_CH0_ID_18FA6389_Sig_HMS_MaxPres(void)
{
    return (((uint16_t)((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_HMS_18FA6389_Msg_Count, 1u) >> 0u) & 0xFFu) << 8u) + \
    ((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_HMS_18FA6389_Msg_Count, 0u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_18FEE6EE_Sig_IC_Year(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_IC_18FEE6EE_Msg_Count, 5u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_18FEE6EE_Sig_IC_Day(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_IC_18FEE6EE_Msg_Count, 4u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_18FEE6EE_Sig_IC_Month(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_IC_18FEE6EE_Msg_Count, 3u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_18FEE6EE_Sig_IC_Hour(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_IC_18FEE6EE_Msg_Count, 2u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_18FEE6EE_Sig_IC_Minute(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_IC_18FEE6EE_Msg_Count, 1u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_18FEE6EE_Sig_IC_Second(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_IC_18FEE6EE_Msg_Count, 0u) >> 0u) & 0xFFu));
}*/

uint8_t  Get_CAN_CH0_ID_18FF2319_Sig_AC_AmbientTemperature(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_AC_18FF2319_Msg_Count, 4u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_18FF2319_Sig_AC_AmbientTemperatureInvalid(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_AC_18FF2319_Msg_Count, 1u) >> 1u) & 0x01u));
}

/*uint16_t Get_CAN_CH0_ID_18FAB227_Sig_PMS_FuleDTEodometer(void)
{
    return (((uint16_t)((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_PMS_18FAB227_Msg_Count, 7u) >> 0u) & 0xFFu) << 8u) + \
    ((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_PMS_18FAB227_Msg_Count, 6u) >> 0u) & 0xFFu));
}*/

uint16_t Get_CAN_CH0_ID_18FAB227_Sig_PMS_EVDTE_odometer(void)
{
    return (((uint16_t)((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_PMS_18FAB227_Msg_Count, 5u) >> 0u) & 0xFFu) << 8u) + \
    ((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_PMS_18FAB227_Msg_Count, 4u) >> 0u) & 0xFFu));
}

/*uint16_t Get_CAN_CH0_ID_18FAB227_Sig_PMS_AvgFuelVF(void)
{
    return (((uint16_t)((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_PMS_18FAB227_Msg_Count, 3u) >> 0u) & 0xFFu) << 8u) + \
    ((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_PMS_18FAB227_Msg_Count, 2u) >> 0u) & 0xFFu));
}*/

uint16_t Get_CAN_CH0_ID_18FAB227_Sig_PMS_AvgEVConsume(void)
{
    return (((uint16_t)((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_PMS_18FAB227_Msg_Count, 1u) >> 0u) & 0xFFu) << 8u) + \
    ((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_PMS_18FAB227_Msg_Count, 0u) >> 0u) & 0xFFu));
}

/*uint32_t Get_CAN_CH0_ID_18FEC117_Sig_IC_TotalVehicleDistance(void)
{
    return (((uint32_t)((uint32_t)((uint32_t)((uint32_t)((uint32_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_IC_18FEC117_Msg_Count, 3u) >> 0u) & 0xFFu) << 8u) + \
    ((uint32_t)((uint32_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_IC_18FEC117_Msg_Count, 2u) >> 0u) & 0xFFu) << 8u) + \
    ((uint32_t)((uint32_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_IC_18FEC117_Msg_Count, 1u) >> 0u) & 0xFFu) << 8u) + \
    ((uint32_t)((uint32_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_IC_18FEC117_Msg_Count, 0u) >> 0u) & 0xFFu));
}

uint32_t Get_CAN_CH0_ID_18FEC117_Sig_IC_TripDistance(void)
{
    return (((uint32_t)((uint32_t)((uint32_t)((uint32_t)((uint32_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_IC_18FEC117_Msg_Count, 7u) >> 0u) & 0xFFu) << 8u) + \
    ((uint32_t)((uint32_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_IC_18FEC117_Msg_Count, 6u) >> 0u) & 0xFFu) << 8u) + \
    ((uint32_t)((uint32_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_IC_18FEC117_Msg_Count, 5u) >> 0u) & 0xFFu) << 8u) + \
    ((uint32_t)((uint32_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_IC_18FEC117_Msg_Count, 4u) >> 0u) & 0xFFu));
}*/

uint16_t Get_CAN_CH0_ID_18FAB327_Sig_PMS_PTResiduePwrInd(void)
{
    return (((uint16_t)((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_PMS_18FAB327_Msg_Count, 7u) >> 0u) & 0xFFu) << 8u) + \
    ((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_PMS_18FAB327_Msg_Count, 6u) >> 0u) & 0xFFu));
}

uint32_t Get_CAN_CH0_ID_18FAB327_Sig_PMS_VehCruisingDistance(void)
{
    return (((uint32_t)((uint32_t)((uint32_t)((uint32_t)((uint32_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_PMS_18FAB327_Msg_Count, 3u) >> 0u) & 0xFFu) << 8u) + \
    ((uint32_t)((uint32_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_PMS_18FAB327_Msg_Count, 2u) >> 0u) & 0xFFu) << 8u) + \
    ((uint32_t)((uint32_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_PMS_18FAB327_Msg_Count, 1u) >> 0u) & 0xFFu) << 8u) + \
    ((uint32_t)((uint32_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_PMS_18FAB327_Msg_Count, 0u) >> 0u) & 0xFFu));
}

/*uint8_t  Get_CAN_CH0_ID_18FA48F4_Sig_BMS_IC_Temp(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_BMS_18FA48F4_Msg_Count, 7u) >> 0u) & 0xFFu));
}*/

uint8_t  Get_CAN_CH0_ID_18FA48F4_Sig_BMS_BattMaxTemp1(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_BMS_18FA48F4_Msg_Count, 3u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_18FA48F4_Sig_BMS_BattMinTemp1(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_BMS_18FA48F4_Msg_Count, 0u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_0CFAA627_Sig_PMS_ControlSetSpeed(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_PMS_0CFAA627_Msg_Count, 5u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_0CFAA627_Sig_PMS_CruiseControlSts(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_PMS_0CFAA627_Msg_Count, 4u) >> 4u) & 0x07u));
}

/*uint8_t  Get_CAN_CH0_ID_18FACA2A_Sig_FCS_ALOD_TimeGap(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_FCS_18FACA2A_Msg_Count, 2u) >> 0u) & 0x07u));
}

uint8_t  Get_CAN_CH0_ID_18FACA2A_Sig_FCS_ACC_Info(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_FCS_18FACA2A_Msg_Count, 2u) >> 3u) & 0x1Fu));
}

uint8_t  Get_CAN_CH0_ID_18FACA2A_Sig_FCS_ALOD_SpeedSetDisp(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_FCS_18FACA2A_Msg_Count, 1u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_18FACA2A_Sig_FCS_ALOD_Warning(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_FCS_18FACA2A_Msg_Count, 0u) >> 6u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_18FACA2A_Sig_FCS_ALOD_TargetDisplay(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_FCS_18FACA2A_Msg_Count, 0u) >> 4u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_18FACA2A_Sig_FCS_ALOD_Status(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_FCS_18FACA2A_Msg_Count, 0u) >> 0u) & 0x0Fu));
}*/

uint8_t  Get_CAN_CH0_ID_18FF629F_Sig_TBOX_BatteryVoltageLowWarning(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_TBOX_18FF629F_Msg_Count, 2u) >> 0u) & 0x01u));
}

uint16_t Get_CAN_CH0_ID_18FF629F_Sig_TBOX_BatteryVoltage(void)
{
    return (((uint16_t)((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_TBOX_18FF629F_Msg_Count, 1u) >> 0u) & 0xFFu) << 8u) + \
    ((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_TBOX_18FF629F_Msg_Count, 0u) >> 0u) & 0xFFu));
}

uint16_t Get_CAN_CH0_ID_18FAA027_Sig_PMS_ErrCode(void)
{
    return (((uint16_t)((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_PMS_18FAA027_Msg_Count, 1u) >> 0u) & 0xFFu) << 8u) + \
    ((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_PMS_18FAA027_Msg_Count, 0u) >> 0u) & 0xFFu));
}

/*uint8_t  Get_CAN_CH0_ID_18FA60D5_Sig_HFCU_LqdSts(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_HFCU_18FA60D5_Msg_Count, 5u) >> 0u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_18FA60D5_Sig_HFCU_FltLvl(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_HFCU_18FA60D5_Msg_Count, 0u) >> 4u) & 0x0Fu));
}

uint8_t  Get_CAN_CH0_ID_18FA60D5_Sig_HFCU_StsFlg(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_HFCU_18FA60D5_Msg_Count, 0u) >> 0u) & 0x0Fu));
}*/

uint16_t Get_CAN_CH0_ID_18FA4AF4_Sig_BMS_MaxCellVolt(void)
{
    return (((uint16_t)((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_BMS_18FA4AF4_Msg_Count, 5u) >> 0u) & 0xFFu) << 8u) + \
    ((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_BMS_18FA4AF4_Msg_Count, 4u) >> 0u) & 0xFFu));
}

uint16_t Get_CAN_CH0_ID_18FA4AF4_Sig_BMS_MinCellVolt(void)
{
    return (((uint16_t)((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_BMS_18FA4AF4_Msg_Count, 1u) >> 0u) & 0xFFu) << 8u) + \
    ((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_BMS_18FA4AF4_Msg_Count, 0u) >> 0u) & 0xFFu));
}

/*uint8_t  Get_CAN_CH0_ID_18FACAE8_Sig_FCS_LKAState(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_FCS_18FACAE8_Msg_Count, 0u) >> 4u) & 0x0Fu));
}

uint8_t  Get_CAN_CH0_ID_18FACAE8_Sig_FCS_LKATakeoverRequest(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_FCS_18FACAE8_Msg_Count, 0u) >> 2u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_18FACAE8_Sig_FCS_LKAHandsOffWarning(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_FCS_18FACAE8_Msg_Count, 0u) >> 0u) & 0x03u));
}*/

uint8_t  Get_CAN_CH0_ID_18FF0BDF_Sig_PEPS_SSB_Failure_warning(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_PSPS_18FF0BDF_Msg_Count, 6u) >> 2u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_18FF0BDF_Sig_PEPS_Warning_Keyout(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_PSPS_18FF0BDF_Msg_Count, 6u) >> 0u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_18FF0BDF_Sig_PEPS_Indication_UID_Closer(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_PSPS_18FF0BDF_Msg_Count, 4u) >> 3u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_18FF0BDF_Sig_PEPS_Warning_IMMO_Fail(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_PSPS_18FF0BDF_Msg_Count, 4u) >> 0u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_18FF0BDF_Sig_PEPS_Warn_UID_LOW_BATT(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_PSPS_18FF0BDF_Msg_Count, 3u) >> 6u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_18FF0BDF_Sig_PEPS_IGN1FailureWarning(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_PSPS_18FF0BDF_Msg_Count, 3u) >> 4u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_18FF0BDF_Sig_PEPS_Indication_shift_to_Park(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_PSPS_18FF0BDF_Msg_Count, 3u) >> 0u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_18FF0BDF_Sig_PEPS_Indication_shift_to_PN(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_PSPS_18FF0BDF_Msg_Count, 2u) >> 6u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_18FF0BDF_Sig_PEPS_Indication_press_brake_clutch(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_PSPS_18FF0BDF_Msg_Count, 2u) >> 5u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_18FF0BDF_Sig_PEPS_Warning_No_key_found(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_PSPS_18FF0BDF_Msg_Count, 2u) >> 3u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_18FF0BDF_Sig_PEPS_SystemFault(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_PSPS_18FF0BDF_Msg_Count, 0u) >> 0u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_18FA42F4_Sig_BMS_BattSOCFault(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_BMS_18FA42F4_Msg_Count, 0u) >> 6u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_18FA42F4_Sig_BMS_BattTempFault(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_BMS_18FA42F4_Msg_Count, 0u) >> 4u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_0CFABF8F_Sig_EPB_SafeBeltNotTiedLmtReleaseWarning(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_EPB_0CFABF8F_Msg_Count, 3u) >> 2u) & 0x03u));
}

/*uint8_t  Get_CAN_CH0_ID_0CFABF8F_Sig_EPB_ChildLockActive(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_EPB_0CFABF8F_Msg_Count, 3u) >> 0u) & 0x03u));
}*/

uint8_t  Get_CAN_CH0_ID_0CFABF8F_Sig_EPB_WarningLampState(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_EPB_0CFABF8F_Msg_Count, 1u) >> 6u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_0CFABF8F_Sig_EPB_ParkLampState(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_EPB_0CFABF8F_Msg_Count, 1u) >> 4u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_18FA3EF4_Sig_BMS_DCChgPlugSts(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_BMS_18FA3EF4_Msg_Count, 1u) >> 0u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_18FA3EF4_Sig_BMS_ChgStatus(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_BMS_18FA3EF4_Msg_Count, 0u) >> 4u) & 0x0Fu));
}

uint8_t  Get_CAN_CH0_ID_18FAC490_Sig_ACU_AirbagWarningStatus(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ACU_18FAC490_Msg_Count, 0u) >> 5u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_18FAAE27_Sig_PMS_OverloadInd(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_PMS_18FAAE27_Msg_Count, 4u) >> 0u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_0C012705_Sig_EGSM_LockStatus(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_EGSM_0C012705_Msg_Count, 5u) >> 1u) & 0x07u));
}

uint8_t  Get_CAN_CH0_ID_0C012705_Sig_EGSM_WorkStatus(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_EGSM_0C012705_Msg_Count, 0u) >> 0u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_18FA41F4_Sig_BMS_TempOutofCtr(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_BMS_18FA41F4_Msg_Count, 5u) >> 0u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_18FA41F4_Sig_BMS_HVIsolationSts(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_BMS_18FA41F4_Msg_Count, 4u) >> 0u) & 0x07u));
}

/*uint8_t  Get_CAN_CH0_ID_18FF4A41_Sig_MMI_WorkMode(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_MMI_18FF4A41_Msg_Count, 1u) >> 4u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_18FF4A41_Sig_MMI_ConfirmSwStatus(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_MMI_18FF4A41_Msg_Count, 1u) >> 0u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_18FF4A41_Sig_MMI_DownSwStatus(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_MMI_18FF4A41_Msg_Count, 0u) >> 6u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_18FF4A41_Sig_MMI_UpSwStatus(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_MMI_18FF4A41_Msg_Count, 0u) >> 4u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_18FF4A41_Sig_MMI_LeftSwStatus(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_MMI_18FF4A41_Msg_Count, 0u) >> 2u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_18FF4A41_Sig_MMI_RightSwStatus(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_MMI_18FF4A41_Msg_Count, 0u) >> 0u) & 0x03u));
}*/

uint8_t  Get_CAN_CH0_ID_18FA02EF_Sig_MCU_MotorFltLevel(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_MCU_18FA02EF_Msg_Count, 3u) >> 6u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_18FA02EF_Sig_MCU_MotorTempHighAlarm(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_MCU_18FA02EF_Msg_Count, 1u) >> 2u) & 0x03u));
}

/*uint8_t  Get_CAN_CH0_ID_18FA63D5_Sig_HFCU_ConductHigh(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_HFCU_18FA63D5_Msg_Count, 4u) >> 0u) & 0x03u));
}*/

uint8_t  Get_CAN_CH0_ID_18FA98D0_Sig_PMS_EngMaintanceFlag(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_PMS_18FA98D0_Msg_Count, 4u) >> 1u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_18FA98D0_Sig_PMS_EngMaintainWarningSts(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_PMS_18FA98D0_Msg_Count, 4u) >> 0u) & 0x01u));
}

uint16_t Get_CAN_CH0_ID_18FA98D0_Sig_PMS_EngServiceMaintainInterval(void)
{
    return (((uint16_t)((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_PMS_18FA98D0_Msg_Count, 3u) >> 0u) & 0xFFu) << 8u) + \
    ((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_PMS_18FA98D0_Msg_Count, 2u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_0CFFB303_Sig_TCU_PTO_Fault(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_TCU_0CFFB303_Msg_Count, 6u) >> 6u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_18FA1727_Sig_PMS_SpdLmtLevelReq(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_PMS_18FA1727_Msg_Count, 0u) >> 4u) & 0x03u));
}

/*uint8_t  Get_CAN_CH0_ID_18FF649F_Sig_TBOX_AnnualViolationPro(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_TBOX_18FF649F_Msg_Count, 2u) >> 5u) & 0x07u));
}

uint8_t  Get_CAN_CH0_ID_18FF649F_Sig_TBOX_EthAbnormalPrompt(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_TBOX_18FF649F_Msg_Count, 2u) >> 4u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_18FF649F_Sig_TBOX_PaymentPrompt(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_TBOX_18FF649F_Msg_Count, 1u) >> 4u) & 0x0Fu));
}

uint8_t  Get_CAN_CH0_ID_18FF649F_Sig_TBOX_MaintenanceRemind(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_TBOX_18FF649F_Msg_Count, 1u) >> 0u) & 0x0Fu));
}

uint8_t  Get_CAN_CH0_ID_18FF5241_Sig_MMI_NavTunnelIndication(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_MMI_18FF5241_Msg_Count, 4u) >> 3u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_18FF5241_Sig_MMI_NavDestinationIndication(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_MMI_18FF5241_Msg_Count, 4u) >> 2u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_18FF5241_Sig_MMI_NavRestAreaIndication(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_MMI_18FF5241_Msg_Count, 4u) >> 1u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_18FF5241_Sig_MMI_TollGateIndication(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_MMI_18FF5241_Msg_Count, 4u) >> 0u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_18FF5241_Sig_MMI_NextCrossDistanceUnitIndicate(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_MMI_18FF5241_Msg_Count, 3u) >> 3u) & 0x01u));
}

uint16_t Get_CAN_CH0_ID_18FF5241_Sig_MMI_NextCrossDistanceIndicate(void)
{
    return (((uint16_t)((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_MMI_18FF5241_Msg_Count, 2u) >> 0u) & 0xFFu) << 2u) + \
    ((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_MMI_18FF5241_Msg_Count, 1u) >> 6u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_18FF5241_Sig_MMI_TurningDirectionType(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_MMI_18FF5241_Msg_Count, 1u) >> 0u) & 0x1Fu));
}

uint32_t Get_CAN_CH0_ID_18FF5141_Sig_MMI_DestinationDistanceIndicate(void)
{
    return (((uint32_t)((uint32_t)((uint32_t)((uint32_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_MMI_18FF5141_Msg_Count, 7u) >> 0u) & 0xFFu) << 8u) + \
    ((uint32_t)((uint32_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_MMI_18FF5141_Msg_Count, 6u) >> 0u) & 0xFFu) << 8u) + \
    ((uint32_t)((uint32_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_MMI_18FF5141_Msg_Count, 5u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_18FF5141_Sig_MMI_DestinationDistanceUnitIndicate(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_MMI_18FF5141_Msg_Count, 4u) >> 5u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_18FF5141_Sig_MMI_DestinationTime_Hour(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_MMI_18FF5141_Msg_Count, 4u) >> 0u) & 0x1Fu));
}

uint8_t  Get_CAN_CH0_ID_18FF5141_Sig_MMI_DestinationTime_Minute(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_MMI_18FF5141_Msg_Count, 3u) >> 0u) & 0x3Fu));
}

uint8_t  Get_CAN_CH0_ID_18FF5141_Sig_MMI_CurrentRoadType(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_MMI_18FF5141_Msg_Count, 1u) >> 4u) & 0x0Fu));
}*/

uint16_t Get_CAN_CH0_ID_18FC03F4_Sig_BMS_ChgTimeRemain(void)
{
    return (((uint16_t)((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_BMS_18FC03F4_Msg_Count, 7u) >> 0u) & 0xFFu) << 8u) + \
    ((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_BMS_18FC03F4_Msg_Count, 6u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_18FF5F27_Sig_PMS_MILTelltale(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_PMS_18FF5F27_Msg_Count, 3u) >> 0u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_18FAA527_Sig_PMS_EDCP_FaultFB(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_PMS_18FAA527_Msg_Count, 5u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_18FAA527_Sig_PMS_ECPM_FaultFB(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_PMS_18FAA527_Msg_Count, 4u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_18FAA527_Sig_PMS_HBCP_FaultFB(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_PMS_18FAA527_Msg_Count, 3u) >> 0u) & 0xFFu));
}

/*uint8_t  Get_CAN_CH0_ID_0CFA90D0_Sig_PFCU_IdleTypeResp(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_PFCU_0CFA90D0_Msg_Count, 6u) >> 0u) & 0x03u));
}*/

uint8_t  Get_CAN_CH0_ID_18FFC095_Sig_AVAS_AVASDisabledSts(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_AVAS_18FFC095_Msg_Count, 0u) >> 0u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_18FF4C41_Sig_MMI_IC_LanguageSet(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_MMI_18FF4C41_Msg_Count, 3u) >> 6u) & 0x03u));
}

/*uint8_t  Get_CAN_CH0_ID_18FFB403_Sig_TCU_FltLevel(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_TCU_18FFB403_Msg_Count, 0u) >> 0u) & 0x03u));
}*/

uint8_t  Get_CAN_CH0_ID_18FF5D27_Sig_PMS_LockVehSts(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_PMS_18FF5D27_Msg_Count, 0u) >> 0u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_0CFABA13_Sig_EPS_WarningLamp(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_EPS_0CFABA13_Msg_Count, 1u) >> 0u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_18FE4F0B_Sig_ESC_VDCFullyOperational(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ESC_18FE4F0B_Msg_Count, 0u) >> 2u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_18FE4F0B_Sig_ESC_VDCInformationSignal(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_ESC_18FE4F0B_Msg_Count, 0u) >> 0u) & 0x03u));
}

/*uint8_t  Get_CAN_CH0_ID_18FECAE8_Sig_FCS_AmberWarningLamp(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_FCS_18FECAE8_Msg_Count, 0u) >> 2u) & 0x03u));
}*/
const uint32_t u32CoCanConvertSubID[CAN_CH0_ID_TOTAL_MAX]=
{
    CAN_CH0_ID_BCM_light_Msg,
     CAN_CH0_ID_ABS_EBS_EBC1_Msg,
     CAN_CH0_ID_TPMS_TireInfor_Msg,
     CAN_CH0_ID_BCM_DoorControl2_Msg,  
     CAN_CH0_ID_EPB_StsInfor_Msg,  
     CAN_CH0_ID_DMM_StsInfor_Msg,
     CAN_CH0_ID_TBOX_TD_Msg,  
     CAN_CH0_ID_PDC_Status_Msg,
     CAN_CH0_ID_BCM_StateUpdate_Msg,
     CAN_CH0_ID_TPMS_ManualLearnResp_Msg,
     CAN_CH0_ID_T_BOX_OTAStatus_Msg,
     CAN_CH0_ID_TBOX_HeartBeatMsg_Msg,
     CAN_CH0_ID_PMS_CFAB127_Msg,
     CAN_CH0_ID_EMS_18FA40F4_Msg,
     CAN_CH0_ID_PMS_18FAB027_Msg,    
     CAN_CH0_ID_EMS_18FA92D0_Msg,   
     CAN_CH0_ID_AC_18FF2319_Msg,
     CAN_CH0_ID_PMS_18FAB227_Msg,  
     CAN_CH0_ID_PMS_18FAB327_Msg,
     CAN_CH0_ID_BMS_18FA48F4_Msg,
     CAN_CH0_ID_PMS_0CFAA627_Msg,
     CAN_CH0_ID_TBOX_18FF629F_Msg,
     CAN_CH0_ID_PMS_18FAA027_Msg,   
     CAN_CH0_ID_BMS_18FA4AF4_Msg,   
     CAN_CH0_ID_PSPS_18FF0BDF_Msg,
     CAN_CH0_ID_BMS_18FA42F4_Msg,   
     CAN_CH0_ID_EPB_0CFABF8F_Msg,
     CAN_CH0_ID_BMS_18FA3EF4_Msg, 
     CAN_CH0_ID_ACU_18FAC490_Msg, 
     CAN_CH0_ID_PMS_18FAAE27_Msg,
     CAN_CH0_ID_EGSM_0C012705_Msg,    
     CAN_CH0_ID_BMS_18FA41F4_Msg,
     //CAN_CH0_ID_MMI_18FF4A41_Msg,
     CAN_CH0_ID_MCU_18FA02EF_Msg,
     CAN_CH0_ID_PMS_18FA98D0_Msg,
     CAN_CH0_ID_TCU_0CFFB303_Msg,   
     CAN_CH0_ID_PMS_18FA1727_Msg,
     //CAN_CH0_ID_TBOX_18FF649F_Msg,
     //CAN_CH0_ID_MMI_18FF5241_Msg,
     //CAN_CH0_ID_MMI_18FF5141_Msg,
     CAN_CH0_ID_BMS_18FC03F4_Msg,    
     CAN_CH0_ID_PMS_18FF5F27_Msg,
     CAN_CH0_ID_PMS_18FAA527_Msg,
     CAN_CH0_ID_AVAS_18FFC095_Msg,
     CAN_CH0_ID_MMI_18FF4C41_Msg,  
     CAN_CH0_ID_PMS_18FF5D27_Msg,
     CAN_CH0_ID_EPS_0CFABA13_Msg,
     CAN_CH0_ID_ESC_18FE4F0B_Msg,
  
    
};

uint8_t  Co_Can_ConvertSubID_CAN_CH0(uint32_t MsgID)
{
    uint8_t u8Result = CAN_CH0_ID_TOTAL_MAX;
    uint8_t i=0;
    for ( i = 0; i < CAN_CH0_ID_TOTAL_MAX; i++)
    {
        if (MsgID==u32CoCanConvertSubID[i])
        {
            u8Result= i;
        }
    }
    
  
    return u8Result;
}

