//
#ifndef _FUTIAN_BackLight_H_
#define _FUTIAN_BackLight_H_



typedef enum
{
    Light_Lvl_1 = 1,
    Light_Lvl_2,
    Light_Lvl_3,
    Light_Lvl_4,
    Light_Lvl_5,
    Light_Lvl_Max, 
}_Mcd_Area_Enum;


/******************************************************************************

******************************************************************************/	    
#define   BL_PWM_DUTY_CYCLE                 BLPWMDutyCycle

#define   BL_PWM_DUTY_CYCLE_FILTER          5    //յռձȲڴֵΪЧռձ
#define   BL_PWM_FILTER_MAX_CNT             4   //ֹմ
#define   BL_SAMPLE_POINT                   10
#define   BL_PWM_DUTY_CYCLE_MAX             95
#define   BL_PWM_DUTY_CYCLE_MIN             10
#define   BL_PWM_DUTY_CYCLE_HYSTERESIS      3    //ز
#define   BL_PWM_DUTY_CYCLE_APPR_FACTOR     8    //ռձȱƽϵ 
#define   BL_PWM_DUTY_CYCLE_APPR_SPEED      20   //ռձȱƽ,λms  

#define   BL_OFF_TIME_DOOR_OPEN_ONLY        30

typedef struct
{
    uint8_t   Backup;
    uint16_t  Timer;
    uint16_t  HiLvTimer;
} BL_PWMCaptureStruct;

extern BL_PWMCaptureStruct  BL_PWMCapture ;

typedef struct
{
    uint8_t   InitTimer;
    uint8_t   Backup;
    uint8_t   BackupCnt;
    uint8_t   Sample[BL_SAMPLE_POINT];
    uint8_t   Ptr;
    uint8_t   Cnt;
    uint8_t   Locked;
    uint8_t   Timer;
    uint8_t   Current;
    uint8_t   Current_Last;
    uint8_t   Current_Dir;
    uint8_t   TractorMarker_Light;
    
} BlPWMFilterStruct;

// 
typedef struct
{
  uint8_t Duty;        //Ŀֵ
  uint8_t Level ; 
  
}BackLightCtrlStruct;

extern  BackLightCtrlStruct BackLightCtrl ; 


typedef struct
{
    uint8_t   DoorStatusBackup;
    uint16_t  Timer;
    uint16_t  BackupPwm;
} BlOFFCtrlStruct;


typedef struct
{
	uint16_t u16OffTimer;
	uint8_t u8LF_St:1;
	uint8_t u8LF_St_Last:1;
	uint8_t u8RF_St:1;
	uint8_t u8RF_St_Last:1;
    uint8_t u8LR_St:1;
	uint8_t u8LR_St_Last:1;
	uint8_t u8RR_St:1;
	uint8_t u8RR_St_Last:1;
	uint8_t u8Flag:1;
	
} _DoorOpen;
EXTERN _DoorOpen     		DoorOpen;

typedef struct
{
	uint16_t u16OffTimer;
	uint16_t u16OffTimer_Door;
	uint8_t u8Chg_St;
	uint8_t u8Chg_St_Last;
	uint8_t u8Flag;
	
} _ChargeStatus;

EXTERN _ChargeStatus     		ChargeStatus;

void Backlight_Init(void );					        	

void Dial_Backlight_Set(INT8U duty);
void TFT_Backlight_Set(INT8U duty);


void BL_PWM_Duty_Cycle_Capture_ISR ( void );

void BL_Management_service(void );
void BL_PWMDutyCycle_Filter_Get(void);
INT8U BL_PWM_Duty_Get(INT8U Level);
INT8U BL_PWM_Level_Get(INT8U Duty);

#endif 