#include "UDS_Common.h"
#include "IC_Config.h" 

uint8_t  SessionType = DefaultSession;

uint16_t S3_ServerCnt = S3_SERVER;
uint8_t  S3_ServerClear = 0u;
uint8_t  S3_ServerTimeOut = 1u;

uint8_t  UDSKL15Status = 0u;
uint8_t  HVoltageStatus = 0u;
uint8_t  LVoltageStatus = 0u;

uint16_t UDSTimer10ms = 0u;

uint8_t  S31DID62F3RequestStatus = 0u;

uint8_t  isDTCOpen = 1u;
uint8_t  isReceive = 1u;
uint8_t  isEnable = 0u;
uint16_t enableTimer = 0u;					            
uint16_t enableMaxTimer = KL15DTCEnableTimer;

DiagMSGUnion DiagMSG;
DiagFlagUnion DiagFlag;
Ser27_FlowCtrlUnion Ser27_FlowCtrl;
Ser27_FlowCtrlCntUnion Ser27_FlowCtrlCnt;
BootToDFlashInfoUnion BootToDFlashInfo;
Ser2EToDFlashInfoUnion Ser2EToDFlashInfo;
_CAN_Control CAN_Control;
uint8_t BUS_OFF_FLAG;
uint8_t BusOffEvent;/**
  *DTC����ʱ��
  */
uint32_t DTCTimerList[27] = {0u};

/**
  *msg�б�
  */
uint32_t msgList[22][4] =
{
    {0x18FF4A41, 8, 100, 0},
    {0x18FE4021, 8, 100,0},
    {0x0CFF0ADF, 8, 20,0},
    {0x0CFAB127, 8, 10,0},
    {0x18FA40F4, 8, 100,0},
    {0x18FFE033, 8, 200,0},
    {0x10F007E8, 8, 50,0},
    {0x0CF02FA0, 8, 50,0},
    {0x0CFABF8F, 8, 50,0},
    {0x18FFB88F, 8, 100,0},
    {0x0CFF1ADA, 8, 50,0},
    {0x18FA02EF, 8, 100,0},
    {0x18FF2319, 8, 100,0},
    {0x18FAC490, 8, 200,0},
    {0x18FFC095, 8, 100,0},
    {0x18F0010B, 8, 100,0},
    {0x0CFABA13, 8, 20,0},
    {0x18FE4F0B, 8, 100,0},
    {0x18FEE69F, 8, 1000,0},
    {0x0C012705, 8, 100,0},
    {0x18FAD084, 8, 100,0},

};

/*APP ���� & ����*/
void Com_RxStart(void) 
{
    CAN_Control.APP_RX_Enable = CAN_Control.APP_RX_Enable | NM_Enable;
}

void Com_TxStart(void) 
{
    CAN_Control.APP_TX_Enable = CAN_Control.APP_TX_Enable | NM_Enable;
}

void Com_RxStop(void) 
{
    CAN_Control.APP_RX_Enable = CAN_Control.APP_RX_Enable & NM_DisEnable;
}

void Com_TxStop(void) 
{
    CAN_Control.APP_TX_Enable = CAN_Control.APP_TX_Enable & NM_DisEnable;
}




/*��λ*/
static void AppExecute(void)
{
	COPCTL = 0x01; //enable watchdog
	ARMCOP = 0x00;
	//value written to ARMCOP register different from 0xAA or 0x55 will reset
	//the MCU immediately.
}
/**
  *���ûỰ����
  *@param status �Ự����
  */
void setSessionType(uint8_t status)
{
    if ((status == DefaultSession) || (status == ProgrammingSession) || (status == ExtendedDiagnosticSession))
    {
        SessionType = status;
    }
    else
    {
        SessionType = DefaultSession;
    }
}

/**
  *��ȡ�Ự����
  *@return ��ǰ�Ự����
  */
uint8_t getSessionType(void)
{
    return SessionType;
}

/**
  *���������Ϣ
  *@param Identifier �յ�����ϱ���ID
  *@param dlc �յ�����ϱ��ĳ���
  *@param Data �յ�����ϱ�������
  */
void setDiagMSG(uint32_t Identifier, uint16_t dlc, uint8_t Data[])
{
    uint8_t i;
    DiagMSG.msgID = Identifier;
    DiagMSG.msgDLC = dlc;
    for (i = 0u; i < dlc; ++i)
    {
        DiagMSG.msgData.Data[i] = Data[i];
    }
}

/**
  *��������Ϣ
  */
void clearDiagMSG(void)
{
    uint8_t i;
    DiagMSG.msgID = 0u;
    DiagMSG.msgDLC = 0u;
    for (i = 0u; i < DIM(DiagMSG.msgData.Data); ++i)
    {
        DiagMSG.msgData.Data[i] = 0u;
    }
}

/**
  *��ȡ��ǰ����
  *@return ���ص�ǰ����
  */
uint16_t getSpeed(void)
{
    Get_SigABS_VehicleSpeed();
    /*uint16_t VSpeed = Common_Get_Act_V_Speed();
    if(VSpeed == 0xFFFFu)
    {
        VSpeed = 0u;
    }
    return (VSpeed / 10u); */
}

/**
  *��ȡ��ǰת��
  *@return ���ص�ǰת��
  */
uint16_t getESpeed(void)
{
    /*uint16_t ESpeed = Common_Get_Act_E_Speed();
    if(ESpeed == 0xFFFFu)
    {
        ESpeed = 0u;
    }
    return ESpeed;*/
}

/**
  *��ȡ��ǰ30��ѹ
  *@return ���ص�ǰ30��ѹ
  */
uint16_t getKL30Voltage(void)
{

    return ADC_Read_Signal(0) + 200;
}

/**
  *��ȡ15��״̬
  *@return 15��״̬ 0ΪIGN OFF,1ΪIGN ON
  */
uint8_t getKL15Status(void)
{
    uint8_t res;
    if(SYS_OPR_STAT_IGN_ON) 
    {
        res = 1;
    } 
    else
    {
        res = 0;
    
    }
    return res;
}

/*��ȡ����*/
uint16_t Get_SigABS_VehicleSpeed(void)
{
    //shican
    //uint16_t ABS_vehicle_speed;
    //ABS_vehicle_speed = Steer_axlespeed_H;
    //ABS_vehicle_speed = ABS_vehicle_speed << 8;
    //ABS_vehicle_speed |= Steer_axlespeed_L;
    //return ABS_vehicle_speed;
    return Get_CAN_CH0_ID_0CFAB127_Sig_PMS_VehicleSpd();
}

/*��ȡת��*/
uint16_t Get_SigEMS_EngSpeed(void)
{
    //shican
    //uint16_t EMS_Engine_Speed;
    //EMS_Engine_Speed = EMS_EngSpeed_H;
    //EMS_Engine_Speed = EMS_Engine_Speed << 8;
    //EMS_Engine_Speed |= EMS_EngSpeed_L;
    //return EMS_Engine_Speed;
    return 0;
}
/**
  *��ȡ��ǰ��ȫ����
  *@return ���ص�ǰ��ȫ����
  */
uint8_t getSecurityLevel(void)
{
    return Ser27_FlowCtrl.LV1SafetyStatus;
}

/**
  *���ð�ȫ�ȼ�
  */
void Ser27_ChangeSessionHandle(void)
{
    Ser27_FlowCtrl.LV1Ctrl = SER27_CLEAR_REQ_SEEDED;
    Ser27_FlowCtrl.LV1Key[0]  = 0x00u;
    Ser27_FlowCtrl.LV1Key[1]  = 0x00u;
    Ser27_FlowCtrl.LV1Key[2]  = 0x00u;
    Ser27_FlowCtrl.LV1Key[3]  = 0x00u;
    Ser27_FlowCtrl.LV1SafetyStatus = NormalKeyLock;
    Ser27_FlowCtrl.LV1Seed[0] = 0x00u;
    Ser27_FlowCtrl.LV1Seed[1] = 0x00u;
    Ser27_FlowCtrl.LV1Seed[2] = 0x00u;
    Ser27_FlowCtrl.LV1Seed[3] = 0x00u;
}

/**
  *��λ����
  */
void UDS_RESET(void)
{
    ControlMessageCommunication(networkManagementMsgAndnormalMsg, disableRxAndTx);
    AppExecute();
}

/**
  *�����ʱ
  *@param count ��ʱ����
  */
void UDS_Delay(uint16_t count)
{
    uint16_t tmpcnt;
    tmpcnt = count;
    _FEED_COP();
    //?WDT_Clear();
    while (tmpcnt--)
    {
        nop();
    }
    //?WDT_Clear();
    _FEED_COP();
}

/**
  *�������11����������
  */
void UDS_S11_Sand(uint8_t subid)
{
    _CAN_TX_BUF_TYPE canMag;
    canMag.SendID = DIAG_ID_Tx;
    canMag.BUFF[0] = 0x02u;
    canMag.BUFF[1] = 0x51u;
    canMag.BUFF[2] = subid;
    canMag.BUFF[3] = FILLER_BYTE;
    canMag.BUFF[4] = FILLER_BYTE;
    canMag.BUFF[5] = FILLER_BYTE;
    canMag.BUFF[6] = FILLER_BYTE;
    canMag.BUFF[7] = FILLER_BYTE;
    canMag.Len = 8u;
    CAN0_TX_BUF_Set(canMag.BUFF,canMag.SendID,canMag.Len);
    UDS_Delay(3000u);
    UDS_Delay(3000u);
    UDS_S11_Confirm();
}

/**
  *���11����������ȷ��
  */
void UDS_S11_Confirm(void)
{
    UDS_RESET();
}

/**
  *�������78������
  */
void UDS_NRC78_Sand(uint8_t sid)
{
    _CAN_TX_BUF_TYPE canMag;
    canMag.SendID = DIAG_ID_Tx;
    canMag.BUFF[0] = 0x03u;
    canMag.BUFF[1] = 0x7Fu;
    canMag.BUFF[2] = sid;
    canMag.BUFF[3] = 0x78u;
    canMag.BUFF[4] = FILLER_BYTE;
    canMag.BUFF[5] = FILLER_BYTE;
    canMag.BUFF[6] = FILLER_BYTE;
    canMag.BUFF[7] = FILLER_BYTE;
    canMag.Len = 8u;
    CAN0_TX_BUF_Set(canMag.BUFF,canMag.SendID,canMag.Len);
}

/**
  *�������78������
  */
void UDS_14_SendRsp(uint8_t sid)
{
    _CAN_TX_BUF_TYPE canMag;
    canMag.SendID = DIAG_ID_Tx;
    canMag.BUFF[0] = 0x01u;
    canMag.BUFF[1] = 0x54u;
    canMag.BUFF[2] = FILLER_BYTE;
    canMag.BUFF[3] = FILLER_BYTE;
    canMag.BUFF[4] = FILLER_BYTE;
    canMag.BUFF[5] = FILLER_BYTE;
    canMag.BUFF[6] = FILLER_BYTE;
    canMag.BUFF[7] = FILLER_BYTE;
    canMag.Len = 8u;
    CAN0_TX_BUF_Set(canMag.BUFF,canMag.SendID,canMag.Len);
}


void UDS_SendNRCRsp(uint8_t sid,uint8_t status)
{
    _CAN_TX_BUF_TYPE canMag;
    canMag.SendID = DIAG_ID_Tx;
    canMag.BUFF[0] = 0x03u;
    canMag.BUFF[1] = 0x54u;
    canMag.BUFF[2] = sid;
    canMag.BUFF[3] = status;
    canMag.BUFF[4] = FILLER_BYTE;
    canMag.BUFF[5] = FILLER_BYTE;
    canMag.BUFF[6] = FILLER_BYTE;
    canMag.BUFF[7] = FILLER_BYTE;
    canMag.Len = 8u;
    CAN0_TX_BUF_Set(canMag.BUFF,canMag.SendID,canMag.Len);
}


/**
  *���50us����
  */
void UDS_50us_Service(void)
{
    ++UDSTimer10ms;
}

/**
  *���10ms����
  */
void UDS_10ms_Service(void)
{
    uint16_t count;
    UDS_KL15_init();
    if(UDSTimer10ms >= 200u)
    {
        count = UDSTimer10ms / 200u;
        UDSTimer10ms %= 200u;
        enableDTCTimer(count * 10u);
        MsgLostTimer(count * 10u);
        TestDTC(count * 10u);
        S3_Service(count * 10u);
        Ser27_ErrDelayTimerService(count * 10u);
    }
}

/**
  *���KL15init
  */
void UDS_KL15_init(void)
{
    uint8_t KL15Status = getKL15Status();
    if(UDSKL15Status == 0u)
    {
        if((KL15Status == 1u))
        {
            UDSKL15Status = 1u;
            setDTCEnableTimer(KL15DTCEnableTimer);
            S3_ServiceTimeOut();
            //DTCAgeing();  //���Բ���
        }
    }
    else
    {
        if(KL15Status == 0u)
        {
            UDSKL15Status = 0u;
            setDTCEnableTimer(KL15DTCEnableTimer);
        }
    }
}

/**
  *���ĵ��߼�ʱ��
  *@param timer ��ʱ�����ӵ�ʱ�䣬��λ��ms
  */
void MsgLostTimer(uint16_t timer)
{
    uint8_t i;
    uint8_t BUS_OFF_Status = getBusoffStatus();
    if((isEnable == 1u) && (isReceive == 1u) && (UDSKL15Status == 1u) && (BUS_OFF_Status == 0u) && (HVoltageStatus == 0u) && (LVoltageStatus == 0u))
    {
        for(i = 0u; i < (sizeof(msgList) / sizeof(msgList[0u])); ++i)
        {
            if(msgList[i][2u] < 50u)
            {
                if(msgList[i][3u] < 50u * OfflineLoopMultiple)
                {
                    msgList[i][3u] += timer;
                }
            }
            else
            {
                if(msgList[i][3u] < msgList[i][2u] * OfflineLoopMultiple)
                {
                    msgList[i][3u] += timer;
                }
            }
        }
    }
}

/**
  *�յ����������ʱ��
  *@param MsgID ����ID
  *@param DLC   ���ĳ���
  */
void ReceivedMsg(uint32_t MsgID, uint8_t DLC)
{
    uint8_t i;
    if(isReceive == 1u)
    {
        for(i = 0u; i < (sizeof(msgList) / sizeof(msgList[0u])); ++i)
        {
            if((MsgID == msgList[i][0u]) && (DLC == msgList[i][1u]))
            {
                msgList[i][3] = 0u;
                break;
            }
        }
    }
}

/**
  *S3����
  */
void S3_Service(uint16_t timer)
{
    if (S3_ServerClear == 1u)
    {
        S3_ServerClear = 0u;
        S3_ServerCnt = 0u;
        S3_ServerTimeOut = 0u;
    }
    else
    {
        if (S3_ServerCnt < S3_SERVER)
        {
            S3_ServerCnt += timer;
        }
        else
        {
            if (S3_ServerTimeOut == 0u)
            {
                S3_ServerTimeOut = 1u;
                S3_ServiceTimeOut();
            }
        }
    }
}

/**
  *S3���÷���
  */
void S3_ServiceClear(void)
{
    S3_ServerClear = 1u;
}

/**
  *S3�ȴ�����
  */
void S3_ServiceWait(void)
{
    S3_ServerClear = 0u;
    S3_ServerCnt = S3_SERVER;
    S3_ServerTimeOut = 1u;
}

/**
  *S3��ʱ����
  */
void S3_ServiceTimeOut(void)
{
    /*10��������*/
    setSessionType(DefaultSession);
    /*27��������*/
    Ser27_ChangeSessionHandle();
    /*28��������*/
    ControlMessageCommunication(networkManagementMsgAndnormalMsg, enableRxAndTx);
    /*2F��������*/
    /*BuzzerForceCtrlRelease();
    UDS_SpeedoForceCtrlRelease();
    UDS_TachoForceCtrlRelease();
    FuelSEGForceCtrlRelease();
    ColantSEGForceCtrlRelease();
    Set_Telltales_UNControl();*/
    /*85��������*/
    OpenDTCTest();
    /*��Ϸ�������*/
    clearDiagMSG();
}

/**
  *27����10s��ʱ
  */
void Ser27_ErrDelayTimerService(uint16_t timer)
{
    if ( ( Ser27_FlowCtrl.LV1DelayCtrl == SER27_ERR_DELAY_TIMER_EN ) )
    {
        if (Ser27_FlowCtrl.LV1DelayTimer < 0xfff0u )
        {
            Ser27_FlowCtrl.LV1DelayTimer += timer;
            if (Ser27_FlowCtrl.LV1DelayTimer >= SER27_ERR_DELAY_TIMEOUT)
            {
                if (Ser27_FlowCtrlCnt.LV1ReqSeedCnt >= SER27_MAX_REQ_SEED_NUM )
                {
                    Ser27_FlowCtrlCnt.LV1ReqSeedCnt  = SER27_MAX_REQ_SEED_NUM - 1u;
                }
                if (Ser27_FlowCtrlCnt.LV11_ReqSeedCnt >= SER27_MAX_REQ_SEED_NUM)
                {
                    Ser27_FlowCtrlCnt.LV11_ReqSeedCnt  = SER27_MAX_REQ_SEED_NUM - 1u;
                }
                Ser27_FlowCtrl.LV1Ctrl = SER27_CLEAR_REQ_SEEDED;
                Ser27_FlowCtrl.LV1DelayTimer = 0u;
                Ser27_FlowCtrl.LV1DelayCtrl = 0u;
                /*������DFlashд�뺯����*/
                WriteDFlashData(0x02u, (uint32_t *)&Ser27_FlowCtrlCnt.Flag, sizeof(Ser27_FlowCtrlCnt), NoNeedWait);
            }
        }
    }
}


/**
  *���Ʊ���ͨ��
  *@param Type ���Ʊ��ĵ�����
  *@param Status ���Ƶı�־λ
  */
void ControlMessageCommunication(uint8_t Type, uint8_t Status)
{
    if ((uint8_t)(Type & normalMsg) == normalMsg)
    {
        if ((uint8_t)(Status & enableRxAndDisableTx) == enableRxAndDisableTx)
        {
            CAN_Control.APP_TX_Enable = CAN_Control.APP_TX_Enable & APP_DisEnable;
        }
        else
        {
            CAN_Control.APP_TX_Enable = CAN_Control.APP_TX_Enable | APP_Enable;
        }
        if ((uint8_t)(Status & disableRxAndEnableTx) == disableRxAndEnableTx)
        {
            CAN_Control.APP_RX_Enable = CAN_Control.APP_RX_Enable & APP_DisEnable;
            isReceive = 0u;
        }
        else
        {   
            CAN_Control.APP_RX_Enable = CAN_Control.APP_RX_Enable | APP_Enable;
            isReceive = 1u;
        }
    }
    if ((uint8_t)(Type & networkManagementMsg) == networkManagementMsg)
    {
        if ((uint8_t)(Status & enableRxAndDisableTx) == enableRxAndDisableTx)
        {
            CanNm_Data_State(2u, 0u);
        }
        else
        {
            CanNm_Data_State(2u, 1u);
        }
        if ((uint8_t)(Status & disableRxAndEnableTx) == disableRxAndEnableTx)
        {
            CanNm_Data_State(1u, 0u);
        }
        else
        {
            CanNm_Data_State(1u, 1u);
        }
    } /**/
}

/**
  *��ȡbusoff״̬
  *@return busoff״̬ 0����,1�쳣
  */
uint8_t getBUS_OFF_Status(void)
{
    return BusOffEvent;
}

/**
  *��ȡbusoff��־
  *@return busoff״̬ 0����,1�쳣
  */
uint8_t getBUS_OFF_FLAG(void)
{
    uint8_t FLAG = BUS_OFF_FLAG;
    if(!getBUS_OFF_Status())
    {  
        BUS_OFF_FLAG = 0u;
    }
    FLAG = BUS_OFF_FLAG;
    return FLAG;
}
/**
  *DTCʹ�ܶ�ʱ
  */
void enableDTCTimer(uint16_t Timer)
{
    uint8_t BUS_OFF_Status = getBusoffStatus();
    if((UDSKL15Status == 1u) && (BUS_OFF_Status == 0u) && (HVoltageStatus == 0u) && (LVoltageStatus == 0u))
    {
        if(isEnable == 0u)
        {
            if(enableTimer >= enableMaxTimer)
            {
                isEnable = 1u;
                enableTimer = 0u;
            }
            else
            {
                enableTimer += Timer;
            }
        }
    }
}

/**
  *DTC�Ƿ�ʹ��
  *@return DTCʹ��״̬ 0Ϊδʹ��,1Ϊʹ��
  */
uint8_t isDTCEnable(void)
{
    return isEnable;
}

/**
  *����DTCʹ��ʱ��
  */
void setDTCEnableTimer(uint16_t Timer)
{
    uint8_t i;
    if(isEnable == 1u)
    {
        isEnable = 0u;
        enableTimer = 0u;
        enableMaxTimer = Timer;
        for(i = 0u; i < (sizeof(msgList) / sizeof(msgList[0u])); ++i)
        {
            msgList[i][3] = 0u;
        }
    }
    else
    {
        if(enableMaxTimer == Timer)
        {
            enableTimer = 0u;
        }
        else
        {
            if(enableMaxTimer < enableTimer + Timer)
            {
                enableMaxTimer = enableTimer + Timer;
            }
        }
    }
}

/**
  *����DTC���
  */
void OpenDTCTest(void)
{
    isDTCOpen = 1u;
}

/**
  *�ر�DTC���
  */
void CloseDTCTest(void)
{
    isDTCOpen = 0u;
}

/**
  *DTC�Ƿ���
  *@return DTC״̬ 0�ر�,1����
  */
uint8_t DTCTestIsOpen(void)
{
    return isDTCOpen;
}

/**
  *DTC�ϻ�
  */
void DTC_Ageing(void)
{
    uint8_t i;
    for (i = 0u; i < sizeof(DTCToDFlashInfo.DTC) / sizeof(DTCUnion); ++i)
    {
        DTCToDFlashInfo.DTC[i].DTCStatus |= (DTCNoTestThisCycle);
        if ((uint8_t)(DTCToDFlashInfo.DTC[i].DTCStatus & DTCErrorThisCycle) != DTCErrorThisCycle)
        {
            DTCToDFlashInfo.DTC[i].DTCStatus &= (~DTCPending);
            DTCToDFlashInfo.DTC[i].DTCPendingCount = 0u;
            if ((uint8_t)(DTCToDFlashInfo.DTC[i].DTCStatus & DTCConfirmed) == DTCConfirmed)
            {
                DTCToDFlashInfo.DTC[i].DTCAgeing++;
                if (DTCToDFlashInfo.DTC[i].DTCAgeing >= AgeingCount)
                {
                    DTCToDFlashInfo.DTC[i].DTCStatus &= (~DTCConfirmed);
                }
            }
        }
        else
        {
            DTCToDFlashInfo.DTC[i].DTCStatus &= (~DTCErrorThisCycle);
        }
        DTCToDFlashInfo.DTC[i].DTCStatus &= DTCNoError;
    }
}

/**
  *��ȡ���е������Ϣ
  */
void ReadAllDFlashData(void)
{
    ReadDFlashData(EEPROM_BLOCK_UDS_FLAG, (uint32_t *)&DiagFlag.Flag         , sizeof(DiagFlag), AllFlagInit);
    ReadDFlashData(EEPROM_BLOCK_UDS_S27, (uint32_t *)&Ser27_FlowCtrlCnt.Flag, sizeof(Ser27_FlowCtrlCnt), Ser27ToDFlashInfoInit);
    ReadDFlashData(EEPROM_BLOCK_UDS_ReadBoot, (uint32_t *)&BootToDFlashInfo.Flag , sizeof(BootToDFlashInfo), BootToDFlashInfoInit);
    ReadDFlashData(EEPROM_BLOCK_UDS_S2E, (uint32_t *)&Ser2EToDFlashInfo.Flag, sizeof(Ser2EToDFlashInfo), Ser2EToDFlashInfoInit);

    if (Ser27_FlowCtrlCnt.LV1ReqSeedCnt >= SER27_MAX_REQ_SEED_NUM )
    {
        Ser27_FlowCtrl.LV1DelayCtrl = SER27_ERR_DELAY_TIMER_EN;
    }
    if (Ser27_FlowCtrlCnt.LV11_ReqSeedCnt >= SER27_MAX_REQ_SEED_NUM)
    {
        Ser27_FlowCtrl.LV1DelayCtrl = SER27_ERR_DELAY_TIMER_EN;
    }

    EOL_SetF101(Ser2EToDFlashInfo.DID_F101, 8u);
    EOL_SetF102(Ser2EToDFlashInfo.DID_F102, 24u);
    EOL_SetF110(Ser2EToDFlashInfo.DID_F110, 8u);
    
    DTCConfigurationInit();
}

/**
  *��ȡ��Ϣ
  */
uint8_t ReadDFlashData(uint8_t u8BlockNum, uint32_t u32Data[], uint16_t u16Len, InitFunction initFunction)
{
    uint8_t enResult = OK;
    uint32_t Addr = D_Flash_Block_1 + u8BlockNum * 256;
    enResult = DFLASH_Read_Word(Addr, (uint8_t *)u32Data, u16Len);
    if(enResult == OK) 
    {
      if (*u32Data != 0x7AA7A55Au)
      {
        initFunction();
        enResult = WriteDFlashData(u8BlockNum, u32Data, u16Len, NeedWait);
      }
    }
    return enResult;
}

/**
  *д����Ϣ
  */
uint8_t WriteDFlashData(uint8_t u8BlockNum, uint32_t u32Data[], uint16_t u16Len, uint8_t isWait)
{
    uint8_t enResult = OK;
    uint32_t Addr;
    (void)isWait;
    Addr = D_Flash_Block_1 + u8BlockNum * 256u;
    enResult = Write_Base_DATA_FROM_FLASH(Addr,(uint8_t *)u32Data, u16Len);
    return enResult;
}

/**
  *���б�־λ��ʼ��
  */
void AllFlagInit(void)
{
    DiagFlag.Flag = 0x7AA7A55Au;
    DiagFlag.JumpToBootFlag = 0u;//0x00000000u;
    DiagFlag.AppValidFlag = 0u;//0x00000000u;
    DiagFlag.S11Flag = 0x00000000u;
}

/**
  *27��Ϣ��ʼ��
  */
void Ser27ToDFlashInfoInit(void)
{
    Ser27_FlowCtrlCnt.Flag = 0x7AA7A55Au;
    Ser27_FlowCtrlCnt.LV11_InvaidKyeCnt = 0u;
    Ser27_FlowCtrlCnt.LV11_ReqSeedCnt = 0u;
    Ser27_FlowCtrlCnt.LV1InvaidKyeCnt = 0u;
    Ser27_FlowCtrlCnt.LV1ReqSeedCnt = 0u;
    Ser27_FlowCtrlCnt.RandNum = 0u;
}

/**
  *boot��Ϣ��ʼ��
  */
void BootToDFlashInfoInit(void)
{
    BootToDFlashInfo.Flag = 0x7AA7A55Au;
    BootToDFlashInfo.DID_0200 = 0u;
    BootToDFlashInfo.DID_0201 = 0u;
    
    memset(BootToDFlashInfo.DID_F180, 0x20, 16u);
    BootToDFlashInfo.DID_F180[0] = '1';
    BootToDFlashInfo.DID_F180[1] = '0';
    BootToDFlashInfo.DID_F180[2] = '1';
    


    memset(BootToDFlashInfo.DID_F187, 0x20, 21u);
    BootToDFlashInfo.DID_F187[0] = '9';
    BootToDFlashInfo.DID_F187[1] = '9';
    BootToDFlashInfo.DID_F187[2] = '0';
    BootToDFlashInfo.DID_F187[3] = '0';
    BootToDFlashInfo.DID_F187[4] = '1';
    BootToDFlashInfo.DID_F187[5] = '3';
    BootToDFlashInfo.DID_F187[6] = '7';
    BootToDFlashInfo.DID_F187[7] = '0';
    BootToDFlashInfo.DID_F187[8] = '6';
    BootToDFlashInfo.DID_F187[9] = '4';


     
    memset(BootToDFlashInfo.DID_F189, 0x00, 10u);
    BootToDFlashInfo.DID_F189[0] = 'S';
    BootToDFlashInfo.DID_F189[1] = 'W';
    BootToDFlashInfo.DID_F189[2] = '.';
    BootToDFlashInfo.DID_F189[3] = '0';
    BootToDFlashInfo.DID_F189[4] = '0';
    BootToDFlashInfo.DID_F189[5] = '0';
    BootToDFlashInfo.DID_F189[6] = '.';
    BootToDFlashInfo.DID_F189[7] = '0';
    BootToDFlashInfo.DID_F189[8] = '0';
    BootToDFlashInfo.DID_F189[9] = '0';
    
    memset(BootToDFlashInfo.DID_F193, 0x20, 16u);
    BootToDFlashInfo.DID_F193[0] = '1';
    BootToDFlashInfo.DID_F193[1] = '0';
    BootToDFlashInfo.DID_F193[2] = '0';
    
    memset(BootToDFlashInfo.DID_F198, 0x00, 16u);

    BootToDFlashInfo.DID_F199[0] = 0x20u;
    BootToDFlashInfo.DID_F199[1] = 0x00u;
    BootToDFlashInfo.DID_F199[2] = 0x01u;
    BootToDFlashInfo.DID_F199[3] = 0x01u;
    
    memset(BootToDFlashInfo.DID_DFEC, 0x00, 64u);
    memset(BootToDFlashInfo.DID_DFED, 0x00, 64u);
    
}

/**
  *2E��Ϣ��ʼ��
  */
void Ser2EToDFlashInfoInit(void)
{
    uint8_t i;
    _EOL_F101 __EOL_F101;
    _EOL_F102 __EOL_F102;
    _EOL_F110 __EOL_F110;
    Ser2EToDFlashInfo.Flag = 0x7AA7A55Au;
    
    memset(Ser2EToDFlashInfo.DID_F190, 0x00, 17u);
    Ser2EToDFlashInfo.DID_F1A2[0] = 0x20u;
    Ser2EToDFlashInfo.DID_F1A2[1] = 0x00u;
    Ser2EToDFlashInfo.DID_F1A2[2] = 0x01u;
    Ser2EToDFlashInfo.DID_F1A2[3] = 0x01u;    
    memset(Ser2EToDFlashInfo.DID_F112, 0x20, 8u);
    #if(IC_Current == LD01) 
    {
        Ser2EToDFlashInfo.DID_F112[0] = 'L';
        Ser2EToDFlashInfo.DID_F112[0] = 'D';
        Ser2EToDFlashInfo.DID_F112[0] = '0';
        Ser2EToDFlashInfo.DID_F112[0] = '1';
        
    }
    #else if(IC_Current == LD02) 
    {
        Ser2EToDFlashInfo.DID_F112[0] = 'L';
        Ser2EToDFlashInfo.DID_F112[0] = 'D';
        Ser2EToDFlashInfo.DID_F112[0] = '0';
        Ser2EToDFlashInfo.DID_F112[0] = '2';
        
    }
    #endif
    memset(Ser2EToDFlashInfo.DID_F197, 0x20, 8u);
    Ser2EToDFlashInfo.DID_F197[0] = 'I';
    Ser2EToDFlashInfo.DID_F197[1] = 'P';
    Ser2EToDFlashInfo.DID_F197[2] = 'K';    
    memset(Ser2EToDFlashInfo.DID_DFEE, 0, 64u); 
    memset(Ser2EToDFlashInfo.DID_DFEF, 0, 64u);
    
    memset(Ser2EToDFlashInfo.DID_F100, 0xFF, 16u);
    Ser2EToDFlashInfo.DID_7101[0] = 0x00;
    Ser2EToDFlashInfo.DID_7101[1] = 0x50;
    Ser2EToDFlashInfo.DID_7101[2] = 0x00;
    
    Ser2EToDFlashInfo.DID_7102[0] = 0x01;
    Ser2EToDFlashInfo.DID_7102[1] = 0x00;
    Ser2EToDFlashInfo.DID_7102[2] = 0x00;

    Ser2EToDFlashInfo.DID_7103 = 0x00;
    Ser2EToDFlashInfo.DID_7104 = 0x00;
    
    EOL_InitVal();
    __EOL_F101 = EOL_GetF101();
    __EOL_F102 = EOL_GetF102();
    __EOL_F110 = EOL_GetF110();
    for (i = 0u; i < 8u; ++i)
    {
        Ser2EToDFlashInfo.DID_F101[i] = __EOL_F101.F101_Byte[i];
    }
    for (i = 0u; i < 24u; ++i)
    {
        Ser2EToDFlashInfo.DID_F102[i] = __EOL_F102.F102_Byte[i];
    }
    for (i = 0u; i < 16u; ++i)
    {
        Ser2EToDFlashInfo.DID_F110[i] = __EOL_F110.F110_Byte[i];
    } 
}

/**
  *DTC��Ϣ��ʼ��
  */
void DTCToDFlashInfoInit(void)
{
    uint8_t i;
    //DTCToDFlashInfo.Flag = 0x7AA7A55Au;
    for (i = 0u; i < sizeof(DTCToDFlashInfo.DTC) / sizeof(DTCUnion); ++i)
    {
        DTCToDFlashInfo.DTC[i].DTCStatus = DTCNoTestLastClear | DTCNoTestThisCycle;
        DTCToDFlashInfo.DTC[i].DTCAgeing = 0x00u;
        DTCToDFlashInfo.DTC[i].DTCCount = 0x00u;
        DTCToDFlashInfo.DTC[i].DTCPendingCount = 0x00u;
        DTCToDFlashInfo.DTC[i].Snapshot.ECUPowerVoltage = 0x00u;
        DTCToDFlashInfo.DTC[i].Snapshot.VehicleSpeed = 0x0000u;
        DTCToDFlashInfo.DTC[i].Snapshot.OccurrenceCounter = 0x00u;
        DTCToDFlashInfo.DTC[i].Snapshot.FirstMalfunction = 0x00000000u;
        DTCToDFlashInfo.DTC[i].Snapshot.LastMalfunction = 0x00000000u;  
        DTCToDFlashInfo.DTC[i].Snapshot.EngineSpeed = 0u;
        //DTCToDFlashInfo.DTC[i].Snapshot.PowerRange = 0u;
        DTCToDFlashInfo.DTC[i].Snapshot.TimeOfFailure_S = 0u;
        DTCToDFlashInfo.DTC[i].Snapshot.TimeOfFailure_Min = 0u;
        DTCToDFlashInfo.DTC[i].Snapshot.TimeOfFailure_Hr = 0u;
        DTCToDFlashInfo.DTC[i].Snapshot.TimeOfFailure_Month = 0u;
        DTCToDFlashInfo.DTC[i].Snapshot.TimeOfFailure_Day = 0u;
        DTCToDFlashInfo.DTC[i].Snapshot.TimeOfFailure_Year = 0u;
        NVM_Data_Update(NVM_DTC + i);
    }
    for(i = 0u; i < (sizeof(msgList) / sizeof(msgList[0u])); ++i)
    {
        msgList[i][3] = 0u;
    }
    for(i = 0u; i < (sizeof(DTCTimerList) / sizeof(DTCTimerList[0u])); ++i)
    {
        DTCTimerList[i] = 0u;
    }
}

/**
  *DTC��Ϣ���ó�ʼ��
  */
void DTCConfigurationInit(void)
{
    if(!Val_EOL_F110_MMI())
    {
        DTCToDFlashInfo.DTC[cnU015687].DTCStatus = DTCNoTestLastClear | DTCNoTestThisCycle;
        DTCToDFlashInfo.DTC[cnU015687].DTCAgeing = 0x00u;
        DTCToDFlashInfo.DTC[cnU015687].DTCCount = 0x00u;
        DTCToDFlashInfo.DTC[cnU015687].DTCPendingCount = 0x00u;
        DTCToDFlashInfo.DTC[cnU015687].Snapshot.ECUPowerVoltage = 0x00u;
        DTCToDFlashInfo.DTC[cnU015687].Snapshot.VehicleSpeed = 0x0000u;
        DTCToDFlashInfo.DTC[cnU015687].Snapshot.OccurrenceCounter = 0x00u;
        DTCToDFlashInfo.DTC[cnU015687].Snapshot.FirstMalfunction = 0x00000000u;
        DTCToDFlashInfo.DTC[cnU015687].Snapshot.LastMalfunction = 0x00000000u;
        DTCToDFlashInfo.DTC[cnU015687].Snapshot.EngineSpeed = 0x0000u;
        DTCToDFlashInfo.DTC[cnU015687].Snapshot.PowerRange = 0x00u;
        DTCToDFlashInfo.DTC[cnU015687].Snapshot.TimeOfFailure_S = 0x00u;
        DTCToDFlashInfo.DTC[cnU015687].Snapshot.TimeOfFailure_Min = 0x00u;
        DTCToDFlashInfo.DTC[cnU015687].Snapshot.TimeOfFailure_Hr = 0x00u;
        DTCToDFlashInfo.DTC[cnU015687].Snapshot.TimeOfFailure_Month = 0x00u;
        DTCToDFlashInfo.DTC[cnU015687].Snapshot.TimeOfFailure_Day = 0x00u;
        DTCToDFlashInfo.DTC[cnU015687].Snapshot.TimeOfFailure_Year = 0x00u;
    }/**/
    if(!Val_EOL_F110_BCM())
    {
        DTCToDFlashInfo.DTC[cnU014087].DTCStatus = DTCNoTestLastClear | DTCNoTestThisCycle;
        DTCToDFlashInfo.DTC[cnU014087].DTCAgeing = 0x00u;
        DTCToDFlashInfo.DTC[cnU014087].DTCCount = 0x00u;
        DTCToDFlashInfo.DTC[cnU014087].DTCPendingCount = 0x00u;
        DTCToDFlashInfo.DTC[cnU014087].Snapshot.ECUPowerVoltage = 0x00u;
        DTCToDFlashInfo.DTC[cnU014087].Snapshot.VehicleSpeed = 0x0000u;
        DTCToDFlashInfo.DTC[cnU014087].Snapshot.OccurrenceCounter = 0x00u;
        DTCToDFlashInfo.DTC[cnU014087].Snapshot.FirstMalfunction = 0x00000000u;
        DTCToDFlashInfo.DTC[cnU014087].Snapshot.LastMalfunction = 0x00000000u;
        DTCToDFlashInfo.DTC[cnU014087].Snapshot.EngineSpeed = 0x0000u;
        DTCToDFlashInfo.DTC[cnU014087].Snapshot.PowerRange = 0x00u;
        DTCToDFlashInfo.DTC[cnU014087].Snapshot.TimeOfFailure_S = 0x00u;
        DTCToDFlashInfo.DTC[cnU014087].Snapshot.TimeOfFailure_Min = 0x00u;
        DTCToDFlashInfo.DTC[cnU014087].Snapshot.TimeOfFailure_Hr = 0x00u;
        DTCToDFlashInfo.DTC[cnU014087].Snapshot.TimeOfFailure_Month = 0x00u;
        DTCToDFlashInfo.DTC[cnU014087].Snapshot.TimeOfFailure_Day = 0x00u;
        DTCToDFlashInfo.DTC[cnU014087].Snapshot.TimeOfFailure_Year = 0x00u;
    }/**/
    if(!Val_EOL_F110_PEPS())
    {
        DTCToDFlashInfo.DTC[cnU021487].DTCStatus = DTCNoTestLastClear | DTCNoTestThisCycle;
        DTCToDFlashInfo.DTC[cnU021487].DTCAgeing = 0x00u;
        DTCToDFlashInfo.DTC[cnU021487].DTCCount = 0x00u;
        DTCToDFlashInfo.DTC[cnU021487].DTCPendingCount = 0x00u;
        DTCToDFlashInfo.DTC[cnU021487].Snapshot.ECUPowerVoltage = 0x00u;
        DTCToDFlashInfo.DTC[cnU021487].Snapshot.VehicleSpeed = 0x0000u;
        DTCToDFlashInfo.DTC[cnU021487].Snapshot.OccurrenceCounter = 0x00u;
        DTCToDFlashInfo.DTC[cnU021487].Snapshot.FirstMalfunction = 0x00000000u;
        DTCToDFlashInfo.DTC[cnU021487].Snapshot.LastMalfunction = 0x00000000u;
        DTCToDFlashInfo.DTC[cnU021487].Snapshot.EngineSpeed = 0x0000u;
        DTCToDFlashInfo.DTC[cnU021487].Snapshot.PowerRange = 0x00u;
        DTCToDFlashInfo.DTC[cnU021487].Snapshot.TimeOfFailure_S = 0x00u;
        DTCToDFlashInfo.DTC[cnU021487].Snapshot.TimeOfFailure_Min = 0x00u;
        DTCToDFlashInfo.DTC[cnU021487].Snapshot.TimeOfFailure_Hr = 0x00u;
        DTCToDFlashInfo.DTC[cnU021487].Snapshot.TimeOfFailure_Month = 0x00u;
        DTCToDFlashInfo.DTC[cnU021487].Snapshot.TimeOfFailure_Day = 0x00u;
        DTCToDFlashInfo.DTC[cnU021487].Snapshot.TimeOfFailure_Year = 0x00u;
    }/**/
    if(!Val_EOL_F110_VCU())
    {
        DTCToDFlashInfo.DTC[cnU029300].DTCStatus = DTCNoTestLastClear | DTCNoTestThisCycle;
        DTCToDFlashInfo.DTC[cnU029300].DTCAgeing = 0x00u;
        DTCToDFlashInfo.DTC[cnU029300].DTCCount = 0x00u;
        DTCToDFlashInfo.DTC[cnU029300].DTCPendingCount = 0x00u;
        DTCToDFlashInfo.DTC[cnU029300].Snapshot.ECUPowerVoltage = 0x00u;
        DTCToDFlashInfo.DTC[cnU029300].Snapshot.VehicleSpeed = 0x0000u;
        DTCToDFlashInfo.DTC[cnU029300].Snapshot.OccurrenceCounter = 0x00u;
        DTCToDFlashInfo.DTC[cnU029300].Snapshot.FirstMalfunction = 0x00000000u;
        DTCToDFlashInfo.DTC[cnU029300].Snapshot.LastMalfunction = 0x00000000u;
        DTCToDFlashInfo.DTC[cnU029300].Snapshot.EngineSpeed = 0x0000u;
        DTCToDFlashInfo.DTC[cnU029300].Snapshot.PowerRange = 0x00u;
        DTCToDFlashInfo.DTC[cnU029300].Snapshot.TimeOfFailure_S = 0x00u;
        DTCToDFlashInfo.DTC[cnU029300].Snapshot.TimeOfFailure_Min = 0x00u;
        DTCToDFlashInfo.DTC[cnU029300].Snapshot.TimeOfFailure_Hr = 0x00u;
        DTCToDFlashInfo.DTC[cnU029300].Snapshot.TimeOfFailure_Month = 0x00u;
        DTCToDFlashInfo.DTC[cnU029300].Snapshot.TimeOfFailure_Day = 0x00u;
        DTCToDFlashInfo.DTC[cnU029300].Snapshot.TimeOfFailure_Year = 0x00u;
    }/**/
    if(!Val_EOL_F110_BMS())
    {
        DTCToDFlashInfo.DTC[cnU011287].DTCStatus = DTCNoTestLastClear | DTCNoTestThisCycle;
        DTCToDFlashInfo.DTC[cnU011287].DTCAgeing = 0x00u;
        DTCToDFlashInfo.DTC[cnU011287].DTCCount = 0x00u;
        DTCToDFlashInfo.DTC[cnU011287].DTCPendingCount = 0x00u;
        DTCToDFlashInfo.DTC[cnU011287].Snapshot.ECUPowerVoltage = 0x00u;
        DTCToDFlashInfo.DTC[cnU011287].Snapshot.VehicleSpeed = 0x0000u;
        DTCToDFlashInfo.DTC[cnU011287].Snapshot.OccurrenceCounter = 0x00u;
        DTCToDFlashInfo.DTC[cnU011287].Snapshot.FirstMalfunction = 0x00000000u;
        DTCToDFlashInfo.DTC[cnU011287].Snapshot.LastMalfunction = 0x00000000u;
        DTCToDFlashInfo.DTC[cnU011287].Snapshot.EngineSpeed = 0x0000u;
        DTCToDFlashInfo.DTC[cnU011287].Snapshot.PowerRange = 0x00u;
        DTCToDFlashInfo.DTC[cnU011287].Snapshot.TimeOfFailure_S = 0x00u;
        DTCToDFlashInfo.DTC[cnU011287].Snapshot.TimeOfFailure_Min = 0x00u;
        DTCToDFlashInfo.DTC[cnU011287].Snapshot.TimeOfFailure_Hr = 0x00u;
        DTCToDFlashInfo.DTC[cnU011287].Snapshot.TimeOfFailure_Month = 0x00u;
        DTCToDFlashInfo.DTC[cnU011287].Snapshot.TimeOfFailure_Day = 0x00u;
        DTCToDFlashInfo.DTC[cnU011287].Snapshot.TimeOfFailure_Year = 0x00u;
    }/**/
    if(!Val_EOL_F110_TPMS())
    {
        DTCToDFlashInfo.DTC[cnU012787].DTCStatus = DTCNoTestLastClear | DTCNoTestThisCycle;
        DTCToDFlashInfo.DTC[cnU012787].DTCAgeing = 0x00u;
        DTCToDFlashInfo.DTC[cnU012787].DTCCount = 0x00u;
        DTCToDFlashInfo.DTC[cnU012787].DTCPendingCount = 0x00u;
        DTCToDFlashInfo.DTC[cnU012787].Snapshot.ECUPowerVoltage = 0x00u;
        DTCToDFlashInfo.DTC[cnU012787].Snapshot.VehicleSpeed = 0x0000u;
        DTCToDFlashInfo.DTC[cnU012787].Snapshot.OccurrenceCounter = 0x00u;
        DTCToDFlashInfo.DTC[cnU012787].Snapshot.FirstMalfunction = 0x00000000u;
        DTCToDFlashInfo.DTC[cnU012787].Snapshot.LastMalfunction = 0x00000000u;
        DTCToDFlashInfo.DTC[cnU012787].Snapshot.EngineSpeed = 0x0000u;
        DTCToDFlashInfo.DTC[cnU012787].Snapshot.PowerRange = 0x00u;
        DTCToDFlashInfo.DTC[cnU012787].Snapshot.TimeOfFailure_S = 0x00u;
        DTCToDFlashInfo.DTC[cnU012787].Snapshot.TimeOfFailure_Min = 0x00u;
        DTCToDFlashInfo.DTC[cnU012787].Snapshot.TimeOfFailure_Hr = 0x00u;
        DTCToDFlashInfo.DTC[cnU012787].Snapshot.TimeOfFailure_Month = 0x00u;
        DTCToDFlashInfo.DTC[cnU012787].Snapshot.TimeOfFailure_Day = 0x00u;
        DTCToDFlashInfo.DTC[cnU012787].Snapshot.TimeOfFailure_Year = 0x00u;
    }/**/    
    if(!Val_EOL_F110_FCS())
    {
        DTCToDFlashInfo.DTC[cnU120387].DTCStatus = DTCNoTestLastClear | DTCNoTestThisCycle;
        DTCToDFlashInfo.DTC[cnU120387].DTCAgeing = 0x00u;
        DTCToDFlashInfo.DTC[cnU120387].DTCCount = 0x00u;
        DTCToDFlashInfo.DTC[cnU120387].DTCPendingCount = 0x00u;
        DTCToDFlashInfo.DTC[cnU120387].Snapshot.ECUPowerVoltage = 0x00u;
        DTCToDFlashInfo.DTC[cnU120387].Snapshot.VehicleSpeed = 0x0000u;
        DTCToDFlashInfo.DTC[cnU120387].Snapshot.OccurrenceCounter = 0x00u;
        DTCToDFlashInfo.DTC[cnU120387].Snapshot.FirstMalfunction = 0x00000000u;
        DTCToDFlashInfo.DTC[cnU120387].Snapshot.LastMalfunction = 0x00000000u;
        DTCToDFlashInfo.DTC[cnU120387].Snapshot.EngineSpeed = 0x0000u;
        DTCToDFlashInfo.DTC[cnU120387].Snapshot.PowerRange = 0x00u;
        DTCToDFlashInfo.DTC[cnU120387].Snapshot.TimeOfFailure_S = 0x00u;
        DTCToDFlashInfo.DTC[cnU120387].Snapshot.TimeOfFailure_Min = 0x00u;
        DTCToDFlashInfo.DTC[cnU120387].Snapshot.TimeOfFailure_Hr = 0x00u;
        DTCToDFlashInfo.DTC[cnU120387].Snapshot.TimeOfFailure_Month = 0x00u;
        DTCToDFlashInfo.DTC[cnU120387].Snapshot.TimeOfFailure_Day = 0x00u;
        DTCToDFlashInfo.DTC[cnU120387].Snapshot.TimeOfFailure_Year = 0x00u;
    }/**/      
    if((Val_EOL_F110_EPB_Air() == 0) && (Val_EOL_F110_EPB_Liquid() == 0))
    {
        DTCToDFlashInfo.DTC[cnU012887].DTCStatus = DTCNoTestLastClear | DTCNoTestThisCycle;
        DTCToDFlashInfo.DTC[cnU012887].DTCAgeing = 0x00u;
        DTCToDFlashInfo.DTC[cnU012887].DTCCount = 0x00u;
        DTCToDFlashInfo.DTC[cnU012887].DTCPendingCount = 0x00u;
        DTCToDFlashInfo.DTC[cnU012887].Snapshot.ECUPowerVoltage = 0x00u;
        DTCToDFlashInfo.DTC[cnU012887].Snapshot.VehicleSpeed = 0x0000u;
        DTCToDFlashInfo.DTC[cnU012887].Snapshot.OccurrenceCounter = 0x00u;
        DTCToDFlashInfo.DTC[cnU012887].Snapshot.FirstMalfunction = 0x00000000u;
        DTCToDFlashInfo.DTC[cnU012887].Snapshot.LastMalfunction = 0x00000000u;
        DTCToDFlashInfo.DTC[cnU012887].Snapshot.EngineSpeed = 0x0000u;
        DTCToDFlashInfo.DTC[cnU012887].Snapshot.PowerRange = 0x00u;
        DTCToDFlashInfo.DTC[cnU012887].Snapshot.TimeOfFailure_S = 0x00u;
        DTCToDFlashInfo.DTC[cnU012887].Snapshot.TimeOfFailure_Min = 0x00u;
        DTCToDFlashInfo.DTC[cnU012887].Snapshot.TimeOfFailure_Hr = 0x00u;
        DTCToDFlashInfo.DTC[cnU012887].Snapshot.TimeOfFailure_Month = 0x00u;
        DTCToDFlashInfo.DTC[cnU012887].Snapshot.TimeOfFailure_Day = 0x00u;
        DTCToDFlashInfo.DTC[cnU012887].Snapshot.TimeOfFailure_Year = 0x00u;
    }/**/       
    if(!Val_EOL_F110_PDC())
    {
        DTCToDFlashInfo.DTC[cnU015987].DTCStatus = DTCNoTestLastClear | DTCNoTestThisCycle;
        DTCToDFlashInfo.DTC[cnU015987].DTCAgeing = 0x00u;
        DTCToDFlashInfo.DTC[cnU015987].DTCCount = 0x00u;
        DTCToDFlashInfo.DTC[cnU015987].DTCPendingCount = 0x00u;
        DTCToDFlashInfo.DTC[cnU015987].Snapshot.ECUPowerVoltage = 0x00u;
        DTCToDFlashInfo.DTC[cnU015987].Snapshot.VehicleSpeed = 0x0000u;
        DTCToDFlashInfo.DTC[cnU015987].Snapshot.OccurrenceCounter = 0x00u;
        DTCToDFlashInfo.DTC[cnU015987].Snapshot.FirstMalfunction = 0x00000000u;
        DTCToDFlashInfo.DTC[cnU015987].Snapshot.LastMalfunction = 0x00000000u;
        DTCToDFlashInfo.DTC[cnU015987].Snapshot.EngineSpeed = 0x0000u;
        DTCToDFlashInfo.DTC[cnU015987].Snapshot.PowerRange = 0x00u;
        DTCToDFlashInfo.DTC[cnU015987].Snapshot.TimeOfFailure_S = 0x00u;
        DTCToDFlashInfo.DTC[cnU015987].Snapshot.TimeOfFailure_Min = 0x00u;
        DTCToDFlashInfo.DTC[cnU015987].Snapshot.TimeOfFailure_Hr = 0x00u;
        DTCToDFlashInfo.DTC[cnU015987].Snapshot.TimeOfFailure_Month = 0x00u;
        DTCToDFlashInfo.DTC[cnU015987].Snapshot.TimeOfFailure_Day = 0x00u;
        DTCToDFlashInfo.DTC[cnU015987].Snapshot.TimeOfFailure_Year = 0x00u;
    }/**/     
    if(!Val_EOL_F110_MCU())
    {
        DTCToDFlashInfo.DTC[cnU011087].DTCStatus = DTCNoTestLastClear | DTCNoTestThisCycle;
        DTCToDFlashInfo.DTC[cnU011087].DTCAgeing = 0x00u;
        DTCToDFlashInfo.DTC[cnU011087].DTCCount = 0x00u;
        DTCToDFlashInfo.DTC[cnU011087].DTCPendingCount = 0x00u;
        DTCToDFlashInfo.DTC[cnU011087].Snapshot.ECUPowerVoltage = 0x00u;
        DTCToDFlashInfo.DTC[cnU011087].Snapshot.VehicleSpeed = 0x0000u;
        DTCToDFlashInfo.DTC[cnU011087].Snapshot.OccurrenceCounter = 0x00u;
        DTCToDFlashInfo.DTC[cnU011087].Snapshot.FirstMalfunction = 0x00000000u;
        DTCToDFlashInfo.DTC[cnU011087].Snapshot.LastMalfunction = 0x00000000u;
        DTCToDFlashInfo.DTC[cnU011087].Snapshot.EngineSpeed = 0x0000u;
        DTCToDFlashInfo.DTC[cnU011087].Snapshot.PowerRange = 0x00u;
        DTCToDFlashInfo.DTC[cnU011087].Snapshot.TimeOfFailure_S = 0x00u;
        DTCToDFlashInfo.DTC[cnU011087].Snapshot.TimeOfFailure_Min = 0x00u;
        DTCToDFlashInfo.DTC[cnU011087].Snapshot.TimeOfFailure_Hr = 0x00u;
        DTCToDFlashInfo.DTC[cnU011087].Snapshot.TimeOfFailure_Month = 0x00u;
        DTCToDFlashInfo.DTC[cnU011087].Snapshot.TimeOfFailure_Day = 0x00u;
        DTCToDFlashInfo.DTC[cnU011087].Snapshot.TimeOfFailure_Year = 0x00u;
    }/**/
    if(!Val_EOL_F110_AC())
    {
        DTCToDFlashInfo.DTC[cnU016487].DTCStatus = DTCNoTestLastClear | DTCNoTestThisCycle;
        DTCToDFlashInfo.DTC[cnU016487].DTCAgeing = 0x00u;
        DTCToDFlashInfo.DTC[cnU016487].DTCCount = 0x00u;
        DTCToDFlashInfo.DTC[cnU016487].DTCPendingCount = 0x00u;
        DTCToDFlashInfo.DTC[cnU016487].Snapshot.ECUPowerVoltage = 0x00u;
        DTCToDFlashInfo.DTC[cnU016487].Snapshot.VehicleSpeed = 0x0000u;
        DTCToDFlashInfo.DTC[cnU016487].Snapshot.OccurrenceCounter = 0x00u;
        DTCToDFlashInfo.DTC[cnU016487].Snapshot.FirstMalfunction = 0x00000000u;
        DTCToDFlashInfo.DTC[cnU016487].Snapshot.LastMalfunction = 0x00000000u;
        DTCToDFlashInfo.DTC[cnU016487].Snapshot.EngineSpeed = 0x0000u;
        DTCToDFlashInfo.DTC[cnU016487].Snapshot.PowerRange = 0x00u;
        DTCToDFlashInfo.DTC[cnU016487].Snapshot.TimeOfFailure_S = 0x00u;
        DTCToDFlashInfo.DTC[cnU016487].Snapshot.TimeOfFailure_Min = 0x00u;
        DTCToDFlashInfo.DTC[cnU016487].Snapshot.TimeOfFailure_Hr = 0x00u;
        DTCToDFlashInfo.DTC[cnU016487].Snapshot.TimeOfFailure_Month = 0x00u;
        DTCToDFlashInfo.DTC[cnU016487].Snapshot.TimeOfFailure_Day = 0x00u;
        DTCToDFlashInfo.DTC[cnU016487].Snapshot.TimeOfFailure_Year = 0x00u;
    }/**/    
    if(!Val_EOL_F110_ACU())
    {
        DTCToDFlashInfo.DTC[cnU015187].DTCStatus = DTCNoTestLastClear | DTCNoTestThisCycle;
        DTCToDFlashInfo.DTC[cnU015187].DTCAgeing = 0x00u;
        DTCToDFlashInfo.DTC[cnU015187].DTCCount = 0x00u;
        DTCToDFlashInfo.DTC[cnU015187].DTCPendingCount = 0x00u;
        DTCToDFlashInfo.DTC[cnU015187].Snapshot.ECUPowerVoltage = 0x00u;
        DTCToDFlashInfo.DTC[cnU015187].Snapshot.VehicleSpeed = 0x0000u;
        DTCToDFlashInfo.DTC[cnU015187].Snapshot.OccurrenceCounter = 0x00u;
        DTCToDFlashInfo.DTC[cnU015187].Snapshot.FirstMalfunction = 0x00000000u;
        DTCToDFlashInfo.DTC[cnU015187].Snapshot.LastMalfunction = 0x00000000u;
        DTCToDFlashInfo.DTC[cnU015187].Snapshot.EngineSpeed = 0x0000u;
        DTCToDFlashInfo.DTC[cnU015187].Snapshot.PowerRange = 0x00u;
        DTCToDFlashInfo.DTC[cnU015187].Snapshot.TimeOfFailure_S = 0x00u;
        DTCToDFlashInfo.DTC[cnU015187].Snapshot.TimeOfFailure_Min = 0x00u;
        DTCToDFlashInfo.DTC[cnU015187].Snapshot.TimeOfFailure_Hr = 0x00u;
        DTCToDFlashInfo.DTC[cnU015187].Snapshot.TimeOfFailure_Month = 0x00u;
        DTCToDFlashInfo.DTC[cnU015187].Snapshot.TimeOfFailure_Day = 0x00u;
        DTCToDFlashInfo.DTC[cnU015187].Snapshot.TimeOfFailure_Year = 0x00u;
    }/**/  
    if(!Val_EOL_F110_AVAS())
    {
        DTCToDFlashInfo.DTC[cnU112887].DTCStatus = DTCNoTestLastClear | DTCNoTestThisCycle;
        DTCToDFlashInfo.DTC[cnU112887].DTCAgeing = 0x00u;
        DTCToDFlashInfo.DTC[cnU112887].DTCCount = 0x00u;
        DTCToDFlashInfo.DTC[cnU112887].DTCPendingCount = 0x00u;
        DTCToDFlashInfo.DTC[cnU112887].Snapshot.ECUPowerVoltage = 0x00u;
        DTCToDFlashInfo.DTC[cnU112887].Snapshot.VehicleSpeed = 0x0000u;
        DTCToDFlashInfo.DTC[cnU112887].Snapshot.OccurrenceCounter = 0x00u;
        DTCToDFlashInfo.DTC[cnU112887].Snapshot.FirstMalfunction = 0x00000000u;
        DTCToDFlashInfo.DTC[cnU112887].Snapshot.LastMalfunction = 0x00000000u;
        DTCToDFlashInfo.DTC[cnU112887].Snapshot.EngineSpeed = 0x0000u;
        DTCToDFlashInfo.DTC[cnU112887].Snapshot.PowerRange = 0x00u;
        DTCToDFlashInfo.DTC[cnU112887].Snapshot.TimeOfFailure_S = 0x00u;
        DTCToDFlashInfo.DTC[cnU112887].Snapshot.TimeOfFailure_Min = 0x00u;
        DTCToDFlashInfo.DTC[cnU112887].Snapshot.TimeOfFailure_Hr = 0x00u;
        DTCToDFlashInfo.DTC[cnU112887].Snapshot.TimeOfFailure_Month = 0x00u;
        DTCToDFlashInfo.DTC[cnU112887].Snapshot.TimeOfFailure_Day = 0x00u;
        DTCToDFlashInfo.DTC[cnU112887].Snapshot.TimeOfFailure_Year = 0x00u;
    }/**/      
    if(!Val_EOL_F110_EBS())
    {
        DTCToDFlashInfo.DTC[cnU012987].DTCStatus = DTCNoTestLastClear | DTCNoTestThisCycle;
        DTCToDFlashInfo.DTC[cnU012987].DTCAgeing = 0x00u;
        DTCToDFlashInfo.DTC[cnU012987].DTCCount = 0x00u;
        DTCToDFlashInfo.DTC[cnU012987].DTCPendingCount = 0x00u;
        DTCToDFlashInfo.DTC[cnU012987].Snapshot.ECUPowerVoltage = 0x00u;
        DTCToDFlashInfo.DTC[cnU012987].Snapshot.VehicleSpeed = 0x0000u;
        DTCToDFlashInfo.DTC[cnU012987].Snapshot.OccurrenceCounter = 0x00u;
        DTCToDFlashInfo.DTC[cnU012987].Snapshot.FirstMalfunction = 0x00000000u;
        DTCToDFlashInfo.DTC[cnU012987].Snapshot.LastMalfunction = 0x00000000u;
        DTCToDFlashInfo.DTC[cnU012987].Snapshot.EngineSpeed = 0x0000u;
        DTCToDFlashInfo.DTC[cnU012987].Snapshot.PowerRange = 0x00u;
        DTCToDFlashInfo.DTC[cnU012987].Snapshot.TimeOfFailure_S = 0x00u;
        DTCToDFlashInfo.DTC[cnU012987].Snapshot.TimeOfFailure_Min = 0x00u;
        DTCToDFlashInfo.DTC[cnU012987].Snapshot.TimeOfFailure_Hr = 0x00u;
        DTCToDFlashInfo.DTC[cnU012987].Snapshot.TimeOfFailure_Month = 0x00u;
        DTCToDFlashInfo.DTC[cnU012987].Snapshot.TimeOfFailure_Day = 0x00u;
        DTCToDFlashInfo.DTC[cnU012987].Snapshot.TimeOfFailure_Year = 0x00u;
    }/**/    
    if(!Val_EOL_F110_EPS())
    {
        DTCToDFlashInfo.DTC[cnU013187].DTCStatus = DTCNoTestLastClear | DTCNoTestThisCycle;
        DTCToDFlashInfo.DTC[cnU013187].DTCAgeing = 0x00u;
        DTCToDFlashInfo.DTC[cnU013187].DTCCount = 0x00u;
        DTCToDFlashInfo.DTC[cnU013187].DTCPendingCount = 0x00u;
        DTCToDFlashInfo.DTC[cnU013187].Snapshot.ECUPowerVoltage = 0x00u;
        DTCToDFlashInfo.DTC[cnU013187].Snapshot.VehicleSpeed = 0x0000u;
        DTCToDFlashInfo.DTC[cnU013187].Snapshot.OccurrenceCounter = 0x00u;
        DTCToDFlashInfo.DTC[cnU013187].Snapshot.FirstMalfunction = 0x00000000u;
        DTCToDFlashInfo.DTC[cnU013187].Snapshot.LastMalfunction = 0x00000000u;
        DTCToDFlashInfo.DTC[cnU013187].Snapshot.EngineSpeed = 0x0000u;
        DTCToDFlashInfo.DTC[cnU013187].Snapshot.PowerRange = 0x00u;
        DTCToDFlashInfo.DTC[cnU013187].Snapshot.TimeOfFailure_S = 0x00u;
        DTCToDFlashInfo.DTC[cnU013187].Snapshot.TimeOfFailure_Min = 0x00u;
        DTCToDFlashInfo.DTC[cnU013187].Snapshot.TimeOfFailure_Hr = 0x00u;
        DTCToDFlashInfo.DTC[cnU013187].Snapshot.TimeOfFailure_Month = 0x00u;
        DTCToDFlashInfo.DTC[cnU013187].Snapshot.TimeOfFailure_Day = 0x00u;
        DTCToDFlashInfo.DTC[cnU013187].Snapshot.TimeOfFailure_Year = 0x00u;
    }/**/ 
    if((Val_EOL_F110_ESC_L() != 1) && (Val_EOL_F110_ESC_W() != 1))
    {
        DTCToDFlashInfo.DTC[cnU012287].DTCStatus = DTCNoTestLastClear | DTCNoTestThisCycle;
        DTCToDFlashInfo.DTC[cnU012287].DTCAgeing = 0x00u;
        DTCToDFlashInfo.DTC[cnU012287].DTCCount = 0x00u;
        DTCToDFlashInfo.DTC[cnU012287].DTCPendingCount = 0x00u;
        DTCToDFlashInfo.DTC[cnU012287].Snapshot.ECUPowerVoltage = 0x00u;
        DTCToDFlashInfo.DTC[cnU012287].Snapshot.VehicleSpeed = 0x0000u;
        DTCToDFlashInfo.DTC[cnU012287].Snapshot.OccurrenceCounter = 0x00u;
        DTCToDFlashInfo.DTC[cnU012287].Snapshot.FirstMalfunction = 0x00000000u;
        DTCToDFlashInfo.DTC[cnU012287].Snapshot.LastMalfunction = 0x00000000u;
        DTCToDFlashInfo.DTC[cnU012287].Snapshot.EngineSpeed = 0x0000u;
        DTCToDFlashInfo.DTC[cnU012287].Snapshot.PowerRange = 0x00u;
        DTCToDFlashInfo.DTC[cnU012287].Snapshot.TimeOfFailure_S = 0x00u;
        DTCToDFlashInfo.DTC[cnU012287].Snapshot.TimeOfFailure_Min = 0x00u;
        DTCToDFlashInfo.DTC[cnU012287].Snapshot.TimeOfFailure_Hr = 0x00u;
        DTCToDFlashInfo.DTC[cnU012287].Snapshot.TimeOfFailure_Month = 0x00u;
        DTCToDFlashInfo.DTC[cnU012287].Snapshot.TimeOfFailure_Day = 0x00u;
        DTCToDFlashInfo.DTC[cnU012287].Snapshot.TimeOfFailure_Year = 0x00u;
    }/**/ 
    if(!Val_EOL_F110_TBOX())
    {
        DTCToDFlashInfo.DTC[cnU019887].DTCStatus = DTCNoTestLastClear | DTCNoTestThisCycle;
        DTCToDFlashInfo.DTC[cnU019887].DTCAgeing = 0x00u;
        DTCToDFlashInfo.DTC[cnU019887].DTCCount = 0x00u;
        DTCToDFlashInfo.DTC[cnU019887].DTCPendingCount = 0x00u;
        DTCToDFlashInfo.DTC[cnU019887].Snapshot.ECUPowerVoltage = 0x00u;
        DTCToDFlashInfo.DTC[cnU019887].Snapshot.VehicleSpeed = 0x0000u;
        DTCToDFlashInfo.DTC[cnU019887].Snapshot.OccurrenceCounter = 0x00u;
        DTCToDFlashInfo.DTC[cnU019887].Snapshot.FirstMalfunction = 0x00000000u;
        DTCToDFlashInfo.DTC[cnU019887].Snapshot.LastMalfunction = 0x00000000u;
        DTCToDFlashInfo.DTC[cnU019887].Snapshot.EngineSpeed = 0x0000u;
        DTCToDFlashInfo.DTC[cnU019887].Snapshot.PowerRange = 0x00u;
        DTCToDFlashInfo.DTC[cnU019887].Snapshot.TimeOfFailure_S = 0x00u;
        DTCToDFlashInfo.DTC[cnU019887].Snapshot.TimeOfFailure_Min = 0x00u;
        DTCToDFlashInfo.DTC[cnU019887].Snapshot.TimeOfFailure_Hr = 0x00u;
        DTCToDFlashInfo.DTC[cnU019887].Snapshot.TimeOfFailure_Month = 0x00u;
        DTCToDFlashInfo.DTC[cnU019887].Snapshot.TimeOfFailure_Day = 0x00u;
        DTCToDFlashInfo.DTC[cnU019887].Snapshot.TimeOfFailure_Year = 0x00u;
    }/**/    
    if(!Val_EOL_F110_EGSM())
    {
        DTCToDFlashInfo.DTC[cnU010387].DTCStatus = DTCNoTestLastClear | DTCNoTestThisCycle;
        DTCToDFlashInfo.DTC[cnU010387].DTCAgeing = 0x00u;
        DTCToDFlashInfo.DTC[cnU010387].DTCCount = 0x00u;
        DTCToDFlashInfo.DTC[cnU010387].DTCPendingCount = 0x00u;
        DTCToDFlashInfo.DTC[cnU010387].Snapshot.ECUPowerVoltage = 0x00u;
        DTCToDFlashInfo.DTC[cnU010387].Snapshot.VehicleSpeed = 0x0000u;
        DTCToDFlashInfo.DTC[cnU010387].Snapshot.OccurrenceCounter = 0x00u;
        DTCToDFlashInfo.DTC[cnU010387].Snapshot.FirstMalfunction = 0x00000000u;
        DTCToDFlashInfo.DTC[cnU010387].Snapshot.LastMalfunction = 0x00000000u;
        DTCToDFlashInfo.DTC[cnU010387].Snapshot.EngineSpeed = 0x0000u;
        DTCToDFlashInfo.DTC[cnU010387].Snapshot.PowerRange = 0x00u;
        DTCToDFlashInfo.DTC[cnU010387].Snapshot.TimeOfFailure_S = 0x00u;
        DTCToDFlashInfo.DTC[cnU010387].Snapshot.TimeOfFailure_Min = 0x00u;
        DTCToDFlashInfo.DTC[cnU010387].Snapshot.TimeOfFailure_Hr = 0x00u;
        DTCToDFlashInfo.DTC[cnU010387].Snapshot.TimeOfFailure_Month = 0x00u;
        DTCToDFlashInfo.DTC[cnU010387].Snapshot.TimeOfFailure_Day = 0x00u;
        DTCToDFlashInfo.DTC[cnU010387].Snapshot.TimeOfFailure_Year = 0x00u;
    }/**/
    if(!Val_EOL_F110_ABS())
    {
        DTCToDFlashInfo.DTC[cnU012187].DTCStatus = DTCNoTestLastClear | DTCNoTestThisCycle;
        DTCToDFlashInfo.DTC[cnU012187].DTCAgeing = 0x00u;
        DTCToDFlashInfo.DTC[cnU012187].DTCCount = 0x00u;
        DTCToDFlashInfo.DTC[cnU012187].DTCPendingCount = 0x00u;
        DTCToDFlashInfo.DTC[cnU012187].Snapshot.ECUPowerVoltage = 0x00u;
        DTCToDFlashInfo.DTC[cnU012187].Snapshot.VehicleSpeed = 0x0000u;
        DTCToDFlashInfo.DTC[cnU012187].Snapshot.OccurrenceCounter = 0x00u;
        DTCToDFlashInfo.DTC[cnU012187].Snapshot.FirstMalfunction = 0x00000000u;
        DTCToDFlashInfo.DTC[cnU012187].Snapshot.LastMalfunction = 0x00000000u;
        DTCToDFlashInfo.DTC[cnU012187].Snapshot.EngineSpeed = 0x0000u;
        DTCToDFlashInfo.DTC[cnU012187].Snapshot.PowerRange = 0x00u;
        DTCToDFlashInfo.DTC[cnU012187].Snapshot.TimeOfFailure_S = 0x00u;
        DTCToDFlashInfo.DTC[cnU012187].Snapshot.TimeOfFailure_Min = 0x00u;
        DTCToDFlashInfo.DTC[cnU012187].Snapshot.TimeOfFailure_Hr = 0x00u;
        DTCToDFlashInfo.DTC[cnU012187].Snapshot.TimeOfFailure_Month = 0x00u;
        DTCToDFlashInfo.DTC[cnU012187].Snapshot.TimeOfFailure_Day = 0x00u;
        DTCToDFlashInfo.DTC[cnU012187].Snapshot.TimeOfFailure_Year = 0x00u;
    }/**/
}