#include "UDS_19Service_Main.h"

/**
  *19
  *@param A_TA_type յݵĵַ
  *@param A_Length յݵĳ
  *@param A_Data յݵ
  */
void UDS_Service_19_Indication(uint32_t A_TA_type, uint16_t A_Length, uint8_t A_Data[])
{
    uint8_t NRC = positiveResponse;
    setDiagMSG(A_TA_type, A_Length, A_Data);
    if (NRC == positiveResponse)
    {
        NRC = UDS_19Service_NRC11();                                            /*19Ƿֹ֧Ѱַ*/
    }
    if (NRC == positiveResponse)
    {
        NRC = UDS_19Service_NRC7F();                                            /*19ỰǷ֧֤*/
    }
    if (NRC == positiveResponse)
    {
        NRC = UDS_19Service_NRC33();                                            /*19ȼ֤*/
    }
    if (NRC == positiveResponse)
    {
        NRC = UDS_19Service_NRC13_MinLengthCheck();                             /*19С֤*/
    }
    if (NRC == positiveResponse)
    {
        NRC = UDS_19Service_NRC31();                                            /*19񳬳Χ֤*/
    }
    if (NRC == positiveResponse)
    {
        NRC = UDS_19Service_NRC13_TotalLengthCheck();                           /*19ܳȳ֤*/
    }
    if (NRC == positiveResponse)
    {
        NRC = UDS_19Service_NRC22();                                            /*19֤*/
    }
    if (NRC == positiveResponse)
    {
        UDS_19Service_Sub();                                                    /*19ӹ*/
    }
    clearDiagMSG();                                                             /*Ϣ*/
}

/**
  *19ӹ
  */
void UDS_19Service_Sub(void)
{
    uint8_t NRC = positiveResponse;
    if (NRC == positiveResponse)
    {
        NRC = UDS_19Service_Sub_NRC13_MinLengthCheck();                         /*19ӹС֤*/
    }
    if (NRC == positiveResponse)
    {
        NRC = UDS_19Service_Sub_NRC12();                                        /*19ӹǷ֧֤*/
    }
    if (NRC == positiveResponse)
    {
        NRC = UDS_19Service_Sub_NRC7E();                                        /*19ӹܻỰǷ֧֤*/
    }
    if (NRC == positiveResponse)
    {
        NRC = UDS_19Service_Sub_NRC31();                                        /*19ӹܳΧ֤*/
    }
    if (NRC == positiveResponse)
    {
        NRC = UDS_19Service_Sub_NRC13_TotalLengthCheck();                       /*19ӹܳȳ֤*/
    }
    if (NRC == positiveResponse)
    {
        NRC = UDS_19Service_Sub_NRC24();                                        /*19ӹ˳֤*/
    }
    if (NRC == positiveResponse)
    {
        NRC = UDS_19Service_Sub_NRC22();                                        /*19ӹ֤*/
    }
    if (NRC == positiveResponse)
    {
        switch (DiagMSG.msgData.SidDetail.SubID)                                /*ӷж*/
        {
        case ReportNumberOfDTCByStatusMask:
            UDS_19Service_Sub01();                                              /*1901ӹ*/
            break;
        case ReportDTCByStatusMask:
            UDS_19Service_Sub02();                                              /*1902ӹ*/
            break;
        case ReportDTCSnapshotRecordByDTCNumber:
            UDS_19Service_Sub04();                                              /*1904ӹ*/
            break;
        case ReportSupportedDTC:
            UDS_19Service_Sub0A();                                              /*190Aӹ*/
            break;
        default:
            break;
        }
    }
}

/**
  *1901ӹ
  */
void UDS_19Service_Sub01(void)
{
    uint8_t  i = 0u;
    uint8_t  DTCStatus = 0u;
    uint16_t DTCCount = 0u;
    for (i = 0u; i < sizeof(DTCToDFlashInfo.DTC) / sizeof(DTCUnion); ++i)
    {
        if(DTCList[i][1u])
        {
            DTCStatus = DTCToDFlashInfo.DTC[i].DTCStatus & DTCMask;
            if (DTCStatus & DiagMSG.msgData.SidDetail.Data[0])
            {
                ++DTCCount;
            }
        }
    }
    DiagMSG.msgData.SidDetail.Data[0] = DTCMask;
    DiagMSG.msgData.SidDetail.Data[1] = 0x00u;
    DiagMSG.msgData.SidDetail.Data[2] = (uint8_t)(DTCCount >> 8);
    DiagMSG.msgData.SidDetail.Data[3] = (uint8_t)(DTCCount);
    UDS_Service_Response(0x19u, POSITIVE_RSP, DIAG_ID_Tx, 5u, DiagMSG.msgData.Data);
}

/**
  *1902ӹ
  */
void UDS_19Service_Sub02(void)
{
    uint8_t  i = 0u;
    uint8_t  DTCStatus = 0u;
    uint16_t count = 1u;
    uint32_t DTC = 0u;
    for (i = 0u; i < sizeof(DTCToDFlashInfo.DTC) / sizeof(DTCUnion); ++i)
    {
        if(DTCList[i][1u])
        {
            DTCStatus = DTCToDFlashInfo.DTC[i].DTCStatus & DTCMask;
            if (DTCStatus & DiagMSG.msgData.SidDetail.Data[0])
            {
                DTC = getDTCNumber(i);
                DiagMSG.msgData.SidDetail.Data[count++] = (uint8_t)(DTC >> 16u);
                DiagMSG.msgData.SidDetail.Data[count++] = (uint8_t)(DTC >> 8u);
                DiagMSG.msgData.SidDetail.Data[count++] = (uint8_t)(DTC);
                DiagMSG.msgData.SidDetail.Data[count++] = DTCStatus;
            }
        }
    }
    DiagMSG.msgData.SidDetail.Data[0] = DTCMask;
    UDS_Service_Response(0x19u, POSITIVE_RSP, DIAG_ID_Tx, count + 1u, DiagMSG.msgData.Data);
}

/**
  *1904ӹ
  */
void UDS_19Service_Sub04(void)
{
    uint8_t  NRC;
    uint8_t  DTCcount = 0u;
    uint8_t  DTCStatus = 0u;
    uint32_t DTC = 0u;
    DTC = toUint32_t(0x00u, DiagMSG.msgData.SidDetail.Data[0], DiagMSG.msgData.SidDetail.Data[1], DiagMSG.msgData.SidDetail.Data[2]);
    DTCcount = getDTCCount(DTC);
    if (DTCcount < (sizeof(DTCList) / sizeof(DTCList[0u])))
    {
        DTCStatus = DTCToDFlashInfo.DTC[DTCcount].DTCStatus;//״̬Ҫ޸
        DiagMSG.msgData.SidDetail.Data[3] = DTCStatus & DTCMask;
        if((uint8_t)(DTCStatus & DTCErrorLastClear) == DTCErrorLastClear)
        {
            DiagMSG.msgData.SidDetail.Data[4] = 0x01u;
            DiagMSG.msgData.SidDetail.Data[5] = 0x07u;
            DiagMSG.msgData.SidDetail.Data[6] = 0xDFu;
            DiagMSG.msgData.SidDetail.Data[7] = 0x00u;
            DiagMSG.msgData.SidDetail.Data[8] = (DTCToDFlashInfo.DTC[DTCcount].Snapshot.ECUPowerVoltage >> 8u);
            DiagMSG.msgData.SidDetail.Data[9] = DTCToDFlashInfo.DTC[DTCcount].Snapshot.ECUPowerVoltage;            
            DiagMSG.msgData.SidDetail.Data[10] = 0xDFu;
            DiagMSG.msgData.SidDetail.Data[11] = 0x01u;
            DiagMSG.msgData.SidDetail.Data[12] = (uint8_t)(DTCToDFlashInfo.DTC[DTCcount].Snapshot.VehicleSpeed >> 8u);
            DiagMSG.msgData.SidDetail.Data[13] = (uint8_t)(DTCToDFlashInfo.DTC[DTCcount].Snapshot.VehicleSpeed);
            DiagMSG.msgData.SidDetail.Data[14] = 0xDFu;
            DiagMSG.msgData.SidDetail.Data[15] = 0x02u;
            DiagMSG.msgData.SidDetail.Data[16] = DTCToDFlashInfo.DTC[DTCcount].Snapshot.OccurrenceCounter;
            DiagMSG.msgData.SidDetail.Data[17] = 0xDFu;
            DiagMSG.msgData.SidDetail.Data[18] = 0x03u;
            DiagMSG.msgData.SidDetail.Data[19] = (uint8_t)(DTCToDFlashInfo.DTC[DTCcount].Snapshot.FirstMalfunction >> 16u);
            DiagMSG.msgData.SidDetail.Data[20] = (uint8_t)(DTCToDFlashInfo.DTC[DTCcount].Snapshot.FirstMalfunction >> 8u);
            DiagMSG.msgData.SidDetail.Data[21] = (uint8_t)(DTCToDFlashInfo.DTC[DTCcount].Snapshot.FirstMalfunction);
            DiagMSG.msgData.SidDetail.Data[22] = 0xDFu;
            DiagMSG.msgData.SidDetail.Data[23] = 0x04u;
            DiagMSG.msgData.SidDetail.Data[24] = (uint8_t)(DTCToDFlashInfo.DTC[DTCcount].Snapshot.LastMalfunction >> 16u);
            DiagMSG.msgData.SidDetail.Data[25] = (uint8_t)(DTCToDFlashInfo.DTC[DTCcount].Snapshot.LastMalfunction >> 8u);
            DiagMSG.msgData.SidDetail.Data[26] = (uint8_t)(DTCToDFlashInfo.DTC[DTCcount].Snapshot.LastMalfunction);
            DiagMSG.msgData.SidDetail.Data[27] = 0xDFu;
            DiagMSG.msgData.SidDetail.Data[28] = 0x05u;
            DiagMSG.msgData.SidDetail.Data[29] = (uint8_t)(DTCToDFlashInfo.DTC[DTCcount].Snapshot.EngineSpeed >> 8);
            DiagMSG.msgData.SidDetail.Data[30] = (uint8_t)(DTCToDFlashInfo.DTC[DTCcount].Snapshot.EngineSpeed);
            /*DiagMSG.msgData.SidDetail.Data[30] = 0xDFu;
            DiagMSG.msgData.SidDetail.Data[31] = 0x04u;
            DiagMSG.msgData.SidDetail.Data[32] = (uint8_t)(DTCToDFlashInfo.DTC[DTCcount].Snapshot.PowerRange);*/
            DiagMSG.msgData.SidDetail.Data[31] = 0xDFu;
            DiagMSG.msgData.SidDetail.Data[32] = 0x10u;
            DiagMSG.msgData.SidDetail.Data[33] = (uint8_t)(DTCToDFlashInfo.DTC[DTCcount].Snapshot.TimeOfFailure_S);
            DiagMSG.msgData.SidDetail.Data[34] = (uint8_t)(DTCToDFlashInfo.DTC[DTCcount].Snapshot.TimeOfFailure_Min);
            DiagMSG.msgData.SidDetail.Data[35] = (uint8_t)(DTCToDFlashInfo.DTC[DTCcount].Snapshot.TimeOfFailure_Hr);
            DiagMSG.msgData.SidDetail.Data[36] = (uint8_t)(DTCToDFlashInfo.DTC[DTCcount].Snapshot.TimeOfFailure_Month);
            DiagMSG.msgData.SidDetail.Data[37] = (uint8_t)(DTCToDFlashInfo.DTC[DTCcount].Snapshot.TimeOfFailure_Day);
            DiagMSG.msgData.SidDetail.Data[38] = (uint8_t)(DTCToDFlashInfo.DTC[DTCcount].Snapshot.TimeOfFailure_Year);
            UDS_Service_Response(0x19u, POSITIVE_RSP, DIAG_ID_Tx, 40u, DiagMSG.msgData.Data);
        }
        else
        {
            UDS_Service_Response(0x19u, POSITIVE_RSP, DIAG_ID_Tx, 5u, DiagMSG.msgData.Data);
        }
    } 
    else
    {
        NRC = requestOutOfRange;
        if(DiagMSG.msgID == DIAG_ID_Rx_PHY)
        {
            UDS_Service_Response(0x19u, NEGATIVE_RSP, DIAG_ID_Tx, 1u, (uint8_t*)&NRC);
        }
    }
}

/**
  *190Aӹ
  */
void UDS_19Service_Sub0A(void)
{
    uint8_t  i = 0u;
    uint8_t  DTCStatus = 0u;
    uint16_t count = 0u;
    uint32_t DTC = 0u;
    DiagMSG.msgData.SidDetail.Data[count++] = DTCMask;
    for (i = 0u; i < sizeof(DTCToDFlashInfo.DTC) / sizeof(DTCUnion); ++i)
    {
        if(DTCList[i][1u])
        {
            DTC = getDTCNumber(i);
            DTCStatus = DTCToDFlashInfo.DTC[i].DTCStatus & DTCMask;
            DiagMSG.msgData.SidDetail.Data[count++] = (uint8_t)(DTC >> 16u);
            DiagMSG.msgData.SidDetail.Data[count++] = (uint8_t)(DTC >> 8u);
            DiagMSG.msgData.SidDetail.Data[count++] = (uint8_t)(DTC);
            DiagMSG.msgData.SidDetail.Data[count++] = DTCStatus;
        }
        
    }
    UDS_Service_Response(0x19u, POSITIVE_RSP, DIAG_ID_Tx, count + 1u, DiagMSG.msgData.Data);
}