#include "UDS_22Service_Filter.h"
                                                                                                                                                                 
const uint8_t  S22DLC[] = {2u,      2u,      2u,      2u,      2u,      2u,      2u,      2u,      2u,      2u,      2u,      2u,      2u,      2u,      2u,      2u,      2u,      2u,      2u,      2u,      2u,      2u,      2u,      2u,      2u,      2u,      2u,      2u,      2u,      2u,      2u,      2u     };
const uint16_t S22DID[] = {0xF199u, 0xF187u, 0xF18Au, 0xF190u, 0xF1A2u, 0xF191u, 0xF189u, 0xF193u, 0xF195u, 0xF180u, 0xF112u, 0xF198u, 0xF197u, 0xF113u, 0xF182u, 0xF186u, 0xF18Bu, 0xF18Cu, 0x0200u, 0x0201u, 0xDFECu, 0xDFEDu, 0xDFEEu, 0xDFEFu, 0xF101u, 0xF102u, 0xF110u, 0xF100u, 0x7101u, 0x7102u, 0x7103u, 0x7104u};

/**
  *22С֤
  *@return 
  */
uint8_t UDS_22Service_NRC13_MinLengthCheck(void)
{
    uint8_t NRC = positiveResponse;
    if(DiagMSG.msgDLC < 2u)
    {
        NRC = incorrectMessageLength;
        UDS_Service_Response(0x22u, NEGATIVE_RSP, DIAG_ID_Tx, 1u, (uint8_t*)&NRC);
    }
    else
    {
        NRC = positiveResponse;
    }
    return NRC;
}

/**
  *22񳬳Χ֤
  *Ѱַθø
  *@return 
  */
uint8_t UDS_22Service_NRC31(void)
{
    uint8_t i;
    uint8_t NRC = requestOutOfRange;
    uint8_t count = 0u;
    count = DIM(S22DID);
    for(i = 0u; i < count; ++i)
    {
        if(getDID(DiagMSG.msgData.DidDetail.DID_H, DiagMSG.msgData.DidDetail.DID_L) == S22DID[i])
        {
            NRC = positiveResponse;
            break;
        }
    }
    if((NRC == requestOutOfRange) && (DiagMSG.msgID == DIAG_ID_Rx_PHY))
    {
        UDS_Service_Response(0x22u, NEGATIVE_RSP, DIAG_ID_Tx, 1u, (uint8_t*)&NRC);
    }
    return NRC;
}

/**
  *22ܳȳ֤
  *@return 
  */
uint8_t UDS_22Service_NRC13_TotalLengthCheck(void)
{
    uint8_t i;
    uint8_t NRC = positiveResponse;
    for(i = 0u; i < DIM(S22DID); ++i)
    {
        if(getDID(DiagMSG.msgData.DidDetail.DID_H, DiagMSG.msgData.DidDetail.DID_L) == S22DID[i])
        {
            if(DiagMSG.msgDLC != S22DLC[i])
            {
                NRC = incorrectMessageLength;
                UDS_Service_Response(0x22u, NEGATIVE_RSP, DIAG_ID_Tx, 1u, (uint8_t*)&NRC);
            }
            else
            {
                NRC = positiveResponse;
            }
            break;
        }
    }/* */
    return NRC;
}

