#include "UDS_22Service_Main.h"

/**
  *22
  *@param A_TA_type յݵĵַ
  *@param A_Length յݵĳ
  *@param A_Data յݵ
  */
void UDS_Service_22_Indication(uint32_t A_TA_type, uint16_t A_Length, uint8_t A_Data[])
{
    uint8_t NRC = positiveResponse;
    setDiagMSG(A_TA_type, A_Length, A_Data);
    if(NRC == positiveResponse)
    {
        NRC = UDS_22Service_NRC13_MinLengthCheck();                             /*22С֤*/
    }
    if(NRC == positiveResponse)
    {
        NRC = UDS_22Service_NRC31();                                            /*22񳬳Χ֤*/
    }
    if(NRC == positiveResponse)
    {
        NRC = UDS_22Service_NRC13_TotalLengthCheck();      
    }
    if(NRC == positiveResponse)         
    {
        UDS_22Service_DID();                                                    /*22DIDж*/
    }
    clearDiagMSG();                                                             /*Ϣ*/
}
const uint8_t Ser22_DID_F113[4] = {0x01, 0x03, 0x04, 0x04};                     /*Э汾*/
const uint8_t Ser22_DID_F182[] = "";                                            /*궨汾*/
const uint8_t Ser22_DID_F18A[6] = {'4', '5', '1', '0', '0', '3'};               /*Ӧʶ*/
const uint8_t Ser22_DID_F18B[4] = {0x20, 0x21, 0x08, 0x26};                     /*ECU*/
const uint8_t Ser22_DID_F18C[] = "0000";                                        /*ECUк*/
const uint8_t Ser22_DID_F191[10] = {'H', 'W', '.', '0', '0', '0', '.', '0', '0', '1'};                                      /*Ӳ汾*/
const uint8_t Ser22_DID_F195[] = "100";                       	                /*ӦECU汾*/
const uint8_t Ser22_DID_F1AA[8];                                                /*ECUܳ㲿*/
const uint8_t Ser22_DID_F1AE[] = "";                                            /*ECU*/
const uint8_t Ser22_DID_6209[16] = "";                                          /*ڶ汾*/
const uint8_t Ser22_DID_6983[3] = "";                                           /*̧ͷʾ汾*/
const uint8_t Ser22_DID_6984[2] = "";                                           /*̧ͷʾӲ汾*/
const uint8_t Ser22_DID_6985[3] = "";                                           /*̧ͷʾ EEPROMݰ汾*/
/**
  *22ӹ
  */
void UDS_22Service_DID(void)
{
    ReadDFlashData(EEPROM_BLOCK_UDS_ReadBoot, (uint32_t *)&BootToDFlashInfo.Flag, sizeof(BootToDFlashInfo), BootToDFlashInfoInit);
    ReadDFlashData(EEPROM_BLOCK_UDS_S2E, (uint32_t *)&Ser2EToDFlashInfo.Flag, sizeof(Ser2EToDFlashInfo), Ser2EToDFlashInfoInit);
    switch(getDID(DiagMSG.msgData.DidDetail.DID_H, DiagMSG.msgData.DidDetail.DID_L))/*22DIDж*/
    {
    case 0x0200:
        UDS_22Service_DID_0200();                                               /*ɹˢд*/
        break;
    case 0x0201:
        UDS_22Service_DID_0201();                                               /*ˢдԴ*/
        break;
    case 0x7101:
        UDS_22Service_DID_7101();                                               /*ױ*/
        break;        
    case 0x7102:
        UDS_22Service_DID_7102();                                               /*ױ*/
        break;        
    case 0x7103:
        UDS_22Service_DID_7103();                                               /*屣̱־λ*/
        break;        
    case 0x7104:
        UDS_22Service_DID_7104();                                               /*ۼ־λ*/
        break;              
    case 0xDFEC:
        UDS_22Service_DID_DFEC();                                               /*ֱ4*/
        break;
    case 0xDFED:
        UDS_22Service_DID_DFED();                                               /*ֱ3*/
        break;
    case 0xDFEE:
        UDS_22Service_DID_DFEE();                                               /*ֱ2*/
        break;
    case 0xDFEF:
        UDS_22Service_DID_DFEF();                                               /*ֱ*/
        break;
    case 0xF100:
        UDS_22Service_DID_F100();                                               /**/
        break;
    case 0xF101:
        UDS_22Service_DID_F101();                                               /*ECU1*/
        break; 
    case 0xF102:
        UDS_22Service_DID_F102();                                               /*ECU2*/
        break;        
    case 0xF110:
        UDS_22Service_DID_F110();                                               /**/
        break;                            
    case 0xF112:
        UDS_22Service_DID_F112();                                               /**/
        break;
    case 0xF113:
        UDS_22Service_DID_F113();                                               /*Э汾*/
        break;
    case 0xF180:
        UDS_22Service_DID_F180();                                               /*ʶ*/
        break;
    case 0xF182:
        UDS_22Service_DID_F182();                                               /*궨汾*/
        break;
    case 0xF186:
        UDS_22Service_DID_F186();                                               /*ϻỰ*/
        break;
    case 0xF187:
        UDS_22Service_DID_F187();                                               /*BOM*/
        break;
    case 0xF189:
        UDS_22Service_DID_F189();                                               /*ECU汾*/
        break;
    case 0xF18A:
        UDS_22Service_DID_F18A();                                               /*Ӧʶ*/
        break;
    case 0xF18B:
        UDS_22Service_DID_F18B();                                               /*ECU*/
        break;
    case 0xF18C:
        UDS_22Service_DID_F18C();                                               /*ECUк*/
        break;
    case 0xF190:
        UDS_22Service_DID_F190();                                               /*VIN*/
        break;
    case 0xF191:
        UDS_22Service_DID_F191();                                               /*Ӳ汾*/
        break;    
    case 0xF193:
        UDS_22Service_DID_F193();                                               /*ӦECUӲ汾*/
        break;
    case 0xF195:
        UDS_22Service_DID_F195();                                               /*ӦECU汾*/
        break;
    case 0xF197:
        UDS_22Service_DID_F197();                                               /*ECU*/
        break;
    case 0xF198:
        UDS_22Service_DID_F198();                                               /*к*/
        break;
    case 0xF199:
        UDS_22Service_DID_F199();                                               /*ECUˢ*/
        break;
    case 0xF1A2:
        UDS_22Service_DID_F1A2();                                               /*ECUװ*/
        break;
    default:
        break;
    }
}

/**
  *22DID0200
  *ɹˢд
  */
void UDS_22Service_DID_0200(void)
{
    DiagMSG.msgData.DidDetail.Data[0] = BootToDFlashInfo.DID_0200;
    UDS_Service_Response(0x22u, POSITIVE_RSP, DIAG_ID_Tx, 2u + 1u, DiagMSG.msgData.Data);
}

/**
  *22DID0201
  *ˢдԴ
  */
void UDS_22Service_DID_0201(void)
{
    DiagMSG.msgData.DidDetail.Data[0] = BootToDFlashInfo.DID_0201;
    UDS_Service_Response(0x22u, POSITIVE_RSP, DIAG_ID_Tx, 2u + 1u, DiagMSG.msgData.Data);
}
    
/**
  *22DID7101
  *ױ
  */
void UDS_22Service_DID_7101(void)
{   
    memcpy(DiagMSG.msgData.DidDetail.Data, Ser2EToDFlashInfo.DID_7101, sizeof(Ser2EToDFlashInfo.DID_7101));
    UDS_Service_Response(0x22u, POSITIVE_RSP, DIAG_ID_Tx, 2u + 3u, DiagMSG.msgData.Data);
}

/**
  *22DID7102
  *ױ
  */
void UDS_22Service_DID_7102(void)
{   
    memcpy(DiagMSG.msgData.DidDetail.Data, Ser2EToDFlashInfo.DID_7102, sizeof(Ser2EToDFlashInfo.DID_7102));
    UDS_Service_Response(0x22u, POSITIVE_RSP, DIAG_ID_Tx, 2u + 3u, DiagMSG.msgData.Data);
}

/**
  *22DID7103
  *屣̱־λ
  */
void UDS_22Service_DID_7103(void)
{
    DiagMSG.msgData.DidDetail.Data[0] = Ser2EToDFlashInfo.DID_7103;
    UDS_Service_Response(0x22u, POSITIVE_RSP, DIAG_ID_Tx, 2u + 1u, DiagMSG.msgData.Data);
}

/**
  *22DID7104
  *ۼ־λ
  */
void UDS_22Service_DID_7104(void)
{
    DiagMSG.msgData.DidDetail.Data[0] = Ser2EToDFlashInfo.DID_7104;
    UDS_Service_Response(0x22u, POSITIVE_RSP, DIAG_ID_Tx, 2u + 1u, DiagMSG.msgData.Data);
}

/**
  *22DIDDFEC
  *ֱ4
  */
void UDS_22Service_DID_DFEC(void)
{
    memcpy(DiagMSG.msgData.DidDetail.Data, BootToDFlashInfo.DID_DFEC, sizeof(BootToDFlashInfo.DID_DFEC));
    UDS_Service_Response(0x22u, POSITIVE_RSP, DIAG_ID_Tx, 2u + 64u, DiagMSG.msgData.Data);
}

/**
  *22DIDDFED
  *ֱ3
  */
void UDS_22Service_DID_DFED(void)
{
    memcpy(DiagMSG.msgData.DidDetail.Data, BootToDFlashInfo.DID_DFED, sizeof(BootToDFlashInfo.DID_DFED));
    UDS_Service_Response(0x22u, POSITIVE_RSP, DIAG_ID_Tx, 2u + 64u, DiagMSG.msgData.Data);
}

/**
  *22DIDDFEE
  *ֱ2
  */
void UDS_22Service_DID_DFEE(void)
{
    memcpy(DiagMSG.msgData.DidDetail.Data, Ser2EToDFlashInfo.DID_DFEE, sizeof(Ser2EToDFlashInfo.DID_DFEE));
    UDS_Service_Response(0x22u, POSITIVE_RSP, DIAG_ID_Tx, 2u + 64u, DiagMSG.msgData.Data);
}

/**
  *22DIDDFEF
  *ֱ
  */
void UDS_22Service_DID_DFEF(void)
{
    memcpy(DiagMSG.msgData.DidDetail.Data, Ser2EToDFlashInfo.DID_DFEF, sizeof(Ser2EToDFlashInfo.DID_DFEF));
    UDS_Service_Response(0x22u, POSITIVE_RSP, DIAG_ID_Tx, 2u + 64u, DiagMSG.msgData.Data);
}

/**
  *22DIDF100
  *
  */
void UDS_22Service_DID_F100(void)
{
    memcpy(DiagMSG.msgData.DidDetail.Data, Ser2EToDFlashInfo.DID_F100, sizeof(Ser2EToDFlashInfo.DID_F100));
    UDS_Service_Response(0x22u, POSITIVE_RSP, DIAG_ID_Tx, 2u + 16u, DiagMSG.msgData.Data);
}

/**
  *22DIDF101
  *ECU1
  */
void UDS_22Service_DID_F101(void)
{
    _EOL_F101 EOL_F101 = EOL_GetF101();
    memcpy(DiagMSG.msgData.DidDetail.Data, EOL_F101.F101_Byte, sizeof(EOL_F101.F101_Byte));
    UDS_Service_Response(0x22u, POSITIVE_RSP, DIAG_ID_Tx, 2u + 8u, DiagMSG.msgData.Data);
}

/**
  *22DIDF102
  *ECU2
  */
void UDS_22Service_DID_F102(void)
{
    _EOL_F102 EOL_F102 = EOL_GetF102();
    memcpy(DiagMSG.msgData.DidDetail.Data, EOL_F102.F102_Byte, sizeof(EOL_F102.F102_Byte));
    UDS_Service_Response(0x22u, POSITIVE_RSP, DIAG_ID_Tx, 2u + 24u, DiagMSG.msgData.Data);
}

/**
  *22DIDF110
  *
  */
void UDS_22Service_DID_F110(void)
{
    _EOL_F110 EOL_F110 = EOL_GetF110();
    memcpy(DiagMSG.msgData.DidDetail.Data, EOL_F110.F110_Byte, sizeof(EOL_F110.F110_Byte));
    UDS_Service_Response(0x22u, POSITIVE_RSP, DIAG_ID_Tx, 2u + 8u, DiagMSG.msgData.Data);
}
/**
  *22DIDF112
  *
  */
void UDS_22Service_DID_F112(void)
{
    memcpy(DiagMSG.msgData.DidDetail.Data, Ser2EToDFlashInfo.DID_F112, sizeof(Ser2EToDFlashInfo.DID_F112));
    UDS_Service_Response(0x22u, POSITIVE_RSP, DIAG_ID_Tx, 2u + 8u, DiagMSG.msgData.Data);
}

/**
  *22DIDF113
  *ϰ汾
  */
void UDS_22Service_DID_F113(void)
{
    memcpy(DiagMSG.msgData.DidDetail.Data, Ser22_DID_F113, sizeof(Ser22_DID_F113));
    UDS_Service_Response(0x22u, POSITIVE_RSP, DIAG_ID_Tx, 2u + 4u, DiagMSG.msgData.Data);
}

/**
  *22DIDF180
  *Bootloader汾
  */
void UDS_22Service_DID_F180(void)
{
    memcpy(DiagMSG.msgData.DidDetail.Data, BootToDFlashInfo.DID_F180, sizeof(BootToDFlashInfo.DID_F180));
    UDS_Service_Response(0x22u, POSITIVE_RSP, DIAG_ID_Tx, 2u + 16u, DiagMSG.msgData.Data);
}

/**
  *22DIDF182
  *궨汾
  */
void UDS_22Service_DID_F182(void)
{
    memset(DiagMSG.msgData.DidDetail.Data, 0x20, 16u);
    memcpy(DiagMSG.msgData.DidDetail.Data, Ser22_DID_F182, sizeof(Ser22_DID_F182) - 1u);
    UDS_Service_Response(0x22u, POSITIVE_RSP, DIAG_ID_Tx, 2u + 16u, DiagMSG.msgData.Data);
}

/**
  *22DIDF186
  *ϻỰ
  */
void UDS_22Service_DID_F186(void)
{
    DiagMSG.msgData.DidDetail.Data[0] = getSessionType();
    UDS_Service_Response(0x22u, POSITIVE_RSP, DIAG_ID_Tx, 2u + 1u, DiagMSG.msgData.Data);
}

/**
  *22DIDF187
  *ECU
  */
void UDS_22Service_DID_F187(void)
{
    memcpy(DiagMSG.msgData.DidDetail.Data, BootToDFlashInfo.DID_F187, sizeof(BootToDFlashInfo.DID_F187));
    UDS_Service_Response(0x22u, POSITIVE_RSP, DIAG_ID_Tx, 2u + 21u, DiagMSG.msgData.Data);
}

/**
  *22DIDF189
  *汾
  */
void UDS_22Service_DID_F189(void)
{
    memcpy(DiagMSG.msgData.DidDetail.Data, BootToDFlashInfo.DID_F189, sizeof(BootToDFlashInfo.DID_F189));
    UDS_Service_Response(0x22u, POSITIVE_RSP, DIAG_ID_Tx, 2u + 10u, DiagMSG.msgData.Data);
}

/**
  *22DIDF18A
  *ECUӦID
  */
void UDS_22Service_DID_F18A(void)
{
    memcpy(DiagMSG.msgData.DidDetail.Data, Ser22_DID_F18A, sizeof(Ser22_DID_F18A));
    UDS_Service_Response(0x22u, POSITIVE_RSP, DIAG_ID_Tx, 2u + 6u, DiagMSG.msgData.Data);
}

/**
  *22DIDF18B
  *ECU
  */
void UDS_22Service_DID_F18B(void)
{
    memcpy(DiagMSG.msgData.DidDetail.Data, Ser22_DID_F18B, sizeof(Ser22_DID_F18B));
    UDS_Service_Response(0x22u, POSITIVE_RSP, DIAG_ID_Tx, 2u + 4u, DiagMSG.msgData.Data);
}

/**
  *22DIDF18C
  *ECUк 
  */
void UDS_22Service_DID_F18C(void)
{
    memset(DiagMSG.msgData.DidDetail.Data, 0x20, 24u);
    memcpy(DiagMSG.msgData.DidDetail.Data, Ser22_DID_F18C, sizeof(Ser22_DID_F18C) - 1u);
    UDS_Service_Response(0x22u, POSITIVE_RSP, DIAG_ID_Tx, 2u + 24u, DiagMSG.msgData.Data);
}

/**
  *22DIDF190
  *VIN
  */
void UDS_22Service_DID_F190(void)
{
    memcpy(DiagMSG.msgData.DidDetail.Data, Ser2EToDFlashInfo.DID_F190, sizeof(Ser2EToDFlashInfo.DID_F190));
    UDS_Service_Response(0x22u, POSITIVE_RSP, DIAG_ID_Tx, 2u + 17u, DiagMSG.msgData.Data);
}

/**
  *22DIDF191
  *Ӳ汾
  */
void UDS_22Service_DID_F191(void)
{
    memcpy(DiagMSG.msgData.DidDetail.Data, Ser22_DID_F191, sizeof(Ser22_DID_F191));
    UDS_Service_Response(0x22u, POSITIVE_RSP, DIAG_ID_Tx, 2u + 10u, DiagMSG.msgData.Data);
}

/**
  *22DIDF193
  *Ӧ̶Ӳ汾
  */
void UDS_22Service_DID_F193(void)
{
    memcpy(DiagMSG.msgData.DidDetail.Data, BootToDFlashInfo.DID_F193, sizeof(BootToDFlashInfo.DID_F193));
    UDS_Service_Response(0x22u, POSITIVE_RSP, DIAG_ID_Tx, 2u + 16u, DiagMSG.msgData.Data);
}

/**
  *22DIDF195
  *Ӧ̶汾
  */
void UDS_22Service_DID_F195(void)
{
    memset(DiagMSG.msgData.DidDetail.Data, 0x20, 16u);
    memcpy(DiagMSG.msgData.DidDetail.Data, Ser22_DID_F195, sizeof(Ser22_DID_F195) - 1u);
    UDS_Service_Response(0x22u, POSITIVE_RSP, DIAG_ID_Tx, 2u + 16u, DiagMSG.msgData.Data);
}

/**
  *22DIDF197
  *ECU
  */
void UDS_22Service_DID_F197(void)
{
    memcpy(DiagMSG.msgData.DidDetail.Data, Ser2EToDFlashInfo.DID_F197, sizeof(Ser2EToDFlashInfo.DID_F197));
    UDS_Service_Response(0x22u, POSITIVE_RSP, DIAG_ID_Tx, 2u + 8u, DiagMSG.msgData.Data);
}

/**
  *22DIDF198
  *豸к
  */
void UDS_22Service_DID_F198(void)
{
    memcpy(DiagMSG.msgData.DidDetail.Data, BootToDFlashInfo.DID_F198, sizeof(BootToDFlashInfo.DID_F198));
    UDS_Service_Response(0x22u, POSITIVE_RSP, DIAG_ID_Tx, 2u + 16u, DiagMSG.msgData.Data);
}

/**
  *22DIDF199
  *ECUˢ
  */
void UDS_22Service_DID_F199(void)
{
    memcpy(DiagMSG.msgData.DidDetail.Data, BootToDFlashInfo.DID_F199, sizeof(BootToDFlashInfo.DID_F199));
    UDS_Service_Response(0x22u, POSITIVE_RSP, DIAG_ID_Tx, 2u + 4u, DiagMSG.msgData.Data);
}

/**
  *22DIDF1A2
  */ECUװ
  */
void UDS_22Service_DID_F1A2(void)
{
    memcpy(DiagMSG.msgData.DidDetail.Data, Ser2EToDFlashInfo.DID_F1A2, sizeof(Ser2EToDFlashInfo.DID_F1A2));
    UDS_Service_Response(0x22u, POSITIVE_RSP, DIAG_ID_Tx, 2u + 4u, DiagMSG.msgData.Data);
}