#include "Include.h"
#include "Alarm_typdef.h"
#include "Sound_Pop.h"

_Turn_Lamp Turn_Lamp;

void Sounds_Polling(void)
{
	uint8_t SndMsg = 0u;
	uint8_t PopupMsg = 0u;

	PopupMsg = Popup_Get_Current_Message();
	if ((SYS_OPR_STAT_HALT) || (Bus_Sleep_Mode_Delay_Time >= BusSleep_Wait_Mode_Time))
	{
		Sound_Play_Switch_Handle(Sound_Play_NOTControl);
		return;
	}

	for (SndMsg = 0; SndMsg < Sound_Reverse_Gear; SndMsg++)
	{
		if (SndMsg == PopupMsg)
		{
			// �ſ�
			if (SndMsg == Sound_Door_Open_Greate10)
			{
				if (DoorOpen.u8LF_St == 1)
				{
					Sound_Request(SndMsg, Alarm_Trigger1);
				}
				else
				{
					Sound_Delete(SndMsg, Alarm_Trigger1);
				}
				if (DoorOpen.u8RF_St == 1)
				{
					Sound_Request(SndMsg, Alarm_Trigger2);
				}
				else
				{
					Sound_Delete(SndMsg, Alarm_Trigger2);
				}

				if (DoorOpen.u8LR_St == 1)
				{
					Sound_Request(SndMsg, Alarm_Trigger3);
				}
				else
				{
					Sound_Delete(SndMsg, Alarm_Trigger3);
				}
				if (DoorOpen.u8RR_St == 1)
				{
					Sound_Request(SndMsg, Alarm_Trigger4);
				}
				else
				{
					Sound_Delete(SndMsg, Alarm_Trigger4);
				}
			}
			else if (SndMsg == Sound_Door_Open)
			{
				if (DoorOpen.u8LF_St == 1)
				{
					Sound_Request(SndMsg, Alarm_Trigger1);
				}
				else
				{
					Sound_Delete(SndMsg, Alarm_Trigger1);
				}
				if (DoorOpen.u8RF_St == 1)
				{
					Sound_Request(SndMsg, Alarm_Trigger2);
				}
				else
				{
					Sound_Delete(SndMsg, Alarm_Trigger2);
				}
				if (DoorOpen.u8LR_St == 1)
				{
					Sound_Request(SndMsg, Alarm_Trigger3);
				}
				else
				{
					Sound_Delete(SndMsg, Alarm_Trigger3);
				}
				if (DoorOpen.u8RR_St == 1)
				{
					Sound_Request(SndMsg, Alarm_Trigger4);
				}
				else
				{
					Sound_Delete(SndMsg, Alarm_Trigger4);
				}
			}
			else if (SndMsg == Sound_Door_Open_Off)
			{
				if (DoorOpen.u8LF_St == 1)
				{
					Sound_Request(SndMsg, Alarm_Trigger1);
				}
				else
				{
					Sound_Delete(SndMsg, Alarm_Trigger1);
				}
				if (DoorOpen.u8RF_St == 1)
				{
					Sound_Request(SndMsg, Alarm_Trigger2);
				}
				else
				{
					Sound_Delete(SndMsg, Alarm_Trigger2);
				}
				if (DoorOpen.u8LR_St == 1)
				{
					Sound_Request(SndMsg, Alarm_Trigger3);
				}
				else
				{
					Sound_Delete(SndMsg, Alarm_Trigger3);
				}
				if (DoorOpen.u8RR_St == 1)
				{
					Sound_Request(SndMsg, Alarm_Trigger4);
				}
				else
				{
					Sound_Delete(SndMsg, Alarm_Trigger4);
				}
			}
			else if (SndMsg == Sound_SafetyBelt)
			{
				if ((g_stSafeBelt.u8Left_St == 1)&&(g_stSafeBelt.Trigger == 1))
				{
					Sound_Request(SndMsg, Alarm_Trigger1);
				}
				else
				{
					Sound_Delete(SndMsg, Alarm_Trigger1);
				}
				if((g_stSafeBelt.u8Mid_St == 1)&&(g_stSafeBelt.Trigger == 1))
				{
					Sound_Request(SndMsg, Alarm_Trigger2);
				}
				else
				{
					Sound_Delete(SndMsg, Alarm_Trigger2);
				}
				if ((g_stSafeBelt.u8Right_St == 1)&&(g_stSafeBelt.Trigger == 1))
				{
					Sound_Request(SndMsg, Alarm_Trigger3);
				}
				else
				{
					Sound_Delete(SndMsg, Alarm_Trigger3);
				}
			}
			else
			{
				Sound_Request(SndMsg, Alarm_Trigger_ALL);
			}
		}
		else
		{
			Sound_Delete(SndMsg, Alarm_Trigger_ALL);
		}
	}

	/*�����״�*/
	if (((Val_EOL_F110_PDC() == 1) && (Val_EOL_F101_PDC() == 4)))
	{
		if (SYS_OPR_STAT_IGN_ON)
		{
			if (1 == Get_CAN_CH0_ID_0CFF1ADA_Sig_PDC_Warning_Frq())
			{
				Sound_Delete(Sound_Radar_2HZ, Alarm_Trigger1);
				Sound_Delete(Sound_Radar_4HZ, Alarm_Trigger1);
				Sound_Delete(Sound_Radar_Loop, Alarm_Trigger1);
				Sound_Request(Sound_Radar_1HZ, Alarm_Trigger1);
			}
			else if (2 == Get_CAN_CH0_ID_0CFF1ADA_Sig_PDC_Warning_Frq())
			{
				Sound_Delete(Sound_Radar_4HZ, Alarm_Trigger1);
				Sound_Delete(Sound_Radar_Loop, Alarm_Trigger1);
				Sound_Delete(Sound_Radar_1HZ, Alarm_Trigger1);
				Sound_Request(Sound_Radar_2HZ, Alarm_Trigger1);
			}
			else if (3 == Get_CAN_CH0_ID_0CFF1ADA_Sig_PDC_Warning_Frq())
			{
				Sound_Delete(Sound_Radar_Loop, Alarm_Trigger1);
				Sound_Delete(Sound_Radar_1HZ, Alarm_Trigger1);
				Sound_Delete(Sound_Radar_2HZ, Alarm_Trigger1);
				Sound_Request(Sound_Radar_4HZ, Alarm_Trigger1);
			}
			else if (5 == Get_CAN_CH0_ID_0CFF1ADA_Sig_PDC_Warning_Frq())
			{
				Sound_Delete(Sound_Radar_1HZ, Alarm_Trigger1);
				Sound_Delete(Sound_Radar_2HZ, Alarm_Trigger1);
				Sound_Delete(Sound_Radar_4HZ, Alarm_Trigger1);
				Sound_Request(Sound_Radar_Loop, Alarm_Trigger1);
			}
			else
			{
				Sound_Delete(Sound_Radar_Loop, Alarm_Trigger1);
				Sound_Delete(Sound_Radar_1HZ, Alarm_Trigger1);
				Sound_Delete(Sound_Radar_2HZ, Alarm_Trigger1);
				Sound_Delete(Sound_Radar_4HZ, Alarm_Trigger1);
			}
		}
		else
		{
			Sound_Delete(Sound_Radar_Loop, Alarm_Trigger1);
			Sound_Delete(Sound_Radar_1HZ, Alarm_Trigger1);
			Sound_Delete(Sound_Radar_2HZ, Alarm_Trigger1);
			Sound_Delete(Sound_Radar_4HZ, Alarm_Trigger1);
		}
	}
	else
	{
		Sound_Delete(Sound_Radar_Loop, Alarm_Trigger1);
		Sound_Delete(Sound_Radar_1HZ, Alarm_Trigger1);
		Sound_Delete(Sound_Radar_2HZ, Alarm_Trigger1);
		Sound_Delete(Sound_Radar_4HZ, Alarm_Trigger1);
	}
}

/*����ת��*/
void Sound_Turn_Lamp_Service(void)
{
	if (SYS_OPR_STAT_HALT)
	{
		Sound_Play_Switch_Handle(Sound_Play_NOTControl);
		return;
	}

	if ((Get_CAN_CH0_ID_18FE4021_Sig_BCM_LeftTurnSignalLights() == 1) || (Get_CAN_CH0_ID_18FE4021_Sig_BCM_LeftTurnSignalLights() == 2))
	{
		Turn_Lamp.Left = 1;
	}
	else
	{
		Turn_Lamp.Left = 0;
	}

	if ((Get_CAN_CH0_ID_18FE4021_Sig_BCM_RightTurnSignalLights() == 1) || (Get_CAN_CH0_ID_18FE4021_Sig_BCM_RightTurnSignalLights() == 2))
	{
		Turn_Lamp.Right = 1;
	}
	else
	{
		Turn_Lamp.Right = 0;
	}

	if ((SYS_OPR_STAT_IGN_ON) && (g_u8SelfLampTimes >= LED_SELF_CHECK_TIME))
	{
		// ת����  //������
		if (((Turn_Lamp.Left == 1) && (Turn_Lamp.Left_Last == 0)) || ((Turn_Lamp.Right == 1) && (Turn_Lamp.Right_Last == 0)))
		{
			Sound_Request(Sound_Tick, Alarm_Trigger1);
		}
		// ת����  //�½���
		if (((Turn_Lamp.Left == 0) && (Turn_Lamp.Left_Last == 1)) || ((Turn_Lamp.Right == 0) && (1 == Turn_Lamp.Right_Last)))
		{
			Sound_Request(Sound_Tock, Alarm_Trigger1);
		}
	}
	if (!SYS_OPR_STAT_IGN_ON)
	{
		if (((Turn_Lamp.Left == 1) && (Turn_Lamp.Left_Last == 0)) || ((Turn_Lamp.Right == 1) && (Turn_Lamp.Right_Last == 0)))
		{
			Sound_Request(Sound_Tick, Alarm_Trigger1);
		}
		// ת����  //�½���
		if (((Turn_Lamp.Left == 0) && (Turn_Lamp.Left_Last == 1)) || ((Turn_Lamp.Right == 0) && (Turn_Lamp.Right_Last == 1)))
		{
			Sound_Request(Sound_Tock, Alarm_Trigger1);
		}
	}

	Turn_Lamp.Left_Last = Turn_Lamp.Left;
	Turn_Lamp.Right_Last = Turn_Lamp.Right;
}

// 室外温度
void Sound_Outdoor_Temp_Service(void)
{
	// if(Val_EOL_F110_AC() == 1)
	//{
	if (SYS_OPR_STAT_IGN_ON)
	{
		if (AC_Temperature.Warn)
		{
			Sound_Request(Sound_Outdoor_Temp, Alarm_Trigger1);
		}
		else
		{
			Sound_Delete(Sound_Outdoor_Temp, Alarm_Trigger1);
		}
	}
	else
	{
		Sound_Delete(Sound_Outdoor_Temp, Alarm_Trigger1);
	}
	//}
	// else
	//{
	//	Sound_Delete(Sound_Outdoor_Temp ,Alarm_Trigger1);
	//}
}