/**********************************************************************************************************
 * Copyright(C) 2017, HeiLongJiang TYW Co.,Ltd.
 *
 * @Filename:       NM_Buf.c
 *
 * @Description:    Ļ
 *
 * @Functions List:
 *
 *
 * @History:        Version:            V0.0.1
                              Date:             2018-05-17 17:05:00
                    Author:             myliu
                    Modification:   creat
 **********************************************************************************************************/

/**********************************************************************************************************
 * Include
*/
#include "Include.h"
#include "NM_Buf.h"


/**********************************************************************************************************
 * Constants and defines
 */

/**********************************************************************************************************
 * Local variables
 */
static unsigned   char CanNmDataRxEnable = 1u;
static unsigned   char CanNmDataTxEnable = 1u;

/**********************************************************************************************************
 * Local functions
 */

/**********************************************************************************************************
 * Global variables
 */

/**********************************************************************************************************
 * Global functions
 */
/**********************************************************************************************************
 *@Function:        CanNm_Data_State
 *@Description: /ر·.
 *@Input:           CanNmDataType -- ·ͣ1:RX2:TX.
 *              State -- ·״̬ʹ/ֹ
 *@Output:        none.
 *@Calls:             none.
 *@Return:        none.
 *@Note:              һϽе.
 **********************************************************************************************************/
void CanNm_Data_State ( unsigned   char CanNmDataType, unsigned   char State )
{
    switch ( CanNmDataType )
    {
    case 1:
        if ( State )
        {
            CanNmDataRxEnable = 1u;
        }
        else
        {
            CanNmDataRxEnable = 0u;
        }
        break;

    case 2:
        if ( State )
        {
            CanNmDataTxEnable = 1u;
        }
        else
        {
            CanNmDataTxEnable = 0u;
        }
        break;

    default:
        break;
    }
}

/**********************************************************************************************************
 *@Function:          CanNm_Data_Indication
 *@Description:     յģ䱣ڻػ洢
 *@Input:               uint16_t Identifier -- ID.
 *                        unsigned   char DLC -- ݳ.
 *                        unsigned   char *Data -- .
 *@Output:            none.
 *@Calls:               none.
 *@Return:            none.
 *@Note:                none.
 **********************************************************************************************************/
void CanNm_Data_Indication ( unsigned  long Identifier, unsigned   char DLC, unsigned   char Data[] )
{
    unsigned   char i = 0u;
    unsigned   char CanNmMsg[8];

    if ( !CanNmDataRxEnable )
    {

    }
    else
    {
        if ( DLC == 8u )
        {
            if ( ( Identifier >= NM_ECU_ADDR_START ) && ( Identifier <= NM_ECU_ADDR_END ) )
            {
                for ( i = 0u; i < DLC; i++ )
                {
                    CanNmMsg[i] = Data[i];
                }
                CanNm_RecvNMPDUInd ( CanNmMsg );
            }
        }
    }
}

/**********************************************************************************************************
 *@Function:          CanNm_Data_Request
 *@Description:     ģһȼϸߣΪ0
 *@Input:               unsigned   char WakeupReason -- 绽ѵԭ򣬰KL15Ļ.
 *@Output:            none.
 *@Calls:               none.
 *@Return:            none.
 *@Note:                none.
 **********************************************************************************************************/
void CanNm_Data_Request ( NM_Wakeup_Reasons_t WakeupReason, Network_Request_Reasons_t StayawakeReson )
{
    unsigned   char       i = 0u;
    CANNmMsg_t    CanNmMsg;
    NM_Mode_t     CanNmMode = Bus_Sleep_Mode;
    /*_CAN_Msg    m_Msg;*/
    NetworkMode_State_t NetworkModeState = Repeat_Message_State;

    if (!CanNmDataTxEnable)
    {
    }
    else
    {

        if (NM_GetBusSt())
        {
        }
        else
        {
            for ( i = 0u; i < sizeof ( CanNmMsg.Msg ); i++ )
            {
                CanNmMsg.Msg[i] = 0u;
            }

            CanNmMsg.Sig.ICU_Address0 = 0x17u;
            /*Slave node, Repeat Message State is equal 0*/
            CanNmMsg.Sig.ICU_RMR0 = 0u;
            /*Wakeup Reason*/
            if ( WakeupReason == NM_KL15 )
            {
                CanNmMsg.Sig.ICU_AWB0 = 1u;
                CanNmMsg.Sig.ICU_Wakeup_reasons = 1u;
            }
            else
            {
                CanNmMsg.Sig.ICU_AWB0 = 0u;
                CanNmMsg.Sig.ICU_Wakeup_reasons = 2u;
            }
            /*Network Manage state*/
            CanNmMode = CanNm_GetMode();
            NetworkModeState = CanNm_GetState();
            if ( ( CanNmMode == Network_Mode ) && ( NetworkModeState == Normal_Operation_State ) )
            {
                CanNmMsg.Sig.ICU_NMSts0 = 1u;
                if ( StayawakeReson == NM_REQ_KL15_ON )
                {
                    CanNmMsg.Sig.ICU_Stayawake_KL15 = 1u;
                }
                else if ( StayawakeReson == NM_REQ_DIAG_RECVD )
                {
                    CanNmMsg.Sig.ICU_Stayawake_Diag = 1u;
                }
                else
                {

                }
            }
            else
            {
                CanNmMsg.Sig.ICU_NMSts0 = 0u;
            }
            /*ģȼȽϸߣʱ̶Ϊ0*/
            if(AnalogKL30Voltage <= 9000)
            {
                return;
            }
            else
            {
                Bsp_Can_Send(NM_FRAME_ID, 8, CanNmMsg.Msg, 0);
            }
           	
        }
    }
}

/**********************************************************************************************************
 *@Function:        CanNm_Data_Confirm
 *@Description: ʾѾɹ·ģһ·.
 *@Input:           uint16_t Identifier -- ID.
 *              unsigned   char TransferStatus -- ķ״̬orδ
 *@Output:        none.
 *@Calls:             none.
 *@Return:        none..
 *@Note:              none.
 **********************************************************************************************************/
void CanNm_Data_Confirm ( unsigned  long Identifier, unsigned   char TransferStatus )
{
    if ( ( Identifier < NM_ECU_ADDR_START ) || ( Identifier > NM_ECU_ADDR_END ) )
    {

    }
    else
    {
        if ( TransferStatus == COMPLETE )
        {
            CanNm_TransNMPDUInd();
        }
        else
        {

        }
    }
}

