/*  BEGIN_FILE_HDR
********************************************************************************
*   NOTICE
*   This software is the property of HiRain Technologies. Any information
*   contained in this doc should not be reproduced, or used, or disclosed
*   without the written authorization from HiRain Technologies.
********************************************************************************
*   File Name       : Platform_Types.h
********************************************************************************
*   Project/Product : Common
*   Title           : Platform_Types.h
*   Author          : ning.chen
********************************************************************************
*   Description     : platform related types
*
********************************************************************************
*   Limitations     : only used for Freescale S12X
*
********************************************************************************
*
********************************************************************************
*   Revision History:
*
*   Version     Date          Initials      CR#          Descriptions
*   ---------   ----------    ------------  ----------   ---------------
*   01.00.00    13/06/2013    ning.chen     N/A          Original
*   01.00.01    17/07/2013    ning.chen     N/A          DPN_COMMON_130717_01
*   01.00.02    15/08/2013    ning.chen     N/A          D10_COMMON51_130815_01
*   01.00.03    08/01/2014    ning.chen     N/A          D10_COMMON51_140108_01
********************************************************************************
* END_FILE_HDR*/

#ifndef _PLATFORM_TYPES_H_
#define _PLATFORM_TYPES_H_

/*******************************************************************************
*   Includes
*******************************************************************************/
/*#include "stdint.h"*/
/*******************************************************************************
*   Macro
*******************************************************************************/
#define CPU_TYPE_8       (8u)
#define CPU_TYPE_16      (16u)
#define CPU_TYPE_32      (32u)

#define MSB_FIRST        (0u)    /* big endian bit ordering */
#define LSB_FIRST        (1u)    /* little endian bit ordering */

#define HIGH_BYTE_FIRST  (0u)    /* big endian byte ordering */
#define LOW_BYTE_FIRST   (1u)    /* little endian byte ordering */


/*#ifndef TRUE
#define TRUE   (1u)
#endif

#ifndef FALSE
#define FALSE  (0u)
#endif
 */





#define CPU_TYPE            CPU_TYPE_16
#define CPU_BIT_ORDER       LSB_FIRST
#define CPU_BYTE_ORDER      HIGH_BYTE_FIRST

/*******************************************************************************
*   Typedef
*******************************************************************************/
typedef unsigned char       boolean;

typedef signed char         sint8;
typedef unsigned char       uint8;
typedef signed short        sint16;
typedef unsigned short      uint16;
typedef signed long         sint32;
typedef unsigned long       uint32;

typedef signed char         sint8_least;
typedef unsigned char       uint8_least;
typedef signed short        sint16_least;
typedef unsigned short      uint16_least;
typedef signed long         sint32_least;
typedef unsigned long       uint32_least;

typedef float               float32;
typedef double              float64;





#define NM_FRAME_ID                     0x18FFFA17u

#define COMPLETE                            1u
#define NO_COMPLETE                         0u
typedef enum
{
  BusInit,
  BusSleep,
  BusAwake,
} D_Init_Routine_t;

typedef enum
{
  NM_Default = 0x00u,
  NM_KL15 = 0x01u,
  NM_PDU_Received = 0x02u,
} NM_Wakeup_Reasons_t;

typedef enum
{
  NM_NOT_AWAKE,
  NM_REQ_KL15_ON,
  NM_REQ_DIAG_RECVD,
} Network_Request_Reasons_t;

typedef enum
{
  NM_REQ_KL15_OFF = 1u,
  NM_REQ_DIAG_TIMEOUT,
} Network_Release_Reasons_t;


typedef enum
{
  Bus_Sleep_Mode,
  Pre_Bus_Sleep_Mode,
  Network_Mode,
} NM_Mode_t;

typedef enum
{
  Repeat_Message_State,
  Normal_Operation_State,
  Ready_Sleep_State,
} NetworkMode_State_t;

typedef enum
{
  NM_Trms_Timer,
  NM_Tnm_Timer,
  NM_Twbs_Timer,
  NM_Ticyc_Timer,
  NM_Tcyc_Timer,
  NM_Tdiag_Timer,
} NM_Timer_Name_t;




typedef struct
{
  unsigned   char   NM_Trms_Enable        : 1u;
  unsigned   char   NM_Tnm_Enable       : 1u;
  unsigned   char   NM_Twbs_Enable      : 1u;
  unsigned   char   NM_Ticyc_Enable     : 1u;
  unsigned   char   NM_Tcyc_Enable      : 1u;
  unsigned   char     NM_Tdiag_Enable       : 1u;
  unsigned   char   NM_Trms_Timeout       : 1u;
  unsigned   char   NM_Tnm_Timeout      : 1u;
  unsigned   char   NM_Twbs_Timeout     : 1u;
  unsigned   char   NM_Ticyc_Timeout    : 1u;
  unsigned   char   NM_Tcyc_Timeout     : 1u;
  unsigned   char     NM_Tdiag_Timeout      : 1u;
} NM_Timer_State_t;


typedef union
{
  unsigned   int Words;

  struct
  {
    unsigned   int Network_Requested    : 1u;      /*Condition 1:Network Requested, as +KL15 or diagnostic*/
    unsigned   int Succ_Recv_NMPDU    : 1u;      /*Condition 2:Successfully Received NM PDU*/
    unsigned   int Succ_Trans_NMPDU   : 1u;      /*Condition 3:Successfully Transmit NM PDU*/
    unsigned   int NM_Trms_Timeout      : 1u;      /*Condition 4:T_REPEAT_MESSAGE timer has expired*/
    unsigned   int Network_Released     : 1u;      /*Condition 5:Network Released, in IGN_OFF*/
    unsigned   int NM_Tnm_Timeout       : 1u;      /*Condition 6:T_NM_TIMEROUT has expired*/
    unsigned   int Repeat_Msg_Bit_Recv  : 1u;      /*Condition 7:Repeat Message Bit Received*/
    unsigned   int NM_Twbs_Timeout      : 1u;      /*Condition 8:T_WAIT_BUS_SLEEP timer has expired*/
    unsigned   int NM_Repeat_Msg_Req    : 1u;      /*Condition 9:NM Repeat Message Request*/
    unsigned   int NM_Ticyc_Timeout     : 1u;      /*Condition 10:T_NM_ImmediateCycTime timer has expired*/
    unsigned   int NM_Tcyc_Timeout      : 1u;      /*Condition 11:T_NM_MessageCycle timer has expired*/
    unsigned   int                      : 5u;      /*Save*/
  } Bits;
} NM_Event_List_t;


/**********************************************************************************************************
 * Defines
 */
#define T_REPEAT_MESSAGE            1700ul*1000ul                /*Timer for a node becomes visible to the other nodes on the network（这个参数最满足要求，否则可能造成多一帧少一帧）*/
#define T_NM_TIMEOUT                2000ul*1000ul                 /*As long as the node enter the network mode and start this timer. When the timer is expired, the node will enter the Prepare Bus Sleep Mode*/
#define T_WAIT_BUS_SLEEP            2000ul*1000ul                 /*The timer is to ensure that all nodes have time to stop their network activity*/
#define T_START_NM_TX               20ul*1000ul                   /*The time describes all sent NM message behaviour that the NM node enters network mode from Prepare Bus Sleep Mode, Normal Operation State or Ready Sleep State and start to transmit the first NM PDU.*/
#define T_STARTx_AppFrame           20ul*1000ul           /*The maximum interval time starts sending application message after send the first NM-PDU successfully*/
#define T_NM_ImmediateCycleTime     20ul*1000ul     /*In generally, network request of node should be trigger the immediate transmission mechanism and NM-PDU will be transmitted with this periodic in Repeat Message State.*/
#define T_NM_MessageCycle           500ul*1000ul      /*The interval time is every two NM frames which are transmitted in Network Mode except Ready Sleep State*/
#define T_Wake_Up                   100ul*1000ul      /*The value is max time that the node from the Sleep Mode to Network Mode and send the first NM PDU, generally transmit in Repeat Message State*/
#define T_DIAG_TIMEOUT              5010ul*1000ul



#define N_ImmediateNM_TIMES         10u

/*#define API_Cycle 1000ul*/


/**********************************************************************************************************
 * Constants and defines
 */


#endif  /* _PLATFORM_TYPES_H_ */

