

#include "Include.h"
// #include "System_Status_Monitor.h"

#pragma MESSAGE DISABLE C4000
#pragma MESSAGE DISABLE C4001

/******************************************************************************

  ܣϵͳ״̬ʼ
        ״ϵʱʼһ
  
ֵ
******************************************************************************/
void Sys_Status_Init(void)
{
	SysStatUpdateMode = SYS_STAT_UPDATE_MODE_INIT;

	//SysPowerStatus = 0x00;
	//SysOperatingStatus = 0x00;

	SysPwrMode.Mode = SYS_PWR_INIT_MODE;
	SysPwrMode.LVPTimer = 0;
	SysPwrMode.NormalTimer = 0;
	SysPwrMode.OVPTimer = 0;

	SysKL15Signal.Status = SYS_SIG_STAT_INACTIVE;
	SysKL15Signal.Timer = 0;
}

/******************************************************************************
Sys_Status_Update_Mode_Set
  ܣϵͳ״̬ģʽ
  Modeģʽ SYS_STAT_UPDATE_MODE_NORMAL   - ģʽ
                       SYS_STAT_UPDATE_MODE_WAKEUP   - ߺѸģʽ
                       SYS_STAT_UPDATE_MODE_RECOVERY - ѹ쳣ָģʽ
                       SYS_STAT_UPDATE_MODE_INIT     - ʼģʽ
ֵ
******************************************************************************/
void Sys_Status_Update_Mode_Set(uint8_t Mode)
{
	if (Mode != SysStatUpdateMode) //ģʽ仯ʱ,жʱ
	{
		SysPwrMode.LVPTimer = 0;
		SysPwrMode.NormalTimer = 0;
		SysPwrMode.OVPTimer = 0;

		SysKL15Signal.Timer = 0;

		SysStatUpdateMode = Mode;
	}
}
//ѹ쳣⣬ͬģʽ¶Ҫж
//20ms һ
void Voltage_Abnormal_Detect(INT16U Voltage, INT8U Mode)
{
	INT8U Debounce_Count = 0;
	if (SYS_STAT_UPDATE_MODE_INIT == Mode) //ʼ//ѵģʽ
	{
		Debounce_Count = 5;
	}
	else if (SYS_STAT_UPDATE_MODE_WAKEUP == Mode)
	{
		//ģʽ£˯ʱѹ쳣
		if (_IGN_Sleep == g_Power_St)
		{
			return;
		}
		else //ʱӦѾIGOFFˣû˯
		{
			Debounce_Count = SYS_PWR_DEBOUNCE_TIME / 20;
		}
	}
	else //еģʽ
	{
		Debounce_Count = SYS_PWR_DEBOUNCE_TIME / 20;
	}

	//ѹɼЧֵʱ   0
	if (Voltage)
	{
		switch (SysPwrMode.Mode) //Դ״̬ת
		{
			case SYS_PWR_LVP_MODE:
				if (Voltage >= SYS_OVP_ENTER_THRESHOLD)
				{
					SysPwrMode.NormalTimer = 0;
					SysPwrMode.OVPTimer++;
				}
				else if (Voltage >= SYS_LVP_EXIT_THRESHOLD)
				{
					SysPwrMode.NormalTimer++;
					SysPwrMode.OVPTimer = 0;
				}
				else
				{
					SysPwrMode.NormalTimer = 0;
					SysPwrMode.OVPTimer = 0;
				}

				if (SysPwrMode.OVPTimer >= Debounce_Count)
				{
					SysPwrMode.Mode = SYS_PWR_OVP_MODE;
					SysPwrMode.NormalTimer = 0;
					SysPwrMode.OVPTimer = 0;
				}
				else if (SysPwrMode.NormalTimer >= Debounce_Count)
				{
					SysPwrMode.Mode = SYS_PWR_NORMAL_MODE;
					SysPwrMode.NormalTimer = 0;
					SysPwrMode.OVPTimer = 0;
				}
				break;
			case SYS_PWR_INIT_MODE:
			case SYS_PWR_NORMAL_MODE:
				if (Voltage < SYS_LVP_ENTER_THRESHOLD)
				{
					SysPwrMode.LVPTimer++;
					SysPwrMode.OVPTimer = 0;
					SysPwrMode.NormalTimer = 0;
				}
				else if (Voltage >= SYS_OVP_ENTER_THRESHOLD)
				{
					SysPwrMode.LVPTimer = 0;
					SysPwrMode.OVPTimer++;
					SysPwrMode.NormalTimer = 0;
				}
				else
				{
					SysPwrMode.LVPTimer = 0;
					SysPwrMode.OVPTimer = 0;
					SysPwrMode.NormalTimer++;
				}

				if (SysPwrMode.LVPTimer >= Debounce_Count)
				{
					SysPwrMode.Mode = SYS_PWR_LVP_MODE;
					SysPwrMode.LVPTimer = 0;
					SysPwrMode.OVPTimer = 0;
					SysPwrMode.NormalTimer = 0;
				}
				else if (SysPwrMode.OVPTimer >= Debounce_Count)
				{
					SysPwrMode.Mode = SYS_PWR_OVP_MODE;
					SysPwrMode.LVPTimer = 0;
					SysPwrMode.OVPTimer = 0;
					SysPwrMode.NormalTimer = 0;
				}
				else if (SysPwrMode.NormalTimer >= Debounce_Count)
				{
					SysPwrMode.Mode = SYS_PWR_NORMAL_MODE;
					SysPwrMode.LVPTimer = 0;
					SysPwrMode.OVPTimer = 0;
					SysPwrMode.NormalTimer = 0;
				}
				break;

			case SYS_PWR_OVP_MODE:
				if (Voltage < SYS_LVP_ENTER_THRESHOLD)
				{
					SysPwrMode.LVPTimer++;
					SysPwrMode.NormalTimer = 0;
				}
				else if (Voltage < SYS_OVP_EXIT_THRESHOLD)
				{
					SysPwrMode.LVPTimer = 0;
					SysPwrMode.NormalTimer++;
				}
				else
				{
					SysPwrMode.LVPTimer = 0;
					SysPwrMode.NormalTimer = 0;
				}

				if (SysPwrMode.LVPTimer >= Debounce_Count)
				{
					SysPwrMode.Mode = SYS_PWR_LVP_MODE;
					SysPwrMode.LVPTimer = 0;
					SysPwrMode.NormalTimer = 0;
				}
				else if (SysPwrMode.NormalTimer >= Debounce_Count)
				{
					SysPwrMode.Mode = SYS_PWR_NORMAL_MODE;
					SysPwrMode.LVPTimer = 0;
					SysPwrMode.NormalTimer = 0;
				}
				break;

			default:
				SysPwrMode.Mode = SYS_PWR_NORMAL_MODE;
				SysPwrMode.LVPTimer = 0;
				SysPwrMode.NormalTimer = 0;
				SysPwrMode.OVPTimer = 0;
				break;
		}
	}
}
//KL15⣬15ޣǸߵ
//20msһݶ
void Voltage_KL15ON_Detect(INT16U Voltage, INT8U Mode)
{
	INT8U Debounce_Count = 0;
	if (SYS_STAT_UPDATE_MODE_INIT == Mode) //ʼ
	{
		Debounce_Count = 5;
	}
	else if (SYS_STAT_UPDATE_MODE_WAKEUP == Mode) //ѵģʽ
	{
		Debounce_Count = 5;
	}
	else //еģʽ
	{
		Debounce_Count = (SYS_OPR_DEBOUNCE_TIME / 20);
	}
	//IGN״̬
	if (SysKL15Signal.Status == SYS_SIG_STAT_ACTIVE)
	{
		if (Voltage < SYS_OFF_THRESHOLD)
		{
			SysKL15Signal.Timer++;
			if (SysKL15Signal.Timer >= Debounce_Count)
			{
				SysKL15Signal.Status = SYS_SIG_STAT_INACTIVE;
				SysKL15Signal.Timer = 0;
			}
		}
		else
			SysKL15Signal.Timer = 0;
	}
	else
	{
		if (Voltage >= SYS_ON_THRESHOLD)
		{
			SysKL15Signal.Timer++;
			if (SysKL15Signal.Timer >= Debounce_Count)
			{
				SysKL15Signal.Status = SYS_SIG_STAT_ACTIVE;
				SysKL15Signal.Timer = 0;
			}
		}
		else
			SysKL15Signal.Timer = 0;
	}
}
/******************************************************************************
Sys_Status_Update_Service
  ܣϵͳ״̬·
  
ֵ
*******************************************************************************
ע  ⣺÷ڲͬĹģʽҪղͬڵ
        SYS_STAT_UPDATE_MODE_NORMAL   ģʽ,ÿ  20ms һ
        SYS_STAT_UPDATE_MODE_WAKEUP   ģʽ,ϸҪʱ
        SYS_STAT_UPDATE_MODE_RECOVERY ģʽ,ÿ 100ms һ
        SYS_STAT_UPDATE_MODE_INIT     ģʽ,ڳʼ׶εһ
******************************************************************************/
void Sys_Status_Update_Service(void)
{
	uint8_t i;

	uint16_t Voltage;
	uint16_t RocBackup;
	uint16_t Counter;
	uint8_t OpStatus;

	if (SysStatUpdateMode == SYS_STAT_UPDATE_MODE_NORMAL) //ģʽ
	{
		if ((ANALOG_KL30_VOLTAGE_VALID == 0) || (ANALOG_KL15_VOLTAGE_VALID == 0))
			return; //ڵԴѹЧ²Ž״̬

		Voltage_Abnormal_Detect(ANALOG_KL30_VOLTAGE, SYS_STAT_UPDATE_MODE_NORMAL);
		Voltage_KL15ON_Detect(ANALOG_KL15_VOLTAGE, SYS_STAT_UPDATE_MODE_NORMAL);
	}
	else if (SysStatUpdateMode == SYS_STAT_UPDATE_MODE_WAKEUP) //Ѹģʽ
	{
	
		Voltage_Abnormal_Detect(ANALOG_KL30_VOLTAGE, SYS_STAT_UPDATE_MODE_WAKEUP);
	
		//IGNԴ5μ,5ξֵΪIGN ON
		for (i = 0; i < 5; i++)
		{
			Analog_KL15_Voltage_Conversion();
			Voltage_KL15ON_Detect(ANALOG_KL15_VOLTAGE, SYS_STAT_UPDATE_MODE_WAKEUP);
			if (ANALOG_KL15_VOLTAGE < SYS_ON_THRESHOLD)
				return;
		}
		//5ζֵˣΪ15
	}
	else //ʼģʽ//SYS_STAT_UPDATE_MODE_INIT
	{
		//ϵʱ250ms,ȴԴѹȶ
		RocBackup = API_ROLLING_COUNTER;
		do
		{
			Counter = API_ROLLING_COUNTER;
			Counter -= RocBackup;
		} while (Counter < (250000 / API_INT_CYCLE));

		//ĬϵԴΪ״̬,ʼԴ״̬

		SysKL15Signal.Timer = 0;
		SysKL15Signal.Status = SYS_SIG_STAT_INACTIVE;

		SysPwrMode.NormalTimer = 0;
		SysPwrMode.LVPTimer = 0;
		SysPwrMode.OVPTimer = 0;
		SysPwrMode.Mode = SYS_PWR_INIT_MODE;

		for (;;)
		{
			Voltage = 0;
			Analog_KL15_Voltage_Conversion();
			Analog_KL30_Voltage_Conversion();

			Voltage_KL15ON_Detect(ANALOG_KL15_VOLTAGE, SYS_STAT_UPDATE_MODE_INIT);

			Voltage_Abnormal_Detect(ANALOG_KL30_VOLTAGE, SYS_STAT_UPDATE_MODE_INIT);
			//ȹ˳ʼ״̬
			if (SYS_PWR_INIT_MODE != SysPwrMode.Mode)
			{
				break;
			}
		}
	}
}
