#include "Include.h"

unsigned int Unit_Conv_kPa_To_bar(unsigned int kPa)
{
	return kPa / 10;
}

uint16_t IOoutput_KeyInTimeCnt;

void DataProcessor_On_System_Init(void)
{
	Vehicle_Speed_Init();
	Data_Consumed_Power_Init();
	DataOverSpeed = 120;
	Data_30KL_Init();
	// Coolant_Meter_Data_Reset();
	Data_AC_Temp_Init();
}

void DataProcessor_OFF_To_ON_Init(void)
{
	Vehicle_Speed_Init();
	Data_Consumed_Power_Init();
	Data_AC_Temp_Init();
	Data_15KL_Init();
	Clear_ODO_Flag = 0;
	Can_Receive_KL30_WakeUp_Init();
}

void Can_Receive_KL30_WakeUp_Init(void)
{
	CanReceive.Can_18FEE69F = 0;
	CanReceive.Can_18FAB027 = 0;
	CanReceive.Can_18FF2319 = 0;
	CanReceive.Can_18FAB227 = 0;
	CanReceive.Can_18FAB327 = 0;
	CanReceive.Can_18FA40F4 = 0;
	CanReceive.Can_18FF629F = 0;
	CanReceive.Can_18FA4AF4 = 0;
	CanReceive.Can_18FA48F4 = 0;
	CanReceive.Can_0CFAB127 = 0;
	CanReceive.Can_18FAA027 = 0;
	CanReceive.Can_0CFAA627 = 0;
	CanReceive.Can_18FC03F4 = 0;
	CanReceive.Can_0CFF1ADA = 0;
}

void Can_18FEE69F_Receive(void)
{
	CanReceive.Can_18FEE69F = 1;
}
void Can_18FAB027_Receive(void)
{
	CanReceive.Can_18FAB027 = 1;
}
void Can_18FF2319_Receive(void)
{
	CanReceive.Can_18FF2319 = 1;
}
void Can_18FAB227_Receive(void)
{
	CanReceive.Can_18FAB227 = 1;
}
void Can_18FAB327_Receive(void)
{
	CanReceive.Can_18FAB327 = 1;
}
void Can_18FA40F4_Receive(void)
{
	CanReceive.Can_18FA40F4 = 1;
}
void Can_18FF629F_Receive(void)
{
	CanReceive.Can_18FF629F = 1;
}
void Can_18FA4AF4_Receive(void)
{
	CanReceive.Can_18FA4AF4 = 1;
}
void Can_18FA48F4_Receive(void)
{
	CanReceive.Can_18FA48F4 = 1;
}
void Can_0CFAB127_Receive(void)
{
	CanReceive.Can_0CFAB127 = 1;
}
void Can_18FAA027_Receive(void)
{
	CanReceive.Can_18FAA027 = 1;
}
void Can_0CFAA627_Receive(void)
{
	CanReceive.Can_0CFAA627 = 1;
}
void Can_18FC03F4_Receive(void)
{
	CanReceive.Can_18FC03F4 = 1;
}
void Can_0CFF1ADA_Receive(void)
{
	CanReceive.Can_0CFF1ADA = 1;
}

/******************************************************************************
��������DMM_Checksum_Processing_Service
��  ��: DDM�ź�Checksum���ݴ���
��  ��: ��
����ֵ����
******************************************************************************/
uint8_t DMM_Checksum_Processing_Service(void)
{
	// shican
	/* uint8_t crc = 0xff;
	 uint8_t i = 0;
	 uint8_t j = 0;

	for( i = 0; i < cb_DATA_BYTE_SIZE; ++i)
	{
		crc ^=CANMsg_18FAD084.Data[i];

		for( j = 0 ; j < 8 ; ++ j)
		{
			if( (crc & 0x80) != 0 )
			{
				crc = ( crc << 1 )^cb_CRC_POLY;
			}
			else
			{
				crc = (crc << 1);
			}
		}
	}

	return  ~crc; */
}

void DMM_Processing_Service(void)
{
	// shican
	/*uint8_t   Checksum;

	if(CANMsg_18FAD084_Status.Status_byte &CAN_UPDATE)
	{
			 CANMsg_18FAD084_Status.Status_byte = 0;
			 Checksum = DMM_Checksum_Processing_Service();

		if(Checksum == DMM_Check_Sum)
		{
			DMM_Valid = 1;
		}
		else
		{
			DMM_Valid = 0;
		}
	}*/
}

/******************************************************************************
��������RTC_TIME_Processing_Service
��  ��: ʱ�����ݴ���
��  ��: ��
����ֵ����
******************************************************************************/
void RTC_TIME_Processing_Service(void)
{
	if(Val_EOL_F110_TBOX() == 0)//手动
	{
		DspTimeHour = RTC_HOUR;
		DspTimeSencond = RTC_SECOND;
		DspTimeMin = RTC_MINUTE;
		DspTimeDate = RTC_DATE;
		DspTimeMonth = RTC_MONTH;
		DspTimeYear = RTC_YEAR;
	}
	else
	{
		if (Menu_Item_Select_Get(MENU_ITEM_SET_TIME_Synch))
		{
			if ((CAN_MSG_Status(CAN_CH0, CAN_CH0_ID_TBOX_TD_Msg_Count) == CAN_MSG_LOST) || (CanReceive.Can_18FEE69F != 1) ||
				(Get_CAN_CH0_ID_18FEE69F_Sig_TBOX_Second() > 0XEC) || (Get_CAN_CH0_ID_18FEE69F_Sig_TBOX_Minute() > 0X3B) || (Get_CAN_CH0_ID_18FEE69F_Sig_TBOX_Hour() > 0X17) || (Get_CAN_CH0_ID_18FEE69F_Sig_TBOX_Month() > 0x0C) || (Get_CAN_CH0_ID_18FEE69F_Sig_TBOX_Day() > 0x7C) || (Get_CAN_CH0_ID_18FEE69F_Sig_TBOX_Year() > 0xFA))
			{
				CanReceive.Can_18FEE69F = 0;
				DspTimeHour = RTC_HOUR;
				DspTimeSencond = RTC_SECOND;
				DspTimeMin = RTC_MINUTE;
				DspTimeDate = RTC_DATE;
				DspTimeMonth = RTC_MONTH;
				DspTimeYear = RTC_YEAR;
			}
			else
			{
				RTC_SECOND = Get_CAN_CH0_ID_18FEE69F_Sig_TBOX_Second() / 4;
				RTC_MINUTE = Get_CAN_CH0_ID_18FEE69F_Sig_TBOX_Minute();
				RTC_HOUR = Get_CAN_CH0_ID_18FEE69F_Sig_TBOX_Hour();
				RTC_DATE = Get_CAN_CH0_ID_18FEE69F_Sig_TBOX_Day() / 4;
				RTC_MONTH = Get_CAN_CH0_ID_18FEE69F_Sig_TBOX_Month();
				RTC_YEAR = Get_CAN_CH0_ID_18FEE69F_Sig_TBOX_Year() + 1985;

				DspTimeHour = RTC_HOUR;
				DspTimeSencond = RTC_SECOND;
				DspTimeMin = RTC_MINUTE;
				DspTimeDate = RTC_DATE;
				DspTimeMonth = RTC_MONTH;
				DspTimeYear = RTC_YEAR;
			}
		}
		else
		{
			DspTimeHour = RTC_HOUR;
			DspTimeSencond = RTC_SECOND;
			DspTimeMin = RTC_MINUTE;
			DspTimeDate = RTC_DATE;
			DspTimeMonth = RTC_MONTH;
			DspTimeYear = RTC_YEAR;
		}
	}	
}

/**********************����*********************/
/**********************20ms*********************/
/**********************���ĵ���ʱ��500ms*********************/
void Vehicle_Speed_Init(void)
{
	DataVSpeedActual = 0;
	DataVSpeedDisp = 0;
	DataVSpeedHysteresis = 0;
	DataVSpeedValid = 0;
	DataVSpeedSampler.Timer = 0;
	DataVSpeedSampler.Backup = 0;
	DataVSpeedSampler.UseBackup = 0;
	DataVSpeedSampler.Cnt = 0;
	DataVSPeedDamping.Speed = 0;
	DataVSPeedDamping.Delta = 0;
	DataVSPeedDamping.Dir = DATA_APPR_DIR_INC;
}

void Data_Vehicle_Speed_Processing_Service(void)
{
	uint8_t i;
	uint16_t Delta;
	uint32_t VSpeed;
	uint32_t VSpeedCal;
	uint32_t ABS_vehicle_speed;
	ABS_vehicle_speed = Get_CAN_CH0_ID_0CFAB127_Sig_PMS_VehicleSpd();

	// ��1������ȡʵ�ʳ���ֵ��������Ч��
	if (SYS_OPR_STAT_IGN_ON)
	{
		if ((CAN_MSG_Status(CAN_CH0, CAN_CH0_ID_PMS_CFAB127_Msg_Count) == CAN_MSG_LOST) || (ABS_vehicle_speed > 0xFAFF) || (Get_CAN_CH0_ID_0CFAB127_Sig_PMS_VehicleSpd_flag() == 1))
		{
			if ((CAN_MSG_Status(CAN_CH0, CAN_CH0_ID_PMS_CFAB127_Msg_Count) == CAN_MSG_LOST) || (Get_CAN_CH0_ID_0CFAB127_Sig_PMS_VehicleSpd_flag() == 1))
			{
				DataVSpeedValid = 0;
				DataVSpeedActual = 0;
				DataVSpeedSampler.Backup = 0;
			}
			else // �յ���Чֵ
			{
				if (DataVSpeedSampler.Timer < 100)
				{
					if (DataVSpeedValid)
					{
						DataVSpeedSampler.Timer++;
						DataVSpeedActual = DataVSpeedSampler.Backup;
					}
					else
					{
						DataVSpeedSampler.Timer = 100;
						DataVSpeedActual = 0;
						DataVSpeedSampler.Backup = 0;
					}
				}
				else // //���յ��㹻�����Чֵ
				{
					DataVSpeedValid = 0;
					DataVSpeedActual = 0;
					DataVSpeedSampler.Backup = 0;
				}
			}
			DataVSpeedSampler.Cnt = 0;
		}
		else
		{
			if (DataVSpeedValid == 0)
			{
				DataVSpeedValid = 1;

				VSpeed = ABS_vehicle_speed;
				VSpeed *= 5;
				VSpeed >>= 7;

				DataVSpeedActual = VSpeed;
			}
			else
			{
				DataVSpeedSampler.Buffer[DataVSpeedSampler.Cnt] = ABS_vehicle_speed;

				i = DataVSpeedSampler.Cnt;
				while ((i > 0) && (DataVSpeedSampler.Buffer[i] < DataVSpeedSampler.Buffer[i - 1]))
				{
					VSpeed = DataVSpeedSampler.Buffer[i];
					DataVSpeedSampler.Buffer[i] = DataVSpeedSampler.Buffer[i - 1];
					DataVSpeedSampler.Buffer[i - 1] = VSpeed;
					i--;
				}

				DataVSpeedSampler.Cnt++;
				if (DataVSpeedSampler.Cnt >= 3)
				{
					DataVSpeedSampler.Cnt = 0;
					VSpeed = DataVSpeedSampler.Buffer[1];
					VSpeed *= 5;
					VSpeed >>= 7;

					DataVSpeedActual = VSpeed;
				}
			}

			DataVSpeedSampler.Timer = 0;
			DataVSpeedSampler.Backup = DataVSpeedActual;
		}
	}
	else
	{
		DataVSpeedValid = 0;
		DataVSpeedActual = 0;
		DataVSpeedSampler.Timer = 0;
		DataVSpeedSampler.Cnt = 0;
		DataVSpeedSampler.Backup = 0;
	}

	// ��2�������ٵ����ᴦ��
	VSpeed = DataVSpeedActual;

	if (VSpeed > DataVSPeedDamping.Speed) // ʵ��ֵ�ȵ�ǰ��ʾֵ��ʱ
	{
		Delta = VSpeed - DataVSPeedDamping.Speed;

		if (DataVSPeedDamping.Dir == DATA_APPR_DIR_INC) // ��ʾֵ������ʵ��ֵ����,��ά�ֵ�ǰ������������ٶ�
		{
			if (DataVSPeedDamping.Delta < Delta) // ��ǰ����С����ʾֵ��ʵ��ֵ�Ĳ�ֵ,���������ӵ��ٶ�
			{
				DataVSPeedDamping.Delta += DATA_VSPEED_INC_STEP;
				if (DataVSPeedDamping.Delta > Delta)
					DataVSPeedDamping.Delta = Delta;
			}
			else // ��ǰ�������ڵ�����ʾֵ��ʵ��ֵ�Ĳ�ֵ,���������뵱ǰ��ֵͬ��,���ӵ��ٶȼ��𲽼�С
				DataVSPeedDamping.Delta = Delta;

			Delta = DataVSPeedDamping.Delta;
			Delta /= DATA_VSPEED_DAMPING_FACTOR;

			if (Delta < DATA_VSPEED_APPR_SPEED_MIN)
				Delta = DATA_VSPEED_APPR_SPEED_MIN;

			DataVSPeedDamping.Speed += Delta;
			if (DataVSPeedDamping.Speed > VSpeed)
				DataVSPeedDamping.Speed = VSpeed;
		}
		else // ��ʾֵ���ڼ�С,�򾡿�������ٶ�Ϊ��Сʱ��������
		{
			if (DataVSPeedDamping.Delta > DATA_VSPEED_DEC_STEP)
				DataVSPeedDamping.Delta -= DATA_VSPEED_DEC_STEP;
			else
				DataVSPeedDamping.Delta = 0;

			Delta = DataVSPeedDamping.Delta;
			Delta /= DATA_VSPEED_DAMPING_FACTOR;

			if (Delta < DATA_VSPEED_APPR_SPEED_MIN)		   // �Ѽ�������С�ٶ�
				DataVSPeedDamping.Dir = DATA_APPR_DIR_INC; // ��������
			else
			{
				if (DataVSPeedDamping.Speed > Delta)
					DataVSPeedDamping.Speed -= Delta;
				else
					DataVSPeedDamping.Speed = 0;
			}
		}
	}
	else if (VSpeed < DataVSPeedDamping.Speed) // ʵ��ֵ�ȵ�ǰ��ʾֵСʱ
	{
		Delta = DataVSPeedDamping.Speed - VSpeed;

		if (DataVSPeedDamping.Dir == DATA_APPR_DIR_INC) // ��ʾֵ��������,�򾡿�������ٶ�Ϊ��Сʱ��������
		{
			if (DataVSPeedDamping.Delta > DATA_VSPEED_DEC_STEP)
				DataVSPeedDamping.Delta -= DATA_VSPEED_DEC_STEP;
			else
				DataVSPeedDamping.Delta = 0;

			Delta = DataVSPeedDamping.Delta;
			Delta /= DATA_VSPEED_DAMPING_FACTOR;

			if (Delta < DATA_VSPEED_APPR_SPEED_MIN)		   // �Ѽ�������С�ٶ�
				DataVSPeedDamping.Dir = DATA_APPR_DIR_DEC; // ��������
			else
			{
				DataVSPeedDamping.Speed += Delta;
				if (DataVSPeedDamping.Speed > 3000)
					DataVSPeedDamping.Speed = 3000;
			}
		}
		else // ��ʾֵ������ʵ��ֵ��С,��ά�ֵ�ǰ������������ٶ�
		{
			if (DataVSPeedDamping.Delta < Delta) // ��ǰ(��)����С����ʾֵ��ʵ��ֵ�Ĳ�ֵ,��������С���ٶ�
			{
				DataVSPeedDamping.Delta += DATA_VSPEED_INC_STEP;
				if (DataVSPeedDamping.Delta > Delta)
					DataVSPeedDamping.Delta = Delta;
			}
			else // ��ǰ(��)�������ڵ�����ʾֵ��ʵ��ֵ�Ĳ�ֵ,����(��)�����뵱ǰ��ֵͬ��,��С���ٶȼ��𲽼�С
				DataVSPeedDamping.Delta = Delta;

			Delta = DataVSPeedDamping.Delta;
			Delta /= DATA_VSPEED_DAMPING_FACTOR;

			if (Delta < DATA_VSPEED_APPR_SPEED_MIN)
				Delta = DATA_VSPEED_APPR_SPEED_MIN;

			if (DataVSPeedDamping.Speed < VSpeed + Delta)
				DataVSPeedDamping.Speed = VSpeed;
			else
				DataVSPeedDamping.Speed -= Delta;
		}
	}
	else // ʵ��ֵ�뵱ǰ��ʾֵ���ʱ
	{
		Delta = DataVSPeedDamping.Delta;
		Delta /= DATA_VSPEED_DAMPING_FACTOR;

		if (Delta > DATA_VSPEED_APPR_SPEED_MIN) // ��ǰ���ٶȲ�����С,˵����ֵ��������/��С��,�����ԭ����
		{
			if (DataVSPeedDamping.Delta > DATA_VSPEED_DEC_STEP) // ��ʾֵԽ����ʵ��ֵ,��ȻҪ�ȼ�������С�ٶ�,�ٸı䷽�򷵻�ʵ��ֵ
				DataVSPeedDamping.Delta -= DATA_VSPEED_DEC_STEP;
			else
				DataVSPeedDamping.Delta = 0;

			Delta = DataVSPeedDamping.Delta;
			Delta /= DATA_VSPEED_DAMPING_FACTOR;

			if (DataVSPeedDamping.Dir == DATA_APPR_DIR_INC) // ��ʾֵ��ǰ�����ӷ���
			{
				if (Delta < DATA_VSPEED_APPR_SPEED_MIN)		   // �Ѽ�������С�ٶ�
					DataVSPeedDamping.Dir = DATA_APPR_DIR_DEC; // ��������
				else
				{
					DataVSPeedDamping.Speed += Delta;
					if (DataVSPeedDamping.Speed > 2400)
						DataVSPeedDamping.Speed = 2400;
				}
			}
			else // ��ʾֵ��ǰ�Ǽ�С����
			{
				if (Delta < DATA_VSPEED_APPR_SPEED_MIN)		   // �Ѽ�������С�ٶ�
					DataVSPeedDamping.Dir = DATA_APPR_DIR_INC; // ��������
				else
				{
					if (DataVSPeedDamping.Speed > Delta)
						DataVSPeedDamping.Speed -= Delta;
					else
						DataVSPeedDamping.Speed = 0;
				}
			}
		}
	}

	// ��3����������ʾ����
	if ((DataVSPeedDamping.Speed >= DataVSpeedHysteresis) || (DataVSPeedDamping.Speed < DATA_VSPEED_HYSTERESIS))
	{
		DataVSpeedHysteresis = DataVSPeedDamping.Speed;
	}
	else
	{
		if (DataVSpeedHysteresis - DataVSPeedDamping.Speed >= DATA_VSPEED_HYSTERESIS)
		{
			DataVSpeedHysteresis = DataVSPeedDamping.Speed;
		}
	}

	VSpeedCal = (uint32_t)DataVSpeedHysteresis;

	/*   if(VSpeedCal > 100)
	   {
		   VSpeedCal *= 102;
		   VSpeedCal /= 100;
		   VSpeedCal += 10;
	   }  */
	if (VSpeedCal > 30)
	{
		VSpeedCal *= 103;
		VSpeedCal /= 100;
		VSpeedCal += 10;
	}
	else
	{
		VSpeedCal += 5;
		VSpeedCal /= 10;
		VSpeedCal *= 10;
	}

	DataVSpeedDisp = (uint16_t)VSpeedCal;

	if (DataVSpeedDisp >= 1400)
	{
		DataVSpeedDisp = 1400;
	}
}

void Drive_Info_Speed_Plus_Conversion_ISR(void)
{
	if (DriveInfoSpeedPlusConverter.enable)
	{
		DriveInfoSpeedPlusConverter.Timer++;

		if (DriveInfoSpeedPlusConverter.ActPeriod >= (500000 / API_INT_CYCLE)) // 1Hz���µ�Ƶ����������   500ms      10000
			DriveInfoSpeedPlusConverter.ActPeriod = DriveInfoSpeedPlusConverter.Period;

		if (DriveInfoSpeedPlusConverter.Timer >= DriveInfoSpeedPlusConverter.ActPeriod)
		{
			DriveInfoSpeedPlusConverter.Timer = 0;

			if (DriveInfoSpeedPlusConverter.Level)
			{
				DriveInfoSpeedPlusConverter.Level = 0;
				DriveInfoSpeedPlusConverter.ActPeriod = DriveInfoSpeedPlusConverter.Period; // �����ؼ�������
			}
			else
				DriveInfoSpeedPlusConverter.Level = 1;
		}

		GPIO_Speed_OUT_1 = DriveInfoSpeedPlusConverter.Level;
	}
	else
		GPIO_Speed_OUT_1 = 0;
}

void Drive_Info_Speed_Plus_Conversion_Init(void)
{
	DriveInfoSpeedPlusConverter.enable = 0;
	DriveInfoSpeedPlusConverter.Level = 1;
	DriveInfoSpeedPlusConverter.Timer = 0xFFFE;
	DriveInfoSpeedPlusConverter.Period = 0xFFFF;
	DriveInfoSpeedPlusConverter.ActPeriod = 0xFFFF;
}

void Drive_Info_Speed_Plus_Conversion(void)
{
	uint32_t Speed;

	if ((DATA_VEHICLE_SPEED_VALID) && (DATA_VEHICLE_SPEED_ACTUAL))
	{

		Speed = (uint32_t)(DATA_VEHICLE_SPEED_ACTUAL);
		if (Speed >= 2400)
			Speed = 2400;

		DriveInfoSpeedPlusConverter.Period = ((INT32U)200000) / (2 * Speed);
		DriveInfoSpeedPlusConverter.enable = 1;
	}
	else
	{
		if (DriveInfoSpeedPlusConverter.enable)
		{
			DriveInfoSpeedPlusConverter.enable = 0;
			DriveInfoSpeedPlusConverter.Level = 0;
			DriveInfoSpeedPlusConverter.Timer = 0;
			DriveInfoSpeedPlusConverter.Period = 0xFFFF;
			DriveInfoSpeedPlusConverter.ActPeriod = 0xFFFF;
		}
	}
}

void Drive_Info_Import_Export_Service(void)
{
	Drive_Info_Speed_Plus_Conversion(); // �������
}

/**********************����*********************/
/**********************10ms*********************/
/**********************���ĵ���ʱ��200ms*********************/
void Data_Consumed_Power_Init(void)
{
	DataConsPwr.Valid = 0;
	DataConsPwr.Value = 0;
	DataConsPwr.DispValue = 0;
	DataConsPwr.Symbol = Positive;
}

void Data_Consumed_Power_Service(void)
{
	uint32_t Pwr = 0;
	Pwr = Get_CAN_CH0_ID_18FAB027_Sig_PMS_PTSysElecPwrInd();

	if (SYS_OPR_STAT_IGN_ON)
	{
		if ((CAN_MSG_Status(CAN_CH0, CAN_CH0_ID_PMS_18FAB027_Msg_Count) == CAN_MSG_LOST) || (CanReceive.Can_18FAB027 != 1) || (Pwr == 0xFFFF))
		{
			CanReceive.Can_18FAB027 = 0;
			DataConsPwr.Valid = 0;
			DataConsPwr.Symbol = Positive;
			DataConsPwr.DispValue = 0;
			DataConsPwr.u8CANSignal_InputVal = 1000;
		}
		else
		{
			if (Pwr <= 0xFAFF)
			{
				DataConsPwr.Valid = 1;
				if (Pwr >= 32000)
				{
					DataConsPwr.DispValue = Pwr - 32000;
					DataConsPwr.Symbol = Positive;
					if (DataConsPwr.DispValue >= 1500)
					{
						DataConsPwr.DispValue = 1500;
					}
					DataConsPwr.u8CANSignal_InputVal = DataConsPwr.DispValue + 1000;
				}
				else
				{
					DataConsPwr.DispValue = 32000 - Pwr;
					DataConsPwr.Symbol = Negative;
					if (DataConsPwr.DispValue >= 1000)
					{
						DataConsPwr.DispValue = 1000; // 10p
					}
					DataConsPwr.u8CANSignal_InputVal = 1000 - DataConsPwr.DispValue;
				}
				DataConsPwr.Symbol_BackUp = DataConsPwr.Symbol;
				DataConsPwr.DispValue_BackUp = DataConsPwr.DispValue;
				DataConsPwr.u8CANSignal_InputVal_BackUp = DataConsPwr.u8CANSignal_InputVal;
				DataConsPwr.Valid_BackUp = DataConsPwr.Valid;
			}
			else//0xFB00-0xFFFE
			{
				DataConsPwr.Valid = DataConsPwr.Valid_BackUp;
				DataConsPwr.Symbol = DataConsPwr.Symbol_BackUp;
				DataConsPwr.DispValue = DataConsPwr.DispValue_BackUp;
				DataConsPwr.u8CANSignal_InputVal = DataConsPwr.u8CANSignal_InputVal_BackUp;
			}
		}
	}
	else
	{
		DataConsPwr.Valid = 0;
		DataConsPwr.DispValue = 0;
		DataConsPwr.Symbol = Positive;
		DataConsPwr.u8CANSignal_InputVal = 0;

		//DataConsPwr.Valid_BackUp = 0;
		//DataConsPwr.DispValue_BackUp = 0;
		//DataConsPwr.Symbol_BackUp = Positive;
		//DataConsPwr.u8CANSignal_InputVal_BackUp = 0; 
	}
}
/******************************************************************************
��������Data_Mileage_Rolling_Counter_Update_ISR
��  ��: ��̹�������
��  ��: ��
����ֵ����
******************************************************************************/
void Data_Mileage_Rolling_Counter_Update_ISR(void)
{
	uint16_t Mileage;
	if (SYS_OPR_STAT_IGN_ON)
	{
		if ((DATA_VEHICLE_SPEED_VALID) && (Clear_ODO_Flag < 1))
		{
			if (DATA_VEHICLE_SPEED_ACTUAL <= 2400)
			{
				Mileage = (DATA_VEHICLE_SPEED_ACTUAL * 25) / 9;
			}
			else
			{
				Mileage = (DATA_VEHICLE_SPEED_ACTUAL / 9) * 25;
			}

			DataMileage.mmRollingCounter += Mileage;

			// ��ԭʼ��mm��λ��Rolling Counter�任Ϊ��mΪ��λ
			if (DataMileage.mmRollingCounter - DataMileage.mmRoCBackup >= 1000)
			{
				Mileage = (DataMileage.mmRollingCounter - DataMileage.mmRoCBackup) / 1000;
				DataMileage.mmRoCBackup += Mileage * 1000;

				DataMileageRollingCounter += Mileage;
			}
		}
	}
}

/******************************************************************************
��������Data_ODO_Processing
��  ��: �ܼ�������ݴ���
��  ��: ��
����ֵ����
******************************************************************************/
void Data_ODO_Processing(void)
{
	uint16_t RollingCounter;
	uint16_t Inc;

	if (NVM_EEPROM_FAULT)
	{
		DataODOValid = 0;
	}
	else
	{
		RollingCounter = DATA_MILEAGE_ROLLING_COUNTER;

		if (DataODOValid == 0)
		{
			DataODOCalc.RoCBackup = RollingCounter;
			DataODOValid = 1;
		}

		if (RollingCounter - DataODOCalc.RoCBackup >= 100)
		{
			Inc = (RollingCounter - DataODOCalc.RoCBackup) / 100;
			DataODOCalc.RoCBackup += Inc * 100;

			NVM_ODO_VALUE += Inc;
			Data_Trip_Processing_ADD(Inc);
			Average_Vspeed_ADD(Inc);
			Avg_EVCons_Trip_ADD(Inc);
			//	App_CalFuelEconomy_KM_ADD(Inc);
			//	App_CalOnceFuelEconomy_KM_ADD(Inc);
			if (NVM_ODO_VALUE - DataODOCalc.LastSaved >= 10)
			{
				//	NVM_Data_Update(NVM_TRIPA_DATA);
				//	NVM_Data_Update(NVM_TRIPB_DATA);

				NVM_Data_Update(NVM_ODO_DATA);
				DataODOCalc.LastSaved = NVM_ODO_VALUE;
			}
		}
	}
	ODO_Disp = NVM_ODO_VALUE;
	DispTrip = DataTripCalc.MileageA100m;
}

/******************************************************************************
��������Data_Trip_Processing_ADD
��  ��: С��������ݴ���
��  ��: ��
����ֵ����
******************************************************************************/
void Data_Trip_Processing_ADD(INT16U KM_Data)
{
	DataTripCalc.MileageA100m += KM_Data;
	// DataTripCalc.MileageB100m += KM_Data;

	if (DataTripCalc.MileageA100m > 9999)
	{
		DataTripCalc.MileageA100m -= 10000;
		ResetTripAFlag = 1;
	}

	//	if (DataTripCalc.MileageB100m > 99999)
	//	{
	//	  DataTripCalc.MileageB100m -= 100000;
	// ResetTripBFlag = 1;
	//	}

	//	NVM_TripA = DataTripCalc.MileageA100m;
	//	NVM_TripB = DataTripCalc.MileageB100m;
}
/******************************************************************************
  ��������Data_Clear_Trip
  ��  ��: С���������
  ��  ��: ��
  ����ֵ����
 ******************************************************************************/
void Data_Clear_TripA(void)
{
	DataTripCalc.MileageA100m = 0;
	// NVM_TripA = 0;
}

/******************************************************************************
  ��������Data_Clear_ODO
  ��  ��: ����������
  ��  ��: ��
  ����ֵ����
 ******************************************************************************/
void Data_Clear_ODO(void)
{
	DataODOCalc.RoCBackup = 0;
	NVM_ODO_VALUE = 0;
	DataODOCalc.LastSaved = 0;
	DataMileageRollingCounter = 0;
	NVM_Data_Update(NVM_ODO_DATA);
}

void Data_Clear_Trip(void)
{
	if (SYS_OPR_STAT_IGN_ON)
	{
		if (DataVSpeedDisp == 0)
		{
			if (ButtonSts.DownSts == BUTTON_DOWN_LONG)
			{
				Data_Clear_TripA();
			}
		}
	}
}

void Factory_ClearOdoM(void)
{
	if (SYS_OPR_STAT_IGN_ON)
	{
		if ((DataVSpeedDisp >= 1400) && (DataConsPwr.Symbol == Positive) && (DataConsPwr.DispValue >= 1500) && (Clear_ODO_Flag < 1))
		{
			if (ButtonSts.DownSts == BUTTON_DOWN_LONG)
			{
				NVM_ODO_CLEARED = 0;
				Data_Clear_ODO();
				NVMSERVISE.Sig.Service_Reset = 0;
				Data_Service_Interval_Reset();
				Data_Clear_TripA();
				Clear_ODO_Flag = 1;
			}
		}
	}
}

void Geely_ClearOdo_Processing(void)
{
	if ((Clear_ODO_Flag < 1) && (NVM_ODO_CLEARED < 1) && (NVM_ODO_VALUE <= 44000))
	{
		if (!SYS_OPR_STAT_IGN_ON)
		{
			if (BUTTON_DOWN_IN_P == 0)
			{
				ClearODO.Step_En = 1;
			}
			else
			{
				ClearODO.Step_En = 0;
			}

			ClearODO.Push_Key_Timer = 0;
		}
		else
		{
			if (ClearODO.Step_En)
			{
				if (BUTTON_DOWN_IN_P == 0)
				{
					if (ClearODO.Push_Key_Timer < 300)
					{
						ClearODO.Push_Key_Timer++;
					}
					else
					{
						NVM_ODO_CLEARED = 1;
						ClearODO.Push_Key_Timer = 0;
						ClearODO.Step_En = 0;
						Data_Clear_ODO();
						Data_Service_Interval_Reset();
						Data_Clear_TripA();
						Clear_ODO_Flag = 1;
					}
				}
				else
				{
					ClearODO.Push_Key_Timer = 0;
					ClearODO.Step_En = 0;
				}
			}
			else
			{
				ClearODO.Push_Key_Timer = 0;
			}
		}
	}
}

void S513_Maintenance_Data_Set(INT32U SetedInterV) // 30000
{
	if (OldServiceMileVaule != SetedInterV * 10) // ��ǰ�����Զ���������ֵ�����ı�ʱ
	{
		NVM_SERVISE_SET = SetedInterV * 10; // �������ô洢����Ϊ��ǰ�Զ������õ�ֵ	������֮ǰ��5000����������Ϊ3000��
		//						      = 	    50000+	30000-50000
		//						      =     30985+50000-30000			        300-500
		NVM_USER_SETTINGS_SERVICE = NVM_USER_SETTINGS_SERVICE + NVM_SERVISE_SET - OldServiceMileVaule; // �������

		NVM_Data_Update(NVM_Servise_DATA);
		// ���ݵ�ǰ�Զ��屣������ֵ
		OldServiceMileVaule = NVM_SERVISE_SET;
	}
}

/******************************************************************************
��������Data_Service_Interval_Processing
��  ��: ʣ�ౣ����̴���
��  ��: ��
����ֵ����
******************************************************************************/
void Data_Service_Interval_Processing(void)
{
	uint32_t MileageDev;
	uint32_t Servicekm;

	if (SYS_OPR_STAT_IGN_ON)
	{
		// ��ǰodo>=�������
		if (NVM_ODO_VALUE >= NVM_USER_SETTINGS_SERVICE)
		{
			Servicekm = 0;
			MileageDev = 0;
		}
		else
		{
			// ��һ������Ϊ50000/10-980/10	   =4902
			//		     = 	        30000/10  - 980/10	  = 2902   ;
			MileageDev = NVM_USER_SETTINGS_SERVICE / 10 - NVM_ODO_VALUE / 10;
			Servicekm = MileageDev;
		}

		// ʣ�ౣ���м������= ʣ�ౣ����ֵ������ʾ
		DataServiceInterval = Servicekm * 10;

		if (MileageDev != 0)
		{
			if (Servicekm <= 500)
			{
				DataServiceDistanceWarning = 1;
			}
			else
			{
				DataServiceDistanceWarning = 0;
			}

			DataServiceWarning = 0;
		}
		else
		{
			DataServiceWarning = 1;
			DataServiceDistanceWarning = 0;
		}
	}
	else
	{
		DataServiceWarning = 0;
		DataServiceDistanceWarning = 0;
	}
}

/******************************************************************************
��������Data_Service_Interval_Reset
��  ��: ���ñ������
��  ��: ��
����ֵ����
******************************************************************************/
void Data_Service_Interval_Reset(void) // �����Ѿ����б���
{
	// ��ȡ�������
	NVM_USER_SETTINGS_SERVICE = NVM_ODO_VALUE + NVM_SERVISE_SET;
	NVM_Data_Update(NVM_Servise_DATA);

	// ʣ�ౣ�����Ϊ
	DataServiceInterval = NVM_SERVISE_SET;
	// ����������0
	DataServiceWarning = 0;
	DataServiceDistanceWarning = 0;
}

/******************************************************************************
��������Data_Driving_Time_Processing
��  ��: ��ʻʱ�����ݴ���
��  ��: ��
����ֵ����
******************************************************************************/
void Data_Driving_Time_Processing(void)
{
	uint8_t HourInc;
	uint16_t MinInc;
	uint16_t RollingCounter;

	if (SYS_OPR_STAT_IGN_ON)
	{
		if (DataDrivingTime.Start)
		{
			if ((DATA_VEHICLE_SPEED_DISPLAYING <= 20) && (DoorOpen.u8LF_St == 1))
			{
				DataDrivingTime.Start = 0;
			}
		}
		else
		{
			if ((DATA_VEHICLE_SPEED_VALID) && (DATA_VEHICLE_SPEED_DISPLAYING > 20))
			{
				DataDrivingTime.Start = 1;
			}
		}

		if ((DataDrivingTimeHour >= 99) && (DataDrivingTimeMin >= 59))
		{
			return;
		}
		if (DataDrivingTime.Start)
		{
			RollingCounter = RTC_ROLLING_COUNTER;

			DataDrivingTime.Timer += (RollingCounter - DataDrivingTime.RoCBackup);
			DataDrivingTime.RoCBackup = RollingCounter;

			if (DataDrivingTime.Timer >= 600)
			{
				MinInc = DataDrivingTime.Timer / 600;
				DataDrivingTime.Timer -= MinInc * 600;
				DataDrivingTimeMin += (uint8_t)MinInc;

				if (DataDrivingTimeMin >= 60)
				{
					HourInc = DataDrivingTimeMin / 60;
					DataDrivingTimeMin -= HourInc * 60;
					DataDrivingTimeHour += HourInc;

					
				}
			}
		}
		else
		{
			DataDrivingTime.RoCBackup = RTC_ROLLING_COUNTER;
		}
	}
}

/******************************************************************************
��������Data_IGN_Off_Timing_Service
��  �ܣ��ϵ�ʱ���ʱ����,���ڼ����ϵ�ʱ��,�ú�����IGN ON / OFF ״̬�¶���Ҫ����
		���Ե���
��  ������
����ֵ����
*******************************************************************************
ע  �⣺�÷���������ÿ100ms������һ��
******************************************************************************/
void Data_IGN_Off_Timing_Service(void)
{
	uint16_t SecInc;
	uint16_t RollingCounter;

	if (SYS_OPR_STAT_IGN_ON)
	{
		DataIGNOffTimer.IGNStatus = 5; // ��ֹ���ʱ��Դ��������ϵ��ʱ
	}
	else
	{
		if (DataIGNOffTimer.IGNStatus)
		{
			DataIGNOffTimer.IGNStatus--;
			if (DataIGNOffTimer.IGNStatus == 0)
			{
				DataIGNOffTimerSec = 0;
				DataIGNOffTimer.RoCBackup = RTC_ROLLING_COUNTER;
			}
		}
		else
		{
			RollingCounter = RTC_ROLLING_COUNTER;

			if (RollingCounter - DataIGNOffTimer.RoCBackup >= 10)
			{
				SecInc = (RollingCounter - DataIGNOffTimer.RoCBackup) / 10;
				DataIGNOffTimer.RoCBackup += SecInc * 10;

				if (DataIGNOffTimerSec <= (65535 - SecInc))
					DataIGNOffTimerSec += SecInc;
				else
					DataIGNOffTimerSec = 65535;
			}
		}
	}
}

/******************************************************************************
��������Data_Driving_Time_Reset
��  ��: ��ʻʱ������
��  ��: ��
����ֵ����
******************************************************************************/
void Data_Driving_Time_Reset(void)
{
	DataDrivingTimeHour = 0;
	DataDrivingTimeMin = 0;
	DataDrivingTime.RoCBackup = RTC_ROLLING_COUNTER;
	DataDrivingTime.Timer = 0;
}

void Data_Driving_Time_OFF_Reset(void)
{
	if (DataIGNOffTimerSec > 7200)
	{
		Data_Driving_Time_Reset();
	}
}
/******************************************************************************
��������Data_AC_Temp_Processing_Service
��  �ܣ������¶����ݴ�������
��  ������
����ֵ����
*******************************************************************************
ע  �⣺�ú�������ÿ20ms������һ��
******************************************************************************/
void Data_AC_Temp_Init(void)
{
	AC_Temperature.Value = 0;
	AC_Temperature.Valid = 0;
	AC_Temperature.Symbol = Positive;
	AC_Temperature.Warn = 0;
	AC_Temperature.Blink = 0;
	AC_Temperature.Timer = 0;
}

void Data_AC_Temp_Processing_Service(void)
{
	INT16U AC_Temp;

	AC_Temp = Get_CAN_CH0_ID_18FF2319_Sig_AC_AmbientTemperature() * 5;

	if ((AC_Config.F110 == 1) && (SYS_OPR_STAT_IGN_ON))
	{
		if ((CAN_MSG_Status(CAN_CH0, CAN_CH0_ID_AC_18FF2319_Msg_Count) == CAN_MSG_LOST) || (CanReceive.Can_18FF2319 != 1) ||
			(Get_CAN_CH0_ID_18FF2319_Sig_AC_AmbientTemperatureInvalid() == 1) || (Get_CAN_CH0_ID_18FF2319_Sig_AC_AmbientTemperature() > 0xFA))
		{
			CanReceive.Can_18FF2319 = 0;
			AC_Temperature.Valid = 0;
			AC_Temperature.Value = 0;
			AC_Temperature.Symbol = Positive;
			AC_Temperature.Warn = 0;
			AC_Temperature.Blink = 0;
		}
		else
		{
			AC_Temperature.Valid = 1;
			if (AC_Temp >= 400)
			{
				AC_Temp -= 400;
				AC_Temperature.Symbol = Positive;
			}
			else
			{
				AC_Temp = 400 - AC_Temp;
				AC_Temperature.Symbol = Negative;
			}
			AC_Temperature.Value = AC_Temp / 10;

			if (AC_Temperature.Value > 80)
			{
				AC_Temperature.Value = 80;
			}

			if (AC_Temperature.Symbol)
			{
				AC_Temperature.Warn = 1;
			}
			else
			{
				if (AC_Temperature.Value < 4)
				{
					AC_Temperature.Warn = 1;
				}
				if (AC_Temperature.Value >= 5)
				{
					AC_Temperature.Warn = 0;
				}
			}
		}
		if (AC_Temperature.Warn)
		{
			if (AC_Temperature.Timer <= 600)
			{
				AC_Temperature.Timer++;
				AC_Temperature.Blink = FLASH_SYNC_1Hz;
			}
			else
			{
				AC_Temperature.Blink = 1;
			}
		}
		else
		{
			AC_Temperature.Timer = 0;
			AC_Temperature.Blink = 0;
		}
	}
	else
	{
		AC_Temperature.Value = 0;
		AC_Temperature.Valid = 0;
		AC_Temperature.Symbol = Positive;
		AC_Temperature.Warn = 0;
		AC_Temperature.Blink = 0;
		AC_Temperature.Timer = 0;
	}
}

/******************************************************************************
��������Data_AvgSpeed_Processing_Service
��  �ܣ������¶����ݴ�������
��  ������
����ֵ����
*******************************************************************************
ע  �⣺�ú�������ÿ20ms������һ��
******************************************************************************/
void Average_Vspeed_Trip_Clear(void)
{
	DataAvgSpd.First_Distance = 0;
	DataAvgSpd.FreshTime = 0;
	DataAvgSpd.Distance = 0;
	DataAvgSpd.Time = 0;
	DataAvgSpd.Value = 0;
}

void Average_Vspeed_ADD(INT16U Inc)
{
	if ((Get_CAN_CH0_ID_18FAB027_Sig_PMS_PTReadyInd() == 1) && (CanReceive.Can_18FAB027))
	{
		if (DataAvgSpd.First_Distance < 5)
		{
			DataAvgSpd.First_Distance += Inc;
		}

		DataAvgSpd.Distance += Inc;
	}
}

void Data_AvgSpeed_Processing_Service(void)
{
	if (SYS_OPR_STAT_IGN_ON)
	{
		if ((Get_CAN_CH0_ID_18FAB027_Sig_PMS_PTReadyInd() == 1) && (DATA_VEHICLE_SPEED_VALID))
		{
			DataAvgSpd.Time++;
		}

		if (DataAvgSpd.First_Distance >= 5)
		{
			DataAvgSpd.Display_Valid = 1;
			if ((DataAvgSpd.Distance >= 100000) || (DataAvgSpd.Time >= 4000000))
			{
				if (DataAvgSpd.Distance % 2 == 1)
				{
					DataAvgSpd.Distance = (DataAvgSpd.Distance / 2) + 1;
				}
				else
				{
					DataAvgSpd.Distance = DataAvgSpd.Distance / 2;
				}

				if (DataAvgSpd.Time % 2 == 1)
				{
					DataAvgSpd.Time = (DataAvgSpd.Time / 2) + 1;
				}
				else
				{
					DataAvgSpd.Time = DataAvgSpd.Time / 2;
				}
			}
			if (DataAvgSpd.Time > 0)
			{
				DataAvgSpd.Value = ((DataAvgSpd.Distance * 36000) / DataAvgSpd.Time);
				DataAvgSpd.Value += 5;
				DataAvgSpd.Value /= 10;
				if (DataAvgSpd.Value > 140)
				{
					DataAvgSpd.Value = 140;
				}
			}
			else
			{
				DataAvgSpd.Value = 0;
			}
		}
		else
		{
			DataAvgSpd.Display_Valid = 0;
			DataAvgSpd.Value = 0;
		}
		// ��ʾ����
		if ((Get_CAN_CH0_ID_18FAB027_Sig_PMS_PTReadyInd() == 1) && (DATA_VEHICLE_SPEED_VALID == 1))
		{
			if (DataAvgSpd.Display_Valid == 1)
			{
				DataAvgSpd.FreshTime++;
				if (DataAvgSpd.FreshTime >= 600)
				{
					DataAvgSpd.Display_Value = DataAvgSpd.Value;
					DataAvgSpd.FreshTime = 0;
				}
			}
			else
			{
				DataAvgSpd.FreshTime = 600;
			}
		}
		else
		{
			DataAvgSpd.FreshTime = 600;
		}
	}
	else
	{
		DataAvgSpd.FreshTime = 0;
	}
}

/******************************************************************************
Data_Avg_EVCons_Service
��  �ܣ�ƽ��������ݴ�������
��  ������
����ֵ����
******************************************************************************/
void Data_Avg_EVCons_Trip_Clear(void)
{
	AvgEVCons.First_Distance = 0;
	AvgEVCons.Valid = 0;
	AvgEVCons.Symbol = Positive;
	AvgEVCons.Value = 0;
	AvgEVCons.MsgExpEn = 1;
	AvgEVCons.MsgCnt = 0;
	AvgEVCons.ResetAveragePowerConsumption = 1;
	AvgEVCons.ResetAveragePowerConsumption_Cnt = 3;
	Can_Msg_Tx_Overwrite(&CAN_CH0_CanMsgTxOp, IC_18FF4117_Msg_Count, 3, 20000UL);
}

void IC_ResetAveragePowerConsumption_Service(void)
{
	if (AvgEVCons.ResetAveragePowerConsumption_Cnt != 0)
	{
		AvgEVCons.ResetAveragePowerConsumption_Cnt--;
	}
	else
	{
		AvgEVCons.ResetAveragePowerConsumption = 0U;
	}
	
}

void IC_OTA_InfoShowStatus_Service(void)
{
	if (IC_OTA.IC_OTA_InfoShowStatus_Cnt != 0)
	{
		IC_OTA.IC_OTA_InfoShowStatus_Cnt--;
	}
	else
	{
		IC_OTA.IC_OTA_InfoShowStatus = 0U;
	}
}

void IC_OTA_DownloadSelected_Service(void)
{
	if (IC_OTA.IC_OTA_DownloadSelected_Cnt != 0)
	{
		IC_OTA.IC_OTA_DownloadSelected_Cnt--;
	}
	else
	{
		IC_OTA.IC_OTA_DownloadSelected = 0U;
	}
}

void IC_OTA_UpdateSelected_Service(void)
{
	if (IC_OTA.IC_OTA_UpdateSelected_Cnt != 0)
	{
		IC_OTA.IC_OTA_UpdateSelected_Cnt--;
	}
	else
	{
		IC_OTA.IC_OTA_UpdateSelected = 0U;
	}
}

void IC_OTA_UpdateResultConfirm_Service(void)
{
	if (IC_OTA.IC_OTA_UpdateResultConfirm_Cnt != 0)
	{
		IC_OTA.IC_OTA_UpdateResultConfirm_Cnt--;
	}
	else
	{
		IC_OTA.IC_OTA_UpdateResultConfirm = 0U;
	}
}

void IC_OTA_DeclimerSelected_Service(void)
{
	if (IC_OTA.IC_OTA_DeclimerSelected_Cnt != 0)
	{
		IC_OTA.IC_OTA_DeclimerSelected_Cnt--;
	}
	else
	{
		IC_OTA.IC_OTA_DeclimerSelected = 0U;
	}
}

void Avg_EVCons_Trip_ADD(INT16U Inc)
{
	if (AvgEVCons.First_Distance < 5)
	{
		AvgEVCons.First_Distance += Inc;
	}
}
void Data_Avg_EVCons_Service(void)
{
	uint32_t AvgEV_Value = 0;
	AvgEV_Value = Get_CAN_CH0_ID_18FAB227_Sig_PMS_AvgEVConsume();

	if (SYS_OPR_STAT_IGN_ON)
	{
		if ((CAN_MSG_Status(CAN_CH0, CAN_CH0_ID_PMS_18FAB227_Msg_Count) == CAN_MSG_LOST) || (CanReceive.Can_18FAB227 != 1) || (AvgEV_Value == 0xFFFF))
		{
			CanReceive.Can_18FAB227 = 0;
			AvgEVCons.Valid = 0;
			AvgEVCons.Symbol = Positive;
			AvgEVCons.Value = 0;
		}
		else
		{
			if (AvgEVCons.First_Distance >= 5)
			{
				if (AvgEV_Value < 0xFB00)
				{
					AvgEVCons.Valid = 1;
					AvgEV_Value *= 5;
					if (AvgEV_Value >= 5000)
					{
						AvgEV_Value -= 5000;
						if (AvgEV_Value > 1500)
						{
							AvgEV_Value = 1500;
						}
						AvgEVCons.Symbol = Positive;
						AvgEVCons.Value = (INT16U)AvgEV_Value; // 10p
					}
					else
					{
						AvgEV_Value = 5000 - AvgEV_Value;
						if (AvgEV_Value > 1000)
						{
							AvgEV_Value = 1000;
						}
						AvgEVCons.Symbol = Negative;
						AvgEVCons.Value = (INT16U)AvgEV_Value;
					}
					AvgEVCons.Valid_BackUp = AvgEVCons.Valid;
					AvgEVCons.Value_BackUp = AvgEVCons.Value;
					AvgEVCons.Symbol_BackUp = AvgEVCons.Symbol;
				}
				else
				{
					AvgEVCons.Valid = AvgEVCons.Valid_BackUp;
					AvgEVCons.Value = AvgEVCons.Value_BackUp;
					AvgEVCons.Symbol = AvgEVCons.Symbol_BackUp;
				}
			}
			else
			{
				AvgEVCons.Valid = 0;
			}
		}
	}
	else
	{
		AvgEVCons.Valid = 0;
		AvgEVCons.Symbol = Positive;
		AvgEVCons.Value = 0;
	}
}

/******************************************************************************
Data_EV_DTE_Service
��  �ܣ���������������ݴ�������
��  ������
����ֵ����
******************************************************************************/
void Data_EV_DTE_Service(void)
{
	uint16_t EV_DTE = 0;
	EV_DTE = Get_CAN_CH0_ID_18FAB227_Sig_PMS_EVDTE_odometer();

	if (SYS_OPR_STAT_IGN_ON)
	{
		if ((CAN_MSG_Status(CAN_CH0, CAN_CH0_ID_PMS_18FAB227_Msg_Count) == CAN_MSG_LOST) || (CanReceive.Can_18FAB227 != 1) || (EV_DTE == 0xFFFF))
		{
			CanReceive.Can_18FAB227 = 0;
			DataEVDTE.Valid = 0;
			DataEVDTE.u16_Value = 0;
		}
		else
		{
			if (EV_DTE < 0xFB00)
			{
				DataEVDTE.Valid = 1;
				EV_DTE >>= 3;
				DataEVDTE.u16_Value = EV_DTE;
				if (DataEVDTE.u16_Value > 9999)
				{
					DataEVDTE.u16_Value = 9999;
				}

				DataEVDTE.u16_Value_BackUp = DataEVDTE.u16_Value;
				DataEVDTE.Valid_BackUp = DataEVDTE.Valid;
			}
			else
			{
				DataEVDTE.u16_Value = DataEVDTE.u16_Value_BackUp;
				DataEVDTE.Valid = DataEVDTE.Valid_BackUp;
			}
		}
	}
	else
	{
		DataEVDTE.Valid = 0;
		DataEVDTE.u16_Value = 0;
	}
}

/******************************************************************************
Data_ResiduePwr_Service
��  �ܣ�ʣ�๦�����ݴ�������
��  ������
����ֵ����
******************************************************************************/
void Data_ResiduePwr_Service(void)
{
	uint32_t RemainPwr = 0;
	RemainPwr = Get_CAN_CH0_ID_18FAB327_Sig_PMS_PTResiduePwrInd();

	if (SYS_OPR_STAT_IGN_ON)
	{
		if ((CAN_MSG_Status(CAN_CH0, CAN_CH0_ID_PMS_18FAB327_Msg_Count) == CAN_MSG_LOST) || (CanReceive.Can_18FAB327 != 1) || (RemainPwr == 0xFFFF))
		{
			CanReceive.Can_18FAB327 = 0;
			DataRemainPwr.Valid = 0;
			DataRemainPwr.u16_Value = 0;
		}
		else
		{
			DataRemainPwr.Valid = 1;
			DataRemainPwr.u16_Value = RemainPwr;
			if (DataRemainPwr.u16_Value > 64255)
			{
				DataRemainPwr.u16_Value = 64255;
			}
		}
	}
	else
	{
		DataRemainPwr.Valid = 0;
		DataRemainPwr.u16_Value = 0;
	}
}

/******************************************************************************
Data_Instantaneous_Fuel_Service
��  �ܣ�˲ʱ�ͺ����ݴ�������
��  ������
����ֵ����
******************************************************************************/
void Data_Instantaneous_Fuel_Service(void)
{
	/*        uint32_t InsFuel_Value = 0;

	InsFuel_Value = EngInsFule_H;
	InsFuel_Value = (InsFuel_Value<<8)|EngInsFule_L;

	if(SYS_OPR_STAT_IGN_ON)
	{
		if((CANMsg_18FEF200_Status.BIT.Function_Lost == CAN_MSG_LOST)||(CANMsg_18FEF200_Status.BIT. Receive != 1))
		{
			InsFuel_Eng.Valid = 0;
			InsFuel_Eng.Value = 0;
		}
		else
		{
				 if(InsFuel_Value > 0xFB00)
				 {
				InsFuel_Eng.Valid = 0;
				InsFuel_Eng.Value = 0;
				 }
				 else
				 {
					 if(InsFuel_Value == 0)
					 {
					InsFuel_Eng.Valid = 0;
					InsFuel_Eng.Value = 0;
					 }
					 else
					 {
						InsFuel_Eng.Valid = 1;
						InsFuel_Eng.Value  = (uint32_t)(512000 /InsFuel_Value);
					if(InsFuel_Eng.Value > 250)
					{
						InsFuel_Eng.Value = 250;
					}
					 }

				 }
		}
	}
	else
	{
	}
	*/
}

/******************************************************************************
Data_Avg_Fuel_Service
��  �ܣ�ƽ���ͺ����ݴ�������
��  ������
����ֵ����
******************************************************************************/
void Data_Avg_Fuel_Service(void)
{
	/*    	uint32_t AvgFuel_Value = 0;
	AvgFuel_Value = EngAvgFule_H;
	AvgFuel_Value = (AvgFuel_Value<<8)|EngAvgFule_L;

	if(SYS_OPR_STAT_IGN_ON)
	{
		if((CANMsg_18FEF200_Status.BIT.Function_Lost )||(CANMsg_18FEF200_Status.BIT. Receive != 1)||(AvgFuel_Value > 0xFB00))
		{
			AvgFuel_Eng.Valid = 0;
			AvgFuel_Eng.TimeCnt = 300 ;
		}
		else
		{
			if(AvgFuel_Value == 0 )
			{
				AvgFuel_Eng.Value = AvgFuel_Eng.Backup_Value ;
			}
			else
			{
				AvgFuel_Eng.Value  = (uint32_t)(512000 /AvgFuel_Value);
				if(AvgFuel_Eng.Value >=250)
				{
					AvgFuel_Eng.Value = 250 ;
				}
				AvgFuel_Eng.Flg = 1;
			}

			if(AvgFuel_Eng.Flg == 1)
			{
				AvgFuel_Eng.Valid = 1 ;
			}
			else
			{
				AvgFuel_Eng.Valid = 0 ;
			}
		}

		if(AvgFuel_Eng.Valid)
		{
			if(AvgFuel_Eng.TimeCnt < 300)
			{
				AvgFuel_Eng.TimeCnt++;
			}
			else
			{
				AvgFuel_Eng.Display_Value =  AvgFuel_Eng.Value ;
				AvgFuel_Eng.Backup_Value = AvgFuel_Eng.Display_Value ;
				AvgFuel_Eng.TimeCnt = 0;
			}
		}
		else
		{
			AvgFuel_Eng.TimeCnt = 300 ;
		}
	}
	else
	{
		AvgFuel_Eng.TimeCnt = 300 ;
	}
		*/
}

/******************************************************************************
Data_WokeVolt_Processing_Service
��  �ܣ�������ѹ���ݴ�������
��  ������
����ֵ����
******************************************************************************/
void Data_BattVolt_Processing_Service(void)
{
	uint32_t BatPower = 0;

	BatPower = Get_CAN_CH0_ID_18FA40F4_Sig_BMS_BattVol();

	if ((CAN_MSG_Status(CAN_CH0, CAN_CH0_ID_EMS_18FA40F4_Msg_Count) == CAN_MSG_LOST) || (CanReceive.Can_18FA40F4 != 1) || (BatPower == 0XFFFF))
	{
		CanReceive.Can_18FA40F4 = 0;
		BattVolt.Valid = 0;
		// BattVolt.Value = 0;
	}
	else
	{
		if (BatPower < 0xFB00)
		{
			BattVolt.Valid = 1;
			BattVolt.Value = (BatPower * 5);
			if (BattVolt.Value > 99900)
			{
				BattVolt.Value = 99900; // 100p
			}
			BattVolt.Display_Value = BattVolt.Value / 100;

			BattVolt.Display_Value_BackUp = BattVolt.Display_Value;
			BattVolt.Valid_BackUp = BattVolt.Valid;
		}
		else
		{
			BattVolt.Display_Value = BattVolt.Display_Value_BackUp;
			BattVolt.Valid = BattVolt.Valid_BackUp;
		}
	}
}

/******************************************************************************
Data_BattCurr_Processing_Service
��  �ܣ������������ݴ�������
��  ������
����ֵ����
******************************************************************************/
void Data_BattCurr_Processing_Service(void)
{
	uint32_t Batt_Curr = 0;

	Batt_Curr = Get_CAN_CH0_ID_18FA40F4_Sig_BMS_BattCurr();

	// if(SYS_OPR_STAT_IGN_ON)
	//{
	if ((CAN_MSG_Status(CAN_CH0, CAN_CH0_ID_EMS_18FA40F4_Msg_Count) == CAN_MSG_LOST) || (CanReceive.Can_18FA40F4 != 1) || Batt_Curr == 0XFFFF)
	{
		CanReceive.Can_18FA40F4 = 0;
		BattCurr.Valid = 0;
		// BattCurr.Value = 0;
	}
	else
	{

		if (Batt_Curr < 0xFB00)
		{
			BattCurr.Valid = 1;
			Batt_Curr = (Batt_Curr * 5);
			if (Batt_Curr >= 160000)
			{
				Batt_Curr -= 160000;
				BattCurr.Symbol = Positive;
			}
			else
			{
				Batt_Curr = 160000 - Batt_Curr;
				BattCurr.Symbol = Negative;
			}
			BattCurr.Value = Batt_Curr;

			if (BattCurr.Value > 99900)
			{
				BattCurr.Value = 99900; // 100P
			}
			BattCurr.Display_Value = BattCurr.Value / 100;

			BattCurr.Display_Value_BackUp = BattCurr.Display_Value;
			BattCurr.Symbol_BackUp = BattCurr.Symbol;
			BattCurr.Valid_BackUp = BattCurr.Valid;
		}
		else
		{
			BattCurr.Display_Value = BattCurr.Display_Value_BackUp;
			BattCurr.Symbol = BattCurr.Symbol_BackUp;
			BattCurr.Valid = BattCurr.Valid_BackUp;
		}
	}
	//	}
}

/******************************************************************************
Data_BattPower_Processing_Service
��  �ܣ����ص�ѹ���ݴ�������
��  ������
����ֵ����
******************************************************************************/
void Data_BattPower_Processing_Service(void)
{
	uint32_t BatPower = 0;

	BatPower = Get_CAN_CH0_ID_18FF629F_Sig_TBOX_BatteryVoltage();

	if (SYS_OPR_STAT_IGN_ON)
	{
		if (Val_EOL_F110_TBOX() == 1)
		{
			if ((CAN_MSG_Status(CAN_CH0, CAN_CH0_ID_TBOX_18FF629F_Msg_Count) == CAN_MSG_LOST) || (CanReceive.Can_18FF629F != 1))
			{
				CanReceive.Can_18FF629F = 0;
				//BattPower_Volt.Valid = 0;
				//BattPower_Volt.Value = 0;
				//BattPower_Volt.Display_Value = 0;
			}
			else
			{
				BattPower_Volt.Valid = 1;			
				BattPower_Volt.Value = BatPower ; //10P
				if (BattPower_Volt.Value > 360) 
				{
					BattPower_Volt.Value = 360;
				}

				BattPower_Volt.Display_Value = (INT16U)BattPower_Volt.Value;
			}
		}  
		else 
		{
			if(ADC_Read_Signal_Valid(0))
			{
				if((BattPower_Volt.TimeCnt++) >= 150)
				{
					if(AnalogKL30Voltage <=36000)
					{
						BattPower_Volt.Display_Value = (INT16U)(AnalogKL30Voltage/100);	
					}
					else
					{
						BattPower_Volt.Display_Value = 360;	
					}
					BattPower_Volt.TimeCnt = 0;
				}
				BattPower_Volt.Valid = 1;
			}
			else
			{
			        BattPower_Volt.Valid = 0;
					BattPower_Volt.Value = 0;
			        BattPower_Volt.Display_Value = 0;
			        BattPower_Volt.TimeCnt = 0;
			        
			}
		}	
	}
	else
	{
		BattPower_Volt.Valid = 0;
		BattPower_Volt.Value = 0;
		BattPower_Volt.Display_Value = 0 ;
		BattPower_Volt.TimeCnt = 0;
	}
}

/******************************************************************************
Data_Batt_MaxCellVolt_Processing_Service
��  �ܣ��������ߵ�ѹ���ݴ�������
��  ������
����ֵ����
******************************************************************************/
void Data_Batt_MaxCellVolt_Processing_Service(void)
{
	uint32_t CellVolt = 0;

	CellVolt = Get_CAN_CH0_ID_18FA4AF4_Sig_BMS_MaxCellVolt();

	if (SYS_OPR_STAT_IGN_ON)
	{
		if ((CAN_MSG_Status(CAN_CH0, CAN_CH0_ID_BMS_18FA4AF4_Msg_Count) == CAN_MSG_LOST) || (CanReceive.Can_18FA4AF4 != 1) || (CellVolt == 0xFFFF))
		{
			CanReceive.Can_18FA4AF4 = 0;
			Batt_MaxCellVolt.Valid = 0;
			Batt_MaxCellVolt.Value = 0;
			Batt_MaxCellVolt.Display_Value = 0;
		}
		else
		{
			Batt_MaxCellVolt.Valid = 1;
			Batt_MaxCellVolt.Value = CellVolt; // 1000P
			if (Batt_MaxCellVolt.Value > 5000)
			{
				Batt_MaxCellVolt.Value = 5000;
			}

			Batt_MaxCellVolt.Display_Value = (INT16U)(Batt_MaxCellVolt.Value / 1000); // 1000P
		}
	}
	else
	{
		Batt_MaxCellVolt.Valid = 0;
		Batt_MaxCellVolt.Value = 0;
		Batt_MaxCellVolt.Display_Value = 0;
	}
}

/******************************************************************************
Data_Batt_MinCellVolt_Processing_Service
��  �ܣ��������ߵ�ѹ���ݴ�������
��  ������
����ֵ����
******************************************************************************/
void Data_Batt_MinCellVolt_Processing_Service(void)
{
	uint32_t CellVolt = 0;

	CellVolt = Get_CAN_CH0_ID_18FA4AF4_Sig_BMS_MinCellVolt();

	if (SYS_OPR_STAT_IGN_ON)
	{
		if ((CAN_MSG_Status(CAN_CH0, CAN_CH0_ID_BMS_18FA4AF4_Msg_Count) == CAN_MSG_LOST) || (CanReceive.Can_18FA4AF4 != 1) || (CellVolt == 0xFFFF))
		{
			CanReceive.Can_18FA4AF4 = 0;
			Batt_MinCellVolt.Valid = 0;
			Batt_MinCellVolt.Value = 0;
			Batt_MinCellVolt.Display_Value = 0;
		}
		else
		{
			Batt_MinCellVolt.Valid = 1;
			Batt_MinCellVolt.Value = CellVolt; // 1000P
			if (Batt_MinCellVolt.Value > 5000)
			{
				Batt_MinCellVolt.Value = 5000;
			}

			Batt_MinCellVolt.Display_Value = (INT16U)(Batt_MinCellVolt.Value / 1000); // 1000P
		}
	}
	else
	{
		Batt_MinCellVolt.Valid = 0;
		Batt_MinCellVolt.Value = 0;
		Batt_MinCellVolt.Display_Value = 0;
	}
}

/******************************************************************************
Data_Batt_MaxTemp_Processing_Service
��  �ܣ����������¶����ݴ�������
��  ������
����ֵ����
******************************************************************************/
void Data_Batt_MaxTemp_Processing_Service(void)
{
	uint32_t MaxTemp = 0;

	MaxTemp = Get_CAN_CH0_ID_18FA48F4_Sig_BMS_BattMaxTemp1();

	if (SYS_OPR_STAT_IGN_ON)
	{
		if ((CAN_MSG_Status(CAN_CH0, CAN_CH0_ID_BMS_18FA48F4_Msg_Count) == CAN_MSG_LOST) || (CanReceive.Can_18FA48F4 != 1) || (MaxTemp == 0xFF))
		{
			CanReceive.Can_18FA48F4 = 0;
			Batt_MaxTemp.Valid = 0;
			Batt_MaxTemp.Value = 0;
			Batt_MaxTemp.Display_Value = 0;
			Batt_MaxTemp.Symbol = Positive;
		}
		else
		{
			Batt_MaxTemp.Valid = 1;
			if (MaxTemp >= 40)
			{
				MaxTemp -= 40;
				Batt_MaxTemp.Symbol = Positive;
			}
			else
			{
				MaxTemp = 40 - MaxTemp;
				Batt_MaxTemp.Symbol = Negative;
			}
			Batt_MaxTemp.Value = MaxTemp;
			if (Batt_MaxTemp.Value > 210)
			{
				Batt_MaxTemp.Value = 210;
			}

			Batt_MaxTemp.Display_Value = (INT16U)Batt_MaxTemp.Value;
		}
	}
	else
	{
		Batt_MaxTemp.Valid = 0;
		Batt_MaxTemp.Value = 0;
		Batt_MaxTemp.Display_Value = 0;
	}
}

/******************************************************************************
Data_Batt_MinTemp_Processing_Service
��  �ܣ����������¶����ݴ�������
��  ������
����ֵ����
******************************************************************************/
void Data_Batt_MinTemp_Processing_Service(void)
{
	uint32_t MinTemp = 0;

	MinTemp = Get_CAN_CH0_ID_18FA48F4_Sig_BMS_BattMinTemp1();

	if (SYS_OPR_STAT_IGN_ON)
	{
		if ((CAN_MSG_Status(CAN_CH0, CAN_CH0_ID_BMS_18FA48F4_Msg_Count) == CAN_MSG_LOST) || (CanReceive.Can_18FA48F4 != 1) || (MinTemp == 0xFF))
		{
			CanReceive.Can_18FA48F4 = 0;
			Batt_MinTemp.Valid = 0;
			Batt_MinTemp.Value = 0;
			Batt_MinTemp.Display_Value = 0;
			Batt_MinTemp.Symbol = Positive;
		}
		else
		{
			Batt_MinTemp.Valid = 1;
			if (MinTemp >= 40)
			{
				MinTemp -= 40;
				Batt_MinTemp.Symbol = Positive;
			}
			else
			{
				MinTemp = 40 - MinTemp;
				Batt_MinTemp.Symbol = Negative;
			}
			Batt_MinTemp.Value = MinTemp; // 1000P
			if (Batt_MinTemp.Value > 210)
			{
				Batt_MinTemp.Value = 210;
			}

			Batt_MinTemp.Display_Value = (INT16U)Batt_MinTemp.Value; // 1000P
		}
	}
	else
	{
		Batt_MinTemp.Valid = 0;
		Batt_MinTemp.Value = 0;
		Batt_MinTemp.Display_Value = 0;
	}
}

/******************************************************************************
Data_EnergyRecovery_Processing_Service
��  �ܣ��������յȼ����ݴ�������
��  ������
����ֵ����
******************************************************************************/
void Data_EnergyRecovery_Processing_Service(void)
{
	if (SYS_OPR_STAT_IGN_ON)
	{
		if ((CAN_MSG_Status(CAN_CH0, CAN_CH0_ID_PMS_CFAB127_Msg_Count) == CAN_MSG_LOST) || (CanReceive.Can_0CFAB127 != 1))
		{
			CanReceive.Can_0CFAB127 = 0;
			EnergyRecovery = Energy_LeveMax;
		}
		else
		{
			if (Get_CAN_CH0_ID_0CFAB127_Sig_PMS_ePTRegencyLevInd() == 1)
			{
				EnergyRecovery = Energy_Leve1;
			}
			else if (Get_CAN_CH0_ID_0CFAB127_Sig_PMS_ePTRegencyLevInd() == 2)
			{
				EnergyRecovery = Energy_Leve2;
			}
			else if (Get_CAN_CH0_ID_0CFAB127_Sig_PMS_ePTRegencyLevInd() == 3)
			{
				EnergyRecovery = Energy_Leve3;
			}
			else
			{
				EnergyRecovery = Energy_LeveMax;
			}
		}
	}
	else
	{
		EnergyRecovery = Energy_LeveMax;
	}
}

/******************************************************************************
Data_ErrCode_Processing_Service
��  �ܣ������������ѯ���ݴ�������
��  ������
����ֵ����
******************************************************************************/
void Data_ErrCode_Processing_Service(void)
{
	uint16_t ErrCode;

	ErrCode = Get_CAN_CH0_ID_18FAA027_Sig_PMS_ErrCode();

	if (SYS_OPR_STAT_IGN_ON)
	{
		if ((CAN_MSG_Status(CAN_CH0, CAN_CH0_ID_PMS_18FAA027_Msg_Count) == CAN_MSG_LOST) || (CanReceive.Can_18FAA027 != 1))
		{
			CanReceive.Can_18FAA027 = 0;
			DataErrCode.Vaild = 0;
			DataErrCode.Value = 0;
		}
		else
		{
			DataErrCode.Vaild = 1;
			DataErrCode.Value = ErrCode;
		}
	}
	else
	{
		DataErrCode.Vaild = 0;
		DataErrCode.Value = 0;
	}
}

/******************************************************************************
Data_Cruise_Processing_Service
��  �ܣ�CC����Ѳ���������ݴ�������
��  ������
����ֵ����
******************************************************************************/
void Data_Cruise_Processing_Service(void)
{
	uint16_t ControlSetSpeed;
	ControlSetSpeed = Get_CAN_CH0_ID_0CFAA627_Sig_PMS_ControlSetSpeed();

	if (Val_EOL_F101_Cruise() == 2)
	{
		if ((Val_EOL_F101_CruiseSpeed() == 1)||(Val_EOL_F101_CruiseSpeed() == 2))
		{
			if (SYS_OPR_STAT_IGN_ON)
			{
				if ((CAN_MSG_Status(CAN_CH0, CAN_CH0_ID_PMS_0CFAA627_Msg_Count) == CAN_MSG_LOST) || (CanReceive.Can_0CFAA627 != 1) || (ControlSetSpeed == 0xFF))
				{
					CanReceive.Can_0CFAA627 = 0;
					DataCruise.u16Value = 0;
					DataCruise.u8DisFlg = 0;
					DataCruise.u8Valid = 0;
					DataCruise.u8LED_W_Sts = 0;
					DataCruise.u8LED_G_Sts = 0;
				}
				else
				{
					if (Get_CAN_CH0_ID_0CFAA627_Sig_PMS_CruiseControlSts() == 1)
					{
						DataCruise.u8DisFlg = 1;
						DataCruise.u8Valid = 0;
						DataCruise.u8LED_W_Sts = 1;
						DataCruise.u8LED_G_Sts = 0;
					}
					else if (Get_CAN_CH0_ID_0CFAA627_Sig_PMS_CruiseControlSts() == 2)
					{
						DataCruise.u8DisFlg = 1;
						DataCruise.u8Valid = 1;
						DataCruise.u8LED_W_Sts = 0;
						DataCruise.u8LED_G_Sts = 1;
						DataCruise.u16Value = ControlSetSpeed;
						if (DataCruise.u16Value > 140)
						{
							DataCruise.u16Value = 140;
						}
					}
					else if (Get_CAN_CH0_ID_0CFAA627_Sig_PMS_CruiseControlSts() == 3)
					{
						DataCruise.u8DisFlg = 1;
						DataCruise.u8Valid = 0;
						DataCruise.u8LED_W_Sts = 1;
						DataCruise.u8LED_G_Sts = 0;
					}
					else
					{
						DataCruise.u8DisFlg = 1;
						DataCruise.u8Valid = 0;
						DataCruise.u8LED_W_Sts = 0;
						DataCruise.u8LED_G_Sts = 0;
					}
				}
			}
			else
			{
				DataCruise.u16Value = 0;
				DataCruise.u8DisFlg = 0;
				DataCruise.u8Valid = 0;
				DataCruise.u8LED_W_Sts = 0;
				DataCruise.u8LED_G_Sts = 0;
			}
		}
	}
	else
	{
		DataCruise.u16Value = 0;
		DataCruise.u8DisFlg = 0;
		DataCruise.u8Valid = 0;
		DataCruise.u8LED_W_Sts = 0;
		DataCruise.u8LED_G_Sts = 0;
	}
}

/******************************************************************************
��������Data_Gear_Processing_Service
��  ��: ��λ��ʾ���ݴ���
��  ��: ��
����ֵ����
******************************************************************************/
void Data_Gear_Processing_Service(void)
{
	if (SYS_OPR_STAT_IGN_ON)
	{
		if ((CAN_MSG_Status(CAN_CH0, CAN_CH0_ID_PMS_18FAB027_Msg_Count) == CAN_MSG_LOST) || (CanReceive.Can_18FAB027 != 1))
		{
			CanReceive.Can_18FAB027 = 0;
			GearMode = GEAR_Max;
		}
		else
		{
			if (Get_CAN_CH0_ID_18FAB027_Sig_PMS_GearPositionInd() == 0XFC)
			{
				GearMode = GEAR_D;
			}
			else if (Get_CAN_CH0_ID_18FAB027_Sig_PMS_GearPositionInd() == 0XDF)
			{
				GearMode = GEAR_R;
			}
			else if (Get_CAN_CH0_ID_18FAB027_Sig_PMS_GearPositionInd() == 0X7D)
			{
				GearMode = GEAR_N;
			}
			else if (Get_CAN_CH0_ID_18FAB027_Sig_PMS_GearPositionInd() == 0XFA)
			{
				GearMode = GEAR_L;
			}
			else
			{
			}
		}
	}
	else
	{
		GearMode = GEAR_Max;
	}
}

/******************************************************************************
��������Data_Gear_Processing_Service
��  ��: ��λ��ʾ���ݴ���
��  ��: ��
����ֵ����
******************************************************************************/
void Data_DriveMode_Processing_Service(void)
{
	if (SYS_OPR_STAT_IGN_ON)
	{
		if ((CAN_MSG_Status(CAN_CH0, CAN_CH0_ID_PMS_18FAB027_Msg_Count) == CAN_MSG_LOST) || (CanReceive.Can_18FAB027 != 1))
		{
			CanReceive.Can_18FAB027 = 0;
			DriveMode = Drive_Max;
			g_stEco.Valid = 0;
			g_stEco.Value = DriveMode;
		}
		else
		{
			if (Get_CAN_CH0_ID_18FAB027_Sig_PMS_DriveModeInd() == 0X1)
			{
				DriveMode = Drive_ECO;
				g_stEco.Valid = 1;
				g_stEco.Value = DriveMode;
			}
			else
			{
				DriveMode = Drive_Max;
				g_stEco.Valid = 0;
				g_stEco.Value = DriveMode;
			}
		}
	}
	else
	{
		DriveMode = Drive_Max;
		g_stEco.Valid = 0;
		g_stEco.Value = DriveMode;
	}
}
// 100ms��������
void Data_SOC_Init(void)
{
	g_stSoc.u8Valid = 0;
	g_stSoc.u16Val = 0;
}

void Data_SOC_Processing_Service(void)
{
	uint16_t Soc = 0;

	Soc = Get_CAN_CH0_ID_18FA40F4_Sig_BMS_BattSOC(); // 10p
	Soc = Soc * 4;
	if (SYS_OPR_STAT_IGN_ON)
	{
		//if(PageInfo.u16SelfCheckTimeCnt < 30)
		//{
		//	g_stSoc.u8Valid = 0 ;
		//	g_stSoc.u16Val = 0;
		//}
		//else
		//{
		if ((CAN_MSG_Status(CAN_CH0, CAN_CH0_ID_EMS_18FA40F4_Msg_Count) == CAN_MSG_LOST) || (CanReceive.Can_18FA40F4 != 1) || Get_CAN_CH0_ID_18FA40F4_Sig_BMS_BattSOC() == 0xFF)
		{
			CanReceive.Can_18FA40F4 = 0;
			g_stSoc.u8Valid = 0;
			// g_stSoc.u16Val = 0;
		}
		else
		{
			if ((Get_CAN_CH0_ID_18FA42F4_Sig_BMS_BattSOCFault() == 1))
			{
				g_stSoc.u8Valid = 0;
				g_stSoc.u16Val = 0;
			}
			else
			{
				g_stSoc.u8Valid = 1;
				g_stSoc.u16Val = Soc / 10;

				if (g_stSoc.u16Val > 100)
				{
					g_stSoc.u16Val = 100;
				}
			}
		}
		//}
	}
	if(SYS_OPR_STAT_IGN_OFF)
	{
	   if((CAN_MSG_Status(CAN_CH0, CAN_CH0_ID_EMS_18FA40F4_Msg_Count) == CAN_MSG_LOST)||(CanReceive.Can_18FA40F4 != 1)||Get_CAN_CH0_ID_18FA40F4_Sig_BMS_BattSOC() == 0xFF)
	   {
		   CanReceive.Can_18FA40F4 = 0;
		   g_stSoc.u8Valid = 0 ;
		   //g_stSoc.u16Val = 0;
	   }
	   else
	   {
		   g_stSoc.u8Valid = 1 ;
		   g_stSoc.u16Val = Soc/10 ;

		   if(g_stSoc.u16Val > 100)
		   {
			   g_stSoc.u16Val	= 100 ;
		   }
	   }
	}  
}

void Data_ChgTimeRemain_Init(void)
{
	DataChgRemain.u8Valid = 0;
	DataChgRemain.u8Hour = 0;
	DataChgRemain.u8Min = 0;
}

void Data_ChgTimeRemain_Service(void)
{
	uint16_t ChgTimeRemain = 0;

	ChgTimeRemain = Get_CAN_CH0_ID_18FC03F4_Sig_BMS_ChgTimeRemain();

	//	if(SYS_OPR_STAT_IGN_ON)
	{
		if ((CAN_MSG_Status(CAN_CH0, CAN_CH0_ID_BMS_18FC03F4_Msg_Count) == CAN_MSG_LOST) || (CanReceive.Can_18FC03F4 != 1))
		{
			CanReceive.Can_18FC03F4 = 0;
			DataChgRemain.u8Valid = 0;
			DataChgRemain.u8Hour = 0;
			DataChgRemain.u8Min = 0;
		}
		else
		{
			DataChgRemain.u8Valid = 1;
			DataChgRemain.u8Hour = ChgTimeRemain / 60;
			DataChgRemain.u8Min = ChgTimeRemain % 60;
			if ((DataChgRemain.u8Hour >= 99) && (DataChgRemain.u8Min >= 0))
			{
				DataChgRemain.u8Hour = 99;
				DataChgRemain.u8Min = 0;
			}
		}
	}
}

void Data_15KL_Init(void)
{
	 //Fuel_KL15_Change_Config_Init();
	 CoolantTemp_KL15_Read_Config_Init();

	TPMS_Config.F101 = Val_EOL_F101_TPMSType();
	TPMS_Config.F110 = Val_EOL_F110_TPMS();
	BrakeType_Config.F101 = Val_EOL_F101_Break();
	AC_Config.F110 = Val_EOL_F110_AC();

	// ��ʻʱ��
	DataDrivingTime.Start = 0;
	DataDrivingTime.RoCBackup = RTC_ROLLING_COUNTER;
	DataIGNOffTimerSec = 0;
	BattPower_Volt.TimeCnt = 150;

	// ƽ������
	//	TripA_Average_Speed.FreshTime = 0;
	// ǰ����ѹ
	AirPress_Front.u8_Cnt = 0;
	AirPress_Front.u8_ActTimer = 0;
	AirPress_Front.u8_InActTimer = 0;
	AirPress_Front.u16Press_Val = 0;
	AirPress_Front.u8_PressValid = 0;
	AirPress_Front.u16Press_Val = 0;

	AirPress_Front.u8_DeletWarnTimer = 0;
	AirPress_Front.u8_WarnTimer = 0;
	AirPress_Front.u8_WarnFlag = 0;
	AirPress_Front.u8_WarnValid = 0;

	AirPressFront_Dis.u8_UpFlashtimer = 0;
	AirPressFront_Dis.u8_DownFlashtimer = 0;
	AirPressFront_Dis.u8_CurSeg = 0;
	AirPressFront_Dis.u8_DestSeg = 0;

	// ������ѹ
	AirPress_Rear.u8_Cnt = 0;
	AirPress_Rear.u8_ActTimer = 0;
	AirPress_Rear.u8_InActTimer = 0;
	AirPress_Rear.u16Press_Val = 0;
	AirPress_Rear.u8_PressValid = 0;
	AirPress_Rear.u16Press_Val = 0;

	AirPress_Rear.u8_DeletWarnTimer = 0;
	AirPress_Rear.u8_WarnTimer = 0;
	AirPress_Rear.u8_WarnFlag = 0;
	AirPress_Rear.u8_WarnValid = 0;

	AirPressRear_Dis.u8_UpFlashtimer = 0;
	AirPressRear_Dis.u8_DownFlashtimer = 0;
	AirPressRear_Dis.u8_CurSeg = 0;
	AirPressRear_Dis.u8_DestSeg = 0;

	BattPower_Volt.Valid = 0;
	BattPower_Volt.Value = 0;
	BattPower_Volt.Display_Value = 0;

	// �������

	OldServiceMileVaule = NVM_SERVISE_SET;
	// ƽ���ͺ�
	//	AvgFuel_Eng.TimeCnt = 300;
	////ƽ�����

	AvgEVCons.MsgExpEn = 0;
	AvgEVCons.MsgCnt = 0;
	Data_SOC_Init();
	// Data_ChgTimeRemain_Init();

	//	EnergyRecovery = Energy_LeveMax;
}

void Data_30KL_Init(void)
{

	// ��̹���������
	DataMileageRollingCounter = 0;
	DataMileage.mmRollingCounter = 0;
	DataMileage.mmRoCBackup = 0;

	// �ܼ����
	DataODOValid = !NVM_EEPROM_FAULT;
	DataODOCalc.RoCBackup = 0;
	DataODOCalc.LastSaved = NVM_ODO_VALUE;

	// С�����

	// DataTripUnit = 0;

	DataTripCalc.MileageA100m = 0;
	DispTrip = 0;

	// �������
	DataServiceInterval = 0xFFFF;
	DataServiceWarning = 0;

	// ��ʻʱ��
	DataDrivingTime.init = 1;
	DataDrivingTime.Start = 0;
	DataDrivingTime.Timer = 0;

	// �ϵ��ʱ
	DataIGNOffTimerSec = 0;
	DataIGNOffTimer.IGNStatus = 0;
	DataIGNOffTimer.RoCBackup = 0;

	// ƽ������
	DataAvgSpd.First_Distance = 0;
	DataAvgSpd.Distance = 0;
	DataAvgSpd.FreshTime = 0;
	DataAvgSpd.Time = 0;
	DataAvgSpd.Value = 0;
	DataAvgSpd.Display_Value = 0;

	// ǰ����ѹ
	AirPress_Front.u8_Analog_Valid = 0;
	AirPress_Front.u8_Cnt = 0;
	AirPress_Front.u8_Analog_Valid = 0;
	AirPress_Front.u16Volt_Value = 0;

	AirPress_Front.u8_ActTimer = 0;
	AirPress_Front.u8_InActTimer = 0;
	AirPress_Front.u16Press_Val = 0;
	AirPress_Front.u8_PressValid = 0;
	AirPress_Front.u16Press_Val = 0;

	AirPress_Front.u8_DeletWarnTimer = 0;
	AirPress_Front.u8_WarnTimer = 0;
	AirPress_Front.u8_WarnFlag = 0;
	AirPress_Front.u8_WarnValid = 0;

	AirPressFront_Dis.u8_UpFlashtimer = 0;
	AirPressFront_Dis.u8_DownFlashtimer = 0;
	AirPressFront_Dis.u8_CurSeg = 0;
	AirPressFront_Dis.u8_DestSeg = 0;
	// ������ѹ
	AirPress_Rear.u8_Analog_Valid = 0;
	AirPress_Rear.u8_Cnt = 0;
	AirPress_Rear.u8_Analog_Valid = 0;
	AirPress_Rear.u16Volt_Value = 0;

	AirPress_Rear.u8_ActTimer = 0;
	AirPress_Rear.u8_InActTimer = 0;
	AirPress_Rear.u16Press_Val = 0;
	AirPress_Rear.u8_PressValid = 0;
	AirPress_Rear.u16Press_Val = 0;

	AirPress_Rear.u8_DeletWarnTimer = 0;
	AirPress_Rear.u8_WarnTimer = 0;
	AirPress_Rear.u8_WarnFlag = 0;
	AirPress_Rear.u8_WarnValid = 0;

	AirPressRear_Dis.u8_UpFlashtimer = 0;
	AirPressRear_Dis.u8_DownFlashtimer = 0;
	AirPressRear_Dis.u8_CurSeg = 0;
	AirPressRear_Dis.u8_DestSeg = 0;

	/*	InsFuel_Eng.Valid = 0;
		InsFuel_Eng.Value = 0;
		//??????
		AvgFuel_Eng.Display_Value = 0 ;
		AvgFuel_Eng.Value = 0 ;
		AvgFuel_Eng.Backup_Value = 0 ;
		AvgFuel_Eng.TimeCnt = 0 ;
		AvgFuel_Eng.Valid = 0 ;
		AvgFuel_Eng.Flg = 0;
		*/

	////ƽ�����
	AvgEVCons.Valid = 0;
	AvgEVCons.Symbol = Positive;
	AvgEVCons.Value = 0;
	AvgEVCons.MsgExpEn = 0;
	AvgEVCons.MsgCnt = 0;
	// ��λ
	GearMode = GEAR_Max;
	DriveMode = Drive_Max;
	// ������
	DataEVDTE.Valid = 0;
	DataEVDTE.u16_Value = 0;
	// ʣ�๦��
	DataRemainPwr.Valid = 0;
	DataRemainPwr.u16_Value = 0;
	// ������ѹ
	BattVolt.Valid = 0;
	BattVolt.Value = 0;
	// ��������
	BattCurr.Valid = 0;
	BattCurr.Value = 0;
	BattCurr.Symbol = Positive;
	// ���ص�ѹ
	BattPower_Volt.Valid = 0;
	BattPower_Volt.Value = 0;
	BattPower_Volt.Display_Value = 0;

	// �������ߵ�ѹ
	Batt_MaxCellVolt.Valid = 0;
	Batt_MaxCellVolt.Value = 0;
	Batt_MaxCellVolt.Display_Value = 0;
	// �������͵�ѹ
	Batt_MinCellVolt.Valid = 0;
	Batt_MinCellVolt.Value = 0;
	Batt_MinCellVolt.Display_Value = 0;

	Batt_MaxTemp.Valid = 0;
	Batt_MaxTemp.Value = 0;
	Batt_MaxTemp.Display_Value = 0;
	Batt_MaxTemp.Symbol = Positive;

	Batt_MinTemp.Valid = 0;
	Batt_MinTemp.Value = 0;
	Batt_MinTemp.Display_Value = 0;
	Batt_MinTemp.Symbol = Positive;
	// ��������
	EnergyRecovery = Energy_LeveMax;
	// ���ϲ�ѯ
	DataErrCode.Vaild = 0;
	DataErrCode.Value = 0;
	// ����Ѳ��
	DataCruise.u16Value = 0;
	DataCruise.u8DisFlg = 0;
	DataCruise.u8Valid = 0;
	DataCruise.u8LED_W_Sts = 0;
	DataCruise.u8LED_G_Sts = 0;

	// Data_Urea_Level_Init();
	Data_SOC_Init();
	Data_ChgTimeRemain_Init();

	DoorOpen.u16OffTimer = 0;
	DoorOpen.u8LF_St_Last = 0;
	DoorOpen.u8RF_St_Last = 0;
	DoorOpen.u8LR_St_Last = 0;
	DoorOpen.u8RR_St_Last = 0;
	DoorOpen.u8Flag = 0;

	ChargeStatus.u16OffTimer = 0;
	ChargeStatus.u16OffTimer_Door = 0;
	ChargeStatus.u8Flag = 0;
	ChargeStatus.u8Chg_St_Last = 0;
	ChargeStatus.u8Chg_St = 0;
}

void CoolantTemp_KL30_Read_Config_Init(void)
{
		ConfFun.CoolantTem_Warning =  Val_EOL_F102_WarningEngineCoolantTemperature();
		ConfFun.CoolantTem_H =  Val_EOL_F102_HEngineCoolantTemperature();
		ConfFun_Backup.CoolantTem_Warning = ConfFun.CoolantTem_Warning;
		ConfFun_Backup.CoolantTem_H = ConfFun.CoolantTem_H;
	  
}

void CoolantTemp_Read_Config(void)
{
		ConfFun.CoolantTem_Warning =  Val_EOL_F102_WarningEngineCoolantTemperature();
		ConfFun.CoolantTem_H =  Val_EOL_F102_HEngineCoolantTemperature();
		
}

void CoolantTemp_KL15_Read_Config_Init(void)
{
		if ((ConfFun_Backup.CoolantTem_Warning != ConfFun.CoolantTem_Warning) ||
	(ConfFun_Backup.CoolantTem_H != ConfFun.CoolantTem_H))
	{
		ConfFun_Backup.CoolantTem_Warning = ConfFun.CoolantTem_Warning ;
		ConfFun_Backup.CoolantTem_H = ConfFun.CoolantTem_H;

		MeterInfo[Motor_1].Parameter_Num = 8;

		MeterInfo[Motor_1].Physical_Quantity[0] = 40;
		MeterInfo[Motor_1].Physical_Quantity[1] = 60;
		MeterInfo[Motor_1].Physical_Quantity[2] = 80;
		MeterInfo[Motor_1].Physical_Quantity[3] = 92;
		MeterInfo[Motor_1].Physical_Quantity[4] = 96;
		MeterInfo[Motor_1].Physical_Quantity[5] = 100;
		MeterInfo[Motor_1].Physical_Quantity[6] = ConfFun_Backup.CoolantTem_Warning;
		MeterInfo[Motor_1].Physical_Quantity[7] = ConfFun_Backup.CoolantTem_H;

		MeterInfo[Motor_1].MicroStep[0] = 0;
		MeterInfo[Motor_1].MicroStep[1] = 335;
		MeterInfo[Motor_1].MicroStep[2] = 640;
		MeterInfo[Motor_1].MicroStep[3] = 641;
		MeterInfo[Motor_1].MicroStep[4] = 800;
		MeterInfo[Motor_1].MicroStep[5] = 950;
		MeterInfo[Motor_1].MicroStep[6] = 1100;
		MeterInfo[Motor_1].MicroStep[7] = 1270;

	}
		
}

/******************************************************************************
��������Data_Coolant_Temp_Processing_Service
��  �ܣ���ȴҺ�¶����ݴ�������
��  ������
����ֵ����
*******************************************************************************
ע  �⣺�ú�������ÿ20ms������һ��
******************************************************************************/
void Data_Coolant_Temp_Processing_Service(void)
{
		INT8U Coolant_Temperautre ;

	Coolant_Temperautre  =  Get_CAN_CH0_ID_18FA92D0_Sig_EMS_EngineCoolantTemperature();

	if (SYS_OPR_STAT_IGN_ON)
	{
			CoolantTemp_Read_Config();

		if((CAN_MSG_Status(CAN_CH0, CAN_CH0_ID_EMS_18FA92D0_Msg_Count) == CAN_MSG_LOST) ||(Coolant_Temperautre > 0xFA))
		{
			Coolant_Temperature.Value = 0;
			Coolant_Temperature.Valid = 0;
			Coolant_Temperature.Symbol = Positive;
		}
		else
		{
			if(Coolant_Temperautre >= 40)
			{
				Coolant_Temperautre -= 40;
				Coolant_Temperature.Symbol = Positive;

		}
			else
			{
				Coolant_Temperautre = 40 - Coolant_Temperautre;
				Coolant_Temperature.Symbol = Negative;
			}
			Coolant_Temperature.Value = Coolant_Temperautre;
			Coolant_Temperature.Valid = 1;
		}
	}
	else
	{
		Coolant_Temperature.Value = 0;
		Coolant_Temperature.Valid = 0;
		Coolant_Temperature.Symbol = Positive;
	}
		   
}

void Coolant_Meter_Data_Reset(void)
{
		Coolant_Temperature.Value = 0;
	Coolant_Temperature.Valid = 0;
	Coolant_Temperature.Symbol = Positive;
		
}

/**********************��ѹ*********************/
/**********************100ms*********************/

void AirPress_Front_Delt(INT16U m)
{
	AirPress_Front.Cur_VoltVal = m;

	if (AirPress_Front.Cur_VoltVal > AirPress_Front.Last_VoltVal) // ��ѹ����
	{
		if ((AirPress_Front.Cur_VoltVal - AirPress_Front.Last_VoltVal) <= 200)
		{
			AirPress_Front.u16Get_VoltVal = AirPress_Front.Last_VoltVal;
		}
		else
		{
			AirPress_Front.u16Get_VoltVal = AirPress_Front.Cur_VoltVal;
		}
	}
	else if (AirPress_Front.Cur_VoltVal < AirPress_Front.Last_VoltVal) // ��ѹ�½�
	{
		if ((AirPress_Front.Last_VoltVal - AirPress_Front.Cur_VoltVal) <= 200)
		{
			AirPress_Front.u16Get_VoltVal = AirPress_Front.Last_VoltVal;
		}
		else
		{
			AirPress_Front.u16Get_VoltVal = AirPress_Front.Cur_VoltVal;
		}
	}
	else
	{
		AirPress_Front.u16Get_VoltVal = AirPress_Front.Last_VoltVal = AirPress_Front.Cur_VoltVal;
	}
}

void AirPress_Rear_Delt(INT16U m)
{
	AirPress_Rear.Cur_VoltVal = m;

	if (AirPress_Rear.Cur_VoltVal > AirPress_Rear.Last_VoltVal) // ��ѹ����
	{
		if ((AirPress_Rear.Cur_VoltVal - AirPress_Rear.Last_VoltVal) <= 200)
		{
			AirPress_Rear.u16Get_VoltVal = AirPress_Rear.Last_VoltVal;
		}
		else
		{
			AirPress_Rear.u16Get_VoltVal = AirPress_Rear.Cur_VoltVal;
		}
	}
	else if (AirPress_Rear.Cur_VoltVal < AirPress_Rear.Last_VoltVal) // ��ѹ�½�
	{
		if ((AirPress_Rear.Last_VoltVal - AirPress_Rear.Cur_VoltVal) <= 200)
		{
			AirPress_Rear.u16Get_VoltVal = AirPress_Rear.Last_VoltVal;
		}
		else
		{
			AirPress_Rear.u16Get_VoltVal = AirPress_Rear.Cur_VoltVal;
		}
	}
	else
	{
		AirPress_Rear.u16Get_VoltVal = AirPress_Rear.Last_VoltVal = AirPress_Rear.Cur_VoltVal;
	}
}

void Display_AirPress_Front_Processing(void)
{
	if ((BrakeType_Config.F101 == 2) && (SYS_OPR_STAT_IGN_ON))
	{
		if (PageInfo.u16SelfCheckTimeCnt < 30)
		{
			AirPressFront_Dis.u8_Valid = 0;
			AirPressFront_Dis.u8_Flashflg = 0;
		}
		else
		{
			if (AirPress_Front.u8_PressValid)
			{
				AirPressFront_Dis.u8_Valid = 1;
			}
			else
			{
				AirPressFront_Dis.u8_Valid = 0;
				AirPressFront_Dis.u8_Flashflg = 0;
			}
		}

		if (AirPressFront_Dis.u8_Valid)
		{
			AirPressFront_Dis.u8_DestSeg = AirPress_Front.u16Press_Val / 100;

			if (AirPressFront_Dis.u8_Flashflg == 0)
			{
				AirPressFront_Dis.u8_CurSeg = AirPressFront_Dis.u8_DestSeg;
				AirPressFront_Dis.u8_UpFlashtimer = 0;
				AirPressFront_Dis.u8_DownFlashtimer = 0;
				AirPressFront_Dis.u8_Flashflg = 1;
			}
			else
			{
				// �½�����
				if (AirPressFront_Dis.u8_CurSeg > AirPressFront_Dis.u8_DestSeg)
				{
					AirPressFront_Dis.u8_UpFlashtimer = 0;
					AirPressFront_Dis.u8_DownFlashtimer++;
					if (AirPressFront_Dis.u8_DownFlashtimer >= 30)
					{
						AirPressFront_Dis.u8_DownFlashtimer = 0;
						AirPressFront_Dis.u8_CurSeg--;
					}
				}
				// ��������
				else if (AirPressFront_Dis.u8_CurSeg < AirPressFront_Dis.u8_DestSeg)
				{
					AirPressFront_Dis.u8_DownFlashtimer = 0;
					AirPressFront_Dis.u8_UpFlashtimer++;
					if (AirPressFront_Dis.u8_UpFlashtimer >= 30)
					{
						AirPressFront_Dis.u8_UpFlashtimer = 0;
						AirPressFront_Dis.u8_CurSeg++;
					}
				}
				else
				{
					AirPressFront_Dis.u8_UpFlashtimer = 0;
					AirPressFront_Dis.u8_DownFlashtimer = 0;
					AirPressFront_Dis.u8_CurSeg = AirPressFront_Dis.u8_DestSeg;
				}
			}

			if ((AirPressFront_Dis.u8_CurSeg <= 5) && (AirPressFront_Dis.u8_DestSeg <= 5))
			{
				AirPress_Front.u8_WarnFlag = 1;
			}
			else if ((AirPressFront_Dis.u8_CurSeg >= 6) && (AirPressFront_Dis.u8_DestSeg >= 6))

			{
				AirPress_Front.u8_WarnFlag = 0;
			}
		}
		else
		{
			AirPressFront_Dis.u8_CurSeg = AirPressFront_Dis.u8_DestSeg = 0;
			AirPressFront_Dis.u8_UpFlashtimer = 0;
			AirPressFront_Dis.u8_DownFlashtimer = 0;
			AirPressFront_Dis.u8_Flashflg = 0;
			AirPress_Front.u8_WarnFlag = 0;
		}
	}
	else
	{
		AirPressFront_Dis.u8_CurSeg = AirPressFront_Dis.u8_DestSeg = 0;
		AirPressFront_Dis.u8_UpFlashtimer = 0;
		AirPressFront_Dis.u8_DownFlashtimer = 0;
		AirPressFront_Dis.u8_Flashflg = 0;
		AirPress_Front.u8_WarnFlag = 0;
	}
}

void Data_AirPress_Front_Processing(void)
{
	INT32U AirPress_Front_Value = 0;

	if ((BrakeType_Config.F101 == 2) && (SYS_OPR_STAT_IGN_ON))
	{
		// 1,��ȡAD��ѹֵ
		AirPress_Front.u16Volt_Value = AirPress_Front.u16Analog_Volt;
		// ��ѹ�ز�
		AirPress_Front_Delt(AirPress_Front.u16Volt_Value);

		if ((AirPress_Front.u16Volt_Value >= Threshold_AirPress_Vol_Min) &&
			(AirPress_Front.u16Volt_Value <= Threshold_AirPress_Vol_Max))
		{
			if (AirPress_Front.u8_ActTimer < AtmoSignalShakeTime)
			{
				AirPress_Front.u8_ActTimer++;
			}
			else
			{
				AirPress_Front.u8_InActTimer = 0;
				AirPress_Front.u8_PressValid = 1;
				AirPress_Front_Value = AirPress_Front.u16Get_VoltVal - 1000;
				AirPress_Front_Value *= 10;
				AirPress_Front_Value /= 3;
				AirPress_Front_Value += 5;
				AirPress_Front_Value /= 10; // 100p

				if (AirPress_Front_Value >= 1000)
				{
					AirPress_Front.u16Press_Val = 1000;
				}
				else
				{
					AirPress_Front.u16Press_Val = (INT16U)AirPress_Front_Value;
				}
			}
		}
		else
		{
			if (AirPress_Front.u8_InActTimer < AtmoSignalLostTime)
			{
				AirPress_Front.u8_InActTimer++;
			}
			else
			{
				AirPress_Front.u8_PressValid = 0;
				AirPress_Front.u8_ActTimer = 0;
				AirPress_Front.u16Press_Val = 0;
			}
		}
	}
	else
	{
		AirPress_Front.u8_ActTimer = 0;
		AirPress_Front.u8_InActTimer = 0;
		AirPress_Front.u16Press_Val = 0;
		AirPress_Front.u8_PressValid = 0;
	}
	Display_AirPress_Front_Processing();
}

void Display_AirPress_Rear_Processing(void)
{
	if ((BrakeType_Config.F101 == 2) && (SYS_OPR_STAT_IGN_ON))
	{
		if (PageInfo.u16SelfCheckTimeCnt < 30)
		{
			AirPressRear_Dis.u8_Valid = 0;
			AirPressRear_Dis.u8_Flashflg = 0;
		}
		else
		{
			if (AirPress_Rear.u8_PressValid)
			{
				AirPressRear_Dis.u8_Valid = 1;
			}
			else
			{
				AirPressRear_Dis.u8_Valid = 0;
				AirPressRear_Dis.u8_Flashflg = 0;
			}
		}

		if (AirPressRear_Dis.u8_Valid)
		{
			AirPressRear_Dis.u8_DestSeg = AirPress_Rear.u16Press_Val / 100;

			if (AirPressRear_Dis.u8_Flashflg == 0)
			{
				AirPressRear_Dis.u8_CurSeg = AirPressRear_Dis.u8_DestSeg;
				AirPressRear_Dis.u8_UpFlashtimer = 0;
				AirPressRear_Dis.u8_DownFlashtimer = 0;
				AirPressRear_Dis.u8_Flashflg = 1;
			}
			else
			{
				// �½�����
				if (AirPressRear_Dis.u8_CurSeg > AirPressRear_Dis.u8_DestSeg)
				{
					AirPressRear_Dis.u8_UpFlashtimer = 0;
					AirPressRear_Dis.u8_DownFlashtimer++;
					if (AirPressRear_Dis.u8_DownFlashtimer >= 30)
					{
						AirPressRear_Dis.u8_DownFlashtimer = 0;
						AirPressRear_Dis.u8_CurSeg--;
					}
				}
				// ��������
				else if (AirPressRear_Dis.u8_CurSeg < AirPressRear_Dis.u8_DestSeg)
				{
					AirPressRear_Dis.u8_DownFlashtimer = 0;
					AirPressRear_Dis.u8_UpFlashtimer++;
					if (AirPressRear_Dis.u8_UpFlashtimer >= 30)
					{
						AirPressRear_Dis.u8_UpFlashtimer = 0;
						AirPressRear_Dis.u8_CurSeg++;
					}
				}
				else
				{
					AirPressRear_Dis.u8_UpFlashtimer = 0;
					AirPressRear_Dis.u8_DownFlashtimer = 0;
					AirPressRear_Dis.u8_CurSeg = AirPressRear_Dis.u8_DestSeg;
				}
			}

			if ((AirPressRear_Dis.u8_CurSeg <= 5) && (AirPressRear_Dis.u8_DestSeg <= 5))
			{
				AirPress_Rear.u8_WarnFlag = 1;
			}
			else if ((AirPressRear_Dis.u8_CurSeg >= 6) && (AirPressRear_Dis.u8_DestSeg >= 6))
			{
				AirPress_Rear.u8_WarnFlag = 0;
			}
		}
		else
		{
			AirPressRear_Dis.u8_CurSeg = AirPressRear_Dis.u8_DestSeg = 0;
			AirPressRear_Dis.u8_UpFlashtimer = 0;
			AirPressRear_Dis.u8_DownFlashtimer = 0;
			AirPressRear_Dis.u8_Flashflg = 0;
			AirPress_Rear.u8_WarnFlag = 0;
		}
	}
	else
	{
		AirPressRear_Dis.u8_CurSeg = AirPressRear_Dis.u8_DestSeg = 0;
		AirPressRear_Dis.u8_UpFlashtimer = 0;
		AirPressRear_Dis.u8_DownFlashtimer = 0;
		AirPressRear_Dis.u8_Flashflg = 0;
		AirPress_Rear.u8_WarnFlag = 0;
	}
}

void Data_AirPress_Rear_Processing(void)
{
	INT32U AirPress_Rear_Value = 0;
	if ((BrakeType_Config.F101 == 2) && (SYS_OPR_STAT_IGN_ON))
	{
		// 1,��ȡAD��ѹֵ
		AirPress_Rear.u16Volt_Value = AirPress_Rear.u16Analog_Volt;
		// ��ѹ�ز�
		AirPress_Rear_Delt(AirPress_Rear.u16Volt_Value);

		if ((AirPress_Rear.u16Get_VoltVal >= Threshold_AirPress_Vol_Min) &&
			(AirPress_Rear.u16Get_VoltVal < Threshold_AirPress_Vol_Max))
		{
			if (AirPress_Rear.u8_ActTimer < AtmoSignalShakeTime)
			{
				AirPress_Rear.u8_ActTimer++;
			}
			else
			{
				AirPress_Rear.u8_InActTimer = 0;
				AirPress_Rear.u8_PressValid = 1;
				AirPress_Rear_Value = AirPress_Rear.u16Get_VoltVal - 1000;
				AirPress_Rear_Value *= 10;
				AirPress_Rear_Value /= 3;
				AirPress_Rear_Value += 5;
				AirPress_Rear_Value /= 10;

				if (AirPress_Rear_Value >= 1000)
				{
					AirPress_Rear.u16Press_Val = 1000;
				}
				else
				{
					AirPress_Rear.u16Press_Val = (INT16U)AirPress_Rear_Value;
				}
			}
		}
		else
		{
			if (AirPress_Rear.u8_InActTimer < AtmoSignalLostTime)
			{
				AirPress_Rear.u8_InActTimer++;
			}
			else
			{
				AirPress_Rear.u8_PressValid = 0;
				AirPress_Rear.u8_ActTimer = 0;
				AirPress_Rear.u16Press_Val = 0;
			}
		}
	}
	else
	{
		AirPress_Rear.u8_ActTimer = 0;
		AirPress_Rear.u8_InActTimer = 0;
		AirPress_Rear.u16Press_Val = 0;
		AirPress_Rear.u8_PressValid = 0;
	}
	Display_AirPress_Rear_Processing();
}

/*********����ѹ��***************/
void Data_Oil_Press_Service(void)
{
}
/*********����****************/

void Data_DoorOpen_Service(void)
{
	if (CAN_MSG_Status(CAN_CH0, CAN_CH0_ID_BCM_DoorControl2_Msg_Count) == CAN_MSG_LOST)
	{
		DoorOpen.u8LF_St = 0;
		DoorOpen.u8RF_St = 0;
		DoorOpen.u8LR_St = 0;
		DoorOpen.u8RR_St = 0;
	}
	else
	{
		if (Get_CAN_CH0_ID_18FDA521_Sig_BCM_FrontLeftDoorAjarStatus() == 1)
		{
			DoorOpen.u8LF_St = 1;
		}
		else
		{
			DoorOpen.u8LF_St = 0;
		}

		if (Get_CAN_CH0_ID_18FDA521_Sig_BCM_FrontRightDoorAjarStatus() == 1)
		{
			DoorOpen.u8RF_St = 1;
		}
		else
		{
			DoorOpen.u8RF_St = 0;
		}

		if (Get_CAN_CH0_ID_18FDA521_Sig_BCM_RearLeftDoorAjarStatus() == 1)
		{
			DoorOpen.u8LR_St = 1;
		}
		else
		{
			DoorOpen.u8LR_St = 0;
		}

		if (Get_CAN_CH0_ID_18FDA521_Sig_BCM_RearRightDoorAjarStatus() == 1)
		{
			DoorOpen.u8RR_St = 1;
		}
		else
		{
			DoorOpen.u8RR_St = 0;
		}
	}

	if (SYS_OPR_STAT_IGN_ON)
	{
		DoorOpen.u16OffTimer = 0;
		DoorOpen.u8LF_St_Last = 0;
		DoorOpen.u8RF_St_Last = 0;
		DoorOpen.u8LR_St_Last = 0;
		DoorOpen.u8RR_St_Last = 0;
		DoorOpen.u8Flag = 0;
	}
	else
	{
		if (DoorOpen.u8LF_St_Last != DoorOpen.u8LF_St) /*���´���*/
		{
			if (DoorOpen.u8LF_St == 1)
			{
				DoorOpen.u16OffTimer = 0;
				ChargeStatus.u16OffTimer = 0;
				DoorOpen.u8Flag = 1;
			}
			DoorOpen.u8LF_St_Last = DoorOpen.u8LF_St;
		}

		if (DoorOpen.u8RF_St_Last != DoorOpen.u8RF_St)
		{
			if (DoorOpen.u8RF_St == 1)
			{
				DoorOpen.u16OffTimer = 0;
				ChargeStatus.u16OffTimer = 0;
				DoorOpen.u8Flag = 1;
			}
			DoorOpen.u8RF_St_Last = DoorOpen.u8RF_St;
		}

		if (DoorOpen.u8LR_St_Last != DoorOpen.u8LR_St)
		{
			if (DoorOpen.u8LR_St == 1)
			{
				DoorOpen.u16OffTimer = 0;
				ChargeStatus.u16OffTimer = 0;
				DoorOpen.u8Flag = 1;
			}
			DoorOpen.u8LR_St_Last = DoorOpen.u8LR_St;
		}

		if (DoorOpen.u8RR_St_Last != DoorOpen.u8RR_St)
		{
			if (DoorOpen.u8RR_St == 1)
			{
				DoorOpen.u16OffTimer = 0;
				ChargeStatus.u16OffTimer = 0;
				DoorOpen.u8Flag = 1;
			}
			DoorOpen.u8RR_St_Last = DoorOpen.u8RR_St;
		}

		if (DoorOpen.u8LF_St || DoorOpen.u8RF_St || DoorOpen.u8LR_St || DoorOpen.u8RR_St)
		{
		
			if (DoorOpen.u16OffTimer < 300)
			{
				DoorOpen.u16OffTimer++;
			}
			ChargeStatus.u16OffTimer = 0;
			
		}
		else
		{
			DoorOpen.u16OffTimer = 0;
		}
	}
}
// ������
void Data_Charge_Status_Service(void)
{
	if (CAN_MSG_Status(CAN_CH0, CAN_CH0_ID_BMS_18FA3EF4_Msg_Count) == CAN_MSG_LOST)
	{
		ChargeStatus.u8Chg_St = 0;
	}
	else
	{
		if ((Get_CAN_CH0_ID_18FA3EF4_Sig_BMS_ChgStatus() == 1) || (Get_CAN_CH0_ID_18FA3EF4_Sig_BMS_ChgStatus() == 4) || (Get_CAN_CH0_ID_18FA3EF4_Sig_BMS_ChgStatus() == 5))
		{
			ChargeStatus.u8Chg_St = 1;
		}
		else
		{
			ChargeStatus.u8Chg_St = 0;
		}
	}

	if (SYS_OPR_STAT_IGN_ON)
	{
		ChargeStatus.u16OffTimer = 0;
		ChargeStatus.u16OffTimer_Door = 0;
		ChargeStatus.u8Flag = 0;
		ChargeStatus.u8Chg_St_Last = 0;
	}
	else
	{
		if (ChargeStatus.u8Chg_St_Last != ChargeStatus.u8Chg_St)
		{
			if (ChargeStatus.u8Chg_St == 1)
			{
				ChargeStatus.u16OffTimer = 0;
			}
			ChargeStatus.u8Chg_St_Last = ChargeStatus.u8Chg_St;
		}

		if (ChargeStatus.u8Chg_St)
		{
			if ((DoorOpen.u8Flag == 1) && (DoorOpen.u16OffTimer == 300))
			{
				if (ChargeStatus.u16OffTimer_Door < 3000)
				{
					ChargeStatus.u16OffTimer_Door++;
				}
				ChargeStatus.u16OffTimer = 0;
				ChargeStatus.u8Flag = 1;
			}
			else
			{
				if (ChargeStatus.u16OffTimer < 300)
				{
					ChargeStatus.u16OffTimer++;
				}
				ChargeStatus.u16OffTimer_Door = 0;
				ChargeStatus.u8Flag = 2;
			}
		}
		else
		{
			if ((DoorOpen.u8Flag == 1) && (DoorOpen.u16OffTimer == 300))
			{
				ChargeStatus.u16OffTimer_Door = 3000;
				ChargeStatus.u8Flag = 1;
			}
			else
			{
				ChargeStatus.u16OffTimer = 300;
				ChargeStatus.u8Flag = 2;
			}
		}
	}
}

void Data_Language_Set_Service(void)
{
	if (Get_CAN_CH0_ID_18FF4C41_Sig_MMI_IC_LanguageSet() == 1)
	{
		MenuData.Language = 0;
	}
	else if (Get_CAN_CH0_ID_18FF4C41_Sig_MMI_IC_LanguageSet() == 2)
	{
		MenuData.Language = 1;
	}
}

// ��ȫ��
void Data_SafeBelt_Status_Service(void)
{
	if (SYS_OPR_STAT_IGN_ON)
	{
		g_stSafeBelt.u8Left_St = Line_In_Get_Status(LINE_IN_Driver_SafeBelt);
		g_stSafeBelt.u8Mid_St = Line_In_Get_Status(LINE_IN_Middle_SafeBelt);
		g_stSafeBelt.u8Right_St = Line_In_Get_Status(LINE_IN_Passenger_SafeBelt);

		if (g_stSafeBelt.u8Gear_Last != GearMode)
		{
			if (GearMode == GEAR_R)
			{
				g_stSafeBelt.u16Timer = 0;
			}
			g_stSafeBelt.u8Gear_Last = GearMode;
		}
		if (g_stSafeBelt.u8Left_St_Last != g_stSafeBelt.u8Left_St)
		{
			if (g_stSafeBelt.u8Left_St)
			{
				g_stSafeBelt.u16Timer = 0;
			}
			g_stSafeBelt.u8Left_St_Last = g_stSafeBelt.u8Left_St;
		}

		if (g_stSafeBelt.u8Mid_St_Last != g_stSafeBelt.u8Mid_St)
		{
			if (g_stSafeBelt.u8Mid_St)
			{
				g_stSafeBelt.u16Timer = 0;
			}
			g_stSafeBelt.u8Mid_St_Last = g_stSafeBelt.u8Mid_St;
		}

		if (g_stSafeBelt.u8Right_St_Last != g_stSafeBelt.u8Right_St)
		{
			if (g_stSafeBelt.u8Right_St)
			{
				g_stSafeBelt.u16Timer = 0;
			}
			g_stSafeBelt.u8Right_St_Last = g_stSafeBelt.u8Right_St;
		}

		if ((g_stSafeBelt.u8Left_St) || (g_stSafeBelt.u8Mid_St) || (g_stSafeBelt.u8Right_St))
		{
			g_stSafeBelt.u8Lamp_Warn = 1;
			if ((DataVSpeedDisp >= 100) && (Get_CAN_CH0_ID_18FAB027_Sig_PMS_PTReadyInd() == 1) && (GearMode != GEAR_R))
			{
				if (g_stSafeBelt.u16Timer < 1200)
				{
					g_stSafeBelt.u16Timer++;
					g_stSafeBelt.u8Lamp_Warn = 2;
					g_stSafeBelt.u8Pop_Warn = 1;
					g_stSafeBelt.Trigger = 1;
				}
				else
				{
					g_stSafeBelt.u8Lamp_Warn = 1;
					g_stSafeBelt.Trigger = 0;
					g_stSafeBelt.u8Pop_Warn = 0;
				}
			}
			else
			{
				if ((DataVSpeedDisp == 0) && (Get_CAN_CH0_ID_18FAB027_Sig_PMS_PTReadyInd() == 1) && (GearMode != GEAR_R))
				{
					g_stSafeBelt.u16Timer = 0;
					g_stSafeBelt.Trigger = 0;
					g_stSafeBelt.u8Pop_Warn = 0;
				}
			}
			if (g_stSafeBelt.Trigger)
			{
				if (DataVSpeedDisp < 100)
				{
					if (g_stSafeBelt.u16Timer < 1200)
					{
						g_stSafeBelt.u16Timer++;
						g_stSafeBelt.u8Lamp_Warn = 2;
					}
					else
					{
						g_stSafeBelt.u8Lamp_Warn = 1;
						g_stSafeBelt.Trigger = 0;
						g_stSafeBelt.u8Pop_Warn = 0;
					}
				}
			}

			if ((Get_CAN_CH0_ID_18FAB027_Sig_PMS_PTReadyInd() == 0) || (CAN_MSG_Status(CAN_CH0, CAN_CH0_ID_PMS_18FAB027_Msg_Count) == CAN_MSG_LOST) || (GearMode == GEAR_R))
			{
				g_stSafeBelt.u8Lamp_Warn = 1;
				g_stSafeBelt.u8Pop_Warn = 0;
				g_stSafeBelt.u16Timer = 0;
			}
		}
		else
		{
			g_stSafeBelt.u8Lamp_Warn = 0;
			g_stSafeBelt.u8Pop_Warn = 0;
			g_stSafeBelt.Trigger = 0;
		}
	}
	else
	{
		g_stSafeBelt.u8Left_St = 0;
		g_stSafeBelt.u8Mid_St = 0;
		g_stSafeBelt.u8Right_St = 0;
		g_stSafeBelt.u8Left_St_Last = 0;
		g_stSafeBelt.u8Mid_St_Last = 0;
		g_stSafeBelt.u8Right_St_Last = 0;
		g_stSafeBelt.u8Gear_Last = 0;
		g_stSafeBelt.u8Lamp_Warn = 0;
		g_stSafeBelt.u8Pop_Warn = 0;
		g_stSafeBelt.Trigger = 0;
	}
}

INT8U F110_PDC;
INT8U F101_PDC;
void Data_PDC_Service(void)
{
	INT16U PDC_Distance_RL = 0;
	INT16U PDC_Distance_RCL = 0;
	INT16U PDC_Distance_RCR = 0;
	INT16U PDC_Distance_RR = 0;

	F110_PDC = Val_EOL_F110_PDC();
	F101_PDC = Val_EOL_F101_PDC();

	if (((Val_EOL_F110_PDC() == 1) && (Val_EOL_F101_PDC() == 4)) && (Val_EOL_F110_MMI() == 0))
	{
		if (SYS_OPR_STAT_IGN_ON)
		{
			if ((CAN_MSG_Status(CAN_CH0, CAN_CH0_ID_PDC_Status_Msg_Count) == CAN_MSG_LOST) || (CanReceive.Can_0CFF1ADA != 1))
			{
				CanReceive.Can_0CFF1ADA = 0;
				PDC_Sts.RL = PDC_NoDisplay;
				PDC_Sts.MID = PDC_NoDisplay;
				PDC_Sts.RR = PDC_NoDisplay;
				PDC_Sts.UnVaild = 0;
			}
			else
			{
				if ((Get_CAN_CH0_ID_18FAB027_Sig_PMS_GearPositionInd() == 0xDF) && (Get_CAN_CH0_ID_0CFF1ADA_Sig_PDC_VirtualDisplaySts() == 1) && (Get_CAN_CH0_ID_0CFF1ADA_Sig_PDC_SystemState() == 0))
				{
					// ��Ч
					if ((Get_CAN_CH0_ID_0CFF1ADA_Sig_PDC_Distance_RL() == 0x3F) || (Get_CAN_CH0_ID_0CFF1ADA_Sig_PDC_Distance_RCL() == 0x3F) || (Get_CAN_CH0_ID_0CFF1ADA_Sig_PDC_Distance_RCR() == 0x3F) || (Get_CAN_CH0_ID_0CFF1ADA_Sig_PDC_Distance_RR() == 0x3F))
					{
						PDC_Sts.RL = PDC_3F;
						PDC_Sts.MID = PDC_3F;
						PDC_Sts.RR = PDC_3F;
						PDC_Sts.UnVaild = 1;
					}
					else // ��Ч
					{
						PDC_Sts.UnVaild = 0;
						// ����
						if (Get_CAN_CH0_ID_0CFF1ADA_Sig_PDC_Distance_RL() == 0x0)
						{
							PDC_Sts.RL = PDC_NoDisplay;
						}
						else
						{
							PDC_Distance_RL = (5 * Get_CAN_CH0_ID_0CFF1ADA_Sig_PDC_Distance_RL()) + 25;
							if (PDC_Distance_RL <= 40)
							{
								PDC_Sts.RL = PDC_40D;
							}
							else if ((PDC_Distance_RL <= 100) && (PDC_Distance_RL > 40))
							{
								PDC_Sts.RL = PDC_40_100D;
							}
							else if ((PDC_Distance_RL <= 150) && (PDC_Distance_RL > 100))
							{
								PDC_Sts.RL = PDC_100_150D;
							}
							else if ((PDC_Distance_RL <= 300) && (PDC_Distance_RL > 150))
							{
								PDC_Sts.RL = PDC_150_300D;
							}
							else
							{
								PDC_Sts.RL = PDC_300;
							}
						}
						// ������ͺ�����
						if ((Get_CAN_CH0_ID_0CFF1ADA_Sig_PDC_Distance_RCL() == 0x0) && (Get_CAN_CH0_ID_0CFF1ADA_Sig_PDC_Distance_RCR() == 0x0))
						{
							PDC_Sts.MID = PDC_NoDisplay;
						}
						else if ((Get_CAN_CH0_ID_0CFF1ADA_Sig_PDC_Distance_RCL() == 0x0) && (Get_CAN_CH0_ID_0CFF1ADA_Sig_PDC_Distance_RCR() != 0x0))
						{
							PDC_Distance_RCR = (5 * Get_CAN_CH0_ID_0CFF1ADA_Sig_PDC_Distance_RCR()) + 25;

							if (PDC_Distance_RCR <= 40)
							{
								PDC_Sts.MID = PDC_40D;
							}
							else if ((PDC_Distance_RCR <= 100) && (PDC_Distance_RCR > 40))
							{
								PDC_Sts.MID = PDC_40_100D;
							}
							else if ((PDC_Distance_RCR <= 150) && (PDC_Distance_RCR > 100))
							{
								PDC_Sts.MID = PDC_100_150D;
							}
							else if ((PDC_Distance_RCR <= 300) && (PDC_Distance_RCR > 150))
							{
								PDC_Sts.MID = PDC_150_300D;
							}
							else
							{
								PDC_Sts.MID = PDC_300;
							}
						}
						else if ((Get_CAN_CH0_ID_0CFF1ADA_Sig_PDC_Distance_RCL() != 0x0) && (Get_CAN_CH0_ID_0CFF1ADA_Sig_PDC_Distance_RCR() == 0x0))
						{
							PDC_Distance_RCL = (5 * Get_CAN_CH0_ID_0CFF1ADA_Sig_PDC_Distance_RCL()) + 25;

							if (PDC_Distance_RCL <= 40)
							{
								PDC_Sts.MID = PDC_40D;
							}
							else if ((PDC_Distance_RCL <= 100) && (PDC_Distance_RCL > 40))
							{
								PDC_Sts.MID = PDC_40_100D;
							}
							else if ((PDC_Distance_RCL <= 150) && (PDC_Distance_RCL > 100))
							{
								PDC_Sts.MID = PDC_100_150D;
							}
							else if ((PDC_Distance_RCL <= 300) && (PDC_Distance_RCL > 150))
							{
								PDC_Sts.MID = PDC_150_300D;
							}
							else
							{
								PDC_Sts.MID = PDC_300;
							}
						}
						else
						{
							PDC_Distance_RCL = (5 * Get_CAN_CH0_ID_0CFF1ADA_Sig_PDC_Distance_RCL()) + 25;
							PDC_Distance_RCR = (5 * Get_CAN_CH0_ID_0CFF1ADA_Sig_PDC_Distance_RCR()) + 25;

							if ((PDC_Distance_RCL <= 40) || (PDC_Distance_RCR <= 40))
							{
								PDC_Sts.MID = PDC_40D;
							}
							else if (((PDC_Distance_RCL <= 100) && (PDC_Distance_RCL > 40)) ||
									 ((PDC_Distance_RCR <= 100) && (PDC_Distance_RCR > 40)))
							{
								PDC_Sts.MID = PDC_40_100D;
							}
							else if (((PDC_Distance_RCL <= 150) && (PDC_Distance_RCL > 100)) ||
									 ((PDC_Distance_RCR <= 150) && (PDC_Distance_RCR > 100)))
							{
								PDC_Sts.MID = PDC_100_150D;
							}
							else if (((PDC_Distance_RCL <= 300) && (PDC_Distance_RCL > 150)) ||
									 ((PDC_Distance_RCR <= 300) && (PDC_Distance_RCR > 150)))
							{
								PDC_Sts.MID = PDC_150_300D;
							}
							else
							{
								PDC_Sts.MID = PDC_300;
							}
						}
						// ����
						if (Get_CAN_CH0_ID_0CFF1ADA_Sig_PDC_Distance_RR() == 0x0)
						{
							PDC_Sts.RR = PDC_NoDisplay;
						}
						else
						{
							PDC_Distance_RR = (5 * Get_CAN_CH0_ID_0CFF1ADA_Sig_PDC_Distance_RR()) + 25;
							if (PDC_Distance_RR <= 40)
							{
								PDC_Sts.RR = PDC_40D;
							}
							else if ((PDC_Distance_RR <= 100) && (PDC_Distance_RR > 40))
							{
								PDC_Sts.RR = PDC_40_100D;
							}
							else if ((PDC_Distance_RR <= 150) && (PDC_Distance_RR > 100))
							{
								PDC_Sts.RR = PDC_100_150D;
							}
							else if ((PDC_Distance_RR <= 300) && (PDC_Distance_RR > 150))
							{
								PDC_Sts.RR = PDC_150_300D;
							}
							else
							{
								PDC_Sts.RR = PDC_300;
							}
						}
					}
				}
				else
				{
					PDC_Sts.RL = PDC_NoDisplay;
					PDC_Sts.MID = PDC_NoDisplay;
					PDC_Sts.RR = PDC_NoDisplay;
					PDC_Sts.UnVaild = 0;
				}
			}
		}
		else
		{
			PDC_Sts.RL = PDC_NoDisplay;
			PDC_Sts.MID = PDC_NoDisplay;
			PDC_Sts.RR = PDC_NoDisplay;
			PDC_Sts.UnVaild = 0;
		}
	}
	else
	{
		PDC_Sts.RL = PDC_NoDisplay;
		PDC_Sts.MID = PDC_NoDisplay;
		PDC_Sts.RR = PDC_NoDisplay;
		PDC_Sts.UnVaild = 0;
	}
}

/******************************************************************************
��������Data_LDW_Service
��  ��: ����ƫ�봦��
��  ��: ��
����ֵ����
******************************************************************************/
// INT8U  F101_LDW;
// INT8U  F110_FCS;
/*void Data_LDW_Service(void)
{
	//    F101_LDW =  Val_EOL_F101_LDW();
	//    F110_FCS =  Val_EOL_F110_FCS();
#if 0 // shican     
	if((Val_EOL_F101_LDW() == 0x02) && (Val_EOL_F110_FCS() == 0x01)) 
	{
		if (SYS_OPR_STAT_IGN_ON)
		{
			if((CANMsg_18FE5BE8_Status.BIT.Function_Lost == CAN_MSG_LOST) ||(CANMsg_18FE5BE8_Status.BIT.Receive !=1))
			{
				LDW_Infor.Vaild= 0;
				LDW_Infor.Left_St = LDW_MAX;
				LDW_Infor.Right_St= LDW_MAX;
			}
			else
			{			
				if((FCS_LDWSystem_State == 1)||(FCS_LDWSystem_State == 3)||(FCS_LDWSystem_State == 4)||(FCS_LDWSystem_State == 5)) 
				{
					LDW_Infor.Vaild= 1;		
					if(FCS_LaneTrackingStatusLeft_Side == 1)
					{
						LDW_Infor.Left_St = LDW_Thick;	
					}
					else
					{
						LDW_Infor.Left_St = LDW_Thin;		
					}

					if(FCS_LaneTrackingStatusRight_Side == 1)
					{
						LDW_Infor.Right_St = LDW_Thick;	
					}
					else
					{
						LDW_Infor.Right_St = LDW_Thin;	
					}
										 
				}
				else
				{
					LDW_Infor.Vaild= 0;	
					LDW_Infor.Left_St= LDW_MAX;
					LDW_Infor.Right_St= LDW_MAX;
				}	
			}
		}
		else
		{
			LDW_Infor.Vaild= 0;		
			LDW_Infor.Left_St= LDW_MAX;
			LDW_Infor.Right_St= LDW_MAX;
		}
	}
	else
	{
		LDW_Infor.Vaild= 0;		
		LDW_Infor.Left_St= LDW_MAX;
		LDW_Infor.Right_St= LDW_MAX;
	}
#endif
}*/

/******************************************************************************
��������Data_TPMS_Value_Processing
��  ��: TPMS��ֵ(̥ѹ/̥��)����
��  ��: ��
����ֵ����
******************************************************************************/

void Data_TPMS_30_15KL_Processing(void)
{
	Left_Front_Display.TPMS_Blink = 1;
	Left_Rear_Display.TPMS_Blink = 1;
	Left_Rear_Inside_Display.TPMS_Blink = 1;
	Right_Front_Display.TPMS_Blink = 1;
	Right_Rear_Display.TPMS_Blink = 1;
	Right_Rear_Inside_Display.TPMS_Blink = 1;
}
void Data_TPMS_Value_Processing(void)
{
	INT16U BCM_XX_TyrePressure;
	INT16U BCM_XX_TyreTemp;
	INT8U BCM_XX_TPMS_Temp_St;
	INT8U BCM_XX_TPMS_Press_St;
	INT8U BCM_XX_TPMS_FastLoss_St;
	INT8U BCM_XX_TPMS_BatLow_St;
	INT8U BCM_XX_TPMS_NotLearn_St;

	INT8U BCM_XX_TPMS_SensorFlt_St;
	INT8U BCM_XX_TPMS_SensorLoss_St;
	INT8U BCM_XX_TPMS_Wheel_ID;

	BCM_XX_TyrePressure = Get_CAN_CH0_ID_18FFE033_Sig_TPMS_TirePressure();

	BCM_XX_TyreTemp = Get_CAN_CH0_ID_18FFE033_Sig_TPMS_TireTemp();
	BCM_XX_TPMS_Temp_St = Get_CAN_CH0_ID_18FFE033_Sig_TPMS_TempSts();
	BCM_XX_TPMS_Press_St = Get_CAN_CH0_ID_18FFE033_Sig_TPMS_TirePreSts();
	BCM_XX_TPMS_FastLoss_St = Get_CAN_CH0_ID_18FFE033_Sig_TPMS_FastPrLossSts();
	BCM_XX_TPMS_BatLow_St = Get_CAN_CH0_ID_18FFE033_Sig_TPMS_BatterySts();
	BCM_XX_TPMS_NotLearn_St = Get_CAN_CH0_ID_18FFE033_Sig_TPMS_SystemFault();
	BCM_XX_TPMS_SensorFlt_St = Get_CAN_CH0_ID_18FFE033_Sig_TPMS_SensorFaultSts();
	BCM_XX_TPMS_SensorLoss_St = Get_CAN_CH0_ID_18FFE033_Sig_TPMS_SingallMissingSts();
	BCM_XX_TPMS_Wheel_ID = Get_CAN_CH0_ID_18FFE033_Sig_TPMS_Wheel_location_ID();

	if (SYS_OPR_STAT_IGN_ON)
	{
		if (CAN_MSG_Status(CAN_CH0, CAN_CH0_ID_TPMS_TireInfor_Msg_Count) == CAN_MSG_LOST)
		{
			TPMS_Info.TPMS_Valid = 0;
			TPMS_Info.Press_Valid = 0;
			TPMS_Info.Temp_Valid = 0;
			TPMS_Info.Temp_Symbol = Positive;
			TPMS_Info.Wheel_ID = 0;
			TPMS_Info.Temp_Value = 0;
			TPMS_Info.Press_Value = 0;

			TPMS_Info.Press_St = BCM_XX_TPMS_Press_St;
			TPMS_Info.Temp_St = BCM_XX_TPMS_Temp_St;
			TPMS_Info.Fast_Press = BCM_XX_TPMS_FastLoss_St;
			TPMS_Info.BatLow_St = BCM_XX_TPMS_BatLow_St;
			TPMS_Info.System_Flt = BCM_XX_TPMS_NotLearn_St;
			TPMS_Info.Sensor_Flt = BCM_XX_TPMS_SensorFlt_St;
			TPMS_Info.Sensor_Loss = BCM_XX_TPMS_SensorLoss_St;
		}
		else
		{
			TPMS_Info.TPMS_Valid = 1;
			// ̥��
			if (BCM_XX_TyreTemp == 0xFF)
			{
				TPMS_Info.Temp_Valid = 0;
			}
			else
			{
				if (BCM_XX_TyreTemp >= 50)
				{
					TPMS_Info.Temp_Value = BCM_XX_TyreTemp - 50;
					TPMS_Info.Temp_Symbol = Positive;
				}
				else
				{
					TPMS_Info.Temp_Value = 50 - BCM_XX_TyreTemp;
					TPMS_Info.Temp_Symbol = Negative;
				}
				if (TPMS_Info.Temp_Value > 200)
				{
					TPMS_Info.Temp_Value = 200;
				}
				TPMS_Info.Temp_Valid = 1;
			}

			// ̥ѹ
			if (BCM_XX_TyrePressure == 0xffff)
			{
				TPMS_Info.Press_Valid = 0;
			}
			else
			{
				TPMS_Info.Press_Valid = 1;
				TPMS_Info.Press_Value = Unit_Conv_kPa_To_bar(BCM_XX_TyrePressure);
				if (TPMS_Info.Press_Value > 200)
				{
					TPMS_Info.Press_Value = 200;
				}
			}

			TPMS_Info.Press_St = BCM_XX_TPMS_Press_St;
			TPMS_Info.Temp_St = BCM_XX_TPMS_Temp_St;
			TPMS_Info.Fast_Press = BCM_XX_TPMS_FastLoss_St;
			TPMS_Info.BatLow_St = BCM_XX_TPMS_BatLow_St;
			TPMS_Info.System_Flt = BCM_XX_TPMS_NotLearn_St;
			TPMS_Info.Sensor_Flt = BCM_XX_TPMS_SensorFlt_St;
			TPMS_Info.Sensor_Loss = BCM_XX_TPMS_SensorLoss_St;
			TPMS_Info.Wheel_ID = BCM_XX_TPMS_Wheel_ID;
		}
	}
	// ��ȡ̥ѹ��ʾ
	if (SYS_OPR_STAT_IGN_ON)
	{
		if (TPMS_Info.TPMS_Valid == 1)
		{
			// ��ǰ
			if (TPMS_Info.Wheel_ID == 0x17)
			{
				if (TPMS_Info.Press_Valid == 1)
				{
					Left_Front_Display.Press_Valid = 1;
					Left_Front_Display.Press_Value = TPMS_Info.Press_Value;
				}
				else
				{
					Left_Front_Display.Press_Valid = 0;
				}

				if (TPMS_Info.Temp_Valid == 1)
				{
					Left_Front_Display.Temp_Valid = 1;
					Left_Front_Display.Temp_Value = TPMS_Info.Temp_Value;
					Left_Front_Display.Temp_Symbol = TPMS_Info.Temp_Symbol;
				}
				else
				{
					Left_Front_Display.Temp_Valid = 0;
					Left_Front_Display.Temp_Symbol = Positive;
				}

				if((TPMS_Info.System_Flt == 3)||(TPMS_Info.Sensor_Loss == 1))
				{
					Left_Front_Display.Press_Valid = 0;
					Left_Front_Display.Temp_Valid = 0;
				}
//
				//if ((Left_Rear_Display.Press_St == 2) || (Left_Rear_Display.Press_St == 1) || (Left_Rear_Display.Temp_St == 1) ||
				//	(Left_Rear_Display.Fast_Press == 1) || (Left_Rear_Display.BatLow_St == 1) || (Left_Rear_Display.System_Flt == 3) ||
				//	(Left_Rear_Display.Sensor_Flt == 1) || (Left_Rear_Display.Sensor_Loss == 1))
				//{
				//	Left_Rear_Display.TPMS_Blink = FLASH_SYNC_1Hz;
				//}
				//else
				//{
				//	Left_Rear_Display.TPMS_Blink = 1;
				//}
//
				//if ((Left_Rear_Inside_Display.Press_St == 2) || (Left_Rear_Inside_Display.Press_St == 1) || (Left_Rear_Inside_Display.Temp_St == 1) ||
				//	(Left_Rear_Inside_Display.Fast_Press == 1) || (Left_Rear_Inside_Display.BatLow_St == 1) || (Left_Rear_Inside_Display.System_Flt == 3) ||
				//	(Left_Rear_Inside_Display.Sensor_Flt == 1) || (Left_Rear_Inside_Display.Sensor_Loss == 1))
				//{
				//	Left_Rear_Inside_Display.TPMS_Blink = FLASH_SYNC_1Hz;
				//}
				//else
				//{
				//	Left_Rear_Inside_Display.TPMS_Blink = 1;
				//}
//
				//if ((Right_Front_Display.Press_St == 2) || (Right_Front_Display.Press_St == 1) || (Right_Front_Display.Temp_St == 1) ||
				//	(Right_Front_Display.Fast_Press == 1) || (Right_Front_Display.BatLow_St == 1) || (Right_Front_Display.System_Flt == 3) ||
				//	(Right_Front_Display.Sensor_Flt == 1) || (Right_Front_Display.Sensor_Loss == 1))
				//{
				//	Right_Front_Display.TPMS_Blink = FLASH_SYNC_1Hz;
				//}
				//else
				//{
				//	Right_Front_Display.TPMS_Blink = 1;
				//}
//
				//if ((Right_Rear_Display.Press_St == 2) || (Right_Rear_Display.Press_St == 1) || (Right_Rear_Display.Temp_St == 1) ||
				//	(Right_Rear_Display.Fast_Press == 1) || (Right_Rear_Display.BatLow_St == 1) || (Right_Rear_Display.System_Flt == 3) ||
				//	(Right_Rear_Display.Sensor_Flt == 1) || (Right_Rear_Display.Sensor_Loss == 1))
				//{
				//	Right_Rear_Display.TPMS_Blink = FLASH_SYNC_1Hz;
				//}
				//else
				//{
				//	Right_Rear_Display.TPMS_Blink = 1;
				//}
//
				//if ((Right_Rear_Inside_Display.Press_St == 2) || (Right_Rear_Inside_Display.Press_St == 1) || (Right_Rear_Inside_Display.Temp_St == 1) ||
				//	(Right_Rear_Inside_Display.Fast_Press == 1) || (Right_Rear_Inside_Display.BatLow_St == 1) || (Right_Rear_Inside_Display.System_Flt == 3) ||
				//	(Right_Rear_Inside_Display.Sensor_Flt == 1) || (Right_Rear_Inside_Display.Sensor_Loss == 1))
				//{
				//	Right_Rear_Inside_Display.TPMS_Blink = FLASH_SYNC_1Hz;
				//}
				//else
				//{
				//	Right_Rear_Inside_Display.TPMS_Blink = 1;
				//}

				Left_Front_Display.Press_St = TPMS_Info.Press_St;
				Left_Front_Display.Temp_St = TPMS_Info.Temp_St;
				Left_Front_Display.Fast_Press = TPMS_Info.Fast_Press;
				Left_Front_Display.BatLow_St = TPMS_Info.BatLow_St;
				Left_Front_Display.System_Flt = TPMS_Info.System_Flt;
				Left_Front_Display.Sensor_Flt = TPMS_Info.Sensor_Flt;
				Left_Front_Display.Sensor_Loss = TPMS_Info.Sensor_Loss;

				if ((Left_Front_Display.Press_St == 2) || (Left_Front_Display.Press_St == 1) || (Left_Front_Display.Temp_St == 1) ||
					(Left_Front_Display.Fast_Press == 1) || (Left_Front_Display.BatLow_St == 1) || (Left_Front_Display.System_Flt == 3) ||
					(Left_Front_Display.Sensor_Flt == 1) || (Left_Front_Display.Sensor_Loss == 1))
				{
					Left_Front_Display.TPMS_Blink = FLASH_SYNC_1Hz;
				}
				else
				{
					Left_Front_Display.TPMS_Blink = 1;
				}
			}
			if (TPMS_Info.Wheel_ID == 0x19) // ��ǰ
			{
				if (TPMS_Info.Press_Valid == 1)
				{
					Right_Front_Display.Press_Valid = 1;
					Right_Front_Display.Press_Value = TPMS_Info.Press_Value;
				}
				else
				{
					Right_Front_Display.Press_Valid = 0;
				}

				if (TPMS_Info.Temp_Valid == 1)
				{
					Right_Front_Display.Temp_Valid = 1;
					Right_Front_Display.Temp_Value = TPMS_Info.Temp_Value;
					Right_Front_Display.Temp_Symbol = TPMS_Info.Temp_Symbol;
				}
				else
				{
					Right_Front_Display.Temp_Valid = 0;
					Right_Front_Display.Temp_Symbol = Positive;
				}

				if((TPMS_Info.System_Flt == 3)||(TPMS_Info.Sensor_Loss == 1))
				{
					Right_Front_Display.Press_Valid = 0;
					Right_Front_Display.Temp_Valid = 0;
				}

				//if ((Left_Front_Display.Press_St == 2) || (Left_Front_Display.Press_St == 1) || (Left_Front_Display.Temp_St == 1) ||
				//	(Left_Front_Display.Fast_Press == 1) || (Left_Front_Display.BatLow_St == 1) || (Left_Front_Display.System_Flt == 3) ||
				//	(Left_Front_Display.Sensor_Flt == 1) || (Left_Front_Display.Sensor_Loss == 1))
				//{
				//	Left_Front_Display.TPMS_Blink = FLASH_SYNC_1Hz;
				//}
				//else
				//{
				//	Left_Front_Display.TPMS_Blink = 1;
				//}
//
				//if ((Left_Rear_Display.Press_St == 2) || (Left_Rear_Display.Press_St == 1) || (Left_Rear_Display.Temp_St == 1) ||
				//	(Left_Rear_Display.Fast_Press == 1) || (Left_Rear_Display.BatLow_St == 1) || (Left_Rear_Display.System_Flt == 3) ||
				//	(Left_Rear_Display.Sensor_Flt == 1) || (Left_Rear_Display.Sensor_Loss == 1))
				//{
				//	Left_Rear_Display.TPMS_Blink = FLASH_SYNC_1Hz;
				//}
				//else
				//{
				//	Left_Rear_Display.TPMS_Blink = 1;
				//}
//
				//if ((Left_Rear_Inside_Display.Press_St == 2) || (Left_Rear_Inside_Display.Press_St == 1) || (Left_Rear_Inside_Display.Temp_St == 1) ||
				//	(Left_Rear_Inside_Display.Fast_Press == 1) || (Left_Rear_Inside_Display.BatLow_St == 1) || (Left_Rear_Inside_Display.System_Flt == 3) ||
				//	(Left_Rear_Inside_Display.Sensor_Flt == 1) || (Left_Rear_Inside_Display.Sensor_Loss == 1))
				//{
				//	Left_Rear_Inside_Display.TPMS_Blink = FLASH_SYNC_1Hz;
				//}
				//else
				//{
				//	Left_Rear_Inside_Display.TPMS_Blink = 1;
				//}
//
				//if ((Right_Rear_Display.Press_St == 2) || (Right_Rear_Display.Press_St == 1) || (Right_Rear_Display.Temp_St == 1) ||
				//	(Right_Rear_Display.Fast_Press == 1) || (Right_Rear_Display.BatLow_St == 1) || (Right_Rear_Display.System_Flt == 3) ||
				//	(Right_Rear_Display.Sensor_Flt == 1) || (Right_Rear_Display.Sensor_Loss == 1))
				//{
				//	Right_Rear_Display.TPMS_Blink = FLASH_SYNC_1Hz;
				//}
				//else
				//{
				//	Right_Rear_Display.TPMS_Blink = 1;
				//}
//
				//if ((Right_Rear_Inside_Display.Press_St == 2) || (Right_Rear_Inside_Display.Press_St == 1) || (Right_Rear_Inside_Display.Temp_St == 1) ||
				//	(Right_Rear_Inside_Display.Fast_Press == 1) || (Right_Rear_Inside_Display.BatLow_St == 1) || (Right_Rear_Inside_Display.System_Flt == 3) ||
				//	(Right_Rear_Inside_Display.Sensor_Flt == 1) || (Right_Rear_Inside_Display.Sensor_Loss == 1))
				//{
				//	Right_Rear_Inside_Display.TPMS_Blink = FLASH_SYNC_1Hz;
				//}
				//else
				//{
				//	Right_Rear_Inside_Display.TPMS_Blink = 1;
				//}

				Right_Front_Display.Press_St = TPMS_Info.Press_St;
				Right_Front_Display.Temp_St = TPMS_Info.Temp_St;
				Right_Front_Display.Fast_Press = TPMS_Info.Fast_Press;
				Right_Front_Display.BatLow_St = TPMS_Info.BatLow_St;
				Right_Front_Display.System_Flt = TPMS_Info.System_Flt;
				Right_Front_Display.Sensor_Flt = TPMS_Info.Sensor_Flt;
				Right_Front_Display.Sensor_Loss = TPMS_Info.Sensor_Loss;

				if ((Right_Front_Display.Press_St == 2) || (Right_Front_Display.Press_St == 1) || (Right_Front_Display.Temp_St == 1) ||
					(Right_Front_Display.Fast_Press == 1) || (Right_Front_Display.BatLow_St == 1) || (Right_Front_Display.System_Flt == 3) ||
					(Right_Front_Display.Sensor_Flt == 1) || (Right_Front_Display.Sensor_Loss == 1))
				{
					Right_Front_Display.TPMS_Blink = FLASH_SYNC_1Hz;
				}
				else
				{
					Right_Front_Display.TPMS_Blink = 1;
				}
			}
			if (TPMS_Info.Wheel_ID == 0x26) // �����
			{
				if (TPMS_Info.Press_Valid == 1)
				{
					Left_Rear_Display.Press_Valid = 1;
					Left_Rear_Display.Press_Value = TPMS_Info.Press_Value;
				}
				else
				{
					Left_Rear_Display.Press_Valid = 0;
				}

				if (TPMS_Info.Temp_Valid == 1)
				{
					Left_Rear_Display.Temp_Valid = 1;
					Left_Rear_Display.Temp_Value = TPMS_Info.Temp_Value;
					Left_Rear_Display.Temp_Symbol = TPMS_Info.Temp_Symbol;
				}
				else
				{
					Left_Rear_Display.Temp_Valid = 0;
					Left_Rear_Display.Temp_Symbol = Positive;
				}

				if((TPMS_Info.System_Flt == 3)||(TPMS_Info.Sensor_Loss == 1))
				{
					Left_Rear_Display.Press_Valid = 0;
					Left_Rear_Display.Temp_Valid = 0;
				}

				//if ((Left_Front_Display.Press_St == 2) || (Left_Front_Display.Press_St == 1) || (Left_Front_Display.Temp_St == 1) ||
				//	(Left_Front_Display.Fast_Press == 1) || (Left_Front_Display.BatLow_St == 1) || (Left_Front_Display.System_Flt == 3) ||
				//	(Left_Front_Display.Sensor_Flt == 1) || (Left_Front_Display.Sensor_Loss == 1))
				//{
				//	Left_Front_Display.TPMS_Blink = FLASH_SYNC_1Hz;
				//}
				//else
				//{
				//	Left_Front_Display.TPMS_Blink = 1;
				//}
//
				//if ((Left_Rear_Inside_Display.Press_St == 2) || (Left_Rear_Inside_Display.Press_St == 1) || (Left_Rear_Inside_Display.Temp_St == 1) ||
				//	(Left_Rear_Inside_Display.Fast_Press == 1) || (Left_Rear_Inside_Display.BatLow_St == 1) || (Left_Rear_Inside_Display.System_Flt == 3) ||
				//	(Left_Rear_Inside_Display.Sensor_Flt == 1) || (Left_Rear_Inside_Display.Sensor_Loss == 1))
				//{
				//	Left_Rear_Inside_Display.TPMS_Blink = FLASH_SYNC_1Hz;
				//}
				//else
				//{
				//	Left_Rear_Inside_Display.TPMS_Blink = 1;
				//}
//
				//if ((Right_Front_Display.Press_St == 2) || (Right_Front_Display.Press_St == 1) || (Right_Front_Display.Temp_St == 1) ||
				//	(Right_Front_Display.Fast_Press == 1) || (Right_Front_Display.BatLow_St == 1) || (Right_Front_Display.System_Flt == 3) ||
				//	(Right_Front_Display.Sensor_Flt == 1) || (Right_Front_Display.Sensor_Loss == 1))
				//{
				//	Right_Front_Display.TPMS_Blink = FLASH_SYNC_1Hz;
				//}
				//else
				//{
				//	Right_Front_Display.TPMS_Blink = 1;
				//}
//
				//if ((Right_Rear_Display.Press_St == 2) || (Right_Rear_Display.Press_St == 1) || (Right_Rear_Display.Temp_St == 1) ||
				//	(Right_Rear_Display.Fast_Press == 1) || (Right_Rear_Display.BatLow_St == 1) || (Right_Rear_Display.System_Flt == 3) ||
				//	(Right_Rear_Display.Sensor_Flt == 1) || (Right_Rear_Display.Sensor_Loss == 1))
				//{
				//	Right_Rear_Display.TPMS_Blink = FLASH_SYNC_1Hz;
				//}
				//else
				//{
				//	Right_Rear_Display.TPMS_Blink = 1;
				//}
//
				//if ((Right_Rear_Inside_Display.Press_St == 2) || (Right_Rear_Inside_Display.Press_St == 1) || (Right_Rear_Inside_Display.Temp_St == 1) ||
				//	(Right_Rear_Inside_Display.Fast_Press == 1) || (Right_Rear_Inside_Display.BatLow_St == 1) || (Right_Rear_Inside_Display.System_Flt == 3) ||
				//	(Right_Rear_Inside_Display.Sensor_Flt == 1) || (Right_Rear_Inside_Display.Sensor_Loss == 1))
				//{
				//	Right_Rear_Inside_Display.TPMS_Blink = FLASH_SYNC_1Hz;
				//}
				//else
				//{
				//	Right_Rear_Inside_Display.TPMS_Blink = 1;
				//}

				Left_Rear_Display.Press_St = TPMS_Info.Press_St;
				Left_Rear_Display.Temp_St = TPMS_Info.Temp_St;
				Left_Rear_Display.Fast_Press = TPMS_Info.Fast_Press;
				Left_Rear_Display.BatLow_St = TPMS_Info.BatLow_St;
				Left_Rear_Display.System_Flt = TPMS_Info.System_Flt;
				Left_Rear_Display.Sensor_Flt = TPMS_Info.Sensor_Flt;
				Left_Rear_Display.Sensor_Loss = TPMS_Info.Sensor_Loss;

				if ((Left_Rear_Display.Press_St == 2) || (Left_Rear_Display.Press_St == 1) || (Left_Rear_Display.Temp_St == 1) ||
					(Left_Rear_Display.Fast_Press == 1) || (Left_Rear_Display.BatLow_St == 1) || (Left_Rear_Display.System_Flt == 3) ||
					(Left_Rear_Display.Sensor_Flt == 1) || (Left_Rear_Display.Sensor_Loss == 1))
				{
					Left_Rear_Display.TPMS_Blink = FLASH_SYNC_1Hz;
				}
				else
				{
					Left_Rear_Display.TPMS_Blink = 1;
				}
			}
			if (TPMS_Info.Wheel_ID == 0x27) // �������
			{
				if (TPMS_Info.Press_Valid == 1)
				{
					Left_Rear_Inside_Display.Press_Valid = 1;
					Left_Rear_Inside_Display.Press_Value = TPMS_Info.Press_Value;
				}
				else
				{
					Left_Rear_Inside_Display.Press_Valid = 0;
				}

				if (TPMS_Info.Temp_Valid == 1)
				{
					Left_Rear_Inside_Display.Temp_Valid = 1;
					Left_Rear_Inside_Display.Temp_Value = TPMS_Info.Temp_Value;
					Left_Rear_Inside_Display.Temp_Symbol = TPMS_Info.Temp_Symbol;
				}
				else
				{
					Left_Rear_Inside_Display.Temp_Valid = 0;
					Left_Rear_Inside_Display.Temp_Symbol = Positive;
				}

				if((TPMS_Info.System_Flt == 3)||(TPMS_Info.Sensor_Loss == 1))
				{
					Left_Rear_Inside_Display.Press_Valid = 0;
					Left_Rear_Inside_Display.Temp_Valid = 0;
				}

				//if ((Left_Front_Display.Press_St == 2) || (Left_Front_Display.Press_St == 1) || (Left_Front_Display.Temp_St == 1) ||
				//	(Left_Front_Display.Fast_Press == 1) || (Left_Front_Display.BatLow_St == 1) || (Left_Front_Display.System_Flt == 3) ||
				//	(Left_Front_Display.Sensor_Flt == 1) || (Left_Front_Display.Sensor_Loss == 1))
				//{
				//	Left_Front_Display.TPMS_Blink = FLASH_SYNC_1Hz;
				//}
				//else
				//{
				//	Left_Front_Display.TPMS_Blink = 1;
				//}
//
				//if ((Left_Rear_Display.Press_St == 2) || (Left_Rear_Display.Press_St == 1) || (Left_Rear_Display.Temp_St == 1) ||
				//	(Left_Rear_Display.Fast_Press == 1) || (Left_Rear_Display.BatLow_St == 1) || (Left_Rear_Display.System_Flt == 3) ||
				//	(Left_Rear_Display.Sensor_Flt == 1) || (Left_Rear_Display.Sensor_Loss == 1))
				//{
				//	Left_Rear_Display.TPMS_Blink = FLASH_SYNC_1Hz;
				//}
				//else
				//{
				//	Left_Rear_Display.TPMS_Blink = 1;
				//}
//
				//if ((Right_Front_Display.Press_St == 2) || (Right_Front_Display.Press_St == 1) || (Right_Front_Display.Temp_St == 1) ||
				//	(Right_Front_Display.Fast_Press == 1) || (Right_Front_Display.BatLow_St == 1) || (Right_Front_Display.System_Flt == 3) ||
				//	(Right_Front_Display.Sensor_Flt == 1) || (Right_Front_Display.Sensor_Loss == 1))
				//{
				//	Right_Front_Display.TPMS_Blink = FLASH_SYNC_1Hz;
				//}
				//else
				//{
				//	Right_Front_Display.TPMS_Blink = 1;
				//}
//
				//if ((Right_Rear_Display.Press_St == 2) || (Right_Rear_Display.Press_St == 1) || (Right_Rear_Display.Temp_St == 1) ||
				//	(Right_Rear_Display.Fast_Press == 1) || (Right_Rear_Display.BatLow_St == 1) || (Right_Rear_Display.System_Flt == 3) ||
				//	(Right_Rear_Display.Sensor_Flt == 1) || (Right_Rear_Display.Sensor_Loss == 1))
				//{
				//	Right_Rear_Display.TPMS_Blink = FLASH_SYNC_1Hz;
				//}
				//else
				//{
				//	Right_Rear_Display.TPMS_Blink = 1;
				//}
//
				//if ((Right_Rear_Inside_Display.Press_St == 2) || (Right_Rear_Inside_Display.Press_St == 1) || (Right_Rear_Inside_Display.Temp_St == 1) ||
				//	(Right_Rear_Inside_Display.Fast_Press == 1) || (Right_Rear_Inside_Display.BatLow_St == 1) || (Right_Rear_Inside_Display.System_Flt == 3) ||
				//	(Right_Rear_Inside_Display.Sensor_Flt == 1) || (Right_Rear_Inside_Display.Sensor_Loss == 1))
				//{
				//	Right_Rear_Inside_Display.TPMS_Blink = FLASH_SYNC_1Hz;
				//}
				//else
				//{
				//	Right_Rear_Inside_Display.TPMS_Blink = 1;
				//}

				Left_Rear_Inside_Display.Press_St = TPMS_Info.Press_St;
				Left_Rear_Inside_Display.Temp_St = TPMS_Info.Temp_St;
				Left_Rear_Inside_Display.Fast_Press = TPMS_Info.Fast_Press;
				Left_Rear_Inside_Display.BatLow_St = TPMS_Info.BatLow_St;
				Left_Rear_Inside_Display.System_Flt = TPMS_Info.System_Flt;
				Left_Rear_Inside_Display.Sensor_Flt = TPMS_Info.Sensor_Flt;
				Left_Rear_Inside_Display.Sensor_Loss = TPMS_Info.Sensor_Loss;

				if ((Left_Rear_Inside_Display.Press_St == 2) || (Left_Rear_Inside_Display.Press_St == 1) || (Left_Rear_Inside_Display.Temp_St == 1) ||
					(Left_Rear_Inside_Display.Fast_Press == 1) || (Left_Rear_Inside_Display.BatLow_St == 1) || (Left_Rear_Inside_Display.System_Flt == 3) ||
					(Left_Rear_Inside_Display.Sensor_Flt == 1) || (Left_Rear_Inside_Display.Sensor_Loss == 1))
				{
					Left_Rear_Inside_Display.TPMS_Blink = FLASH_SYNC_1Hz;
				}
				else
				{
					Left_Rear_Inside_Display.TPMS_Blink = 1;
				}
			}
			if (TPMS_Info.Wheel_ID == 0x29) // �Һ�����
			{
				if (TPMS_Info.Press_Valid == 1)
				{
					Right_Rear_Inside_Display.Press_Valid = 1;
					Right_Rear_Inside_Display.Press_Value = TPMS_Info.Press_Value;
				}
				else
				{
					Right_Rear_Inside_Display.Press_Valid = 0;
				}

				if (TPMS_Info.Temp_Valid == 1)
				{
					Right_Rear_Inside_Display.Temp_Valid = 1;
					Right_Rear_Inside_Display.Temp_Value = TPMS_Info.Temp_Value;
					Right_Rear_Inside_Display.Temp_Symbol = TPMS_Info.Temp_Symbol;
				}
				else
				{
					Right_Rear_Inside_Display.Temp_Valid = 0;
					Right_Rear_Inside_Display.Temp_Symbol = Positive;
				}

				if((TPMS_Info.System_Flt == 3)||(TPMS_Info.Sensor_Loss == 1))
				{
					Right_Rear_Inside_Display.Press_Valid = 0;
					Right_Rear_Inside_Display.Temp_Valid = 0;
				}

				//if ((Left_Front_Display.Press_St == 2) || (Left_Front_Display.Press_St == 1) || (Left_Front_Display.Temp_St == 1) ||
				//	(Left_Front_Display.Fast_Press == 1) || (Left_Front_Display.BatLow_St == 1) || (Left_Front_Display.System_Flt == 3) ||
				//	(Left_Front_Display.Sensor_Flt == 1) || (Left_Front_Display.Sensor_Loss == 1))
				//{
				//	Left_Front_Display.TPMS_Blink = FLASH_SYNC_1Hz;
				//}
				//else
				//{
				//	Left_Front_Display.TPMS_Blink = 1;
				//}
//
				//if ((Left_Rear_Display.Press_St == 2) || (Left_Rear_Display.Press_St == 1) || (Left_Rear_Display.Temp_St == 1) ||
				//	(Left_Rear_Display.Fast_Press == 1) || (Left_Rear_Display.BatLow_St == 1) || (Left_Rear_Display.System_Flt == 3) ||
				//	(Left_Rear_Display.Sensor_Flt == 1) || (Left_Rear_Display.Sensor_Loss == 1))
				//{
				//	Left_Rear_Display.TPMS_Blink = FLASH_SYNC_1Hz;
				//}
				//else
				//{
				//	Left_Rear_Display.TPMS_Blink = 1;
				//}
//
				//if ((Left_Rear_Inside_Display.Press_St == 2) || (Left_Rear_Inside_Display.Press_St == 1) || (Left_Rear_Inside_Display.Temp_St == 1) ||
				//	(Left_Rear_Inside_Display.Fast_Press == 1) || (Left_Rear_Inside_Display.BatLow_St == 1) || (Left_Rear_Inside_Display.System_Flt == 3) ||
				//	(Left_Rear_Inside_Display.Sensor_Flt == 1) || (Left_Rear_Inside_Display.Sensor_Loss == 1))
				//{
				//	Left_Rear_Inside_Display.TPMS_Blink = FLASH_SYNC_1Hz;
				//}
				//else
				//{
				//	Left_Rear_Inside_Display.TPMS_Blink = 1;
				//}
//
				//if ((Right_Front_Display.Press_St == 2) || (Right_Front_Display.Press_St == 1) || (Right_Front_Display.Temp_St == 1) ||
				//	(Right_Front_Display.Fast_Press == 1) || (Right_Front_Display.BatLow_St == 1) || (Right_Front_Display.System_Flt == 3) ||
				//	(Right_Front_Display.Sensor_Flt == 1) || (Right_Front_Display.Sensor_Loss == 1))
				//{
				//	Right_Front_Display.TPMS_Blink = FLASH_SYNC_1Hz;
				//}
				//else
				//{
				//	Right_Front_Display.TPMS_Blink = 1;
				//}
//
				//if ((Right_Rear_Display.Press_St == 2) || (Right_Rear_Display.Press_St == 1) || (Right_Rear_Display.Temp_St == 1) ||
				//	(Right_Rear_Display.Fast_Press == 1) || (Right_Rear_Display.BatLow_St == 1) || (Right_Rear_Display.System_Flt == 3) ||
				//	(Right_Rear_Display.Sensor_Flt == 1) || (Right_Rear_Display.Sensor_Loss == 1))
				//{
				//	Right_Rear_Display.TPMS_Blink = FLASH_SYNC_1Hz;
				//}
				//else
				//{
				//	Right_Rear_Display.TPMS_Blink = 1;
				//}

				Right_Rear_Inside_Display.Press_St = TPMS_Info.Press_St;
				Right_Rear_Inside_Display.Temp_St = TPMS_Info.Temp_St;
				Right_Rear_Inside_Display.Fast_Press = TPMS_Info.Fast_Press;
				Right_Rear_Inside_Display.BatLow_St = TPMS_Info.BatLow_St;
				Right_Rear_Inside_Display.System_Flt = TPMS_Info.System_Flt;
				Right_Rear_Inside_Display.Sensor_Flt = TPMS_Info.Sensor_Flt;
				Right_Rear_Inside_Display.Sensor_Loss = TPMS_Info.Sensor_Loss;

				if ((Right_Rear_Inside_Display.Press_St == 2) || (Right_Rear_Inside_Display.Press_St == 1) || (Right_Rear_Inside_Display.Temp_St == 1) ||
					(Right_Rear_Inside_Display.Fast_Press == 1) || (Right_Rear_Inside_Display.BatLow_St == 1) || (Right_Rear_Inside_Display.System_Flt == 3) ||
					(Right_Rear_Inside_Display.Sensor_Flt == 1) || (Right_Rear_Inside_Display.Sensor_Loss == 1))
				{
					Right_Rear_Inside_Display.TPMS_Blink = FLASH_SYNC_1Hz;
				}
				else
				{
					Right_Rear_Inside_Display.TPMS_Blink = 1;
				}
			}
			if (TPMS_Info.Wheel_ID == 0x2A) // �Һ�
			{
				if (TPMS_Info.Press_Valid == 1)
				{
					Right_Rear_Display.Press_Valid = 1;
					Right_Rear_Display.Press_Value = TPMS_Info.Press_Value;
				}
				else
				{
					Right_Rear_Display.Press_Valid = 0;
				}

				if (TPMS_Info.Temp_Valid == 1)
				{
					Right_Rear_Display.Temp_Valid = 1;
					Right_Rear_Display.Temp_Value = TPMS_Info.Temp_Value;
					Right_Rear_Display.Temp_Symbol = TPMS_Info.Temp_Symbol;
				}
				else
				{
					Right_Rear_Display.Temp_Valid = 0;
					Right_Rear_Display.Temp_Symbol = Positive;
				}

				if((TPMS_Info.System_Flt == 3)||(TPMS_Info.Sensor_Loss == 1))
				{
					Right_Rear_Display.Press_Valid = 0;
					Right_Rear_Display.Temp_Valid = 0;
				}

				//if ((Left_Front_Display.Press_St == 2) || (Left_Front_Display.Press_St == 1) || (Left_Front_Display.Temp_St == 1) ||
				//	(Left_Front_Display.Fast_Press == 1) || (Left_Front_Display.BatLow_St == 1) || (Left_Front_Display.System_Flt == 3) ||
				//	(Left_Front_Display.Sensor_Flt == 1) || (Left_Front_Display.Sensor_Loss == 1))
				//{
				//	Left_Front_Display.TPMS_Blink = FLASH_SYNC_1Hz;
				//}
				//else
				//{
				//	Left_Front_Display.TPMS_Blink = 1;
				//}
//
				//if ((Left_Rear_Display.Press_St == 2) || (Left_Rear_Display.Press_St == 1) || (Left_Rear_Display.Temp_St == 1) ||
				//	(Left_Rear_Display.Fast_Press == 1) || (Left_Rear_Display.BatLow_St == 1) || (Left_Rear_Display.System_Flt == 3) ||
				//	(Left_Rear_Display.Sensor_Flt == 1) || (Left_Rear_Display.Sensor_Loss == 1))
				//{
				//	Left_Rear_Display.TPMS_Blink = FLASH_SYNC_1Hz;
				//}
				//else
				//{
				//	Left_Rear_Display.TPMS_Blink = 1;
				//}
//
				//if ((Left_Rear_Inside_Display.Press_St == 2) || (Left_Rear_Inside_Display.Press_St == 1) || (Left_Rear_Inside_Display.Temp_St == 1) ||
				//	(Left_Rear_Inside_Display.Fast_Press == 1) || (Left_Rear_Inside_Display.BatLow_St == 1) || (Left_Rear_Inside_Display.System_Flt == 3) ||
				//	(Left_Rear_Inside_Display.Sensor_Flt == 1) || (Left_Rear_Inside_Display.Sensor_Loss == 1))
				//{
				//	Left_Rear_Inside_Display.TPMS_Blink = FLASH_SYNC_1Hz;
				//}
				//else
				//{
				//	Left_Rear_Inside_Display.TPMS_Blink = 1;
				//}
//
				//if ((Right_Front_Display.Press_St == 2) || (Right_Front_Display.Press_St == 1) || (Right_Front_Display.Temp_St == 1) ||
				//	(Right_Front_Display.Fast_Press == 1) || (Right_Front_Display.BatLow_St == 1) || (Right_Front_Display.System_Flt == 3) ||
				//	(Right_Front_Display.Sensor_Flt == 1) || (Right_Front_Display.Sensor_Loss == 1))
				//{
				//	Right_Front_Display.TPMS_Blink = FLASH_SYNC_1Hz;
				//}
				//else
				//{
				//	Right_Front_Display.TPMS_Blink = 1;
				//}
//
				//if ((Right_Rear_Inside_Display.Press_St == 2) || (Right_Rear_Inside_Display.Press_St == 1) || (Right_Rear_Inside_Display.Temp_St == 1) ||
				//	(Right_Rear_Inside_Display.Fast_Press == 1) || (Right_Rear_Inside_Display.BatLow_St == 1) || (Right_Rear_Inside_Display.System_Flt == 3) ||
				//	(Right_Rear_Inside_Display.Sensor_Flt == 1) || (Right_Rear_Inside_Display.Sensor_Loss == 1))
				//{
				//	Right_Rear_Inside_Display.TPMS_Blink = FLASH_SYNC_1Hz;
				//}
				//else
				//{
				//	Right_Rear_Inside_Display.TPMS_Blink = 1;
				//}

				Right_Rear_Display.Press_St = TPMS_Info.Press_St;
				Right_Rear_Display.Temp_St = TPMS_Info.Temp_St;
				Right_Rear_Display.Fast_Press = TPMS_Info.Fast_Press;
				Right_Rear_Display.BatLow_St = TPMS_Info.BatLow_St;
				Right_Rear_Display.System_Flt = TPMS_Info.System_Flt;
				Right_Rear_Display.Sensor_Flt = TPMS_Info.Sensor_Flt;
				Right_Rear_Display.Sensor_Loss = TPMS_Info.Sensor_Loss;

				if ((Right_Rear_Display.Press_St == 2) || (Right_Rear_Display.Press_St == 1) || (Right_Rear_Display.Temp_St == 1) ||
					(Right_Rear_Display.Fast_Press == 1) || (Right_Rear_Display.BatLow_St == 1) || (Right_Rear_Display.System_Flt == 3) ||
					(Right_Rear_Display.Sensor_Flt == 1) || (Right_Rear_Display.Sensor_Loss == 1))
				{
					Right_Rear_Display.TPMS_Blink = FLASH_SYNC_1Hz;
				}
				else
				{
					Right_Rear_Display.TPMS_Blink = 1;
				}
			}

			if ((TPMS_Info.Wheel_ID == 0x17) || (TPMS_Info.Wheel_ID == 0x19) || (TPMS_Info.Wheel_ID == 0x26) ||
				(TPMS_Info.Wheel_ID == 0x27) || (TPMS_Info.Wheel_ID == 0x29) || (TPMS_Info.Wheel_ID == 0x2A))
				{
					if (TPMS_Info.Wheel_ID == 0x17)
					{
						;
					}
					else
					{
						if ((Left_Front_Display.Press_St == 2) || (Left_Front_Display.Press_St == 1) || (Left_Front_Display.Temp_St == 1) ||
							(Left_Front_Display.Fast_Press == 1) || (Left_Front_Display.BatLow_St == 1) || (Left_Front_Display.System_Flt == 3) ||
							(Left_Front_Display.Sensor_Flt == 1) || (Left_Front_Display.Sensor_Loss == 1))
							{
								Left_Front_Display.TPMS_Blink = FLASH_SYNC_1Hz;
							}
							else
							{
								Left_Front_Display.TPMS_Blink = 1;
							}
					}

					if (TPMS_Info.Wheel_ID == 0x19)
					{
						;
					}
					else
					{
						if ((Left_Rear_Display.Press_St == 2) || (Left_Rear_Display.Press_St == 1) || (Left_Rear_Display.Temp_St == 1) ||
							(Left_Rear_Display.Fast_Press == 1) || (Left_Rear_Display.BatLow_St == 1) || (Left_Rear_Display.System_Flt == 3) ||
							(Left_Rear_Display.Sensor_Flt == 1) || (Left_Rear_Display.Sensor_Loss == 1))
							{
								Left_Rear_Display.TPMS_Blink = FLASH_SYNC_1Hz;
							}
							else
							{
								Left_Rear_Display.TPMS_Blink = 1;
							}
					}

					if (TPMS_Info.Wheel_ID == 0x26)
					{
						;
					}
					else
					{
						if ((Left_Rear_Inside_Display.Press_St == 2) || (Left_Rear_Inside_Display.Press_St == 1) || (Left_Rear_Inside_Display.Temp_St == 1) ||
							(Left_Rear_Inside_Display.Fast_Press == 1) || (Left_Rear_Inside_Display.BatLow_St == 1) || (Left_Rear_Inside_Display.System_Flt == 3) ||
							(Left_Rear_Inside_Display.Sensor_Flt == 1) || (Left_Rear_Inside_Display.Sensor_Loss == 1))
							{
								Left_Rear_Inside_Display.TPMS_Blink = FLASH_SYNC_1Hz;
							}
							else
							{
								Left_Rear_Inside_Display.TPMS_Blink = 1;
							}
					}

					if (TPMS_Info.Wheel_ID == 0x27)
					{
						;
					}
					else
					{
						if ((Right_Front_Display.Press_St == 2) || (Right_Front_Display.Press_St == 1) || (Right_Front_Display.Temp_St == 1) ||
							(Right_Front_Display.Fast_Press == 1) || (Right_Front_Display.BatLow_St == 1) || (Right_Front_Display.System_Flt == 3) ||
							(Right_Front_Display.Sensor_Flt == 1) || (Right_Front_Display.Sensor_Loss == 1))
							{
								Right_Front_Display.TPMS_Blink = FLASH_SYNC_1Hz;
							}
							else
							{
								Right_Front_Display.TPMS_Blink = 1;
							}
					}	

					if (TPMS_Info.Wheel_ID == 0x29)
					{
						;
					}
					else
					{
						if ((Right_Rear_Inside_Display.Press_St == 2) || (Right_Rear_Inside_Display.Press_St == 1) || (Right_Rear_Inside_Display.Temp_St == 1) ||
							(Right_Rear_Inside_Display.Fast_Press == 1) || (Right_Rear_Inside_Display.BatLow_St == 1) || (Right_Rear_Inside_Display.System_Flt == 3) ||
							(Right_Rear_Inside_Display.Sensor_Flt == 1) || (Right_Rear_Inside_Display.Sensor_Loss == 1))
							{
								Right_Rear_Inside_Display.TPMS_Blink = FLASH_SYNC_1Hz;
							}
							else
							{
								Right_Rear_Inside_Display.TPMS_Blink = 1;
							}
					}

					if (TPMS_Info.Wheel_ID == 0x2A)
					{
						;
					}
            		else
					{
						if ((Right_Rear_Display.Press_St == 2) || (Right_Rear_Display.Press_St == 1) || (Right_Rear_Display.Temp_St == 1) ||
							(Right_Rear_Display.Fast_Press == 1) || (Right_Rear_Display.BatLow_St == 1) || (Right_Rear_Display.System_Flt == 3) ||
							(Right_Rear_Display.Sensor_Flt == 1) || (Right_Rear_Display.Sensor_Loss == 1))
							{
								Right_Rear_Display.TPMS_Blink = FLASH_SYNC_1Hz;
							}
							else
							{
								Right_Rear_Display.TPMS_Blink = 1;
							}
					}
				}
			

			if ((TPMS_Info.Wheel_ID != 0x17) && (TPMS_Info.Wheel_ID != 0x19) && (TPMS_Info.Wheel_ID != 0x26) &&
				(TPMS_Info.Wheel_ID != 0x27) && (TPMS_Info.Wheel_ID != 0x29) && (TPMS_Info.Wheel_ID != 0x2A))
			{
				Left_Front_Display.TPMS_Blink = 1;
				Left_Front_Display.TPMS_Blink = 1;
				Left_Rear_Display.TPMS_Blink = 1;
				Left_Rear_Inside_Display.TPMS_Blink = 1;
				Right_Front_Display.TPMS_Blink = 1;
				Right_Rear_Display.TPMS_Blink = 1;
				Right_Rear_Inside_Display.TPMS_Blink = 1;

				Left_Front_Display.Press_St = 0;
				Left_Front_Display.Temp_St = 0;
				Left_Front_Display.Fast_Press = 0;
				Left_Front_Display.BatLow_St = 0;
				Left_Front_Display.System_Flt = 0;
				Left_Front_Display.Sensor_Flt = 0;
				Left_Front_Display.Sensor_Loss = 0;

				Left_Rear_Display.Press_St = 0;
				Left_Rear_Display.Temp_St = 0;
				Left_Rear_Display.Fast_Press = 0;
				Left_Rear_Display.BatLow_St = 0;
				Left_Rear_Display.System_Flt = 0;
				Left_Rear_Display.Sensor_Flt = 0;
				Left_Rear_Display.Sensor_Loss = 0;

				Left_Rear_Inside_Display.Press_St = 0;
				Left_Rear_Inside_Display.Temp_St = 0;
				Left_Rear_Inside_Display.Fast_Press = 0;
				Left_Rear_Inside_Display.BatLow_St = 0;
				Left_Rear_Inside_Display.System_Flt = 0;
				Left_Rear_Inside_Display.Sensor_Flt = 0;
				Left_Rear_Inside_Display.Sensor_Loss = 0;

				Right_Front_Display.Press_St = 0;
				Right_Front_Display.Temp_St = 0;
				Right_Front_Display.Fast_Press = 0;
				Right_Front_Display.BatLow_St = 0;
				Right_Front_Display.System_Flt = 0;
				Right_Front_Display.Sensor_Flt = 0;
				Right_Front_Display.Sensor_Loss = 0;

				Right_Rear_Inside_Display.Press_St = 0;
				Right_Rear_Inside_Display.Temp_St = 0;
				Right_Rear_Inside_Display.Fast_Press = 0;
				Right_Rear_Inside_Display.BatLow_St = 0;
				Right_Rear_Inside_Display.System_Flt = 0;
				Right_Rear_Inside_Display.Sensor_Flt = 0;
				Right_Rear_Inside_Display.Sensor_Loss = 0;

				Right_Rear_Display.Press_St = 0;
				Right_Rear_Display.Temp_St = 0;
				Right_Rear_Display.Fast_Press = 0;
				Right_Rear_Display.BatLow_St = 0;
				Right_Rear_Display.System_Flt = 0;
				Right_Rear_Display.Sensor_Flt = 0;
				Right_Rear_Display.Sensor_Loss = 0;
			}
		}
		else // ����
		{
			Left_Front_Display.Press_Valid = 0;
			Left_Rear_Display.Press_Valid = 0;
			Left_Rear_Inside_Display.Press_Valid = 0;
			Right_Front_Display.Press_Valid = 0;
			Right_Rear_Display.Press_Valid = 0;
			Right_Rear_Inside_Display.Press_Valid = 0;

			Left_Front_Display.Temp_Valid = 0;
			Left_Rear_Display.Temp_Valid = 0;
			Left_Rear_Inside_Display.Temp_Valid = 0;
			Right_Front_Display.Temp_Valid = 0;
			Right_Rear_Display.Temp_Valid = 0;
			Right_Rear_Inside_Display.Temp_Valid = 0;

			Left_Front_Display.Temp_Symbol = 0;
			Left_Rear_Display.Temp_Symbol = 0;
			Left_Rear_Inside_Display.Temp_Symbol = 0;
			Right_Front_Display.Temp_Symbol = 0;
			Right_Rear_Display.Temp_Symbol = 0;
			Right_Rear_Inside_Display.Temp_Symbol = 0;

			Left_Front_Display.Temp_Value = 0;
			Left_Rear_Display.Temp_Value = 0;
			Left_Rear_Inside_Display.Temp_Value = 0;
			Right_Front_Display.Temp_Value = 0;
			Right_Rear_Display.Temp_Value = 0;
			Right_Rear_Inside_Display.Temp_Value = 0;

			Left_Front_Display.TPMS_Blink = 1;
			Left_Front_Display.TPMS_Blink = 1;
			Left_Rear_Display.TPMS_Blink = 1;
			Left_Rear_Inside_Display.TPMS_Blink = 1;
			Right_Front_Display.TPMS_Blink = 1;
			Right_Rear_Display.TPMS_Blink = 1;
			Right_Rear_Inside_Display.TPMS_Blink = 1;

			Left_Front_Display.Press_St = 0;
			Left_Front_Display.Temp_St = 0;
			Left_Front_Display.Fast_Press = 0;
			Left_Front_Display.BatLow_St = 0;
			Left_Front_Display.System_Flt = 0;
			Left_Front_Display.Sensor_Flt = 0;
			Left_Front_Display.Sensor_Loss = 0;

			Left_Rear_Display.Press_St = 0;
			Left_Rear_Display.Temp_St = 0;
			Left_Rear_Display.Fast_Press = 0;
			Left_Rear_Display.BatLow_St = 0;
			Left_Rear_Display.System_Flt = 0;
			Left_Rear_Display.Sensor_Flt = 0;
			Left_Rear_Display.Sensor_Loss = 0;

			Left_Rear_Inside_Display.Press_St = 0;
			Left_Rear_Inside_Display.Temp_St = 0;
			Left_Rear_Inside_Display.Fast_Press = 0;
			Left_Rear_Inside_Display.BatLow_St = 0;
			Left_Rear_Inside_Display.System_Flt = 0;
			Left_Rear_Inside_Display.Sensor_Flt = 0;
			Left_Rear_Inside_Display.Sensor_Loss = 0;

			Right_Front_Display.Press_St = 0;
			Right_Front_Display.Temp_St = 0;
			Right_Front_Display.Fast_Press = 0;
			Right_Front_Display.BatLow_St = 0;
			Right_Front_Display.System_Flt = 0;
			Right_Front_Display.Sensor_Flt = 0;
			Right_Front_Display.Sensor_Loss = 0;

			Right_Rear_Inside_Display.Press_St = 0;
			Right_Rear_Inside_Display.Temp_St = 0;
			Right_Rear_Inside_Display.Fast_Press = 0;
			Right_Rear_Inside_Display.BatLow_St = 0;
			Right_Rear_Inside_Display.System_Flt = 0;
			Right_Rear_Inside_Display.Sensor_Flt = 0;
			Right_Rear_Inside_Display.Sensor_Loss = 0;

			Right_Rear_Display.Press_St = 0;
			Right_Rear_Display.Temp_St = 0;
			Right_Rear_Display.Fast_Press = 0;
			Right_Rear_Display.BatLow_St = 0;
			Right_Rear_Display.System_Flt = 0;
			Right_Rear_Display.Sensor_Flt = 0;
			Right_Rear_Display.Sensor_Loss = 0;
		}
	}
	else // igoff
	{
	}
	//	}
	//	else
	/*	{
		   TPMS_Info.TPMS_Valid = 0;
		   TPMS_Info.Press_Valid = 0;
		   TPMS_Info.Temp_Valid = 0;
		   TPMS_Info.Temp_Symbol = Positive;
		   TPMS_Info.Wheel_ID = 0;
		   TPMS_Info.Temp_Value = 0;
		   TPMS_Info.Press_Value = 0;

		   Left_Front_Display.Press_Valid = 0;
		   Left_Rear_Display.Press_Valid = 0;
		   Left_Rear_Inside_Display.Press_Valid = 0;
		   Right_Front_Display.Press_Valid = 0;
		   Right_Rear_Display.Press_Valid = 0;
		   Right_Rear_Inside_Display.Press_Valid = 0;

		   Left_Front_Display.Temp_Symbol = 0;
		   Left_Rear_Display.Temp_Symbol = 0;
		   Left_Rear_Inside_Display.Temp_Symbol = 0;
		   Right_Front_Display.Temp_Symbol = 0;
		   Right_Rear_Display.Temp_Symbol = 0;
		   Right_Rear_Inside_Display.Temp_Symbol = 0;

		   Left_Front_Display.TPMS_Blink = 1;
		   Left_Rear_Display.TPMS_Blink = 1;
		   Left_Rear_Inside_Display.TPMS_Blink = 1;
		   Right_Front_Display.TPMS_Blink = 1;
		   Right_Rear_Display.TPMS_Blink = 1;
		   Right_Rear_Inside_Display.TPMS_Blink = 1;
	   }     */
}

void Data_Drive_Info_Group1_Processing_Service(void)
{
	RTC_TIME_Processing_Service();
	 Data_Coolant_Temp_Processing_Service();
	// Data_Instantaneous_Fuel_Service();
	// Data_Avg_Fuel_Service() ;
	
	Data_EnergyRecovery_Processing_Service();
	
	Data_Cruise_Processing_Service();
	// Data_TripA_Average_Vspeed_Service();

	Data_Driving_Time_Processing();
	Data_IGN_Off_Timing_Service();
	Data_Service_Interval_Processing();
	Data_TPMS_Value_Processing();

	//Data_SOC_Processing_Service();
	Data_AC_Temp_Processing_Service();
	
	Data_AvgSpeed_Processing_Service();
}
void Data_Drive_Info_Group2_Processing_Service(void)
{
	// Data_Oil_Press_Service();
	// Data_Urea_Level_Service();
	Data_ChgTimeRemain_Service();
	Data_AirPress_Front_Processing();
	Data_AirPress_Rear_Processing();
}

void Data_Drive_Info_Group3_Processing_Service(void)
{
	//	Data_PDC_Service();
	//	Data_LDW_Service();
	Data_Gear_Processing_Service();
	Data_DriveMode_Processing_Service();
	Data_DoorOpen_Service();
	Data_SafeBelt_Status_Service();
	Data_Charge_Status_Service();
	Geely_ClearOdo_Processing();
	Data_Language_Set_Service();
}
