#include "Voice_Play_Buzzer.h"

///////////˳////////////////////////////////////////////////////////
typedef enum
{
	Buzzer_Leisure = 0,
	Buzzer_Charge,		   //
	Buzzer_Charge_Waiting, // ȴ

	Buzzer_Play_ON,			//
	Buzzer_Play_ON_Waiting, //  ȴ

	Buzzer_Fade,		 //
	Buzzer_Fade_Waiting, //  ȴ
} _BuzzerStep;

//岥ſƽṹ
typedef struct
{
	INT8U Buzzer_Variety_Index; //ݵǰűӦԴţԴԱе
	INT8U BuzzerAlarmIndex;		//_SoundAlarm   //ǰŵı//ʹĶԱȾǷֹͣ
	INT16U BuzzerTimeCount;		//ʱʱ    //Ͳʱļʱ

	INT8U Buzzer_Syllable_Count; //ڼ
	INT8U Buzzer_Syllable_MAX;   //ǰŵ 

} _BuzzerAlarmInfor;

_BuzzerAlarmInfor BuzzerAlarmCurrent; //岥ʱƱ
INT8U Buzzer_Alarm_MAX_Num = 0;		  //ⲿ
//ⲿ//˫Դ//ֵ뵥ڵĵһ
INT8U Buzzer_Single_Syllable_First = 0;
INT8U Buzzer_Step = Buzzer_Leisure; //ŲƱ

/////////////////////////////////////////////////Ųֿʼ//////////////////////////////////////////////////////////////////
//ʱִеĲ//ⲿ
//ǿִز//ǵǰǷڲ//ⲿ
//ʱãʱʱر
void Buzzer_Play_Sleep(void)
{
	Buzzer_Positive_Enable(0);
	//Buzzer_Negative_Set_Duty(0);
	Buzzer_Negative_Enable(0);
}
//صǰ״̬
//0״ִ̬߶//㣬ڲĳԴִ߶
INT8U Buzzer_Get_PlayStatus(void)
{
	return Buzzer_Step;
}
//سʼ//״ϵһμ
//MAX_NUM //ⲿ
//Single_First//ⲿ//˫Դ//ֵ뵥ڵĵһ
void Buzzer_Play_Init(_SoundAlarm MAX_NUM, _BuzzerVariety Single_First)
{

	Buzzer_Alarm_MAX_Num = MAX_NUM; //ⲿ
	//ⲿ//˫Դ//ֵ뵥ڵĵһ
	Buzzer_Single_Syllable_First = Single_First;

	Buzzer_Step = Buzzer_Leisure; //ŲƱ

	BuzzerAlarmCurrent.BuzzerAlarmIndex = Buzzer_Alarm_MAX_Num;
	BuzzerAlarmCurrent.BuzzerTimeCount = 0;
	BuzzerAlarmCurrent.Buzzer_Variety_Index = Buzzer_Variety_MAX + Buzzer_Single_Syllable_First;
	BuzzerAlarmCurrent.Buzzer_Syllable_MAX = 0;
	BuzzerAlarmCurrent.Buzzer_Syllable_Count = 0;
}
///żʱ ʱ//һξʹ
void Buzzer_Play_Time_Count(INT8U Time_NUM)
{
	if (BuzzerAlarmCurrent.BuzzerTimeCount < (65530 - Time_NUM)) //65536
	{
		BuzzerAlarmCurrent.BuzzerTimeCount += Time_NUM;
	}
}

//˸ĵͬ//źţ
//ź//Ҫŵı//PWMʼ֮󷽿ɵ
void Buzzer_Play_Handle(_SoundAlarm SoundAlarmNew)
{
	switch (Buzzer_Step)
	{
	case Buzzer_Leisure:
	{
		//ִеʱ֮ǰŶ϶˲LOOPı
		//ôʱıĸ֮ǰŵ಻ֻͬҪЧִ
		if (SoundAlarmNew < Buzzer_Alarm_MAX_Num) //ǿ
		{
			Buzzer_Step = Buzzer_Charge;
		}
		else
		{
			break;
		}

		BuzzerAlarmCurrent.BuzzerAlarmIndex = SoundAlarmNew;
		BuzzerAlarmCurrent.BuzzerTimeCount = 0;
		BuzzerAlarmCurrent.Buzzer_Syllable_Count = 0;
		//
		//˫ԴӦԱеԪ
		if (BuzzerAlarmVarietyInforTable[BuzzerAlarmCurrent.BuzzerAlarmIndex].Variety < Buzzer_Single_Syllable_First)
		{
			BuzzerAlarmCurrent.Buzzer_Syllable_MAX = 2;
			BuzzerAlarmCurrent.Buzzer_Variety_Index = BuzzerAlarmVarietyInforTable[BuzzerAlarmCurrent.BuzzerAlarmIndex].Variety * 2;
		}
		else //ԴӦԱеԪ
		{
			BuzzerAlarmCurrent.Buzzer_Syllable_MAX = 1;
			BuzzerAlarmCurrent.Buzzer_Variety_Index = BuzzerAlarmVarietyInforTable[BuzzerAlarmCurrent.BuzzerAlarmIndex].Variety + Buzzer_Single_Syllable_First;
		}
	}
	case Buzzer_Charge:
	{

		INT16U Fre_buf = 0;
		Buzzer_Negative_Enable(0);
		Buzzer_Positive_Enable(1);

		Fre_buf = BuzzerAttribute[BuzzerAlarmCurrent.Buzzer_Variety_Index + BuzzerAlarmCurrent.Buzzer_Syllable_Count].Frequency;

		Buzzer_Negative_Set_Frequency(Fre_buf);
		Buzzer_Negative_Set_Duty(50);
		Buzzer_Step = Buzzer_Charge_Waiting;
		//break; //ʱ㣬ôͲضִһθúִеӦ
	}
	case Buzzer_Charge_Waiting:
	{
		if (BuzzerAlarmCurrent.BuzzerTimeCount >= BuzzerAttribute[BuzzerAlarmCurrent.Buzzer_Variety_Index + BuzzerAlarmCurrent.Buzzer_Syllable_Count].Charge_Time)
		{
			BuzzerAlarmCurrent.BuzzerTimeCount = 0;
			Buzzer_Step = Buzzer_Play_ON;
		}
		else
		{
			break;
		}
	}

	case Buzzer_Play_ON:
	{
		Buzzer_Negative_Enable(1);
		//Buzzer_Positive_Enable(1);//ʱѾ
		Buzzer_Play_Start(BuzzerAlarmCurrent.BuzzerAlarmIndex);
		Buzzer_Step = Buzzer_Play_ON_Waiting;
		//break;//ʱΪ0ͲضִһθúִеӦ
	}
	case Buzzer_Play_ON_Waiting:
	{
		//
		if (Buzzer_LoopOnTime == BuzzerAttribute[BuzzerAlarmCurrent.Buzzer_Variety_Index + BuzzerAlarmCurrent.Buzzer_Syllable_Count].PlayON_Time)
		{
			//±
			if (BuzzerAlarmCurrent.BuzzerAlarmIndex != SoundAlarmNew)
			{
				BuzzerAlarmCurrent.BuzzerTimeCount = 0;
				Buzzer_Step = Buzzer_Fade;
			}
			else
			{
				break;
			}
		}
		else //ѭŵԴ
		{
			if (BuzzerAlarmCurrent.BuzzerTimeCount >= BuzzerAttribute[BuzzerAlarmCurrent.Buzzer_Variety_Index + BuzzerAlarmCurrent.Buzzer_Syllable_Count].PlayON_Time)
			{
				BuzzerAlarmCurrent.BuzzerTimeCount = 0;
				Buzzer_Step = Buzzer_Fade;
			}
			else
			{
				break;
			}
		}
	}
	case Buzzer_Fade:
	{
		//Buzzer_Negative_Enable(1);
		Buzzer_Positive_Enable(0); //
		Buzzer_Step = Buzzer_Fade_Waiting;
		//break;
	}
	case Buzzer_Fade_Waiting:
	{
		//ʹǳҲжϵʱǷ񵽴
		if (BuzzerAlarmCurrent.BuzzerTimeCount >= BuzzerAttribute[BuzzerAlarmCurrent.Buzzer_Variety_Index + BuzzerAlarmCurrent.Buzzer_Syllable_Count].Fade_Time)
		{
			BuzzerAlarmCurrent.BuzzerTimeCount = 0;
			//ڲɣرշţԱ´ʹ
			Buzzer_Negative_Enable(0);
			//Buzzer_Positive_Enable(0);
			//ڲɣǷҪŵ
			BuzzerAlarmCurrent.Buzzer_Syllable_Count++;
			//ʣҪ
			if (BuzzerAlarmCurrent.Buzzer_Syllable_Count < BuzzerAlarmCurrent.Buzzer_Syllable_MAX)
			{
				Buzzer_Step = Buzzer_Charge;
			}
			else //ڶ
			{
				Buzzer_Step = Buzzer_Leisure;
				Buzzer_Play_Done(BuzzerAlarmCurrent.BuzzerAlarmIndex);

				BuzzerAlarmCurrent.BuzzerAlarmIndex = Buzzer_Alarm_MAX_Num;
				BuzzerAlarmCurrent.Buzzer_Variety_Index = Buzzer_Variety_MAX + Buzzer_Single_Syllable_First;
				BuzzerAlarmCurrent.Buzzer_Syllable_MAX = 0;
				BuzzerAlarmCurrent.Buzzer_Syllable_Count = 0;

				//break; //µøúʱжϵǰҪŵı
			}
		}
		break;
	}

	default:
	{

		Buzzer_Step = Buzzer_Leisure; //ŲƱ

		BuzzerAlarmCurrent.BuzzerAlarmIndex = Buzzer_Alarm_MAX_Num;
		BuzzerAlarmCurrent.BuzzerTimeCount = 0;
		BuzzerAlarmCurrent.Buzzer_Variety_Index = Buzzer_Variety_MAX + Buzzer_Single_Syllable_First;
		BuzzerAlarmCurrent.Buzzer_Syllable_MAX = 0;
		BuzzerAlarmCurrent.Buzzer_Syllable_Count = 0;
		break;
	}
	}
}

/////////////////////////////////////////////////Ųֽ/////////////////////////////////////////////////////////////////
