#ifndef _EOL_Para_H_
#define _EOL_Para_H_

#include "stdint.h"

typedef struct
{
	uint8_t F101_Byte[8u];
} _EOL_F101;


typedef struct
{
	uint8_t F102_Byte[24u];
} _EOL_F102;

typedef struct
{
	uint8_t F110_Byte[8u];
} _EOL_F110;



/*F101*/

/*BYTE0*/
uint8_t Val_EOL_F101_ConfigType(void);
uint8_t Val_EOL_F101_Language(void);
/*BYTE1*/
uint8_t Val_EOL_F101_TPMSType(void);
uint8_t Val_EOL_F101_LDW(void);
uint8_t Val_EOL_F101_Cruise(void);
/*BYTE2*/
uint8_t Val_EOL_F101_EmissionsStandards(void);
uint8_t Val_EOL_F101_FCW_AEB(void);
uint8_t Val_EOL_F101_AverageFuel(void);
/*BYTE3*/
uint8_t Val_EOL_F101_PDC(void);
uint8_t Val_EOL_F101_OTA(void);
uint8_t Val_EOL_F101_AirFilterBlocking(void);
/*BYTE4*/
uint8_t Val_EOL_F101_Break(void);
uint8_t Val_EOL_F101_CollisionSystem(void);
uint8_t Val_EOL_F101_ServiceMaintain(void);
uint8_t Val_EOL_F101_AutoHold(void);
/*BYTE5*/
uint8_t Val_EOL_F101_ASR(void);
uint8_t Val_EOL_F101_LKA(void);
uint8_t Val_EOL_F101_FuelResistanceRange (void);
uint8_t Val_EOL_F101_CruiseSpeed (void);

/*BYTE6*/
uint8_t Val_EOL_F101_ADAS(void);
uint8_t Val_EOL_F101_BrakeSupplier(void);
uint8_t Val_EOL_F101_TransmissionType(void);
uint8_t Val_EOL_F101_baroceptor(void);
uint8_t Val_EOL_F101_Engine(void);
uint8_t Val_EOL_F101_TBOX(void);
uint8_t Val_EOL_F101_Reserved2(void);
/****F102***/

/**byte0*/
uint8_t Val_EOL_F102_WarningEngineCoolantTemperature(void);
/**byte1*/
uint8_t Val_EOL_F102_HEngineCoolantTemperature(void);
/**byte2*/
uint8_t Val_EOL_F102_EFuelSensor(void);
/**byte3*/
uint8_t Val_EOL_F102_EighthFuelSensor(void);
/**byte4*/
uint8_t Val_EOL_F102_QuarterFuelSensor(void);
/**byte5*/
uint8_t Val_EOL_F102_Three8FuelSensor(void);
/**byte6*/
uint8_t Val_EOL_F102_AHalfFuelSensor(void);
/**byte7*/
uint8_t Val_EOL_F102_Five8FuelSensor(void);
/**byte8*/
uint8_t Val_EOL_F102_Three3FuelSensor(void);
/**byte9*/
uint8_t Val_EOL_F102_Seven8FuelSensor(void);
/**byte10*/
uint8_t Val_EOL_F102_FFuelSensor(void);
/**byte11*/
uint8_t Val_EOL_F102_EFuelLevel(void);
/**byte12*/
uint8_t Val_EOL_F102_EighthFuelLevel(void);
/**byte13*/
uint8_t Val_EOL_F102_QuarterFuelLevel(void);
/**byte14*/
uint8_t Val_EOL_F102_Three8FuelLevel(void);
/**byte15*/
uint8_t Val_EOL_F102_AHalfFuelLevel(void);
/**byte16*/
uint8_t Val_EOL_F102_Five8FuelLevel(void);
/**byte17*/
uint8_t Val_EOL_F102_Three4FuelLevel(void);
/**byte18*/
uint8_t Val_EOL_F102_Seven8FuelLevel(void);
/**byte19*/
uint8_t Val_EOL_F102_FFuelLevel(void);
/**byte20*/
uint8_t Val_EOL_F102_FuelAlarm(void);
/****F110***/

/**byte0*/
uint8_t Val_EOL_F110_EMS(void);
uint8_t Val_EOL_F110_BMS(void);
uint8_t Val_EOL_F110_HCM(void);
uint8_t Val_EOL_F110_VCU(void);
uint8_t Val_EOL_F110_MCU(void);
uint8_t Val_EOL_F110_DCDC_24V(void);
uint8_t Val_EOL_F110_DCDC_12V(void);
uint8_t Val_EOL_F110_OBC(void);
/**byte1**/
uint8_t Val_EOL_F110_BDCAC(void);
uint8_t Val_EOL_F110_SDCAC(void);
uint8_t Val_EOL_F110_CCU(void);
uint8_t Val_EOL_F110_GCU(void);
uint8_t Val_EOL_F110_PFGU(void);
uint8_t Val_EOL_F110_DCU(void);
uint8_t Val_EOL_F110_DCU1(void);
uint8_t Val_EOL_F110_Reserved2(void);
/**byte2**/
uint8_t Val_EOL_F110_TCU(void);
uint8_t Val_EOL_F110_EGSM(void);
uint8_t Val_EOL_F110_ESC_L(void);
uint8_t Val_EOL_F110_MGU(void);
uint8_t Val_EOL_F110_DR(void);
uint8_t Val_EOL_F110_HMS(void);
uint8_t Val_EOL_F110_HFCU(void);
uint8_t Val_EOL_F110_EPB_Air(void);
/*byte3**/

uint8_t Val_EOL_F110_ABS(void);
uint8_t Val_EOL_F110_ESC_W(void);
uint8_t Val_EOL_F110_EBS(void);
uint8_t Val_EOL_F110_EPB_Liquid(void);
uint8_t Val_EOL_F110_ACU(void);
uint8_t Val_EOL_F110_SAS(void);
uint8_t Val_EOL_F110_ECAS(void);
uint8_t Val_EOL_F110_EPS(void);
/**BYTE4*/
uint8_t Val_EOL_F110_EPS_A(void);
uint8_t Val_EOL_F110_FCS(void);
uint8_t Val_EOL_F110_FRS(void);
uint8_t Val_EOL_F110_ADAS(void);
uint8_t Val_EOL_F110_ICE(void);
uint8_t Val_EOL_F110_HVB(void);
uint8_t Val_EOL_F110_HVBC(void);
uint8_t Val_EOL_F110_BPTC(void);
/**BYTE5*/


uint8_t Val_EOL_F110_TPMS(void);
uint8_t Val_EOL_F110_PEPS(void);
uint8_t Val_EOL_F110_AC(void);
uint8_t Val_EOL_F110_ACCP(void);
uint8_t Val_EOL_F110_PTC(void);
uint8_t Val_EOL_F110_IPTC(void);
uint8_t Val_EOL_F110_ACCM(void);
uint8_t Val_EOL_F110_MMI(void);
/**BYTE6**/

uint8_t Val_EOL_F110_PDC(void);
uint8_t Val_EOL_F110_AVM(void);
uint8_t Val_EOL_F110_IC(void);
uint8_t Val_EOL_F110_NVS(void);
uint8_t Val_EOL_F110_DMM(void);
uint8_t Val_EOL_F110_Reserved5(void);
uint8_t Val_EOL_F110_DVR(void);
uint8_t Val_EOL_F110_BCM(void);
/**BYTE7**/  

uint8_t Val_EOL_F110_DCM(void);
uint8_t Val_EOL_F110_AVAS(void);
uint8_t Val_EOL_F110_TBOX(void);
uint8_t Val_EOL_F110_GW(void);




/*�������ó�ʼ��*/
void EOL_InitVal(void);
/*������������F101*/
void EOL_SetF101(uint8_t EOL[], uint8_t len);
/*������������F102*/
void EOL_SetF102(uint8_t EOL[], uint8_t len);
/*������������F110*/
void EOL_SetF110(uint8_t EOL[], uint8_t len);
/*��ȡ��������F101*/
_EOL_F101 EOL_GetF101(void);
/*��ȡ��������F102*/
_EOL_F102 EOL_GetF102(void);
/*��ȡ��������F110*/
_EOL_F110 EOL_GetF110(void);

#endif