#include "Include.h"
#include "Popup_Scheduler.h"

_Page_Info_Struct PageInfo;
_Page_Info_Struct DisplayInfor_BackUp;
uint8_t MaskPopupNum = 0u;
uint8_t MaskPopupNum_Backup = 0u;
uint16_t MaskPopupList[70u] = {0u};
uint8_t MaskPopupCurIdx = 0u;
_MenuDispTpmsCtrl_Struct MenuTpmsCtrl;
 _MenuDispTpmsCtrl_Struct MenuTpmsCtrl_Backup;
 OTA_HMI_Ctrl_Struct OTA_Ctrl;
 OTA_HMI_Ctrl_Struct OTA_Ctrl_Backup;
INT8U Popups_SelfCheckTime = 0;

const uint8_t MenuTPMSTgrSts[MenuDispTPMS_Max] = 
{
    0x01,
    0x02,
    0x04,
    0x08,
    0x10,
    0x20,
    0x40,
    0x80,

    0x00,
};

void  Menu_TPMS_Learn_Process(void );
uint8_t Menu_TPMS_Learn_Msg_Process(Menu_Item_en_t curMenu, uint8_t MsgSts, uint8_t LearnLocation, uint8_t LearnSts);
void Menu_TPMS_Learning_Process(Menu_Item_en_t curMenu);

void Page_OFF_TO_ON_Init(void )
{
    PageInfo.PageType = Page_Max;
    PageInfo.u16SelfCheckTimeCnt = 0;
    Popups_SelfCheckTime = 0;
    MenuTpmsCtrl.DispTimeCnt = 0;
    MenuTpmsCtrl.MenuCurTpmsSts = MenuDispTPMS_Normal;
    //LDW_PriDisp_Sts = 0;
    RADAR_PriDisp_Sts = 0;
}

void Page_30KL_Init(void )
{
    uint8_t i;
    PageInfo.PageType = Page_Max;
    PageInfo.u16SelfCheckTimeCnt = 0;
    Popups_SelfCheckTime = 0;
    //LDW_PriDisp_Sts = 0;
    RADAR_PriDisp_Sts = 0;
     
     for(i= 0; i<70;i++)
     {
     	MaskPopupList[i] = 0xffff;	
     }
    
}



void Page_Manage_Service(void )
{
    if(SYS_OPR_STAT_HALT)
    {
//	Page_OFF_TO_ON_Init();    
	PageInfo.PageType = Page_Max;
    	return;
    }
    
 
    if(OTA_Ctrl.CurHMI < OTA_HMI_Max)
    {
        PageInfo.PageType = Page_OTA;
    }
    else
    {
	    if(SYS_OPR_STAT_IGN_ON)
	    {
            if(Popups_SelfCheckTime < SelfCheckTime)
            {
                Popups_SelfCheckTime++;
            }
	        if(PageInfo.u16SelfCheckTimeCnt <  SelfCheckTime)
	        {
	            PageInfo.u16SelfCheckTimeCnt++;
	            PageInfo.PageType = Page_Menu;
	        }
	        else
	       {
	            if(PopupAlarm < POPUP_MSG_MAX )
	            {
	                PageInfo.PageType = Page_Alarm;
	            }
	            else
	            {
	                PageInfo.PageType = Page_Menu;
	            }
	        }
	    }
	    else
	    {
	            //PageInfo.u16SelfCheckTimeCnt = 0;
	            if(PopupAlarm < POPUP_MSG_MAX )
	            {
	                if(PopupAlarm == POPUP_MSG_DoorOpen)
	                {
	                    if(DoorOpen.u16OffTimer >= 300)
	                    {
	                        PageInfo.PageType = Page_Max ;
	                    }
	                    else
	                    {
	                        PageInfo.PageType = Page_Alarm;		
	                    }
	                }
	                else
	                {
	                	PageInfo.PageType = Page_Alarm;		
	                }
	            }
	            else
	            {
	                PageInfo.PageType = Page_Max;
	            }
	    }
    }
}


//uint8_t LDW_PriDisp_Sts = 0;
uint8_t RADAR_PriDisp_Sts = 0;
void Page_Manage_KeyCrl_Service(_Page_Key_Value_Enum key )
{
    Menu_Item_en_t menu = Menu_Get_Current_Cursor_Information();
    uint8_t tmpsLenSts = 0;
    uint8_t VechSpeedExist = 0;

    if(PageInfo.PageType == Page_OTA)
    {
        if((Val_EOL_F110_MMI() == 0)&&(Val_EOL_F110_TBOX() == 1)&&(Val_EOL_F101_OTA() == 1))
        {
            if (key == KEY_Enter_Short)
            {
                switch (OTA_Ctrl.CurHMI)
                {
                    case OTA_HMI_2:
                    case OTA_HMI_4:
                    {
                        if (OTA_Ctrl.Cursor == OTA_HMI_CURSOR_Confirm)
                        {
                            IC_OTA.IC_OTA_DownloadSelected = 0x02;
                        }
                        else if (OTA_Ctrl.Cursor == OTA_HMI_CURSOR_Concel)
                        {
                            IC_OTA.IC_OTA_DownloadSelected = 0x01;
                        }
                        IC_OTA.IC_OTA_DownloadSelected_Cnt = 3;
                        Can_Msg_Tx_Overwrite(&CAN_CH0_CanMsgTxOp, IC_18FF4117_Msg_Count, 3, 20000UL);
                        break;
                    }
                    case OTA_HMI_3:
                    {
                        IC_OTA.IC_OTA_DownloadSelected = 0x01;
                        IC_OTA.IC_OTA_DownloadSelected_Cnt = 3;
                        Can_Msg_Tx_Overwrite(&CAN_CH0_CanMsgTxOp, IC_18FF4117_Msg_Count, 3, 20000UL);
                        break;
                    }
                    case OTA_HMI_5:
                    {
                        if (OTA_Ctrl.Cursor == OTA_HMI_CURSOR_Confirm)
                        {
                            IC_OTA.IC_OTA_UpdateSelected = 0x02;
                        }
                        else if (OTA_Ctrl.Cursor == OTA_HMI_CURSOR_Concel)
                        {
                            IC_OTA.IC_OTA_UpdateSelected = 0x01;
                        }
                        IC_OTA.IC_OTA_UpdateSelected_Cnt = 3;
                        Can_Msg_Tx_Overwrite(&CAN_CH0_CanMsgTxOp, IC_18FF4117_Msg_Count, 3, 20000UL);
                        break;
                    }
                    case OTA_HMI_6:
                    {
                        if (OTA_Ctrl.Cursor == OTA_HMI_CURSOR_Confirm)
                        {
                            IC_OTA.IC_OTA_DeclimerSelected = 0x02;
                        }
                        else if (OTA_Ctrl.Cursor == OTA_HMI_CURSOR_Concel)
                        {
                            IC_OTA.IC_OTA_DeclimerSelected = 0x01;
                        }
                        IC_OTA.IC_OTA_DeclimerSelected_Cnt = 3;
                        Can_Msg_Tx_Overwrite(&CAN_CH0_CanMsgTxOp, IC_18FF4117_Msg_Count, 3, 20000UL);
                        break;
                    }
                    case OTA_HMI_7_PowerMode:
                    case OTA_HMI_7_GearPos:
                    case OTA_HMI_7_VehicleSpd:
                    case OTA_HMI_7_BattVol:
                    case OTA_HMI_7_HandBrake:
                    case OTA_HMI_7_ChgStatus:
                    case OTA_HMI_7_HVStatus:
                    {
                        IC_OTA.IC_OTA_UpdateSelected = 0x01;
                        IC_OTA.IC_OTA_UpdateSelected_Cnt = 3;
                        Can_Msg_Tx_Overwrite(&CAN_CH0_CanMsgTxOp, IC_18FF4117_Msg_Count, 3, 20000UL);
                        break;
                    }
                    case OTA_HMI_10:
                    case OTA_HMI_11:
                    {
                        IC_OTA.IC_OTA_UpdateResultConfirm = 0x01;
                        IC_OTA.IC_OTA_UpdateResultConfirm_Cnt = 3;
                        Can_Msg_Tx_Overwrite(&CAN_CH0_CanMsgTxOp, IC_18FF4117_Msg_Count, 3, 20000UL);
                        break;
                    }
                    default:
                    {
                        break;
                    }
                }
            }
            else if (key == KEY_Left || KEY_Right == key)
            {
                if (OTA_Ctrl.CursorNum == 2)
                {
                    if (OTA_Ctrl.Cursor == OTA_HMI_CURSOR_Confirm)
                    {
                        OTA_Ctrl.Cursor = OTA_HMI_CURSOR_Concel;
                    }
                    else if (OTA_Ctrl.Cursor == OTA_HMI_CURSOR_Concel)
                    {
                        OTA_Ctrl.Cursor = OTA_HMI_CURSOR_Confirm;
                    }
                }
            }
        }
        
    }
    else if(PageInfo.PageType == Page_Alarm)
    {
        if(key == KEY_Enter_Short)
        {
        		Popup_Mask_Request(); 
        		PageInfo.PageType == Page_Menu;   
        }
        else
        {

        }
    }
    else if(PageInfo.PageType == Page_Menu)
    {
        if((PDC_Sts.RL == PDC_NoDisplay)&&(PDC_Sts.MID == PDC_NoDisplay)&&(PDC_Sts.RR == PDC_NoDisplay))
        {
            if(menu == MENU_ITEM_ECU_RADAR)
            {
                Menu_Change_Branch_To_Item(MENU_BRANCH_MENUE, MENU_ITEM_ECU_AvgELC);
            }
            else
            {
            }
	  
            if(Menu_Item_Select_Get(MENU_ITEM_ECU_RADAR) == 1)
            {
                MENU_Intf_Inside_Item_Select_Set(MENU_ITEM_ECU_AvgELC, MENU_ITEM_ECU_RADAR, MENU_ITEM_ECU_AvgELC); 
            }
            else
            {
            }
            Menu_Item_Exist_Condition_Set(MENU_ITEM_ECU_RADAR, 0);
        }
        else
        {
            Menu_Item_Exist_Condition_Set(MENU_ITEM_ECU_RADAR, 1);
        }

        if((PDC_Sts.RL == PDC_NoDisplay)&&(PDC_Sts.MID == PDC_NoDisplay)&&(PDC_Sts.RR == PDC_NoDisplay))
        {
            RADAR_PriDisp_Sts = 0;
        }
        else
        {
            if(0 == RADAR_PriDisp_Sts)
            {
                RADAR_PriDisp_Sts = 1;
            }

            if((KEY_Enter_Short == key)||(KEY_Enter_Long == key)||(KEY_Right == key)||(KEY_Left == key))
            {
                RADAR_PriDisp_Sts = 2;
            }
            else if(KEY_None_10s == key)
            {
                if(RADAR_PriDisp_Sts == 2)
                {
                    RADAR_PriDisp_Sts = 1;
                }
            }
            else
            {
            }
        }

        if(RADAR_PriDisp_Sts == 1)
        {
            Menu_Change_Branch_To_Item(MENU_BRANCH_MENUE, MENU_ITEM_ECU_RADAR);
            MENU_Intf_Inside_Item_Select_Set(MENU_ITEM_ECU_AvgELC, MENU_ITEM_ECU_RADAR, MENU_ITEM_ECU_RADAR);
            MENU_Intf_Inside_Item_Select_Set(MENU_ITEM_Navi_ECU, MENU_ITEM_Navi_Demand, MENU_ITEM_Navi_ECU);
        }

	//if(LDW_Infor.Vaild ==  1)
	//{
	//	Menu_Item_Exist_Condition_Set(MENU_ITEM_ECU_LDW, 1);		
	//}
	//else
	//{
	//	Menu_Item_Exist_Condition_Set(MENU_ITEM_ECU_LDW, 0);			
	//}
	
        //if(1)//((Val_EOL_F101_LDW() == 0x02) && (Val_EOL_F110_FCS() == 0x01) )
      //  {
            //if(LDW_Infor.Vaild ==  0)
            //{
            //    LDW_PriDisp_Sts = 0;
            //}
            //else
            //{
            //    if(0 == LDW_PriDisp_Sts)
            //    {
            //        LDW_PriDisp_Sts = 1;
            //    }
//
            //    if((KEY_Enter_Short == key)||(KEY_Enter_Long == key)||(KEY_Right == key)||(KEY_Left == key))
            //    {
            //        LDW_PriDisp_Sts = 2;
            //    }
            //    else
            //    {
            //    }
            //}
       // }
        //else
        //{
          //  LDW_PriDisp_Sts = 0;
        //}

        //if(LDW_PriDisp_Sts == 1)
        //{
        //    Menu_Change_Branch_To_Item(MENU_BRANCH_MENUE, MENU_ITEM_ECU_LDW);
        //    MENU_Intf_Inside_Item_Select_Set(MENU_ITEM_ECU_AvgELC, MENU_ITEM_ECU_RADAR, MENU_ITEM_ECU_LDW);
        //    MENU_Intf_Inside_Item_Select_Set(MENU_ITEM_Navi_ECU, MENU_ITEM_Navi_Demand, MENU_ITEM_Navi_ECU);
        //}


        if((DataVSpeedValid)&&(DataVSpeedDisp > 0))
        {
            if((menu >= MENU_ITEM_ECU_AvgELC)&&(menu <= MENU_ITEM_ECU_RADAR))
            {
            }
            else
            {
                MENU_Intf_Inside_Item_Select_Set(MENU_ITEM_Navi_ECU, MENU_ITEM_Navi_Demand, MENU_ITEM_Navi_ECU);
                Menu_Change_Branch_To_Item(MENU_BRANCH_MENUE, MENU_ITEM_ECU_AvgELC);
            }

            VechSpeedExist = 1;
        }
        else
        {
        }

        if(key == KEY_Enter_Short)
        {
            if ((menu == MENU_ITEM_SET_TPMS_LEARN_LF) || (menu == MENU_ITEM_SET_TPMS_LEARN_RF) ||
                (menu == MENU_ITEM_SET_TPMS_LEARN_LR) || (menu == MENU_ITEM_SET_TPMS_LEARN_MLR) ||
                (menu == MENU_ITEM_SET_TPMS_LEARN_MRR) || (menu == MENU_ITEM_SET_TPMS_LEARN_RR))
            {                
                if(menu == MENU_ITEM_SET_TPMS_LEARN_LF)
                {
                    TMPS_Learnning_Flag = TMPS_Export_LF;
                }
                else if(menu == MENU_ITEM_SET_TPMS_LEARN_RF)
                {
                    TMPS_Learnning_Flag = TMPS_Export_RF;
                }
                else if(menu == MENU_ITEM_SET_TPMS_LEARN_LR)
                {
                    TMPS_Learnning_Flag = TMPS_Export_LR;
                }
                else if(menu == MENU_ITEM_SET_TPMS_LEARN_MLR)
                {
                    TMPS_Learnning_Flag = TMPS_Export_MLR;
                }
                else if(menu == MENU_ITEM_SET_TPMS_LEARN_MRR)
                {
                    TMPS_Learnning_Flag = TMPS_Export_MRR;
                }
                else if(menu == MENU_ITEM_SET_TPMS_LEARN_RR)
                {
                    TMPS_Learnning_Flag = TMPS_Export_RR;
                }
            }
            else
            {
                // if(menu == MENU_ITEM_Navi_ECU)
                // {
                 		Menu_Service(MENU_KEY_CONFIRM_SHORT);
                // }
            }
        }
        else if (key == KEY_Left)
        {
            if ((menu == MENU_ITEM_ECU_AvgELC) || (menu == MENU_ITEM_ECU_ElcDTE) ||
                (menu == MENU_ITEM_ECU_InsELC) || (menu == MENU_ITEM_ECU_RemainPwr) ||
                (menu == MENU_ITEM_ECU_AvgSpeed) ||(menu == MENU_ITEM_ECU_DrivingTime) ||
                (menu == MENU_ITEM_ECU_WorkVolt) ||(menu == MENU_ITEM_ECU_WorkCurr) ||
                (menu == MENU_ITEM_ECU_BattVolt) ||
                (menu == MENU_ITEM_ECU_BattHighVolt) ||(menu == MENU_ITEM_ECU_BattLowVolt) ||
                (menu == MENU_ITEM_ECU_BattHighTemp) ||(menu == MENU_ITEM_ECU_BattLowTemp) ||
                (menu == MENU_ITEM_ECU_ErrCode) ||
                (menu == MENU_ITEM_ECU_TPMS) /*|| (menu == MENU_ITEM_ECU_LDW)*/ ||
                (menu == MENU_ITEM_ECU_RADAR) ||
                (menu == MENU_ITEM_SET_TPMS_LEARN_LF) || (menu == MENU_ITEM_SET_TPMS_LEARN_RF) ||
                (menu == MENU_ITEM_SET_TPMS_LEARN_LR) || (menu == MENU_ITEM_SET_TPMS_LEARN_MLR) ||
                (menu == MENU_ITEM_SET_TPMS_LEARN_MRR) || (menu == MENU_ITEM_SET_TPMS_LEARN_RR) ||
                (menu == MENU_ITEM_SET_TPMS_Learning) || (menu == MENU_ITEM_SET_TPMS_Learn_TimeOut) ||
                (menu == MENU_ITEM_SET_TPMS_Learn_IDConflict) || (menu == MENU_ITEM_SET_TPMS_Learn_HaveVechSpeed) ||
                (menu == MENU_ITEM_SET_TPMS_Learn_Succeed) || (menu == MENU_ITEM_Navi_Demand_Alam))
            {
                if(VechSpeedExist == 0u)
                {
                    Menu_Service(MENU_KEY_CANCEL_SHORT);
                }
            }   
            else
            {
                Menu_Service(MENU_KEY_UP_SHORT);
            }
        }
        else if(key == KEY_Right)
        {
            Menu_Service(MENU_KEY_DOWN_SHORT);
        }
        else if(key == KEY_None_5s)
        {
            if(menu == MENU_ITEM_SET_TPMS_Learn_Succeed)
            {
                Menu_Service(MENU_KEY_TIMEOUT);
            }
        }
        else if(key == KEY_None_20s)
        {
            if((menu == MENU_ITEM_Navi_ECU)||(menu == MENU_ITEM_Navi_Set)||(menu == MENU_ITEM_Navi_Demand))
            {
                Menu_Service(MENU_KEY_TIMEOUT);
            }
        }
        else
        {
        }

        if ((menu == MENU_ITEM_SET_TPMS_LEARN_LF) || (menu == MENU_ITEM_SET_TPMS_LEARN_RF) ||
            (menu == MENU_ITEM_SET_TPMS_LEARN_LR) || (menu == MENU_ITEM_SET_TPMS_LEARN_MLR) ||
            (menu == MENU_ITEM_SET_TPMS_LEARN_MRR) || (menu == MENU_ITEM_SET_TPMS_LEARN_RR))
        {
            Menu_TPMS_Learn_Process();
        }

        if(menu == MENU_ITEM_SET_TPMS_Learning)
        {
            Menu_TPMS_Learning_Process(menu);
        }
    }
    else
    {

    }
}

void Menu_Check_TPMS_Alarm_Trigger(void )
{
    if((TPMS_Config.F110 == 1)&&(TPMS_Config.F101 == 1))
    {
        if(Config1_TPMS_NotLearnt)
        {
            MenuTpmsCtrl.MenuTpmsTgr |= MenuTPMSTgrSts[MenuDispTPMS_NotLearn];    
        }
        else
        {
            MenuTpmsCtrl.MenuTpmsTgr &= (~MenuTPMSTgrSts[MenuDispTPMS_NotLearn]);
        }

        if(Config1_Sensor_Loss)
        {
            MenuTpmsCtrl.MenuTpmsTgr |= MenuTPMSTgrSts[MenuDispTPMS_SensorLost];    
        }
        else
        {
            MenuTpmsCtrl.MenuTpmsTgr &= (~MenuTPMSTgrSts[MenuDispTPMS_SensorLost]);
        }

        if(Config1_Sensor_Fault)
        {
            MenuTpmsCtrl.MenuTpmsTgr |= MenuTPMSTgrSts[MenuDispTPMS_SensorFault];    
        }
        else
        {
            MenuTpmsCtrl.MenuTpmsTgr &= (~MenuTPMSTgrSts[MenuDispTPMS_SensorFault]);
        }

        if(Config1_TPMS_Low)
        {
            MenuTpmsCtrl.MenuTpmsTgr |= MenuTPMSTgrSts[MenuDispTPMS_PressLow];    
        }
        else
        {
            MenuTpmsCtrl.MenuTpmsTgr &= (~MenuTPMSTgrSts[MenuDispTPMS_PressLow]);
        }

        if(Config1_TPMS_High)
        {
            MenuTpmsCtrl.MenuTpmsTgr |= MenuTPMSTgrSts[MenuDispTPMS_PressHigh];    
        }
        else
        {
            MenuTpmsCtrl.MenuTpmsTgr &= (~MenuTPMSTgrSts[MenuDispTPMS_PressHigh]);
        }

        if(Config1_TPMS_Leak)
        {
            MenuTpmsCtrl.MenuTpmsTgr |= MenuTPMSTgrSts[MenuDispTPMS_LeakFast];    
        }
        else
        {
            MenuTpmsCtrl.MenuTpmsTgr &= (~MenuTPMSTgrSts[MenuDispTPMS_LeakFast]);
        }

        if(Config1_Temp_High)
        {
            MenuTpmsCtrl.MenuTpmsTgr |= MenuTPMSTgrSts[MenuDispTPMS_TempHigh];    
        }
        else
        {
            MenuTpmsCtrl.MenuTpmsTgr &= (~MenuTPMSTgrSts[MenuDispTPMS_TempHigh]);
        }

        if(Config1_Bat_Low)
        {
            MenuTpmsCtrl.MenuTpmsTgr |= MenuTPMSTgrSts[MenuDispTPMS_SensorBatteryLow];    
        }
        else
        {
            MenuTpmsCtrl.MenuTpmsTgr &= (~MenuTPMSTgrSts[MenuDispTPMS_SensorBatteryLow]);
        }
    }
    else if((TPMS_Config.F110 == 1)&&(TPMS_Config.F101 == 2))
    {
        if(Config2_TPMS_NotLearnt)
        {
            MenuTpmsCtrl.MenuTpmsTgr |= MenuTPMSTgrSts[MenuDispTPMS_NotLearn];    
        }
        else
        {
            MenuTpmsCtrl.MenuTpmsTgr &= (~MenuTPMSTgrSts[MenuDispTPMS_NotLearn]);
        }

        if(Config2_Sensor_Loss)
        {
            MenuTpmsCtrl.MenuTpmsTgr |= MenuTPMSTgrSts[MenuDispTPMS_SensorLost];    
        }
        else
        {
            MenuTpmsCtrl.MenuTpmsTgr &= (~MenuTPMSTgrSts[MenuDispTPMS_SensorLost]);
        }

        if(Config2_Sensor_Fault)
        {
            MenuTpmsCtrl.MenuTpmsTgr |= MenuTPMSTgrSts[MenuDispTPMS_SensorFault];    
        }
        else
        {
            MenuTpmsCtrl.MenuTpmsTgr &= (~MenuTPMSTgrSts[MenuDispTPMS_SensorFault]);
        }

        if(Config2_TPMS_Low)
        {
            MenuTpmsCtrl.MenuTpmsTgr |= MenuTPMSTgrSts[MenuDispTPMS_PressLow];    
        }
        else
        {
            MenuTpmsCtrl.MenuTpmsTgr &= (~MenuTPMSTgrSts[MenuDispTPMS_PressLow]);
        }

        if(Config2_TPMS_High)
        {
            MenuTpmsCtrl.MenuTpmsTgr |= MenuTPMSTgrSts[MenuDispTPMS_PressHigh];    
        }
        else
        {
            MenuTpmsCtrl.MenuTpmsTgr &= (~MenuTPMSTgrSts[MenuDispTPMS_PressHigh]);
        }

        if(Config2_TPMS_Leak)
        {
            MenuTpmsCtrl.MenuTpmsTgr |= MenuTPMSTgrSts[MenuDispTPMS_LeakFast];    
        }
        else
        {
            MenuTpmsCtrl.MenuTpmsTgr &= (~MenuTPMSTgrSts[MenuDispTPMS_LeakFast]);
        }

        if(Config2_Temp_High)
        {
            MenuTpmsCtrl.MenuTpmsTgr |= MenuTPMSTgrSts[MenuDispTPMS_TempHigh];    
        }
        else
        {
            MenuTpmsCtrl.MenuTpmsTgr &= (~MenuTPMSTgrSts[MenuDispTPMS_TempHigh]);
        }

        if(Config2_Bat_Low)
        {
            MenuTpmsCtrl.MenuTpmsTgr |= MenuTPMSTgrSts[MenuDispTPMS_SensorBatteryLow];    
        }
        else
        {
            MenuTpmsCtrl.MenuTpmsTgr &= (~MenuTPMSTgrSts[MenuDispTPMS_SensorBatteryLow]);
        }
    }
    else
    {
        MenuTpmsCtrl.MenuTpmsTgr = 0;
    }
}

void Menu_TPMS_Display_ChangeNext()
{
    uint8_t i = 0;
    uint8_t buffer = MenuTpmsCtrl.MenuCurTpmsSts;
    if(MenuTpmsCtrl.MenuTpmsTgr == 0)
    {
        MenuTpmsCtrl.MenuCurTpmsSts = MenuDispTPMS_Normal;			
    }
    else
    {
        for(i=0; i<MenuDispTPMS_Normal; i++)
        {
            buffer++;
            if(buffer >= MenuDispTPMS_Normal)
            {
                buffer = 0;
            }

            if((MenuTpmsCtrl.MenuTpmsTgr & MenuTPMSTgrSts[buffer]) == MenuTPMSTgrSts[buffer])
            {
                
                MenuTpmsCtrl.MenuCurTpmsSts = buffer;
                break;
            }
        }
    }

    MenuTpmsCtrl.DispTimeCnt = 0;
}

void Menu_TPMS_Display_Service(void )
{
    uint16_t Maxtime = 400;
    uint8_t Mintime = 100;
    Menu_Item_en_t menu = Menu_Get_Current_Cursor_Information();

    Menu_Check_TPMS_Alarm_Trigger();
    if(MenuTpmsCtrl.DispTimeCnt < Maxtime)
    {
        MenuTpmsCtrl.DispTimeCnt++;
    }

    if(menu == MENU_ITEM_ECU_TPMS)
    {
        if(MenuTpmsCtrl.MenuCurTpmsSts >= MenuDispTPMS_Normal)
        {
            if(MenuTpmsCtrl.MenuTpmsTgr != 0)
            {
                if(MenuTpmsCtrl.DispTimeCnt >= Mintime)
                {
                    Menu_TPMS_Display_ChangeNext();
                }
            }
        }
        else
        {
            if((MenuTPMSTgrSts[MenuTpmsCtrl.MenuCurTpmsSts]&MenuTpmsCtrl.MenuTpmsTgr) == 0)
            {
                if(MenuTpmsCtrl.DispTimeCnt >= Mintime)
                {
                    Menu_TPMS_Display_ChangeNext();
                }
            }
            else
            {
                if(MenuTpmsCtrl.DispTimeCnt >= Maxtime)
                {
                    Menu_TPMS_Display_ChangeNext();
                }
            }
        }
    }
    else
    {
        if(MenuTpmsCtrl.MenuCurTpmsSts >= MenuDispTPMS_Normal)
        {
            if(MenuTpmsCtrl.MenuTpmsTgr != 0)
            {
                Menu_TPMS_Display_ChangeNext();
            }
        }
        else
        {
            if(MenuTpmsCtrl.MenuTpmsTgr == 0)
            {
                Menu_TPMS_Display_ChangeNext(); 
            }
        }
    }
}

void Menu_TPMS_Learn_Process(void)
{
    Menu_Item_en_t curMenu = Menu_Get_Current_Cursor_Information();
    uint8_t MsgSts = TMPS_Learnning_Flag;
    uint8_t LearnLocation = Get_CAN_CH0_ID_18FFE133_Sig_TPMS_Manual_LearnLocation();
    uint8_t LearnSts = Get_CAN_CH0_ID_18FFE133_Sig_TPMS_Manual_LearnSts();
    uint8_t Learn_Result = 0u;
    

    Learn_Result = Menu_TPMS_Learn_Msg_Process(curMenu, MsgSts, LearnLocation, LearnSts);
    if (Learn_Result == 2)
    {
        Menu_Item_Exist_Condition_Set(MENU_ITEM_SET_TPMS_Learning, 1);
        Menu_Item_Exist_Condition_Set(MENU_ITEM_SET_TPMS_Learn_TimeOut, 0);
        Menu_Item_Exist_Condition_Set(MENU_ITEM_SET_TPMS_Learn_IDConflict, 0);
        Menu_Item_Exist_Condition_Set(MENU_ITEM_SET_TPMS_Learn_HaveVechSpeed, 0);
        Menu_Item_Exist_Condition_Set(MENU_ITEM_SET_TPMS_Learn_Succeed, 0);
        Menu_Service(MENU_KEY_CONFIRM_SHORT);
    }
    else if (Learn_Result == 3)
    {
        Menu_Item_Exist_Condition_Set(MENU_ITEM_SET_TPMS_Learning, 0);
        Menu_Item_Exist_Condition_Set(MENU_ITEM_SET_TPMS_Learn_TimeOut, 0);
        Menu_Item_Exist_Condition_Set(MENU_ITEM_SET_TPMS_Learn_IDConflict, 0);
        Menu_Item_Exist_Condition_Set(MENU_ITEM_SET_TPMS_Learn_HaveVechSpeed, 0);
        Menu_Item_Exist_Condition_Set(MENU_ITEM_SET_TPMS_Learn_Succeed, 1);
        Menu_Service(MENU_KEY_CONFIRM_SHORT);
    }
    else if (Learn_Result == 4)
    {
        Menu_Item_Exist_Condition_Set(MENU_ITEM_SET_TPMS_Learning, 0);
        Menu_Item_Exist_Condition_Set(MENU_ITEM_SET_TPMS_Learn_TimeOut, 1);
        Menu_Item_Exist_Condition_Set(MENU_ITEM_SET_TPMS_Learn_IDConflict, 0);
        Menu_Item_Exist_Condition_Set(MENU_ITEM_SET_TPMS_Learn_HaveVechSpeed, 0);
        Menu_Item_Exist_Condition_Set(MENU_ITEM_SET_TPMS_Learn_Succeed, 0);
        Menu_Service(MENU_KEY_CONFIRM_SHORT);
    }
    else if (Learn_Result == 5)
    {
        Menu_Item_Exist_Condition_Set(MENU_ITEM_SET_TPMS_Learning, 0);
        Menu_Item_Exist_Condition_Set(MENU_ITEM_SET_TPMS_Learn_TimeOut, 0);
        Menu_Item_Exist_Condition_Set(MENU_ITEM_SET_TPMS_Learn_IDConflict, 1);
        Menu_Item_Exist_Condition_Set(MENU_ITEM_SET_TPMS_Learn_HaveVechSpeed, 0);
        Menu_Item_Exist_Condition_Set(MENU_ITEM_SET_TPMS_Learn_Succeed, 0);
        Menu_Service(MENU_KEY_CONFIRM_SHORT);
    }
    else if (Learn_Result == 6)
    {
        Menu_Item_Exist_Condition_Set(MENU_ITEM_SET_TPMS_Learning, 0);
        Menu_Item_Exist_Condition_Set(MENU_ITEM_SET_TPMS_Learn_TimeOut, 0);
        Menu_Item_Exist_Condition_Set(MENU_ITEM_SET_TPMS_Learn_IDConflict, 0);
        Menu_Item_Exist_Condition_Set(MENU_ITEM_SET_TPMS_Learn_HaveVechSpeed, 1);
        Menu_Item_Exist_Condition_Set(MENU_ITEM_SET_TPMS_Learn_Succeed, 0);
        Menu_Service(MENU_KEY_CONFIRM_SHORT);
    }
    else
    {
    }
}

void Menu_TPMS_Learning_Process(Menu_Item_en_t curMenu)
{
    uint8_t MsgSts = TMPS_Learnning_Flag;
    uint8_t LearnLocation = Get_CAN_CH0_ID_18FFE133_Sig_TPMS_Manual_LearnLocation();
    uint8_t LearnSts = Get_CAN_CH0_ID_18FFE133_Sig_TPMS_Manual_LearnSts();
    uint8_t Learn_Result = 0u;

    if(curMenu != MENU_ITEM_SET_TPMS_Learning)
    {
        return;
    }
    Learn_Result = Menu_TPMS_Learn_Msg_Process(curMenu, MsgSts, LearnLocation, LearnSts);
    if (Learn_Result == 3)
    {
        Menu_Item_Exist_Condition_Set(MENU_ITEM_SET_TPMS_Learn_Succeed, 1);
        Menu_Service(MENU_KEY_DOWN_SHORT);
        Menu_Item_Exist_Condition_Set(MENU_ITEM_SET_TPMS_Learning, 0);
        Menu_Item_Exist_Condition_Set(MENU_ITEM_SET_TPMS_Learn_TimeOut, 0);
        Menu_Item_Exist_Condition_Set(MENU_ITEM_SET_TPMS_Learn_IDConflict, 0);
        Menu_Item_Exist_Condition_Set(MENU_ITEM_SET_TPMS_Learn_HaveVechSpeed, 0);
    }
    else if (Learn_Result == 4)
    {
        Menu_Item_Exist_Condition_Set(MENU_ITEM_SET_TPMS_Learn_TimeOut, 1);
        Menu_Service(MENU_KEY_DOWN_SHORT);
        Menu_Item_Exist_Condition_Set(MENU_ITEM_SET_TPMS_Learning, 0);
        Menu_Item_Exist_Condition_Set(MENU_ITEM_SET_TPMS_Learn_IDConflict, 0);
        Menu_Item_Exist_Condition_Set(MENU_ITEM_SET_TPMS_Learn_HaveVechSpeed, 0);
        Menu_Item_Exist_Condition_Set(MENU_ITEM_SET_TPMS_Learn_Succeed, 0);
    }
    else if (Learn_Result == 5)
    {
        Menu_Item_Exist_Condition_Set(MENU_ITEM_SET_TPMS_Learn_IDConflict, 1);
        Menu_Service(MENU_KEY_DOWN_SHORT);
        Menu_Item_Exist_Condition_Set(MENU_ITEM_SET_TPMS_Learning, 0);
        Menu_Item_Exist_Condition_Set(MENU_ITEM_SET_TPMS_Learn_TimeOut, 0);
        Menu_Item_Exist_Condition_Set(MENU_ITEM_SET_TPMS_Learn_HaveVechSpeed, 0);
        Menu_Item_Exist_Condition_Set(MENU_ITEM_SET_TPMS_Learn_Succeed, 0);
        
    }
    else if (Learn_Result == 6)
    {
        Menu_Item_Exist_Condition_Set(MENU_ITEM_SET_TPMS_Learn_HaveVechSpeed, 1);
        Menu_Service(MENU_KEY_DOWN_SHORT);
        Menu_Item_Exist_Condition_Set(MENU_ITEM_SET_TPMS_Learning, 0);
        Menu_Item_Exist_Condition_Set(MENU_ITEM_SET_TPMS_Learn_TimeOut, 0);
        Menu_Item_Exist_Condition_Set(MENU_ITEM_SET_TPMS_Learn_IDConflict, 0);
        Menu_Item_Exist_Condition_Set(MENU_ITEM_SET_TPMS_Learn_Succeed, 0);
    }
}

uint8_t Menu_TPMS_Learn_Msg_Process(Menu_Item_en_t curMenu, uint8_t MsgSts, uint8_t LearnLocation, uint8_t LearnSts)
{
    uint8_t ret = 0u;

    if ((curMenu < MENU_ITEM_SET_TPMS_LEARN_LF) || (curMenu > MENU_ITEM_SET_TPMS_Learning))
    {
        return 0;
    }

    
    if (MsgSts == TMPS_Export_Max||MsgSts == TMPS_Export_Over)
    {
        return 0;
    }
    

    if ((LearnLocation == 0X17) && (curMenu == MENU_ITEM_SET_TPMS_LEARN_LF)&&(MsgSts == TMPS_Export_LF))
    {
    }
    else if ((LearnLocation == 0X19) && (curMenu == MENU_ITEM_SET_TPMS_LEARN_RF)&&(MsgSts == TMPS_Export_RF))
    {
    }
    else if ((LearnLocation == 0X26) && (curMenu == MENU_ITEM_SET_TPMS_LEARN_LR)&&(MsgSts == TMPS_Export_LR))
    {
    }
    else if ((LearnLocation == 0X27) && (curMenu == MENU_ITEM_SET_TPMS_LEARN_MLR)&&(MsgSts == TMPS_Export_MLR))
    {
    }
    else if ((LearnLocation == 0X29) && (curMenu == MENU_ITEM_SET_TPMS_LEARN_MRR)&&(MsgSts == TMPS_Export_MRR))
    {
    }
    else if ((LearnLocation == 0X2A) && (curMenu == MENU_ITEM_SET_TPMS_LEARN_RR) && (MsgSts == TMPS_Export_RR))
    {
    }
    else if(curMenu == MENU_ITEM_SET_TPMS_Learning)
    {
    }
    else
    {
        return 0;
    }

    if (LearnSts == 0x02)
    {
        ret = 2;
    }
    else if (LearnSts == 0x03)
    {
        ret = 3;
    }
    else if (LearnSts == 0x04)
    {
        ret = 4;
    }
    else if (LearnSts == 0x05)
    {
        ret = 5;
    }
    else if (LearnSts == 0x06)
    {
        ret = 6;
    }
    else
    {
        ret = 0;
    }

    return ret;
}



uint8_t HintPopupNum = 0u;
uint8_t Menu_Get_g1_SystemError(void)
{
    uint8_t i = 0u;
   // uint8_t startIndex = 0u;
   // uint8_t endIndex = 0u;
    //uint8_t jumpFlag = 0u;
    //uint8_t WarringPopupNum = 0u;
    //uint8_t MaskPopupNum = 0u;
    uint8_t PopupNum = 0;
    
/*	for(i= 0; i<128;i++)
	{
		MaskPopupList[i] = 0xffff;	
	}
	*/
    HintPopupNum =  Popup_Get_Hint_Msg(&MaskPopupList, sizeof(MaskPopupList) );
    //WarringPopupNum =   Popup_Get_Warring_Msg(&MaskPopupList[HintPopupNum], (sizeof(MaskPopupList)-sizeof(HintPopupNum)) );
    PopupNum =  HintPopupNum /*+ WarringPopupNum*/;
     
     return 	 PopupNum ;
    
}

//OTA_HMI_Ctrl_Struct OTA_Ctrl;
//OTA_HMI_Ctrl_Struct OTA_Ctrl_Backup;
void OTA_Display_Info_KL15_30_Init(void)
{
    OTA_Ctrl.CurHMI = OTA_HMI_Max;                    /*µ±Ç°½çÃæ*/
    OTA_Ctrl.Cursor = OTA_HMI_CURSOR_Max;             /*¹â±êÎ»ÖÃ*/
    OTA_Ctrl.CursorNum = 0;                           /*½çÃæ¹â±ê¸öÊý*/
    OTA_Ctrl.Countdown = 0;                           /*µ¹¼ÆÊ±×î´óÖµ*/
    OTA_Ctrl.CountdownPos = OTA_HMI_CountdownPos_Max; /*µ¹¼ÆÊ±ÏÔÊ¾µÄÎ»ÖÃ*/
    OTA_Ctrl.CountdownTimeCnt = 0;
    OTA_Ctrl.HMI_6_Displayed = 0;
    OTA_Ctrl.Countdownflag = 0;
    //OTA_Ctrl.MsgExpEn = 0;
    //OTA_Ctrl.MsgCnt = 0;
}

void OTA_Detect(void)
{
    if((Val_EOL_F110_MMI() == 0)&&(Val_EOL_F110_TBOX() == 1)&&(Val_EOL_F101_OTA() == 1))
    {
        OTA_HMI_INFO_ENUM vCurHMI = OTA_HMI_Max; /*µ±Ç°½çÃæ*/

	    OTA_HMI_CURSOR_ENUM vDefaultCursor = OTA_HMI_CURSOR_Max; /*½çÃæÄ¬ÈÏ¹â±êÎ»ÖÃ*/
	    uint8_t vCursorNum = 0;                                  /*½çÃæ¹â±ê¸öÊý*/
        uint8_t vCountdownflag = 0; 
	    uint16_t vCountdownMax = 0;                                         /*µ¹¼ÆÊ±×î´óÖµ*/
	    OTA_HMI_CountdownPos_ENUM vCountdownPos = OTA_HMI_CountdownPos_Max; /*µ¹¼ÆÊ±ÏÔÊ¾µÄÎ»ÖÃ*/

	    if (Get_CAN_CH0_ID_18FF639F_Sig_TBOX_OTA_Mode() == 1)
	    {
	    	/*½çÃæ1*/
	    	vCurHMI = OTA_HMI_1;
	    }
	    else
	    {

	    }

	    if (Get_CAN_CH0_ID_18FF639F_Sig_TBOX_OTA_Mode() == 1)
	    {
	    	if (Get_CAN_CH0_ID_18FF639F_Sig_TBOX_OTA_DownloadRequest() == 1)
	    	{
	    		/*½çÃæ2*/
	    		vCurHMI = OTA_HMI_2;
	    	}
	    	else 
	    	{
	    		if (Get_CAN_CH0_ID_18FF639F_Sig_TBOX_OTA_DownloadState() == 1)
	    		{
	    			/*½çÃæ3*/
	    			vCurHMI = OTA_HMI_3;
	    			OTA_Ctrl.DownLoadPercent =  Get_CAN_CH0_ID_18FF639F_Sig_TBOX_OTA_DownloadProgress() ; 
	    			if(OTA_Ctrl.DownLoadPercent >= 0x64)
	    			{
	    				OTA_Ctrl.DownLoadPercent = 0x64 ;
	    			}
	    		}
	    		else if (Get_CAN_CH0_ID_18FF639F_Sig_TBOX_OTA_DownloadState() == 0x03)
	    		{
	    			/*½çÃæ4*/
	    			vCurHMI = OTA_HMI_4;
	    		}
	    		else if (Get_CAN_CH0_ID_18FF639F_Sig_TBOX_OTA_DownloadState() == 0x00)
	    		{
	    			if (Get_CAN_CH0_ID_18FF639F_Sig_TBOX_OTA_UpdateRequest() == 0x01)
	    			{
	    				/*½çÃæ5*/
	    				vCurHMI = OTA_HMI_5;
	    			}
	    			else
	    			{
	    				if (Get_CAN_CH0_ID_18FF639F_Sig_TBOX_OTA_DisclaimerWarning() == 0x01)
	    				{
	    				    /*½çÃæ6*/
	    				    /*ÃâÔðÉùÃ÷*/
	    				    OTA_Ctrl.HMI_6_Displayed = 1;
	    				    vCurHMI = OTA_HMI_6;
	    				}
	    				else
	    				{
                            if ((((Get_CAN_CH0_ID_18FF639F_Sig_TBOX_OTA_FailedReason_PowerMode() != 0)||
                                 (Get_CAN_CH0_ID_18FF639F_Sig_TBOX_OTA_FailedReason_GearPos() != 0)||
                                 (Get_CAN_CH0_ID_18FF639F_Sig_TBOX_OTA_FailedReason_VehicleSpd() != 0)||
                                 (Get_CAN_CH0_ID_18FF639F_Sig_TBOX_OTA_FailedReason_BattVo() != 0)||
                                 (Get_CAN_CH0_ID_18FF639F_Sig_TBOX_OTA_FailedReason_HandBrake() != 0)||
                                 (Get_CAN_CH0_ID_18FF639F_Sig_TBOX_OTA_FailedReason_ChgStatus() != 0)||
                                 (Get_CAN_CH0_ID_18FF639F_Sig_TBOX_OTA_FailedReason_HVStatus() != 0))&&
                                 (Get_CAN_CH0_ID_18FF639F_Sig_TBOX_OTA_PreConditionDetect() == 1)) 
                                 && (OTA_Ctrl.HMI_6_Displayed == 1))
	    				    {
	    				        /*½çÃæ7*/
	    				        if (Get_CAN_CH0_ID_18FF639F_Sig_TBOX_OTA_FailedReason_PowerMode() == 1)
	    				        {
	    				            vCurHMI = OTA_HMI_7_PowerMode;
	    				        }
	    				        else if (Get_CAN_CH0_ID_18FF639F_Sig_TBOX_OTA_FailedReason_GearPos() == 1)
	    				        {
	    				            vCurHMI = OTA_HMI_7_GearPos;
	    				        }
	    				        else if (Get_CAN_CH0_ID_18FF639F_Sig_TBOX_OTA_FailedReason_VehicleSpd() == 1)
	    				        {
	    				            vCurHMI = OTA_HMI_7_VehicleSpd;
	    				        }
	    				        else if (Get_CAN_CH0_ID_18FF639F_Sig_TBOX_OTA_FailedReason_BattVo() == 1)
	    				        {
	    				            vCurHMI = OTA_HMI_7_BattVol;
	    				        }
	    				        else if (Get_CAN_CH0_ID_18FF639F_Sig_TBOX_OTA_FailedReason_HandBrake() == 1)
	    				        {
	    				            vCurHMI = OTA_HMI_7_HandBrake;
	    				        }
	    				        else if (Get_CAN_CH0_ID_18FF639F_Sig_TBOX_OTA_FailedReason_ChgStatus() == 1)
	    				        {
	    				            vCurHMI = OTA_HMI_7_ChgStatus;
	    				        }
	    				        else if (Get_CAN_CH0_ID_18FF639F_Sig_TBOX_OTA_FailedReason_HVStatus() == 1)
	    				        {
	    				            vCurHMI = OTA_HMI_7_HVStatus;
	    				        }
	    				    }
	    				    else
	    				    {
	    				        if (Get_CAN_CH0_ID_18FF639F_Sig_TBOX_OTA_UpdateState() == 0X05)
	    				        {
	    				            /*½çÃæ8*/
	    				            vCurHMI = OTA_HMI_8;
	    				        }
	    				        else if (Get_CAN_CH0_ID_18FF639F_Sig_TBOX_OTA_UpdateState() == 0X01)
	    				        {
	    				            /*½çÃæ9*/
	    				            vCurHMI = OTA_HMI_9;
	    				        }
	    				        else if (Get_CAN_CH0_ID_18FF639F_Sig_TBOX_OTA_UpdateState() == 0X06)
	    				        {
	    				            /*½çÃæ10*/
	    				            vCurHMI = OTA_HMI_10;
	    				        }
	    				        else if (Get_CAN_CH0_ID_18FF639F_Sig_TBOX_OTA_UpdateState() == 0X02)
	    				        {
	    				            /*½çÃæ11*/
	    				            vCurHMI = OTA_HMI_11;
	    				        }
	    				    }
	    				}
	    			}
	    		}
	    	}
	    }

	    if (OTA_Ctrl.CurHMI != vCurHMI)
	    {
	    	switch (vCurHMI)
	    	{
	    		case OTA_HMI_1:
	    		case OTA_HMI_8:
	    		case OTA_HMI_9:
	    		{
	    			vDefaultCursor = OTA_HMI_CURSOR_Max;
	    			vCursorNum = 0;
	    			vCountdownMax = 0;
	    			vCountdownPos = OTA_HMI_CountdownPos_Max;
                    vCountdownflag = 1;
	    			break;
	    		}
	    		case OTA_HMI_2:
	    		case OTA_HMI_4:
	    		case OTA_HMI_5:
	    		case OTA_HMI_6:
	    		{
	    			vDefaultCursor = OTA_HMI_CURSOR_Confirm;
	    			vCursorNum = 2;
	    			vCountdownMax = 60;
	    			vCountdownPos = OTA_HMI_CountdownPos_Concel;
                    vCountdownflag = 1;
	    			break;
	    		}
	    		case OTA_HMI_3:
	    		case OTA_HMI_7_PowerMode:
	    		case OTA_HMI_7_GearPos:
	    		case OTA_HMI_7_VehicleSpd:
	    		case OTA_HMI_7_BattVol:
	    		case OTA_HMI_7_HandBrake:
	    		case OTA_HMI_7_ChgStatus:
	    		case OTA_HMI_7_HVStatus:
	    		{
	    			vDefaultCursor = OTA_HMI_CURSOR_Concel;
	    			vCursorNum = 1;
	    			vCountdownMax = 60;
	    			vCountdownPos = OTA_HMI_CountdownPos_Concel;
                    vCountdownflag = 1;
	    			break;
	    		}

	    		case OTA_HMI_10:
	    		case OTA_HMI_11:
	    		{
	    			vDefaultCursor = OTA_HMI_CURSOR_Confirm;
	    			vCursorNum = 1;
	    			vCountdownMax = 10;
	    			vCountdownPos = OTA_HMI_CountdownPos_Confirm;
                    vCountdownflag = 1;
	    			break;
	    		}
	    		default:
	    		{
	    			vDefaultCursor = OTA_HMI_CURSOR_Max;
	    			vCursorNum = 0;
	    			vCountdownMax = 0;
	    			vCountdownPos = OTA_HMI_CountdownPos_Max;
                    vCountdownflag = 1;
	    			break;
	    		}
	    	}

	    	if(OTA_Ctrl.CurHMI == OTA_HMI_Max)
	    	{
	    		IC_OTA.IC_OTA_InfoShowStatus = 0x01;	
	    		IC_OTA.IC_OTA_InfoShowStatus_Cnt = 0x03;
                Can_Msg_Tx_Overwrite(&CAN_CH0_CanMsgTxOp, IC_18FF4117_Msg_Count, 3, 20000UL);
	    	}

	    	if(vCurHMI == OTA_HMI_Max)
	    	{
	    		OTA_Ctrl.HMI_6_Displayed = 0; /*ÏÔÊ¾ÖÜÆÚ½áÊø£¬ÏÔÊ¾¹ý½çÃæ6±êÖ¾ÇåÁã*/
	    	}

	    	OTA_Ctrl.CurHMI = vCurHMI;
	    	OTA_Ctrl.Countdown = vCountdownMax;
	    	OTA_Ctrl.CountdownPos = vCountdownPos;
	    	OTA_Ctrl.Cursor = vDefaultCursor;
	    	OTA_Ctrl.CursorNum = vCursorNum;
	    	OTA_Ctrl.CountdownTimeCnt = 0;
            OTA_Ctrl.Countdownflag = vCountdownflag; 
	    }


	    if(OTA_Ctrl.CurHMI < OTA_HMI_Max)
	    {
	    	if(OTA_Ctrl.CountdownTimeCnt++ >= 10)
	    	{
	    		OTA_Ctrl.CountdownTimeCnt = 0;
	    		if(OTA_Ctrl.Countdown)
	    		{
	    			OTA_Ctrl.Countdown--;
	    		}
	    		else
	    		{
	    			switch (OTA_Ctrl.CurHMI)
	    			{
	    				case OTA_HMI_2:
	    				case OTA_HMI_4:
	    				case OTA_HMI_3: 
	    				{
                            if(OTA_Ctrl.Countdownflag)
                            {
                                OTA_Ctrl.Countdownflag = 0; 
                                IC_OTA.IC_OTA_DownloadSelected = 0x01;
	    				        IC_OTA.IC_OTA_DownloadSelected_Cnt = 3;
                                Can_Msg_Tx_Overwrite(&CAN_CH0_CanMsgTxOp, IC_18FF4117_Msg_Count, 3, 20000UL);
                            }
	    				    else
                            {
                                IC_OTA.IC_OTA_DownloadSelected = 0x00;
                            }

	    				    break;
	    				}
	    				case OTA_HMI_5:
	    				{
                            if(OTA_Ctrl.Countdownflag)
                            {
                                OTA_Ctrl.Countdownflag = 0; 
                                IC_OTA.IC_OTA_UpdateSelected = 0x01;
	    				        IC_OTA.IC_OTA_UpdateSelected_Cnt = 3;
                                Can_Msg_Tx_Overwrite(&CAN_CH0_CanMsgTxOp, IC_18FF4117_Msg_Count, 3, 20000UL);
                            }
                            else
                            {
                                IC_OTA.IC_OTA_UpdateSelected = 0x00;
                            }
	    				    break;
	    				}
	    				case OTA_HMI_6:
	    				{
                            if(OTA_Ctrl.Countdownflag)
                            {
                                OTA_Ctrl.Countdownflag = 0; 
	    				        IC_OTA.IC_OTA_DeclimerSelected = 0x01;
	    				        IC_OTA.IC_OTA_DeclimerSelected_Cnt = 3;
                                Can_Msg_Tx_Overwrite(&CAN_CH0_CanMsgTxOp, IC_18FF4117_Msg_Count, 3, 20000UL);
                            }
                            else
                            {
                                IC_OTA.IC_OTA_DeclimerSelected = 0x00;
                            }
	    				    break;
	    				}
	    				case OTA_HMI_7_PowerMode:
	    				case OTA_HMI_7_GearPos:
	    				case OTA_HMI_7_VehicleSpd:
	    				case OTA_HMI_7_BattVol:
	    				case OTA_HMI_7_HandBrake:
	    				case OTA_HMI_7_ChgStatus:
	    				case OTA_HMI_7_HVStatus:
	    				{
                            if(OTA_Ctrl.Countdownflag)
                            {
                                OTA_Ctrl.Countdownflag = 0; 
	    				        IC_OTA.IC_OTA_UpdateSelected = 0x01;
	    				        IC_OTA.IC_OTA_UpdateSelected_Cnt = 3;
                                Can_Msg_Tx_Overwrite(&CAN_CH0_CanMsgTxOp, IC_18FF4117_Msg_Count, 3, 20000UL);
                            }
                            else
                            {
                                IC_OTA.IC_OTA_UpdateSelected = 0x00;
                            }
	    				    break;
	    				}
	    				case OTA_HMI_10:
	    				case OTA_HMI_11:
	    				{
                            if(OTA_Ctrl.Countdownflag)
                            {
                                OTA_Ctrl.Countdownflag = 0; 
	    				        IC_OTA.IC_OTA_UpdateResultConfirm = 0x01;
	    				        IC_OTA.IC_OTA_UpdateResultConfirm_Cnt = 3;
                                Can_Msg_Tx_Overwrite(&CAN_CH0_CanMsgTxOp, IC_18FF4117_Msg_Count, 3, 20000UL);
                            }
                            else
                            {
                                IC_OTA.IC_OTA_UpdateResultConfirm = 0x00;
                            }
	    				    break;
	    				}
	    				default:
	    				{
	    				    break;
	    				}
	    			}
	    		}
	    	}
	    }
    }
}

