#include "UDS_27Service_Main.h"
#include "UDS_Common.h"
//const uint8_t XorArray[4]= {0x31,0x23,0x56,0x71};
const uint8_t XorArray[4]= {0x74,0xF7,0x15,0x17};
static void Ser27_CalculateKeyLV1(uint8_t Seed[],uint8_t Key[])  ;


void UDS_Service_27_Indication(uint32_t A_TA_type, uint16_t A_Length, uint8_t A_Data[])
{
    uint8_t NRC = positiveResponse;
    setDiagMSG(A_TA_type, A_Length, A_Data);
    if(NRC == positiveResponse)
    {
        NRC = UDS_27Service_NRC11();                                            /*27Ƿֹ֧Ѱַ*/
    }
    if(NRC == positiveResponse)
    {
        NRC = UDS_27Service_NRC7F();                                            /*27ỰǷ֧֤*/
    }
    if(NRC == positiveResponse)
    {
        NRC = UDS_27Service_NRC33();                                            /*27ȼ֤*/
    }
    if(NRC == positiveResponse)
    {
        NRC = UDS_27Service_NRC13_MinLengthCheck();                             /*27С֤*/
    }
    if(NRC == positiveResponse)
    {
        NRC = UDS_27Service_NRC31();                                            /*27񳬳Χ֤*/
    }
    if(NRC == positiveResponse)
    {
        NRC = UDS_27Service_NRC13_TotalLengthCheck();                           /*27ܳȳ֤*/
    }
    if(NRC == positiveResponse)
    {
        NRC = UDS_27Service_NRC22();                                            /*27֤*/
    }
    if(NRC == positiveResponse)
    {
        UDS_27Service_Sub();                                                    /*27ӹ*/
    }
    clearDiagMSG();                                                             /*Ϣ*/
}

/**
  *10ӹ
  */
void UDS_27Service_Sub(void)
{
    uint8_t NRC = positiveResponse;
    if(NRC == positiveResponse)
    {
        NRC = UDS_27Service_Sub_NRC13_MinLengthCheck();                         /*27ӹС֤*/
    }
    if(NRC == positiveResponse)
    {
        NRC = UDS_27Service_Sub_NRC12();                                        /*27ӹǷ֧֤*/
    }
    if(NRC == positiveResponse)
    {
        NRC = UDS_27Service_Sub_NRC7E();                                        /*27ӹܻỰǷ֧֤*/
    }
    if(NRC == positiveResponse)
    {
        NRC = UDS_27Service_Sub_NRC31();                                        /*27ӹܳΧ֤*/
    }
    if(NRC == positiveResponse)
    {
        NRC = UDS_27Service_Sub_NRC13_TotalLengthCheck();                       /*27ӹܳȳ֤*/
    }
    if(NRC == positiveResponse)
    {
        NRC = UDS_27Service_Sub_NRC24();                                        /*27ӹ˳֤*/
    }
    if(NRC == positiveResponse)
    {
        NRC = UDS_27Service_Sub_NRC22();                                        /*27ӹ֤*/
    }
     if(NRC == positiveResponse)
    {
        NRC = UDS_27Service_Sub_NRC37();                                        /*27ʱ֤*/
    }

    if(NRC == positiveResponse)
    {
        switch(DiagMSG.msgData.SidDetail.SubID)                                 /*ӷж*/
        {
        case requestSeed_LV1:
            UDS_27Service_Sub01();                                              /*2701ӹ*/
            break;
        case sendKey_LV1:
            UDS_27Service_Sub02();                                              /*2702ӹ*/
            break;
        default:
            break;
        }
    }
}

 /**
  *2701ӹ
  */
void UDS_27Service_Sub01(void)
{
    uint8_t randomseed[4];
    if(Ser27_FlowCtrl.LV1SafetyStatus != NormalKeyUnlock )
    {
        if(Ser27_FlowCtrl.LV1Ctrl != SER27_REQ_SEEDED)
        {
            Ser27_CreateRandomSeed();
            Ser27_FlowCtrl.LV1Seed[0] = ((uint8_t)(Ser27_SeedRandomNumber) ^ 0x31u)+16u ;
            Ser27_FlowCtrl.LV1Seed[1] = ((uint8_t)(Ser27_SeedRandomNumber>>8) ^ 0x56u)+9u ;
            Ser27_FlowCtrl.LV1Seed[2] = ((uint8_t)(Ser27_SeedRandomNumber>>16) ^ 0x87u)+1u ;
            Ser27_FlowCtrl.LV1Seed[3] = ((uint8_t)(Ser27_SeedRandomNumber>>24) ^ 0x92u)+21u ; 
        }
        else
        {
            Ser27_FlowCtrlCnt.LV1ReqSeedCnt +=1u;
        }
        /*
        FailCntD-Flash*/
        Ser27_WriteCtrlInfoToDFlash();
        Ser27_FlowCtrl.LV1Ctrl = SER27_REQ_SEEDED;
        if( Ser27_FlowCtrlCnt.LV1ReqSeedCnt >= SER27_MAX_REQ_SEED_NUM )
        {
            Ser27_EnDelayTimer();
            Ser27_FlowCtrl.LV1Ctrl = SER27_CLEAR_REQ_SEEDED;
        }
    }
    else
    {
        Ser27_FlowCtrl.LV1Seed[0] = 0u;
        Ser27_FlowCtrl.LV1Seed[1] = 0u;
        Ser27_FlowCtrl.LV1Seed[2] = 0u;
        Ser27_FlowCtrl.LV1Seed[3] = 0u;
    }
    DiagMSG.msgData.SidDetail.Data[0] = Ser27_FlowCtrl.LV1Seed[0]; 		  
    DiagMSG.msgData.SidDetail.Data[1] = Ser27_FlowCtrl.LV1Seed[1];		    
    DiagMSG.msgData.SidDetail.Data[2] = Ser27_FlowCtrl.LV1Seed[2];      
    DiagMSG.msgData.SidDetail.Data[3] = Ser27_FlowCtrl.LV1Seed[3];      
    randomseed[0] = Ser27_FlowCtrl.LV1Seed[0];
    randomseed[1] = Ser27_FlowCtrl.LV1Seed[1]; 
    randomseed[2] = Ser27_FlowCtrl.LV1Seed[2]; 
    randomseed[3] = Ser27_FlowCtrl.LV1Seed[3];
    /*randomseed[0] = 0x5c;
    randomseed[0] = 0x36;
    randomseed[0] = 0x5E;
    randomseed[0] = 0x93;*/

    if((randomseed[0] ==0x00u) &&(randomseed[1] ==0x00u) &&(randomseed[2] ==0x00u) &&(randomseed[3] ==0x00u))
    {

    }
    else
    {
        Ser27_CalculateKeyLV1(randomseed, Ser27_FlowCtrl.LV1Key);
    }
    if(DiagMSG.msgData.SidDetail.PositiveSuppression == 0u)
    {
        UDS_Service_Response(0x27u, POSITIVE_RSP, DIAG_ID_Tx, 5u, DiagMSG.msgData.Data);
    }
}

 /**
  *2702ӹ
  */
void UDS_27Service_Sub02(void)
{
    uint32_t KeyReceive;
    uint32_t KeyCalcValue;

    KeyReceive =(uint32_t)DiagMSG.msgData.SidDetail.Data[0];
    KeyReceive =(KeyReceive<<8u) | ((uint32_t)DiagMSG.msgData.SidDetail.Data[1]);
    KeyReceive =(KeyReceive<<8u) | ((uint32_t)DiagMSG.msgData.SidDetail.Data[2]);
    KeyReceive =(KeyReceive<<8u) | ((uint32_t)DiagMSG.msgData.SidDetail.Data[3]);

    KeyCalcValue =(uint32_t)Ser27_FlowCtrl.LV1Key[0];
    KeyCalcValue =(KeyCalcValue<<8u) | ((uint32_t)Ser27_FlowCtrl.LV1Key[1]);
    KeyCalcValue =(KeyCalcValue<<8u) | ((uint32_t)Ser27_FlowCtrl.LV1Key[2]);
    KeyCalcValue =(KeyCalcValue<<8u) | ((uint32_t)Ser27_FlowCtrl.LV1Key[3]);

    if(KeyReceive == KeyCalcValue)
    {
        Ser27_FlowCtrl.LV1SafetyStatus = NormalKeyUnlock; 
        Ser27_FlowCtrl.LV1Ctrl = SER27_CLEAR_REQ_SEEDED;
        Ser27_FlowCtrlCnt.LV1InvaidKyeCnt = 0u;
        Ser27_FlowCtrlCnt.LV1ReqSeedCnt = 0u; 
        DiagMSG.msgData.Data[0]=sendKey_LV1;
        /*flashд纯*/
        Ser27_WriteCtrlInfoToDFlash();
           
        if(DiagMSG.msgData.SidDetail.PositiveSuppression == 0u)
        {
            UDS_Service_Response(0x27u, POSITIVE_RSP, DIAG_ID_Tx, 1u, DiagMSG.msgData.Data);
        }
    }
    else
    {
        Ser27_FlowCtrlCnt.LV1ReqSeedCnt +=1u;
        /*flashд纯*/
        Ser27_WriteCtrlInfoToDFlash();
        if(Ser27_FlowCtrlCnt.LV1ReqSeedCnt >= SER27_MAX_REQ_SEED_NUM  )
        {
            Ser27_EnDelayTimer();
            UDS_27Service_Sub_NRC36();  
        }
        else
        {
            UDS_27Service_Sub_NRC35();
        }
         Ser27_FlowCtrl.LV1Ctrl = SER27_CLEAR_REQ_SEEDED;  
    }
}

static void Ser27_CalculateKeyLV1(uint8_t Seed[],uint8_t Key[])       
{
    uint16_t i;
    uint8_t Cal[4];
    
    for(i=0u; i<4u; i++)
    {
        Cal[i]=Seed[i]^XorArray[i];
    }
    
    
    /*Key[0]=((Cal[3]&0x0Fu)<<4u)|(Cal[3]&0xF0u);
    Key[1]=((Cal[1]&0x0Fu)<<4u)|((Cal[0]&0xF0u)>>4u);
    Key[2]=(Cal[1]&0xF0u)|((Cal[2]&0xF0u)>>4u);
    Key[3]=((Cal[0]&0x0Fu)<<4u)|(Cal[2]&0x0Fu); */
    
    Key[0] = ((Cal[3] & 0x0F) << 4) | (Cal[3] & 0xF0);
	  Key[1] = ((Cal[1] & 0x0F) << 4) | ((Cal[0] & 0xF0) >> 4);
		Key[2] = ((Cal[1] & 0xF0)) | ((Cal[2] & 0xF0) >> 4);
		Key[3] = ((Cal[0] & 0x0F) << 4) | ((Cal[2] & 0x0F));
    
    
    
    
}

