/************************************************ ******************************
 ? ??YGV642_SPI.c
|ڧ??YGV642̧?SPI???ӧ?
    ??ܧ
    ???V1.0
    ??2017.4.8
******************************************************************************/
#include "Include.h"
//#include "Simulated_8080.h"

void Sim_8080_Init ( void )
{
    SIM_8080_P_nCS  = 1;
    nop();
    nop();
    nop();
    nop();
    nop();
    nop();
    nop();
    nop();
    SIM_8080_P_A0   = 1;
    SIM_8080_P_nRD  = 1;
    SIM_8080_P_nWR  = 1;
    SIM_8080_P_DATA = 0x00;
    SIM_8080_P_DIR  = 0xFF;
}

/******************************************************************************
??理??YGV642_SPI_Byte_Write
|  ??痢?SPIYGV642?1??
?  ??Data????̧?
???
******************************************************************************/
void Sim_8080_Command_Write ( uint8_t Cmd )
{
    SIM_8080_P_A0   = 0;      //Command Config_0X20D
    SIM_8080_P_nCS  = 0;      //Selecte chip
    SIM_8080_P_nWR  = 0;      //Prepare for command transfer
    nop();
    nop();
    SIM_8080_P_DATA = Cmd;    //Set command
    nop();
    nop();
    nop();
    nop();
    nop();
    nop();
    nop();
    nop();
    SIM_8080_P_nWR  = 1;      //Latch command
    nop();
    nop();
    nop();
    nop();
    nop();
    nop();
    nop();
    nop();
    SIM_8080_P_nCS  = 1;      //Release chip
    SIM_8080_P_DATA = 0x00;   //Idle data
}


void Sim_8080_Data_Write ( uint8_t Dat )
{
    SIM_8080_P_A0   = 1;      //Data transmission
    SIM_8080_P_nCS  = 0;      //Selecte chip
    SIM_8080_P_nWR  = 0;      //Prepare for data transfer
    nop();
    nop();
    SIM_8080_P_DATA = Dat;    //Set data
    nop();
    nop();
    nop();
    nop();
    nop();
    nop();
    nop();
    nop();
    SIM_8080_P_nWR  = 1;      //Latch data
    nop();
    nop();
    nop();
    nop();
    nop();
    nop();
    nop();
    nop();
    SIM_8080_P_nCS  = 1;      //Release chip
    SIM_8080_P_DATA = 0x00;   //Idle data
}


uint8_t Sim_8080_Data_Read ( void )
{
    uint8_t Dat;
    SIM_8080_P_A0   = 1;      //Data read
    SIM_8080_P_nCS  = 0;      //Selecte chip
    SIM_8080_P_DIR  = 0x00;   //Data input
    nop();
    SIM_8080_P_nRD  = 0;      //Prepare for data read
    nop();
    nop();
    nop();
    nop();
    nop();
    nop();
    nop();
    nop();
    nop();
    nop();
    Dat = SIM_8080_P_DATA;    //Read data
    SIM_8080_P_nRD  = 1;      //Stop data reading
    nop();
    nop();
    nop();
    nop();
    nop();
    nop();
    nop();
    nop();
    SIM_8080_P_nCS  = 1;      //Release chip
    SIM_8080_P_DIR  = 0xFF;   //Data output
    SIM_8080_P_DATA = 0x00;   //Idle data
    return Dat;
}
