
#include "Include.h"
#include "Power_Management.h"
 INT8U TEST121;

//IGOFF��ʱ�����ߵ�ʱ��
//���߿���һ��ʱ��������CAN����
#define Power_Wait_Bus_Sleep_Time 50//1    00MSΪ��λ      5S


/* ---------------------------------------------------------------------------------------------------------------------------
��������
---------------------------------------------------------------------------------------------------------------------------*/
//��Դ����������ʼ����ʼ��
void Power_Management_Variate_Init(void);
void Power_Sleep_Loop(void);
void lcd_init_test(void);
/* ---------------------------------------------------------------------------------------------------------------------------
��������
---------------------------------------------------------------------------------------------------------------------------*/
//INT8U Power_Wait_Bus_Sleep_CounDoor_Open_CAN_Delay_Time_ADD_Ent=0;       //���߿��м�ʱ����
INT16U Power_OFF_Delay_Time = 0; //OFF����ʱ���ߵģ���ʱ����
INT16U Bus_Sleep_Mode_Delay_Time ;// = 0;
uint8_t  LAST_SYS_OPR_STAT_HALT;
uint8_t  LAST_NVM_Wake_Up = 0;
uint8_t  NVM_Wake_Up = 0;
extern INT8U Popups_SelfCheckTime;
//OFF֮��CAN�����ⷢ����ʱ��




volatile uint16_t AnalogKL30Voltage;
volatile uint16_t AnalogKL15Voltage;

static uint16_t CanIdleTimer = 0;
extern uint8_t Sleep_Timer_100ms;
extern uint8_t CAN_Timer_100ms;
extern INT8U GUINaviBar_Flag;

//�״���30�Ա�����ʼ��//����������������ϵͳ��ʼ��֮ǰ
void Power_On_Variable_Init(void)
{
	Motor_Init_Poweron_System();
	Line_In_KL30_Init();
//	Drive_Info_Speed_Plus_Conversion_Init();
	Sound_Scheduler_Init(SoundAlarm_MAX);
	Buzzer_Play_Init(SoundAlarm_MAX, Buzzer_Variety_Single_Loop);
	DataProcessor_On_System_Init();
//	Data_Manage_On_System_Init();
	GUI_Display_INIT_KL30();
	Backlight_Init();
	//SET_YB_InitData();
	Popups_IG_On_Init();
	Popup_Scheduler_Init();
	Lamp_Init();
	LED_Driver_Shutdown_Pin_Set(1);
	Button_Init();
	LAST_SYS_OPR_STAT_HALT = 0 ;
	
	Menu_User_Init(Menu_User_Init_Power_K30);
	OTA_Display_Info_KL15_30_Init();
	RevolutionSpeed_Init(DispPointer);

//	Set_30KL_Init();
}

//��Ҫ����ִ�еĲ�����ʼ��
void Power_On_Variable_Init_First(void)
{
	//CAN_APP_TX_Time_Reset();
}

void Power_On_Memory_Init(void)
{
	uint8_t i = 0;
	NVM_Init();
	ReadAllDFlashData();
	//Fuel_KL30_Read_Config_Init();
	//CoolantTemp_KL30_Read_Config_Init();
	TPMS_Config.F101  = Val_EOL_F101_TPMSType();
	TPMS_Config.F110  = Val_EOL_F110_TPMS();
	BrakeType_Config.F101  = Val_EOL_F101_Break();
	AC_Config.F110 = Val_EOL_F110_AC();
}

//�״�+KL30����.
void Power_On_System_Init(void)
{
	LED_Driver_Par_st_t stLEDDriverPar;
	DisableInterrupts;
	IVBR = 0xFb; // relocate interrupt table to 0xFB00;
	Clock_Init();
	CheckOSC();
	COM_CAN_Init( );//shi+can
	WDT_Init();
	GPIO_Init_First();
	LED_Driver_Init_Example();
	IIC_Init();
	Simulated_IIC_2_Init();
	//MSCAN0_Exit_Low_Power_Mode();
	RTI_Init();
	Analog_Signal_Conv_Init();
	PWM_Init();
	PWM_Wake_Up_Init();
	//Power_On_Variable_Init_First();
	bsp_TIMER0_Init();
	bsp_TIMER1_Init();
	API_Start();
	
	TXCANKL30WakeupInit();//shi+can
	CanNm_Init(); //����
	//CoCAN_Init();//shican
	UDS_10Service_S28Init();
	//stLEDDriverPar.pfnLEDDriverShutdownPinSetCallBack = LED_Driver_Shutdown_Pin_Set;
	//stLEDDriverPar.u8LEDDriverChipNum = LED_DRIVER_CHIP_NUM;
	//stLEDDriverPar.pu8IS31ChipAddress = u8IS31ChipAddress;
	//stLEDDriverPar.pu8AW21036ChipAddress = u8AW21036ChipAddress;
	//LED_Driver_Init_KL30(u8LEDDriverRamData, &stLEDDriverPar);
	
	EnableInterrupts;
	
	Power_KL30_Voltage_Conversion();
	Power_KL15_Voltage_Conversion();
	
         Backlight_Init();
	
	//Lamp_Init	();
	//LockVeh_Sts = 0;
	//EMSLockVeh_Sts = 0;
	LED_Driver_Shutdown_Pin_Set(1);
         Page_30KL_Init();
	TFT_LCD_Startup();
	Can_Receive_KL30_WakeUp_Init();

}

void Power_Management_Init(void)
{
	Power_On_System_Init();
	wdt_reset();
	Power_On_Memory_Init();
	Power_On_Variable_Init();
	Power_Management_Variate_Init();
}

/* ---------------------------------------------------------------------------------------------------------------------------
�ߵ�ѹ�жϲ���
---------------------------------------------------------------------------------------------------------------------------*/
typedef struct
{
	INT16U Abnormal_Enter_Threshold;	 //�쳣��ѹ������ֵ//��λmv
	INT16U Abnormal_Enter_Debounce_Time; //�쳣��ѹ�������ʱ��//��λms
	INT16U Abnormal_Exit_Threshold;		 //�쳣��ѹ�˳���ֵ//��λmv
	INT16U Abnormal_Exit_Debounce_Time;	 //�쳣��ѹ�˳�����ʱ��//��λms

} Voltage_Abnormal_Type;

//��ѹ�쳣����
const Voltage_Abnormal_Type Voltage_Abnormal_High_Parameter =
	{32000, 100, 31500, 100};//	{32000, 100, 31500, 100};
//��ѹ�쳣����
const Voltage_Abnormal_Type Voltage_Abnormal_Low_Parameter =
	{18000, 100, 18500, 100};	//{18000, 100, 18500, 100};



//Off״̬��˯��״̬�ĳ�ʼ������
void Power_OFF_To_Sleep_Init(void)
{
	wdt_reset();
	LedDriveCheck_Timer = 0 ;	
	LED_Driver_Init_Sleep();
	PWM_Sleep_Init();
	GUI_Display_INIT_Sleep();
	TFT_LCD_Shutdown();
	bsp_TIMER_Stop();
	API_Stop();
	Gauges_Sleep_Init();
	Analog_Signal_Conv_Stop();
	GPIO_Sleep_Init();
	Button_Sleep_Init();
}

//˯��״̬��OFF״̬�ĵĳ�ʼ������//���Ѳ���
void Power_Sleep_To_OFF_Init(void)
{
	LED_Driver_Par_st_t stLEDDriverPar;
	Clock_Init();
	CheckOSC();
	GPIO_WakeUp_Init();
	LED_Driver_Init_Example();
	COM_CAN_Init( );//shi+can
	//CoCAN_Init();//shican
	wdt_reset();
	//CAN���������Ƿ��޸�
	//CoCAN_Reset();//shican
	//TXCANKL15Init();//shi+can
	//TXCANKL30WakeupInit();//shi+can
	Analog_Signal_Conv_Init();
	bsp_TIMER0_Init();
	bsp_TIMER1_Init();
	Power_OFF_Delay_Time = 0;

	API_Start();
	PWM_Wake_Up_Init();
	TFT_LCD_Startup();
	
	//stLEDDriverPar.pfnLEDDriverShutdownPinSetCallBack = LED_Driver_Shutdown_Pin_Set;
	//stLEDDriverPar.u8LEDDriverChipNum = LED_DRIVER_CHIP_NUM;
	//stLEDDriverPar.pu8IS31ChipAddress = u8IS31ChipAddress;
	//stLEDDriverPar.pu8AW21036ChipAddress = u8AW21036ChipAddress;
	//LED_Driver_Init_KL30(u8LEDDriverRamData, &stLEDDriverPar);
	
	Menu_User_Init(Menu_User_Init_Power_WakeUp);
	OTA_Display_Info_KL15_30_Init();

}
//OFF��ON�ĳ�ʼ������
void Power_OFF_To_ON_Init(void)
{
	Line_In_KL15_ON_Init();
	Lamp_Init();
	Motor_Init_Poweron_IGN();
	TFT_LCD_Startup();
	DataProcessor_OFF_To_ON_Init();
	//Data_Manage_OFF_To_ON_Init();
	 Button_Init();
	GUI_Display_INIT_KL15();
//	Set_15KL_Init();
	//CoCAN_Reset();//shican
	TXCANKL15Init();//shi+can
	Page_OFF_TO_ON_Init();
	Menu_User_Init(Menu_User_Init_Power_K15);
	Popups_IG_On_Init();
	OTA_Display_Info_KL15_30_Init();
	Sound_Play_Switch_Handle(Sound_Play_Control);
	TEST121 = 0;
	lcd_init_test();
	TFT_LCD_BUF_Clean();

}
//ON��OFF�ĳ�ʼ������
void Power_ON_To_OFF_Init(void)
{
         Motor_IGNOFF();
	Power_OFF_Delay_Time = 0;
	PageInfo.u16SelfCheckTimeCnt = 0;
	Popups_SelfCheckTime = 0;
	Line_In_KL15_OFF_Init();	
	Popup_Scheduler_OFF();		
	GUINaviBar_Flag = 0;		  
	TEST121 = 0;  

}
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
void Power_KL15_Voltage_Conversion(void)
{	
	AnalogKL15Voltage = ADC_Conv_Single_Channel(1) ;
}

void Power_KL30_Voltage_Conversion(void)
{
	AnalogKL30Voltage = ADC_Conv_Single_Channel(0) ;
}


							     

//100ms     ����һ��

void Power_Management_Time_Handle(void)			      
{
	if(SYS_OPR_STAT_IGN_OFF)
	{
		if (Power_OFF_Delay_Time < Power_Wait_Bus_Sleep_Time)
		{
			Power_OFF_Delay_Time++;
		}
		
		if((CanNm_GetMode() == Bus_Sleep_Mode)  )
		{
			if (Bus_Sleep_Mode_Delay_Time < BusSleep_Wait_Mode_Time)
			{
				Bus_Sleep_Mode_Delay_Time++;
			}	
		}
	}
}

//��OFF״̬ʱ������Ƿ�����˯������
//����0��ʾ����������//����1��ʾ��������������ִ��˯�߲���

INT8U Power_Check_Sleep_Conditions(void)
{
	INT8U Wake_Up_Status = 0;
	
	if((CanNm_GetMode() != Bus_Sleep_Mode)  )
	{
		Wake_Up_Status = 1;
		Bus_Sleep_Mode_Delay_Time = 0 ;
		NVM_Wake_Up = 0;
	}
	else
	{
		Wake_Up_Status = 0;
		if(Bus_Sleep_Mode_Delay_Time >= BusSleep_Wait_Mode_Time )
		{
			NVM_Wake_Up = 1;	
		}	
	} 
	if(LAST_NVM_Wake_Up!= NVM_Wake_Up )   
	{
		if(NVM_Wake_Up )
		{
			Sound_Play_Switch_Handle(Sound_Play_NOTControl);
			DoorOpen.u16OffTimer  = 300;
			//ChargeStatus.u8Flag = 3; 	
		}
		else
		{
			DoorOpen.u16OffTimer = 0;
			Sound_Play_Switch_Handle(Sound_Play_Control);		
		}
		LAST_NVM_Wake_Up = NVM_Wake_Up;
	}
	
	//CANδ����//EEPROMδд�����//������δֹͣ
	//OFFʱ�䲻��20s//�л���Ӳ���ź�		
//	if ((MSCAN0_Get_Wake_Up_Flag()) || (NVMUpdateCtrl.Enable) || (Buzzer_Get_PlayStatus()) ||
//	(Wake_Up_Status)|| (Power_OFF_Delay_Time < Power_Wait_Bus_Sleep_Time) )
	if ( (NVMUpdateCtrl.Enable) || (Buzzer_Get_PlayStatus()) ||
	(Wake_Up_Status)|| (Power_OFF_Delay_Time < Power_Wait_Bus_Sleep_Time) )
	{
		return 0;
	}
	else
	{
		return 1;
	}
}
//��sleep״̬ʱ������Ƿ����㻽������
//��15��֮��Ļ�������
//����0��ʾ����������//����1��ʾ���㻽������������ִ�л��Ѷ���
INT8U Power_Check_Wakeup_Conditions(void)
{
	INT8U Wake_Up_Status = 0;
	
	if(CanNm_GetMode() != Bus_Sleep_Mode)  
	{
		Wake_Up_Status = 1;	
	}
	else
	{
		Wake_Up_Status = 0;
	}       

	//CAN，硬线两种可以唤醒仪�?
	if( (MSCAN0_Get_Wake_Up_Flag())|| (Wake_Up_Status))
	{
		return 1;
	}
	else
	{
		return 0;
	}
}

//////////////��������һ�㲻Ҫ����//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//////////////��������һ�㲻Ҫ����//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//////////////��������һ�㲻Ҫ����//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

/*IG��Դ״̬��������ʱ*/
typedef struct
{
	INT8U Status;
	INT16U Timer;
} SysSignalStatusStruct;

SysPwrModeStruct SysPwrMode;
SysSignalStatusStruct SysKL15Signal;
_IGN_Status g_PowerIGN;

/////////////////////////////////////////////////////////////////////////////////////////

#define SYS_SIG_STAT_INACTIVE 0x00 //û��⵽15��
#define SYS_SIG_STAT_ACTIVE 0x01   //��⵽15��

#define SYS_OFF_THRESHOLD 6000 //��Դ(KL15)�ر���ֵ	 
#define SYS_ON_THRESHOLD 6500  //��Դ(KL15)������ֵ 

#define SYS_IGOFF_Delay_Time 100//120 //ms//�µ���ʱʱ��
#define Voltage_Abnormal_Call_Cycle 20
//��ѹ�쳣��⣬��ͬģʽ�¶�Ҫ�����ж�
//20ms ����һ��//Ĭ��˯��ʱ������ѹ�쳣//û�г�ʼ��״̬
void Power_Voltage_Abnormal_Detect(INT16U Voltage)
{
	if (Voltage < 0xFFFF)  //��Чֵʱ�Ž����ж�
	{
		//��ѹ����ʱ�Ĵ���
		if (_Power_Normal == SysPwrMode.Mode)
		{
			if (Voltage <= Voltage_Abnormal_Low_Parameter.Abnormal_Enter_Threshold)
			{
				SysPwrMode.Low_Vo_Timer ++ ;//= Voltage_Abnormal_Call_Cycle;
				SysPwrMode.High_Vo_Timer = 0;
			}
			else if (Voltage >= Voltage_Abnormal_High_Parameter.Abnormal_Enter_Threshold)
			{
				SysPwrMode.Low_Vo_Timer = 0;
				SysPwrMode.High_Vo_Timer ++;
			}
			else
			{
				SysPwrMode.Low_Vo_Timer = 0;
				SysPwrMode.High_Vo_Timer = 0;
			}

			if (SysPwrMode.Low_Vo_Timer >= Voltage_Abnormal_Low_Parameter.Abnormal_Enter_Debounce_Time)
			{
				SysPwrMode.Mode = _Power_Low;
				SysPwrMode.Low_Vo_Timer = 0;
				SysPwrMode.High_Vo_Timer = 0;
				SysPwrMode.Normal_Vo_Timer = 0;
			}
			else if (SysPwrMode.High_Vo_Timer >= Voltage_Abnormal_High_Parameter.Abnormal_Enter_Debounce_Time)
			{
				SysPwrMode.Mode = _Power_High;
				SysPwrMode.Low_Vo_Timer = 0;
				SysPwrMode.High_Vo_Timer = 0;
				SysPwrMode.Normal_Vo_Timer = 0;
			}
			// else //��ѹ������ʱ�����߳���ʱ��δ��������ԭ��״̬//ע���ʱ��������
			// {
			// 	SysPwrMode.Mode = _Power_Normal;
			// 	SysPwrMode.Low_Vo_Timer = 0;
			// 	SysPwrMode.High_Vo_Timer = 0;
			// 	SysPwrMode.Normal_Vo_Timer = 0;
			// }
		}
		//��ѹ�ͣ�ʱ�Ĵ���
		else if (_Power_Low == SysPwrMode.Mode)
		{
			if (Voltage > Voltage_Abnormal_High_Parameter.Abnormal_Enter_Threshold)
			{
				SysPwrMode.High_Vo_Timer ++;
				SysPwrMode.Normal_Vo_Timer = 0;
			}
			else if (Voltage > Voltage_Abnormal_Low_Parameter.Abnormal_Exit_Threshold)
			{
				SysPwrMode.High_Vo_Timer = 0;
				SysPwrMode.Normal_Vo_Timer ++;
			}
			else
			{
				SysPwrMode.High_Vo_Timer = 0;
				SysPwrMode.Normal_Vo_Timer = 0;
			}

			if (SysPwrMode.Normal_Vo_Timer >= Voltage_Abnormal_Low_Parameter.Abnormal_Exit_Debounce_Time)
			{
				SysPwrMode.Mode = _Power_Normal;
				SysPwrMode.Low_Vo_Timer = 0;
				SysPwrMode.High_Vo_Timer = 0;
				SysPwrMode.Normal_Vo_Timer = 0;
			}
			else if (SysPwrMode.High_Vo_Timer >= Voltage_Abnormal_High_Parameter.Abnormal_Enter_Debounce_Time)
			{
				SysPwrMode.Mode = _Power_High;
				SysPwrMode.Low_Vo_Timer = 0;
				SysPwrMode.High_Vo_Timer = 0;
				SysPwrMode.Normal_Vo_Timer = 0;
			}
			// else//��ѹ������ʱ�����߳���ʱ��δ��������ԭ��״̬//ע���ʱ��������
			// {
			// 	SysPwrMode.Mode = _Power_Low;
			// 	SysPwrMode.Low_Vo_Timer = 0;
			// 	SysPwrMode.High_Vo_Timer = 0;
			// 	SysPwrMode.Normal_Vo_Timer = 0;
			// }
		}
		//��ѹ�ߣ�ʱ�Ĵ���
		else //if(_Power_High==SysPwrMode.Mode)
		{
			if (Voltage < Voltage_Abnormal_Low_Parameter.Abnormal_Enter_Threshold)
			{
				SysPwrMode.Low_Vo_Timer ++;
				SysPwrMode.Normal_Vo_Timer = 0;
			}
			else if (Voltage < Voltage_Abnormal_High_Parameter.Abnormal_Exit_Threshold)
			{
				SysPwrMode.Low_Vo_Timer = 0;
				SysPwrMode.Normal_Vo_Timer ++;
			}
			else
			{
				SysPwrMode.Low_Vo_Timer = 0;
				SysPwrMode.Normal_Vo_Timer = 0;
			}
			//
			if (SysPwrMode.Low_Vo_Timer >= Voltage_Abnormal_Low_Parameter.Abnormal_Enter_Debounce_Time)
			{
				SysPwrMode.Mode = _Power_Low;
				SysPwrMode.Low_Vo_Timer = 0;
				SysPwrMode.High_Vo_Timer = 0;
				SysPwrMode.Normal_Vo_Timer = 0;
			}
			else if (SysPwrMode.Normal_Vo_Timer >= Voltage_Abnormal_High_Parameter.Abnormal_Exit_Debounce_Time)
			{
				SysPwrMode.Mode = _Power_Normal;
				SysPwrMode.Low_Vo_Timer = 0;
				SysPwrMode.High_Vo_Timer = 0;
				SysPwrMode.Normal_Vo_Timer = 0;
			}
			// else//��ѹ������ʱ�����߳���ʱ��δ��������ԭ��״̬//ע���ʱ��������
			// {
			// 	SysPwrMode.Mode = _Power_Low;
			// 	SysPwrMode.Low_Vo_Timer = 0;
			// 	SysPwrMode.High_Vo_Timer = 0;
			// 	SysPwrMode.Normal_Vo_Timer = 0;
			// }
		}
	}
}
//KL15���⣬���15������ޣ������Ǹߵ�
//20msһ���ݶ�
void Power_Voltage_KL15ON_Detect(INT16U Voltage)
{
	if (Voltage < 0xFFFF) //��Чֵʱ�Ž����ж�
	{
		//IGN״̬���
		if (SysKL15Signal.Status == SYS_SIG_STAT_ACTIVE)
		{
			if (Voltage < SYS_OFF_THRESHOLD)
			{
				SysKL15Signal.Timer += Voltage_Abnormal_Call_Cycle ;
				if (SysKL15Signal.Timer >= SYS_IGOFF_Delay_Time)
				{
					SysKL15Signal.Status = SYS_SIG_STAT_INACTIVE;
					SysKL15Signal.Timer = 0;
				}
			}
			else
			{
				SysKL15Signal.Timer = 0;	
			}
		}
		else //�ݶ�
		{
			if (Voltage >= SYS_ON_THRESHOLD)
			{
				//SysKL15Signal.ActTimer++;
			//	if (SysKL15Signal.ActTimer >= Debounce_Count)
			//	{
				SysKL15Signal.Status = SYS_SIG_STAT_ACTIVE;
			//	SysKL15Signal.Timer = 0;
			//	}
			}
		//	else
		//	{
		//		SysKL15Signal.Timer = 0;	
		//	}
			
		}
	}
}



//�ֱ���30��15���ѹֵ//mv��λ
void Power_Status_Update_Service(INT16U Voltage_KL30, INT16U Voltage_KL15)
{
	//�жϴ����ѹ�Ƿ���Ч
	Power_Voltage_KL15ON_Detect(Voltage_KL15);
	if (g_PowerIGN != _IGN_Sleep)
	{
		Power_Voltage_Abnormal_Detect(Voltage_KL30);
	}
}

// ��ѭ��ʵʱ����
void Power_Management_Service(void)
{
	switch (g_PowerIGN)
	{
		case _IGN_OFF:
		{
			if (SysKL15Signal.Status == SYS_SIG_STAT_ACTIVE)
			{
				 Bus_Sleep_Mode_Delay_Time	   = 0;
				CanNm_NetworkRequest(NM_REQ_KL15_ON);   
				Power_OFF_To_ON_Init();
				g_PowerIGN = _IGN_ON;
			}
			else
			{
				INT8U Conditon = Power_Check_Sleep_Conditions();
				CanNm_NetworkRelease(NM_REQ_KL15_OFF);
				if(IsNMTimerOut(NM_Tdiag_Timer)) 
				{
				  NMStopTimer(NM_Tdiag_Timer);
				  CanNm_NetworkRelease(NM_REQ_DIAG_TIMEOUT);
				}	
				if (Conditon) //����˯������
				{
					Power_OFF_To_Sleep_Init();
					g_PowerIGN = _IGN_Sleep;
				}
				else
				{
				}
			}
			break;
		}
		case _IGN_Sleep:
		{				   
			Power_Sleep_Loop();
			Power_Sleep_To_OFF_Init();
			g_PowerIGN = _IGN_OFF;
			break;
		}
		case _IGN_ON:
		{
			if (SysKL15Signal.Status != SYS_SIG_STAT_ACTIVE)
			{
				CanNm_NetworkRelease(NM_REQ_KL15_OFF);
				if(IsNMTimerOut(NM_Tdiag_Timer)) 
				{
				  NMStopTimer(NM_Tdiag_Timer);
				  CanNm_NetworkRelease(NM_REQ_DIAG_TIMEOUT);
				}
				Power_ON_To_OFF_Init();
				g_PowerIGN = _IGN_OFF;
			}
			break;
		}

		default:
		{
			CanNm_NetworkRelease(NM_REQ_KL15_OFF);
			if(IsNMTimerOut(NM_Tdiag_Timer)) 
			{
			  NMStopTimer(NM_Tdiag_Timer);
			  CanNm_NetworkRelease(NM_REQ_DIAG_TIMEOUT);
			}		
			Power_ON_To_OFF_Init();
			g_PowerIGN = _IGN_OFF;
			break;
		}
	}
}
//电源管理变量初�?�化初�?�化
void Power_Management_Variate_Init(void)
{

	SysKL15Signal.Status = SYS_SIG_STAT_INACTIVE;
	SysKL15Signal.Timer = 0;

	SysPwrMode.Mode = _Power_Normal;
	SysPwrMode.Low_Vo_Timer = 0;
	SysPwrMode.Normal_Vo_Timer = 0;
	SysPwrMode.High_Vo_Timer = 0;

	g_PowerIGN = _IGN_OFF;
}

//睡眠时需要循�?执�?�的函数添加进去//包括单片机休眠指�?
void Power_Sleep_Loop(void)
{
	uint8_t sleepFlag = 0;

	while(1) 
	{
		wdt_reset();

		if((CanNm_GetMode() != Bus_Sleep_Mode) || (SysKL15Signal.Status == SYS_SIG_STAT_ACTIVE)) 
		{
			if(SYS_OPR_STAT_IGN_ON) 
			{
				CanNm_NetworkRequest(NM_REQ_KL15_ON);   
			}

			return;  
		} 

		if(sleepFlag == 0) 
		{
			Enter_Stop_Mode();
			if(MSCAN0_Get_Wake_Up_Flag())    
			{
				Clock_Init();
				MSCAN0_Exit_Low_Power_Mode();  
				//CAN0RFLG_WUPIF = 1;
				CanIdleTimer = 0;
				sleepFlag = 1;
			}
		} 
		else 
		{
			if(MSCAN0_Is_Exist_Frame())
			{
				CanIdleTimer = 0;		
			}
			else 
			{
				if(CAN_Timer_100ms) 
				{
					CanIdleTimer++;
					CAN_Timer_100ms = 0;
				}

				if(CanIdleTimer >= 40) 
				{
					CanIdleTimer = 0;
					MSCAN0_Enter_Low_Power_Mode(); 
					sleepFlag = 0; 		 
				}        
			}
		}

		CanNm_Service();
		RTI_Timing_Service();
		Data_IGN_Off_Timing_Service();
		Data_Driving_Time_OFF_Reset();

		if(Sleep_Timer_100ms) 
		{
			Sleep_Timer_100ms = 0;

			Analog_Signal_Conv_Init();
			Power_KL15_Voltage_Conversion();
			Analog_Signal_Conv_Stop ();

			Power_Status_Update_Service(AnalogKL30Voltage, AnalogKL15Voltage);
		}
	}
	return;
}

/******************************************************************************
��������Power_HALT_Service
��  ��: ��ѹ�쳣������
��  ��: ��
����ֵ����                                  
******************************************************************************/  
void Power_HALT_Service(void) 
{
       if(LAST_SYS_OPR_STAT_HALT != SYS_OPR_STAT_HALT)
        {
                LAST_SYS_OPR_STAT_HALT = SYS_OPR_STAT_HALT;
                if(!SYS_OPR_STAT_HALT)
                {
	                	Sound_Play_Switch_Handle(Sound_Play_Control);
	                	Lamp_Init();
	                	Data_15KL_Init();
	                	Button_Init();
	                	Page_OFF_TO_ON_Init(); 
	                	Menu_User_Init(Menu_User_Init_Power_K15);
	                	Menu_Language_Init();
	                	GUI_Display_INIT_KL15();
	                	Popups_IG_On_Init();
	                	DataOverSpeed = 120 ;
                }
                else
                {
					Clear_Box(0, 0, 239, 319);	
                }
        }

         
	
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
