
#include "Menu.h"
#include "Include.h"
/*-------------------------------------------------------*/


Menu_TimeSetData_Struct MenuData;
TMPS_Export_Sts TMPS_Learnning_Flag  = TMPS_Export_Max ;



/*-----------------------------------------------------------------*/

/*-------------------Logic_Operation Call Back---------------------*/


void Menu_Language_Init(void);
void Menu_User_Init(Menu_User_Init_PowerTypeEnum PowerType);

void MENU_TPMS_Exist_Config(void );
void MENU_Intf_Inside_Item_Select_Set(Menu_Item_en_t StartItem, Menu_Item_en_t EndItem, Menu_Item_en_t SelectItem);
/*��ȡĳһ����ѡ�еĹ�����*/
Menu_Item_en_t MENU_Intf_Inside_Item_Select_Get(Menu_Item_en_t StartItem, Menu_Item_en_t EndItem);
void Menu_u8Data_Updata_Process(uint8_t updateDir , uint8_t datMax, uint8_t datMin, uint8_t datStep, uint8_t *dat);
//static void Menu_Cursor_Preprocess(Menu_Key_en_t enMenuKey);
//static void Menu_Cursor_Postprocess(Menu_Key_en_t enMenuKey);
void Menu_Service(Menu_Key_en_t enMenuKey);

/*-----------------------------------------------------------------*/

/*-------------------Logic_Operation Call Back---------------------*/
void Menu_Logic_Operation_NaviBar_ECU(Menu_Key_en_t enKeyType);
void Menu_Logic_Operation_NaviBar_SET(Menu_Key_en_t enKeyType);
void Menu_Logic_Operation_NaviBar_DEMAND(Menu_Key_en_t enKeyType);
void Menu_Logic_Operation_TPMS_LEARN(Menu_Key_en_t enKeyType);
void Menu_Logic_Operation_ECU_AvgELC(Menu_Key_en_t enKeyType);
void Menu_Logic_Operation_ECU_AvgSpeed(Menu_Key_en_t enKeyType);
void Menu_Logic_Operation_ECU_DrivingTime(Menu_Key_en_t enKeyType);
void Menu_Logic_Operation_ECU_BattVolt(Menu_Key_en_t enKeyType);
void Menu_Logic_Operation_ECU_TPMS(Menu_Key_en_t enKeyType);
void Menu_Logic_Operation_ECU_LDW(Menu_Key_en_t enKeyType);
void Menu_Logic_Operation_ECU_RADAR(Menu_Key_en_t enKeyType);
void Menu_Logic_Operation_SET_TIME_CLOCK(Menu_Key_en_t enKeyType);
void Menu_Logic_Operation_SET_TIME_Synch(Menu_Key_en_t enKeyType);
//void Menu_Logic_Operation_SET_TIME_12MODE(Menu_Key_en_t enKeyType);
//void Menu_Logic_Operation_SET_TIME_24MODE(Menu_Key_en_t enKeyType);
//void Menu_Logic_Operation_SET_TIME_CLOCK_APm(Menu_Key_en_t enKeyType);
void Menu_Logic_Operation_SET_TIME_CLOCK_HOUR(Menu_Key_en_t enKeyType);
void Menu_Logic_Operation_SET_TIME_CLOCK_MIN(Menu_Key_en_t enKeyType);
void Menu_Logic_Operation_SET_OVERSPEED_OPEN(Menu_Key_en_t enKeyType);
void Menu_Logic_Operation_SET_OVERSPEED_CLOSE(Menu_Key_en_t enKeyType);
void Menu_Logic_Operation_SET_OVERSPEED_CUSTOM(Menu_Key_en_t enKeyType);
void Menu_Logic_Operation_SET_OVERSPEED_CUSTOM_ADJUST(Menu_Key_en_t enKeyType);
void Menu_Logic_Operation_SET_MAINT_OPEN(Menu_Key_en_t enKeyType);
void Menu_Logic_Operation_SET_MAINT_CLOSE(Menu_Key_en_t enKeyType);
void Menu_Logic_Operation_SET_CLEAR_TRIP_YES(Menu_Key_en_t enKeyType);
void Menu_Logic_Operation_SET_CLEAR_DRIVTIME_YES(Menu_Key_en_t enKeyType);
void Menu_Logic_Operation_SET_CLEAR_AVGSPD_YES(Menu_Key_en_t enKeyType);
void Menu_Logic_Operation_SET_CLEAR_AVGELC_YES(Menu_Key_en_t enKeyType);
void Menu_Logic_Operation_SET_LANGUAGE_China(Menu_Key_en_t enKeyType);
void Menu_Logic_Operation_SET_LANGUAGE_ENGLISH(Menu_Key_en_t enKeyType);
void Menu_Logic_Operation_SET_TPMS_LEARN_LF(Menu_Key_en_t enKeyType);
void Menu_Logic_Operation_SET_TPMS_LEARN_RF(Menu_Key_en_t enKeyType);
void Menu_Logic_Operation_SET_TPMS_LEARN_LR(Menu_Key_en_t enKeyType);
void Menu_Logic_Operation_SET_TPMS_LEARN_MLR(Menu_Key_en_t enKeyType);
void Menu_Logic_Operation_SET_TPMS_LEARN_MRR(Menu_Key_en_t enKeyType);
void Menu_Logic_Operation_SET_TPMS_LEARN_RR(Menu_Key_en_t enKeyType);
void Menu_Logic_Operation_SET_TPMS_Learning(Menu_Key_en_t enKeyType);
void Menu_Logic_Operation_SET_TPMS_Learn_TimeOut(Menu_Key_en_t enKeyType);
void Menu_Logic_Operation_SET_TPMS_Learn_IDConflict(Menu_Key_en_t enKeyType);
void Menu_Logic_Operation_SET_TPMS_Learn_HaveVechSpeed(Menu_Key_en_t enKeyType);
void Menu_Logic_Operation_SET_TPMS_Learn_Succeed(Menu_Key_en_t enKeyType);
void Menu_Logic_Operation_SET_FactoryReset_Confirm2(Menu_Key_en_t enKeyType);
void Menu_Logic_Operation_Navi_Demand_Alam(Menu_Key_en_t enKeyType);


void Menu_Language_Init(void)
{
	if(Val_EOL_F101_Language()== 1)
	{
		Menu_Item_Select_Set(MENU_ITEM_SET_LANGUAGE_China, 1);
	    Menu_Item_Select_Set(MENU_ITEM_SET_LANGUAGE_ENGLISH, 0);
	}
	else if(Val_EOL_F101_Language()== 2)
	{
		Menu_Item_Select_Set(MENU_ITEM_SET_LANGUAGE_China, 0);
	    Menu_Item_Select_Set(MENU_ITEM_SET_LANGUAGE_ENGLISH, 1);
	}
	
	if(Menu_Item_Select_Get(MENU_ITEM_SET_LANGUAGE_ENGLISH))	
	{
		MenuData.Language = 1 ;	
	}

	if(Menu_Item_Select_Get(MENU_ITEM_SET_LANGUAGE_China))
	{
		MenuData.Language = 0 ;		
	}
}



void Menu_User_Init(Menu_User_Init_PowerTypeEnum PowerType)
{
	Menu_Init_st_t Menu_Init_st;
	Menu_Init_st.enMenuBranchLen = MENU_BRANCH_MAX;
	Menu_Init_st.enMenuInterfaceLen = MENU_INTERFACE_MAX;
	Menu_Init_st.enMenuItemLen = MENU_ITEM_MAX;
	Menu_Init_st.uintMenuConfig = 0x0001;
	Menu_Init_st.uintMenuCursorMemoryDepth = 0;

	if(PowerType == Menu_User_Init_Power_K30)
	{
		Menu_Init((uint8_t *)u8MenuRamData, (Menu_Item_Attribute_st_t *)stMenuItemAttribute, (Menu_Init_st_t *)&Menu_Init_st);


		//MENU_Intf_Inside_Item_Select_Set(MENU_ITEM_SET_TIME_12MODE, MENU_ITEM_SET_TIME_24MODE, MENU_ITEM_SET_TIME_24MODE);
		MENU_Intf_Inside_Item_Select_Set(MENU_ITEM_SET_OVERSPEED_OPEN, MENU_ITEM_SET_OVERSPEED_CLOSE, MENU_ITEM_SET_OVERSPEED_OPEN);
		MENU_Intf_Inside_Item_Select_Set(MENU_ITEM_SET_MAINT_OPEN, MENU_ITEM_SET_MAINT_CLOSE, MENU_ITEM_SET_MAINT_OPEN);
		MENU_Intf_Inside_Item_Select_Set(MENU_ITEM_SET_LANGUAGE_China, MENU_ITEM_SET_LANGUAGE_ENGLISH, MENU_ITEM_SET_LANGUAGE_China);
		
		MENU_Intf_Inside_Item_Select_Set(MENU_ITEM_Navi_ECU, MENU_ITEM_Navi_Demand, MENU_ITEM_Navi_ECU);
		MENU_Intf_Inside_Item_Select_Set(MENU_ITEM_ECU_AvgELC, MENU_ITEM_ECU_RADAR, MENU_ITEM_ECU_AvgELC);

		Menu_Item_Exist_Condition_Set(MENU_ITEM_SET_OVERSPEED_CUSTOM, 1);
		Menu_Item_Exist_Condition_Set(MENU_ITEM_SET_OVERSPEED_CUSTOM_ADJUST, 1);
		Menu_Item_Exist_Condition_Set(MENU_ITEM_SET_OVERSPEED_CUSTOM_RETURN, 1);
		Menu_Item_Select_Set(MENU_ITEM_SET_TIME_Synch, 1);
		Menu_Change_Branch_To_Item(MENU_BRANCH_MENUE, MENU_ITEM_ECU_AvgELC);
		Menu_Item_Exist_Condition_Set(MENU_ITEM_ECU_LDW, 0);
		Menu_Item_Exist_Condition_Set(MENU_ITEM_ECU_RADAR, 0);
		Menu_Language_Init();
	}
	else if(PowerType == Menu_User_Init_Power_WakeUp)
	{
		Menu_Wake_Up_Init((uint8_t *)u8MenuRamData, (Menu_Item_Attribute_st_t *)stMenuItemAttribute, (Menu_Init_st_t *)&Menu_Init_st);
		
	}
	else
	{
	}

	MENU_TPMS_Exist_Config();
//	MENU_Intf_Inside_Item_Select_Set(MENU_ITEM_Navi_ECU, MENU_ITEM_Navi_Demand, MENU_ITEM_Navi_ECU);
//	MENU_Intf_Inside_Item_Select_Set(MENU_ITEM_ECU_InsFuel, MENU_ITEM_ECU_RADAR, MENU_ITEM_ECU_InsFuel);
	
	//Menu_Change_Branch_To_Item(MENU_BRANCH_MENUE, MENU_ITEM_ECU_InsFuel);
	
	if ((Val_EOL_F101_ConfigType() == 1)||(Val_EOL_F101_ConfigType() == 2)||(Val_EOL_F101_ConfigType() == 4)||(Val_EOL_F101_ConfigType() == 5)||(Val_EOL_F101_ConfigType() == 6))
	{
		Menu_Item_Exist_Condition_Set(MENU_ITEM_ECU_ElcDTE, 1);
	}
	else
	{
		Menu_Item_Exist_Condition_Set(MENU_ITEM_ECU_ElcDTE, 0);
	}
	if (Val_EOL_F101_ServiceMaintain() == 2)
	{
		Menu_Item_Exist_Condition_Set(MENU_ITEM_SET_MAINT, 1);
	}
	else
	{
		Menu_Item_Exist_Condition_Set(MENU_ITEM_SET_MAINT, 0);
	}
	TMPS_Learnning_Flag = TMPS_Export_Max;
}

void MENU_TPMS_Exist_Config(void )
{
	if((Val_EOL_F110_TPMS() == 1u)&&((Val_EOL_F101_TPMSType() == 1)||(Val_EOL_F101_TPMSType() == 2)))
	{    
		if(Val_EOL_F101_TPMSType() == 1u)  
		{
			Menu_Item_Exist_Condition_Set(MENU_ITEM_SET_TPMS_LEARN_LR, 1);
			Menu_Item_Exist_Condition_Set(MENU_ITEM_SET_TPMS_LEARN_MLR, 1);
			Menu_Item_Exist_Condition_Set(MENU_ITEM_SET_TPMS_LEARN_MRR, 1);
			Menu_Item_Exist_Condition_Set(MENU_ITEM_SET_TPMS_LEARN_RR, 1);
		}   
		else if(Val_EOL_F101_TPMSType() == 2u)
		{
			
			Menu_Item_Exist_Condition_Set(MENU_ITEM_SET_TPMS_LEARN_LR, 0);
			Menu_Item_Exist_Condition_Set(MENU_ITEM_SET_TPMS_LEARN_MLR, 0);
			Menu_Item_Exist_Condition_Set(MENU_ITEM_SET_TPMS_LEARN_MRR, 0);
			Menu_Item_Exist_Condition_Set(MENU_ITEM_SET_TPMS_LEARN_RR, 0);
			
			
			
		}                                                                                    
		Menu_Item_Exist_Condition_Set(MENU_ITEM_ECU_TPMS, 1);
		Menu_Item_Exist_Condition_Set(MENU_ITEM_SET_TPMS_LEARN, 1);
		Menu_Item_Exist_Condition_Set(MENU_ITEM_SET_TPMS_LEARN_LF, 1);
		Menu_Item_Exist_Condition_Set(MENU_ITEM_SET_TPMS_LEARN_RF, 1);
		Menu_Item_Exist_Condition_Set(MENU_ITEM_SET_TPMS_Learning, 1);
		Menu_Item_Exist_Condition_Set(MENU_ITEM_SET_TPMS_Learn_TimeOut, 1);
		Menu_Item_Exist_Condition_Set(MENU_ITEM_SET_TPMS_Learn_IDConflict, 1);
		Menu_Item_Exist_Condition_Set(MENU_ITEM_SET_TPMS_Learn_HaveVechSpeed, 1);
		Menu_Item_Exist_Condition_Set(MENU_ITEM_SET_TPMS_Learn_Succeed, 1);
	}
	else
	{
		Menu_Item_Exist_Condition_Set(MENU_ITEM_ECU_TPMS, 0);
		Menu_Item_Exist_Condition_Set(MENU_ITEM_SET_TPMS_LEARN, 0);		
		Menu_Item_Exist_Condition_Set(MENU_ITEM_SET_TPMS_LEARN_LF, 0);
		Menu_Item_Exist_Condition_Set(MENU_ITEM_SET_TPMS_LEARN_RF, 0);
		Menu_Item_Exist_Condition_Set(MENU_ITEM_SET_TPMS_LEARN_LR, 0);
		Menu_Item_Exist_Condition_Set(MENU_ITEM_SET_TPMS_LEARN_MLR, 0);
		Menu_Item_Exist_Condition_Set(MENU_ITEM_SET_TPMS_LEARN_MRR, 0);
		Menu_Item_Exist_Condition_Set(MENU_ITEM_SET_TPMS_LEARN_RR, 0);
		Menu_Item_Exist_Condition_Set(MENU_ITEM_SET_TPMS_Learning, 0);
		Menu_Item_Exist_Condition_Set(MENU_ITEM_SET_TPMS_Learn_TimeOut, 0);
		Menu_Item_Exist_Condition_Set(MENU_ITEM_SET_TPMS_Learn_IDConflict, 0);
		Menu_Item_Exist_Condition_Set(MENU_ITEM_SET_TPMS_Learn_HaveVechSpeed, 0);
		Menu_Item_Exist_Condition_Set(MENU_ITEM_SET_TPMS_Learn_Succeed, 0);
	}
}

void MENU_Intf_Inside_Item_Select_Set(Menu_Item_en_t StartItem, Menu_Item_en_t EndItem, Menu_Item_en_t SelectItem)
{
	Menu_Item_en_t i = StartItem;
	if(StartItem > EndItem)
	{
		return;
	}
	if(EndItem >= MENU_ITEM_MAX)
	{
		return;
	}
	if((SelectItem < StartItem)||(SelectItem > EndItem))
	{
		return;
	}
	for(i=StartItem; i<=EndItem; i++)
	{
		Menu_Item_Select_Set(i, 0);
	}
	Menu_Item_Select_Set(SelectItem, 1);
}

/*��ȡĳһ����ѡ�еĹ�����*/
Menu_Item_en_t MENU_Intf_Inside_Item_Select_Get(Menu_Item_en_t StartItem, Menu_Item_en_t EndItem)
{
	Menu_Item_en_t i = StartItem;
	Menu_Item_en_t ret = MENU_ITEM_MAX;
	if(StartItem > EndItem)
	{
		return ret;
	}
	if(EndItem >= MENU_ITEM_MAX)
	{
		return ret;
	}

	for(i = StartItem; i<=EndItem; i++)
	{
		if(Menu_Item_Select_Get(i))
		{
			ret = i;
			break;
		}
	}
	return ret;
}

void Menu_u8Data_Updata_Process(uint8_t updateDir , uint8_t datMax, uint8_t datMin, uint8_t datStep, uint8_t *dat)
{
	uint8_t temp = *dat;
    if(datMax > datMin)
    {
        if(updateDir == 1u)
        {
            if(temp < datMax)
            {
                if((temp) <= (255u-datStep))
                {
                    temp += datStep;
                }
            } 
            else
            {
                temp = datMin;
            }        
        }
        else if(updateDir == 2u)
        {
            if(temp > datMin)
            {
                if(temp >= datStep)
                {
                    temp -= datStep;
                }
            } 
            else
            {
                temp = datMax;
            }
        }
        else
        {
        }
    }
    else
    {
    }

	*dat = temp;
}

/*-----------------------------------------------------------------*/

/*-------------------Logic_Operation Call Back---------------------*/
void Menu_Logic_Operation_NaviBar_ECU(Menu_Key_en_t enKeyType)
{
	if(enKeyType == MENU_KEY_CONFIRM_SHORT)
	{
		MENU_Intf_Inside_Item_Select_Set(MENU_ITEM_Navi_ECU, MENU_ITEM_Navi_Demand, MENU_ITEM_Navi_ECU);
		//��ȡ�����εı���
	}
	else  if(enKeyType == MENU_KEY_TIMEOUT)
	{
		MENU_Intf_Inside_Item_Select_Set(MENU_ITEM_Navi_ECU, MENU_ITEM_Navi_Demand, MENU_ITEM_Navi_ECU);	
	}
	else
	{
		
	}
}
void Menu_Logic_Operation_NaviBar_SET(Menu_Key_en_t enKeyType)
{
	if(enKeyType == MENU_KEY_CONFIRM_SHORT)
	{
		MENU_Intf_Inside_Item_Select_Set(MENU_ITEM_Navi_ECU, MENU_ITEM_Navi_Demand, MENU_ITEM_Navi_Set);
	
	}
	else  if(enKeyType == MENU_KEY_TIMEOUT)
	{
		MENU_Intf_Inside_Item_Select_Set(MENU_ITEM_Navi_ECU, MENU_ITEM_Navi_Demand, MENU_ITEM_Navi_ECU);	
	}
	else
	{
		
	}

}
void Menu_Logic_Operation_NaviBar_DEMAND(Menu_Key_en_t enKeyType)
{
	if(enKeyType == MENU_KEY_CONFIRM_SHORT)
	{
		MENU_Intf_Inside_Item_Select_Set(MENU_ITEM_Navi_ECU, MENU_ITEM_Navi_Demand, MENU_ITEM_Navi_Demand);
		MaskPopupNum = Menu_Get_g1_SystemError();
	}
	else  if(enKeyType == MENU_KEY_TIMEOUT)
	{
		MENU_Intf_Inside_Item_Select_Set(MENU_ITEM_Navi_ECU, MENU_ITEM_Navi_Demand, MENU_ITEM_Navi_ECU);	
	}

}

void Menu_Logic_Operation_ECU_AvgELC(Menu_Key_en_t enKeyType)
{
	if(enKeyType == MENU_KEY_DOWN_SHORT)
	{
		MENU_Intf_Inside_Item_Select_Set(MENU_ITEM_ECU_AvgELC, MENU_ITEM_ECU_RADAR, MENU_ITEM_ECU_ElcDTE);
	}
	else
	{
	}
}
void Menu_Logic_Operation_ECU_ElcDTE(Menu_Key_en_t enKeyType )
{
	if(enKeyType == MENU_KEY_DOWN_SHORT)
	{
		MENU_Intf_Inside_Item_Select_Set(MENU_ITEM_ECU_AvgELC, MENU_ITEM_ECU_RADAR, MENU_ITEM_ECU_InsELC);
	}
	else
	{
	}    
	
}
void Menu_Logic_Operation_ECU_InsELC(Menu_Key_en_t enKeyType )
{
	if(enKeyType == MENU_KEY_DOWN_SHORT)
	{
		MENU_Intf_Inside_Item_Select_Set(MENU_ITEM_ECU_AvgELC, MENU_ITEM_ECU_RADAR, MENU_ITEM_ECU_RemainPwr);
	}
	else
	{
	}    
	
}
void Menu_Logic_Operation_ECU_RemainPwr(Menu_Key_en_t enKeyType )
{
	if(enKeyType == MENU_KEY_DOWN_SHORT)
	{
		MENU_Intf_Inside_Item_Select_Set(MENU_ITEM_ECU_AvgELC, MENU_ITEM_ECU_RADAR, MENU_ITEM_ECU_AvgSpeed);
	}
	else
	{
	}    

}

void Menu_Logic_Operation_ECU_AvgSpeed(Menu_Key_en_t enKeyType)
{
	if(enKeyType == MENU_KEY_DOWN_SHORT)
	{
		MENU_Intf_Inside_Item_Select_Set(MENU_ITEM_ECU_AvgELC, MENU_ITEM_ECU_RADAR, MENU_ITEM_ECU_DrivingTime);
	}
	else
	{
	}
}

void Menu_Logic_Operation_ECU_DrivingTime(Menu_Key_en_t enKeyType)
{
	if(enKeyType == MENU_KEY_DOWN_SHORT)
	{
		MENU_Intf_Inside_Item_Select_Set(MENU_ITEM_ECU_AvgELC, MENU_ITEM_ECU_RADAR, MENU_ITEM_ECU_WorkVolt);
	}
	else
	{
	}
}

void Menu_Logic_Operation_ECU_WorkVolt(Menu_Key_en_t enKeyType)
{
	if(enKeyType == MENU_KEY_DOWN_SHORT)
	{
		MENU_Intf_Inside_Item_Select_Set(MENU_ITEM_ECU_AvgELC, MENU_ITEM_ECU_RADAR, MENU_ITEM_ECU_WorkCurr);
	}
	else
	{
	}

}


void Menu_Logic_Operation_ECU_WorkCurr(Menu_Key_en_t enKeyType)
{
	if(enKeyType == MENU_KEY_DOWN_SHORT)
	{
		MENU_Intf_Inside_Item_Select_Set(MENU_ITEM_ECU_AvgELC, MENU_ITEM_ECU_RADAR, MENU_ITEM_ECU_BattVolt);
	}
	else
	{
	}	
}

void Menu_Logic_Operation_ECU_BattVolt(Menu_Key_en_t enKeyType)
{
	if(enKeyType == MENU_KEY_DOWN_SHORT)
	{
		MENU_Intf_Inside_Item_Select_Set(MENU_ITEM_ECU_AvgELC, MENU_ITEM_ECU_RADAR, MENU_ITEM_ECU_BattHighVolt);
	}
	else
	{
	}
}
void Menu_Logic_Operation_ECU_BattHighVolt(Menu_Key_en_t enKeyType)
{
	if(enKeyType == MENU_KEY_DOWN_SHORT)
	{
		MENU_Intf_Inside_Item_Select_Set(MENU_ITEM_ECU_AvgELC, MENU_ITEM_ECU_RADAR, MENU_ITEM_ECU_BattLowVolt);
	}
	else
	{
	}
	
}

void Menu_Logic_Operation_ECU_BattLowVolt(Menu_Key_en_t enKeyType)
{
	if(enKeyType == MENU_KEY_DOWN_SHORT)
	{
		MENU_Intf_Inside_Item_Select_Set(MENU_ITEM_ECU_AvgELC, MENU_ITEM_ECU_RADAR, MENU_ITEM_ECU_BattHighTemp);
	}
	else
	{
	}
	
}

void Menu_Logic_Operation_ECU_BattHighTemp(Menu_Key_en_t enKeyType)
{
	if(enKeyType == MENU_KEY_DOWN_SHORT)
	{
		MENU_Intf_Inside_Item_Select_Set(MENU_ITEM_ECU_AvgELC, MENU_ITEM_ECU_RADAR, MENU_ITEM_ECU_BattLowTemp);
	}
	else
	{
	}
}
void Menu_Logic_Operation_ECU_BattLowTemp(Menu_Key_en_t enKeyType)
{
	if(enKeyType == MENU_KEY_DOWN_SHORT)
	{
		MENU_Intf_Inside_Item_Select_Set(MENU_ITEM_ECU_AvgELC, MENU_ITEM_ECU_RADAR, MENU_ITEM_ECU_ErrCode);
	}
	else
	{
	}
	
}
void Menu_Logic_Operation_ECU_ErrCode(Menu_Key_en_t enKeyType)
{
	if(enKeyType == MENU_KEY_DOWN_SHORT)
	{
		MENU_Intf_Inside_Item_Select_Set(MENU_ITEM_ECU_AvgELC, MENU_ITEM_ECU_RADAR, MENU_ITEM_ECU_TPMS);
	}
	else
	{
	}
	
}

void Menu_Logic_Operation_ECU_TPMS(Menu_Key_en_t enKeyType)
{
	if(enKeyType == MENU_KEY_DOWN_SHORT)
	{
		MENU_Intf_Inside_Item_Select_Set(MENU_ITEM_ECU_AvgELC, MENU_ITEM_ECU_RADAR, MENU_ITEM_ECU_LDW);
	}
	else
	{
	}
}

void Menu_Logic_Operation_ECU_LDW(Menu_Key_en_t enKeyType)
{
	if(enKeyType == MENU_KEY_DOWN_SHORT)
	{
		MENU_Intf_Inside_Item_Select_Set(MENU_ITEM_ECU_AvgELC, MENU_ITEM_ECU_RADAR, MENU_ITEM_ECU_RADAR);
	}
	else
	{
	}
}

void Menu_Logic_Operation_ECU_RADAR(Menu_Key_en_t enKeyType)
{
	if(enKeyType == MENU_KEY_DOWN_SHORT)
	{
		MENU_Intf_Inside_Item_Select_Set(MENU_ITEM_ECU_AvgELC, MENU_ITEM_ECU_RADAR, MENU_ITEM_ECU_AvgELC);
	}
	else
	{
	}
}

void Menu_Logic_Operation_TPMS_LEARN(Menu_Key_en_t enKeyType)
{
	if(enKeyType == MENU_KEY_CONFIRM_SHORT)
	{
	}
}






void Menu_Logic_Operation_SET_TIME_CLOCK(Menu_Key_en_t enKeyType)
{
	uint8_t hourbuf = RTC_HOUR;
	uint8_t minutebuf = RTC_MINUTE;

	if(enKeyType == MENU_KEY_CONFIRM_SHORT)
	{
		MenuData.Minute = minutebuf;

		/*if(Menu_Item_Select_Get(MENU_ITEM_SET_TIME_12MODE) == 1u)
		{
			if(hourbuf > 12u)
			{
				MenuData.Hour = hourbuf-12u;
			}  
			else if(hourbuf == 0u)
			{
				MenuData.Hour = 12u; 
			}
			else
			{
				MenuData.Hour = hourbuf;  
			}
		}
		else
		{*/
			MenuData.Hour = hourbuf;	
		//}

		/*if(hourbuf >= 12)
		{
			MenuData.APm = Day_PM;
		}
		else
		{
			MenuData.APm = Day_AM;
		}*/

		Menu_Item_Select_Set(MENU_ITEM_SET_TIME_Synch, 0);
	}
}

void Menu_Logic_Operation_SET_TIME_Synch(Menu_Key_en_t enKeyType)
{
	if(enKeyType == MENU_KEY_CONFIRM_SHORT)
	{
		Menu_Item_Select_Set(MENU_ITEM_SET_TIME_Synch, 1);
	}
}
#if 0
void Menu_Logic_Operation_SET_TIME_12MODE(Menu_Key_en_t enKeyType)
{
	/*if(enKeyType == MENU_KEY_CONFIRM_SHORT)
	{
		MENU_Intf_Inside_Item_Select_Set(MENU_ITEM_SET_TIME_12MODE, MENU_ITEM_SET_TIME_24MODE, MENU_ITEM_SET_TIME_12MODE);
	}*/
}

void Menu_Logic_Operation_SET_TIME_24MODE(Menu_Key_en_t enKeyType)
{
	/*if(enKeyType == MENU_KEY_CONFIRM_SHORT)
	{
		MENU_Intf_Inside_Item_Select_Set(MENU_ITEM_SET_TIME_12MODE, MENU_ITEM_SET_TIME_24MODE, MENU_ITEM_SET_TIME_24MODE);
	}*/
}


void Menu_Logic_Operation_SET_TIME_CLOCK_APm(Menu_Key_en_t enKeyType)
{
	/*uint8_t hourBuf = 0u;
	if(enKeyType == MENU_KEY_CONFIRM_SHORT)
	{
		if(Menu_Item_Select_Get(MENU_ITEM_SET_TIME_12MODE) == 1u)
		{
			if(MenuData.APm == Day_AM)
			{
				if(MenuData.Hour >= 12)
				{
					hourBuf = 0;
				}
				else
				{
					hourBuf = MenuData.Hour;	
				}
			}
			else
			{
				if(MenuData.Hour >= 12)
				{
					hourBuf = 12;
				}
				else
				{
					hourBuf = MenuData.Hour+12;	
				}
			}
		}
		else
		{
			hourBuf = MenuData.Hour;
		}
		RTC_HOUR = hourBuf;
	}
	else if((enKeyType == MENU_KEY_UP_SHORT)||(enKeyType == MENU_KEY_DOWN_SHORT))
	{
		if(MenuData.APm == Day_AM)
		{
			MenuData.APm = Day_PM;
		}
		else
		{
			MenuData.APm = Day_AM;
		}
	}
	else
	{
	}*/
}
#endif
void Menu_Logic_Operation_SET_TIME_CLOCK_HOUR(Menu_Key_en_t enKeyType)
{
	uint8_t updataDir = 0u;
	uint8_t datmax = 0u;
	uint8_t datmin = 0u;
	uint8_t hourBuf = 0u;
	if(enKeyType == MENU_KEY_CONFIRM_SHORT)
	{
		/*��ϵͳʱ���Сʱ��ֵ*/
		/*if(Menu_Item_Select_Get(MENU_ITEM_SET_TIME_12MODE) == 1u)
		{
			if(MenuData.APm == Day_AM)
			{
				if(MenuData.Hour >= 12)
				{
					hourBuf = 0;
				}
				else
				{
					hourBuf = MenuData.Hour;	
				}
			}
			else
			{
				if(MenuData.Hour >= 12)
				{
					hourBuf = 12;
				}
				else
				{
					hourBuf = MenuData.Hour+12;	
				}
			}
		}
		else
		{*/
			hourBuf = MenuData.Hour;
		//}
		RTC_HOUR = hourBuf;
	}
	else if(enKeyType == MENU_KEY_UP_SHORT)
	{
		updataDir = 2;
	}
	else if(enKeyType == MENU_KEY_DOWN_SHORT)
	{
		updataDir = 1;
	}

	//if(Menu_Item_Select_Get(MENU_ITEM_SET_TIME_12MODE) == 1u)
    //{
    //    datmax = 12u;
    //    datmin = 1u;   
    //}
    //else
    //{
        datmax = 23u;
        datmin = 0u;  
    //}

	Menu_u8Data_Updata_Process(updataDir, datmax, datmin, 1u, (uint8_t*)&(MenuData.Hour));
}

void Menu_Logic_Operation_SET_TIME_CLOCK_MIN(Menu_Key_en_t enKeyType)
{
	uint8_t updataDir = 0u;
	uint8_t datmax = 59u;
	uint8_t datmin = 0u;
	if(enKeyType == MENU_KEY_UP_SHORT)
	{
		updataDir = 2;
	}
	else if(enKeyType == MENU_KEY_DOWN_SHORT)
	{
		updataDir = 1;
	}
	else if(enKeyType == MENU_KEY_CONFIRM_SHORT)
	{
		RTC_MINUTE = MenuData.Minute;
	}

	Menu_u8Data_Updata_Process(updataDir, datmax, datmin, 1u, (uint8_t*)&(MenuData.Minute));
}

void Menu_Logic_Operation_SET_OVERSPEED_OPEN(Menu_Key_en_t enKeyType)
{
	if(enKeyType == MENU_KEY_CONFIRM_SHORT)
	{
		MENU_Intf_Inside_Item_Select_Set(MENU_ITEM_SET_OVERSPEED_OPEN, MENU_ITEM_SET_OVERSPEED_CLOSE, MENU_ITEM_SET_OVERSPEED_OPEN);
		Menu_Item_Exist_Condition_Set(MENU_ITEM_SET_OVERSPEED_CUSTOM, 1);
		Menu_Item_Exist_Condition_Set(MENU_ITEM_SET_OVERSPEED_CUSTOM_ADJUST, 1);
		Menu_Item_Exist_Condition_Set(MENU_ITEM_SET_OVERSPEED_CUSTOM_RETURN, 1);
	}
}

void Menu_Logic_Operation_SET_OVERSPEED_CLOSE(Menu_Key_en_t enKeyType)
{
	if(enKeyType == MENU_KEY_CONFIRM_SHORT)
	{
		MENU_Intf_Inside_Item_Select_Set(MENU_ITEM_SET_OVERSPEED_OPEN, MENU_ITEM_SET_OVERSPEED_CLOSE, MENU_ITEM_SET_OVERSPEED_CLOSE);
		Menu_Item_Exist_Condition_Set(MENU_ITEM_SET_OVERSPEED_CUSTOM, 0);
		Menu_Item_Exist_Condition_Set(MENU_ITEM_SET_OVERSPEED_CUSTOM_ADJUST, 0);
		Menu_Item_Exist_Condition_Set(MENU_ITEM_SET_OVERSPEED_CUSTOM_RETURN, 0);
	}
}

void Menu_Logic_Operation_SET_OVERSPEED_CUSTOM(Menu_Key_en_t enKeyType)
{
	if(enKeyType == MENU_KEY_CONFIRM_SHORT)
	{
		MenuData.OverSpeed = DataOverSpeed;
	}
}

void Menu_Logic_Operation_SET_OVERSPEED_CUSTOM_ADJUST(Menu_Key_en_t enKeyType)
{
	uint8_t updataDir = 0u;
	uint8_t datmax = 120u;
	uint8_t datmin = 30u;

	if(enKeyType == MENU_KEY_UP_SHORT)
	{
		updataDir = 2;
	}
	else if(enKeyType == MENU_KEY_DOWN_SHORT)
	{
		updataDir = 1;
	}
	else if(enKeyType == MENU_KEY_CONFIRM_SHORT)
	{
		DataOverSpeed = MenuData.OverSpeed;
	}

	Menu_u8Data_Updata_Process(updataDir, datmax, datmin, 5u, (uint8_t*)&(MenuData.OverSpeed));
}

void Menu_Logic_Operation_SET_MAINT_OPEN(Menu_Key_en_t enKeyType)
{
	if(enKeyType == MENU_KEY_CONFIRM_SHORT)
	{
		MENU_Intf_Inside_Item_Select_Set(MENU_ITEM_SET_MAINT_OPEN, MENU_ITEM_SET_MAINT_CLOSE, MENU_ITEM_SET_MAINT_OPEN);
	}
}

void Menu_Logic_Operation_SET_MAINT_CLOSE(Menu_Key_en_t enKeyType)
{
	if(enKeyType == MENU_KEY_CONFIRM_SHORT)
	{
		MENU_Intf_Inside_Item_Select_Set(MENU_ITEM_SET_MAINT_OPEN, MENU_ITEM_SET_MAINT_CLOSE, MENU_ITEM_SET_MAINT_CLOSE);
	}
}
void Menu_Logic_Operation_SET_CLEAR_TRIP_YES(Menu_Key_en_t enKeyType)
{
	if(MENU_KEY_CONFIRM_SHORT == enKeyType)
	{
         	Data_Clear_TripA();	
	}
}

void Menu_Logic_Operation_SET_CLEAR_DRIVTIME_YES(Menu_Key_en_t enKeyType)
{
	if(MENU_KEY_CONFIRM_SHORT == enKeyType)
	{
		Data_Driving_Time_Reset();
	}
}

void Menu_Logic_Operation_SET_CLEAR_AVGSPD_YES(Menu_Key_en_t enKeyType)
{
	if(MENU_KEY_CONFIRM_SHORT == enKeyType)
	{
		Average_Vspeed_Trip_Clear();
	}
}

void Menu_Logic_Operation_SET_CLEAR_AVGELC_YES(Menu_Key_en_t enKeyType)
{
	if(MENU_KEY_CONFIRM_SHORT == enKeyType)
	{
		Data_Avg_EVCons_Trip_Clear();
	}
}

void Menu_Logic_Operation_SET_LANGUAGE_China(Menu_Key_en_t enKeyType)
{
	if(MENU_KEY_CONFIRM_SHORT == enKeyType)
	{
		MENU_Intf_Inside_Item_Select_Set(MENU_ITEM_SET_LANGUAGE_China, MENU_ITEM_SET_LANGUAGE_ENGLISH, MENU_ITEM_SET_LANGUAGE_China);
		MenuData.Language = 0 ;
		if(GUIBackUp.Language != MenuData.Language)
		{
			Clear_Box(50, 188, 190, 212);
			GUIBackUp.Language = MenuData.Language;
		}
		
	}
}

void Menu_Logic_Operation_SET_LANGUAGE_ENGLISH(Menu_Key_en_t enKeyType)
{
	if(MENU_KEY_CONFIRM_SHORT == enKeyType)
	{
		MENU_Intf_Inside_Item_Select_Set(MENU_ITEM_SET_LANGUAGE_China, MENU_ITEM_SET_LANGUAGE_ENGLISH, MENU_ITEM_SET_LANGUAGE_ENGLISH);
		MenuData.Language = 1 ;
		if(GUIBackUp.Language != MenuData.Language)
		{
			Clear_Box(50, 188, 190, 212);
			GUIBackUp.Language = MenuData.Language;
		}
		
	}
}

void Menu_Logic_Operation_SET_TPMS_LEARN_LF(Menu_Key_en_t enKeyType)
{
	if(MENU_KEY_CONFIRM_SHORT == enKeyType)
	{
	}
	else if(MENU_KEY_CANCEL_SHORT == enKeyType)
	{
	    TMPS_Learnning_Flag = TMPS_Export_Max;
	}
}

void Menu_Logic_Operation_SET_TPMS_LEARN_RF(Menu_Key_en_t enKeyType)
{
	if(MENU_KEY_CONFIRM_SHORT == enKeyType)
	{
	}
	else if(MENU_KEY_CANCEL_SHORT == enKeyType)
	{
	    TMPS_Learnning_Flag = TMPS_Export_Max;
	}
}

void Menu_Logic_Operation_SET_TPMS_LEARN_LR(Menu_Key_en_t enKeyType)
{
	if(MENU_KEY_CONFIRM_SHORT == enKeyType)
	{
	}
	else if(MENU_KEY_CANCEL_SHORT == enKeyType)
	{
	    TMPS_Learnning_Flag = TMPS_Export_Max;
	}
}

void Menu_Logic_Operation_SET_TPMS_LEARN_MLR(Menu_Key_en_t enKeyType)
{
	if(MENU_KEY_CONFIRM_SHORT == enKeyType)
	{
	}
	else if(MENU_KEY_CANCEL_SHORT == enKeyType)
	{
	    TMPS_Learnning_Flag = TMPS_Export_Max;
	}
}

void Menu_Logic_Operation_SET_TPMS_LEARN_MRR(Menu_Key_en_t enKeyType)
{
	if(MENU_KEY_CONFIRM_SHORT == enKeyType)
	{
	}
	else if(MENU_KEY_CANCEL_SHORT == enKeyType)
	{
	    TMPS_Learnning_Flag = TMPS_Export_Max;
	}
}

void Menu_Logic_Operation_SET_TPMS_LEARN_RR(Menu_Key_en_t enKeyType)
{
	if(MENU_KEY_CONFIRM_SHORT == enKeyType)
	{
	}
	else if(MENU_KEY_CANCEL_SHORT == enKeyType)
	{
	    TMPS_Learnning_Flag = TMPS_Export_Max;
	}
}




void Menu_Logic_Operation_SET_TPMS_Learning(Menu_Key_en_t enKeyType)
{
	if(MENU_KEY_CANCEL_SHORT == enKeyType)
	{
	    TMPS_Learnning_Flag = TMPS_Export_Over;
	}
}

void Menu_Logic_Operation_SET_TPMS_Learn_TimeOut(Menu_Key_en_t enKeyType)
{
	if(MENU_KEY_CANCEL_SHORT == enKeyType)
	{
	    TMPS_Learnning_Flag = TMPS_Export_Over;
	}
}

void Menu_Logic_Operation_SET_TPMS_Learn_IDConflict(Menu_Key_en_t enKeyType)
{
	if(MENU_KEY_CANCEL_SHORT == enKeyType)
	{
	    TMPS_Learnning_Flag = TMPS_Export_Over;
	}
}

void Menu_Logic_Operation_SET_TPMS_Learn_HaveVechSpeed(Menu_Key_en_t enKeyType)
{
	if(MENU_KEY_CANCEL_SHORT == enKeyType)
	{
	    TMPS_Learnning_Flag = TMPS_Export_Over;
	}
}

void Menu_Logic_Operation_SET_TPMS_Learn_Succeed(Menu_Key_en_t enKeyType)
{
	if(MENU_KEY_CANCEL_SHORT == enKeyType)
	{
	    TMPS_Learnning_Flag = TMPS_Export_Over;
	}
}

void Menu_Logic_Operation_SET_FactoryReset_Confirm2(Menu_Key_en_t enKeyType)
{
	if(MENU_KEY_CONFIRM_SHORT == enKeyType)
	{
		Average_Vspeed_Trip_Clear();
		Data_Avg_EVCons_Trip_Clear();
		Data_Driving_Time_Reset();
		Data_Clear_TripA();	
		Menu_Item_Select_Set(MENU_ITEM_SET_OVERSPEED_OPEN, 1);
		Menu_Item_Select_Set(MENU_ITEM_SET_OVERSPEED_CLOSE, 0);
		Menu_Item_Select_Set(MENU_ITEM_SET_MAINT_OPEN, 1);
		Menu_Item_Select_Set(MENU_ITEM_SET_MAINT_CLOSE, 0);
	//	MENU_Intf_Inside_Item_Select_Set(MENU_ITEM_SET_LANGUAGE_China, MENU_ITEM_SET_LANGUAGE_ENGLISH, MENU_ITEM_SET_LANGUAGE_China);
		Menu_Language_Init();
		DataOverSpeed = 120;
		S513_Maintenance_Data_Set(5000);
	}
}

void Menu_Logic_Operation_Navi_Demand_Alam(Menu_Key_en_t enKeyType)
{
	if(MENU_KEY_DOWN_SHORT == enKeyType)
	{
		//��ȡ���α���
		//Menu_Get_g1_SystemError();
		if(MaskPopupNum > 0)
		{
			if(MaskPopupCurIdx < (MaskPopupNum - 1u))
			{
				MaskPopupCurIdx++;
			}
			else
			{
				MaskPopupCurIdx = 0u;
			}
		}
		else
		{
			MaskPopupCurIdx = 0u;	
		}
	}
	else if(MENU_KEY_CANCEL_SHORT == enKeyType) 
	{
		MaskPopupCurIdx = 0 ;
	}  
	else
	{
		
	}
}




/*---------------------------------------------------------------------------------------*/

const Menu_Item_Attribute_st_t stMenuItemAttribute[MENU_ITEM_MAX] =
{  
/*MENU_ITEM_Navi_ECU */    {0, 	MENU_INTF_Navi, MENU_ITEM_MAX,	0U, 3U, 3U, 0U, 80U, 	MENU_DIRECTION_LONGITUDINAL,	 0XFFU,		MENU_INTF_ECU, MENU_JUMP_FIRST,		MENU_INTERFACE_MAX, 	MENU_JUMP_FIRST,  	MENU_INTF_ECU, 	MENU_JUMP_FIRST,Menu_Logic_Operation_NaviBar_ECU},
/*MENU_ITEM_Navi_Set */      {0,  MENU_INTF_Navi, MENU_ITEM_MAX, 	1U, 3U, 3U, 1U, 80U, 	MENU_DIRECTION_LONGITUDINAL, 0XFFU, 		MENU_INTF_SET, MENU_JUMP_FIRST, 		MENU_INTERFACE_MAX, 	MENU_JUMP_FIRST, 	MENU_INTF_ECU, 	MENU_JUMP_FIRST,Menu_Logic_Operation_NaviBar_SET},		
/*MENU_ITEM_Navi_Demand */ {0,  MENU_INTF_Navi, MENU_ITEM_MAX, 	2U, 3U, 3U, 2U, 80U, 	MENU_DIRECTION_LONGITUDINAL, 0XFFU, 		MENU_INTF_Demand, MENU_JUMP_FIRST, 	    MENU_INTERFACE_MAX,		MENU_JUMP_FIRST, 	MENU_INTF_ECU, 	MENU_JUMP_FIRST,Menu_Logic_Operation_NaviBar_DEMAND},

/*MENU_ITEM_ECU_AvgELC */     {0,  MENU_INTF_ECU, MENU_ITEM_Navi_ECU, 		0U,		17U, 1U, 		3U, 			80U, 	MENU_DIRECTION_LONGITUDINAL, 0XFFU, MENU_INTERFACE_MAX, MENU_JUMP_FIRST, MENU_INTF_Navi, MENU_JUMP_FIRST, 	MENU_INTERFACE_MAX, MENU_JUMP_FIRST,Menu_Logic_Operation_ECU_AvgELC},
/*MENU_ITEM_ECU_ElcDTE */     {0,  MENU_INTF_ECU, MENU_ITEM_Navi_ECU, 		1U,		17U, 1U, 		4U, 			80U, 	MENU_DIRECTION_LONGITUDINAL, 0XFFU, MENU_INTERFACE_MAX, MENU_JUMP_FIRST, MENU_INTF_Navi, MENU_JUMP_FIRST, 	MENU_INTERFACE_MAX, MENU_JUMP_FIRST,Menu_Logic_Operation_ECU_ElcDTE},
/*MENU_ITEM_ECU_InsELC */     {0,  MENU_INTF_ECU, MENU_ITEM_Navi_ECU, 		2U,		17U, 1U, 		5U, 			80U, 	MENU_DIRECTION_LONGITUDINAL, 0XFFU, MENU_INTERFACE_MAX, MENU_JUMP_FIRST, MENU_INTF_Navi, MENU_JUMP_FIRST, 	MENU_INTERFACE_MAX, MENU_JUMP_FIRST,Menu_Logic_Operation_ECU_InsELC},
/*MENU_ITEM_ECU_RemainPwr */	{0,  MENU_INTF_ECU, MENU_ITEM_Navi_ECU, 	3U,		17U, 1U, 		6U, 			80U, 	MENU_DIRECTION_LONGITUDINAL, 0XFFU, MENU_INTERFACE_MAX, MENU_JUMP_FIRST, MENU_INTF_Navi, MENU_JUMP_FIRST, 	MENU_INTERFACE_MAX, MENU_JUMP_FIRST,Menu_Logic_Operation_ECU_RemainPwr},
/*MENU_ITEM_ECU_AvgSpeed */    	{0,  MENU_INTF_ECU, MENU_ITEM_Navi_ECU,         4U,		17U, 1U, 		7U, 			80U, 	MENU_DIRECTION_LONGITUDINAL, 0XFFU, MENU_INTERFACE_MAX, MENU_JUMP_FIRST, MENU_INTF_Navi, MENU_JUMP_FIRST, 	MENU_INTERFACE_MAX, MENU_JUMP_FIRST,Menu_Logic_Operation_ECU_AvgSpeed},
/*MENU_ITEM_ECU_DrivingTime */ {0,  MENU_INTF_ECU, MENU_ITEM_Navi_ECU,         5U,		17U, 1U, 		8U, 			80U, 	MENU_DIRECTION_LONGITUDINAL, 0XFFU, MENU_INTERFACE_MAX, MENU_JUMP_FIRST, MENU_INTF_Navi, MENU_JUMP_FIRST, 	MENU_INTERFACE_MAX, MENU_JUMP_FIRST,Menu_Logic_Operation_ECU_DrivingTime},
/*MENU_ITEM_ECU_WorkVolt */ {0,  MENU_INTF_ECU, MENU_ITEM_Navi_ECU,      	6U,		17U, 1U, 		9U, 			80U, 	MENU_DIRECTION_LONGITUDINAL, 0XFFU, MENU_INTERFACE_MAX, MENU_JUMP_FIRST, MENU_INTF_Navi, MENU_JUMP_FIRST, 	MENU_INTERFACE_MAX, MENU_JUMP_FIRST,Menu_Logic_Operation_ECU_WorkVolt},
/*MENU_ITEM_ECU_WorkCurr */ {0,  MENU_INTF_ECU, MENU_ITEM_Navi_ECU,      	7U,		17U, 1U, 		10U, 		80U, 	MENU_DIRECTION_LONGITUDINAL, 0XFFU, MENU_INTERFACE_MAX, MENU_JUMP_FIRST, MENU_INTF_Navi, MENU_JUMP_FIRST, 	MENU_INTERFACE_MAX, MENU_JUMP_FIRST,Menu_Logic_Operation_ECU_WorkCurr},
/*MENU_ITEM_ECU_BattVolt */    {0,  MENU_INTF_ECU, MENU_ITEM_Navi_ECU, 	   	 8U,		17U, 1U, 		11U, 		80U, 	MENU_DIRECTION_LONGITUDINAL, 0XFFU, MENU_INTERFACE_MAX, MENU_JUMP_FIRST, MENU_INTF_Navi, MENU_JUMP_FIRST, 	MENU_INTERFACE_MAX, MENU_JUMP_FIRST,Menu_Logic_Operation_ECU_BattVolt},
/*MENU_ITEM_ECU_BattHighVolt */ {0,  MENU_INTF_ECU, MENU_ITEM_Navi_ECU,      	 9U,		17U, 1U, 		12U, 		80U, 	MENU_DIRECTION_LONGITUDINAL, 0XFFU, MENU_INTERFACE_MAX, MENU_JUMP_FIRST, MENU_INTF_Navi, MENU_JUMP_FIRST, 	MENU_INTERFACE_MAX, MENU_JUMP_FIRST,Menu_Logic_Operation_ECU_BattHighVolt},
/*MENU_ITEM_ECU_BattLowVolt */ {0,  MENU_INTF_ECU, MENU_ITEM_Navi_ECU,      	10U,		17U, 1U, 		13U, 		80U, 	MENU_DIRECTION_LONGITUDINAL, 0XFFU, MENU_INTERFACE_MAX, MENU_JUMP_FIRST, MENU_INTF_Navi, MENU_JUMP_FIRST, 	MENU_INTERFACE_MAX, MENU_JUMP_FIRST,Menu_Logic_Operation_ECU_BattLowVolt},
/*MENU_ITEM_ECU_BattHighTemp */ {0,  MENU_INTF_ECU, MENU_ITEM_Navi_ECU,     11U,		17U, 1U, 		14U, 		80U, 	MENU_DIRECTION_LONGITUDINAL, 0XFFU, MENU_INTERFACE_MAX, MENU_JUMP_FIRST, MENU_INTF_Navi, MENU_JUMP_FIRST, 	MENU_INTERFACE_MAX, MENU_JUMP_FIRST,Menu_Logic_Operation_ECU_BattHighTemp},
/*MENU_ITEM_ECU_BattLowTemp */ {0,  MENU_INTF_ECU, MENU_ITEM_Navi_ECU,      12U,	17U, 1U, 		15U, 		80U, 	MENU_DIRECTION_LONGITUDINAL, 0XFFU, MENU_INTERFACE_MAX, MENU_JUMP_FIRST, MENU_INTF_Navi, MENU_JUMP_FIRST, 	MENU_INTERFACE_MAX, MENU_JUMP_FIRST,Menu_Logic_Operation_ECU_BattLowTemp },
/*MENU_ITEM_ECU_ErrCode */ 	{0,  MENU_INTF_ECU, MENU_ITEM_Navi_ECU,      	13U,		17U, 1U, 		16U, 		80U, 	MENU_DIRECTION_LONGITUDINAL, 0XFFU, MENU_INTERFACE_MAX, MENU_JUMP_FIRST, MENU_INTF_Navi, MENU_JUMP_FIRST, 	MENU_INTERFACE_MAX, MENU_JUMP_FIRST,Menu_Logic_Operation_ECU_ErrCode},
/*MENU_ITEM_ECU_TPMS */        {0,  MENU_INTF_ECU, MENU_ITEM_Navi_ECU, 		14U,		17U, 1U, 		17U, 		80U, 	MENU_DIRECTION_LONGITUDINAL, 0XFFU, MENU_INTERFACE_MAX, MENU_JUMP_FIRST, MENU_INTF_Navi, MENU_JUMP_FIRST, 	MENU_INTERFACE_MAX, MENU_JUMP_FIRST,Menu_Logic_Operation_ECU_TPMS},
/*MENU_ITEM_ECU_LDW */         {0,  MENU_INTF_ECU, MENU_ITEM_Navi_ECU, 		15U,		17U, 1U, 		18U, 		80U, 	MENU_DIRECTION_LONGITUDINAL, 0XFFU, MENU_INTERFACE_MAX, MENU_JUMP_FIRST, MENU_INTF_Navi, MENU_JUMP_FIRST, 	MENU_INTERFACE_MAX, MENU_JUMP_FIRST,Menu_Logic_Operation_ECU_LDW},
/*MENU_ITEM_ECU_RADAR */       {0,  MENU_INTF_ECU, MENU_ITEM_Navi_ECU, 		16U,		17U, 1U, 		19U, 		80U, 	MENU_DIRECTION_LONGITUDINAL, 0XFFU, MENU_INTERFACE_MAX, MENU_JUMP_FIRST, MENU_INTF_Navi, MENU_JUMP_FIRST, 	MENU_INTERFACE_MAX, MENU_JUMP_FIRST,Menu_Logic_Operation_ECU_RADAR},

/*MENU_ITEM_SET_TIME */         {0,  MENU_INTF_SET, MENU_ITEM_Navi_Set, 		0U,		9U, 1U, 		20U, 		80U, 	MENU_DIRECTION_LONGITUDINAL, 	 0XFFU, 		MENU_INTF_Time_Set_Option, MENU_JUMP_FIRST, MENU_INTERFACE_MAX, 		MENU_JUMP_FIRST	, 	MENU_INTERFACE_MAX, 		MENU_JUMP_FIRST,0},
/*MENU_ITEM_SET_OVERSPEED */    {0,  MENU_INTF_SET, MENU_ITEM_Navi_Set, 	1U,		9U, 1U, 	   	21U, 		80U, 	MENU_DIRECTION_LONGITUDINAL, 	 0XFFU, 		MENU_INTF_SET_OVERSPEED, MENU_JUMP_SELECT, MENU_INTERFACE_MAX, 		MENU_JUMP_FIRST	, 	MENU_INTERFACE_MAX, 		MENU_JUMP_FIRST,0},
/*MENU_ITEM_SET_MAINT */        {0,  MENU_INTF_SET, MENU_ITEM_Navi_Set, 		2U,		9U, 1U, 	     	22U, 		80U, 	MENU_DIRECTION_LONGITUDINAL, 	 0XFFU, 		MENU_INTF_SET_MAINT, 	MENU_JUMP_SELECT, MENU_INTERFACE_MAX, 		MENU_JUMP_FIRST	, 	MENU_INTERFACE_MAX, 		MENU_JUMP_FIRST,0},
/*MENU_ITEM_SET_CLEAR */        {0,  MENU_INTF_SET, MENU_ITEM_Navi_Set, 		3U,		9U, 1U, 	      	23U, 		80U, 	MENU_DIRECTION_LONGITUDINAL, 	 0XFFU, 		MENU_INTF_SET_Clear, MENU_JUMP_FIRST,    MENU_INTERFACE_MAX, 		MENU_JUMP_FIRST	, 	MENU_INTERFACE_MAX, 		MENU_JUMP_FIRST,0},
/*MENU_ITEM_SET_LANGUAGE */     {0,  MENU_INTF_SET, MENU_ITEM_Navi_Set, 	4U,		9U, 1U, 	     	24U, 		80U, 	MENU_DIRECTION_LONGITUDINAL, 	 0XFFU, 		MENU_INTF_SET_Language, MENU_JUMP_SELECT,MENU_INTERFACE_MAX, 	MENU_JUMP_FIRST	, 	MENU_INTERFACE_MAX, 		MENU_JUMP_FIRST,0},
/*MENU_ITEM_SET_TPMS_LEARN */   {0,  MENU_INTF_SET, MENU_ITEM_Navi_Set, 	5U,		9U, 1U, 	    	25U, 		80U, 	MENU_DIRECTION_LONGITUDINAL, 	 0XFFU, 		MENU_INTF_SET_TPMS_LEARN, MENU_JUMP_FIRST,MENU_INTERFACE_MAX, 		MENU_JUMP_FIRST	, 	MENU_INTERFACE_MAX, 		MENU_JUMP_FIRST,0},
/*MENU_ITEM_SET_IC */           {0,  MENU_INTF_SET, MENU_ITEM_Navi_Set, 		6U,		9U, 1U, 	   	26U, 		80U, 	MENU_DIRECTION_LONGITUDINAL, 	 0XFFU, 		MENU_INTF_SET_IC_SW		, MENU_JUMP_FIRST,	MENU_INTERFACE_MAX, 		MENU_JUMP_FIRST	, 	MENU_INTERFACE_MAX, 		MENU_JUMP_FIRST,0},
/*MENU_ITEM_SET_FACTORYRESET */ {0,  MENU_INTF_SET, MENU_ITEM_Navi_Set, 	7U,		9U, 1U, 	 	27U, 		80U, 	MENU_DIRECTION_LONGITUDINAL, 	 0XFFU, 		MENU_INTF_SET_FactoryReset_Confirm1, MENU_JUMP_FIRST,MENU_INTERFACE_MAX, MENU_JUMP_FIRST, 	MENU_INTERFACE_MAX, 		MENU_JUMP_FIRST,0},
/*MENU_ITEM_SET_RETURN */       {0,  MENU_INTF_SET, MENU_ITEM_Navi_Set, 		8U,		9U, 1U, 		28U, 		80U, 	MENU_DIRECTION_LONGITUDINAL, 	 0XFFU, 		MENU_INTF_Navi, 	MENU_JUMP_LAST_POSITION,		MENU_INTERFACE_MAX		, MENU_JUMP_FIRST, 	MENU_INTERFACE_MAX, 		MENU_JUMP_FIRST,0},

///*MENU_ITEM_SET_TIME_MODE */    {0, MENU_INTF_Time_Set_Option, MENU_ITEM_SET_TIME, 0U,	4U, 1U, 29U, 80U, MENU_DIRECTION_LONGITUDINAL, 	0XFFU, MENU_INTF_Time_Set_Hourly, MENU_JUMP_FIRST,          MENU_INTERFACE_MAX	, MENU_JUMP_FIRST, 	MENU_INTERFACE_MAX, MENU_JUMP_FIRST,0},
/*MENU_ITEM_SET_TIME_CLOCK */   {0, MENU_INTF_Time_Set_Option, MENU_ITEM_SET_TIME, 	0U,	3U, 1U, 29U, 80U, MENU_DIRECTION_LONGITUDINAL, 	0XFFU, MENU_INTF_Time_Set_Hour,   MENU_JUMP_FIRST,		    MENU_INTERFACE_MAX	, MENU_JUMP_FIRST, 	MENU_INTERFACE_MAX, MENU_JUMP_FIRST,Menu_Logic_Operation_SET_TIME_CLOCK},
/*MENU_ITEM_SET_TIME_Synch */   {0, MENU_INTF_Time_Set_Option, MENU_ITEM_SET_TIME,  1U,	3U, 1U, 30U, 80U, MENU_DIRECTION_LONGITUDINAL, 	0XFFU, MENU_INTERFACE_MAX, 		  MENU_JUMP_FIRST,			MENU_INTERFACE_MAX	, MENU_JUMP_FIRST, 	MENU_INTERFACE_MAX, MENU_JUMP_FIRST,Menu_Logic_Operation_SET_TIME_Synch},
/*MENU_ITEM_SET_TIME_RETURN */  {0, MENU_INTF_Time_Set_Option, MENU_ITEM_SET_TIME,  2U,	3U, 1U, 31U, 80U, MENU_DIRECTION_LONGITUDINAL, 	0XFFU, MENU_INTF_SET, 		      MENU_JUMP_LAST_POSITION,	MENU_INTERFACE_MAX	, MENU_JUMP_FIRST, 	MENU_INTERFACE_MAX, MENU_JUMP_FIRST,0},

///*MENU_ITEM_SET_TIME_12MODE */     {0, MENU_INTF_Time_Set_Hourly, MENU_ITEM_SET_TIME_MODE, 0U, 3U, 1U, 33U, 80U, MENU_DIRECTION_LONGITUDINAL, 0XFFU, MENU_INTERFACE_MAX, 	    MENU_JUMP_FIRST,		MENU_INTERFACE_MAX, MENU_JUMP_FIRST, MENU_INTERFACE_MAX, MENU_JUMP_FIRST,Menu_Logic_Operation_SET_TIME_12MODE},
///*MENU_ITEM_SET_TIME_24MODE */     {0, MENU_INTF_Time_Set_Hourly, MENU_ITEM_SET_TIME_MODE, 1U, 3U, 1U, 34U, 80U, MENU_DIRECTION_LONGITUDINAL, 0XFFU, MENU_INTERFACE_MAX, 	    MENU_JUMP_FIRST,		MENU_INTERFACE_MAX, MENU_JUMP_FIRST, MENU_INTERFACE_MAX, MENU_JUMP_FIRST,Menu_Logic_Operation_SET_TIME_24MODE},
///*MENU_ITEM_SET_TIME_MODE_RETURN */{0, MENU_INTF_Time_Set_Hourly, MENU_ITEM_SET_TIME_MODE, 2U, 3U, 1U, 35U, 80U, MENU_DIRECTION_LONGITUDINAL, 0XFFU, MENU_INTF_Time_Set_Option, MENU_JUMP_LAST_POSITION,MENU_INTERFACE_MAX, MENU_JUMP_FIRST, MENU_INTERFACE_MAX, MENU_JUMP_FIRST,0},

/*MENU_ITEM_SET_TIME_CLOCK_HOUR */ {0, MENU_INTF_Time_Set_Hour, MENU_ITEM_SET_TIME_CLOCK, 0U, 1U, 1U, 32U, 80U, MENU_DIRECTION_LONGITUDINAL, 0XFFU, MENU_INTF_Time_Set_Minute, MENU_JUMP_FIRST, MENU_INTERFACE_MAX, MENU_JUMP_FIRST, MENU_INTERFACE_MAX, MENU_JUMP_FIRST,Menu_Logic_Operation_SET_TIME_CLOCK_HOUR},

/*MENU_ITEM_SET_TIME_CLOCK_MIN */ {0, MENU_INTF_Time_Set_Minute, MENU_ITEM_SET_TIME_CLOCK_HOUR, 0U, 1U,1U, 33U, 80U, MENU_DIRECTION_LONGITUDINAL, 0XFFU, MENU_INTF_Time_Set_Clock_Ret, MENU_JUMP_FIRST, MENU_INTERFACE_MAX, MENU_JUMP_FIRST, MENU_INTERFACE_MAX, MENU_JUMP_FIRST,Menu_Logic_Operation_SET_TIME_CLOCK_MIN},

///*MENU_ITEM_SET_TIME_CLOCK_APm */ {0, MENU_INTF_Time_Set_APm, MENU_ITEM_SET_TIME_CLOCK_MIN, 0U, 1U, 1U, 38U, 80U, MENU_DIRECTION_LONGITUDINAL, 0XFFU, MENU_INTF_Time_Set_Clock_Ret, MENU_JUMP_FIRST, MENU_INTERFACE_MAX, MENU_JUMP_FIRST, MENU_INTERFACE_MAX, MENU_JUMP_FIRST,Menu_Logic_Operation_SET_TIME_CLOCK_APm},

/*MENU_ITEM_SET_TIME_SET_RETURN */ {0, MENU_INTF_Time_Set_Clock_Ret, MENU_ITEM_SET_TIME_CLOCK_MIN, 0U, 1U, 1U, 34U, 80U, MENU_DIRECTION_LONGITUDINAL, 0XFFU, MENU_INTF_Time_Set_Option, MENU_JUMP_LAST_POSITION, MENU_INTERFACE_MAX, MENU_JUMP_FIRST, MENU_INTERFACE_MAX, MENU_JUMP_FIRST,0},

/*MENU_ITEM_SET_OVERSPEED_OPEN */   {0, MENU_INTF_SET_OVERSPEED, MENU_ITEM_SET_OVERSPEED, 0U, 4U, 1U, 35U, 80U, MENU_DIRECTION_LONGITUDINAL, 0XFFU, MENU_INTERFACE_MAX, MENU_JUMP_FIRST,	MENU_INTERFACE_MAX, MENU_JUMP_FIRST, MENU_INTERFACE_MAX, MENU_JUMP_FIRST,Menu_Logic_Operation_SET_OVERSPEED_OPEN},
/*MENU_ITEM_SET_OVERSPEED_CLOSE */  {0, MENU_INTF_SET_OVERSPEED, MENU_ITEM_SET_OVERSPEED, 1U, 4U, 1U, 36U, 80U, MENU_DIRECTION_LONGITUDINAL, 0XFFU, MENU_INTERFACE_MAX, MENU_JUMP_FIRST,	MENU_INTERFACE_MAX, MENU_JUMP_FIRST, MENU_INTERFACE_MAX, MENU_JUMP_FIRST,Menu_Logic_Operation_SET_OVERSPEED_CLOSE},
/*MENU_ITEM_SET_OVERSPEED_CUSTOM */ {0, MENU_INTF_SET_OVERSPEED, MENU_ITEM_SET_OVERSPEED, 2U, 4U, 1U, 37U, 80U, MENU_DIRECTION_LONGITUDINAL, 0XFFU, MENU_INTF_SET_OverSpeed_Adjust, MENU_JUMP_FIRST,	MENU_INTERFACE_MAX, MENU_JUMP_FIRST, MENU_INTERFACE_MAX, MENU_JUMP_FIRST,Menu_Logic_Operation_SET_OVERSPEED_CUSTOM},
/*MENU_ITEM_SET_OVERSPEED_RETURN */ {0, MENU_INTF_SET_OVERSPEED, MENU_ITEM_SET_OVERSPEED, 3U, 4U, 1U, 38U, 80U, MENU_DIRECTION_LONGITUDINAL, 0XFFU, MENU_INTF_SET, MENU_JUMP_LAST_POSITION,	MENU_INTERFACE_MAX, MENU_JUMP_FIRST, MENU_INTERFACE_MAX, MENU_JUMP_FIRST,0},

/*MENU_ITEM_SET_OVERSPEED_CUSTOM_ADJUST */ {0, MENU_INTF_SET_OverSpeed_Adjust, MENU_ITEM_SET_OVERSPEED_CUSTOM, 0U, 1U, 1U, 39U, 80U, MENU_DIRECTION_LONGITUDINAL, 0XFFU, MENU_INTF_SET_OverSpeed_Ret, MENU_JUMP_FIRST,	MENU_INTERFACE_MAX, MENU_JUMP_FIRST, MENU_INTERFACE_MAX, MENU_JUMP_FIRST,Menu_Logic_Operation_SET_OVERSPEED_CUSTOM_ADJUST},

/*MENU_ITEM_SET_OVERSPEED_CUSTOM_RETURN */ {0, MENU_INTF_SET_OverSpeed_Ret, MENU_ITEM_SET_OVERSPEED_CUSTOM_ADJUST, 0U, 1U, 1U, 40U, 80U, MENU_DIRECTION_LONGITUDINAL, 0XFFU, MENU_INTF_SET_OVERSPEED, MENU_JUMP_LAST_POSITION,	MENU_INTERFACE_MAX, MENU_JUMP_FIRST, MENU_INTERFACE_MAX, MENU_JUMP_FIRST,0},

/*MENU_ITEM_SET_MAINT_OPEN */  {0, MENU_INTF_SET_MAINT, MENU_ITEM_SET_MAINT, 0U, 4U, 1U, 41U, 80U, MENU_DIRECTION_LONGITUDINAL, 0XFFU, MENU_INTERFACE_MAX, MENU_JUMP_FIRST,	MENU_INTERFACE_MAX, MENU_JUMP_FIRST, MENU_INTERFACE_MAX, MENU_JUMP_FIRST,Menu_Logic_Operation_SET_MAINT_OPEN},
/*MENU_ITEM_SET_MAINT_CLOSE */ {0, MENU_INTF_SET_MAINT, MENU_ITEM_SET_MAINT, 1U, 4U, 1U, 42U, 80U, MENU_DIRECTION_LONGITUDINAL, 0XFFU, MENU_INTERFACE_MAX, MENU_JUMP_FIRST,	MENU_INTERFACE_MAX, MENU_JUMP_FIRST, MENU_INTERFACE_MAX, MENU_JUMP_FIRST,Menu_Logic_Operation_SET_MAINT_CLOSE},
/*MENU_ITEM_SET_MAINT_CHECK */ {0, MENU_INTF_SET_MAINT, MENU_ITEM_SET_MAINT, 2U, 4U, 1U, 43U, 80U, MENU_DIRECTION_LONGITUDINAL, 0XFFU, MENU_INTF_SET_MAINT_CHECK, MENU_JUMP_FIRST,	MENU_INTERFACE_MAX, MENU_JUMP_FIRST, MENU_INTERFACE_MAX, MENU_JUMP_FIRST,0},
/*MENU_ITEM_SET_MAINT_RETURN */{0, MENU_INTF_SET_MAINT, MENU_ITEM_SET_MAINT, 3U, 4U, 1U, 44U, 80U, MENU_DIRECTION_LONGITUDINAL, 0XFFU, MENU_INTF_SET, MENU_JUMP_LAST_POSITION,	MENU_INTERFACE_MAX, MENU_JUMP_FIRST, MENU_INTERFACE_MAX, MENU_JUMP_FIRST,0},

/*MENU_ITEM_SET_MAINT_CHECK_RETURN */{0, MENU_INTF_SET_MAINT_CHECK, MENU_ITEM_SET_MAINT_CHECK, 0U, 1U, 1U, 45U, 80U, MENU_DIRECTION_LONGITUDINAL, 0XFFU, MENU_INTF_SET_MAINT, MENU_JUMP_LAST_POSITION,	MENU_INTERFACE_MAX, MENU_JUMP_FIRST, MENU_INTERFACE_MAX, MENU_JUMP_FIRST,0},

/*MENU_ITEM_SET_CLEAR_TRIP */    {0, MENU_INTF_SET_Clear, MENU_ITEM_SET_CLEAR, 0U, 5U, 1U, 46U, 80U, MENU_DIRECTION_LONGITUDINAL, 0XFFU, MENU_INTF_SET_Clear_Trip, MENU_JUMP_FIRST,	MENU_INTERFACE_MAX, MENU_JUMP_FIRST, MENU_INTERFACE_MAX, MENU_JUMP_FIRST,0},
/*MENU_ITEM_SET_CLEAR_DRIVTIME */{0, MENU_INTF_SET_Clear, MENU_ITEM_SET_CLEAR, 1U, 5U, 1U, 47U, 80U, MENU_DIRECTION_LONGITUDINAL, 0XFFU, MENU_INTF_SET_Clear_DriveTime, MENU_JUMP_FIRST, MENU_INTERFACE_MAX, MENU_JUMP_FIRST, MENU_INTERFACE_MAX, MENU_JUMP_FIRST,0},
/*MENU_ITEM_SET_CLEAR_AVGSPD */  {0, MENU_INTF_SET_Clear, MENU_ITEM_SET_CLEAR, 2U, 5U, 1U, 48U, 80U, MENU_DIRECTION_LONGITUDINAL, 0XFFU, MENU_INTF_SET_Clear_AvgSpeed, MENU_JUMP_FIRST,	MENU_INTERFACE_MAX, MENU_JUMP_FIRST, MENU_INTERFACE_MAX, MENU_JUMP_FIRST,0},
/*MENU_ITEM_SET_CLEAR_AVGELC */  {0, MENU_INTF_SET_Clear, MENU_ITEM_SET_CLEAR, 3U, 5U, 1U, 49U, 80U, MENU_DIRECTION_LONGITUDINAL, 0XFFU, MENU_INTF_SET_Clear_AvgElc, MENU_JUMP_FIRST,	MENU_INTERFACE_MAX, MENU_JUMP_FIRST, MENU_INTERFACE_MAX, MENU_JUMP_FIRST,0},
/*MENU_ITEM_SET_CLEAR_RETURN */  {0, MENU_INTF_SET_Clear, MENU_ITEM_SET_CLEAR, 4U, 5U, 1U, 50U, 80U, MENU_DIRECTION_LONGITUDINAL, 0XFFU, MENU_INTF_SET, MENU_JUMP_LAST_POSITION,	MENU_INTERFACE_MAX, MENU_JUMP_FIRST, MENU_INTERFACE_MAX, MENU_JUMP_FIRST,0},

/*MENU_ITEM_SET_CLEAR_TRIP_YES */  {0, MENU_INTF_SET_Clear_Trip, MENU_ITEM_SET_CLEAR_TRIP, 0U, 2U, 1U, 51U, 80U, MENU_DIRECTION_LONGITUDINAL, 0XFFU, MENU_INTF_SET_Clear, MENU_JUMP_LAST_POSITION,	MENU_INTERFACE_MAX, MENU_JUMP_FIRST, MENU_INTERFACE_MAX, MENU_JUMP_FIRST,Menu_Logic_Operation_SET_CLEAR_TRIP_YES},
/*MENU_ITEM_SET_CLEAR_TRIP_NO */   {0, MENU_INTF_SET_Clear_Trip, MENU_ITEM_SET_CLEAR_TRIP, 1U, 2U, 1U, 52U, 80U, MENU_DIRECTION_LONGITUDINAL, 0XFFU, MENU_INTF_SET_Clear, MENU_JUMP_LAST_POSITION,	MENU_INTERFACE_MAX, MENU_JUMP_FIRST, MENU_INTERFACE_MAX, MENU_JUMP_FIRST,0},

/*MENU_ITEM_SET_CLEAR_DRIVTIME_YES */  {0, MENU_INTF_SET_Clear_DriveTime, MENU_ITEM_SET_CLEAR_DRIVTIME, 0U, 2U, 1U, 53U, 80U, MENU_DIRECTION_LONGITUDINAL, 0XFFU, MENU_INTF_SET_Clear, MENU_JUMP_LAST_POSITION,	MENU_INTERFACE_MAX, MENU_JUMP_FIRST, MENU_INTERFACE_MAX, MENU_JUMP_FIRST,Menu_Logic_Operation_SET_CLEAR_DRIVTIME_YES},
/*MENU_ITEM_SET_CLEAR_DRIVTIME_NO */   {0, MENU_INTF_SET_Clear_DriveTime, MENU_ITEM_SET_CLEAR_DRIVTIME, 1U, 2U, 1U, 54U, 80U, MENU_DIRECTION_LONGITUDINAL, 0XFFU, MENU_INTF_SET_Clear, MENU_JUMP_LAST_POSITION,	MENU_INTERFACE_MAX, MENU_JUMP_FIRST, MENU_INTERFACE_MAX, MENU_JUMP_FIRST,0},

/*MENU_ITEM_SET_CLEAR_AVGSPD_YES */  {0, MENU_INTF_SET_Clear_AvgSpeed, MENU_ITEM_SET_CLEAR_AVGSPD, 0U, 2U, 1U, 55U, 80U, MENU_DIRECTION_LONGITUDINAL, 0XFFU, MENU_INTF_SET_Clear, MENU_JUMP_LAST_POSITION,	MENU_INTERFACE_MAX, MENU_JUMP_FIRST, MENU_INTERFACE_MAX, MENU_JUMP_FIRST,Menu_Logic_Operation_SET_CLEAR_AVGSPD_YES},
/*MENU_ITEM_SET_CLEAR_AVGSPD_NO */   {0, MENU_INTF_SET_Clear_AvgSpeed, MENU_ITEM_SET_CLEAR_AVGSPD, 1U, 2U, 1U, 56U, 80U, MENU_DIRECTION_LONGITUDINAL, 0XFFU, MENU_INTF_SET_Clear, MENU_JUMP_LAST_POSITION,	MENU_INTERFACE_MAX, MENU_JUMP_FIRST, MENU_INTERFACE_MAX, MENU_JUMP_FIRST,0},

/*MENU_ITEM_SET_CLEAR_AVGELC_YES */  {0, MENU_INTF_SET_Clear_AvgElc, MENU_ITEM_SET_CLEAR_AVGELC, 0U, 2U, 1U, 57U, 80U, MENU_DIRECTION_LONGITUDINAL, 0XFFU, MENU_INTF_SET_Clear, MENU_JUMP_LAST_POSITION,	MENU_INTERFACE_MAX, MENU_JUMP_FIRST, MENU_INTERFACE_MAX, MENU_JUMP_FIRST,Menu_Logic_Operation_SET_CLEAR_AVGELC_YES},
/*MENU_ITEM_SET_CLEAR_AVGELC_NO */   {0, MENU_INTF_SET_Clear_AvgElc, MENU_ITEM_SET_CLEAR_AVGELC, 1U, 2U, 1U, 58U, 80U, MENU_DIRECTION_LONGITUDINAL, 0XFFU, MENU_INTF_SET_Clear, MENU_JUMP_LAST_POSITION,	MENU_INTERFACE_MAX, MENU_JUMP_FIRST, MENU_INTERFACE_MAX, MENU_JUMP_FIRST,0},

/*MENU_ITEM_SET_LANGUAGE_China */   {0, MENU_INTF_SET_Language, MENU_ITEM_SET_LANGUAGE, 0U, 3U, 1U, 59U, 80U, MENU_DIRECTION_LONGITUDINAL, 0XFFU, MENU_INTERFACE_MAX, MENU_JUMP_FIRST, MENU_INTERFACE_MAX, MENU_JUMP_FIRST, MENU_INTERFACE_MAX, MENU_JUMP_FIRST,Menu_Logic_Operation_SET_LANGUAGE_China},
/*MENU_ITEM_SET_LANGUAGE_ENGLISH */ {0, MENU_INTF_SET_Language, MENU_ITEM_SET_LANGUAGE, 1U, 3U, 1U, 60U, 80U, MENU_DIRECTION_LONGITUDINAL, 0XFFU, MENU_INTERFACE_MAX, MENU_JUMP_FIRST, MENU_INTERFACE_MAX, MENU_JUMP_FIRST, MENU_INTERFACE_MAX, MENU_JUMP_FIRST,Menu_Logic_Operation_SET_LANGUAGE_ENGLISH},
/*MENU_ITEM_SET_LANGUAGE_RETURN */  {0, MENU_INTF_SET_Language, MENU_ITEM_SET_LANGUAGE, 2U, 3U, 1U, 61U, 80U, MENU_DIRECTION_LONGITUDINAL, 0XFFU, MENU_INTF_SET, MENU_JUMP_LAST_POSITION, MENU_INTERFACE_MAX, MENU_JUMP_FIRST, MENU_INTERFACE_MAX, MENU_JUMP_FIRST,0},

/*MENU_ITEM_SET_TPMS_LEARN_LF */  {0, MENU_INTF_SET_TPMS_LEARN, MENU_ITEM_SET_TPMS_LEARN, 0U, 6U, 1U, 62U, 80U, MENU_DIRECTION_LONGITUDINAL, 0XFFU, MENU_INTF_SET_TPMS_Learn_Result, MENU_JUMP_FIRST, MENU_INTF_SET, MENU_JUMP_LAST_POSITION, MENU_INTERFACE_MAX, MENU_JUMP_FIRST,Menu_Logic_Operation_SET_TPMS_LEARN_LF},
/*MENU_ITEM_SET_TPMS_LEARN_RF */  {0, MENU_INTF_SET_TPMS_LEARN, MENU_ITEM_SET_TPMS_LEARN, 1U, 6U, 1U, 63U, 80U, MENU_DIRECTION_LONGITUDINAL, 0XFFU, MENU_INTF_SET_TPMS_Learn_Result, MENU_JUMP_FIRST, MENU_INTF_SET, MENU_JUMP_LAST_POSITION, MENU_INTERFACE_MAX, MENU_JUMP_FIRST,Menu_Logic_Operation_SET_TPMS_LEARN_RF},
/*MENU_ITEM_SET_TPMS_LEARN_LR */  {0, MENU_INTF_SET_TPMS_LEARN, MENU_ITEM_SET_TPMS_LEARN, 2U, 6U, 1U, 64U, 80U, MENU_DIRECTION_LONGITUDINAL, 0XFFU, MENU_INTF_SET_TPMS_Learn_Result, MENU_JUMP_FIRST, MENU_INTF_SET, MENU_JUMP_LAST_POSITION, MENU_INTERFACE_MAX, MENU_JUMP_FIRST,Menu_Logic_Operation_SET_TPMS_LEARN_LR},
/*MENU_ITEM_SET_TPMS_LEARN_MLR */ {0, MENU_INTF_SET_TPMS_LEARN, MENU_ITEM_SET_TPMS_LEARN, 3U, 6U, 1U, 65U, 80U, MENU_DIRECTION_LONGITUDINAL, 0XFFU, MENU_INTF_SET_TPMS_Learn_Result, MENU_JUMP_FIRST, MENU_INTF_SET, MENU_JUMP_LAST_POSITION, MENU_INTERFACE_MAX, MENU_JUMP_FIRST,Menu_Logic_Operation_SET_TPMS_LEARN_MLR},
/*MENU_ITEM_SET_TPMS_LEARN_MRR */ {0, MENU_INTF_SET_TPMS_LEARN, MENU_ITEM_SET_TPMS_LEARN, 4U, 6U, 1U, 66U, 80U, MENU_DIRECTION_LONGITUDINAL, 0XFFU, MENU_INTF_SET_TPMS_Learn_Result, MENU_JUMP_FIRST, MENU_INTF_SET, MENU_JUMP_LAST_POSITION, MENU_INTERFACE_MAX, MENU_JUMP_FIRST,Menu_Logic_Operation_SET_TPMS_LEARN_MRR},
/*MENU_ITEM_SET_TPMS_LEARN_RR */  {0, MENU_INTF_SET_TPMS_LEARN, MENU_ITEM_SET_TPMS_LEARN, 5U, 6U, 1U, 67U, 80U, MENU_DIRECTION_LONGITUDINAL, 0XFFU, MENU_INTF_SET_TPMS_Learn_Result, MENU_JUMP_FIRST, MENU_INTF_SET, MENU_JUMP_LAST_POSITION, MENU_INTERFACE_MAX, MENU_JUMP_FIRST,Menu_Logic_Operation_SET_TPMS_LEARN_RR},

/*MENU_ITEM_SET_TPMS_Learning */           	{0, MENU_INTF_SET_TPMS_Learn_Result, MENU_ITEM_SET_TPMS_LEARN_LF, 0U, 5U, 1U, 68U, 80U, MENU_DIRECTION_LONGITUDINAL, 0XFFU, MENU_INTERFACE_MAX, MENU_JUMP_FIRST, MENU_INTF_SET_TPMS_LEARN, MENU_JUMP_LAST_POSITION, MENU_INTERFACE_MAX, MENU_JUMP_FIRST,Menu_Logic_Operation_SET_TPMS_Learning},
/*MENU_ITEM_SET_TPMS_Learn_TimeOut */      {0, MENU_INTF_SET_TPMS_Learn_Result, MENU_ITEM_SET_TPMS_LEARN_LF, 1U, 5U, 1U, 69U, 80U, MENU_DIRECTION_LONGITUDINAL, 0XFFU, MENU_INTERFACE_MAX, MENU_JUMP_FIRST, MENU_INTF_SET_TPMS_LEARN, MENU_JUMP_LAST_POSITION, MENU_INTERFACE_MAX, MENU_JUMP_FIRST,Menu_Logic_Operation_SET_TPMS_Learn_TimeOut},
/*MENU_ITEM_SET_TPMS_Learn_IDConflict */   {0, MENU_INTF_SET_TPMS_Learn_Result, MENU_ITEM_SET_TPMS_LEARN_LF, 2U, 5U, 1U, 70U, 80U, MENU_DIRECTION_LONGITUDINAL, 0XFFU, MENU_INTERFACE_MAX, MENU_JUMP_FIRST, MENU_INTF_SET_TPMS_LEARN, MENU_JUMP_LAST_POSITION, MENU_INTERFACE_MAX, MENU_JUMP_FIRST,Menu_Logic_Operation_SET_TPMS_Learn_IDConflict},
/*MENU_ITEM_SET_TPMS_Learn_HaveVechSpeed */{0, MENU_INTF_SET_TPMS_Learn_Result, MENU_ITEM_SET_TPMS_LEARN_LF, 3U, 5U, 1U, 71U, 80U, MENU_DIRECTION_LONGITUDINAL, 0XFFU, MENU_INTERFACE_MAX, MENU_JUMP_FIRST, MENU_INTF_SET_TPMS_LEARN, MENU_JUMP_LAST_POSITION, MENU_INTERFACE_MAX, MENU_JUMP_FIRST,Menu_Logic_Operation_SET_TPMS_Learn_HaveVechSpeed},
/*MENU_ITEM_SET_TPMS_Learn_Succeed */      {0, MENU_INTF_SET_TPMS_Learn_Result, MENU_ITEM_SET_TPMS_LEARN_LF, 4U, 5U, 1U, 72U, 80U, MENU_DIRECTION_LONGITUDINAL, 0XFFU, MENU_INTERFACE_MAX, MENU_JUMP_FIRST, MENU_INTF_SET_TPMS_LEARN, MENU_JUMP_LAST_POSITION, MENU_INTERFACE_MAX, MENU_JUMP_FIRST,Menu_Logic_Operation_SET_TPMS_Learn_Succeed},

///*MENU_ITEM_SET_IC_ResCheck */{0, MENU_INTF_SET_IC_SW, MENU_ITEM_SET_IC, 0U, 2U, 1U, 78U, 80U, MENU_DIRECTION_LONGITUDINAL, 0XFFU, MENU_INTF_SET_IC_ResCheck, MENU_JUMP_FIRST, MENU_INTERFACE_MAX, MENU_JUMP_FIRST, MENU_INTERFACE_MAX, MENU_JUMP_FIRST,0},
/*MENU_ITEM_SET_IC_RETUEN */  {0, MENU_INTF_SET_IC_SW, MENU_ITEM_SET_IC, 0U, 1U, 1U, 73U, 80U, MENU_DIRECTION_LONGITUDINAL, 0XFFU, MENU_INTF_SET, MENU_JUMP_LAST_POSITION, MENU_INTERFACE_MAX, MENU_JUMP_FIRST, MENU_INTERFACE_MAX, MENU_JUMP_FIRST,0},

///*MENU_ITEM_SET_IC_ResCheckRet */  {0, MENU_INTF_SET_IC_ResCheck, MENU_ITEM_SET_IC_ResCheck, 0U, 1U, 1U, 80U, 80U, MENU_DIRECTION_LONGITUDINAL, 0XFFU, MENU_INTF_SET_IC_SW, MENU_JUMP_LAST_POSITION, MENU_INTERFACE_MAX, MENU_JUMP_FIRST, MENU_INTERFACE_MAX, MENU_JUMP_FIRST,0},

/*MENU_ITEM_SET_FactoryReset_Confirm1 */    {0, MENU_INTF_SET_FactoryReset_Confirm1, MENU_ITEM_SET_FACTORYRESET, 0U, 2U, 1U, 74U, 80U, MENU_DIRECTION_LONGITUDINAL, 0XFFU, MENU_INTF_SET_FactoryReset_Confirm2, MENU_JUMP_LAST_POSITION, MENU_INTERFACE_MAX, MENU_JUMP_FIRST, MENU_INTERFACE_MAX, MENU_JUMP_FIRST,0},
/*MENU_ITEM_SET_FactoryReset_Confirm1_Ret */{0, MENU_INTF_SET_FactoryReset_Confirm1, MENU_ITEM_SET_FACTORYRESET, 1U, 2U, 1U, 75U, 80U, MENU_DIRECTION_LONGITUDINAL, 0XFFU, MENU_INTF_SET, MENU_JUMP_LAST_POSITION, MENU_INTERFACE_MAX, MENU_JUMP_FIRST, MENU_INTERFACE_MAX, MENU_JUMP_FIRST,0},

/*MENU_ITEM_SET_FactoryReset_Confirm2 */    {0, MENU_INTF_SET_FactoryReset_Confirm2, MENU_ITEM_SET_FactoryReset_Confirm1, 0U, 2U, 1U, 76U, 80U, MENU_DIRECTION_LONGITUDINAL, 0XFFU, MENU_INTF_Navi, MENU_JUMP_FIRST, MENU_INTERFACE_MAX, MENU_JUMP_FIRST, MENU_INTERFACE_MAX, MENU_JUMP_FIRST,Menu_Logic_Operation_SET_FactoryReset_Confirm2},
/*MENU_ITEM_SET_FactoryReset_Confirm2_Ret */{0, MENU_INTF_SET_FactoryReset_Confirm2, MENU_ITEM_SET_FactoryReset_Confirm1, 1U, 2U, 1U, 77U, 80U, MENU_DIRECTION_LONGITUDINAL, 0XFFU, MENU_INTF_SET_FactoryReset_Confirm1, MENU_JUMP_LAST_POSITION, MENU_INTERFACE_MAX, MENU_JUMP_FIRST, MENU_INTERFACE_MAX, MENU_JUMP_FIRST,0},

/*MENU_ITEM_Navi_Demand_Alam */{0, MENU_INTF_Demand, MENU_ITEM_Navi_Demand, 0U, 1U, 1U, 78U, 80U, MENU_DIRECTION_LONGITUDINAL, 0XFFU, MENU_INTERFACE_MAX, MENU_JUMP_FIRST, MENU_INTF_Navi, MENU_JUMP_LAST_POSITION, MENU_INTERFACE_MAX, MENU_JUMP_FIRST,Menu_Logic_Operation_Navi_Demand_Alam},
///*MENU_ITEM_Navi_Demand_Alam_RETUEN */{0, MENU_INTF_Demand, MENU_ITEM_Navi_Demand, 1U, 2U, 1U, 79U, 80U, MENU_DIRECTION_LONGITUDINAL, 0XFFU, MENU_INTF_Navi, MENU_JUMP_FIRST, MENU_INTERFACE_MAX, MENU_JUMP_FIRST,MENU_INTERFACE_MAX, MENU_JUMP_FIRST,0},

};

/*-------------------------------------------------------------------------------------------------*/

/*--------------------------The following usage is recommended, but not required--------------------------------*/
/*--------------------------The following usage is recommended, but not required--------------------------------*/
/*--------------------------The following usage is recommended, but not required--------------------------------*/

#if 0
/*���밴������ִ��֮ǰ��ҪԤ�ȴ����Ķ���*/
static void Menu_Cursor_Preprocess(Menu_Key_en_t enMenuKey)
{
}
/*���밴������ִ��֮����Ҫ���ô����Ķ���*/

static void Menu_Cursor_Postprocess(Menu_Key_en_t enMenuKey)
{
	/*if(Menu_Get_Current_Cursor_Information() == MENU_ITEM_SET_TIME_CLOCK_APm)
	{
		if(enMenuKey == MENU_KEY_CONFIRM_SHORT)
		{
			if(Menu_Item_Select_Get(MENU_ITEM_SET_TIME_24MODE))
			{
				Menu_Cursor_Process(MENU_KEY_CONFIRM_SHORT);
			}
		}
	}*/
}
#endif

/*------------���밴������-----------------------*/
void Menu_Service(Menu_Key_en_t enMenuKey)
{
	/*���ܻص������ĵ���*/
	Menu_Logic_Process(enMenuKey);
	/*--------------------------------------------------*/
	/*���������Թ��Ĵ���*/
	//Menu_Cursor_Preprocess(enMenuKey);
	Menu_Cursor_Process(enMenuKey);
	//Menu_Cursor_Postprocess(enMenuKey);
	/*--------------------------------------------------*/
}

/*------------��������ߣ�����֮�󲻻ᱻ�����RAM������-------------------------*/
/*------------��������ߣ�����֮�󲻻ᱻ�����RAM������-------------------------*/
/*------------��������ߣ�����֮�󲻻ᱻ�����RAM������-------------------------*/
//#pragma ghs section bss = ".myNonInitArea"
uint8_t u8MenuRamData[MENU_RAM_DATA_LEN];
//#pragma ghs section bss = default
/*---------------------------------------*/
/*---------------------------------------*/
/*---------------------------------------*/
