#include "EOL_Para.h"
#include "IC_Config.h" 


_EOL_F101 EOL_F101;
_EOL_F102 EOL_F102;
_EOL_F110 EOL_F110;



void EOL_InitVal(void)
{
    uint8_t i;
 
    #if(IC_Current == LD01)
    {
        EOL_F101.F101_Byte[0u] = 0x31u;
        EOL_F101.F101_Byte[1u] = 0x12u;
        EOL_F101.F101_Byte[2u] = 0x01u;
        EOL_F101.F101_Byte[3u] = 0x44u;
        EOL_F101.F101_Byte[4u] = 0x88u;
        EOL_F101.F101_Byte[5u] = 0x04u;
        EOL_F101.F101_Byte[6u] = 0x01u;
        EOL_F101.F101_Byte[7u] = 0x24u;
        
        EOL_F110.F110_Byte[0u] = 0x80u;
        EOL_F110.F110_Byte[1u] = 0x00u;
        EOL_F110.F110_Byte[2u] = 0x00u;
        EOL_F110.F110_Byte[3u] = 0x80u;
        EOL_F110.F110_Byte[4u] = 0x00u;
        EOL_F110.F110_Byte[5u] = 0x00u;
        EOL_F110.F110_Byte[6u] = 0x21u;
        EOL_F110.F110_Byte[7u] = 0x20u;
        
        for(i = 0;i < 24u;i++) 
       {
          EOL_F102.F102_Byte[i] = 0x00u;
       }
        
       EOL_F102.F102_Byte[0u]  = 0x69u;	      //105
       EOL_F102.F102_Byte[1u]  = 0x82u;	        //130
 //��ֵ      
       EOL_F102.F102_Byte[2u]  = 105u;   //E
       EOL_F102.F102_Byte[3u]  = 83u;   //1/8
       EOL_F102.F102_Byte[4u]  = 62u;   //2/8
       EOL_F102.F102_Byte[5u]  = 47u;   //3/8
       EOL_F102.F102_Byte[6u]  = 32u;   //4/8
       EOL_F102.F102_Byte[7u]  = 27u;   //5/8
       EOL_F102.F102_Byte[8u]  = 22u;   //6/8
       EOL_F102.F102_Byte[9u]  = 18u;   //7/8   
       EOL_F102.F102_Byte[10u]  = 13u;   //8/8
 //����
       EOL_F102.F102_Byte[11u]  = 12u;   //E	   //  12 	    0
       EOL_F102.F102_Byte[12u]  = 18u;   //1/8	    //	15	     3
       EOL_F102.F102_Byte[13u]  = 27u;   //2/8	     //27	     15
       EOL_F102.F102_Byte[14u]  = 33u;   //3/8	      //42	        30
       EOL_F102.F102_Byte[15u]  = 40u;   //4/8	       //54		42
       EOL_F102.F102_Byte[16u]  = 46u;   //5/8	        //67		  55
       EOL_F102.F102_Byte[17u]  = 54u;   //6/8	       //75		   63
       EOL_F102.F102_Byte[18u]  = 62u;   //7/8        //  84		  72
       EOL_F102.F102_Byte[19u]  = 67u;   //8/8	      //  90		   78	    5a
 //ȼ�ͱ�����      
       EOL_F102.F102_Byte[20u]  = 83u;   //8/8
    }
    #else if(IC_Current == LD02)
    {
        EOL_F101.F101_Byte[0u] = 0x21u;  
        EOL_F101.F101_Byte[1u] = 0x1Au;	   //2-4 0001.1010  2-0 0010.1010
        EOL_F101.F101_Byte[2u] = 0x01u;	  
        EOL_F101.F101_Byte[3u] = 0x44u;
        EOL_F101.F101_Byte[4u] = 0xaAu;    //bag0010.1010  acu0001.1010
        EOL_F101.F101_Byte[5u] = 0xA1u;    //1010.0001
        EOL_F101.F101_Byte[6u] = 0x01u;
        EOL_F101.F101_Byte[7u] = 0x42u;	   //0100.0010
        
        EOL_F110.F110_Byte[0u] = 0xffu;
        EOL_F110.F110_Byte[1u] = 0xffu;									       
        EOL_F110.F110_Byte[2u] = 0xffu;
        EOL_F110.F110_Byte[3u] = 0xffu;
        EOL_F110.F110_Byte[4u] = 0xffu;   	   
        EOL_F110.F110_Byte[5u] = 0xffu;	   //1110.0000
        EOL_F110.F110_Byte[6u] = 0xffu;	   	 
        EOL_F110.F110_Byte[7u] = 0xffu;     //0110.0000
        
        for(i = 0;i < 24u;i++) 
       {
          EOL_F102.F102_Byte[i] = 0x00u;
       }
       
       EOL_F102.F102_Byte[0u]  = 0x69u;	      //105
       EOL_F102.F102_Byte[1u]  = 0x82u;	        //130
//��ֵ      
       EOL_F102.F102_Byte[2u]  = 105u;   //E
       EOL_F102.F102_Byte[3u]  = 83u;   //1/8
       EOL_F102.F102_Byte[4u]  = 62u;   //2/8
       EOL_F102.F102_Byte[5u]  = 47u;   //3/8
       EOL_F102.F102_Byte[6u]  = 32u;   //4/8
       EOL_F102.F102_Byte[7u]  = 27u;   //5/8
       EOL_F102.F102_Byte[8u]  = 22u;   //6/8
       EOL_F102.F102_Byte[9u]  = 18u;   //7/8   
       EOL_F102.F102_Byte[10u]  = 13u;   //8/8
 //����
       EOL_F102.F102_Byte[11u]  = 12u;   //E
       EOL_F102.F102_Byte[12u]  = 18u;   //1/8
       EOL_F102.F102_Byte[13u]  = 27u;   //2/8
       EOL_F102.F102_Byte[14u]  = 33u;   //3/8
       EOL_F102.F102_Byte[15u]  = 40u;   //4/8
       EOL_F102.F102_Byte[16u]  = 46u;   //5/8
       EOL_F102.F102_Byte[17u]  = 54u;   //6/8
       EOL_F102.F102_Byte[18u]  = 62u;   //7/8   
       EOL_F102.F102_Byte[19u]  = 67u;   //8/8
 //ȼ�ͱ�����      
       EOL_F102.F102_Byte[20u]  = 83u;   //8/8
    }
    #endif
    
   
}

void EOL_SetF101(uint8_t EOL[], uint8_t len)
{
    uint8_t i;

    if (len == 8u)
    {
        for (i = 0u; i < sizeof(EOL_F101); i++)
        {
            EOL_F101.F101_Byte[i] = EOL[i];
        }
    }
}


void EOL_SetF102(uint8_t EOL[], uint8_t len)
{
    uint8_t i;
    if (len == 24u)
    {
        for (i = 0u; i < sizeof(EOL_F102); i++)
        {
            EOL_F102.F102_Byte[i] = EOL[i];
        }
    }
}/**/

void EOL_SetF110(uint8_t EOL[], uint8_t len)
{
    uint8_t i;
    if (len == 8u)
    {
        for (i = 0u; i < sizeof(EOL_F110); i++)
        {
            EOL_F110.F110_Byte[i] = EOL[i];
        }
    }
}


_EOL_F101 EOL_GetF101(void)
{
    return EOL_F101;
}

_EOL_F102 EOL_GetF102(void)
{
    return EOL_F102;
}
/**/
_EOL_F110 EOL_GetF110(void)
{
    return EOL_F110;
}

/*F101*/

/*BYTE0*/
//����
uint8_t Val_EOL_F101_ConfigType(void)
{
    uint8_t Res;
    Res = (uint8_t)((EOL_F101.F101_Byte[0u] >> 4) &0x0F);
    return Res;
}
//����
uint8_t Val_EOL_F101_Language(void)
{
    uint8_t Res;
    Res = (uint8_t)(EOL_F101.F101_Byte[0u] &0x0F);
    return Res;
}
/*BYTE1*/
//̥ѹ
uint8_t Val_EOL_F101_TPMSType(void)
{
    uint8_t Res;
    Res = (uint8_t)((EOL_F101.F101_Byte[1u] >> 4u) & 0x0Fu);
    return Res;
}
//����ƫ��
uint8_t Val_EOL_F101_LDW(void)
{
    uint8_t Res;
    Res = (uint8_t)((EOL_F101.F101_Byte[1u] >> 2u) & 0x03u);  
    return Res;
}
//Ѳ��
uint8_t Val_EOL_F101_Cruise(void)
{
    uint8_t Res;
    Res = (uint8_t)(EOL_F101.F101_Byte[1u]  & 0x03u);
    return Res;
}

/*BYTE2*/
//EPB����
uint8_t Val_EOL_F101_EmissionsStandards(void)
{
    uint8_t Res;
    Res = (uint8_t)((EOL_F101.F101_Byte[2u] >> 6u) & 0x03u);
    return Res;
}
//ǰ��ײ �����ƶ�
uint8_t Val_EOL_F101_FCW_AEB(void)
{
    uint8_t Res;
    Res = (uint8_t)((EOL_F101.F101_Byte[2u] >> 4u) & 0x03u);
    return Res;
}
//ƽ���ͺĳ�ʼֵ
uint8_t Val_EOL_F101_AverageFuel(void)
{
    uint8_t Res;
    Res = (uint8_t)((EOL_F101.F101_Byte[2u]) & 0x0Fu);
    return Res;
}

/*BYTE3*/
//�����״�
uint8_t Val_EOL_F101_PDC(void)
{
    uint8_t Res;
    Res = (uint8_t)((EOL_F101.F101_Byte[3u] >> 4u) & 0x0Fu);
    return Res;
}
//OTA������ʽ
uint8_t Val_EOL_F101_OTA(void)
{
    uint8_t Res;
    Res = (uint8_t)((EOL_F101.F101_Byte[3u] >> 2u) & 0x03u);
    return Res;
}
//��������
uint8_t Val_EOL_F101_AirFilterBlocking(void)
{
    uint8_t Res;
    Res = (uint8_t)((EOL_F101.F101_Byte[3u]) & 0x03u);
    return Res;
}

/*BYTE4*/
//�ƶ�����
uint8_t Val_EOL_F101_Break(void)
{
    uint8_t Res;
    Res = (uint8_t)((EOL_F101.F101_Byte[4u] >> 6u) & 0x03u);
    return Res;
}
//��ײ����
uint8_t Val_EOL_F101_CollisionSystem(void)
{
    uint8_t Res;
    Res = (uint8_t)((EOL_F101.F101_Byte[4u] >> 4u) & 0x03u);
    return Res;
}
//��������
uint8_t Val_EOL_F101_ServiceMaintain(void)
{
    uint8_t Res;
    Res = (uint8_t)((EOL_F101.F101_Byte[4u] >>2u) & 0x03u);
    return Res;
}
//�Զ�פ��
uint8_t Val_EOL_F101_AutoHold(void)
{
    uint8_t Res;
    Res = (uint8_t)(EOL_F101.F101_Byte[4u] & 0x03u);
    return Res;
}
/*BYTE5*/
//������������
uint8_t Val_EOL_F101_ASR(void)
{
    uint8_t Res;
    Res = (uint8_t)((EOL_F101.F101_Byte[5u] >> 6u) & 0x03u);
    return Res;
}
//��������
uint8_t Val_EOL_F101_LKA(void)
{
    uint8_t Res;
    Res = (uint8_t)((EOL_F101.F101_Byte[5u] >> 4u) & 0x03u);
    return Res;
}
//ȼ�͵��跶Χ
uint8_t Val_EOL_F101_FuelResistanceRange (void)
{
    uint8_t Res;
    Res = (uint8_t)((EOL_F101.F101_Byte[5u] >> 2u) & 0x03u);
    return Res;
}
//Ѳ���ٶ�
uint8_t Val_EOL_F101_CruiseSpeed (void)
{
    uint8_t Res;
    Res = (uint8_t)((EOL_F101.F101_Byte[5u]) & 0x03u);
    return Res;
}

/*BYTE6*/
//ADAS��Ӧ��
uint8_t Val_EOL_F101_ADAS(void)
{
    uint8_t Res;
    Res = (uint8_t)((EOL_F101.F101_Byte[6u] >> 5u) & 0x07u);
    return Res;
}
//�ƶ���Ӧ��
uint8_t Val_EOL_F101_BrakeSupplier(void)
{
    uint8_t Res;
    Res = (uint8_t)((EOL_F101.F101_Byte[6u] >> 2u) & 0x07u);
    return Res;
}
//����������
uint8_t Val_EOL_F101_TransmissionType(void)
{
    uint8_t Res;
    Res = (uint8_t)((EOL_F101.F101_Byte[6u]) & 0x03u);
    return Res;
}

/*BYTE7*/
//��ѹ����������
uint8_t Val_EOL_F101_baroceptor(void)
{
    uint8_t Res;
    Res = (uint8_t)((EOL_F101.F101_Byte[7u] >> 5u) & 0x07u);
    return Res;
}
//������
uint8_t Val_EOL_F101_Engine(void)
{
    uint8_t Res;
    Res = (uint8_t)((EOL_F101.F101_Byte[7u] >> 2u) & 0x07u);
    return Res;
}
//TBOX����״̬
uint8_t Val_EOL_F101_TBOX(void)
{
    uint8_t Res;
    Res = (uint8_t)((EOL_F101.F101_Byte[7u] >>1u) & 0x01u);
    return Res;
}
//Ԥ��2
uint8_t Val_EOL_F101_Reserved2(void)
{
    uint8_t Res;
    Res = (uint8_t)(EOL_F101.F101_Byte[7u] & 0x01u);
    return Res;
}
/****F102***/

/**byte0*/
uint8_t Val_EOL_F102_WarningEngineCoolantTemperature(void)
{
    uint8_t Res;
    Res = EOL_F102.F102_Byte[0u];
    return Res;
}
/**byte1*/
uint8_t Val_EOL_F102_HEngineCoolantTemperature(void)
{
    uint8_t Res;
    Res = EOL_F102.F102_Byte[1u];
    return Res;
}
/**byte2*/
uint8_t Val_EOL_F102_EFuelSensor(void)
{
    uint8_t Res;
    Res = EOL_F102.F102_Byte[2u];
    return Res;
}
/**byte3*/
uint8_t Val_EOL_F102_EighthFuelSensor(void)
{
    uint8_t Res;
    Res = EOL_F102.F102_Byte[3u];
    return Res;
}
/**byte4*/
uint8_t Val_EOL_F102_QuarterFuelSensor(void)
{
    uint8_t Res;
    Res = EOL_F102.F102_Byte[4u];
    return Res;
}
/**byte5*/
uint8_t Val_EOL_F102_Three8FuelSensor(void)
{
    uint8_t Res;
    Res = EOL_F102.F102_Byte[5u];
    return Res;
}
/**byte6*/
uint8_t Val_EOL_F102_AHalfFuelSensor(void)
{
    uint8_t Res;
    Res = EOL_F102.F102_Byte[6u];
    return Res;
}
/**byte7*/
uint8_t Val_EOL_F102_Five8FuelSensor(void)
{
    uint8_t Res;
    Res = EOL_F102.F102_Byte[7u];
    return Res;
}
/**byte8*/
uint8_t Val_EOL_F102_Three3FuelSensor(void)
{
    uint8_t Res;
    Res = EOL_F102.F102_Byte[8u];
    return Res;
}
/**byte9*/
uint8_t Val_EOL_F102_Seven8FuelSensor(void)
{
    uint8_t Res;
    Res = EOL_F102.F102_Byte[9u];
    return Res;
}
/**byte10*/
uint8_t Val_EOL_F102_FFuelSensor(void)
{
    uint8_t Res;
    Res = EOL_F102.F102_Byte[10u];
    return Res;
}
/**byte11*/
uint8_t Val_EOL_F102_EFuelLevel(void)
{
    uint8_t Res;
    Res = EOL_F102.F102_Byte[11u];
    return Res;
}
/**byte12*/
uint8_t Val_EOL_F102_EighthFuelLevel(void)
{
    uint8_t Res;
    Res = EOL_F102.F102_Byte[12u];
    return Res;
}
/**byte13*/
uint8_t Val_EOL_F102_QuarterFuelLevel(void)
{
    uint8_t Res;
    Res = EOL_F102.F102_Byte[13u];
    return Res;
}
/**byte14*/
uint8_t Val_EOL_F102_Three8FuelLevel(void)
{
    uint8_t Res;
    Res = EOL_F102.F102_Byte[14u];
    return Res;
}
/**byte15*/
uint8_t Val_EOL_F102_AHalfFuelLevel(void)
{
    uint8_t Res;
    Res = EOL_F102.F102_Byte[15u];
    return Res;
}
/**byte16*/
uint8_t Val_EOL_F102_Five8FuelLevel(void)
{
    uint8_t Res;
    Res = EOL_F102.F102_Byte[16u];
    return Res;
}
/**byte17*/
uint8_t Val_EOL_F102_Three4FuelLevel(void)
{
    uint8_t Res;
    Res = EOL_F102.F102_Byte[17u];
    return Res;
}
/**byte18*/
uint8_t Val_EOL_F102_Seven8FuelLevel(void)
{
    uint8_t Res;
    Res = EOL_F102.F102_Byte[18u];
    return Res;
}
/**byte19*/
uint8_t Val_EOL_F102_FFuelLevel(void)
{
    uint8_t Res;
    Res = EOL_F102.F102_Byte[19u];
    return Res;
}/**byte20*/
uint8_t Val_EOL_F102_FuelAlarm(void)
{
    uint8_t Res;
    Res = EOL_F102.F102_Byte[20u];
    return Res;
}


/****F110***/

/**byte0*/
uint8_t Val_EOL_F110_EMS(void)
{
    uint8_t Res;
    Res = (uint8_t)((EOL_F110.F110_Byte[0u] >> 7u) & 0x01u);
    return Res;
}
uint8_t Val_EOL_F110_BMS(void)
{
    uint8_t Res;
    Res = (uint8_t)((EOL_F110.F110_Byte[0u] >> 6u) & 0x01u);
    return Res;
}
uint8_t Val_EOL_F110_HCM(void)
{
    uint8_t Res;
    Res = (uint8_t)((EOL_F110.F110_Byte[0u] >> 5u) & 0x01u);
    return Res;
}
uint8_t Val_EOL_F110_VCU(void)
{
    uint8_t Res;
    Res = (uint8_t)((EOL_F110.F110_Byte[0u] >> 4u) & 0x01u);
    return Res;
}
uint8_t Val_EOL_F110_MCU(void)
{
    uint8_t Res;
    Res = (uint8_t)((EOL_F110.F110_Byte[0u] >> 3u) & 0x01u);
    return Res;
}
uint8_t Val_EOL_F110_DCDC_24V(void)
{
    uint8_t Res;
    Res = (uint8_t)((EOL_F110.F110_Byte[0u] >> 2u) & 0x01u);
    return Res;
}
uint8_t Val_EOL_F110_DCDC_12V(void)
{
    uint8_t Res;
    Res = (uint8_t)((EOL_F110.F110_Byte[0u] >> 1u) & 0x01u);
    return Res;
}

uint8_t Val_EOL_F110_OBC(void)
{
    uint8_t Res;
    Res = (uint8_t)((EOL_F110.F110_Byte[0u]) & 0x01u);
    return Res;
}


/**byte1**/
uint8_t Val_EOL_F110_BDCAC(void)
{
    uint8_t Res;
    Res = (uint8_t)((EOL_F110.F110_Byte[1u] >> 7u) & 0x01u);
    return Res;
}
uint8_t Val_EOL_F110_SDCAC(void)
{
    uint8_t Res;
    Res = (uint8_t)((EOL_F110.F110_Byte[1u] >> 6u) & 0x01u);
    return Res;
}
uint8_t Val_EOL_F110_CCU(void)
{
    uint8_t Res;
    Res = (uint8_t)((EOL_F110.F110_Byte[1u] >> 5u) & 0x01u);
    return Res;
}
uint8_t Val_EOL_F110_GCU(void)
{
    uint8_t Res;
    Res = (uint8_t)((EOL_F110.F110_Byte[1u] >> 4u) & 0x01u);
    return Res;
}
uint8_t Val_EOL_F110_PFGU(void)
{
    uint8_t Res;
    Res = (uint8_t)((EOL_F110.F110_Byte[1u] >> 3u) & 0x01u);
    return Res;
}
uint8_t Val_EOL_F110_DCU(void)
{
    uint8_t Res;
    Res = (uint8_t)((EOL_F110.F110_Byte[1u] >> 2u) & 0x01u);
    return Res;
}
uint8_t Val_EOL_F110_DCU1(void)
{
    uint8_t Res;
    Res = (uint8_t)((EOL_F110.F110_Byte[1u] >> 1u) & 0x01u);
    return Res;
}
uint8_t Val_EOL_F110_Reserved2(void)
{
    uint8_t Res;
    Res = (uint8_t)(EOL_F110.F110_Byte[1u] & 0x01u);
    return Res;
}


/**byte2**/
uint8_t Val_EOL_F110_TCU(void)
{
    uint8_t Res;
    Res = (uint8_t)((EOL_F110.F110_Byte[2u] >> 7u) & 0x01u);
    return Res;
}
uint8_t Val_EOL_F110_EGSM(void)
{
    uint8_t Res;
    Res = (uint8_t)((EOL_F110.F110_Byte[2u] >> 6u) & 0x01u);
    return Res;
}
uint8_t Val_EOL_F110_ESC_L(void)
{
    uint8_t Res;
    Res = (uint8_t)((EOL_F110.F110_Byte[2u] >> 5u) & 0x01u);
    return Res;
}
uint8_t Val_EOL_F110_MGU(void)
{
    uint8_t Res;
    Res = (uint8_t)((EOL_F110.F110_Byte[2u] >> 4u) & 0x01u);
    return Res;
}
uint8_t Val_EOL_F110_DR(void)
{
    uint8_t Res;
    Res = (uint8_t)((EOL_F110.F110_Byte[2u] >> 3u) & 0x01u);
    return Res;
}
uint8_t Val_EOL_F110_HMS(void)
{
    uint8_t Res;
    Res = (uint8_t)((EOL_F110.F110_Byte[2u] >> 2u) & 0x01u);
    return Res;
}
uint8_t Val_EOL_F110_HFCU(void)
{
    uint8_t Res;
    Res = (uint8_t)((EOL_F110.F110_Byte[2u] >> 1u) & 0x01u);
    return Res;
}

uint8_t Val_EOL_F110_EPB_Air(void)
{
    uint8_t Res;
    Res = (uint8_t)((EOL_F110.F110_Byte[2u]) & 0x01u);
    return Res;
}

/*byte3**/

uint8_t Val_EOL_F110_ABS(void)
{
    uint8_t Res;
    Res = (uint8_t)((EOL_F110.F110_Byte[3u] >> 7u) & 0x01u);
    return Res;
}
uint8_t Val_EOL_F110_ESC_W(void)
{
    uint8_t Res;
    Res = (uint8_t)((EOL_F110.F110_Byte[3u] >> 6u) & 0x01u);
    return Res;
}
uint8_t Val_EOL_F110_EBS(void)
{
    uint8_t Res;
    Res = (uint8_t)((EOL_F110.F110_Byte[3u] >> 5u) & 0x01u);
    return Res;
}
uint8_t Val_EOL_F110_EPB_Liquid(void)
{
    uint8_t Res;
    Res = (uint8_t)((EOL_F110.F110_Byte[3u] >> 4u) & 0x01u);
    return Res;
}
uint8_t Val_EOL_F110_ACU(void)
{
    uint8_t Res;
    Res = (uint8_t)((EOL_F110.F110_Byte[3u] >> 3u) & 0x01u);
    return Res;
}
uint8_t Val_EOL_F110_SAS(void)
{
    uint8_t Res;
    Res = (uint8_t)((EOL_F110.F110_Byte[3u] >> 2u) & 0x01u);
    return Res;
}
uint8_t Val_EOL_F110_ECAS(void)
{
    uint8_t Res;
    Res = (uint8_t)((EOL_F110.F110_Byte[3u] >> 1u) & 0x01u);
    return Res;
}

uint8_t Val_EOL_F110_EPS(void)
{
    uint8_t Res;
    Res = (uint8_t)((EOL_F110.F110_Byte[3u]) & 0x01u);
    return Res;
}
/**BYTE4*/
uint8_t Val_EOL_F110_EPS_A(void)
{
    uint8_t Res;
    Res = (uint8_t)((EOL_F110.F110_Byte[4u] >> 7u) & 0x01u);
    return Res;
}
uint8_t Val_EOL_F110_FCS(void)
{
    uint8_t Res;
    Res = (uint8_t)((EOL_F110.F110_Byte[4u] >> 6u) & 0x01u);
    return Res;
}
uint8_t Val_EOL_F110_FRS(void)
{
    uint8_t Res;
    Res = (uint8_t)((EOL_F110.F110_Byte[4u] >> 5u) & 0x01u);
    return Res;
}
uint8_t Val_EOL_F110_ADAS(void)
{
    uint8_t Res;
    Res = (uint8_t)((EOL_F110.F110_Byte[4u] >> 4u) & 0x01u);
    return Res;
}
uint8_t Val_EOL_F110_ICE(void)
{
    uint8_t Res;
    Res = (uint8_t)((EOL_F110.F110_Byte[4u] >> 3u) & 0x01u);
    return Res;
}
uint8_t Val_EOL_F110_HVB(void)
{
    uint8_t Res;
    Res = (uint8_t)((EOL_F110.F110_Byte[4u] >> 2u) & 0x01u);
    return Res;
}
uint8_t Val_EOL_F110_HVBC(void)
{
    uint8_t Res;
    Res = (uint8_t)((EOL_F110.F110_Byte[4u] >> 1u) & 0x01u);
    return Res;
}

uint8_t Val_EOL_F110_BPTC(void)
{
    uint8_t Res;
    Res = (uint8_t)((EOL_F110.F110_Byte[4u]) & 0x01u);
    return Res;
}

/**BYTE5*/


uint8_t Val_EOL_F110_TPMS(void)
{
    uint8_t Res;
    Res = (uint8_t)((EOL_F110.F110_Byte[5u] >> 7u) & 0x01u);
    return Res;
}
uint8_t Val_EOL_F110_PEPS(void)
{
    uint8_t Res;
    Res = (uint8_t)((EOL_F110.F110_Byte[5u] >> 6u) & 0x01u);
    return Res;
}
uint8_t Val_EOL_F110_AC(void)
{
    uint8_t Res;
    Res = (uint8_t)((EOL_F110.F110_Byte[5u] >> 5u) & 0x01u);
    return Res;
}
uint8_t Val_EOL_F110_ACCP(void)
{
    uint8_t Res;
    Res = (uint8_t)((EOL_F110.F110_Byte[5u] >> 4u) & 0x01u);
    return Res;
}
uint8_t Val_EOL_F110_PTC(void)
{
    uint8_t Res;
    Res = (uint8_t)((EOL_F110.F110_Byte[5u] >> 3u) & 0x01u);
    return Res;
}
uint8_t Val_EOL_F110_IPTC(void)
{
    uint8_t Res;
    Res = (uint8_t)((EOL_F110.F110_Byte[5u] >> 2u) & 0x01u);
    return Res;
}
uint8_t Val_EOL_F110_ACCM(void)
{
    uint8_t Res;
    Res = (uint8_t)((EOL_F110.F110_Byte[5u] >> 1u) & 0x01u);
    return Res;
}
uint8_t Val_EOL_F110_MMI(void)
{
    uint8_t Res;
    Res = (uint8_t)((EOL_F110.F110_Byte[5u]) & 0x01u);
    return Res;
}


/**BYTE6**/

uint8_t Val_EOL_F110_PDC(void)
{
    uint8_t Res;
    Res = (uint8_t)((EOL_F110.F110_Byte[6u] >> 7u) & 0x01u);
    return Res;
}
uint8_t Val_EOL_F110_AVM(void)
{
    uint8_t Res;
    Res = (uint8_t)((EOL_F110.F110_Byte[6u] >> 6u) & 0x01u);
    return Res;
}
uint8_t Val_EOL_F110_IC(void)
{
    uint8_t Res;
    Res = (uint8_t)((EOL_F110.F110_Byte[6u] >> 5u) & 0x01u);
    
    return Res;
}
uint8_t Val_EOL_F110_NVS(void)
{
    uint8_t Res;
    Res = (uint8_t)((EOL_F110.F110_Byte[6u] >> 4u) & 0x01u);
    return Res;
}
uint8_t Val_EOL_F110_DMM(void)
{
    uint8_t Res;
    Res = (uint8_t)((EOL_F110.F110_Byte[6u] >> 3u) & 0x01u);
    return Res;
}
uint8_t Val_EOL_F110_Reserved5(void)
{
    uint8_t Res;
    Res = (uint8_t)((EOL_F110.F110_Byte[6u] >> 2u) & 0x01u);
    return Res;
}
uint8_t Val_EOL_F110_DVR(void)
{
    uint8_t Res;
    Res = (uint8_t)((EOL_F110.F110_Byte[6u] >> 1u) & 0x01u);
    return Res;
}
uint8_t Val_EOL_F110_BCM(void)
{
    uint8_t Res;
    Res = (uint8_t)(EOL_F110.F110_Byte[6u] & 0x01u);
    return Res;
}

/**BYTE7**/  

uint8_t Val_EOL_F110_DCM(void)
{
    uint8_t Res;
    Res = (uint8_t)((EOL_F110.F110_Byte[7u] >> 7u) & 0x01u);
    return Res;
}

uint8_t Val_EOL_F110_AVAS(void)
{
    uint8_t Res;
    Res = (uint8_t)((EOL_F110.F110_Byte[7u] >> 6u) & 0x01u);
    return Res;
}

uint8_t Val_EOL_F110_TBOX(void)
{
    uint8_t Res;
    Res = (uint8_t)((EOL_F110.F110_Byte[7u] >> 5u) & 0x01u);
    return Res;
}

uint8_t Val_EOL_F110_GW(void)
{
    uint8_t Res;
    Res = (uint8_t)((EOL_F110.F110_Byte[7u] >> 4u) & 0x01u);
    return Res;
}





