/**********************************************************************************************************
 * Copyright(C) 2017, HeiLongJiang TYW Co.,Ltd.
 *
 * @Filename:     	NM_Buf.h
 *
 * @Description:  	Э֡ʽ
 *
 * @Functions List:
 *
 *
 * @History:       	Version: 		  V0.0.1
					          Date:      		2018-05-17 16:54:00
                    Author: 		  myliu
                    Modification: creat
 **********************************************************************************************************/
#ifndef	__NM_BUF_H__
#define __NM_BUF_H__

/**********************************************************************************************************
 * Include
*/
#include "NM_Include.h"
//#define NM_FRAME_ID               0x18FFFA17
//#define NM_ECU_ADDR_START			0x00 //   0x18FFFA00
//#define NM_ECU_ADDR_END				0xFF //  0x18FFFA00
//#define NM_CONTROL_FRAME_BASE_ADDR  18FFFA00
#define NM_ECU_ADDR_START          0x18FFFA00
#define NM_ECU_ADDR_END             0x18FFFAFF


typedef union 
{  
	struct
	{
		uint8_t  ICU_Address0 :  8;  	//Bit    0-7 : ECU Address	
		
		uint8_t  ICU_RMR0  	 :  1;   		//Bit  Repeat Message Requestظ
		uint8_t	     :  3;		    
		uint8_t  ICU_AWB0  	 :  1;		//Active Wakeup Bitλ                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   WB
		uint8_t          :  3;   
		
		uint8_t  ICU_Wakeup_reasons	:  8; 	//Bit  16-23 :ԭ
		
		uint8_t  ICU_NMSts0   :  1; 	//ʾǰNMظ״̬״̬
		uint8_t         		:  7; 
		
		uint8_t         		:  1; 
		uint8_t  ICU_Stayawake_KL15	    :  1;	  //Bit  32-63 : ICU_Stayawake_reasons   ֻԭ
		uint8_t                   	    :  4;	  //Bit  32-63 : ICU_Stayawake_reasons	
		uint8_t  ICU_Stayawake_Diag	    :  1;	  //Bit  32-63 : ICU_Stayawake_reasons
		uint8_t                   	    :  1;	  //Bit  32-63 : ICU_Stayawake_reasons
		
		uint8_t                   	    :  8;	  //Bit  32-63 : ICU_Stayawake_reasons
		uint8_t                   	    :  8;	  //Bit  32-63 : ICU_Stayawake_reasons
		uint8_t                   	    :  8;	  //Bit  32-63 : ICU_Stayawake_reasons	
	} Sig;
  
  uint8_t Msg[8];
} CANNmMsg_t;



/**********************************************************************************************************
 * Global functions
 */
/**********************************************************************************************************
 *@Function:		CanNm_Data_State
 *@Description:	/ر·.
 *@Input:		    CanNmDataType -- ·ͣ1:RX2:TX.
 *              State -- ·״̬ʹ/ֹ
 *@Output:		  none.
 *@Calls:			  none.
 *@Return:		  none.
 *@Note:			  һϽе.
 **********************************************************************************************************/
void CanNm_Data_State ( unsigned   char CanNmDataType, unsigned   char State );

/**********************************************************************************************************
 *@Function:		  CanNm_Data_Indication
 *@Description:		յģ䱣ڻػ洢
 *@Input:			    uint16_t Identifier -- ID.
 *					      unsigned   char DLC -- ݳ.
 *					      unsigned   char *Data -- .
 *@Output:			  none.
 *@Calls:			    none.
 *@Return:			  none.
 *@Note:			    none.
 **********************************************************************************************************/
void CanNm_Data_Indication ( unsigned  long Identifier, unsigned   char DLC, unsigned   char Data[] );

/**********************************************************************************************************
 *@Function:		  CanNm_Data_Request
 *@Description:		ģһȼϸߣΪ0
 *@Input:			    unsigned   char WakeupReason -- 绽ѵԭ򣬰KL15Ļ.
 *@Output:			  none.
 *@Calls:			    none.
 *@Return:			  none.
 *@Note:			    none.
 **********************************************************************************************************/
void CanNm_Data_Request ( NM_Wakeup_Reasons_t WakeupReason, Network_Request_Reasons_t StayawakeReson );

/**********************************************************************************************************
 *@Function:		CanNm_Data_Confirm
 *@Description:	ʾѾɹ·ģһ·.
 *@Input:		    uint16_t Identifier -- ID.
 *              unsigned   char TransferStatus -- ķ״̬orδ
 *@Output:		  none.
 *@Calls:			  none.
 *@Return:		  none..
 *@Note:			  none.
 **********************************************************************************************************/
void CanNm_Data_Confirm ( unsigned  long Identifier, unsigned   char TransferStatus );

#endif
