#include "LED_Driver.h"
#include "GPIO.h"
#include "Include.h"

/*如果条件允许将u8LEDDriverRamData定义在休眠唤醒后不会被清空的RAM区域*/
LED_Driver_uint8_t u8LEDDriverRamData[LED_DRIVER_RAM_LEN];
INT8U LedDriveCheck_Timer;
const LED_Driver_uint8_t u8AW21036ChipAddress[LED_DRIVER_CHIP_NUM] = {
#if (LED_DRIVER_CHIP_NUM >= 1U)
	AW21036_CHIP1_ADDRESS,
#endif
#if (LED_DRIVER_CHIP_NUM >= 2U)
	AW21036_CHIP2_ADDRESS,
#endif
#if (LED_DRIVER_CHIP_NUM >= 3U)
	AW21036_CHIP3_ADDRESS,
#endif
#if (LED_DRIVER_CHIP_NUM >= 4U)
	AW21036_CHIP4_ADDRESS,
#endif
};
const LED_Driver_uint8_t u8IS31ChipAddress[LED_DRIVER_CHIP_NUM] = {
#if (LED_DRIVER_CHIP_NUM >= 1U)
	IS31_CHIP1_ADDRESS,
#endif
#if (LED_DRIVER_CHIP_NUM >= 2U)
	IS31_CHIP2_ADDRESS,
#endif
#if (LED_DRIVER_CHIP_NUM >= 3U)
	IS31_CHIP3_ADDRESS,
#endif
#if (LED_DRIVER_CHIP_NUM >= 4U)
	IS31_CHIP4_ADDRESS,
#endif
};
/*设置shutdown引脚*/
void LED_Driver_Shutdown_Pin_Set(LED_Driver_uint8_t u8Level)
{
	SDB_LED_DRIVER = u8Level;
}
/****************初始化函数调用示例*************/
void LED_Driver_Init_Example(void)
{
	LED_Driver_Par_st_t stLEDDriverParInit;
	/*芯片数量*/
	stLEDDriverParInit.u8LEDDriverChipNum = LED_DRIVER_CHIP_NUM;
	/*shutdown 引脚控制函数*/
	stLEDDriverParInit.pfnLEDDriverShutdownPinSetCallBack = LED_Driver_Shutdown_Pin_Set;
	/*喂狗函数*/
	stLEDDriverParInit.pfnLEDDriverFeedDogCallBack = WDT_Reset_Service; /*根据项目需调整*/
	/*10us 延时函数*/
	stLEDDriverParInit.pfnLEDDriverDelay10usCallBack = Delay_10US; /*根据项目需调整*/
	/*3236芯片地址数组*/
	stLEDDriverParInit.pu8IS31ChipAddress = u8IS31ChipAddress;
	/*21036芯片地址数组*/
	stLEDDriverParInit.pu8AW21036ChipAddress = u8AW21036ChipAddress;
	stLEDDriverParInit.u8LEDDriverOpenThreshold = 0;
	stLEDDriverParInit.u8LEDDriverShortThreshold = 0;
	LED_Driver_Init_KL30(u8LEDDriverRamData, &stLEDDriverParInit);
	/*唤醒初始化同样*/
}

void LED_Driver_WorkCheck( void )
{
	if(LedDriveCheck_Timer < 10)
	{
		LedDriveCheck_Timer++ ;	
	}
	else
	{
		LED_Driver_Work_Check();
		LedDriveCheck_Timer = 0 ;		
	}
}