#ifndef CAN_CH0_CAN_COMMUNICATION_MATRIX_H_
#define CAN_CH0_CAN_COMMUNICATION_MATRIX_H_

#include "TYW_stdint.h"
#include "CAN_Lib.h"
extern uint8_t Get_Airbag_Fault;
extern st_CanMsgOp CAN_CH0_CanMsgOp;

extern st_CanMsgTxOp CAN_CH0_CanMsgTxOp;
#define CAN_MSG_LOST     0x55
#define CAN_CH0 &CAN_CH0_CanMsgOp
typedef enum
{
    CAN_CH0_ID_BCM_light_Msg_Count,
    CAN_CH0_ID_ABS_EBS_EBC1_Msg_Count,
    CAN_CH0_ID_TPMS_TireInfor_Msg_Count,
    CAN_CH0_ID_BCM_DoorControl2_Msg_Count,
    //CAN_CH0_ID_FCS_FLI2_Msg_Count,
    //CAN_CH0_ID_EMS_OI_Msg_Count,
    CAN_CH0_ID_EPB_StsInfor_Msg_Count,
    CAN_CH0_ID_DMM_StsInfor_Msg_Count,
    CAN_CH0_ID_TBOX_TD_Msg_Count,
    //CAN_CH0_ID_IC_TCO1_Msg_Count,

    //CAN_CH0_ID_IC_VDHR_Msg_Count,
    //CAN_CH0_ID_IC_TCO_Msg_Count,
    //CAN_CH0_ID_IC_StatusInfor2_Msg_Count,
    //CAN_CH0_ID_IC_NWM_Msg_Count,
    //CAN_CH0_ID_IC_TD_Msg_Count,
    //CAN_CH0_ID_IC_StatusInfor_Msg_Count,
    //CAN_CH0_ID_IC_SettingInfomation_Msg_Count,
    //CAN_CH0_ID_IC_TPMS_Manual_Learn_Req_Msg_Count,
    //CAN_CH0_ID_IC_DD_Msg_Count,
    //CAN_CH0_ID_FCS_FLI1_Msg_Count,

    CAN_CH0_ID_PDC_Status_Msg_Count,
    //CAN_CH0_ID_IC_AIR1_Msg_Count,
    //CAN_CH0_ID_FCS_AEBS1_Msg_Count,
    CAN_CH0_ID_BCM_StateUpdate_Msg_Count,
    CAN_CH0_ID_TPMS_ManualLearnResp_Msg_Count,
    CAN_CH0_ID_T_BOX_OTAStatus_Msg_Count,
    CAN_CH0_ID_TBOX_HeartBeatMsg_Msg_Count,
    CAN_CH0_ID_PMS_CFAB127_Msg_Count,
    CAN_CH0_ID_EMS_18FA40F4_Msg_Count,
    CAN_CH0_ID_PMS_18FAB027_Msg_Count,

    CAN_CH0_ID_EMS_18FA92D0_Msg_Count,
    /*CAN_CH0_ID_HMS_18FA6489_Msg_Count,
    CAN_CH0_ID_HMS_18FA6389_Msg_Count,
    CAN_CH0_ID_IC_18FEE6EE_Msg_Count,*/
    CAN_CH0_ID_AC_18FF2319_Msg_Count,
    CAN_CH0_ID_PMS_18FAB227_Msg_Count,
    //CAN_CH0_ID_IC_18FEC117_Msg_Count,
    CAN_CH0_ID_PMS_18FAB327_Msg_Count,
    CAN_CH0_ID_BMS_18FA48F4_Msg_Count,
    CAN_CH0_ID_PMS_0CFAA627_Msg_Count,

    //CAN_CH0_ID_FCS_18FACA2A_Msg_Count,
    CAN_CH0_ID_TBOX_18FF629F_Msg_Count,
    CAN_CH0_ID_PMS_18FAA027_Msg_Count,
    //CAN_CH0_ID_HFCU_18FA60D5_Msg_Count,
    CAN_CH0_ID_BMS_18FA4AF4_Msg_Count,
    //CAN_CH0_ID_FCS_18FACAE8_Msg_Count,
    CAN_CH0_ID_PSPS_18FF0BDF_Msg_Count,
    CAN_CH0_ID_BMS_18FA42F4_Msg_Count,
    CAN_CH0_ID_EPB_0CFABF8F_Msg_Count,
    CAN_CH0_ID_BMS_18FA3EF4_Msg_Count,

    CAN_CH0_ID_ACU_18FAC490_Msg_Count,
    CAN_CH0_ID_PMS_18FAAE27_Msg_Count,
    CAN_CH0_ID_EGSM_0C012705_Msg_Count,
    CAN_CH0_ID_BMS_18FA41F4_Msg_Count,
    //CAN_CH0_ID_MMI_18FF4A41_Msg_Count,
    CAN_CH0_ID_MCU_18FA02EF_Msg_Count,
    //CAN_CH0_ID_HFCU_18FA63D5_Msg_Count,
    CAN_CH0_ID_PMS_18FA98D0_Msg_Count,
    CAN_CH0_ID_TCU_0CFFB303_Msg_Count,
    CAN_CH0_ID_PMS_18FA1727_Msg_Count,

    //CAN_CH0_ID_TBOX_18FF649F_Msg_Count,
    //CAN_CH0_ID_MMI_18FF5241_Msg_Count,
    //CAN_CH0_ID_MMI_18FF5141_Msg_Count,
    CAN_CH0_ID_BMS_18FC03F4_Msg_Count,
    CAN_CH0_ID_PMS_18FF5F27_Msg_Count,
    CAN_CH0_ID_PMS_18FAA527_Msg_Count,
    //CAN_CH0_ID_PFCU_0CFA90D0_Msg_Count,
    CAN_CH0_ID_AVAS_18FFC095_Msg_Count,
    CAN_CH0_ID_MMI_18FF4C41_Msg_Count,
    //CAN_CH0_ID_TCU_18FFB403_Msg_Count,

    CAN_CH0_ID_PMS_18FF5D27_Msg_Count,
    CAN_CH0_ID_EPS_0CFABA13_Msg_Count,
    CAN_CH0_ID_ESC_18FE4F0B_Msg_Count,
    //CAN_CH0_ID_FCS_18FECAE8_Msg_Count,

    CAN_CH0_ID_TOTAL_MAX,
} CAN_CH0_CAN_MSG_ID_t;

typedef enum
{
    IC_0CFE6C17_Msg_Count,
    IC_18FF4017_Msg_Count,
    IC_18FF4117_Msg_Count,
    IC_18FEC117_Msg_Count,
    IC_18FF6F17_Msg_Count,
    IC_18FEE617_Msg_Count,
    CAN_CH0_ID_SEND_TOTAL,
} CAN_CH0_CAN_MSG_SEND_ID_t;

extern const st_CANMsgAttribute CAN_CH0_CAN_MSG_CONST_ARRAY[CAN_CH0_ID_TOTAL_MAX] ;
extern const st_CAN_SendAttribute    CAN_CH0_CANSendAttr[CAN_CH0_ID_SEND_TOTAL] ;

#define  CAN_CH0_ID_BCM_light_Msg                   0x18FE4021ul
#define  CAN_CH0_ID_ABS_EBS_EBC1_Msg                0x18F0010Bul
#define  CAN_CH0_ID_TPMS_TireInfor_Msg              0x18FFE033ul
#define  CAN_CH0_ID_BCM_DoorControl2_Msg            0x18FDA521ul
//#define  CAN_CH0_ID_FCS_FLI2_Msg                    0x18FE5BE8ul
//#define  CAN_CH0_ID_EMS_OI_Msg                      0x18FEFF00ul
#define  CAN_CH0_ID_EPB_StsInfor_Msg                0x18FFB88Ful
#define  CAN_CH0_ID_DMM_StsInfor_Msg                0x18FAD084ul
#define  CAN_CH0_ID_TBOX_TD_Msg                     0x18FEE69Ful
//#define  CAN_CH0_ID_IC_TCO1_Msg                     0x0CFE6CEEul

//#define  CAN_CH0_ID_IC_VDHR_Msg                     0x18FEC1EEul
//#define  CAN_CH0_ID_IC_TCO_Msg                      0x0CFE6C17ul
//#define  CAN_CH0_ID_IC_StatusInfor2_Msg             0x18FF4117ul
//#define  CAN_CH0_ID_IC_NWM_Msg                      0x18FFFA17ul
//#define  CAN_CH0_ID_IC_TD_Msg                       0x18FEE617ul
//#define  CAN_CH0_ID_IC_StatusInfor_Msg              0x18FF4017ul
//#define  CAN_CH0_ID_IC_SettingInfomation_Msg        0x18FF4217ul
//#define  CAN_CH0_ID_IC_TPMS_Manual_Learn_Req_Msg    0x18FF6F17ul
//#define  CAN_CH0_ID_IC_DD_Msg                       0x18FEFC17ul
//#define  CAN_CH0_ID_FCS_FLI1_Msg                    0x10F007E8ul

#define  CAN_CH0_ID_PDC_Status_Msg                  0x0CFF1ADAul
//#define  CAN_CH0_ID_IC_AIR1_Msg                     0x18FEAE30ul
//#define  CAN_CH0_ID_FCS_AEBS1_Msg                   0x0CF02FA0ul
#define  CAN_CH0_ID_BCM_StateUpdate_Msg             0x18FFDD21ul
#define  CAN_CH0_ID_TPMS_ManualLearnResp_Msg        0x18FFE133ul
#define  CAN_CH0_ID_T_BOX_OTAStatus_Msg             0x18FF639Ful
#define  CAN_CH0_ID_TBOX_HeartBeatMsg_Msg           0x18FF789Ful
#define  CAN_CH0_ID_PMS_CFAB127_Msg                 0x0CFAB127ul
#define  CAN_CH0_ID_EMS_18FA40F4_Msg                0x18FA40F4ul
#define  CAN_CH0_ID_PMS_18FAB027_Msg                0x18FAB027ul

#define  CAN_CH0_ID_EMS_18FA92D0_Msg                0x18FA92D0ul
/*#define  CAN_CH0_ID_HMS_18FA6489_Msg                0x18FA6489ul
#define  CAN_CH0_ID_HMS_18FA6389_Msg                0x18FA6389ul
#define  CAN_CH0_ID_IC_18FEE6EE_Msg                 0x18FEE6EEul*/
#define  CAN_CH0_ID_AC_18FF2319_Msg                 0x18FF2319ul
#define  CAN_CH0_ID_PMS_18FAB227_Msg                0x18FAB227ul
//#define  CAN_CH0_ID_IC_18FEC117_Msg                 0x18FEC117ul
#define  CAN_CH0_ID_PMS_18FAB327_Msg                0x18FAB327ul
#define  CAN_CH0_ID_BMS_18FA48F4_Msg                0x18FA48F4ul
#define  CAN_CH0_ID_PMS_0CFAA627_Msg                0x0CFAA627ul

//#define  CAN_CH0_ID_FCS_18FACA2A_Msg                0x18FACA2Aul
#define  CAN_CH0_ID_TBOX_18FF629F_Msg               0x18FF629Ful
#define  CAN_CH0_ID_PMS_18FAA027_Msg                0x18FAA027ul
//#define  CAN_CH0_ID_HFCU_18FA60D5_Msg               0x18FA60D5ul
#define  CAN_CH0_ID_BMS_18FA4AF4_Msg                0x18FA4AF4ul
//#define  CAN_CH0_ID_FCS_18FACAE8_Msg                0x18FACAE8ul
#define  CAN_CH0_ID_PSPS_18FF0BDF_Msg               0x18FF0BDFul
#define  CAN_CH0_ID_BMS_18FA42F4_Msg                0x18FA42F4ul
#define  CAN_CH0_ID_EPB_0CFABF8F_Msg                0x0CFABF8Ful
#define  CAN_CH0_ID_BMS_18FA3EF4_Msg                0x18FA3EF4ul

#define  CAN_CH0_ID_ACU_18FAC490_Msg                0x18FAC490ul
#define  CAN_CH0_ID_PMS_18FAAE27_Msg                0x18FAAE27ul
#define  CAN_CH0_ID_EGSM_0C012705_Msg               0x0C012705ul
#define  CAN_CH0_ID_BMS_18FA41F4_Msg                0x18FA41F4ul
//#define  CAN_CH0_ID_MMI_18FF4A41_Msg                0x18FF4A41ul
#define  CAN_CH0_ID_MCU_18FA02EF_Msg                0x18FA02EFul
//#define  CAN_CH0_ID_HFCU_18FA63D5_Msg               0x18FA63D5ul
#define  CAN_CH0_ID_PMS_18FA98D0_Msg                0x18FA98D0ul
#define  CAN_CH0_ID_TCU_0CFFB303_Msg                0x0CFFB303ul
#define  CAN_CH0_ID_PMS_18FA1727_Msg                0x18FA1727ul

//#define  CAN_CH0_ID_TBOX_18FF649F_Msg               0x18FF649Ful
//#define  CAN_CH0_ID_MMI_18FF5241_Msg                0x18FF5241ul
//#define  CAN_CH0_ID_MMI_18FF5141_Msg                0x18FF5141ul
#define  CAN_CH0_ID_BMS_18FC03F4_Msg                0x18FC03F4ul
#define  CAN_CH0_ID_PMS_18FF5F27_Msg                0x18FF5F27ul
#define  CAN_CH0_ID_PMS_18FAA527_Msg                0x18FAA527ul
//#define  CAN_CH0_ID_PFCU_0CFA90D0_Msg               0x0CFA90D0ul
#define  CAN_CH0_ID_AVAS_18FFC095_Msg               0x18FFC095ul
#define  CAN_CH0_ID_MMI_18FF4C41_Msg                0x18FF4C41ul
//#define  CAN_CH0_ID_TCU_18FFB403_Msg                0x18FFB403ul

#define  CAN_CH0_ID_PMS_18FF5D27_Msg                0x18FF5D27ul
#define  CAN_CH0_ID_EPS_0CFABA13_Msg                0x0CFABA13ul
#define  CAN_CH0_ID_ESC_18FE4F0B_Msg                0x18FE4F0Bul
//#define  CAN_CH0_ID_FCS_18FECAE8_Msg                0x18FECAE8ul

extern uint8_t  Get_CAN_CH0_ID_18FE4021_Sig_BCM_LightLeftOn(void);
extern uint8_t  Get_CAN_CH0_ID_18FE4021_Sig_BCM_RearFogLights(void);
extern uint8_t  Get_CAN_CH0_ID_18FE4021_Sig_BCM_TractorMarkerLight(void);
extern uint8_t  Get_CAN_CH0_ID_18FE4021_Sig_BCM_LeftStopLight(void);
extern uint8_t  Get_CAN_CH0_ID_18FE4021_Sig_BCM_RightStopLight(void);
extern uint8_t  Get_CAN_CH0_ID_18FE4021_Sig_BCM_CenterStopLight(void);
extern uint8_t  Get_CAN_CH0_ID_18FE4021_Sig_BCM_BackUpLightAndAlarmHorn(void);
extern uint8_t  Get_CAN_CH0_ID_18FE4021_Sig_BCM_LeftTurnSignalLights(void);
extern uint8_t  Get_CAN_CH0_ID_18FE4021_Sig_BCM_RightTurnSignalLights(void);
extern uint8_t  Get_CAN_CH0_ID_18FE4021_Sig_BCM_TractorFrontFogLights(void);
extern uint8_t  Get_CAN_CH0_ID_18FE4021_Sig_BCM_HighBeamHeadLightData(void);
extern uint8_t  Get_CAN_CH0_ID_18FE4021_Sig_BCM_LowBeamHeadLightData(void);
extern uint8_t  Get_CAN_CH0_ID_18FE4021_Sig_BCM_AlternateBeamHeadLightData(void);
extern uint8_t  Get_CAN_CH0_ID_18FE4021_Sig_BCM_RunningLight(void);
extern uint8_t  Get_CAN_CH0_ID_18F0010B_Sig_EBS_EBSRedWarningState(void);
extern uint8_t  Get_CAN_CH0_ID_18F0010B_Sig_EBS_ASR_Off_RoadSwitch(void);
extern uint8_t  Get_CAN_CH0_ID_18F0010B_Sig_EBS_TractionControlOverrideSwitch(void);
extern uint8_t  Get_CAN_CH0_ID_18F0010B_Sig_EBS_ATC_ASRLampState(void);
extern uint8_t  Get_CAN_CH0_ID_18F0010B_Sig_EBS_ABS_AmberWarningState(void);
extern uint8_t  Get_CAN_CH0_ID_18F0010B_Sig_EBS_ASRBrakeControlActive(void);
extern uint8_t  Get_CAN_CH0_ID_18F0010B_Sig_EBS_ASREngineControlActive(void);
extern uint8_t  Get_CAN_CH0_ID_18FFE033_Sig_TPMS_TirePreSts(void);
extern uint8_t  Get_CAN_CH0_ID_18FFE033_Sig_TPMS_ECUSts(void);
extern uint8_t  Get_CAN_CH0_ID_18FFE033_Sig_TPMS_TireLockSts(void);
extern uint8_t  Get_CAN_CH0_ID_18FFE033_Sig_TPMS_BatterySts(void);
extern uint8_t  Get_CAN_CH0_ID_18FFE033_Sig_TPMS_TempSts(void);
extern uint8_t  Get_CAN_CH0_ID_18FFE033_Sig_TPMS_SystemFault(void);
extern uint8_t  Get_CAN_CH0_ID_18FFE033_Sig_TPMS_FastPrLossSts(void);
extern uint8_t  Get_CAN_CH0_ID_18FFE033_Sig_TPMS_SensorFaultSts(void);
extern uint8_t  Get_CAN_CH0_ID_18FFE033_Sig_TPMS_SingallMissingSts(void);
extern uint8_t  Get_CAN_CH0_ID_18FFE033_Sig_TPMS_TireTemp(void);
extern uint16_t Get_CAN_CH0_ID_18FFE033_Sig_TPMS_TirePressure(void);
extern uint8_t  Get_CAN_CH0_ID_18FFE033_Sig_TPMS_Wheel_location_ID(void);
extern uint8_t  Get_CAN_CH0_ID_18FDA521_Sig_BCM_RearRightDoorAjarStatus(void);
extern uint8_t  Get_CAN_CH0_ID_18FDA521_Sig_BCM_RearLeftDoorAjarStatus(void);
extern uint8_t  Get_CAN_CH0_ID_18FDA521_Sig_BCM_FrontRightDoorAjarStatus(void);
extern uint8_t  Get_CAN_CH0_ID_18FDA521_Sig_BCM_FrontLeftDoorAjarStatus(void);
/*extern uint8_t  Get_CAN_CH0_ID_18FE5BE8_Sig_FCS_LDWEnableStatus(void);
extern uint8_t  Get_CAN_CH0_ID_18FE5BE8_Sig_FCS_LDWCameraStatus(void);
extern uint8_t  Get_CAN_CH0_ID_18FE5BE8_Sig_FCS_LaneTrackingStatusLeftSide(void);
extern uint8_t  Get_CAN_CH0_ID_18FE5BE8_Sig_FCS_LaneTrackingStatusRightSide(void);
extern uint8_t  Get_CAN_CH0_ID_18FE5BE8_Sig_FCS_LDWSystemState(void);*/
/*extern uint8_t  Get_CAN_CH0_ID_18FEFF00_Sig_EMS_DWarnSysIndicatorSts(void);
extern uint8_t  Get_CAN_CH0_ID_18FEFF00_Sig_EMS_ECSOpInSeverity(void);
extern uint8_t  Get_CAN_CH0_ID_18FEFF00_Sig_EMS_WaterInFuelIndicator(void);*/
extern uint8_t  Get_CAN_CH0_ID_18FFB88F_Sig_EPB_SafeBeltNotTiedLmtReleaseWarning(void);
extern uint8_t  Get_CAN_CH0_ID_18FFB88F_Sig_EPB_FltLevel(void);
extern uint8_t  Get_CAN_CH0_ID_18FFB88F_Sig_EPB_LowPreReleaseParkLimit(void);
extern uint8_t  Get_CAN_CH0_ID_18FFB88F_Sig_EPB_ChildLockActive(void);
extern uint8_t  Get_CAN_CH0_ID_18FFB88F_Sig_EPB_TemParkActive(void);
extern uint8_t  Get_CAN_CH0_ID_18FFB88F_Sig_EPB_TemParkBrakeSts(void);
extern uint8_t  Get_CAN_CH0_ID_18FFB88F_Sig_EPB_ParkBrakeSts(void);
extern uint8_t  Get_CAN_CH0_ID_18FAD084_Sig_DMM_CheckSum(void);
extern uint8_t  Get_CAN_CH0_ID_18FAD084_Sig_DMM_AliveCounter(void);
extern uint8_t  Get_CAN_CH0_ID_18FAD084_Sig_DMM_Occlusion_Alarm(void);
extern uint8_t  Get_CAN_CH0_ID_18FAD084_Sig_DMM_UnsafeAct_Warning_Status(void);
extern uint8_t  Get_CAN_CH0_ID_18FAD084_Sig_DMM_Fatigue_Warning_Status(void);
extern uint8_t  Get_CAN_CH0_ID_18FAD084_Sig_DMM_SystemFault(void);
extern uint8_t  Get_CAN_CH0_ID_18FAD084_Sig_DMM_WorkSts(void);
extern uint8_t  Get_CAN_CH0_ID_18FEE69F_Sig_TBOX_Year(void);
extern uint8_t  Get_CAN_CH0_ID_18FEE69F_Sig_TBOX_Day(void);
extern uint8_t  Get_CAN_CH0_ID_18FEE69F_Sig_TBOX_Month(void);
extern uint8_t  Get_CAN_CH0_ID_18FEE69F_Sig_TBOX_Hour(void);
extern uint8_t  Get_CAN_CH0_ID_18FEE69F_Sig_TBOX_Minute(void);
extern uint8_t  Get_CAN_CH0_ID_18FEE69F_Sig_TBOX_Second(void);
/*extern uint16_t Get_CAN_CH0_ID_0CFE6CEE_Sig_IC_TachographOutputShaftSpeed(void);
extern uint16_t Get_CAN_CH0_ID_0CFE6CEE_Sig_IC_TachographVehicleSpeed(void);
extern uint32_t Get_CAN_CH0_ID_18FEC1EE_Sig_IC_TripDistance(void);
extern uint32_t Get_CAN_CH0_ID_18FEC1EE_Sig_IC_TotalVehicleDistance(void);
extern uint16_t Get_CAN_CH0_ID_0CFE6C17_Sig_IC_TachographVehicleSpeed(void);
extern uint8_t  Get_CAN_CH0_ID_18FF4117_Sig_IC_OTA_DeclimerSelected(void);
extern uint8_t  Get_CAN_CH0_ID_18FF4117_Sig_IC_OTA_UpdateResultConfirm(void);
extern uint8_t  Get_CAN_CH0_ID_18FF4117_Sig_IC_OTA_UpdateSelected(void);
extern uint8_t  Get_CAN_CH0_ID_18FF4117_Sig_IC_OTA_DownloadSelected(void);
extern uint8_t  Get_CAN_CH0_ID_18FF4117_Sig_IC_OTA_InfoShowStatus(void);
extern uint8_t  Get_CAN_CH0_ID_18FF4117_Sig_IC_DriveCabReverseSW(void);
extern uint8_t  Get_CAN_CH0_ID_18FF4117_Sig_IC_ResetAverageFuelConsumption(void);
extern uint8_t  Get_CAN_CH0_ID_18FF4117_Sig_IC_ResetAveragePowerConsumption(void);
extern uint8_t  Get_CAN_CH0_ID_18FF4117_Sig_IC_Backlightadjust(void);
extern uint8_t  Get_CAN_CH0_ID_18FF4117_Sig_IC_BrakeShoeWearWarn(void);
extern uint32_t Get_CAN_CH0_ID_18FFFA17_Sig_IC_Stayawake_reasons(void);
extern uint8_t  Get_CAN_CH0_ID_18FFFA17_Sig_IC_NMSts(void);
extern uint8_t  Get_CAN_CH0_ID_18FFFA17_Sig_IC_Wakeup_reasons(void);
extern uint8_t  Get_CAN_CH0_ID_18FFFA17_Sig_IC_AWB(void);
extern uint8_t  Get_CAN_CH0_ID_18FFFA17_Sig_IC_RMR(void);
extern uint8_t  Get_CAN_CH0_ID_18FFFA17_Sig_IC_Address(void);
extern uint8_t  Get_CAN_CH0_ID_18FEE617_Sig_IC_Year(void);
extern uint8_t  Get_CAN_CH0_ID_18FEE617_Sig_IC_Day(void);
extern uint8_t  Get_CAN_CH0_ID_18FEE617_Sig_IC_Month(void);
extern uint8_t  Get_CAN_CH0_ID_18FEE617_Sig_IC_Hour(void);
extern uint8_t  Get_CAN_CH0_ID_18FEE617_Sig_IC_Minute(void);
extern uint8_t  Get_CAN_CH0_ID_18FEE617_Sig_IC_Second(void);
extern uint8_t  Get_CAN_CH0_ID_18FF4017_Sig_IC_BrakeFuleLowWarn(void);
extern uint8_t  Get_CAN_CH0_ID_18FF4017_Sig_IC_PassSeatMidPosbeltWarning(void);
extern uint8_t  Get_CAN_CH0_ID_18FF4017_Sig_IC_AirbagUnitLEDSts(void);
extern uint8_t  Get_CAN_CH0_ID_18FF4017_Sig_IC_FuelLevelStsInvalid(void);
extern uint8_t  Get_CAN_CH0_ID_18FF4017_Sig_IC_FuelSensorOCFault(void);
extern uint8_t  Get_CAN_CH0_ID_18FF4017_Sig_IC_FuelSensorSTGFault(void);
extern uint8_t  Get_CAN_CH0_ID_18FF4017_Sig_IC_RearAirTankPressure(void);
extern uint8_t  Get_CAN_CH0_ID_18FF4017_Sig_IC_FrontAirTankPressure(void);
extern uint8_t  Get_CAN_CH0_ID_18FF4017_Sig_IC_PassSeatbeltWarning(void);
extern uint8_t  Get_CAN_CH0_ID_18FF4017_Sig_IC_DrvSeatbeltBucklestatus(void);
extern uint8_t  Get_CAN_CH0_ID_18FF4017_Sig_IC_FuelLevelLowWarn(void);
extern uint8_t  Get_CAN_CH0_ID_18FF4017_Sig_IC_LanguageMode(void);
extern uint8_t  Get_CAN_CH0_ID_18FF4017_Sig_IC_MaintanceWarningSts(void);
extern uint16_t Get_CAN_CH0_ID_18FF4017_Sig_IC_ServiceMaintainInterval(void);
extern uint8_t  Get_CAN_CH0_ID_18FF4017_Sig_IC_AverageVehSpd(void);
extern uint8_t  Get_CAN_CH0_ID_18FF4017_Sig_IC_FuelLevelSts(void);
extern uint8_t  Get_CAN_CH0_ID_18FF4217_Sig_IC_PFCU_IdleTypeSet(void);
extern uint8_t  Get_CAN_CH0_ID_18FF6F17_Sig_IC_Manual_LearnSet(void);
extern uint8_t  Get_CAN_CH0_ID_18FF6F17_Sig_IC_Manual_LearnLocation(void);
extern uint8_t  Get_CAN_CH0_ID_18FEFC17_Sig_IC_FuelLevel1(void);
extern uint8_t  Get_CAN_CH0_ID_10F007E8_Sig_FCS_LaneDepartureLeftSide(void);
extern uint8_t  Get_CAN_CH0_ID_10F007E8_Sig_FCS_LaneDepartureRightSide(void);*/
extern uint8_t  Get_CAN_CH0_ID_0CFF1ADA_Sig_PDC_Warning_Frq(void);
extern uint8_t  Get_CAN_CH0_ID_0CFF1ADA_Sig_PDC_Distance_RR(void);
extern uint8_t  Get_CAN_CH0_ID_0CFF1ADA_Sig_PDC_Distance_RCR(void);
extern uint8_t  Get_CAN_CH0_ID_0CFF1ADA_Sig_PDC_Distance_RCL(void);
extern uint8_t  Get_CAN_CH0_ID_0CFF1ADA_Sig_PDC_SystemState(void);
extern uint8_t  Get_CAN_CH0_ID_0CFF1ADA_Sig_PDC_VirtualDisplaySts(void);
extern uint8_t  Get_CAN_CH0_ID_0CFF1ADA_Sig_PDC_Distance_RL(void);
//extern uint8_t  Get_CAN_CH0_ID_18FEAE30_Sig_IC_ServiceBrakeCircuit2AirPre(void);
//extern uint8_t  Get_CAN_CH0_ID_18FEAE30_Sig_IC_ServiceBrakeCircuit1AirPre(void);
/*extern uint8_t  Get_CAN_CH0_ID_0CF02FA0_Sig_FCS_CollisionWarningLevel(void);
extern uint8_t  Get_CAN_CH0_ID_0CF02FA0_Sig_FCS_AEBState(void);*/
extern uint8_t  Get_CAN_CH0_ID_18FFDD21_Sig_BCM_TankFlapSts(void);
extern uint8_t  Get_CAN_CH0_ID_18FFDD21_Sig_BCM_FuLidNotClsd(void);
extern uint8_t  Get_CAN_CH0_ID_18FFDD21_Sig_BCM_KeyInwithDrvDoorAjar(void);
extern uint8_t  Get_CAN_CH0_ID_18FFE133_Sig_TPMS_Manual_LearnSts(void);
extern uint8_t  Get_CAN_CH0_ID_18FFE133_Sig_TPMS_Manual_LearnLocation(void);
extern uint8_t  Get_CAN_CH0_ID_18FF639F_Sig_TBOX_OTA_DisclaimerWarning(void);
extern uint8_t  Get_CAN_CH0_ID_18FF639F_Sig_TBOX_OTA_PreConditionDetect(void);
extern uint8_t  Get_CAN_CH0_ID_18FF639F_Sig_TBOX_OTA_FailedReason_HVStatus(void);
extern uint8_t  Get_CAN_CH0_ID_18FF639F_Sig_TBOX_OTA_FailedReason_ChgStatus(void);
extern uint8_t  Get_CAN_CH0_ID_18FF639F_Sig_TBOX_OTA_FailedReason_HandBrake(void);
extern uint8_t  Get_CAN_CH0_ID_18FF639F_Sig_TBOX_OTA_FailedReason_BattVo(void);
extern uint8_t  Get_CAN_CH0_ID_18FF639F_Sig_TBOX_OTA_FailedReason_VehicleSpd(void);
extern uint8_t  Get_CAN_CH0_ID_18FF639F_Sig_TBOX_OTA_FailedReason_GearPos(void);
extern uint8_t  Get_CAN_CH0_ID_18FF639F_Sig_TBOX_OTA_FailedReason_PowerMode(void);
extern uint8_t  Get_CAN_CH0_ID_18FF639F_Sig_TBOX_OTA_DownloadProgress(void);
extern uint8_t  Get_CAN_CH0_ID_18FF639F_Sig_TBOX_OTA_Mode(void);
extern uint8_t  Get_CAN_CH0_ID_18FF639F_Sig_TBOX_OTA_UpdateState(void);
extern uint8_t  Get_CAN_CH0_ID_18FF639F_Sig_TBOX_OTA_UpdateRequest(void);
extern uint8_t  Get_CAN_CH0_ID_18FF639F_Sig_TBOX_OTA_DownloadState(void);
extern uint8_t  Get_CAN_CH0_ID_18FF639F_Sig_TBOX_OTA_DownloadRequest(void);
extern uint8_t  Get_CAN_CH0_ID_18FF789F_Sig_TBOX_LineDiscntSts(void);
extern uint8_t  Get_CAN_CH0_ID_0CFAB127_Sig_PMS_EnergyModeIndication(void);
extern uint8_t  Get_CAN_CH0_ID_0CFAB127_Sig_PMS_VehicleSpd_flag(void);
extern uint8_t  Get_CAN_CH0_ID_0CFAB127_Sig_PMS_ePTRegencyLevInd(void);
extern uint16_t Get_CAN_CH0_ID_0CFAB127_Sig_PMS_VehicleSpd(void);
extern uint8_t  Get_CAN_CH0_ID_0CFAB127_Sig_PMS_SDCACStopFault(void);
extern uint8_t  Get_CAN_CH0_ID_0CFAB127_Sig_PMS_DriverOperationReminder(void);
extern uint8_t  Get_CAN_CH0_ID_18FA40F4_Sig_BMS_FaultLevel(void);
extern uint8_t  Get_CAN_CH0_ID_18FA40F4_Sig_BMS_BattSOC(void);
extern uint16_t Get_CAN_CH0_ID_18FA40F4_Sig_BMS_BattCurr(void);
extern uint16_t Get_CAN_CH0_ID_18FA40F4_Sig_BMS_BattVol(void);
extern uint8_t  Get_CAN_CH0_ID_18FAB027_Sig_PMS_BrkSysErr(void);
extern uint8_t  Get_CAN_CH0_ID_18FAB027_Sig_PMS_VehicleSlipWarning(void);
extern uint8_t  Get_CAN_CH0_ID_18FAB027_Sig_PMS_HandbrakeSts(void);
extern uint8_t  Get_CAN_CH0_ID_18FAB027_Sig_PMS_GearPositionInd(void);
extern uint16_t Get_CAN_CH0_ID_18FAB027_Sig_PMS_PTSysElecPwrInd(void);
extern uint8_t  Get_CAN_CH0_ID_18FAB027_Sig_PMS_GearOperateErr(void);
extern uint8_t  Get_CAN_CH0_ID_18FAB027_Sig_PMS_PTHVSysErrorLampStsInd(void);
extern uint8_t  Get_CAN_CH0_ID_18FAB027_Sig_PMS_DCDC_WorkSts(void);
extern uint8_t  Get_CAN_CH0_ID_18FAB027_Sig_PMS_TurtleLampReq(void);
extern uint8_t  Get_CAN_CH0_ID_18FAB027_Sig_PMS_DrivePwrCircuitInd(void);
extern uint8_t  Get_CAN_CH0_ID_18FAB027_Sig_PMS_PTReadyInd(void);
extern uint8_t  Get_CAN_CH0_ID_18FAB027_Sig_PMS_PTModeInd(void);
extern uint8_t  Get_CAN_CH0_ID_18FAB027_Sig_PMS_DriveModeInd(void);
extern uint8_t  Get_CAN_CH0_ID_18FA92D0_Sig_EMS_PresReliefReady(void);
extern uint8_t  Get_CAN_CH0_ID_18FA92D0_Sig_EMS_FTIVFault(void);
extern uint8_t  Get_CAN_CH0_ID_18FA92D0_Sig_EMS_GPFRegenerationInd(void);
extern uint8_t  Get_CAN_CH0_ID_18FA92D0_Sig_EMS_OilPressureWarning(void);
extern uint8_t  Get_CAN_CH0_ID_18FA92D0_Sig_EMS_EngineMILTelltale(void);
extern uint8_t  Get_CAN_CH0_ID_18FA92D0_Sig_EMS_EngineSVSTelltale(void);
extern uint8_t  Get_CAN_CH0_ID_18FA92D0_Sig_EMS_EngineCoolantTemperatureinvalid(void);
extern uint8_t  Get_CAN_CH0_ID_18FA92D0_Sig_EMS_EngineCoolantTemperature(void);
/*extern uint8_t  Get_CAN_CH0_ID_18FA6489_Sig_HMS_FltLevel(void);
extern uint8_t  Get_CAN_CH0_ID_18FA6489_Sig_HMS_FillStatus(void);
extern uint8_t  Get_CAN_CH0_ID_18FA6489_Sig_HMS_H2SOC(void);
extern uint8_t  Get_CAN_CH0_ID_18FA6489_Sig_HMS_ErrorCode(void);
extern uint8_t  Get_CAN_CH0_ID_18FA6489_Sig_HMS_HighPressSts(void);
extern uint16_t Get_CAN_CH0_ID_18FA6389_Sig_HMS_MaxPres(void);
extern uint8_t  Get_CAN_CH0_ID_18FEE6EE_Sig_IC_Year(void);
extern uint8_t  Get_CAN_CH0_ID_18FEE6EE_Sig_IC_Day(void);
extern uint8_t  Get_CAN_CH0_ID_18FEE6EE_Sig_IC_Month(void);
extern uint8_t  Get_CAN_CH0_ID_18FEE6EE_Sig_IC_Hour(void);
extern uint8_t  Get_CAN_CH0_ID_18FEE6EE_Sig_IC_Minute(void);
extern uint8_t  Get_CAN_CH0_ID_18FEE6EE_Sig_IC_Second(void);*/
extern uint8_t  Get_CAN_CH0_ID_18FF2319_Sig_AC_AmbientTemperature(void);
extern uint8_t  Get_CAN_CH0_ID_18FF2319_Sig_AC_AmbientTemperatureInvalid(void);
extern uint16_t Get_CAN_CH0_ID_18FAB227_Sig_PMS_FuleDTEodometer(void);
extern uint16_t Get_CAN_CH0_ID_18FAB227_Sig_PMS_EVDTE_odometer(void);
extern uint16_t Get_CAN_CH0_ID_18FAB227_Sig_PMS_AvgFuelVF(void);
extern uint16_t Get_CAN_CH0_ID_18FAB227_Sig_PMS_AvgEVConsume(void);
/*extern uint32_t Get_CAN_CH0_ID_18FEC117_Sig_IC_TotalVehicleDistance(void);
extern uint32_t Get_CAN_CH0_ID_18FEC117_Sig_IC_TripDistance(void);*/
extern uint16_t Get_CAN_CH0_ID_18FAB327_Sig_PMS_PTResiduePwrInd(void);
extern uint32_t Get_CAN_CH0_ID_18FAB327_Sig_PMS_VehCruisingDistance(void);
extern uint8_t  Get_CAN_CH0_ID_18FA48F4_Sig_BMS_IC_Temp(void);
extern uint8_t  Get_CAN_CH0_ID_18FA48F4_Sig_BMS_BattMaxTemp1(void);
extern uint8_t  Get_CAN_CH0_ID_18FA48F4_Sig_BMS_BattMinTemp1(void);
extern uint8_t  Get_CAN_CH0_ID_0CFAA627_Sig_PMS_ControlSetSpeed(void);
extern uint8_t  Get_CAN_CH0_ID_0CFAA627_Sig_PMS_CruiseControlSts(void);
/*extern uint8_t  Get_CAN_CH0_ID_18FACA2A_Sig_FCS_ALOD_TimeGap(void);
extern uint8_t  Get_CAN_CH0_ID_18FACA2A_Sig_FCS_ACC_Info(void);
extern uint8_t  Get_CAN_CH0_ID_18FACA2A_Sig_FCS_ALOD_SpeedSetDisp(void);
extern uint8_t  Get_CAN_CH0_ID_18FACA2A_Sig_FCS_ALOD_Warning(void);
extern uint8_t  Get_CAN_CH0_ID_18FACA2A_Sig_FCS_ALOD_TargetDisplay(void);
extern uint8_t  Get_CAN_CH0_ID_18FACA2A_Sig_FCS_ALOD_Status(void);*/
extern uint8_t  Get_CAN_CH0_ID_18FF629F_Sig_TBOX_BatteryVoltageLowWarning(void);
extern uint16_t Get_CAN_CH0_ID_18FF629F_Sig_TBOX_BatteryVoltage(void);
extern uint16_t Get_CAN_CH0_ID_18FAA027_Sig_PMS_ErrCode(void);
/*extern uint8_t  Get_CAN_CH0_ID_18FA60D5_Sig_HFCU_LqdSts(void);
extern uint8_t  Get_CAN_CH0_ID_18FA60D5_Sig_HFCU_FltLvl(void);
extern uint8_t  Get_CAN_CH0_ID_18FA60D5_Sig_HFCU_StsFlg(void);*/
extern uint16_t Get_CAN_CH0_ID_18FA4AF4_Sig_BMS_MaxCellVolt(void);
extern uint16_t Get_CAN_CH0_ID_18FA4AF4_Sig_BMS_MinCellVolt(void);
/*extern uint8_t  Get_CAN_CH0_ID_18FACAE8_Sig_FCS_LKAState(void);
extern uint8_t  Get_CAN_CH0_ID_18FACAE8_Sig_FCS_LKATakeoverRequest(void);
extern uint8_t  Get_CAN_CH0_ID_18FACAE8_Sig_FCS_LKAHandsOffWarning(void);*/
extern uint8_t  Get_CAN_CH0_ID_18FF0BDF_Sig_PEPS_SSB_Failure_warning(void);
extern uint8_t  Get_CAN_CH0_ID_18FF0BDF_Sig_PEPS_Warning_Keyout(void);
extern uint8_t  Get_CAN_CH0_ID_18FF0BDF_Sig_PEPS_Indication_UID_Closer(void);
extern uint8_t  Get_CAN_CH0_ID_18FF0BDF_Sig_PEPS_Warning_IMMO_Fail(void);
extern uint8_t  Get_CAN_CH0_ID_18FF0BDF_Sig_PEPS_Warn_UID_LOW_BATT(void);
extern uint8_t  Get_CAN_CH0_ID_18FF0BDF_Sig_PEPS_IGN1FailureWarning(void);
extern uint8_t  Get_CAN_CH0_ID_18FF0BDF_Sig_PEPS_Indication_shift_to_Park(void);
extern uint8_t  Get_CAN_CH0_ID_18FF0BDF_Sig_PEPS_Indication_shift_to_PN(void);
extern uint8_t  Get_CAN_CH0_ID_18FF0BDF_Sig_PEPS_Indication_press_brake_clutch(void);
extern uint8_t  Get_CAN_CH0_ID_18FF0BDF_Sig_PEPS_Warning_No_key_found(void);
extern uint8_t  Get_CAN_CH0_ID_18FF0BDF_Sig_PEPS_SystemFault(void);
extern uint8_t  Get_CAN_CH0_ID_18FA42F4_Sig_BMS_BattSOCFault(void);
extern uint8_t  Get_CAN_CH0_ID_18FA42F4_Sig_BMS_BattTempFault(void);
extern uint8_t  Get_CAN_CH0_ID_0CFABF8F_Sig_EPB_SafeBeltNotTiedLmtReleaseWarning(void);
extern uint8_t  Get_CAN_CH0_ID_0CFABF8F_Sig_EPB_ChildLockActive(void);
extern uint8_t  Get_CAN_CH0_ID_0CFABF8F_Sig_EPB_WarningLampState(void);
extern uint8_t  Get_CAN_CH0_ID_0CFABF8F_Sig_EPB_ParkLampState(void);
extern uint8_t  Get_CAN_CH0_ID_18FA3EF4_Sig_BMS_DCChgPlugSts(void);
extern uint8_t  Get_CAN_CH0_ID_18FA3EF4_Sig_BMS_ChgStatus(void);
extern uint8_t  Get_CAN_CH0_ID_18FAC490_Sig_ACU_AirbagWarningStatus(void);
extern uint8_t  Get_CAN_CH0_ID_18FAAE27_Sig_PMS_OverloadInd(void);
extern uint8_t  Get_CAN_CH0_ID_0C012705_Sig_EGSM_LockStatus(void);
extern uint8_t  Get_CAN_CH0_ID_0C012705_Sig_EGSM_WorkStatus(void);
extern uint8_t  Get_CAN_CH0_ID_18FA41F4_Sig_BMS_TempOutofCtr(void);
extern uint8_t  Get_CAN_CH0_ID_18FA41F4_Sig_BMS_HVIsolationSts(void);
//extern uint8_t  Get_CAN_CH0_ID_18FF4A41_Sig_MMI_WorkMode(void);
//extern uint8_t  Get_CAN_CH0_ID_18FF4A41_Sig_MMI_ConfirmSwStatus(void);
//extern uint8_t  Get_CAN_CH0_ID_18FF4A41_Sig_MMI_DownSwStatus(void);
//extern uint8_t  Get_CAN_CH0_ID_18FF4A41_Sig_MMI_UpSwStatus(void);
//extern uint8_t  Get_CAN_CH0_ID_18FF4A41_Sig_MMI_LeftSwStatus(void);
//extern uint8_t  Get_CAN_CH0_ID_18FF4A41_Sig_MMI_RightSwStatus(void);
extern uint8_t  Get_CAN_CH0_ID_18FA02EF_Sig_MCU_MotorFltLevel(void);
extern uint8_t  Get_CAN_CH0_ID_18FA02EF_Sig_MCU_MotorTempHighAlarm(void);
//extern uint8_t  Get_CAN_CH0_ID_18FA63D5_Sig_HFCU_ConductHigh(void);
extern uint8_t  Get_CAN_CH0_ID_18FA98D0_Sig_PMS_EngMaintanceFlag(void);
extern uint8_t  Get_CAN_CH0_ID_18FA98D0_Sig_PMS_EngMaintainWarningSts(void);
extern uint16_t Get_CAN_CH0_ID_18FA98D0_Sig_PMS_EngServiceMaintainInterval(void);
extern uint8_t  Get_CAN_CH0_ID_0CFFB303_Sig_TCU_PTO_Fault(void);
extern uint8_t  Get_CAN_CH0_ID_18FA1727_Sig_PMS_SpdLmtLevelReq(void);
//extern uint8_t  Get_CAN_CH0_ID_18FF649F_Sig_TBOX_AnnualViolationPro(void);
//extern uint8_t  Get_CAN_CH0_ID_18FF649F_Sig_TBOX_EthAbnormalPrompt(void);
//extern uint8_t  Get_CAN_CH0_ID_18FF649F_Sig_TBOX_PaymentPrompt(void);
//extern uint8_t  Get_CAN_CH0_ID_18FF649F_Sig_TBOX_MaintenanceRemind(void);
//extern uint8_t  Get_CAN_CH0_ID_18FF5241_Sig_MMI_NavTunnelIndication(void);
//extern uint8_t  Get_CAN_CH0_ID_18FF5241_Sig_MMI_NavDestinationIndication(void);
//extern uint8_t  Get_CAN_CH0_ID_18FF5241_Sig_MMI_NavRestAreaIndication(void);
//extern uint8_t  Get_CAN_CH0_ID_18FF5241_Sig_MMI_TollGateIndication(void);
//extern uint8_t  Get_CAN_CH0_ID_18FF5241_Sig_MMI_NextCrossDistanceUnitIndicate(void);
//extern uint16_t Get_CAN_CH0_ID_18FF5241_Sig_MMI_NextCrossDistanceIndicate(void);
//extern uint8_t  Get_CAN_CH0_ID_18FF5241_Sig_MMI_TurningDirectionType(void);
//extern uint32_t Get_CAN_CH0_ID_18FF5141_Sig_MMI_DestinationDistanceIndicate(void);
//extern uint8_t  Get_CAN_CH0_ID_18FF5141_Sig_MMI_DestinationDistanceUnitIndicate(void);
//extern uint8_t  Get_CAN_CH0_ID_18FF5141_Sig_MMI_DestinationTime_Hour(void);
//extern uint8_t  Get_CAN_CH0_ID_18FF5141_Sig_MMI_DestinationTime_Minute(void);
//extern uint8_t  Get_CAN_CH0_ID_18FF5141_Sig_MMI_CurrentRoadType(void);
extern uint16_t Get_CAN_CH0_ID_18FC03F4_Sig_BMS_ChgTimeRemain(void);
extern uint8_t  Get_CAN_CH0_ID_18FF5F27_Sig_PMS_MILTelltale(void);
extern uint8_t  Get_CAN_CH0_ID_18FAA527_Sig_PMS_EDCP_FaultFB(void);
extern uint8_t  Get_CAN_CH0_ID_18FAA527_Sig_PMS_ECPM_FaultFB(void);
extern uint8_t  Get_CAN_CH0_ID_18FAA527_Sig_PMS_HBCP_FaultFB(void);
//extern uint8_t  Get_CAN_CH0_ID_0CFA90D0_Sig_PFCU_IdleTypeResp(void);
extern uint8_t  Get_CAN_CH0_ID_18FFC095_Sig_AVAS_AVASDisabledSts(void);
extern uint8_t  Get_CAN_CH0_ID_18FF4C41_Sig_MMI_IC_LanguageSet(void);
//extern uint8_t  Get_CAN_CH0_ID_18FFB403_Sig_TCU_FltLevel(void);
extern uint8_t  Get_CAN_CH0_ID_18FF5D27_Sig_PMS_LockVehSts(void);
extern uint8_t  Get_CAN_CH0_ID_0CFABA13_Sig_EPS_WarningLamp(void);
extern uint8_t  Get_CAN_CH0_ID_18FE4F0B_Sig_ESC_VDCFullyOperational(void);
extern uint8_t  Get_CAN_CH0_ID_18FE4F0B_Sig_ESC_VDCInformationSignal(void);
/*extern uint8_t  Get_CAN_CH0_ID_18FECAE8_Sig_FCS_AmberWarningLamp(void);*/

extern uint8_t  Co_Can_ConvertSubID_CAN_CH0(uint32_t MsgID);

void Can_Set_Buff_0CFE6C17(canlib_uint8_t CopyData []);
void Can_Set_Buff_18FF4017(canlib_uint8_t CopyData []);
void Can_Set_Buff_18FF4117(canlib_uint8_t CopyData []);
void Can_Set_Buff_18FEC117(canlib_uint8_t CopyData []);
void Can_Set_Buff_18FF6F17(canlib_uint8_t CopyData []);
void Can_Set_Buff_18FEE617(canlib_uint8_t CopyData []);

void Can_18FEE69F_Receive(void);
void Can_18FAB027_Receive(void);
void Can_18FF2319_Receive(void);
void Can_18FAB227_Receive(void);
void Can_18FAB327_Receive(void);
void Can_18FA40F4_Receive(void);
void Can_18FF629F_Receive(void);
void Can_18FA4AF4_Receive(void);
void Can_18FA48F4_Receive(void);
void Can_0CFAB127_Receive(void);
void Can_18FAA027_Receive(void);
void Can_0CFAA627_Receive(void);
void Can_18FC03F4_Receive(void);
void Can_0CFF1ADA_Receive(void);

#endif
