
#include "Include.h"
#include "Button.h"

_ButtonSts ButtonSts;
INT8U KnobKeyFlag = 0;

INT8U ButtonLongPushLock = 0;
uint16_t NoKey3sTimeCnt = 0u;
uint16_t NoKey10sTimeCnt = 0u;
uint16_t NoKey20sTimeCnt = 0u;

void Button_Init(void)
{
	ButtonSts.PushSts = 0;
	ButtonSts.DownSts = 0;
	ButtonLongPushLock = 0;
}

void Button_Sleep_Init(void)
{
	PIN_69_PULL = 0; //°
	PIN_70_PULL = 0; //	  Ұ 
	PIN_72_PULL = 0; //   󰴼

	ButtonSts.PushSts = 0;
//	ButtonSts.DownSts = 0;
	ButtonLongPushLock = 0;
}

INT8U Get_Button_Knob_Status(void)
{
	INT8U  ButtonKnobSts ;
	
	ButtonKnobSts	= 0;

	ButtonSts.LeftTurnNowSts = BUTTON_LEFT_IN_P;
	ButtonSts.RightTurnNowSts = BUTTON_RIGHT_IN_P;


	if(ButtonSts.LeftTurnNowSts == ButtonSts.RightTurnNowSts)
	{
		KnobKeyFlag = 1;
	}
	else
	{
		if(KnobKeyFlag == 1)
		{
			if((ButtonSts.LeftTurnNowSts != ButtonSts.LeftTurnOldSts) && (ButtonSts.RightTurnNowSts == ButtonSts.RightTurnOldSts))
			{
				ButtonKnobSts = BUTTON_KNOB_LEFT;
			}
			else if((ButtonSts.LeftTurnNowSts == ButtonSts.LeftTurnOldSts) && (ButtonSts.RightTurnNowSts != ButtonSts.RightTurnOldSts))
			{
				ButtonKnobSts = BUTTON_KNOB_RIGHT;
			}
			else
			{
				;
			}
		}
		KnobKeyFlag = 0;
	}

	ButtonSts.LeftTurnOldSts = ButtonSts.LeftTurnNowSts;
	ButtonSts.RightTurnOldSts = ButtonSts.RightTurnNowSts;

	return ButtonKnobSts;
}

void Button_Down_Pro(void)
{
	if(BUTTON_DOWN_IN_P == 1)
	{
		if((ButtonSts.PushTime >= 100) && (ButtonSts.PushTime <= 2000))
		{
			ButtonSts.PushSts = BUTTON_DOWN_SHORT;	     
		}
		ButtonLongPushLock = 0;
		ButtonSts.PushTime = 0;
	}
	else
	{
		if(ButtonSts.PushTime < 5000)
		{
			ButtonSts.PushTime +=10;
		}

		if(ButtonSts.PushTime > 2000)
		{
			if(ButtonLongPushLock == 0)
			{
				ButtonSts.PushSts = BUTTON_DOWN_LONG;
				ButtonLongPushLock = 1;
			}
		}
	}
}

INT8U Get_Button_Down_Status(void)
{
	INT8U ButtonDownSts;

	ButtonDownSts = ButtonSts.PushSts;
	ButtonSts.PushSts = BUTTON_DOWN_NOACT;

	return ButtonDownSts;
} 
 
// unsigned char TestButton = 0u;
 //unsigned char TestButton1 = 0u;

void Button_Service(void)
{
	_Page_Key_Value_Enum temp = KEY_Value_Max;
	if(SYS_OPR_STAT_IGN_ON)
	{
		Button_Down_Pro();
		ButtonSts.DownSts = Get_Button_Down_Status();
		ButtonSts.KnobSts =  Get_Button_Knob_Status();
		
		if(ButtonSts.DownSts == BUTTON_DOWN_SHORT)
		{
			temp = KEY_Enter_Short;
			LongTimeNoKeyTmCntReset();							       
		}
		else if((ButtonSts.DownSts == BUTTON_DOWN_LONG)&&(ClearODO.Step_En == 0 ))
		{
			temp = KEY_Enter_Long;
			LongTimeNoKeyTmCntReset();
			Factory_ClearOdoM();
			Data_Clear_Trip();
		}
		else
		{
			if(ButtonSts.KnobSts == BUTTON_KNOB_LEFT)
			{
				temp = KEY_Left;
				LongTimeNoKeyTmCntReset();
			}
			else if(ButtonSts.KnobSts == BUTTON_KNOB_RIGHT)
			{
				temp = KEY_Right;
				LongTimeNoKeyTmCntReset();
			}
			else
			{
				if(NoKey3sTimeCnt++ >= 500)
				{
					NoKey3sTimeCnt = 0;
					temp = KEY_None_5s;
				}
				else if(NoKey10sTimeCnt++ >= 1000)
				{
					NoKey10sTimeCnt = 0;
					temp = KEY_None_10s;
				}
				else if(NoKey20sTimeCnt++ >= 2000)
				{
					NoKey20sTimeCnt = 0;
					temp = KEY_None_20s;
				}
				else
				{
					temp = KEY_Value_Max;
				}
			}
		}
	}
	else
	{
	}
	Page_Manage_KeyCrl_Service(temp);
}

void LongTimeNoKeyTmCntReset(void )
{
	NoKey3sTimeCnt = 0;
	NoKey20sTimeCnt = 0;
	NoKey10sTimeCnt = 0;
}


