/*
 * MOTOR.h
 *
 *  Created on: Apr 21, 2019
 *      Author: qitiancun
 */

#ifndef MOTOR_H_
#define MOTOR_H_

    typedef unsigned char uint8_t;
    typedef unsigned int  uint16_t;
    typedef unsigned long uint32_t;
    

    typedef enum
    {
       direction_1 = 0,
       direction_2,
    }MoveDirection_t;
    
    typedef enum
    {
       Motor_1 = 0,
       Motor_2,
       Motor_3,
       Motor_4,
    }MotorIndex_t;
    
    typedef enum
    {
       Normal = 0,
       MinReset,
       MaxReset,
       MaxStep,
       MaxStepKeep,
       MinStep
    }workMode_t;
    
    extern      uint8_t*        bsp_MotorGetVersion(void);      /* ��ȡ�汾�� */
    
    extern      void            bsp_MotorMove_50us_main(void);  /* ������ VectorNumber_Vmctimovf �ж��е��ã���ʼ�����Ĭ��ʹ���ж� */
    
    extern      uint8_t         bsp_set_meterCfg(uint8_t motorIndex,MoveDirection_t motorDir,uint16_t MaxAngle,uint16_t One_Step_Damp);
                                          /* One_Step_Damp �ƽ�Ŀ��������ٶ�,��ֵԽ��Խ�� */       
    extern      void            bsp_SetMotorMode(uint8_t index,workMode_t Mode); /* ���õ������ģʽ */
    
    extern      workMode_t      bsp_GetMotorState(uint8_t index);   /* ��ȡ�������ģʽ */
    
    extern      void            bsp_SetOneStepDamp(uint8_t motorIndex,uint32_t One_Step_Damp); /* ����ÿһ������ʱ�� */
    
    extern      void            MotorDriveOff(void);
   
    extern      void            bsp_SetMaxSpeed(uint8_t motorIndex,uint32_t speed); /* ���õ������ٶȣ���ֵԽ��Խ�� */

    extern      void            bsp_SetMotorStep(uint8_t Index, uint16_t Step);     /* ���õ��Ŀ�경(ֻ����Nomalģʽ�²ſ�������) */
    
    extern      uint16_t        bsp_GetMotorStep(uint8_t Index);                    /* ��ȡ�����ǰ�� */      
#endif /* MOTOR_H_ */
