

//#include "stdint.h"
//#include <string.h>
#include "IC_Config.h" 
#include "CAN_XHY.h"
#include "DoCAN_ISO15765.h"
#include "Diag_ID_Def.h"



/******************************************************************************

                                

===============================================================================
- MSCANͨԤƵʱTqΪCANźŵʱ

-  Bosch CAN 2.0A/B ׼, MSCAN/ÿһλʱ䱻Ϊ:

  ----------------------------------------------------------------------------
  | Sync_Seg |            Time Segment 1            |     Time Segment 2     |
  ----------------------------------------------------------------------------
  |<- 1 Tq ->|<------------  4 ~ 16 Tq  ----------->|<-----  2 ~ 8 Tq  ----->|
  |                                                                          |
  |<---------------------------  Total 8 ~ 25 Tq  -------------------------->|
  
  Sync_Segй̶1Tqʱ,CANźŵ½ڱβ(ʱ)
            (ʱ),־CANһλշĿʼ,ͬշ
  ʱ 1  ΰCAN׼PROP_SEGκPHASE_SEG1,ʱ,ݵĲڱ
            εĺοһδ,εʱΪ 4 ~ 16 Tq
  ʱ 2  ΰCAN׼PHASE_SEG2,εʱΪ 2 ~ 8 Tq

- ͬתSJWͬڼ,λñƶTq,ʱݶ
                   ֵΪͬת,ɱΪ 1 ~ 4 Tq
                   
- ûȷλʱCAN׼
  --------------------------------------------------
       ʱ 1     |     ʱ 2     |  ͬת
  --------------------------------------------------
       5 ~ 10     |       2        |     1 ~ 2
       4 ~ 11     |       3        |     1 ~ 3
       5 ~ 12     |       4        |     1 ~ 4
       6 ~ 13     |       5        |     1 ~ 4
       7 ~ 14     |       6        |     1 ~ 4
       8 ~ 15     |       7        |     1 ~ 4
       9 ~ 16     |       8        |     1 ~ 4
  --------------------------------------------------
******************************************************************************/
#if (IC_Current == LD01)

#define MSCAN0_BAUD_RATE 250//LD01  250 //,λkbps	LD02 500 
#define MSCAN0_T_SEG1 13//LD01 13 //ʱ1Tq	      LD02 12
#define MSCAN0_T_SEG2 2//LD01  2	 //ʱ2Tq	      LD02 3

#elif(IC_Current == LD02)

#define MSCAN0_BAUD_RATE 500//LD01  250 //,λkbps	LD02 500 
#define MSCAN0_T_SEG1 12//LD01 13 //ʱ1Tq	      LD02 12
#define MSCAN0_T_SEG2 3//LD01  2	 //ʱ2Tq	      LD02 3

#endif

//λü 1+MSCAN0_T_SEG1/1+MSCAN0_T_SEG1+MSCAN0_T_SEG2
//е1Sync_Seg  ͬΣ̶Ϊ1ͬתȲһ

#define MSCAN0_SAMPLE_POINT MSCAN0_SAMPLE_1POINT
#define MSCAN0_SJW 1//1 //2 //3               //ͬת

/******************************************************************************
ѡ                                                                                                                                    
******************************************************************************/
#define MSCAN0_SAMPLE_1POINT 0x00 //ÿλ1(CANƼ)
#define MSCAN0_SAMPLE_3POINT 0x80 //ÿλ3

/******************************************************************************
Ԥ
******************************************************************************/
#define MSCAN0_PRESCALER (8000000 / (1 + MSCAN0_T_SEG1 + MSCAN0_T_SEG2) / MSCAN0_BAUD_RATE / 1000)

#define MSCAN0_BTR0_VALUE ((INT8U)((MSCAN0_SJW - 1) << 6) | (INT8U)(MSCAN0_PRESCALER - 1))
#define MSCAN0_BTR1_VALUE (MSCAN0_SAMPLE_POINT | (INT8U)((MSCAN0_T_SEG2 - 1) << 4) | (INT8U)(MSCAN0_T_SEG1 - 1))
/////////////////////////////////////////////////////////////////////////////////////////////////////

#define Standard_Frame 1 //׼֡
#define Extended_Frame 0 //չ֡
//CAN0  FIFO
#define TX0_BUF_LEN 15 // 10

#define CAN0_Frame_Type Extended_Frame //Standard_Frame

#define Sampling_Rate_Select

#if (CAN0_Frame_Type == Standard_Frame)
#elif (CAN0_Frame_Type == Extended_Frame)
#else
#error CAN0 Frame Type select error
#endif
////////////////////ͼ//////////////////////////////////////////////////////////////////////////////////////////////
volatile _CAN_TX_BUF_TYPE CAN0_TX_BUF[TX0_BUF_LEN];
volatile INT8U CAN0_TX_Count;  //ҪBUF
volatile INT8U CAN0_TX_Seting; //

static INT8U CanFrameExist = 0;

/////////////////////////////////////////////////////////////////////////////////////////////
//CAN0ʼ
void MSCAN0_Init(void)
{

	CAN0CTL0 = 0x01; // MSCANʼģʽ
	while (!(CAN0CTL1_INITAK))
		; //ȴʼģʽ

	CAN0IDAC = 0; //ռĴĹʽ  two 32-bit filter

	CAN0IDAR0 = 0x00; //ռĴ
	CAN0IDAR1 = 0x00;
	CAN0IDAR2 = 0x00;
	CAN0IDAR3 = 0x00;

	CAN0IDMR0 = 0xFF; //μĴ (ΪбID)
	CAN0IDMR1 = 0xFF;
	CAN0IDMR2 = 0xFF;
	CAN0IDMR3 = 0xFF;

	CAN0IDAR4 = 0x00; //ռĴ
	CAN0IDAR5 = 0x00;
	CAN0IDAR6 = 0x00;
	CAN0IDAR7 = 0x00;

	CAN0IDMR4 = 0xFF; //μĴ (ΪбID)
	CAN0IDMR5 = 0xFF;
	CAN0IDMR6 = 0xFF;
	CAN0IDMR7 = 0xFF;

	CAN0CTL1_CANE = 1;	 //ʹMSCANģ
	CAN0CTL1_CLKSRC = 0; //ѡOSCCLK(8MHz)ΪMSCANʱԴ
	CAN0CTL1_LISTEN = 0; //ģʽ(Ǽģʽ)

	// CAN0CTL1_BORM = 0; //ԶBUS_OFFָ
	CAN0CTL1_BORM = 1; //BUS_OFFûƻָ

	CAN0CTL1_WUPM = 1; //Ѽ˲

	CAN0BTR0 = MSCAN0_BTR0_VALUE; // 81.25%Ĳ
	CAN0BTR1 = MSCAN0_BTR1_VALUE;

	CAN0CTL0 = 0x00; //˳ʼģʽ
	while (CAN0CTL1_INITAK)
		; //ȴ˳ʼģʽ
	while (!CAN0CTL0_SYNCH)
		; //ȴMSCANCANͬ

	CAN0TIER = 0x00;	//ֹCANж
	CAN0RIER_RXFIE = 1; //ʹCANж
	CAN0RIER_WUPIE = 1;

	//CAN0_STB = 0; //ʹCANշ
	MSCAN0_TJA1042_STB_SET(0); //ʹCANշ
}
//ʵķͺ
void MSCAN0_SendMsg(_CAN_TX_BUF_TYPE *sendMsgBuf)
{
	INT8U txEmptyBuf = 0;
	INT8U i = 0;

	if ((CAN0CTL0_SLPRQ) || (MSCAN0_TJA1042_STB_GET()))
		return; //MACAN ˯ģʽ ?,NO
	/*if ((CAN0RFLG_TSTAT == 0x03) || (CAN0RFLG_RSTAT == 0x03))
	{
		return;
	}*/
	//	if (CAN0CTL0_SYNCH == 0)
	//	return; //MSCANCAN BUS ͬ
	if (!(CAN0TFLG & 0x01))
		return; //3ͻûп

	txEmptyBuf = CAN0TBSEL = CAN0TFLG; //ѡָеķͻ(ѡ͵)

#if (CAN0_Frame_Type == Standard_Frame)
	CAN0TXIDR0 = (INT8U)(sendMsgBuf->SendID >> 3);
	CAN0TXIDR1 = (INT8U)(sendMsgBuf->SendID << 5);
	CAN0TXIDR1_SRR = 0; //sendMsgBuf->RTR;
	CAN0TXIDR1_IDE = 0;
#elif (CAN0_Frame_Type == Extended_Frame)
	CAN0TXIDR0 = (INT8U)((sendMsgBuf->SendID & 0x1fe00000) >> 21);
	CAN0TXIDR1 = (INT8U)((sendMsgBuf->SendID & 0x001c0000) >> 13);
	CAN0TXIDR1 |= (INT8U)((sendMsgBuf->SendID & 0x00038000) >> 15);
	CAN0TXIDR1 |= 0x18;
	CAN0TXIDR2 = (INT8U)((sendMsgBuf->SendID & 0x00007f80) >> 7);
	CAN0TXIDR3 = (INT8U)((sendMsgBuf->SendID & 0x0000007f) << 1);

#endif

	for (i = 0; i < sendMsgBuf->Len; i++)
	{
		*((&CAN0TXDSR0) + i) = sendMsgBuf->BUFF[i]; //д
	}
	CAN0TXDLR = sendMsgBuf->Len;

	//  CAN0TXTBPR  =   2;//sendMsgBuf->priority;               	         //дȼ
	CAN0TFLG = txEmptyBuf; //TXxб־,Ӧķͻ׼,ͳɹTXxλʾֿ
}
//==================================================
//CAN0,же
//==================================================
void CAN0_TX_DATA_BUF(void)
{
   
	if (CAN0_TX_Seting)
	{
		CAN0TIER_TXEIE = 0X00;
		return;
	}
	
	 BusoffRecover(); 
	if (CAN0_TX_BUF[CAN0_TX_Count].Len != 0)
	{
		MSCAN0_SendMsg(&CAN0_TX_BUF[CAN0_TX_Count]);
		CAN0_TX_BUF[CAN0_TX_Count].Len = 0;
		
		CanNm_Data_Confirm ( CAN0_TX_BUF[CAN0_TX_Count].SendID, 1 );
	
	  	DoCAN_L_Data_Confirm(CAN0_TX_BUF[CAN0_TX_Count].SendID, DIAG_COMPLETE);
			
		CAN0_TX_BUF[CAN0_TX_Count].SendID = 0;
		CAN0_TX_Count++;
		if (CAN0_TX_Count >= TX0_BUF_LEN)
		{
			CAN0_TX_Count = 0;
		}
		
		return;
	}
	CAN0TIER_TXEIE = 0X00; //رж
}
//CAN0  buf д͵
void CAN0_TX_BUF_Clear(void)
{
	INT8U i = 0;

	CAN0_TX_Count = 0;
	for (i = 0; i < TX0_BUF_LEN; i++)
	{
		CAN0_TX_BUF[i].SendID = 0;
		CAN0_TX_BUF[i].Len = 0;
	}
}
//÷
_CAN_SetState CAN0_TX_BUF_Set(INT8U *pdata, INT32U ID, INT8U Len)
{
	INT8U i = 0;
	INT8U j = 0;
	INT8U Count = 0;
	if ((CAN0RFLG_TSTAT == 0x03) || (CAN0RFLG_RSTAT == 0x03))
	{
		return CAN_Set_ERROR_BUSOFF;
	}
	if (Len > 8)
	{
		return CAN_Set_ERROR_OverMaxLen;
	}
	__asm SEI;
	Count = CAN0_TX_Count;
	CAN0_TX_Seting = 1;

	for (j = 0; j < TX0_BUF_LEN; j++)
	{
		if (CAN0_TX_BUF[Count].Len == 0) //
		{
			CAN0_TX_BUF[Count].Len = Len;
			CAN0_TX_BUF[Count].SendID = ID;
			for (i = 0; i < Len; i++)
			{
				CAN0_TX_BUF[Count].BUFF[i] = *(pdata + i);
			}
			CAN0_TX_Seting = 0;

			CAN0TIER_TXEIE = 0x01;
			__asm CLI;
			return CAN_Set_Complete;
		}
		else
		{
			Count++;
			if (Count >= TX0_BUF_LEN)
			{
				Count = 0;
			}
		}
	}

	CAN0_TX_Seting = 0;
	CAN0TIER_TXEIE = 0x01;
	__asm CLI;
	return CAN_Set_ERROR_OverFlow;
}
unsigned char GetBusOffState(void)
{
	if ((CAN0RFLG_TSTAT == 0x03) || (CAN0RFLG_RSTAT == 0x03))
	{
		return 1;
	}
	return 0;
}
void AbortAllCan0Tx(void)
{
	CAN0TARQ = 0x07;
}
/******************************************************************************
MSCAN0_Enter_Low_Power_Mode
  ܣMSCAN0͹ģʽ
  
ֵ
******************************************************************************/
void MSCAN0_Enter_Low_Power_Mode(void)
{
	MSCAN0_Init(); //͸ʼֹCANշ

	//CAN0_STB = 1; //ʧCANշ
	MSCAN0_TJA1042_STB_SET(1); ////ʧCANշ

	if (CAN0RFLG_WUPIF) //ж־ = 1 д10
		CAN0RFLG_WUPIF = 1;
	CAN0CTL0_WUPE = 1; //ʹ

	//1,MSCANз(Ͷп),Ҳ(CAN߿),
	//MSCAN SLEEPģʽ, CAN0CTL1_SLPAK=1ʾȷ
	//ôλǰ CAN0RFLG_WUPIF 

	//CAN0CTL0_SLPRQ=1,CAN0CTL1_SLPAK=1 ,ʾMSCANѾ˯ģʽ
	CAN0CTL0_SLPRQ = 1; //MSCAN˯ģʽ

	//MSCAN˯ģʽ, CAN0CTL0_WUPE = 1 յCANĺ,MSCAN˳˯,CAN0RFLG_WUPIF1
	//ͬʱ CAN0CTL0_SLPRQ,CAN0CTL1_SLPAK ҲԶ0.

	//MSCAN˯ģʽ,ҲCAN0CTL0_SLPRQ = 0,ʹMSCAN˳˯,CAN0CTL1_SLPAK ҲԶ0.
	// CAN0CTL0_SLPRQ = 1,MSCANûн˯ģʽ,ôCAN0CTL0_SLPRQ = 0.

	CAN0TARQ = 0x07; //ֹбķ.

	CAN0RIER_RXFIE = 0; //ֹCANж
}

/******************************************************************************
MSCAN0_Exit_Low_Power_Mode
  ܣMSCAN0˳͹ģʽ
  
ֵ
******************************************************************************/
void MSCAN0_Exit_Low_Power_Mode(void)
{
	CAN0CTL0_SLPRQ = 0; //ʹMSCAN˳˯

	if (CAN0RFLG_WUPIF) //ж־ = 1 д10
		CAN0RFLG_WUPIF = 1;
	CAN0CTL0_WUPE = 0; //ûѹ

	//CAN0_STB = 0; //ʹCANշ
	MSCAN0_TJA1042_STB_SET(0); //ʹCANշ
	CAN0RIER_RXFIE = 1;		   //ʹCANж
}

/******************************************************************************
iMSCAN0_Get_Wake_Up_Flag
  ܣȡMSCAN0ĻG״?
  iS
ֵ0 - δG? 1 - ѱG?
******************************************************************************/
INT8U MSCAN0_Get_Wake_Up_Flag(void)
{
	if ((CAN0CTL0_SLPRQ == 0))
	{
		return 1;
	}
	else
	{
		return 0;
	}
}

INT8U MSCAN0_Set_Exist_Frame(void)
{ 
  CanFrameExist = 1;
}

INT8U MSCAN0_Is_Exist_Frame(void)
{ 
  INT8U ExistFrame = 0;
  
  ExistFrame = CanFrameExist;
  CanFrameExist = 0;
  
  return ExistFrame;
}

//ȡCAN0 յݳ   //׼֡չ֡һ
//extern INT8U MSCAN0_GET_Data_Len(void);
//ȡCAN0 յݳ   //׼֡չ֡һ
INT8U MSCAN0_GET_Data_Len(void)
{
	return CAN0RXDLR_DLC;
}
typedef union
{
	INT16U DATA16;
	struct
	{
		INT8U DATA0; //ֽ
		INT8U DATA1; //ֽ
	} BIT;

} _TEMP_DATA16;

//ȡCAN0 ׼֡ID
INT16U MSCAN0_GET_Stand_ID(void)
{
	_TEMP_DATA16 CANMsgID;
	CANMsgID.BIT.DATA1 = CAN0RXIDR1;
	CANMsgID.BIT.DATA0 = CAN0RXIDR0;
	CANMsgID.DATA16 >>= 5;
	//CANMsgID = (CAN0RXIDR0<<3);
	//CANMsgID |= (CAN0RXIDR1>>5);

	//CANMsgID = ((INT16U)(CAN0RXIDR0 << 3)) | ((INT16U)(CAN0RXIDR1 >> 5));
	//return CANMsgID;
	return CANMsgID.DATA16;
}
typedef union
{
	INT32U DATA32;
	struct
	{
		INT8U DATA0;
		INT8U DATA1;
		INT8U DATA2;
		INT8U DATA3;
	} BIT;

} _TEMP_DATA32;

//ȡCAN0 չ֡ID
INT32U MSCAN0_GET_Extended_ID(void)
{

	_TEMP_DATA32 CANMsgID;

	CANMsgID.BIT.DATA0 = CAN0RXIDR0;
	CANMsgID.BIT.DATA1 = CAN0RXIDR1;
	CANMsgID.BIT.DATA2 = CAN0RXIDR2;
	CANMsgID.BIT.DATA3 = CAN0RXIDR3;

	CANMsgID.DATA32 = (((CANMsgID.DATA32 & 0X7FFFF) >> 1) | (CANMsgID.DATA32 & 0XFFE00000) >> 3);

	return CANMsgID.DATA32;
}

//#define GET_EXTPGN(id) (((((((INT32U)id & 0xFF0000) >> 16) >= 0xF0) ? ((INT32U)id & 0x00FF00) : 0) | ((INT32U)id & 0x2FF0000)) >> 8)

//ȡCAN0 չ֡PNG
INT32U MSCAN0_GET_Extended_PNG(INT32U ID)
{
	INT32U CAN_PGN;
	if ((ID & 0XFF0000) >= 0XF00000)
	{
		CAN_PGN = ((ID & 0x2FFFF00) >> 8);
	}
	else
	{
		CAN_PGN = ((ID & 0x2FF0000) >> 8);
	}

	return CAN_PGN;
}
//ȡCAN0 չ֡SA
INT8U MSCAN0_GET_Extended_SA(INT32U ID)
{
	return ((INT8U)(ID & 0Xff));
}
//ȡCAN0 չ֡PS
INT8U MSCAN0_GET_Extended_PS(INT32U ID)
{
	return ((INT8U)((ID & 0Xff00) >> 8));
}
//ȡCAN0 չ֡PF
INT8U MSCAN0_GET_Extended_PF(INT32U ID)
{
	return ((INT8U)((ID & 0Xff0000) >> 16));
}
