
#include "mc9s12xhy256.h"


#include "XHY_PWM.h"
//Ѻ״ϵʱһ
void  PWM_Wake_Up_Init(void)
{
 //ͨʼ趨ʹ
PWM_Channel_Init(PWM_CH5_PIN34_PP5, PWM_CLOCK_SA , PWM_POL_POS , PWM_LEFT_ALIGN)  ;    
PWM_Channel_Set_Freq(PWM_CH5_PIN34_PP5, 2850 )  ;
PWM_Channel_Set_Duty(PWM_CH5_PIN34_PP5, 0 ) ;
PWM_Channel_Enable(PWM_CH5_PIN34_PP5,1);     

PWM_Channel_Init(PWM_CH7_PIN36_PP7, PWM_CLOCK_SB , PWM_POL_POS , PWM_LEFT_ALIGN)  ;    
PWM_Channel_Set_Freq(PWM_CH7_PIN36_PP7, 2850 )  ;
PWM_Channel_Set_Duty(PWM_CH7_PIN36_PP7, 0 ) ;
PWM_Channel_Enable(PWM_CH7_PIN36_PP7,1);     

//PWM_Channel_Init(PWM_CH6_PIN35_PP6, PWM_CLOCK_SB , PWM_POL_POS , PWM_LEFT_ALIGN)  ;       
//PWM_Channel_Set_Freq(PWM_CH6_PIN35_PP6, 2850 )   ;       
//PWM_Channel_Set_Duty(PWM_CH6_PIN35_PP6, 0 )   ;    
//PWM_Channel_Enable(PWM_CH6_PIN35_PP6,1);      

//
PWM_Channel_Init(PWM_CH0_PIN29_PP0, PWM_CLOCK_SA , PWM_POL_POS , PWM_LEFT_ALIGN)  ;      
PWM_Channel_Set_Freq(PWM_CH0_PIN29_PP0, 1000 )   ;       
PWM_Channel_Set_Duty(PWM_CH0_PIN29_PP0, 0 )   ;    
PWM_Channel_Enable(PWM_CH0_PIN29_PP0,1);        

}
//ʱһ
void  PWM_Sleep_Init(void)
{
        PWM_Channel_Enable(PWM_CH5_PIN34_PP5, 0 );
        PWM_Channel_Enable(PWM_CH7_PIN36_PP7, 0 );
      //  PWM_Channel_Enable(PWM_CH6_PIN35_PP6, 0 );
        PWM_Channel_Enable(PWM_CH0_PIN29_PP0, 0 );
        
}
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

//PWMģĳʼ//һ״ϵһμ
void PWM_Init(void)
{
	PWME = 0;   
	PWMPOL = 0; 
	PWMCLK = 0; 
	PWMCAE = 0; 
	PWMCTL = 0; 

	PWMCTL_CON67 = PWM_Channel_67_Cascade_Mode;
	PWMCTL_CON45 = PWM_Channel_45_Cascade_Mode;
	PWMCTL_CON23 = PWM_Channel_23_Cascade_Mode;
	PWMCTL_CON01 = PWM_Channel_01_Cascade_Mode;

	PWMPRCLK = (PWM_CLOCK_B_DIV << 4) | PWM_CLOCK_A_DIV; //PWM clock A/B Ƶ
	PWMSCLA = PWMSCLAREG;								 //PWM clock SA
	PWMSCLB = PWMSCLBREG;								 //PWM clock SB
}
//PWMͨĳʼ
//ͨӦΪ·Чƽ
// PWMͨ 0 / 1 / 4 / 5 ѡ clock A / clock SA еһΪʱ
// PWMͨ 2 / 3 / 6 / 7 ѡ clock B / clock SB еһΪʱ
//һѡ
void PWM_Channel_Init(_PWMCHPIN_Type Pin, _PWMClock_Select ClkSrc, _PWMPolarity_Select Pol, _PWMAlign_Select Cae)
{
	INT8U ChBit;
	INT8U Chanel;

	Chanel = Pin >> 4;
	if (Chanel > 7)
		return;

	ChBit = 1 << Chanel;

	if (ClkSrc & 0X01)
		PWMCLK |= ChBit;
	else
		PWMCLK &= ~ChBit;
	if (Pol)
		PWMPOL |= ChBit;
	else
		PWMPOL &= ~ChBit;
	if (Cae)
		PWMCAE |= ChBit;
	else
		PWMCAE &= ~ChBit;

	switch (Chanel)
	{
	case 0:
		PTPRRL &= 0b00001110;
		PTPRRL |= (Pin & 0x01) << 0;
		break; //CH0
	case 1:
		PTPRRL &= 0b00001101;
		PTPRRL |= (Pin & 0x01) << 1;
		break; //CH1
	case 2:
		PTPRRL &= 0b00001011;
		PTPRRL |= (Pin & 0x01) << 2;
		break; //CH2
	case 3:
		PTPRRL &= 0b00000111;
		PTPRRL |= (Pin & 0x01) << 3;
		break; //CH3
	case 4:
		PTPRRH &= 0b11111100;
		PTPRRH |= (Pin & 0x03) << 0;
		break; //CH4
	case 5:
		PTPRRH &= 0b11110011;
		PTPRRH |= (Pin & 0x03) << 2;
		break; //CH5
	case 6:
		PTPRRH &= 0b11001111;
		PTPRRH |= (Pin & 0x03) << 4;
		break; //CH6
	case 7:
		PTPRRH &= 0b00111111;
		PTPRRH |= (Pin & 0x03) << 6;
		break; //CH7
	default:;  //쳣
	}
}
//PWMͨƵ//ͨڼĴ
void PWM_Channel_Set_Freq(_PWMCHPIN_Type Pin, INT32U Freq)
{
	INT8U ChBit;
	INT8U RegVal;
	INT8U Chanel;
	INT8U *pReg;
	INT32U Prescaler;
	INT32U ClkFreq;

	Chanel = Pin >> 4;
	if (Chanel > 7)
		return;

	ChBit = 1 << Chanel;

	if (ChBit & 0x33) // 0 / 1 / 4 / 5 ͨ,ʹclock A/SA
	{
		if (PWMCLK & ChBit) //ʹclock SA
			ClkFreq = PWM_CLOCK_SA_Real_FREQ;
		else //ʹclock A
			ClkFreq = PWM_CLOCK_A_FREQ;
	}
	else // 2 / 3 / 6 / 7 ͨ,ʹclock B/SB
	{
		if (PWMCLK & ChBit) //ʹclock SB
			ClkFreq = PWM_CLOCK_SB_Real_FREQ;
		else //ʹclock B
			ClkFreq = PWM_CLOCK_B_FREQ;
	}

	if (PWMCAE & ChBit)
		ClkFreq /= 2;

	Prescaler = ClkFreq / Freq;

	if (Prescaler > 255)
		RegVal = 255;
	else
		RegVal = (INT8U)Prescaler;

	if (RegVal == 0)
		RegVal = 1;

	pReg = &PWMPER0 + Chanel;
	*pReg = RegVal;
}
//ͨռձ
void PWM_Channel_Set_Duty(_PWMCHPIN_Type Pin, INT8U Dty)
{
	INT8U ChBit;
	INT8U Chanel;
	INT8U *pPERReg;
	INT8U *pDTYReg;
	INT16U Val;

	Chanel = Pin >> 4;
	if (Chanel > 7)
		return;

	ChBit = 1 << Chanel;

	if (Dty > 100)
		Dty = 100;

	pPERReg = &PWMPER0 + Chanel; //
	pDTYReg = &PWMDTY0 + Chanel; //ռձ


	Val = (INT16U)Dty;
	Val *= (INT16U)(*pPERReg);
	*pDTYReg = (INT8U)(Val / 100);
}

//ͨ͹رա10ر
void PWM_Channel_Enable(_PWMCHPIN_Type Pin, INT8U Onoff)
{
	INT8U ChBit, Chanel;

	Chanel = Pin >> 4; 
	if (Chanel > 7)
		return;

	ChBit = 1 << Chanel;
	if (Onoff)
		PWME |= ChBit;
	else
		PWME &= ~ChBit;
}
//ͨƵ
void PWM_Channel_Cascade_Set_Freq(_PWMCHPIN_Type Pin, INT32U Freq)
{
	INT8U ChBit;
	INT16U RegVal;
	INT8U Chanel;
	INT16U *pReg;
	INT32U Prescaler;
	INT32U ClkFreq;

	Chanel = Pin >> 4;
	if (Chanel > 7)
		return;
	if (Chanel & 0x01)
	{
		ChBit = 1 << Chanel;
		if (ChBit & 0x33) // 0 / 1 / 4 / 5 ͨ,ʹclock A/SA
		{
			if (PWMCLK & ChBit) //ʹclock SA
				ClkFreq = PWM_CLOCK_SA_Real_FREQ;
			else //ʹclock A
				ClkFreq = PWM_CLOCK_A_FREQ;
		}
		else // 2 / 3 / 6 / 7 ͨ,ʹclock B/SB
		{
			if (PWMCLK & ChBit) //ʹclock SB
				ClkFreq = PWM_CLOCK_SB_Real_FREQ;
			else //ʹclock B
				ClkFreq = PWM_CLOCK_B_FREQ;
		}

		if (PWMCAE & ChBit)
			ClkFreq /= 2;

		Prescaler = ClkFreq / Freq;

		if (Prescaler > 65535)
			RegVal = 65535;
		else
			RegVal = (INT16U)Prescaler;

		if (RegVal == 0)
			RegVal = 1;

		pReg = (&PWMPER01 + (Chanel >> 1));
		*pReg = RegVal;
	}
}
//ͨռձ
void PWM_Channel_Cascade_Set_Duty(_PWMCHPIN_Type Pin, INT8U Dty)
{
	INT8U ChBit;
	INT8U Chanel;
	INT16U *pPERReg;
	INT16U *pDTYReg;
	INT32U Val;

	Chanel = Pin >> 4;
	if (Chanel > 7)
		return;
	if (Chanel & 0x01)
	{
		ChBit = 1 << Chanel;

		if (Dty > 100)
			Dty = 100;

		pPERReg = (&PWMPER01 + (Chanel >> 1)); //
		pDTYReg = (&PWMDTY01 + (Chanel >> 1)); //ռձ

		Val = (INT32U)Dty;
		Val *= (INT32U)(*pPERReg);
		*pDTYReg = (INT16U)(Val / 100);
	}
}

