    #ifndef _DATA_PROCESSOR_H_
#define _DATA_PROCESSOR_H_

/******************************************************************************
ʱ����ʾ
******************************************************************************/

//typedef enum
//{
//        Time_AM,
//        Time_PM,
//        Time_MAX,
//}_TimeEnum;
     
EXTERN uint8_t   DspTimeSencond;
EXTERN uint8_t   DspTimeMin;
EXTERN uint8_t   DspTimeHour;
EXTERN uint8_t   DspTimeDate;
EXTERN uint32_t DspTimeYear;
EXTERN uint8_t   DspTimeMonth;
//EXTERN uint8_t   DspTimeAPM;
/******************************************************************************
checksum
******************************************************************************/
#define   cb_CRC_POLY  0x2F  
#define   cb_DATA_BYTE_SIZE 7

//EXTERN  uint8_t DMM_Valid;

/******************************************************************************
��̹���������
******************************************************************************/

/*** ȫ�ֱ��� ***/
EXTERN uint16_t DataMileageRollingCounter;

#define  DATA_MILEAGE_ROLLING_COUNTER       DataMileageRollingCounter     //��̹���������,��λm

/*** ���ƽṹ ***/
typedef struct
{
  uint16_t  mmRollingCounter;
  uint16_t  mmRoCBackup;
}DataMileageCalcStruct;

/******************************************************************************
�ܼ����
******************************************************************************/

/*** ȫ�ֱ��� ***/
EXTERN uint8_t  DataODOValid;
EXTERN uint32_t  ODO_Disp;


/*** ���ƽṹ ***/
typedef struct
{
 // uint8_t  UpdateDisable;

  uint16_t RoCBackup;
  uint32_t LastSaved;
}DataODOStruct;

//���
EXTERN DataMileageCalcStruct   DataMileage;
EXTERN DataODOStruct           DataODOCalc;

/******************************************************************************
С�����
******************************************************************************/

/*** ȫ�ֱ��� ***/
//EXTERN uint8_t  DataTripUnit;
EXTERN uint32_t   DispTrip;
//EXTERN uint32_t   DispTripB;

/*** ���ƽṹ ***/
typedef struct
{
  uint32_t  MileageA100m;
  uint32_t  MileageB100m;

}DataTripStruct;

EXTERN DataTripStruct          DataTripCalc;

EXTERN INT8U ResetTripAFlag;

/******************************************************************************
�������
******************************************************************************/
EXTERN uint32_t DataServiceInterval;
EXTERN uint8_t  DataServiceWarning;
EXTERN uint8_t  DataServiceDistanceWarning;
EXTERN uint32_t ServiceMileVaule;
EXTERN uint32_t  OldServiceMileVaule;
#define  DATA_SERVICE_INTERVAL              DataServiceInterval
#define  DATA_SERVICE_WARNING               DataServiceWarning

/******************************************************************************
��ʻʱ��
******************************************************************************/
#define   DATA_ENGINE_RUNNING_THRESHOLD     400 //��������ת��ֵ    
#define   DATA_ENGINE_STOP_THRESHOLD        300 //������ֹͣ��ֵ


/*** ȫ�ֱ��� ***/
EXTERN uint8_t DataDrivingTimeHour;
EXTERN uint8_t DataDrivingTimeMin;

#define  DATA_DRIVING_TIME_HOUR             DataDrivingTimeHour
#define  DATA_DRIVING_TIME_MIN              DataDrivingTimeMin

/*** ���ƽṹ ***/
typedef struct
{
  uint8_t   init;
  uint8_t   Start;
  uint16_t  RoCBackup;
  uint16_t  Timer;
}DataDrivingTimeStruct;

//��ʻʱ��
EXTERN DataDrivingTimeStruct   DataDrivingTime;

/******************************************************************************
�ϵ��ʱ
******************************************************************************/

/*** ȫ�ֱ��� ***/
EXTERN uint16_t DataIGNOffTimerSec;


/*** ���ƽṹ ***/
typedef struct
{
  uint8_t   IGNStatus;
  uint16_t  RoCBackup;
}DataIGNOffTimingStruct;

EXTERN DataIGNOffTimingStruct  DataIGNOffTimer;
////////////////////////////ƽ���������/////////////////////////////////
typedef struct{
      INT16U FreshTime;
      INT8U Display_Valid;
      INT8U Valid;
      INT8U First_Distance;
      INT16U Value;
      INT16U Display_Value;
      INT32U Distance;
      INT32U Time;
}_AverageSpd;

EXTERN _AverageSpd DataAvgSpd;

#define TripA_Average_Speed_Display DataAvgSpd.Display_Value
#define TripA_Average_Speed_Valid DataAvgSpd.Valid

////////////////////////////˲ʱ�ͺ�/////////////////////////////////
typedef struct{
      
      INT32U Value;
      INT8U   Valid;
      INT8U Symbol ;
      INT8U First_Distance;
      INT8U MsgCnt ;
      INT8U MsgExpEn;
      INT8U ResetAveragePowerConsumption;
      INT8U ResetAveragePowerConsumption_Cnt;
      INT32U Value_BackUp;
      INT8U  Valid_BackUp;
      INT8U  Symbol_BackUp;
}_InsFuel_Eng;
//EXTERN _InsFuel_Eng      InsFuel_Eng;
 //EXTERN _InsFuel_Eng      AvgFuel_Eng;
EXTERN _InsFuel_Eng      AvgEVCons;

typedef struct{   
   
      INT32U Value;
      INT16U Display_Value; 
      INT16U TimeCnt ;
      INT8U   Valid;
      
}_BattPower_Volt;
//���ص�ѹ
EXTERN _BattPower_Volt      BattPower_Volt;
//�������ߵ�ѹ
EXTERN _BattPower_Volt      Batt_MaxCellVolt;
//�������͵�ѹ
EXTERN _BattPower_Volt      Batt_MinCellVolt;

typedef struct{   
   
      INT32U Value;
      INT16U Display_Value; 
      INT8U   Valid;
      INT8U Symbol ;  
      INT16U Display_Value_BackUp; 
      INT8U  Valid_BackUp;
      INT8U  Symbol_BackUp; 
}_BattCurr;

//��������
EXTERN _BattCurr      BattCurr;

//���������¶�
EXTERN _BattCurr      Batt_MaxTemp;
//���������¶�
EXTERN _BattCurr      Batt_MinTemp;

//������ѹ
EXTERN _BattCurr      BattVolt;

typedef struct{
      
      INT16U u16_Value;
      INT8U   Valid;
      INT16U u16_Value_BackUp;
      INT8U   Valid_BackUp; 
}_DataDTEStruct;

EXTERN _DataDTEStruct	       DataEVDTE;
EXTERN _DataDTEStruct	       DataRemainPwr;

typedef struct{
      
      INT16U u16Value;
      INT8U   u8Valid;
      INT8U u8DisFlg;
      INT8U u8LED_W_Sts ;
      INT8U u8LED_G_Sts ;
      
}_DataCruiseStruct;
EXTERN _DataCruiseStruct	   DataCruise;


typedef struct
{
	INT8U CoolantTem_Warning ;
	INT8U CoolantTem_H ; 
}_CoolantTemp_ConfFun;
 EXTERN _CoolantTemp_ConfFun 	 ConfFun_Backup;
 EXTERN _CoolantTemp_ConfFun 	 ConfFun;


//�������
typedef struct
{
  uint8_t   	enable;
  uint8_t   Level;
  uint16_t  Timer;
  uint16_t  Period;
  uint16_t  ActPeriod;
}DriveInfoSpeedPlusConverterStruct;

EXTERN DriveInfoSpeedPlusConverterStruct  DriveInfoSpeedPlusConverter;




/******************************************************************************
����
******************************************************************************/
/*** ȫ�ֱ��� ***/
EXTERN uint16_t DataVSpeedActual;
EXTERN uint16_t DataVSpeedDisp;
EXTERN uint16_t  DataVSpeedHysteresis;
EXTERN uint8_t  DataVSpeedValid;
EXTERN uint8_t DataOverSpeed;

#define  DATA_VEHICLE_SPEED_ACTUAL          DataVSpeedActual
#define  DATA_VEHICLE_SPEED_DISPLAYING      DataVSpeedDisp
#define  DATA_VEHICLE_SPEED_VALID           DataVSpeedValid
//#define  DATA_OVER_SPEED_WARNING            DataOverSpeed

/*** �������� ***/
#define   DATA_VSPEED_DAMPING_FACTOR        4   //����ϵ��
#define   DATA_VSPEED_INC_STEP              3   //�ٶ�����ʱ�������ٶȱ仯����
#define   DATA_VSPEED_DEC_STEP              8   //����ı�ʱ�������ٶȱ仯����
#define   DATA_VSPEED_APPR_SPEED_MIN        2   //��С�ƽ��ٶ�
#define   DATA_VSPEED_HYSTERESIS            10  //�ز� 
/******************************************************************************
���ݱƽ�����
******************************************************************************/
#define   DATA_APPR_DIR_INC                 0x00
#define   DATA_APPR_DIR_DEC                 0x01


/*** ���ƽṹ ***/
typedef struct
{
  uint16_t  Timer;
  uint16_t  Backup;
  uint16_t  Buffer[3];
  uint8_t   Cnt;
  uint8_t   UseBackup;
}DataVSpeedSamplerStruct;             //���ٲ����ṹ

typedef struct
{
  uint16_t  Speed;
  uint16_t  Delta;
  uint8_t   Dir;
}DataVSPeedDampingStruct;             //��������ṹ

//����
EXTERN  DataVSpeedSamplerStruct DataVSpeedSampler;
EXTERN  DataVSPeedDampingStruct DataVSPeedDamping;

/******************************************************************************
������ת��
******************************************************************************/
/*** ���ƽṹ ***/
typedef struct
{
  uint16_t  Timer;
  uint16_t  Backup;
  uint16_t  Buffer[5];
  uint8_t   Cnt;
  uint8_t   UseBackup;
}DataESpeedSamplerStruct;             //ת�ٲ����ṹ

//EXTERN DataESpeedSamplerStruct DataESpeedSampler;
//EXTERN uint16_t  DataESpeedActual;
//EXTERN uint16_t  DataESpeedDisp; 
//EXTERN uint8_t   DataESpeedValid ;


//#define  DATA_ENGINE_SPEED_ACTUAL           DataESpeedActual
//#define  DATA_ENGINE_SPEED_DISPLAYING       DataESpeedDisp
//#define  DATA_ENGINE_SPEED_VALID            DataESpeedValid

typedef struct
{
    uint32_t Value;
    uint32_t DispValue;
    uint8_t Valid;
    uint8_t Symbol;
    uint32_t u8CANSignal_InputVal;
    uint32_t DispValue_BackUp;
    uint32_t u8CANSignal_InputVal_BackUp;
    uint8_t Symbol_BackUp;
    uint8_t Valid_BackUp;
}_DataConPwrStruct;	

EXTERN _DataConPwrStruct DataConsPwr;

/******************************************************************************
ˮ��
******************************************************************************/
typedef enum
{
      Positive,
      Negative,
}_Symbol;

typedef struct
{
  INT16U Value;
  INT8U Symbol;
  INT8U Valid;
}DataCoolantStruct;

EXTERN DataCoolantStruct Coolant_Temperature;


typedef struct
{
  INT8U Value;
  INT8U Symbol;
  INT8U Valid;
  INT8U Warn;
  INT8U Blink;
  INT16U Timer;
}DataACTempStruct;

EXTERN DataACTempStruct AC_Temperature;


typedef enum
{
    INACTIVE = 0,
    ACTIVE ,
}_AirPressEnum;


/*��ѹ*/
#define             Air_Cnt        5
#define AtmoSignalShakeTime 6//000/2 
#define AtmoSignalLostTime 100//000/2 


typedef struct
{
    INT8U   u8_Analog_Valid;
    INT16U u16Analog_Volt;
    INT16U u16Get_VoltVal;
    INT16U u16Level[Air_Cnt]; 
    //INT8U   u8_Cnt;
    INT16U u16Volt_Value;
    INT16U  Cur_VoltVal;
    INT16U  Last_VoltVal;
    INT8U   u8_ActTimer;
    INT8U   u8_InActTimer;
    INT8U   u8_PressValid;
    INT16U u16Press_Val;
    //INT16U u16Press_Val_Last;
    //INT8U   u8_WarnTimer;
    //INT8U   u8_WarnValid;
    //INT8U   u8_WarnFlag;
    //INT8U   u8_DeletWarnTimer;
    
    uint16_t  u16SignalVal;
}_AirPress;

EXTERN   _AirPress    	      AirPress_Front;
EXTERN   _AirPress    	      AirPress_Rear;

typedef struct
{
    INT8U   u8_CurSeg;
    INT8U 	u8_DestSeg;
    INT8U 	u8_SegLast;
    INT8U 	u8_UpFlashtimer;
    INT8U 	u8_DownFlashtimer;
    INT8U 	u8_Flashflg;
    INT8U 	u8_Valid;
}_AirPress_Dis;

EXTERN   _AirPress_Dis    	      AirPressFront_Dis;
EXTERN   _AirPress_Dis    	      AirPressRear_Dis;




typedef enum
{
	PDC_NoDisplay = 0 ,
	PDC_40D,
	PDC_40_100D,
	PDC_100_150D,
	PDC_150_300D,
	PDC_300,
	PDC_3F,
}_PDC_Enum;

//EXTERN _PDC_Enum     PDC_Sts;

typedef struct
{
    uint16_t RL: 3;
    uint16_t MID:3;
    uint16_t RR:3;
    uint16_t UnVaild:1;
    
}_PDC_Infor;

EXTERN _PDC_Infor      PDC_Sts ;

//typedef enum
//{
//	LDW_Thin,
//	LDW_Thick,
//	LDW_MAX,
//	
//}_LDW_Enum;

//EXTERN _LDW_Enum     LDW_Sts;

//typedef struct
//{
//    uint8_t Left_St: 2;
//    uint8_t Right_St:2;
//    uint8_t Vaild:1;
//    
//}_LDW_Infor;
//
//EXTERN _LDW_Infor      LDW_Infor ;




typedef enum
{
    Warning_Non = 0,
    Warning_level_1,
    Warning_level_2,    
}Warning_level_Enum;

typedef struct
{
    uint16_t u16Timer;
    uint8_t  u8Lamp_Warn;
    uint8_t  u8Pop_Warn:1;
    uint8_t u8Left_St:1;
    uint8_t u8Mid_St:1;
    uint8_t u8Right_St:1;
    uint8_t u8Left_St_Last:1;
    uint8_t u8Mid_St_Last:1;
    uint8_t u8Right_St_Last:1;
    uint8_t u8Gear_Last:1;
    uint8_t Trigger:1;
  
}_Safe_Belt_Warning_Struct;

EXTERN _Safe_Belt_Warning_Struct g_stSafeBelt; 

////////////////////////////��λ��ʾ/////////////////////////////////
typedef enum
{
   GEAR_R = 0,
   GEAR_N,
   GEAR_D,
   GEAR_L, 
   GEAR_Max,
}_Gear_Mode;

EXTERN  INT8U GearMode;

////////////////////////////�г�ģʽ��ʾ/////////////////////////////////
typedef enum
{
   Drive_Normal = 0,
   Drive_ECO,
   Drive_S,
   Drive_Max,
}_Drive_Mode;

EXTERN  _Drive_Mode  DriveMode;

////////////////////////////��������/////////////////////////////////
typedef struct
{
    uint16_t Value;
    uint8_t  Vaild; 
    
}_ErrCodeStruct;

EXTERN  _ErrCodeStruct  DataErrCode;

////////////////////////////��������/////////////////////////////////
typedef enum
{
	Energy_Leve1 = 0,
	Energy_Leve2,
	Energy_Leve3,
	Energy_LeveMax,
	
}_Energy_Recovery;

EXTERN  _Energy_Recovery  EnergyRecovery;



////////////////////////////̥ѹ��ʾʹ�ñ���///////////////////////////////////

typedef enum
{
   TPMS_Left_Front = 0,
   TPMS_Left_Rear ,
   TPMS_Left_Rear_Inside,
   TPMS_Right_Front ,
   TPMS_Right_Rear ,
   TPMS_Right_Rear_Inside,
   TPMS_Dir_MAX,
} _TPMS_Dir;

typedef struct
{
	INT8U Wheel_ID;
	INT8U  TPMS_Blink;
	INT8U TPMS_Valid;
	INT8U Press_Valid;
	INT8U  Press_St;
	INT16U  Press_Value;
	INT8U  Temp_Valid;
	INT8U  Temp_St;
	INT16U  Temp_Value;
	INT16U  Temp_Symbol;	
	INT8U  Sensor_Loss;
	INT8U  Sensor_Flt;
	INT8U Fast_Press;
	INT8U System_Flt;
	INT8U BatLow_St;
//	INT8U SoundAlarm;
}_TPMS_Display_Infor;




EXTERN _TPMS_Display_Infor Left_Front_Display;
EXTERN _TPMS_Display_Infor Left_Rear_Display;
EXTERN _TPMS_Display_Infor Left_Rear_Inside_Display;
EXTERN _TPMS_Display_Infor Right_Front_Display;
EXTERN _TPMS_Display_Infor Right_Rear_Display;
EXTERN _TPMS_Display_Infor Right_Rear_Inside_Display;
EXTERN _TPMS_Display_Infor TPMS_Info;

typedef struct
{
	INT8U  TPMS_Blink;
	INT8U Temp_Valid;
	INT8U Press_Valid;
	INT16U  Press_Value;
	INT16U  Temp_Value;
	INT16U  Temp_Symbol;	
}_TPMS_Display_Infor_Backup;

EXTERN _TPMS_Display_Infor_Backup Left_Front_Display_Backup;
EXTERN _TPMS_Display_Infor_Backup Left_Rear_Display_Backup;
EXTERN _TPMS_Display_Infor_Backup Left_Rear_Inside_Display_Backup;
EXTERN _TPMS_Display_Infor_Backup Right_Front_Display_Backup;
EXTERN _TPMS_Display_Infor_Backup Right_Rear_Display_Backup;
EXTERN _TPMS_Display_Infor_Backup Right_Rear_Inside_Display_Backup;

 typedef struct
{
	uint8_t F101;
	uint8_t F110;
}_TPMS_Config;

EXTERN _TPMS_Config 	TPMS_Config ;
EXTERN _TPMS_Config 	BrakeType_Config ;
EXTERN _TPMS_Config 	AC_Config ;

typedef struct
{
    uint16_t Push_Key_Timer;
    uint8_t Step_En; //IGOFFתIGON
    uint16_t Delay_Timer;
}_Clear_ODO_Struct;

EXTERN _Clear_ODO_Struct ClearODO;

EXTERN INT8U Clear_ODO_Flag;

typedef struct
{
    uint8_t   Blink;
    uint8_t  u8Valid;    
    uint16_t u16Val;	  
}_Data_Soc_Struct;
EXTERN _Data_Soc_Struct  g_stSoc; 

typedef struct
{
  uint8_t  Valid;
  uint8_t  Value;    
}_Data_Eco_Struct;
EXTERN _Data_Eco_Struct  g_stEco; 

typedef struct
{
    uint8_t   u8Hour;
    uint16_t u8Min;
    uint8_t  u8Valid;     	  
}_Data_ChgRemain_Struct;
EXTERN _Data_ChgRemain_Struct  DataChgRemain; 

typedef struct
{
  uint8_t  Can_18FEE69F: 1;
  uint8_t  Can_18FAB027: 1;
  uint8_t  Can_18FF2319: 1;
  uint8_t  Can_18FAB227: 1;
  uint8_t  Can_18FAB327: 1;
  uint8_t  Can_18FA40F4: 1;
  uint8_t  Can_18FF629F: 1;
  uint8_t  Can_18FA4AF4: 1;

  uint8_t  Can_18FA48F4: 1; 
  uint8_t  Can_0CFAB127: 1;
  uint8_t  Can_18FAA027: 1;
  uint8_t  Can_0CFAA627: 1;
  uint8_t  Can_18FC03F4: 1;
  uint8_t  Can_0CFF1ADA: 1;
  uint8_t  : 1;
  uint8_t  : 1;
}_Can_Receive_Struct;
EXTERN _Can_Receive_Struct  CanReceive;
void Can_Receive_KL30_WakeUp_Init(void);

void Can_18FEE69F_Receive(void);
void Can_18FAB027_Receive(void);
void Can_18FF2319_Receive(void);
void Can_18FAB227_Receive(void);
void Can_18FAB327_Receive(void);
void Can_18FA40F4_Receive(void);
void Can_18FF629F_Receive(void);
void Can_18FA4AF4_Receive(void);
void Can_18FA48F4_Receive(void);
void Can_0CFAB127_Receive(void);
void Can_18FAA027_Receive(void);
void Can_0CFAA627_Receive(void);
void Can_18FC03F4_Receive(void);
void Can_0CFF1ADA_Receive(void);




unsigned int Unit_Conv_kPa_To_bar(unsigned int kPa);
extern void DataProcessor_On_System_Init(void );
extern void DataProcessor_OFF_To_ON_Init(void );
void Data_15KL_Init(void)	 ;
void Data_30KL_Init(void);
void CoolantTemp_Read_Config(void);
void CoolantTemp_KL15_Read_Config_Init(void);
void CoolantTemp_KL30_Read_Config_Init(void);


 //������������ж�
void Drive_Info_Speed_Plus_Conversion_Init(void);
void Drive_Info_Speed_Plus_Conversion_ISR(void);
void Drive_Info_Speed_Plus_Conversion ( void );
void Drive_Info_Import_Export_Service ( void );

void RTC_TIME_Processing_Service(void);
void Vehicle_Speed_Init(void );

//void Data_Urea_Level_Init(void ) ;
void Data_Urea_Level_Service(void); 
void Coolant_Meter_Data_Reset(void );
void Data_Oil_Press_Service(void );
void Data_Coolant_Temp_Processing_Service(void );

void Data_Vehicle_Speed_Processing_Service(void)  ;
void Data_Mileage_Rolling_Counter_Update_ISR(void);
void Data_ODO_Processing(void);
void Data_Clear_ODO(void);
void Data_Clear_Trip(void) ;
void Data_Clear_TripA(void);
void Factory_ClearOdoM(void);
void Geely_ClearOdo_Processing(void);
void Data_Trip_Processing_ADD(INT16U KM_Data);
void Data_Service_Interval_Processing(void);
void Data_Service_Interval_Reset(void);
void Data_Driving_Time_Processing(void);
void Data_IGN_Off_Timing_Service(void);
void Data_Driving_Time_Reset(void);
void Data_Driving_Time_OFF_Reset(void ) ;
void Data_AvgSpeed_Processing_Service(void);
void Average_Vspeed_ADD(INT16U Inc);
void Average_Vspeed_Trip_Clear(void);
void Data_Instantaneous_Fuel_Service(void );
void Data_Avg_Fuel_Service(void );
void Avg_EVCons_Trip_ADD(INT16U Inc);
void Data_Avg_EVCons_Service(void );
void Data_Avg_EVCons_Trip_Clear(void);
void IC_ResetAveragePowerConsumption_Service(void);
void IC_OTA_InfoShowStatus_Service(void);
void IC_OTA_DownloadSelected_Service(void);
void IC_OTA_UpdateSelected_Service(void);
void IC_OTA_UpdateResultConfirm_Service(void);
void IC_OTA_DeclimerSelected_Service(void);
void Data_EV_DTE_Service (void );
void Data_ResiduePwr_Service(void );
void Data_BattPower_Processing_Service(void );
void Data_BattVolt_Processing_Service(void );
void Data_BattCurr_Processing_Service(void );
void Data_Batt_MaxCellVolt_Processing_Service(void );
void Data_Batt_MinCellVolt_Processing_Service(void );
void Data_Batt_MaxTemp_Processing_Service(void );
void Data_Batt_MinTemp_Processing_Service(void );
void Data_EnergyRecovery_Processing_Service(void );
void Data_ErrCode_Processing_Service(void );
void Data_Cruise_Processing_Service(void );
void Data_Gear_Processing_Service(void );
void Data_ChgTimeRemain_Service(void );

void AirPress_Front_Delt(INT16U m);
void AirPress_Rear_Delt(INT16U m);
void Display_AirPress_Front_Processing(void );
void Data_AirPress_Rear_Processing(void );
void Data_AirPress_Front_Processing(void );
void Data_AirPress_Rear_Processing(void );


void Data_DoorOpen_Service(void);
void Data_Charge_Status_Service(void);
void Data_SafeBelt_Status_Service(void) ;
void Data_Language_Set_Service(void);
void Data_PDC_Service(void );
void Data_LDW_Service(void );
void Data_TPMS_30_15KL_Processing(void);
void Data_TPMS_Value_Processing(void);
void Data_Drive_Info_Group1_Processing_Service(void);
void Data_Drive_Info_Group2_Processing_Service(void);	
void Data_Drive_Info_Group3_Processing_Service(void)  ;

extern void S513_Maintenance_Data_Set(INT32U SetedInterV);

extern uint8_t DMM_Checksum_Processing_Service(void);
void DMM_Processing_Service( void );

void Data_Consumed_Power_Init(void);
void Data_Consumed_Power_Service(void);
void Data_AC_Temp_Init(void);
void Data_AC_Temp_Processing_Service(void);
void Data_SOC_Init(void);
void Data_SOC_Processing_Service(void );


#endif