#ifndef MEMU_H__
#define MEMU_H__

#include <hidef.h>      /* common defines and macros */
#include "derivative.h"      /* derivative-specific definitions */
#include "stdint.h"

#define MENU_PLATFORM_16BIT 0U
#define MENU_PLATFORM_32BIT 1U
#define MENU_PLATFORM_SELECT MENU_PLATFORM_16BIT
#if (MENU_PLATFORM_SELECT == MENU_PLATFORM_16BIT)
typedef unsigned char Menu_uint8_t;
typedef unsigned int Menu_uint16_t;
typedef unsigned long Menu_uint32_t;
#define MENU_INT_SIZE 2U
#define MENU_ENUM_SIZE 2U
#elif (MENU_PLATFORM_SELECT == MENU_PLATFORM_32BIT)
typedef unsigned char Menu_uint8_t;
typedef unsigned short Menu_uint16_t;
typedef unsigned int Menu_uint32_t;
#define MENU_INT_SIZE 4U
#define MENU_ENUM_SIZE 4U
#else
#error platform select error!!!
#endif

/*--------------------------Please do not modify the above content--------------------------------*/
/*--------------------------Please do not modify the above content--------------------------------*/
/*--------------------------Please do not modify the above content--------------------------------*/
/*
ʹ��ע�����
1���������ĳ����֦ʱ�������԰Ѹ÷�֦���˵������ѡ����ó�����ȡ����״̬��
	��ȡ���ˣ����������������
2�������������⣬������Щһ����֦��һ���˵�������֣���Ҫ��������ȡ����
	����Ҫ��ʱ����ת���Ǹ���֦�ͺá�
3�����к���������ѭ���ڵ��ã���Ҫ���ж��ڵ��á�
*/
/*���в˵����ö��
��ʹĳЩ�˵�������ʾ����ͬ������������ͬ�˵����棬����Ҫ�ò�ͬö������
*/
typedef enum
{
//	MENU_ITEM_ENTRANCE_FIX = 0U, /*��ڹ̶���*/
	
	MENU_ITEM_Navi_ECU = 0U,
	MENU_ITEM_Navi_Set,
	MENU_ITEM_Navi_Demand,	       //��ѯ
	
	MENU_ITEM_ECU_AvgELC, 
	MENU_ITEM_ECU_ElcDTE,
	MENU_ITEM_ECU_InsELC,   
	MENU_ITEM_ECU_RemainPwr,
	MENU_ITEM_ECU_AvgSpeed,
	MENU_ITEM_ECU_DrivingTime,
	MENU_ITEM_ECU_WorkVolt,
	MENU_ITEM_ECU_WorkCurr,
	MENU_ITEM_ECU_BattVolt,
	MENU_ITEM_ECU_BattHighVolt,
	MENU_ITEM_ECU_BattLowVolt,
	MENU_ITEM_ECU_BattHighTemp,	
	MENU_ITEM_ECU_BattLowTemp,
	MENU_ITEM_ECU_ErrCode,	
	MENU_ITEM_ECU_TPMS,	    
	//MENU_ITEM_ECU_LDW,
	MENU_ITEM_ECU_RADAR,	   
	
	MENU_ITEM_SET_TIME,
	MENU_ITEM_SET_OVERSPEED, 
	MENU_ITEM_SET_MAINT, 
	MENU_ITEM_SET_CLEAR, 
	MENU_ITEM_SET_LANGUAGE, 
	MENU_ITEM_SET_TPMS_LEARN, 
	MENU_ITEM_SET_IC,
	MENU_ITEM_SET_FACTORYRESET,
	MENU_ITEM_SET_RETURN,	 //3
	
	//MENU_ITEM_SET_TIME_MODE,
	MENU_ITEM_SET_TIME_CLOCK,
	MENU_ITEM_SET_TIME_Synch,
	MENU_ITEM_SET_TIME_RETURN,	//4
	
	//MENU_ITEM_SET_TIME_12MODE,
	//MENU_ITEM_SET_TIME_24MODE,
	//MENU_ITEM_SET_TIME_MODE_RETURN,
	
	MENU_ITEM_SET_TIME_CLOCK_HOUR,
	
	MENU_ITEM_SET_TIME_CLOCK_MIN,

	//MENU_ITEM_SET_TIME_CLOCK_APm,
	
	MENU_ITEM_SET_TIME_SET_RETURN,
	
	MENU_ITEM_SET_OVERSPEED_OPEN, 
	MENU_ITEM_SET_OVERSPEED_CLOSE, 
	MENU_ITEM_SET_OVERSPEED_CUSTOM, 
	MENU_ITEM_SET_OVERSPEED_RETURN,
	
	MENU_ITEM_SET_OVERSPEED_CUSTOM_ADJUST, 
	MENU_ITEM_SET_OVERSPEED_CUSTOM_RETURN,
	
	MENU_ITEM_SET_MAINT_OPEN, 
	MENU_ITEM_SET_MAINT_CLOSE, 
	MENU_ITEM_SET_MAINT_CHECK, 
	MENU_ITEM_SET_MAINT_RETURN,
	
	MENU_ITEM_SET_MAINT_CHECK_RETURN,
	
	MENU_ITEM_SET_CLEAR_TRIP, 
	MENU_ITEM_SET_CLEAR_DRIVTIME, 
	MENU_ITEM_SET_CLEAR_AVGSPD, 
	MENU_ITEM_SET_CLEAR_AVGELC, 
	MENU_ITEM_SET_CLEAR_RETURN,
	
	MENU_ITEM_SET_CLEAR_TRIP_YES,
	MENU_ITEM_SET_CLEAR_TRIP_NO,
	
	MENU_ITEM_SET_CLEAR_DRIVTIME_YES,
	MENU_ITEM_SET_CLEAR_DRIVTIME_NO,
	
	MENU_ITEM_SET_CLEAR_AVGSPD_YES,
	MENU_ITEM_SET_CLEAR_AVGSPD_NO,
	
	MENU_ITEM_SET_CLEAR_AVGELC_YES,
	MENU_ITEM_SET_CLEAR_AVGELC_NO,

	MENU_ITEM_SET_LANGUAGE_China, 
	MENU_ITEM_SET_LANGUAGE_ENGLISH, 
	MENU_ITEM_SET_LANGUAGE_RETURN,
	
	MENU_ITEM_SET_TPMS_LEARN_LF,
	MENU_ITEM_SET_TPMS_LEARN_RF,
	MENU_ITEM_SET_TPMS_LEARN_LR,
	MENU_ITEM_SET_TPMS_LEARN_MLR,
	MENU_ITEM_SET_TPMS_LEARN_MRR,
	MENU_ITEM_SET_TPMS_LEARN_RR,
	
	MENU_ITEM_SET_TPMS_Learning,

	MENU_ITEM_SET_TPMS_Learn_TimeOut,
	MENU_ITEM_SET_TPMS_Learn_IDConflict,
	MENU_ITEM_SET_TPMS_Learn_HaveVechSpeed,
	MENU_ITEM_SET_TPMS_Learn_Succeed,

	MENU_ITEM_SET_IC_ResCheck,
	MENU_ITEM_SET_IC_RETUEN,
	
	MENU_ITEM_SET_IC_ResCheckRet,
	
	MENU_ITEM_SET_FactoryReset_Confirm1,
	MENU_ITEM_SET_FactoryReset_Confirm1_Ret,
	
	MENU_ITEM_SET_FactoryReset_Confirm2,
	MENU_ITEM_SET_FactoryReset_Confirm2_Ret,
	
	MENU_ITEM_Navi_Demand_Alam,
	
	
	MENU_ITEM_MAX,
} Menu_Item_en_t;
/*���в˵������ö��*/
typedef enum
{
//	MENU_INTF_ENTRANCE = 0U, /*���*/
	
	MENU_INTF_Navi = 0U,	
	
	MENU_INTF_ECU,
	
	MENU_INTF_SET,
		
	MENU_INTF_Time_Set_Option,
	
	MENU_INTF_Time_Set_Hourly,

	MENU_INTF_Time_Set_Hour,
	MENU_INTF_Time_Set_Minute,
	//MENU_INTF_Time_Set_APm,
	MENU_INTF_Time_Set_Clock_Ret,

	MENU_INTF_SET_OVERSPEED, 
	MENU_INTF_SET_OverSpeed_Adjust, 
	MENU_INTF_SET_OverSpeed_Ret, 
	
	MENU_INTF_SET_MAINT, 
	
	MENU_INTF_SET_MAINT_CHECK,
	
	MENU_INTF_SET_Clear, 
	
	MENU_INTF_SET_Clear_Trip,
	
	MENU_INTF_SET_Clear_DriveTime,
	
	MENU_INTF_SET_Clear_AvgSpeed,
	
	MENU_INTF_SET_Clear_AvgElc,
	
	MENU_INTF_SET_Language, 
	
	MENU_INTF_SET_TPMS_LEARN,
		
	MENU_INTF_SET_TPMS_Learn_Result,
	
	MENU_INTF_SET_IC_SW,
	
	MENU_INTF_SET_IC_ResCheck,
	
	MENU_INTF_SET_FactoryReset_Confirm1,
	
	MENU_INTF_SET_FactoryReset_Confirm2,
	
	MENU_INTF_Demand,

	
	MENU_INTERFACE_MAX,
} Menu_Interface_en_t;
/*���в˵���֧*/
typedef enum
{
	MENU_BRANCH_MENUE = 0u, /*��ͨ�˵�*/
	MENU_BRANCH_MAX,
} Menu_Branch_en_t;
/*��Ҫ��������*/
#define MENU_CURSOR_MEMORY_DEPTH 0UL
/*--------------------------Do not modify the following--------------------------------*/
/*--------------------------Do not modify the following--------------------------------*/
/*--------------------------Do not modify the following--------------------------------*/
#define MENU_RAM_DATA_LEN ((2UL * MENU_INT_SIZE + 4UL * MENU_ENUM_SIZE) + \
						   (MENU_ENUM_SIZE * MENU_BRANCH_MAX) +           \
						   (MENU_ENUM_SIZE * MENU_INTERFACE_MAX) +        \
						   (MENU_INT_SIZE * 2UL * MENU_ITEM_MAX) +        \
						   (MENU_ENUM_SIZE * MENU_CURSOR_MEMORY_DEPTH))
/*-------------------------������˵��---------------
Ԥ��λ������0������λ������Ҫ����ѡ��
0x0001λ���Ƿ��ѭ��,���˵׶�ѭ���ν���� 1����ѭ����0������ѭ��
0x0002λ��Ԥ��
0x0004λ��Ԥ��
0x0008λ��Ԥ��
0x0010λ��Ԥ��
0x0020λ��Ԥ��
0x0040λ��Ԥ��
0x0080λ��Ԥ��
0x0100λ��Ԥ��
0x0200λ��Ԥ��
0x0400λ��Ԥ��
0x0800λ��Ԥ��
0x1000λ��Ԥ��
0x2000λ��Ԥ��
0x4000λ��Ԥ��
0x8000λ��Ԥ��
--------------------------------------------*/
/*----�˵�֧�ֵİ�������-----------*/
typedef enum
{
	MENU_KEY_NONE = 0U,
	/*6�������Ķ̰�����*/
	MENU_KEY_UP_SHORT,
	MENU_KEY_DOWN_SHORT,
	MENU_KEY_LEFT_SHORT,
	MENU_KEY_RIGHT_SHORT,
	MENU_KEY_CANCEL_SHORT,
	MENU_KEY_CONFIRM_SHORT,
	/*����Բ˵��������ⴥ������*/
	MENU_KEY_TIMEOUT, /*��ʱ��������*/
	/*6�������ĳ�������*/
	MENU_KEY_UP_LONG,
	MENU_KEY_DOWN_LONG,
	MENU_KEY_LEFT_LONG,
	MENU_KEY_RIGHT_LONG,
	MENU_KEY_CANCEL_LONG,
	MENU_KEY_CONFIRM_LONG,
	/*6�������ĳ���������*/
	MENU_KEY_UP_SUPER_LONG,
	MENU_KEY_DOWN_SUPER_LONG,
	MENU_KEY_LEFT_SUPER_LONG,
	MENU_KEY_RIGHT_SUPER_LONG,
	MENU_KEY_CANCEL_SUPER_LONG,
	MENU_KEY_CONFIRM_SUPER_LONG,
	/*��Ծ��幦�ܵ������������*/
	MENU_KEY_FUNCTION_1_SHORT,
	MENU_KEY_FUNCTION_1_LONG,
	MENU_KEY_FUNCTION_1_SUPER_LONG,
	MENU_KEY_FUNCTION_2_SHORT,
	MENU_KEY_FUNCTION_2_LONG,
	MENU_KEY_FUNCTION_2_SUPER_LONG,
	MENU_KEY_MAX,
} Menu_Key_en_t;
/*------�˵���������-------------------------------------------
--------Ĭ������ʱ�����°���ʵ�ֲ˵����л������Ұ���ʵ�ַ�ҳ����-----------
--------����ʱ�����Ұ���ʵ�ֲ˵����л������°���ʵ�ַ�ҳ����--------------
-------------------------------*/
typedef enum
{
	MENU_DIRECTION_LONGITUDINAL = 0U, /*����*/
	MENU_DIRECTION_TRANSVERSE,		  /*����*/
	MENU_DIRECTION_MAX,
} Menu_Direction_en_t;
/*------�˵���ת����ѡ�񣬲˵����淢���仯ʱ��ȷ�����룬�������أ���ʱ���ص�-----------*/
typedef enum
{
	/*��ת���׸�λ��*/
	MENU_JUMP_FIRST = 0U,
	/*��ת��ĩβλ��*/
	MENU_JUMP_END,
	/*��ת����ѡ��Ĳ˵����ϣ�����ж����ѡ��λ�ÿ�ǰ��*/
	MENU_JUMP_SELECT,
	/*��ת����һ�ι��λ��*/
	MENU_JUMP_LAST_POSITION,
	MENU_JUMP_MAX,
} Menu_Jump_Type_en_t;
/*��������֦�л�ʱ����Ŀ���֦���Ĵ�����ʽ*/
typedef enum
{
	/*�л���굽��֦���׸�λ����*/
	MENU_CHANGE_FIRST = 0U,
	/*�л���굽֮ǰ�뿪ʱ��λ���ϣ�Ҳ���Ǽ���λ�ã�����������ȥ��*/
	MENU_CHANGE_HOLD,
	/*�л���굽����λ�õ���һ���˵��㼶*/
	MENU_CHANGE_PREVIOUS,
	MENU_CHANGE_MAX,
} Menu_Change_Type_en_t;
/*
��������
*/
typedef enum
{
	MENU_ERROR_NONE = 0U,
	MENU_ERROR_1, /*�˵����������Ĳ˵�������Ϣ����*/
	MENU_ERROR_2, /*�˵����������Ĳ˵���֧��Ϣ����*/
	MENU_ERROR_3, /*��Ļ��ÿ�п���ʾ��������ҪС�ڵ��ڲ˵���������� */
	MENU_ERROR_4,
	MENU_ERROR_5,  /*ȷ�ϡ����ء���ʱ����������������ת��ʽ���� */
	MENU_ERROR_6,  /*���������в˵����ǰ���˳����д��,*/
	MENU_ERROR_7,  /*ͬһ���˵�����������������ֵ��һ�µ�*/
	MENU_ERROR_8,  /*ͬһ���˵����������в˵�����ϼ��˵���Ҳ��һ�µġ�*/
	MENU_ERROR_9,  /*ͬһ���˵�������ÿ�п���ʾ������Ҳ��һ�µġ�*/
	MENU_ERROR_10, /*�˵�������ÿ���˵����Ӧ��������ʵ����д�Ĳ˵�����������Ҫ��Ӧ*/
	MENU_ERROR_11, /*�˵�����ö��������ʵ����д�Ĳ˵����������ܶ�Ӧ��*/
	MENU_ERROR_12, /*��֦�ڲ˵�����Ų�����*/
	MENU_ERROR_13, /*��֦�ڲ˵���������һ��*/
	MENU_ERROR_14, /*��֦�ڲ˵����������ʵ����д����������Ӧ*/
	MENU_ERROR_15, /*�˵���֦ö��������ʵ����д�Ĳ˵���֦��������Ӧ*/
	MENU_ERROR_16, /*�˵����������Ϣ����*/
	MENU_ERROR_17, /*��������������ѭ����enMenuBelongItem��д����*/
	MENU_ERROR_18,
	MENU_ERROR_19, /*�˵����ڵĲ˵���������������ɷ�ɢ���С�*/
	MENU_ERROR_20, /*�˵���֦�����еĲ˵�������������С����ɷ�ɢ���С�*/
	MENU_ERROR_21, /*ȷ�ϰ����������߶���˵�������ϼ��˵������һ��*/
	MENU_ERROR_22, /*ȷ�ϰ��������Կ��֦��ת*/
	MENU_ERROR_23, /*ͬһ��֦�ڲ����Գ���������֦�����ӵ������˵���*/
	MENU_ERROR_24,
	MENU_ERROR_25,
	/*���һ������˵����ϰ���ȷ�Ϻ�����ͬһ���˵������ϡ�
	����ȷ�����һ�У����ࡱ���������в˵������������Զ����ʱ���ɺ��Ա�����
	*/
	MENU_WARNING_1,
	MENU_ERROR_MAX,
} Menu_Error_en_t;
/*�˵����Ա��������*/
typedef struct
{
	/*��������*/
	Menu_Error_en_t enMenuErrorType;
	/*�˵�����������ڽ�����������ڷ�֦���ִ���*/
	Menu_Item_en_t enMenuErrorItem;
} Menu_Error_Information_en_t;
/*�˵���ʼ������*/
typedef struct
{
	/*�˵���ȣ�����Ϊ0*/
	Menu_Item_en_t enMenuItemLen;
	/*�˵����泤�ȣ�����Ϊ0*/
	Menu_Interface_en_t enMenuInterfaceLen;
	/*�˵���֦���ȣ�����Ϊ0*/
	Menu_Branch_en_t enMenuBranchLen;
	/*�˵�������Ϣ*/
	unsigned int uintMenuConfig;
	/*��Ҫ��������
	������Ҫ������λ��ʱ������Ϊ0
	������Ҫ�����ϴι��λ��ʱ����Ϊ1��
	������Ҫ�����ϴκ����ϴ�ʱ���ó�2��
	������Ҫ�����ϴΡ����ϴκ������ϴ�ʱ���ó�3��
	�Դ�����
	*/
	unsigned int uintMenuCursorMemoryDepth;
} Menu_Init_st_t;
typedef void (*Logic_Operation)(Menu_Key_en_t enKeyType);
/*ÿ���˵���Ĺ̶�����*/
typedef struct
{
	/*定位在哪个分枝上*/
	Menu_Branch_en_t enMenuLocateBranch;
	/*定位在哪个菜单界面内*/
	Menu_Interface_en_t enMenuLocateInterface;
	/*归属哪个菜单项，上级菜单项。
	一般可以理解为在哪个菜单项上按确认按键进入的*/
	Menu_Item_en_t enMenuBelongItem;
	/*该菜单项所在界面的位置,一定顺序填写，从0开始*/
	unsigned int uintMenuPositionInInterface;
	/*该菜单项所在界面的所有项数*/
	unsigned int uintMenuItemTotalInInterface;
	/*屏幕内可显示的，每一列最多有几个横向行，*/
	unsigned int uintMenuTransverseNum;
	/*该菜单项所在分支的位置,一定顺序填写，从0开始。0表示首个位置*/
	unsigned int uintMenuPositionInBranch;
	/*该菜单项所在分支的所有项数*/
	unsigned int uintMenuItemTotalInBranch;
	/*菜单方向*/
	Menu_Direction_en_t enMenuDirection;
	/*本菜单项都支持哪些触发动作。
	待开发，暂定填0xFF即可*/
	unsigned int uintMenuKeyBit;
	
	/*下一级菜单界面，也就是按下确认按键后需要跳转到的界面,
	如果没有下级菜单时填0xFFFF，不要填本身序号*/
	Menu_Interface_en_t enMenuNextInterface;

	/*按下确认按键，进入新菜单界面时，光标跳转类型*/
	Menu_Jump_Type_en_t enMenuNextJumpPostion;

	/*上一级菜单界面,也就是按下返回按键后需要跳转到的界面，
	如果没有上级菜单时填0xFFFF，不要填本身序号*/
	Menu_Interface_en_t enMenuPreviousInterface;
	
	/*按下返回按键，返回菜单界面时，光标跳转类型*/
	Menu_Jump_Type_en_t enMenuPreviousJumpPostion;

	/*按键超时时需要返回到的菜单界面,
	如果不需要返回（返回到自身）时填0xFFFF不要填本身序号*/
	Menu_Interface_en_t enMenuTimeoutInterface;

	/*超时返回界面中光标跳转的类型*/
	Menu_Jump_Type_en_t enMenuTimeoutJumpPostion;
	/*----------------------------------------------------------*/
	/*   具体功能逻辑的回调函数，按键操作类型，上下左右确认返回    */
	Logic_Operation pfnLogicOperationCallBack;
} Menu_Item_Attribute_st_t;
/*--------------------------------------------------------------------------------------------*/
extern const Menu_Item_Attribute_st_t stMenuItemAttribute[MENU_ITEM_MAX];
/*------------------------------------------------------------------------------------*/

/*
���Կ����׶�ʹ�ã�����������Ա��Ƿ��д���.
����ֵ��MENU_ERROR_NONEʱ���ſɵ��ú�������������
ע��ÿ���޸����Ա���������һ�¸ú�����ȷ�����Ա���д����
�Ѿ�ȷ�����Ա�����֮������θú�����
enItemMAX:���˵�������Ҳ����MENU_ITEM_MAX
enInterfaceMAX:���˵���������Ҳ����MENU_INTERFACE_MAX
enBranchMAX:���˵���֦����Ҳ����MENU_BRANCH_MAX
*/
//extern Menu_Error_Information_en_t Menu_Attribute_Error_Check(uint8_t *pu8MenuRamData, const Menu_Item_Attribute_st_t *pstMenuAttribute, Menu_Init_st_t *pstMenuInit);
/*
�״��ϵ����һ�μ��ɣ������ظ����á�
��ʼ��Ĭ�����в˵�����Ч����û�б�ѡ�С�
u32MenuItemLen:���˵�������Ҳ����MENU_ITEM_MAX
u32MenuInterfaceLen:���˵���������Ҳ����MENU_INTERFACE_MAX
u32MenuBranchLen:���˵���֦����Ҳ����MENU_BRANCH_MAX
u32MenuConfig:�����֣�����ʵ����Ҫ��д��
*/
extern void Menu_Init(uint8_t *pu8MenuRamData, const Menu_Item_Attribute_st_t *pstMenuAttribute, Menu_Init_st_t *pstMenuInit);
/*
ÿ�����ߺ���ʱ����һ�Ρ�
*/
extern void Menu_Wake_Up_Init(uint8_t *pu8MenuRamData, const Menu_Item_Attribute_st_t *pstMenuAttribute, Menu_Init_st_t *pstMenuInit);
/*
�˵���궯������ִ�к�����
���밴������
��ѭ���ڵ��ã���ѭ���ڵ��ã���ѭ���ڵ��ã�*/
extern void Menu_Cursor_Process(Menu_Key_en_t enMenuKey);
/*�˵��߼��ص������ĵ���
����˵������ڴ˴�����ִ��*/
extern void Menu_Logic_Process(Menu_Key_en_t enMenuKey);
/*��֦�л�
enMenuBranch��Ŀ���֦
enMenuChangePostion:Ŀ��λ�õ�����
���أ�ʵ���л����Ĳ˵���
��ѭ���ڵ��ã���ѭ���ڵ��ã���ѭ���ڵ��ã�
*/
extern Menu_Item_en_t Menu_Change_Branch(Menu_Branch_en_t enMenuBranch, Menu_Change_Type_en_t enMenuChangeType);
/*��֦�л�
enMenuBranch��Ŀ���֦
enMenuItemDes:Ŀ��ѡ��
���أ�ʵ���л����Ĳ˵���
��ѭ���ڵ��ã���ѭ���ڵ��ã���ѭ���ڵ��ã�
*/
extern Menu_Item_en_t Menu_Change_Branch_To_Item(Menu_Branch_en_t enMenuBranch, Menu_Item_en_t enMenuItemDes);
/*��ȡ��ǰ���λ��*/
extern Menu_Item_en_t Menu_Get_Current_Cursor_Information(void);
/*��ȡ������λ��
����0��ù�������ϸ�λ��
����1��ù���������ϸ�λ��
����2��ù�����������ϸ�λ��
ע�ⲻҪ�������õ������Ϣ*/
extern Menu_Item_en_t Menu_Get_Memory_Cursor_Information(unsigned int uintCursorMemoryIndex);
/*��ȡĳ���˵������ڼ���Ĺ��λ��*/
extern Menu_Item_en_t Menu_Get_Cursor_In_Interface(Menu_Interface_en_t enMenuInterface);
/*��ȡĳ����֦�ڼ���Ĺ��λ��*/
extern Menu_Item_en_t Menu_Get_Cursor_In_Branch(Menu_Branch_en_t enMenuBranch);
/*
ĳ���˵����������������
0�����������˵����ʾ
1����������Ҫ��ʾ�˵���
��ѭ���ڵ��ã���ѭ���ڵ��ã���ѭ���ڵ��ã�
*/
extern void Menu_Item_Exist_Condition_Set(Menu_Item_en_t enMenuItem, uint8_t u8ExistOrNot);
/*------��ȡĳ���˵���ĳ���������0����������1������-------*/
extern uint8_t Menu_Item_Exist_Condition_Get(Menu_Item_en_t enMenuItem);
/*
����ĳ���˵����Ƿ�ѡ��
0��δѡ�У�û�й�ѡ
1��ѡ�У�����ѡ��
*/
extern void Menu_Item_Select_Set(Menu_Item_en_t enMenuItem, uint8_t u8SelectOrNot);
/*
��ȡĳ���˵����Ƿ�ѡ��
0��δѡ�У�û�й�ѡ
1��ѡ�У�����ѡ��
*/
extern uint8_t Menu_Item_Select_Get(Menu_Item_en_t enMenuItem);
/*��ȡĳ���˵��������Ľ���*/
/*stMenuItemAttribute[ĳ���˵���].enMenuLocateInterface;*/
/*��ȡĳ���˵��������ķ�֦*/
/*stMenuItemAttribute[ĳ���˵���].enMenuLocateBranch;*/
/*-----------------------------------------------------------------------------------*/
extern uint8_t u8MenuRamData[MENU_RAM_DATA_LEN];
/*-----------------------------------------------------------------------------------*/
/*-----------------------------------------------------------------------------------*/
/*-----------------------------------------------------------------------------------*/


typedef enum
{
	Menu_User_Init_Power_K30 = 0,
	Menu_User_Init_Power_K15,
	Menu_User_Init_Power_WakeUp,
}Menu_User_Init_PowerTypeEnum;

typedef struct
{
	uint8_t Hour;
	uint8_t Minute;
	//uint8_t APm; /*0��AM��1��PM*/
	uint8_t OverSpeed;
	uint8_t Language;
	
}Menu_TimeSetData_Struct;
extern Menu_TimeSetData_Struct MenuData;

/*typedef enum
{
	Day_AM = 0u,
	Day_PM,
	Day_Max,
}Menu_Day_Enum;*/

                
typedef enum
{
    TMPS_Export_LF = 0, 
    TMPS_Export_RF,
    TMPS_Export_LR,
    TMPS_Export_MLR,
    TMPS_Export_MRR, 
    TMPS_Export_RR,
    TMPS_Export_Over,
    TMPS_Export_Max,  
}TMPS_Export_Sts;

extern TMPS_Export_Sts TMPS_Learnning_Flag;

extern void Menu_User_Init(Menu_User_Init_PowerTypeEnum PowerType);

extern Menu_Item_en_t MENU_Intf_Inside_Item_Select_Get(Menu_Item_en_t StartItem, Menu_Item_en_t EndItem);
extern void MENU_Intf_Inside_Item_Select_Set(Menu_Item_en_t StartItem, Menu_Item_en_t EndItem, Menu_Item_en_t SelectItem);
#endif