/******************************************************************************
文 件 名：Simulated_IIC_Master.h
功能描述：IO端口模拟的IIC(I2C)主机函数库头文件
作    者：张暄
版    本：V1.0
日    期：2016.12.21
******************************************************************************/

#ifndef SIMULATED_IIC_2_MASTER_H__
#define SIMULATED_IIC_2_MASTER_H__

//#include <stdint.h>
//#include "GPIO.h"

typedef unsigned char uint8_t;
typedef unsigned int uint16_t;
typedef unsigned long uint32_t;
/******************************************************************************
1us延时校准
******************************************************************************/
#define SIMULATED_IIC_2_FREQ_CALIBRATION 6U

/******************************************************************************
确认信号
******************************************************************************/
#define SIMULATED_IIC_2_ACK 0U		   //肯定应答
#define SIMULATED_IIC_2_NAK 1U		   //否定应答
#define SIMULATED_IIC_2_INVALID_ACK 2U //无效的应答信号(应答信号还未收到)

/******************************************************************************
引脚定义
******************************************************************************/

#define SIMULATED_IIC_2_SCL 		PIN_47_P	 //SCL�ź�
#define SIMULATED_IIC_2_SCL_DIR 		PIN_47_D //SCL����
#define SIMULATED_IIC_2_OUT_SDA 	PIN_50_P //SDA�ź�
#define SIMULATED_IIC_2_IN_SDA 		PIN_50_P	   //?
#define SIMULATED_IIC_2_SDA_DIR 	PIN_50_D //SDA����
#define  SDB_LED_DRIVER			PIN_48_P

/******************************************************************************
函数声明
******************************************************************************/
void Simulated_IIC_2_Init(void);
void Simulated_IIC_2_Start(void);
void Simulated_IIC_2_Stop(void);
void Simulated_IIC_2_Transmit_Data(uint8_t Data);
uint8_t Simulated_IIC_2_Receive_Data(void);
void Simulated_IIC_2_Transmit_ACK(uint8_t ACK);
uint8_t Simulated_IIC_2_Receive_ACK(void);
void Simulated_IIC_2_Delay(void);

/*void Simulated_IIC_2_Slave_Service(void);*/

#endif