/**********************************************************************************************************
 * Copyright(C) 2017, HeiLongJiang TYW Co.,Ltd.
 *
 * @Filename:           NM.c
 *
 * @Description:        AutoSar Net Manage
 *
 * @Functions List:
 *
 *
 * @History:            Version:        V0.0.1
                    Date:
                            Author:         myliu
                            Modification:  creat
 **********************************************************************************************************/

/**********************************************************************************************************
 * Include
*/
#include "Include.h"
#include "NM_Protocol.h"

/**********************************************************************************************************
 * Constants
 */


/**********************************************************************************************************
 * Local variables
 */
static NM_Mode_t                  NMMode                = Bus_Sleep_Mode;
static NM_Event_List_t            NMEventReq            = {0};
static NetworkMode_State_t        NetworkModeState      = Repeat_Message_State;
static unsigned   char                    NM_MessageCycle_Count = 0u;
static NM_Wakeup_Reasons_t        NMWakeupReason        = NM_Default;
static Network_Request_Reasons_t  NMStayawakeupReason   = NM_NOT_AWAKE;

/*Timer State*/
static NM_Timer_State_t NMTimerState = {0};
/*Timer Counter*/
static unsigned  long  NM_Trms_Counter;
static unsigned  long  NM_Tnm_Counter;
static unsigned  long  NM_Twbs_Counter;
static unsigned  long  NM_Ticyc_Counter;
static unsigned  long  NM_Tcyc_Counter;
static unsigned  long  NM_Tdiag_Counter;

/**********************************************************************************************************
 * Local functions
 */
static void CanNm_CutNetworkMode ( void );
static void CanNm_NetworkMode_Service ( void );
static void CanNm_Repeat_Message_Sevice ( void );
static void CanNm_Normal_Operation_Sevice ( void );
static void CanNm_Ready_Sleep_Sevice ( void );;
static void CanNm_ClearEvent ( void );

/**********************************************************************************************************
 * Defines
 */
/*Condition*/
#define NM_CONDITION_1              NMEventReq.Bits.Network_Requested
#define NM_CONDITION_2              NMEventReq.Bits.Succ_Recv_NMPDU
#define NM_CONDITION_3              NMEventReq.Bits.Succ_Trans_NMPDU
#define NM_CONDITION_4              NMEventReq.Bits.NM_Trms_Timeout
#define NM_CONDITION_5              NMEventReq.Bits.Network_Released
#define NM_CONDITION_6              NMEventReq.Bits.NM_Tnm_Timeout
#define NM_CONDITION_7              NMEventReq.Bits.Repeat_Msg_Bit_Recv
#define NM_CONDITION_8              NMEventReq.Bits.NM_Twbs_Timeout
#define NM_CONDITION_9              NMEventReq.Bits.NM_Repeat_Msg_Req
#define NM_CONDITION_10             NMEventReq.Bits.NM_Ticyc_Timeout
#define NM_CONDITION_11             NMEventReq.Bits.NM_Tcyc_Timeout

/*Action*/
#define NM_ACTION_1                 NMReStartTimer(NM_Trms_Timer);

#define NM_ACTION_2                 NMReStartTimer(NM_Tnm_Timer);

#define NM_ACTION_3                 D_Offline();                      \
    NMReStartTimer(NM_Twbs_Timer);    \
    NMMode = Pre_Bus_Sleep_Mode;

#define NM_ACTION_4                 CanNm_Data_Request(NMWakeupReason, NMStayawakeupReason);

#define NM_ACTION_5                 NMStopTimer(NM_Ticyc_Timer);      \
    NMStopTimer(NM_Tcyc_Timer);

#define NM_ACTION_6                 CanNm_ClearEvent();               \
    D_Init(BusSleep);                 \
    D_Offline();                      \
    NMMode = Bus_Sleep_Mode;

#define NM_ACTION_7                 NMStopTimer(NM_Tcyc_Timer);       \
    NMReStartTimer(NM_Ticyc_Timer);

#define NM_ACTION_8                 NM_MessageCycle_Count = 1u;        \
    NMStopTimer(NM_Ticyc_Timer);
/*NMReStartTimer(NM_Tcyc_Timer);*/

/**********************************************************************************************************
 * Global variables
 */

/**********************************************************************************************************
 * Global functions
 */


/**********************************************************************************************************
 *@Function:            NM_Timer_Service
 *@Description:       жʱжʹܵĶʱǷʱ.
 *@Input:                 none.
 *@Output:              none.
 *@Calls:                   none.
 *@Return:              none.
 *@Note:                    жAPI_ISRе.
 **********************************************************************************************************/
void CanNm_Timer_Service ( unsigned  long API_Cycle )
{
    /*T_REPEAT_MESSAGE*/
    if ( NMTimerState.NM_Trms_Enable )
    {
        NM_Trms_Counter += API_Cycle;
        if ( NM_Trms_Counter >= T_REPEAT_MESSAGE )
        {
            NM_Trms_Counter = 0u;
            NMTimerState.NM_Trms_Timeout = 1u;
            CanNm_TimeroutRequest ( NM_Trms_Timer );
        }
    }
    /*T_NM_TIMEOUT*/
    if ( NMTimerState.NM_Tnm_Enable )
    {
        NM_Tnm_Counter += API_Cycle;
        if ( NM_Tnm_Counter >= T_NM_TIMEOUT )
        {
            NM_Tnm_Counter = 0u;
            NMTimerState.NM_Tnm_Timeout = 1u;
            CanNm_TimeroutRequest ( NM_Tnm_Timer );
        }
    }
    /*T_WAIT_BUS_SLEEP*/
    if ( NMTimerState.NM_Twbs_Enable )
    {
        NM_Twbs_Counter += API_Cycle;
        if ( NM_Twbs_Counter >= T_WAIT_BUS_SLEEP )
        {
            NM_Twbs_Counter = 0u;
            NMTimerState.NM_Twbs_Timeout = 1u;
            CanNm_TimeroutRequest ( NM_Twbs_Timer );
        }
    }
    /*T_NM_ImmediateCycleTime*/
    if ( NMTimerState.NM_Ticyc_Enable )
    {
        NM_Ticyc_Counter += API_Cycle;
        if ( NM_Ticyc_Counter >= T_NM_ImmediateCycleTime )
        {
            NM_Ticyc_Counter = 0u;
            NMTimerState.NM_Ticyc_Timeout = 1u;
            CanNm_TimeroutRequest ( NM_Ticyc_Timer );
        }

    }
    /*T_NM_MessageCycle*/
    if ( NMTimerState.NM_Tcyc_Enable )
    {
        NM_Tcyc_Counter += API_Cycle;
        if ( NM_Tcyc_Counter >= T_NM_MessageCycle )
        {
            NM_Tcyc_Counter = 0u;
            NMTimerState.NM_Tcyc_Timeout = 1u;
            CanNm_TimeroutRequest ( NM_Tcyc_Timer );
        }
    }

    /*T_NM_MessageCycle*/
    if ( NMTimerState.NM_Tdiag_Enable )
    {
        NM_Tdiag_Counter += API_Cycle;
        if ( NM_Tdiag_Counter >= T_DIAG_TIMEOUT )
        {
            NM_Tdiag_Counter = 0u;
            NMTimerState.NM_Tdiag_Timeout = 1u;
        }
    }
}

/**********************************************************************************************************
 *@Function:          NMStartTimer
 *@Description:     ·Ķʱ.
 *@Input:               NMTimerName_t TimerName -- ʱ.
 *@Output:            none.
 *@Calls:               none.
 *@Return:            none.
 *@Note:                none.
 **********************************************************************************************************/
void NMReStartTimer ( NM_Timer_Name_t NMTimerName )
{
    switch ( NMTimerName )
    {
    case NM_Trms_Timer:
        NMTimerState.NM_Trms_Enable = 1u;
        NM_Trms_Counter = 0u;
        break;

    case NM_Tnm_Timer:
        NMTimerState.NM_Tnm_Enable = 1u;
        NM_Tnm_Counter = 0u;
        break;

    case NM_Twbs_Timer:
        NMTimerState.NM_Twbs_Enable = 1u;
        NM_Twbs_Counter = 0u;
        break;

    case NM_Ticyc_Timer:
        NMTimerState.NM_Ticyc_Enable = 1u;
        NM_Ticyc_Counter = 0u;
        break;

    case NM_Tcyc_Timer:
        NMTimerState.NM_Tcyc_Enable = 1u;
        NM_Tcyc_Counter = 0u;
        break;

    case NM_Tdiag_Timer:
        NMTimerState.NM_Tdiag_Enable = 1u;
        NM_Tdiag_Counter = 0u;
        break;

    default:
        break;
    }

    return;
}

/**********************************************************************************************************
 *@Function:          NMStopTimer
 *@Description:     ȡ·Ķʱ.
 *@Input:               NMTimerName_t TimerName -- ʱ.
 *@Output:            none.
 *@Calls:               none.
 *@Return:            none.
 *@Note:                none.
 **********************************************************************************************************/
void NMStopTimer ( NM_Timer_Name_t NMTimerName )
{
    switch ( NMTimerName )
    {
    case NM_Trms_Timer:
        NMTimerState.NM_Trms_Enable = 0u;
        break;

    case NM_Tnm_Timer:
        NMTimerState.NM_Tnm_Enable = 0u;
        break;

    case NM_Twbs_Timer:
        NMTimerState.NM_Twbs_Enable = 0u;
        break;

    case NM_Ticyc_Timer:
        NMTimerState.NM_Ticyc_Enable = 0u;
        break;

    case NM_Tcyc_Timer:
        NMTimerState.NM_Tcyc_Enable = 0u;
        break;

    case NM_Tdiag_Timer:
        NMTimerState.NM_Tdiag_Enable = 0u;
        break;

    default:
        break;
    }

    return;
}

/**********************************************************************************************************
 *@Function:          IsNMTimerOut
 *@Description:     ѯNMʱǷʱ.
 *@Input:               NMTimerName_t TimerName -- ʱ.
 *@Output:            none.
 *@Calls:               none.
 *@Return:            none.
 *@Note:                none.
 **********************************************************************************************************/
unsigned   char IsNMTimerOut ( NM_Timer_Name_t NMTimerName )
{
    unsigned   char TimeoutFlag = 0u;

    switch ( NMTimerName )
    {
    case NM_Trms_Timer:
        TimeoutFlag = NMTimerState.NM_Trms_Timeout;
        NMTimerState.NM_Trms_Timeout = 0u;
        break;

    case NM_Tnm_Timer:
        TimeoutFlag = NMTimerState.NM_Tnm_Timeout;
        NMTimerState.NM_Tnm_Timeout = 0u;
        break;

    case NM_Twbs_Timer:
        TimeoutFlag = NMTimerState.NM_Twbs_Timeout;
        NMTimerState.NM_Twbs_Timeout = 0u;
        break;

    case NM_Ticyc_Timer:
        TimeoutFlag = NMTimerState.NM_Ticyc_Timeout;
        NMTimerState.NM_Ticyc_Timeout = 0u;
        break;

    case NM_Tcyc_Timer:
        TimeoutFlag = NMTimerState.NM_Tcyc_Timeout;
        NMTimerState.NM_Tcyc_Timeout = 0u;
        break;

    case NM_Tdiag_Timer:
        TimeoutFlag = NMTimerState.NM_Tdiag_Timeout;
        NMTimerState.NM_Tdiag_Timeout = 0u;
        break;

    default:
        break;
    }

    return TimeoutFlag;
}
/**********************************************************************************************************
 *@Function:        CanNm_Init
 *@Description: ʼ·㣬رӦͨţóʼ״̬Ϊ˯.
 *@Input:           none.
 *@Output:        none.
 *@Calls:             D_Init / D_Offline.
 *@Return:        none..
 *@Note:              же.
 **********************************************************************************************************/
void CanNm_Init ( void )
{
    D_Init ( BusInit );
    D_Offline();
    NMEventReq.Words = 0u;
    NMStopTimer ( NM_Trms_Timer );
    NMStopTimer ( NM_Tnm_Timer );
    NMStopTimer ( NM_Twbs_Timer );
    NMStopTimer ( NM_Ticyc_Timer );
    NMStopTimer ( NM_Tcyc_Timer );
    D_Init ( BusSleep );
    NMMode = Bus_Sleep_Mode;
    NM_Init_AppTimer();
}

/**********************************************************************************************************
 *@Function:        CanNm_NetworkRequest
 *@Description: ͨţһӦò.
 *@Input:           none.
 *@Output:        none.
 *@Calls:             none.
 *@Return:        none..
 *@Note:              none.
 **********************************************************************************************************/
void CanNm_NetworkRequest ( Network_Request_Reasons_t StayawakeReason )
{
    if ( StayawakeReason == NM_REQ_DIAG_RECVD )
    {
        if ( ( NMMode != Network_Mode ) || ( NetworkModeState != Ready_Sleep_State ) )
        {

        }
        else
        {
            NM_CONDITION_1 = 1u;
            NM_CONDITION_5 = 0u;

            NMStayawakeupReason = StayawakeReason;
        }
    }
    else
    {
        NM_CONDITION_1 = 1u;
        NM_CONDITION_5 = 0u;

        NMStayawakeupReason = StayawakeReason;
    }


}

/**********************************************************************************************************
 *@Function:        CanNm_NetworkRelease
 *@Description: ͷ磬ͬ˯ߣһIGN_OFFޱµ.
 *@Input:           none.
 *@Output:        none.
 *@Calls:             none.
 *@Return:        none..
 *@Note:              none.
 **********************************************************************************************************/
void CanNm_NetworkRelease ( Network_Release_Reasons_t ReleaseReason )
{
	if ( ReleaseReason == NM_REQ_DIAG_TIMEOUT )
	{
		if ( NMStayawakeupReason == NM_REQ_KL15_ON )
		{

		}
		else
		{
			NM_CONDITION_5 = 1u;
			NM_CONDITION_1 = 0u;
			NMStayawakeupReason = NM_NOT_AWAKE;
		}
	}
	else if (ReleaseReason == NM_REQ_KL15_OFF)
	{
		if (NMStayawakeupReason == NM_REQ_DIAG_RECVD)
		{

		}
		else
		{
			NM_CONDITION_5 = 1u;
			NM_CONDITION_1 = 0u;
			NMStayawakeupReason = NM_NOT_AWAKE;
		}
	}
	else
	{
		NM_CONDITION_5 = 1u;
		NM_CONDITION_1 = 0u;
		NMStayawakeupReason = NM_NOT_AWAKE;
	}
}

/**********************************************************************************************************
 *@Function:        CanNm_RecvNMPDUInd
 *@Description: ʾյ·ģһ·.
 *@Input:           CANMsg402_t *pCanNmMsg -- .
 *@Output:        none.
 *@Calls:             none.
 *@Return:        none..
 *@Note:              none.
 **********************************************************************************************************/
void CanNm_RecvNMPDUInd ( unsigned   char m_CanNmMsg[ ] )
{
	unsigned   char i;
	CANNmMsg_t pCanNmMsg;
	NM_CONDITION_2 = 1u;


	for (i = 0u; i < 8u; i++)
	{
		pCanNmMsg.Msg[i] = m_CanNmMsg[i];
	}


	if ( ( NMMode == Network_Mode ) && ( ( NetworkModeState == Ready_Sleep_State ) || ( NetworkModeState == Normal_Operation_State ) ) )
	{
		if ( pCanNmMsg.Sig.ICU_RMR0 )
		{
			NM_CONDITION_7 = 1u;
		}
	}
}

/**********************************************************************************************************
 *@Function:        CanNm_TransNMPDUInd
 *@Description: ʾѾɹ·ģһ·.
 *@Input:           none.
 *@Output:        none.
 *@Calls:             none.
 *@Return:        none..
 *@Note:              none.
 **********************************************************************************************************/
void CanNm_TransNMPDUInd ( void )
{
	NM_CONDITION_3 = 1u;
}

/**********************************************************************************************************
 *@Function:        CanNm_RepeatMessageRequest
 *@Description: ظ״̬һڵʹãǱڴӽڵ㣬һ㲻.
 *@Input:           none.
 *@Output:        none.
 *@Calls:             none.
 *@Return:        none..
 *@Note:              none.
 **********************************************************************************************************/
void CanNm_RepeatMessageRequest ( void )
{
	NM_CONDITION_9 = 1u;
}

/**********************************************************************************************************
 *@Function:        CanNm_TimeroutRequest
 *@Description: ʱ糬ʱ¼.
 *@Input:           none.
 *@Output:        none.
 *@Calls:             none.
 *@Return:        none..
 *@Note:              ʱ.
 **********************************************************************************************************/
void CanNm_TimeroutRequest ( NM_Timer_Name_t NMTimerName )
{
	switch ( NMTimerName )
	{
		case NM_Trms_Timer:
			NM_CONDITION_4 = 1u;
		break;

		case NM_Tnm_Timer:
			NM_CONDITION_6 = 1u;
		break;

		case NM_Twbs_Timer:
			NM_CONDITION_8 = 1u;
		break;

		case NM_Ticyc_Timer:
			NM_CONDITION_10 = 1u;
		break;

		case NM_Tcyc_Timer:
			NM_CONDITION_11 = 1u;
		break;

		default:
		break;
	}

	return;
}

/**********************************************************************************************************
 *@Function:        CanNm_GetStatus
 *@Description: ȡǰҪģʽ˯ߣѣ˯ǰ׼
 *@Input:           none.
 *@Output:        none.
 *@Calls:             none.
 *@Return:        NM_Mode_t Mode -- 統ǰģʽ.
 *@Note:              һɵԴã˯״̬󣬵ԴԽ͹ģʽ.
 **********************************************************************************************************/
NM_Mode_t CanNm_GetMode ( void )
{
    return NMMode;
}

/**********************************************************************************************************
 *@Function:        CanNm_GetState
 *@Description: ȡǰ״̬Ҫ߻ǻ.
 *@Input:           none.
 *@Output:        none.
 *@Calls:             none.
 *@Return:        NetworkMode_State_t Mode -- 統ǰ״̬.
 *@Note:              ͱʱҪ״̬.
 **********************************************************************************************************/
NetworkMode_State_t CanNm_GetState ( void )
{
    return NetworkModeState;
}

/**********************************************************************************************************
 *@Function:        CanNm_Service
 *@Description: 񣬽״̬л.
 *@Input:           none.
 *@Output:        none.
 *@Calls:             CanNm_NetworkMode_Service.
 *@Return:        none..
 *@Note:              һ1msһΣʱҪԴ˺Ҫжϵ.
 **********************************************************************************************************/
void CanNm_Service ( void )
{
	switch ( NMMode )
	{
		case Bus_Sleep_Mode:
		/*NM_Clr_AliveCnt();*/
		if (( NM_CONDITION_1 ) || ( NM_CONDITION_2 ))
		{
			D_Init ( BusAwake );
			NM_ACTION_1
			NM_ACTION_2
			NM_Init_AppTimer();
			if ( NM_CONDITION_1 )
			{
				NMWakeupReason = NM_KL15;
				NM_ACTION_4
				NM_ACTION_7
			}
			else
			{
				NM_CONDITION_2 = 0u;
				NM_CONDITION_7 = 0u;
				NMWakeupReason = NM_PDU_Received;
				NM_ACTION_4
				NM_ACTION_8
				NMReStartTimer ( NM_Tcyc_Timer );
			}

			CanNm_CutNetworkMode();
		}
		break;

		case Pre_Bus_Sleep_Mode:
		if (( NM_CONDITION_1) || (NM_CONDITION_2 ) )
		{
			NM_ACTION_1
			NM_ACTION_2
			if ( NM_CONDITION_1 )
			{
				NMWakeupReason = NM_KL15;
				NM_ACTION_4
				NM_ACTION_7
			}
			else
			{
				NM_CONDITION_2 = 0u;
				NM_CONDITION_7 = 0u;
				NMWakeupReason = NM_PDU_Received;
				NM_ACTION_4
				NM_ACTION_8
				NMReStartTimer ( NM_Tcyc_Timer );
			}
			NM_CONDITION_8 = 0u;
			NMStopTimer ( NM_Twbs_Timer );
			CanNm_CutNetworkMode();
		}
		else if ( NM_CONDITION_8 )
		{
			NM_CONDITION_8 = 0u;
			NM_ACTION_6
		}
		else
		{

		}
		break;

		case Network_Mode:
		if (( NM_CONDITION_2 ) || ( NM_CONDITION_3 ))
		{
			NM_CONDITION_2 = 0u;
			NM_CONDITION_3 = 0u;
			NM_ACTION_2
			D_Online();
		}
		CanNm_NetworkMode_Service();
		break;

		default:
		break;
	}

	return;
}

/**********************************************************************************************************
 *@Function:        CanNm_NetworkMode_Service
 *@Description: ģʽ·.
 *@Input:           none.
 *@Output:        none.
 *@Calls:             CanNm_Repeat_Message_Sevice / CanNm_Normal_Operation_Sevice / CanNm_Ready_Sleep_Sevice.
 *@Return:        none..
 *@Note:              же.
 **********************************************************************************************************/
static void CanNm_NetworkMode_Service ( void )
{
	switch ( NetworkModeState )
	{
		case Repeat_Message_State:
			CanNm_Repeat_Message_Sevice();
		break;

		case Normal_Operation_State:
			CanNm_Normal_Operation_Sevice();
		break;

		case Ready_Sleep_State:
			CanNm_Ready_Sleep_Sevice();
		break;

		default:
		break;
	}

	return;
}

/**********************************************************************************************************
 *@Function:        CanNm_Repeat_Message_Sevice
 *@Description: Repeat Message State.
 *@Input:           none.
 *@Output:        none.
 *@Calls:             NM_ACTION_2 / NM_ACTION_4 / NM_ACTION_5 / NM_ACTION_7 / NM_ACTION_8.
 *@Return:        none.
 *@Note:              ڲ.
 **********************************************************************************************************/
static void CanNm_Repeat_Message_Sevice ( void )
{
	if ( NM_CONDITION_6 )
	{
		NM_CONDITION_6 = 0u;
		NM_ACTION_2
	}
	else if (( NM_CONDITION_1 ) &&  ( NM_CONDITION_4 ))
	{
		NM_CONDITION_4 = 0u;
		NMStopTimer ( NM_Trms_Timer );
		/*        NMWakeupReason = NM_KL15;
		NM_ACTION_4*/
		NM_ACTION_8
		/*NMReStartTimer ( NM_Tcyc_Timer );*/
		NetworkModeState = Normal_Operation_State;
	}
	else if (( NM_CONDITION_4 ) && ( NM_CONDITION_5 ))
	{
		NM_CONDITION_4 = 0u;
		NMStopTimer ( NM_Trms_Timer );
		NM_ACTION_5
		NetworkModeState = Ready_Sleep_State;
	}
	else if ( NM_CONDITION_10 )
	{
		NM_CONDITION_10 = 0u;
		NM_MessageCycle_Count++;
		NM_ACTION_4
		if ( NM_MessageCycle_Count < N_ImmediateNM_TIMES )
		{
			NM_ACTION_7
		}
		else
		{
			NM_ACTION_8
			NMReStartTimer ( NM_Tcyc_Timer );
		}
	}
	else if ( NM_CONDITION_11 )
	{
		NM_CONDITION_11 = 0u;
		NM_ACTION_4
		NM_ACTION_8
		NMReStartTimer ( NM_Tcyc_Timer );
	}
	else
	{

	}
}

/**********************************************************************************************************
 *@Function:        CanNm_Normal_Operation_Sevice
 *@Description: Normal Operation State.
 *@Input:           none.
 *@Output:        none.
 *@Calls:             NM_ACTION_1 / NM_ACTION_2 / NM_ACTION_4 / NM_ACTION_5 / NM_ACTION_7 / NM_ACTION_8.
 *@Return:        none.
 *@Note:              ڲ.
 **********************************************************************************************************/
static void CanNm_Normal_Operation_Sevice ( void )
{
	if ( NM_CONDITION_6 )
	{
		NM_CONDITION_6 = 0u;
		NM_ACTION_2
	}
	else if (( NM_CONDITION_7 ) || (NM_CONDITION_9 ))
	{
		/*NMWakeupReason = NM_PDU_Received;*/
		NetworkModeState = Repeat_Message_State;
		NM_ACTION_1
		NM_ACTION_4
		if ( NM_CONDITION_7 )
		{
			NM_CONDITION_7 = 0u;
			NMReStartTimer ( NM_Tcyc_Timer );
			/*NM_ACTION_7*/
		}
		else
		{
			NM_CONDITION_9 = 0u;
			NM_ACTION_8
			NMReStartTimer ( NM_Tcyc_Timer );
		}
	}
	else if ( NM_CONDITION_5 )
	{
		NM_ACTION_5
		NM_ACTION_2
		NetworkModeState = Ready_Sleep_State;
	}
	else if ( NM_CONDITION_10 )
	{
		NM_CONDITION_10 = 0u;
		NM_MessageCycle_Count++;
		NM_ACTION_4
		if ( NM_MessageCycle_Count < N_ImmediateNM_TIMES )
		{
			NM_ACTION_7
		}
		else
		{
			NM_ACTION_8
			NMReStartTimer ( NM_Tcyc_Timer );
		}
	}
	else if ( NM_CONDITION_11 )
	{
		NM_CONDITION_11 = 0u;
		NM_ACTION_4
		NM_ACTION_8
		NMReStartTimer ( NM_Tcyc_Timer );
	}
	else
	{

	}
}

/**********************************************************************************************************
 *@Function:        CanNm_Ready_Sleep_Sevice
 *@Description: Ready Sleep State.
 *@Input:           none.
 *@Output:        none.
 *@Calls:             NM_ACTION_2 / NM_ACTION_4 / NM_ACTION_5 / NM_ACTION_7 / NM_ACTION_8.
 *@Return:        none.
 *@Note:              ڲ.
 **********************************************************************************************************/
static void CanNm_Ready_Sleep_Sevice ( void )
{
	if ( NM_CONDITION_1 )
	{
		/*if(NMStayawakeupReason == NM_REQ_KL15_ON)
		NMWakeupReason = NM_KL15;
		else
		NMWakeupReason = NM_Default;*/

		NetworkModeState = Normal_Operation_State;
		NM_ACTION_4
		NM_ACTION_8
		NMReStartTimer ( NM_Tcyc_Timer );
	}
	else if (( NM_CONDITION_7) || (NM_CONDITION_9 ))
	{
		/*NMWakeupReason = NM_PDU_Received;*/
		NetworkModeState = Repeat_Message_State;
		NM_ACTION_4
		if ( NM_CONDITION_7 )
		{
			NM_CONDITION_7 = 0u;
			NMReStartTimer ( NM_Tcyc_Timer );
			/*NM_ACTION_7*/
		}
		else
		{
			NM_CONDITION_9 = 0u;
			NM_ACTION_8
			NMReStartTimer ( NM_Tcyc_Timer );
		}
		NM_ACTION_1
	}
	else if ( NM_CONDITION_6 )
	{
		NM_CONDITION_6 = 0u;
		NM_ACTION_3
	}
	else
	{
	}
}

/**********************************************************************************************************
 *@Function:            CanNm_CutNetworkMode
 *@Description:       жʱжʹܵĶʱǷʱ.
 *@Input:                 none.
 *@Output:              none.
 *@Calls:                   none.
 *@Return:              none..
 *@Note:                    ڲ.
 **********************************************************************************************************/
static void CanNm_CutNetworkMode ( void )
{
	NM_MessageCycle_Count = 1u;
	NetworkModeState = Repeat_Message_State;
	NMMode = Network_Mode;
}

/**********************************************************************************************************
 *@Function:            CanNm_ClearEvent
 *@Description:       ˯ǰ¼ͷ⣩.
 *@Input:                 none.
 *@Output:              none.
 *@Calls:                   none.
 *@Return:              none..
 *@Note:                    ڲ.
 **********************************************************************************************************/
static void CanNm_ClearEvent ( void )
{
	/*Clear Event Req*/
	NM_CONDITION_2 = 0u;
	NM_CONDITION_3 = 0u;
	NM_CONDITION_4 = 0u;
	NM_CONDITION_6 = 0u;
	NM_CONDITION_7 = 0u;
	NM_CONDITION_8 = 0u;
	NM_CONDITION_9 = 0u;

	/*Stop Timer*/
	NMStopTimer ( NM_Trms_Timer );
	NMStopTimer ( NM_Tnm_Timer );
	NMStopTimer ( NM_Twbs_Timer );
}
/*ȡǰ汾汾*/

/* *pCanNmMsg ޸Ϊ pCanNmMsg ʹָ   02汾*/
/* busoff²ٷrepeat msgź ʹָ   03汾*/
unsigned  long CanNM_Read_Verison(void)
{
	unsigned  long Verison;
	Verison =0x00000003; /* *pCanNmMsg ޸Ϊ pCanNmMsg ʹָ */
	return Verison;
}
/**********************************************************************************************************
 **********************************************************************************************************/

