

#ifndef _GAUGES_H_
#define _GAUGES_H_

#include "Motor.h"
//#include "VID_Motor.h"

#define Num_Of_Piecewise_Linear_App 4

typedef   unsigned   char       INT8U; 
typedef   unsigned   int     INT16U; 
typedef   unsigned  long     INT32U; 


typedef struct
{
	INT16U Physical_Quantity[8]; //һ���ǵ�����
	INT16U MicroStep[8];		 //һ���ǵ�����
	INT8U Parameter_Num;
} _GaugesInfo;


EXTERN _GaugesInfo MeterInfo[Num_Of_Piecewise_Linear_App];

typedef struct  
{
    workMode_t      workMode_Motor1;
    workMode_t      workMode_Motor2;
    workMode_t      workMode_Motor3;
    workMode_t      workMode_Motor4;
    uint8_t         *MotorLib_Version;
} Motor_Struct;

EXTERN Motor_Struct     Motor;  

EXTERN uint8_t HalfSelfSts;

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
 void MeterInfo_Init(void);	  
 void Motor_SelfCheck(void);
 void App_Get_Motor_Status(void);
 void Motor_Init_Poweron_IGN(void);
 void Motor_IGNOFF(void);
 void App_SetMotorStep(uint16_t Physical_Data,uint8_t index);
 void Motor_Init_Poweron_System(void);
 INT8U App_FindSector(INT16U Physical_Data, INT8U Index);
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

 void Gauges_Management_Service(void);
 void Gauges_Sleep_Init(void);
 void Gauges_Wake_Up_Init(void);




#endif