#include "COM_CAN.h"
#include "UDS_Common.h"
#include "CAN_CH0_CAN_Communication_Matrix.h"
#include "include.h"
#include "UDS_Common.h"
//#include "IC_Configuration.h"

//#include "RTE_CAN.h"
#include "TYW_stdint.h"
//#include <string.h>
//#include <EOL_Para.h>
//#include <DataProcess_Common.h>
//#include <CAN_Signal_Select.h>


#pragma alignvar(8)

uint32_t pRXBuff_CH0[CAN_RX_MSG_Block * CAN_CH0_ID_TOTAL_MAX];
uint32_t pTXBuff[CAN_TX_MSG_Block * CAN_CH0_ID_SEND_TOTAL]; 

uint8_t COM_APP_Process(st_CAN_Msg *Msg);

void COM_CAN_Init(void)
{
    /*CAN APP BUFFER INIT*/    
    memset(pRXBuff_CH0,0,sizeof(pRXBuff_CH0));
    CAN_CH0_CanMsgOp.CAN_MSG_Analysis = ( st_CANMsgStruct * )pRXBuff_CH0;
    Can_RX_BuffInit(&CAN_CH0_CanMsgOp, CAN_CH0_CAN_MSG_CONST_ARRAY, CAN_CH0_ID_TOTAL_MAX);


    memset(pTXBuff, 0, sizeof(pTXBuff)); 
    CAN_CH0_CanMsgTxOp.CanMsg = pTXBuff;
    Can_TX_BuffInit(&CAN_CH0_CanMsgTxOp, CAN_CH0_CANSendAttr, CAN_CH0_ID_SEND_TOTAL, COM_APP_Process);
    CAN_TX_SetEnable(&CAN_CH0_CanMsgTxOp, CAN_N_TX_Enable); 
}

void TXCANKL30WakeupInit(void)
{
    memset(pTXBuff, 0, sizeof(pTXBuff)); 
    CAN_CH0_CanMsgTxOp.CanMsg = pTXBuff; 
    Can_TX_BuffInit(&CAN_CH0_CanMsgTxOp, CAN_CH0_CANSendAttr, CAN_CH0_ID_SEND_TOTAL, COM_APP_Process);
    CAN_TX_SetEnable(&CAN_CH0_CanMsgTxOp, CAN_N_TX_Enable); 
}

void TXCANKL15Init(void)
{
    memset(pTXBuff, 0, sizeof(pTXBuff)); 
    CAN_CH0_CanMsgTxOp.CanMsg = pTXBuff; 
    Can_TX_BuffInit(&CAN_CH0_CanMsgTxOp, CAN_CH0_CANSendAttr, CAN_CH0_ID_SEND_TOTAL, COM_APP_Process);
    CAN_TX_SetEnable(&CAN_CH0_CanMsgTxOp, CAN_N_TX_Enable); 
}



void COM_RX_Process(void)
{
    if(AnalogKL30Voltage <= 9000)
    {
        return;
    }
    else
    {
        CanMSg_XMS_Analysis(&CAN_CH0_CanMsgOp, 10u);
    }
    
}


void COM_TX_Process(void)
{
    if(AnalogKL30Voltage <= 9000)
    {
        return;
    }
    else
    {
  		if((CAN_Control.APP_TX_Enable & APP_Enable) == APP_Enable)
  		{
  			Can_Write_Fun(&CAN_CH0_CanMsgTxOp, 1000u);
  		}
    }
    
}

uint8_t COM_APP_Process(st_CAN_Msg *Msg)
{
    //Can_Write(0U, (_CAN_Msg *)Msg);
    if(AnalogKL30Voltage <= 9000)
    {
        return;
    }
    else
    {
       if((CAN_Control.APP_TX_Enable & APP_Enable) == APP_Enable)
        {
            CAN0_TX_BUF_Set(Msg->Msg, Msg->MsgID, Msg->MsgDLC);	
        } 
    }
    
    
    return 0u;
}