#ifndef PAGE_TYPE_H__
#define PAGE_TYPE_H__

#define SelfCheckTime 30
typedef enum
{
    Page_SelfCheck = 0,
    Page_Alarm,
    Page_Menu,
    Page_OTA,
    Page_Max,
}_Page_Type_Enum;

#define Config1_TPMS_NotLearnt ((Left_Front_Display.System_Flt == 3)||(Left_Rear_Display.System_Flt == 3)||(Left_Rear_Inside_Display.System_Flt == 3)||(Right_Front_Display.System_Flt == 3)||(Right_Rear_Display.System_Flt == 3)||(Right_Rear_Inside_Display.System_Flt == 3))

#define Config1_Sensor_Loss  ((Left_Front_Display.Sensor_Loss == 1)||(Left_Rear_Display.Sensor_Loss == 1)||(Left_Rear_Inside_Display.Sensor_Loss == 1)||(Right_Front_Display.Sensor_Loss == 1)||(Right_Rear_Display.Sensor_Loss == 1)||(Right_Rear_Inside_Display.Sensor_Loss == 1))

#define Config1_Sensor_Fault  ((Left_Front_Display.Sensor_Flt == 1)||(Left_Rear_Display.Sensor_Flt == 1)||(Left_Rear_Inside_Display.Sensor_Flt == 1)||(Right_Front_Display.Sensor_Flt == 1)||(Right_Rear_Display.Sensor_Flt == 1)||(Right_Rear_Inside_Display.Sensor_Flt == 1))

#define Config1_TPMS_Low  ((Left_Front_Display.Press_St == 1)||(Left_Rear_Display.Press_St == 1)||(Left_Rear_Inside_Display.Press_St == 1)||(Right_Front_Display.Press_St == 1)||(Right_Rear_Display.Press_St == 1)||(Right_Rear_Inside_Display.Press_St == 1))

#define Config1_TPMS_High  ((Left_Front_Display.Press_St == 2)||(Left_Rear_Display.Press_St == 2)||(Left_Rear_Inside_Display.Press_St == 2)||(Right_Front_Display.Press_St == 2)||(Right_Rear_Display.Press_St == 2)||(Right_Rear_Inside_Display.Press_St == 2))

#define Config1_TPMS_Leak  ((Left_Front_Display.Fast_Press == 1)||(Left_Rear_Display.Fast_Press == 1)||(Left_Rear_Inside_Display.Fast_Press == 1)||(Right_Front_Display.Fast_Press == 1)||(Right_Rear_Display.Fast_Press == 1)||(Right_Rear_Inside_Display.Fast_Press == 1))

#define Config1_Temp_High  ((Left_Front_Display.Temp_St == 1)||(Left_Rear_Display.Temp_St == 1)||(Left_Rear_Inside_Display.Temp_St == 1)||(Right_Front_Display.Temp_St == 1)||(Right_Rear_Display.Temp_St == 1)||(Right_Rear_Inside_Display.Temp_St == 1))

#define Config1_Bat_Low  ((Left_Front_Display.BatLow_St == 1)||(Left_Rear_Display.BatLow_St == 1)||(Left_Rear_Inside_Display.BatLow_St == 1)||(Right_Front_Display.BatLow_St == 1)||(Right_Rear_Display.BatLow_St == 1)||(Right_Rear_Inside_Display.BatLow_St == 1))


#define Config2_TPMS_NotLearnt ((Left_Front_Display.System_Flt == 3)||(Right_Front_Display.System_Flt == 3))

#define Config2_Sensor_Loss  ((Left_Front_Display.Sensor_Loss == 1)||(Right_Front_Display.Sensor_Loss == 1))

#define Config2_Sensor_Fault  ((Left_Front_Display.Sensor_Flt == 1)||(Right_Front_Display.Sensor_Flt == 1))

#define Config2_TPMS_Low  ((Left_Front_Display.Press_St == 1)||(Right_Front_Display.Press_St == 1))

#define Config2_TPMS_High  ((Left_Front_Display.Press_St == 2)||(Right_Front_Display.Press_St == 2))

#define Config2_TPMS_Leak  ((Left_Front_Display.Fast_Press == 1)||(Right_Front_Display.Fast_Press == 1))

#define Config2_Temp_High  ((Left_Front_Display.Temp_St == 1)||(Right_Front_Display.Temp_St == 1))

#define Config2_Bat_Low  ((Left_Front_Display.BatLow_St == 1)||(Right_Front_Display.BatLow_St == 1)||(Right_Rear_Display.BatLow_St == 1)||(Right_Rear_Inside_Display.BatLow_St == 1))

#define DataAirPressEn (PageInfo.u16SelfCheckTimeCnt >= 30)

typedef enum
{
    MenuDispTPMS_PressHigh = 0u,
    MenuDispTPMS_PressLow,
    MenuDispTPMS_TempHigh,
    MenuDispTPMS_LeakFast,
    MenuDispTPMS_SensorBatteryLow,
    MenuDispTPMS_NotLearn,
    MenuDispTPMS_SensorFault,
    MenuDispTPMS_SensorLost,
    
    MenuDispTPMS_Normal,
    MenuDispTPMS_Max,
}_MenuDispTPMS_Info_Enum;





typedef struct 
{
    _MenuDispTPMS_Info_Enum MenuCurTpmsSts;
    uint8_t MenuTpmsTgr;
    uint16_t DispTimeCnt;
}_MenuDispTpmsCtrl_Struct;

extern _MenuDispTpmsCtrl_Struct MenuTpmsCtrl;
extern _MenuDispTpmsCtrl_Struct MenuTpmsCtrl_Backup;

typedef struct 
{
    _Page_Type_Enum PageType;
    unsigned char u8PagePowerSts;
    unsigned int u16SelfCheckTimeCnt;
}_Page_Info_Struct;

extern _Page_Info_Struct PageInfo;
extern _Page_Info_Struct DisplayInfor_BackUp;    //?????????

typedef enum
{
    KEY_Left = 0U,
    KEY_Right,
    KEY_Enter_Short,
    KEY_Enter_Long,
    KEY_None_5s,
    KEY_None_10s,
    KEY_None_20s,
    KEY_Value_Max,
}_Page_Key_Value_Enum;

//extern uint8_t Hint_MaskPopupNum ;
//extern uint8_t Hint_MaskPopupList[20u] ;

extern uint8_t MaskPopupNum ;
extern uint8_t MaskPopupNum_Backup;
extern uint16_t MaskPopupList[70u] ;
extern uint8_t MaskPopupCurIdx ;

extern uint8_t LDW_PriDisp_Sts;
extern uint8_t RADAR_PriDisp_Sts;
extern uint8_t LAST_SYS_OPR_STAT_HALT ;     





extern void Page_OFF_TO_ON_Init(void );
extern void Page_30KL_Init(void );
extern void Page_Manage_Service(void );
extern void Page_Manage_KeyCrl_Service(_Page_Key_Value_Enum key );
extern uint8_t Menu_Get_g1_SystemError( void );
extern void Menu_TPMS_Display_Service(void );



typedef enum
{
    OTA_HMI_1 = 0,
    OTA_HMI_2,
    OTA_HMI_3,
    OTA_HMI_4,
    OTA_HMI_5,
    OTA_HMI_6,
    OTA_HMI_7_PowerMode,
    OTA_HMI_7_GearPos,
    OTA_HMI_7_VehicleSpd,
    OTA_HMI_7_BattVol,
    OTA_HMI_7_HandBrake,
    OTA_HMI_7_ChgStatus,
    OTA_HMI_7_HVStatus,
    OTA_HMI_8,
    OTA_HMI_9,
    OTA_HMI_10,
    OTA_HMI_11,
    OTA_HMI_Max,
}OTA_HMI_INFO_ENUM;

typedef enum
{
    OTA_HMI_CURSOR_Confirm = 0,
    OTA_HMI_CURSOR_Concel,
    OTA_HMI_CURSOR_Max,
}OTA_HMI_CURSOR_ENUM;

typedef enum
{
    OTA_HMI_CountdownPos_Confirm = 0,
    OTA_HMI_CountdownPos_Concel,
    OTA_HMI_CountdownPos_Max,
}OTA_HMI_CountdownPos_ENUM;

typedef struct
{
    OTA_HMI_INFO_ENUM CurHMI;/*???OTA???��MAX??????OTA????*/

    OTA_HMI_CURSOR_ENUM Cursor;/*?????????????��???MAX?????��??*/
    uint8_t CursorNum;

    uint16_t Countdown; /*?????*/
    uint16_t CountdownTimeCnt;
    OTA_HMI_CountdownPos_ENUM CountdownPos; /*?????????????????????????*/

    uint8_t HMI_6_Displayed;

    //uint8_t MsgExpEn;
    //uint8_t MsgCnt;
    uint8_t DownLoadPercent;
    uint8_t Countdownflag;
}OTA_HMI_Ctrl_Struct;

extern OTA_HMI_Ctrl_Struct OTA_Ctrl;
extern OTA_HMI_Ctrl_Struct OTA_Ctrl_Backup;

typedef struct
{
    uint8_t IC_OTA_InfoShowStatus; 
	uint8_t IC_OTA_DownloadSelected;
	uint8_t IC_OTA_UpdateSelected;
	uint8_t IC_OTA_UpdateResultConfirm;
	uint8_t IC_OTA_DeclimerSelected;
    uint8_t IC_OTA_InfoShowStatus_Cnt;
    uint8_t IC_OTA_DownloadSelected_Cnt;
    uint8_t IC_OTA_UpdateSelected_Cnt;
    uint8_t IC_OTA_UpdateResultConfirm_Cnt;
	uint8_t IC_OTA_DeclimerSelected_Cnt;
}IC_OTA_Struct;
extern IC_OTA_Struct IC_OTA;


extern void OTA_Display_Info_KL15_30_Init(void);
extern void OTA_Detect(void);
//extern void OTA_MsgExport_Start(void );
//extern void OTA_MsgExport_Service(void );/*20ms????????*/


#endif