/******************************************************************************
�� �� ����TFT_LCD.h
����������TFT��ɫҺ����ʾ�����ƺ�����ͷ�ļ�
��    �ߣ�����
��    ����V1.0
��    �ڣ�2017.4.8
******************************************************************************/

#ifndef _TFT_LCD_H_
#define _TFT_LCD_H_

//#include "PWM.h"
//#include "TM035HFZGZx.h"
//#include "mapData.h"

/******************************************************************************
��ͼ����FIFO�������

˵��: ���û�ͼ������,��ͼ��������ȴ����FIFO��,�����ɺ�̨��ͼִ�к�����FIFO��
      ȡ����ͼ������ɻ�ͼ����.���ֻ��ƿ��������û������Ļ�ͼ��������õ��Ļ�
      ͼ�����е�ʱ�ӻ�Ӱ������ϵͳ����.
      
      ��ͼ����FIFO�����Ӧ���ݳ���������ͻ���Ե�������ͼ��������,��ӦԤ����һ
      ������.��ǳ��FIFO���ý��п��ܵ���ͻ���Ի�ͼ�п����������FIFO��������ʧ,
      ������Щ����û�б���Ӧ;�������FIFO������ᵼ���ڴ���˷�
******************************************************************************/
#define   TFT_LCD_REQ_FIFO_MAX_DEPTH        95
//#define   TFT_LCD_DRAW_MAX_DEPTH            160
/******************************************************************************
��ͼ����
******************************************************************************/
#define   TFT_LCD_TYPE_SET                  0x00
#define   TFT_LCD_TYPE_CLR                  0x01
#define   TFT_LCD_TYPE_INV                  0x02

/******************************************************************************
�������
******************************************************************************/
#define   TFT_LCD_FILL_NONE                 0x00
#define   TFT_LCD_FILL_FULL                 0x01

/******************************************************************************
��ͼ״̬
******************************************************************************/
#define   TFT_LCD_STATE_IDLE                0x00
#define   TFT_LCD_STATE_INIT                0x01
#define   TFT_LCD_STATE_DRAW                0x02
#define   TFT_LCD_STATE_TOP                 0x03
#define   TFT_LCD_STATE_MID                 0x04
#define   TFT_LCD_STATE_BOT                 0x05
#define   TFT_LCD_STATE_LEFT                0x06
#define   TFT_LCD_STATE_RIGHT               0x07
#define   TFT_LCD_STATE_VERTEX              0x08

/******************************************************************************
��ͼģʽ
******************************************************************************/
#define   TFT_LCD_MODE_IDLE                 0x00
#define   TFT_LCD_MODE_CLEAR                0x01
#define   TFT_LCD_MODE_DBMP                 0x02
#define   TFT_LCD_MODE_IBMP                 0x03
#define   TFT_LCD_MODE_DTBMP                0x04
#define   TFT_LCD_MODE_ITBMP                0x05
#define   TFT_LCD_MODE_PIXEL                0x06
#define   TFT_LCD_MODE_HLINE                0x07
#define   TFT_LCD_MODE_VLINE                0x08
#define   TFT_LCD_MODE_BBOX                 0x09
#define   TFT_LCD_MODE_DFBOX                0x0A
#define   TFT_LCD_MODE_IFBOX                0x0B
#define   TFT_LCD_MODE_TEST                 0x0C
/******************************************************************************
��Ļ�ֱ���
******************************************************************************/
#define   TFT_LCD_X_SIZE                    240
#define   TFT_LCD_Y_SIZE                    320

/******************************************************************************
�Ƿ�ѹ��
******************************************************************************/
#define   Compress                          1
#define   NotCompress                       0

/******************************************************************************
�Ƿ�ɫ��ʾ
******************************************************************************/
#define   Inverse                          1
#define   NotInverse                       0



/******************************************************************************
��ͼ����ṹ��
******************************************************************************/
typedef struct
{
  uint8_t   Mode;
  uint8_t   State;
  
  uint8_t   StartPage;
  uint8_t   StartCol;
  uint8_t   EndPage;
  uint8_t   EndCol;
  uint8_t   CurrentPage;
  uint8_t   CurrentCol;
  
  uint16_t  Width;
  uint16_t  Length;  
  uint16_t  Offset;
  uint16_t  LineOffset;
  
  uint8_t   Type;
  uint8_t   BitShiftT;
  uint8_t   BitShiftB;
  uint8_t   IsCompress;
  uint8_t   IsInverse;
  uint8_t * __far pBmp;
}TFTLCDDrawingReqStruct;

/******************************************************************************
��ͼ����FIFO�ṹ��
******************************************************************************/
typedef struct
{
  TFTLCDDrawingReqStruct  Req[TFT_LCD_REQ_FIFO_MAX_DEPTH];
  uint8_t                 Iptr;
  uint8_t                 Optr;
  uint8_t                 Depth;
}TFTLCDDrawingFIFOStruct;

/********************jiexi**********************************************/
typedef struct 
{
   uint16_t arrayPosCur;
   uint16_t arrayInPosCur;
   uint16_t arrayTotolPosCur;
   
   //uint8_t arrayBuff[1024];
}ArrayBuffStruct;

//ͼƬ��ѹ
#define SCREEN_WIDTH    241      //������Ļ�Ĵ�Сȷ�����ͼƬ����ʾ�ռ�

typedef struct 
{
   uint16_t Top_Pos;
   uint16_t End_Pos;  
   uint8_t array[SCREEN_WIDTH];   
}PixelPointList;


/******************************************************************************
��ʾ���¿��ƽṹ
******************************************************************************/
typedef struct
{
  uint8_t   Brightness;
}TFTLCDUpdateCtrlStruct;
/******************************************************************************
��ͼ����λ����
******************************************************************************/
static const uint8_t TFTLCDBitMask[]  = {0x00, 0x03, 0x0F, 0x3F, 0xFF};

/******************************************************************************
��ͼλ����
******************************************************************************/
static const uint8_t TFTLCDBitTable[] = {0x03, 0x0c, 0x30, 0xc0};

   EXTERN INT8U TFT_INIT;
/******************************************************************************
��������
******************************************************************************/
void TFT_LCD_Startup(void);
void TFT_LCD_BUF_Clean(void);
void TFT_LCD_Shutdown(void);
uint8_t TFT_LCD_Busy_Check(void);
void TFT_LCD_Set_Brightness(uint8_t Br);
void TFT_LCD_Display_Update_Service(void);

void TFT_LCD_Cls(void);
void TFT_LCD_Clean_FIFO_Ptr(void);
void Original_TFT_LCD_Draw_Bmp( uint8_t Comp, uint8_t Inv, uint16_t StartX, uint16_t StartY, uint8_t * __far pBmp);
void TFT_LCD_Draw_Transparent_Bmp(uint16_t StartX, uint16_t StartY, uint8_t * __far pBmp, uint8_t Type);
void TFT_LCD_Draw_Pixel(uint16_t PosX, uint16_t PosY, uint8_t Type);
void Original_TFT_LCD_Draw_Horizontal_Line(uint16_t StartX, uint16_t EndX, uint16_t PosY, uint8_t Type);
void Original_TFT_LCD_Draw_Vertical_Line(uint16_t PosX, uint16_t StartY, uint16_t EndY, uint8_t Type);
void Original_TFT_LCD_Draw_Box(uint16_t StartX, uint16_t StartY, uint16_t EndX, uint16_t EndY, uint8_t Fill, uint8_t Type);

static uint8_t TFT_LCD_Cls_Handler(TFTLCDDrawingReqStruct *pReq);
static uint8_t TFT_LCD_Direct_Draw_Bmp_Handler(TFTLCDDrawingReqStruct *pReq);
static uint8_t TFT_LCD_Direct_Draw_Bmp_TEST(TFTLCDDrawingReqStruct *pReq);
static uint8_t TFT_LCD_Insert_Draw_Bmp_Handler(TFTLCDDrawingReqStruct *pReq);
static uint8_t TFT_LCD_Direct_Draw_Transparent_Bmp_Handler(TFTLCDDrawingReqStruct *pReq);
static uint8_t TFT_LCD_Insert_Draw_Transparent_Bmp_Handler(TFTLCDDrawingReqStruct *pReq);
static uint8_t TFT_LCD_Draw_Pixel_Handler(TFTLCDDrawingReqStruct *pReq);
static uint8_t TFT_LCD_Draw_Horizontal_Line_Handler(TFTLCDDrawingReqStruct *pReq);
static uint8_t TFT_LCD_Draw_Vertical_Line_Handler(TFTLCDDrawingReqStruct *pReq);
static uint8_t TFT_LCD_Draw_Box_Border_Handler(TFTLCDDrawingReqStruct *pReq);
static uint8_t TFT_LCD_Direct_Draw_Full_Box_Handler(TFTLCDDrawingReqStruct *pReq);
static uint8_t TFT_LCD_Insert_Draw_Full_Box_Handler(TFTLCDDrawingReqStruct *pReq);

void TFT_LCD_Draw_Bmp(uint8_t Comp, uint8_t Inv, uint16_t StartX, uint16_t StartY, uint8_t * __far pBmp);
void TFT_LCD_Draw_Vertical_Line(uint16_t PosX, uint16_t StartY, uint16_t EndY, uint8_t Type);
void TFT_LCD_Draw_Horizontal_Line(uint16_t StartX, uint16_t EndX, uint16_t PosY, uint8_t Type);
void TFT_LCD_Draw_Box(uint16_t StartX, uint16_t StartY, uint16_t EndX, uint16_t EndY, uint8_t Fill, uint8_t Type);


#endif
