#ifndef _POPUP_SCHEDULER_H_
#define _POPUP_SCHEDULER_H_

//#include "TYW_stdint.h"

/******************************************************************************
״̬
******************************************************************************/
#define   POPUP_STATUS_OFF                  	0x00u
#define   POPUP_STATUS_NEW                  	0x01u
#define   POPUP_STATUS_FIRST                	0x02u
#define   POPUP_STATUS_LOOP                 	0x03u
#define   POPUP_STATUS_MASKED               	0x04u
#define   POPUP_STATUS_DELETE               	0x05u
#define   POPUP_STATUS_CLEAR                	0x06u

/******************************************************************************
лȼ
******************************************************************************/
#define   POPUP_CUT_NOT                     	0x00u
#define   POPUP_CUT_IMMEDIATELY             	0x01u
#define   POPUP_CUT_WAIT_TIME_MIN           	0x02u
#define   POPUP_CUT_WAIT_TIME_NORMAL        	0x03u

/******************************************************************************

******************************************************************************/
#define   POPUP_DEFINE_FIRST_DISPLAY			    0u    /*״ʾPOPUP_CUT_WAIT_TIME_MINPOPUP_CUT_WAIT_TIME_NORMALлҪȴл*/
#define   POPUP_SAME_CLASS_CUT_IMMEDIATELY		1u     /*ͬ͵ϢϣҪ*/
#define   POPUP_HIGH_CUT_LOW_TYPE_IMMEDIATELY	1u	    /*͸͵ͣ=1ʹܣ=0ʹ*/
#define   POPUP_HINT_CUT_HINT_IMMEDIATELY		  0u	    /*ʾϢʾϢ=1ʹܣ=0ʹ*/
#define   POPUP_WARNING_CUT_HINT_MIN			    0u	    /*Դʾ࣬ҪȴСʱ䣺=1ʹܣ=0ʹ*/		
#define   POPUP_CUT_RECOVER						        1u	    /*ϵϢָʾʱӴ˿ʼʾ*/
#define   POPUP_DISP_TIME_NORMAL            	4u*10u  /*unit = 100ms*/
#define   POPUP_DISP_TIME_MIN               	2u*10u  /*unit = 100ms*/

/******************************************************************************
ѯģʽ
******************************************************************************/
#define   POPUP_POLLING_FORWARD             	0x00u
#define   POPUP_POLLING_REVERSE             	0x01u

/******************************************************************************
ȼ
******************************************************************************/
#define   POPUP_PRIORITY_NUMBER_MAX     POPUP_PRIORITY_NUMBER_FATAL
#define   SND_NONE                      0xFFu
/******************************************************************************
ϢȽṹ
******************************************************************************/
typedef struct
{
    uint16_t   Timer;
    uint16_t   NewPopupID;
    uint16_t   PollPopupID;
    uint8_t   CutGrade;
    uint16_t   CurPopupID;
    uint8_t   CurStatus;
    uint8_t   SndReqCode;
    uint16_t   CurMaskedID;
    uint8_t   WarningExist;
} PopupSchedulingStruct;

/******************************************************************************

******************************************************************************/

/**********************************************************************************************************
 *@Function:  	Popup_Scheduler_Init
 *@Description: ʼϢ
 *@Input:			  MY_MemInit / CommMemInit
 *@Output:			none.
 *@Calls:  			none.
 *@Return:  		none.
 *@Note:    		ڴҪӲʼ֮ǰгʼ
 **********************************************************************************************************/
void Popup_Scheduler_Init ( void );

/**********************************************************************************************************
 *@Function:  		Popup_Scheduler_OFF
 *@Description: 	ٴڵָΪʼ״̬
 *@Input:			MY_MemInit / CommMemInit
 *@Output:			none.
 *@Calls:  			none.
 *@Return:  		none.
 *@Note:    		none.
 **********************************************************************************************************/
void Popup_Scheduler_OFF ( void );

/**********************************************************************************************************
 *@Function:  		Popup_Scheduling_Service
 *@Description:   ȵϢµǰʾϢ,ӿں
 *					      ܷл
 *					      1ǰʾϢɾ/
 *					      2ȼߵϢ
 *					      3ʾʱ䵽
 *@Input:			    CommMemInit
 *@Output:			  none.
 *@Calls:  			  none
 *@Return:  		  none
 *@Note:    		  ÷ÿ100msһ
 **********************************************************************************************************/
void Popup_Scheduling_Service ( void );

/**********************************************************************************************************
 *@Function:  		Popup_Request
 *@Description:   Ϣ󣬰ȫͣӿں
 *@Input:			    uint8_t PopupID -- ϢID.
 *@Output:			  none.
 *@Calls:  			  none.
 *@Return:  		  none.
 *@Note:    		  none.
 **********************************************************************************************************/
void Popup_Request ( uint16_t PopupID );

/**********************************************************************************************************
 *@Function:  		Popup_Mask_Request
 *@Description:   εࣩࣨϢֻʾĲſԱ
 *                ***********ȫʾ***************
 *@Input:			    none.
 *@Output:			  none.
 *@Calls:  			  none.
 *@Return:  		  none.
 *@Note:    		  none.
 **********************************************************************************************************/
void Popup_Mask_Request ( void );

/**********************************************************************************************************
 *@Function:  	Popup_Del_Masked_Request
 *@Description: IGN_OFFʱҪιıϢʾٴʾ
 *@Input:		none.
 *@Output:		none.
 *@Calls:  		none.
 *@Return:  	none.
 *@Note:    	ĿǰϢ״̬лΪѭʾ״̬.
 **********************************************************************************************************/
void Popup_Del_Masked_Request ( void );

/**********************************************************************************************************
 *@Function:  		Popup_Get_Status
 *@Description:   ȡѯϢ״̬
 *@Input:			    uint8_t PopupID -- ϢID
 *@Output:			  none.
 *@Calls:  			  PopupList_Select
 *@Return:  		  POPUP_STATUS_OFF -- ϢҪʾ
 *                POPUP_STATUS_FIRST -- Ϣһʾ
 *                POPUP_STATUS_LOOP -- Ϣѯʾ
 *                POPUP_STATUS_MASKED -- Ϣ
 *                POPUP_STATUS_DELETE -- Ϣȴɾ
 *                POPUP_STATUS_CLEAR -- Ϣϱɾ
 *@Note:    		  none.
 **********************************************************************************************************/
uint8_t Popup_Get_Status ( uint16_t PopupID );

/**********************************************************************************************************
 *@Function:  		Popup_Get_Current_Message
 *@Description:   ȡǰϢֱ
 *@Input:			    none.
 *@Output:			  none.
 *@Calls:  			  none.
 *@Return:  		  none.
 *@Note:    		  none.
 **********************************************************************************************************/
uint16_t Popup_Get_Current_Message ( void );

/**********************************************************************************************************
 *@Function:  		Popup_Get_Current_Sound
 *@Description:   ȡǰϢ
 *@Input:			    none.
 *@Output:			  none.
 *@Calls:  			  none.
 *@Return:  		  none.
 *@Note:    		  ӰĳԼǷ
 **********************************************************************************************************/
 //uint8_t Popup_Get_Current_Sound ( void );

/**********************************************************************************************************
 *@Function:  		Popup_Get_Current_Sound_Req_Code
 *@Description:   ȡǰϢ
 *@Input:			    none.
 *@Output:			  none.
 *@Calls:  			  none.
 *@Return:  		  none.
 *@Note:    		  ӰĳԼǷ
 **********************************************************************************************************/
uint8_t Popup_Get_Current_Sound_Req_Code ( void );

/**********************************************************************************************************
 *@Function:  		Popup_Delete
 *@Description:   ǰʾϢǵһʾҪȴTminڶϢʾࣩ⣩
 *@Input:			    uint8_t PopupID -- ϢID
 *@Output:			  FatalListHead/HintListHead/WarningListHead/ExceptionListHead -- 
 *@Calls:  			  PopupList_Select / PopupList_Delete
 *@Return:  		  none.
 *@Note:    		  none.
 **********************************************************************************************************/
void Popup_Delete ( uint16_t PopupID );

/**********************************************************************************************************
 *@Function:  		Popup_Clear
 *@Description:   ǰʾϢҪȴTmin
 *@Input:			    uint8_t PopupID -- ϢID
 *@Output:			  FatalListHead/HintListHead/WarningListHead/ExceptionListHead -- 
 *@Calls:  			  PopupList_Select / PopupList_Delete
 *@Return:  		  none.
 *@Note:    		  none.
 **********************************************************************************************************/
void Popup_Clear ( uint16_t PopupID );

/**********************************************************************************************************
 *@Function:  		Popup_Get_Warning_Status
 *@Description:   ѯǷڱϢ/ǻȡʾϢ£ǷڱϢ
 *@Input:			    none
 *@Output:			  none
 *@Calls:  			  none
 *@Return:  		  TRUE --ڱϢ
 *                FALSE -- ڱϢ
 *@Note:    		  none.
 **********************************************************************************************************/
uint8_t Popup_Get_Warning_Status ( void );

/**********************************************************************************************************
 *@Function:  		Popup_Get_Masked_Warning_Msg
 *@Description:   ȡǰʾϢ/ͼƬ
 *@Input:			    none
 *@Output:			  none
 *@Calls:  			  none
 *@Return:  		  /ͼƬ
 *@Note:    		  none.
 **********************************************************************************************************/
uint16_t Popup_Get_Masked_Warning_Msg ( void );

/**********************************************************************************************************
 *@Function:  		Popup_Masked_Warning_Polling_Reset
 *@Description:   λϢǰʾָ룬ǰָһָһ
 *@Input:			    none.
 *@Output:			  none.
 *@Calls:  			  none.
 *@Return:  		  none.
 *@Note:    		  none.
 **********************************************************************************************************/
void Popup_Masked_Warning_Polling_Reset ( uint8_t Mode );

/**********************************************************************************************************
Popup_Masked_Warning_Polling
  ܣѯεı

        ÿһδ˺,αָᰴָƶһλ,ָָ
        ϵһϢʱ,ٴͬһѯ,ǰαϢΪ
        POPUP_NONE ʾѯѽ

        :ǰα ABCD,Popup_Masked_Warning_Polling_Reset
        ,趨Ϊ POPUP_POLLING_FORWARD ʱ,αָָ򱨾A,,
        øú趨Ϊ POPUP_POLLING_FORWARD ʱαָ뼴ָ򱨾B.
        ظô˺ҷ򲻱αָָ򱨾D,ͬô˺
        򷵻 POPUP_NONE,ʾѯѽ

        ͨPopup_Get_Masked_Warningɶǰαָָı

  Modeѯģʽ POPUP_POLLING_FORWARD - ģʽ
                       POPUP_POLLING_REVERSE - ģʽ
ֵ
 **********************************************************************************************************/
void Popup_Masked_Warning_Polling ( uint8_t Mode );
void Popup_Hint_Mask_Request ( uint16_t PopupID );
uint16_t Popup_Get_First_Masked_Warning ( void );
uint8_t Popup_WarningRequested ( void );
uint8_t Popup_Get_Hint_Msg(uint16_t *pList, uint16_t len);
uint8_t Popup_Get_Warring_Msg(uint16_t *pList, uint16_t len);

#endif
