#ifndef __UDS_DTC_H
#define __UDS_DTC_H

#include "stdint.h"
#include "UDS_Common.h"

#define U300616  0xF00616
#define U300617  0xF00617
#define U007300  0xC07300
#define U015687  0xC15687
#define U014087  0xC14087
#define U021487  0xC21487
#define U029300  0xC29300
#define U011287  0xC11287
#define U012787  0xC12787
#define U120387  0xD20387
#define U012887  0xC12887
#define U015987  0xC15987
#define U011087  0xC11087
#define U016487  0xC16487
#define U015187  0xC15187
#define U112887  0xD12887
#define U012987  0xC12987
#define U013187  0xC13187
#define U012287  0xC12287
#define U019887  0xC19887
#define U010387  0xC10387
#define U012187  0xC12187
#define U026387  0xC26387
#define B110015  0x910015
#define B110114  0x910114
#define B110215  0x910215
#define B110314  0x910314

#define cnU300616 0
#define cnU300617 1 
#define cnU007300 2
#define cnU015687 3
#define cnU014087 4
#define cnU021487 5
#define cnU029300 6
#define cnU011287 7
#define cnU012787 8
#define cnU120387 9
#define cnU012887 10 
#define cnU015987 11
#define cnU011087 12
#define cnU016487 13
#define cnU015187 14
#define cnU112887 15
#define cnU012987 16
#define cnU013187 17
#define cnU012287 18
#define cnU019887 19
#define cnU010387 20
#define cnU012187 21
#define cnU026387 22
#define cnB110015 23
#define cnB110114 24
#define cnB110215 25
#define cnB110314 26

#define cnMSGA41  0
#define cnMSG021  1
#define cnMSGADF  2
#define cnMSG127  3
#define cnMSG0F4  4
#define cnMSG033  5
#define cnMSG7E8  6
#define cnMSGFA0  7
#define cnMSGF8F  8
#define cnMSG88F  9
#define cnMSGADA  10
#define cnMSG2EF  11
#define cnMSG319  12
#define cnMSG490  13
#define cnMSG095  14
#define cnMSG10B  15
#define cnMSGA13  16
#define cnMSGF0B  17
#define cnMSG69F  18
#define cnMSG705  19
#define cnMSG084  20

extern const uint32_t DTCList[27][2];

void TestDTC(uint16_t timer);

void TestDTC_U007300(void);
void TestDTC_U300616(uint16_t timer);
void TestDTC_U300617(uint16_t timer);
void TestDTC_U015687(void);
void TestDTC_U014087(void);
void TestDTC_U021487(void);
void TestDTC_U029300(void);
void TestDTC_U011287(void);
void TestDTC_U012787(void);
void TestDTC_U120387(void);
void TestDTC_U012887(void);
void TestDTC_U015987(void);
void TestDTC_U011087(void);
void TestDTC_U016487(void);
void TestDTC_U015187(void);
void TestDTC_U112887(void);
void TestDTC_U012987(void);
void TestDTC_U013187(void);
void TestDTC_U012287(void);
void TestDTC_U019887(void);
void TestDTC_U010387(void);
void TestDTC_U012187(void);
void TestDTC_U026387(void);
void TestDTC_B110015(uint16_t timer);
void TestDTC_B110114(uint16_t timer);
void TestDTC_B110215(uint16_t timer);
void TestDTC_B110314(uint16_t timer);

uint8_t getPowerStatus(void);
uint8_t getBusoffStatus(void);
uint8_t getEngStatus(void);
uint8_t getMSGStatus(uint8_t cnMsgID);
void ChangeDTCData(uint8_t DTCNum, uint8_t DTCStatus);
void SaveDTCData(void);

#endif