#ifndef PROTOCOL_USER_H
#define PROTOCOL_USER_H

#include "Protocol_Lib.h"


#define BLE_START_STA        0x10
#define MCU_REPLY            0x20
#define BLE_NAVIGATION       0x01
#define BLE_WEATHER          0x02
#define BLE_LOCATION         0x03
#define BLE_STA              0x12
#define MCU_TO_BLE_INFO      0x21


void Protocol_KL30_Wakeup_Init(void);
void Protocol_Send_Service(void);    // 10ms任务调用
void UART_Put(Protocol_uint16_t Data);

typedef enum
{
    Prot_Idle = 0, 
    Prot_Starting,
    Prot_Start,
    Prot_Normal,
}Prot_User_State_Enum;
typedef struct
{
    uint8_t State;
    uint16_t TimeDelay;

}Protocol_User_Ctrl_Struct;

extern Protocol_User_Ctrl_Struct Prot_User;
void Protocol_User_Ctrl_Init(void );

void Prot_Send_Msg_Process(void );


void Uart_Send_Id12_Pro(void );

#endif
