#include "Protocol_Lib.h"
#include "MCU_Core_Protocol.h"
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include "Protocol_User.h"
#include "gatts_table_creat_demo.h"

#include "app_Ble_User.h"

void Uart_ID10_process(void)
{
    uint8_t ID10[1] = {0x00};
    if(1)//蓝牙模组启动状态
    {
        ID10[0] = 0x01;
        Protocol_Send(0x10,ID10,1);
    }
    else
    {
        Protocol_Send(0x10,ID10,1);
    }

    // printf("send 0x10 \r\n");
}


void Uart_ID01_process(void)
{
        uint8_t ID01[6] = {0x00,0x00,0x00,0x00,0x00,0x00};

        if(Ble_User.Navi_Updat)
        {   
            ID01[0] = Ble_Navi_Data.Navi_Sts;
            ID01[1] = Ble_Navi_Data.Navi_Turn;//赋值为蓝牙收到的转向编码值
            ID01[2] = Ble_Navi_Data.Navi_Dte[0];
            ID01[3] = Ble_Navi_Data.Navi_Dte[1];
            ID01[4] = Ble_Navi_Data.Navi_Dte[2];
            ID01[5] = Ble_Navi_Data.Navi_Dte[3];

        }
        
        Protocol_Send(0x01,ID01,6);
}


void Uart_ID12_process(void)
{
    uint8_t ID12[1] = {0x00};
    ID12[0] =  Ble_User.Ble_Sts;
    Protocol_Send(0x12,ID12,1);
}

void Uart_ID20_process(const Protocol_Data_t *pData)
{
    //开始正式通信
    
}


void Uart_ID02_process(void)
{
    uint8_t ID02[1] = {0x00};
    ID02[0] =  0;//蓝牙电话状态
    Protocol_Send(0x02,ID02,1);   
    
}

uint8_t ID03[33] = {0x00};

void Uart_ID03_process(const Protocol_Data_t *pData)
{
    if(pData->Data[0] == 1/*接到值为1*/)
    {
        //来电
    }
    else if (pData->Data[0] == 2/*接到值为2*/)
    {
        //去电
    }
    else if (pData->Data[0] == 3/*接到值为3*/)
    {
        //通话中
    }
    else/*默认值*/
    {
        //无动作
    }
    
    /*接到UUID，给蓝牙*/
    unsigned int i = 1;
    for ( i = 1; i < 33; i++)
    {
        ID03[i] = pData->Data[i+1];//接到串口传来的UUID值
    }
    
    
}


// unsigned char ID21_num = 0;
// void Uart_ID21_process(const Protocol_Data_t *pData)//底板给ESP32发
// {
//     if (1)
//     {
//         ID21_num++;
//     }
//     printf("ID21 IS %d!!!\r\n",ID21_num);

// }



void MCU_SOC_Commnuication(void)
{
    Protocol_Service();
}


