#include "app_Ble_User.h"
#include "gatts_table_creat_demo.h"
#include <stdint.h>
#include <stdio.h>
#include <stdlib.h>
#include "string.h"
#include "freertos/FreeRTOS.h"
#include "freertos/task.h"
#include "freertos/event_groups.h"

#define TAG "APP_BLE_USER"


Ble_User_Control_Struct Ble_User_Ctrl;


void Ble_Connect_Event_Pro(void )
{
    Ble_User_Ctrl.Ble_Sts = Ble_Conn;
}


void Ble_DisConnect_Event_Pro(void )
{
    Ble_User_Ctrl.Ble_Sts = Ble_Idle;
}


uint8_t tp_Ble_Crc(uint8_t *data, uint32_t len )
{
    uint8_t val = 0;

    for(uint32_t i = 0; i<len; i++)
    {
        val ^= data[i];
    }

    return val;
}


typedef union 
{
    struct 
    {
        uint8_t FrameHeader;
        uint8_t Instruct;
        uint8_t Lenth;
        uint8_t Param[252];
    }Msg;
    uint8_t Data[255];
}app_Ble_User_Data_Rec_Union;

app_Ble_User_Data_Rec_Union BleRec;
app_Ble_User_Data_Rec_Union BleTrans;

typedef struct 
{
    uint32_t RecLen;
    uint32_t TotalLen;
    uint8_t Sts;

    uint8_t Receive;
}app_Ble_Rec_Data_Ctrl_Struct;

app_Ble_Rec_Data_Ctrl_Struct RecCtrl;

uint8_t ble_key[32]   =  "1BJ7J8S";
uint8_t ble_uerid[32] =  {'1', '2', '3', '4', '5', '6', '7', '8', '9', 0x30, 0x31,0x32,0x33,0x34,0x35,0x36,0x00};
uint8_t ble_pwd[32]   =  {'A','D','E','B','O','N','2','0','2','3','Z', 'H','I','D','O','U'};
uint8_t flavor[4]   =  {0, 0, 0, 0x33};

void Clear_Rx_Buffer(void )
{
    for(int i = 0; i< sizeof(BleRec.Data); i++)
    {
        BleRec.Data[i] = 0;
    }
}

uint8_t Ble_Get_User_Info(void )
{
    uint8_t i = 0;
    for(i = 0; i<32;i++)
    {
        ble_uerid[i] = i;
        ble_pwd[i] = i+64;

    }
    return 1;
}

void Get_Ble_Raw_Data(uint8_t *data, uint32_t len)
{
    uint8_t err = 0;
    uint8_t crc = 0;

    if(len > 1024)
    {
        return;
    }
    

    if(data[0] == 0x24)
    {
        if(RecCtrl.Sts == BleRec_Idle)
        {
            
            printf("receive data:");
                for(uint16_t i = 0; i< len; i++)
                {
                    printf(" %x ", data[i]);
                }
                printf("\r\n");

                printf("\r\n");

            RecCtrl.RecLen = 0;
            memcpy(( uint8_t * )&BleRec.Data[RecCtrl.RecLen], data, len);
            RecCtrl.TotalLen = BleRec.Msg.Lenth +1 ;
            RecCtrl.RecLen += len;
            if(RecCtrl.RecLen >= RecCtrl.TotalLen)
            {
                crc = tp_Ble_Crc(BleRec.Data, RecCtrl.TotalLen - 2);

                printf("receive data:");
                for(uint16_t i = 0; i< RecCtrl.TotalLen; i++)
                {
                    printf(" %x ", BleRec.Data[i]);
                }
                printf("\r\n");

                printf("rec crc = %d\r\n", crc);


                if((BleRec.Data[RecCtrl.TotalLen - 1] != 0x0A) || (crc != BleRec.Data[RecCtrl.TotalLen - 2]))
                {
                    Clear_Rx_Buffer();
                    RecCtrl.Sts = Ble_Idle;
                }
                else
                {
                    RecCtrl.Sts = BleRec_Suc;
                }
            }
            else
            {
                RecCtrl.Sts = BleRec_Start;

                printf("BleRec_Start \r\n");
            }
        }
    }
    else
    {
        if(RecCtrl.Sts == BleRec_Start)
        {
            if((RecCtrl.RecLen+len) <= RecCtrl.TotalLen)
            {
                printf("receive data:");
                    for(uint16_t i = 0; i< len; i++)
                    {
                        printf(" %x ", data[i]);
                    }
                    printf("\r\n");

                    printf("\r\n");

                memcpy(( uint8_t * )&BleRec.Data[RecCtrl.RecLen], data, len);
                RecCtrl.RecLen += len;

                if(RecCtrl.RecLen >= RecCtrl.TotalLen)
                {
                    crc = tp_Ble_Crc(BleRec.Data, RecCtrl.TotalLen - 2);

                    printf("receive data:");
                    for(uint16_t i = 0; i< RecCtrl.TotalLen; i++)
                    {
                        printf(" %x ", BleRec.Data[i]);
                    }
                    printf("\r\n");

                    printf("rec crc = %d\r\n", crc);

                    if((BleRec.Data[RecCtrl.TotalLen - 1] != 0x0A) || (crc != BleRec.Data[RecCtrl.TotalLen - 2]))
                    {
                        Clear_Rx_Buffer();
                        RecCtrl.Sts = Ble_Idle;
                    }
                    else
                    {
                        RecCtrl.Sts = BleRec_Suc;
                    }
                }
            }
            else
            {
                //len err
                Clear_Rx_Buffer();
                RecCtrl.Sts = Ble_Idle;
            }
        }
    }

    

    uint8_t total_frame = 0;
    uint8_t trans_len = 0;
    if(RecCtrl.Sts == BleRec_Suc)
    {
        if(BleRec.Msg.Instruct == 0x30)
        {
            //Authr suc

            BleTrans.Msg.FrameHeader = 0x24;
            BleTrans.Msg.Instruct = 0x58;
            BleTrans.Msg.Lenth = 104;
            if((BleTrans.Msg.Lenth+1) % 20 == 0)
            {
                total_frame = (BleTrans.Msg.Lenth+1) / 20;
            }
            else
            {
                total_frame = (BleTrans.Msg.Lenth+1) / 20 + 1;
            }
            
            if(Ble_Get_User_Info())
            {
                memcpy(( uint8_t * )&BleTrans.Msg.Param[0], ble_key, 32);
                memcpy(( uint8_t * )&BleTrans.Msg.Param[32], ble_uerid, 32);
                memcpy(( uint8_t * )&BleTrans.Msg.Param[64], ble_pwd, 32);
                memcpy(( uint8_t * )&BleTrans.Msg.Param[96], flavor, 4);
            }
            BleTrans.Data[BleTrans.Msg.Lenth - 1] = tp_Ble_Crc(BleTrans.Data, BleTrans.Msg.Lenth - 1);
            BleTrans.Data[BleTrans.Msg.Lenth] = 0x0A;

            for(uint8_t i = 0; i < total_frame; i++)
            {
                if(((BleTrans.Msg.Lenth+1) - 20*i) >= 20)
                {
                    trans_len = 20;
                }
                else
                {
                    trans_len = (BleTrans.Msg.Lenth+1) - 20*i;
                }

                printf("trans_len = %d\r\n", trans_len);

                printf("trans data:");
                for(uint16_t j = 0; j< trans_len; j++)
                {
                    printf(" %x ", BleTrans.Data[j + i*20]);
                }
                printf("\r\n");

                printf("\r\n");

                bsp_Ble_Gatts_Send_Indicate( trans_len, &BleTrans.Data[i*20]);

                // vTaskDelay(1);


                
            }
        }
        else
        {
            
        }

        RecCtrl.Sts = BleRec_Idle;
    }





    




    
  
}



void test_test(void )
{
    uint8_t total_frame = 0;
    uint8_t trans_len = 0;


    vTaskDelay(5000);

    if(RecCtrl.Sts == BleRec_Idle)
    {

    }
    else
    {
        return;
    }

    BleTrans.Msg.FrameHeader = 0x24;
    BleTrans.Msg.Instruct = 0x14;
    BleTrans.Msg.Lenth = 9;
    if((BleTrans.Msg.Lenth+1) % 20 == 0)
    {
        total_frame = (BleTrans.Msg.Lenth+1) / 20;
    }
    else
    {
        total_frame = (BleTrans.Msg.Lenth+1) / 20 + 1;
    }

    BleTrans.Msg.Param[0] = 1;
    BleTrans.Msg.Param[1] = 80;
    BleTrans.Msg.Param[2] = 0;
    BleTrans.Msg.Param[3] = 3;
    BleTrans.Msg.Param[4] = 0;
    
    // if(Ble_Get_User_Info())
    // {
    //     memcpy(( uint8_t * )&BleTrans.Msg.Param[0], ble_key, 32);
    //     memcpy(( uint8_t * )&BleTrans.Msg.Param[32], ble_uerid, 32);
    //     memcpy(( uint8_t * )&BleTrans.Msg.Param[64], ble_pwd, 32);
    //     memcpy(( uint8_t * )&BleTrans.Msg.Param[96], flavor, 4);
    // }
    BleTrans.Data[BleTrans.Msg.Lenth - 1] = tp_Ble_Crc(BleTrans.Data, BleTrans.Msg.Lenth - 1);
    BleTrans.Data[BleTrans.Msg.Lenth] = 0x0A;

    for(uint8_t i = 0; i < total_frame; i++)
    {
        if(((BleTrans.Msg.Lenth+1) - 20*i) >= 20)
        {
            trans_len = 20;
        }
        else
        {
            trans_len = (BleTrans.Msg.Lenth+1) - 20*i;
        }

        printf("trans_len = %d\r\n", trans_len);

        printf("trans data:");
        for(uint16_t j = 0; j< trans_len; j++)
        {
            printf(" %x ", BleTrans.Data[j + i*20]);
        }
        printf("\r\n");

        printf("\r\n");

        bsp_Ble_Gatts_Send_Indicate( trans_len, &BleTrans.Data[i*20]);

        


        
    }
}





