
#include "app_BT_User.h"
#include <stdio.h> 
#include "bt_app_hf.h"
#include "freertos/FreeRTOS.h"
#include "freertos/task.h"
#include "bt_app_main.h"
#include "esp_gap_bt_api.h"
#include <string.h>
#include "app_Ble_User.h"
extern esp_bd_addr_t peer_addr;

#define TAG "APP_BLE_USER"

BT_User_Control_Struct BT_User;

#define BT_ReConn_T 300

#define IPHNOE_ACTIVE_CONNENT 0X113

void BT_User_Init(void )
{
    BT_User.BT_Sts = BT_Idle;
    BT_User.Call_Sts = Call_Idle;
    BT_User.ReconnTime = BT_ReConn_T - 50;
    BT_User.HF_Ctrl = HF_Idle;
    BT_User.BT_DisConnReason = 0xffff;
    BT_User.Get_Call_Num = 0;
    BT_User.Call_Fitter_sts = Call_Idle;
    BT_User.HfClient_Req_Cnt = 0;

}

void BT_Connect_Event_Pro(void )
{
    BT_User.BT_Sts = BT_Conn;
    BT_User.Call_Sts = Call_Idle;
    BT_User.ReconnTime = BT_ReConn_T - 50;
    BT_User.HF_Ctrl = HF_Idle;
    // printf("TB CONN\r\n");

    BT_User.BT_DisConnReason = 0xffff;
    BT_User.Get_Call_Num = 0;
    BT_User.Call_Fitter_sts = Call_Idle;
    BT_User.HfClient_Req_Cnt = 0;
}


void BT_DisConnect_Event_Pro(void )
{
    BT_User.BT_Sts = BT_Idle;
    BT_User.Call_Sts = Call_Idle;
    BT_User.ReconnTime = BT_ReConn_T - 50;
    BT_User.HF_Ctrl = HF_Idle;
    // printf("TB DISCONN\r\n");

    BT_User.Get_Call_Num = 0;
    BT_User.Call_Fitter_sts = Call_Idle;
    BT_User.HfClient_Req_Cnt = 0;
}

void BT_User_Process(void )
{
    switch(BT_User.Call_Sts)
    {
        case Call_OutCalling:
        {
            if(BT_User.HF_Ctrl == HF_Reject)
            {
                hf_reject_handler();
            }
            break;
        }
        case Call_IncomeCalling:
        {
            if(BT_User.HF_Ctrl == HF_Reject)
            {
                hf_reject_handler();
            }
            else if(BT_User.HF_Ctrl == HF_Answer)
            {
                hf_answer_handler();
            }
            break;
        }
        case Call_InProcess:
        {
            if(BT_User.HF_Ctrl == HF_Reject)
            {
                hf_reject_handler();
            }

            break;
        }
        case Call_Idle:
        {
            break;
        }
        // case Call_Miss:
        // {
        //     if(BT_User.HF_Ctrl == HF_Reject)
        //     {
        //         hf_reject_handler();
        //     }
        //     break;
        // }
        // case Call_Hangup:
        // {
        //     if(BT_User.HF_Ctrl == HF_Reject)
        //     {
        //         hf_reject_handler();
        //     }
        //     break;
        // }
    }

    BT_User.HF_Ctrl = HF_Idle;

    // if(BT_User.BT_DisConnReason != IPHNOE_ACTIVE_CONNENT)
    {
        if(BT_User.BT_Sts == BT_Idle)
        {
            BT_User.ReconnTime++;
            if(BT_User.ReconnTime >= BT_ReConn_T)
            {
                // printf("Connect Start.................\n");
                if(app_BT_Get_BondDev() == 1)
                {
                    esp_hf_client_connect(peer_addr);
                }
                
                // printf("Connect Over\n");

                BT_User.ReconnTime = 0;
            }
        }
    }
}

/*  */
uint8_t ODO_Clear_BLEinfo(void )
{
    // if (Ble_User.Ble_Sts == Ble_Conn)
    // {
    //     esp_hf_client_disconnect(peer_addr);
    // }
    uint8_t ret = 0;
    int bond_dev_num = esp_bt_gap_get_bond_device_num();

    if(bond_dev_num)
    {
        esp_bd_addr_t *dev_list = (esp_bd_addr_t *)malloc(sizeof(esp_bd_addr_t) * bond_dev_num);
        if (dev_list != NULL)
        {
            esp_bt_gap_get_bond_device_list(&bond_dev_num, dev_list);

            if(bond_dev_num > 0)
            {
                int i = 0;
                for(i=0; i<bond_dev_num; i++)
                {
                    esp_bt_gap_remove_bond_device(dev_list[i]);
                }
            }

            ret = 1;
            free(dev_list);
        }
    }
    else
    {
        memset(peer_addr, 0, 6);
        ret = 0;
    }
    return ret;
}







