#ifndef _WIFI_SERVICE_H_
#define _WIFI_SERVICE_H_

#define WIFI_SERVICE_STOP 0   // WiFi服务已关闭
#define WIFI_SERVICE_INIT 1   // WiFi服务初始化
#define WIFI_SERVICE_START 2  // WiFi服务已开启
#define WIFI_SERVICE_DEINIT 3 // WiFi服务反初始化
#define WIFI_SERVICE_ERR 4    // WiFi服务状态错误
#define WIFI_SERVICE_OK 5     // WiFi服务开启或关闭成功

#define NOTHING_TO_DO 0 // 不执行操作
#define ABOUT_TO_STOP 1 // 即将关闭

#define WIFI_AP_STOP 0   // AP已关闭
#define WIFI_AP_INIT 1   // AP初始化
#define WIFI_AP_START 2  // AP已开启
#define WIFI_AP_DEINIT 3 // AP反初始化

#define WIFI_AP_SSID "QJ500-7C-AP-"
#define WIFI_AP_PASSWD "12345677"

typedef struct
{
    unsigned char status;   // WiFi状态
} wifi_service_t;

/**
 * @brief 开启AP
 */
void wifi_ap_start(void);

/**
 * @brief 关闭AP
 */
void wifi_ap_stop(void);

/**
 * @brief 初始化WiFi的状态
 */
void wifi_service_status_init();

/**
 * @brief 立刻开启 WiFi AP
 * @note return: WIFI_SERVICE_OK，正在开启
 * @note return: WIFI_SERVICE_ERR，WiFi状态不正确，无法开启
 * @note return: WIFI_SERVICE_START, WiFi已开启，无需再开启
 */
unsigned char wifi_turn_on(void);

/**
 * @brief 立刻关闭 WiFi AP
 * @note return: WIFI_SERVICE_OK，正在关闭
 * @note return: WIFI_SERVICE_ERR，WiFi状态不正确，无法关闭
 * @note return: WIFI_SERVICE_STOP, WiFi已关闭，无需再关闭
 */
unsigned char wifi_turn_off(void);

extern int get_sta_number(void);
extern void close_wifi_timer_clear(void);
extern void close_timer(void);

#endif
