/* Coex demo for wifi/bt/ble  mesh

   This example code is in the Public Domain (or CC0 licensed, at your option.)

   Unless required by applicable law or agreed to in writing, this
   software is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
   CONDITIONS OF ANY KIND, either express or implied.
*/

#include <string.h>
#include "freertos/FreeRTOS.h"
#include "freertos/task.h"
#include "nvs_flash.h"
#include "sdkconfig.h"

#include "esp_log.h"
#include "esp_wifi.h"
#include "esp_peripherals.h"
#include "esp_wifi_setting.h"
#include "esp_audio.h"
#include "audio_pipeline.h"
#include "audio_element.h"
#include "audio_mem.h"
#include "http_stream.h"
#include "a2dp_stream.h"
#include "i2s_stream.h"
#include "raw_stream.h"
#include "hfp_stream.h"
#include "filter_resample.h"
#include "mp3_decoder.h"
#include "pcm_decoder.h"
#include "wifi_service.h"
#include "blufi_config.h"
#include "input_key_service.h"
// #include "ble_gatts_module.h"

#include "audio_idf_version.h"

// #include "api/esp_hf_client_api.h"

#include "esp_hf_client_api.h"



#include <string.h>
#include <inttypes.h>
#include "nvs_flash.h"
#include "freertos/FreeRTOS.h"
#include "freertos/task.h"

#include "esp_log.h"
#include "esp_peripherals.h"
#include "periph_touch.h"
#include "periph_adc_button.h"
#include "periph_button.h"
#include "esp_bt_defs.h"
#include "esp_gap_bt_api.h"
#include "esp_hf_client_api.h"

#include "audio_element.h"
#include "audio_pipeline.h"
#include "audio_event_iface.h"
#include "audio_mem.h"

#include "i2s_stream.h"
#include "board.h"
#include "bluetooth_service.h"
#include "filter_resample.h"
#include "raw_stream.h"
#include "bt_keycontrol.h"

#include "audio_idf_version.h"



#if (ESP_IDF_VERSION >= ESP_IDF_VERSION_VAL(4, 1, 0))
#include "esp_netif.h"
#else
#include "tcpip_adapter.h"
#endif

#if (ESP_IDF_VERSION >= ESP_IDF_VERSION_VAL(4, 0, 0))
#define HFP_RESAMPLE_RATE 16000
#else
#define HFP_RESAMPLE_RATE 8000
#endif

#define SAMPLE_DEVICE_NAME "ESP_ADF_COEX_EXAMPLE"

static const char *TAG = "COEX_EXAMPLE";

typedef enum {
    NONE_MODE = 0x0,
    BT_MODE = 0x01,
    WIFI_MODE = 0x02,
} work_mode_t;

typedef struct coex_handle {
    esp_periph_handle_t bt_periph;
    esp_periph_set_handle_t set;
    esp_audio_handle_t player;
    work_mode_t work_mode;
} coex_handle_t;

static bool g_wifi_connect_state = false;
static bool g_a2dp_connect_state = false;

static esp_wifi_setting_handle_t wifi_setting_handle = NULL;
static periph_service_handle_t wifi_serv = NULL;
static int play_pos = 0;
static coex_handle_t *g_coex_handle = NULL;

static void bt_app_hf_client_audio_open(hfp_data_enc_type_t type)
{
    ESP_LOGI(TAG, "bt_app_hf_client_audio_open type = %d", type);
    if (g_coex_handle) {
        esp_audio_state_t state = { 0 };
        esp_audio_state_get(g_coex_handle->player, &state);
        esp_audio_pos_get(g_coex_handle->player, &play_pos);
        if(state.status == AUDIO_STATUS_RUNNING || state.status == AUDIO_STATUS_PAUSED) {
            esp_audio_stop(g_coex_handle->player, TERMINATION_TYPE_NOW);
            ESP_LOGE(TAG, "running or paused ");
        }
          
        if (type == HF_DATA_CVSD) {

            ESP_LOGE(TAG, "cvsd ");
            esp_audio_play(g_coex_handle->player, AUDIO_CODEC_TYPE_DECODER, "hfp://8000:1@bt/hfp/stream.pcm", 0);
        } else if (type == HF_DATA_MSBC) {
            ESP_LOGE(TAG, "msbc ");
            esp_audio_play(g_coex_handle->player, AUDIO_CODEC_TYPE_DECODER, "hfp://16000:1@bt/hfp/stream.pcm", 0);
        } else {
            ESP_LOGE(TAG, "error hfp enc type = %d", type);
        }
    }
}

static void bt_app_hf_client_audio_close(void)
{
    ESP_LOGI(TAG, "bt_app_hf_client_audio_close");
    if (g_coex_handle) {
        esp_audio_state_t state = { 0 };
        esp_audio_state_get(g_coex_handle->player, &state);
        if(state.status == AUDIO_STATUS_RUNNING || state.status == AUDIO_STATUS_PAUSED) {
            esp_audio_stop(g_coex_handle->player, TERMINATION_TYPE_NOW);
        }
        if (g_coex_handle->work_mode == BT_MODE) {
            if (g_a2dp_connect_state == true) {
                periph_bt_play(g_coex_handle->bt_periph);
                esp_audio_play(g_coex_handle->player, AUDIO_CODEC_TYPE_DECODER, "aadp://44100:2@bt/sink/stream.pcm", play_pos);
            }
        } else if (g_coex_handle->work_mode == WIFI_MODE) {
            // if (g_wifi_connect_state == true) {
            //     esp_audio_play(g_coex_handle->player, AUDIO_CODEC_TYPE_DECODER, "https://dl.espressif.com/dl/audio/ff-16b-1c-44100hz.mp3", play_pos);
            // }
        }
        play_pos = 0;
    }
}

static esp_err_t input_key_service_cb(periph_service_handle_t handle, periph_service_event_t *evt, void *ctx)
{
    ESP_LOGI(TAG, "[ * ] input key id is %d, key type is %d", (int)evt->data, (int)evt->type);
    if (ctx == NULL) {
        return ESP_FAIL;
    }
    coex_handle_t *cx_handle = (coex_handle_t *)ctx;
    if (evt->type == INPUT_KEY_SERVICE_ACTION_CLICK_RELEASE) {
        switch ((int)evt->data) {
            case INPUT_KEY_USER_ID_MODE:
                ESP_LOGI(TAG, "[ * ] [mode]");
                if (cx_handle->work_mode == NONE_MODE) {
                    ESP_LOGI(TAG, "[ * ] Enter BT mode");
                    cx_handle->work_mode = BT_MODE;
                    if (g_a2dp_connect_state == true) {
                        periph_bt_play(cx_handle->bt_periph);
                        esp_audio_play(cx_handle->player, AUDIO_CODEC_TYPE_DECODER, "aadp://44100:2@bt/sink/stream.pcm", 0);
                    }
                } else if (cx_handle->work_mode == BT_MODE) {
                    ESP_LOGI(TAG, "[ * ] Enter WIFI mode");
                    cx_handle->work_mode = BT_MODE;
                    if (g_a2dp_connect_state == true) {
                        periph_bt_pause(cx_handle->bt_periph);
                        vTaskDelay(300 / portTICK_RATE_MS);
                    }
                    esp_audio_stop(cx_handle->player, TERMINATION_TYPE_NOW);
                    if (g_wifi_connect_state == true) {
                        esp_audio_play(cx_handle->player, AUDIO_CODEC_TYPE_DECODER, "https://dl.espressif.com/dl/audio/ff-16b-2c-44100hz.mp3", 0);
                    }
                } else if (cx_handle->work_mode == WIFI_MODE) {
                    // ESP_LOGI(TAG, "[ * ] Enter BT mode");
                    // cx_handle->work_mode = BT_MODE;
                    // esp_audio_stop(cx_handle->player, TERMINATION_TYPE_NOW);
                    // if (g_a2dp_connect_state == true) {
                    //     periph_bt_play(cx_handle->bt_periph);
                    //     esp_audio_play(cx_handle->player, AUDIO_CODEC_TYPE_DECODER, "aadp://44100:2@bt/sink/stream.pcm", 0);
                    // }
                }
                break;
            case INPUT_KEY_USER_ID_VOLUP:
                ESP_LOGI(TAG, "[ * ] [long Vol+] next");
                if (cx_handle->work_mode == BT_MODE) {
                    periph_bt_avrc_next(cx_handle->bt_periph);
                }
                break;

            case INPUT_KEY_USER_ID_VOLDOWN:
                ESP_LOGI(TAG, "[ * ] [long Vol-] Previous");
                if (cx_handle->work_mode == BT_MODE) {
                    periph_bt_avrc_prev(cx_handle->bt_periph);
                }
                break;
            default:
                break;
        }

    } else if (evt->type == INPUT_KEY_SERVICE_ACTION_PRESS) {
        // switch ((int) evt->data) {
        //     case INPUT_KEY_USER_ID_SET:
        //         ESP_LOGI(TAG, "[ * ] [Set] Setting Wi-Fi");
        //         ble_gatts_module_start_adv();
        //         blufi_set_sta_connected_flag(wifi_setting_handle, false);
        //         wifi_service_setting_start(wifi_serv, 0);
        //         break;
        //     default:
        //         break;
        // }
    }
    return ESP_OK;
}

static esp_err_t wifi_service_cb(periph_service_handle_t handle, periph_service_event_t *evt, void *ctx)
{
    // ESP_LOGD(TAG, "event type:%d,source:%p, data:%p,len:%d,ctx:%p",
    //          evt->type, evt->source, evt->data, evt->len, ctx);
    // if (evt->type == WIFI_SERV_EVENT_CONNECTED) {
    //     ESP_LOGI(TAG, "WIFI_CONNECTED");
    //     g_wifi_connect_state = true;
    //     esp_err_t set_dev_name_ret = esp_bt_dev_set_device_name(SAMPLE_DEVICE_NAME);
    //     if (set_dev_name_ret) {
    //         ESP_LOGE(TAG, "Set BT device name failed, error code = %x, line(%d)", set_dev_name_ret, __LINE__);
    //     }
    // } else if (evt->type == WIFI_SERV_EVENT_DISCONNECTED) {
    //     ESP_LOGI(TAG, "WIFI_DISCONNECTED");
    //     g_wifi_connect_state = false;
    // } else if (evt->type == WIFI_SERV_EVENT_SETTING_TIMEOUT) {
    //     ESP_LOGI(TAG, "WIFI_SETTING_TIMEOUT ");
    // }
    return ESP_OK;
}

static void wifi_server_init(void)
{
    // ESP_LOGI(TAG, "Blufi module init");
    // wifi_config_t sta_cfg = {0};
    // strncpy((char *)&sta_cfg.sta.ssid, CONFIG_WIFI_SSID, sizeof(sta_cfg.sta.ssid));
    // strncpy((char *)&sta_cfg.sta.password, CONFIG_WIFI_PASSWORD, sizeof(sta_cfg.sta.password));

    // wifi_service_config_t cfg = WIFI_SERVICE_DEFAULT_CONFIG();
    // cfg.extern_stack = true;
    // cfg.evt_cb = wifi_service_cb;
    // cfg.cb_ctx = NULL;
    // cfg.setting_timeout_s = 60;
    // wifi_serv = wifi_service_create(&cfg);

    // int reg_idx = 0;
    // wifi_setting_handle = blufi_config_create(NULL);
    // esp_wifi_setting_register_notify_handle(wifi_setting_handle, (void *)wifi_serv);
    // wifi_service_register_setting_handle(wifi_serv, wifi_setting_handle, &reg_idx);
    // wifi_service_set_sta_info(wifi_serv, &sta_cfg);
    // wifi_service_connect(wifi_serv);
}

static void user_a2dp_sink_cb(esp_a2d_cb_event_t event, esp_a2d_cb_param_t *param)
{
    ESP_LOGI(TAG, "A2DP sink user cb");
    switch (event) {
        case ESP_A2D_CONNECTION_STATE_EVT:
            if (param->conn_stat.state == ESP_A2D_CONNECTION_STATE_DISCONNECTED) {
                ESP_LOGI(TAG, "A2DP disconnected");
                g_a2dp_connect_state = false;
            } else if (param->conn_stat.state == ESP_A2D_CONNECTION_STATE_CONNECTED) {
                ESP_LOGI(TAG, "A2DP connected");
                g_a2dp_connect_state = true;
            }
            break;
        default:
            ESP_LOGI(TAG, "User cb A2DP event: %d", event);
            break;
    }
}

static esp_audio_handle_t setup_player()
{
    esp_audio_cfg_t cfg = DEFAULT_ESP_AUDIO_CONFIG();
    audio_board_handle_t board_handle = audio_board_init();
    cfg.vol_handle = board_handle->audio_hal;
    cfg.vol_set = (audio_volume_set)audio_hal_set_volume;
    cfg.vol_get = (audio_volume_get)audio_hal_get_volume;
    cfg.prefer_type = ESP_AUDIO_PREFER_MEM;
    cfg.resample_rate = 44100;
    cfg.evt_que = xQueueCreate(3, sizeof(esp_audio_state_t));
    esp_audio_handle_t player = esp_audio_create(&cfg);
    audio_hal_ctrl_codec(board_handle->audio_hal, AUDIO_HAL_CODEC_MODE_BOTH, AUDIO_HAL_CTRL_START);

    // Create readers and add to esp_audio
    http_stream_cfg_t http_cfg = HTTP_STREAM_CFG_DEFAULT();
    audio_element_handle_t http_stream_reader = http_stream_init(&http_cfg);
    esp_audio_input_stream_add(player, http_stream_reader);

    a2dp_stream_config_t a2dp_config = {
        .type = AUDIO_STREAM_READER,
        .user_callback.user_a2d_cb = user_a2dp_sink_cb,
    };
    audio_element_handle_t bt_stream_reader = a2dp_stream_init(&a2dp_config);
    esp_audio_input_stream_add(player, bt_stream_reader);
    
    hfp_stream_config_t hfp_config;
    hfp_config.type = INCOMING_STREAM;
    audio_element_handle_t hfp_in_stream = hfp_stream_init(&hfp_config);
    esp_audio_input_stream_add(player, hfp_in_stream);

    // Add decoders and encoders to esp_audio
    mp3_decoder_cfg_t  mp3_dec_cfg  = DEFAULT_MP3_DECODER_CONFIG();
    pcm_decoder_cfg_t  pcm_dec_cfg  = DEFAULT_PCM_DECODER_CONFIG();
    esp_audio_codec_lib_add(player, AUDIO_CODEC_TYPE_DECODER, mp3_decoder_init(&mp3_dec_cfg));
    esp_audio_codec_lib_add(player, AUDIO_CODEC_TYPE_DECODER, pcm_decoder_init(&pcm_dec_cfg));

    // Create writers and add to esp_audio
    i2s_stream_cfg_t i2s_writer = I2S_STREAM_CFG_DEFAULT();
    i2s_writer.type = AUDIO_STREAM_WRITER;
    raw_stream_cfg_t raw_writer = RAW_STREAM_CFG_DEFAULT();
    raw_writer.type = AUDIO_STREAM_WRITER;
    esp_audio_output_stream_add(player, i2s_stream_init(&i2s_writer));
    esp_audio_output_stream_add(player, raw_stream_init(&raw_writer));

    esp_audio_vol_set(player, 60);
    AUDIO_MEM_SHOW(TAG);
    ESP_LOGI(TAG, "esp_audio instance is:%p\r\n", player);
    return player;
}











static bool is_get_data = true;
static hfp_stream_user_callback_t  hfp_stream_user_callback;
static audio_element_handle_t hfp_incoming_stream = NULL;
static audio_element_handle_t hfp_outgoing_stream = NULL;

const char *c_hf_evt_str_app[] = {
    "CONNECTION_STATE_EVT",              /*!< connection state changed event */
    "AUDIO_STATE_EVT",                   /*!< audio connection state change event */
    "VR_STATE_CHANGE_EVT",                /*!< voice recognition state changed */
    "CALL_IND_EVT",                      /*!< call indication event */
    "CALL_SETUP_IND_EVT",                /*!< call setup indication event */
    "CALL_HELD_IND_EVT",                 /*!< call held indicator event */
    "NETWORK_STATE_EVT",                 /*!< network state change event */
    "SIGNAL_STRENGTH_IND_EVT",           /*!< signal strength indication event */
    "ROAMING_STATUS_IND_EVT",            /*!< roaming status indication event */
    "BATTERY_LEVEL_IND_EVT",             /*!< battery level indication event */
    "CURRENT_OPERATOR_EVT",              /*!< current operator name event */
    "RESP_AND_HOLD_EVT",                 /*!< response and hold event */
    "CLIP_EVT",                          /*!< Calling Line Identification notification event */
    "CALL_WAITING_EVT",                  /*!< call waiting notification */
    "CLCC_EVT",                          /*!< listing current calls event */
    "VOLUME_CONTROL_EVT",                /*!< audio volume control event */
    "AT_RESPONSE",                       /*!< audio volume control event */
    "SUBSCRIBER_INFO_EVT",               /*!< subscriber information event */
    "INBAND_RING_TONE_EVT",              /*!< in-band ring tone settings */
    "LAST_VOICE_TAG_NUMBER_EVT",         /*!< requested number from AG event */
    "RING_IND_EVT",                      /*!< ring indication event */
};

// esp_hf_client_connection_state_t
const char *c_connection_state_str_app[] = {
    "disconnected",
    "connecting",
    "connected",
    "slc_connected",
    "disconnecting",
};

// esp_hf_client_audio_state_t
const char *c_audio_state_str_app[] = {
    "disconnected",
    "connecting",
    "connected",
    "connected_msbc",
};

/// esp_hf_vr_state_t
const char *c_vr_state_str_app[] = {
    "disabled",
    "enabled",
};

// esp_hf_service_availability_status_t
const char *c_service_availability_status_str_app[] = {
    "unavailable",
    "available",
};

// esp_hf_roaming_status_t
const char *c_roaming_status_str_app[] = {
    "inactive",
    "active",
};

// esp_hf_client_call_state_t
const char *c_call_str_app[] = {
    "NO call in progress",
    "call in progress",
};

// esp_hf_client_callsetup_t
const char *c_call_setup_str_app[] = {
    "NONE",
    "INCOMING",
    "OUTGOING_DIALING",
    "OUTGOING_ALERTING"
};

// esp_hf_client_callheld_t
const char *c_call_held_str_app[] = {
    "NONE held",
    "Held and Active",
    "Held",
};

// esp_hf_response_and_hold_status_t
const char *c_resp_and_hold_str_app[] = {
    "HELD",
    "HELD ACCEPTED",
    "HELD REJECTED",
};

// esp_hf_client_call_direction_t
const char *c_call_dir_str_app[] = {
    "outgoing",
    "incoming",
};

// esp_hf_client_call_state_t
const char *c_call_state_str_app[] = {
    "active",
    "held",
    "dialing",
    "alerting",
    "incoming",
    "waiting",
    "held_by_resp_hold",
};

// esp_hf_current_call_mpty_type_t
const char *c_call_mpty_type_str_app[] = {
    "single",
    "multi",
};

// esp_hf_volume_control_target_t
const char *c_volume_control_target_str_app[] = {
    "SPEAKER",
    "MICROPHONE"
};

// esp_hf_at_response_code_t
const char *c_at_response_code_str_app[] = {
    "OK",
    "ERROR"
    "ERR_NO_CARRIER",
    "ERR_BUSY",
    "ERR_NO_ANSWER",
    "ERR_DELAYED",
    "ERR_BLACKLILSTED",
    "ERR_CME",
};

// esp_hf_subscriber_service_type_t
const char *c_subscriber_service_type_str_app[] = {
    "unknown",
    "voice",
    "fax",
};

// esp_hf_client_in_band_ring_state_t
const char *c_inband_ring_state_str_app[] = {
    "NOT provided",
    "Provided",
};


static uint32_t bt_app_hf_client_outgoing_cb_app(uint8_t *p_buf, uint32_t sz)
{
    int out_len_bytes = 0;
    if (is_get_data) {
        out_len_bytes = audio_element_input(hfp_outgoing_stream, (char *)p_buf, sz);
    }

    if (out_len_bytes == sz) {
        is_get_data = false;
        return sz;
    } else {
        is_get_data = true;
        return 0;
    }
}

static void bt_app_hf_client_incoming_cb_app(const uint8_t *buf, uint32_t sz)
{
    if (hfp_incoming_stream) {
        if (audio_element_get_state(hfp_incoming_stream) == AEL_STATE_RUNNING) {
            audio_element_output(hfp_incoming_stream, (char *)buf, sz);
            esp_hf_client_outgoing_data_ready();
        }
    }
}
/* callback for HF_CLIENT */
static void bt_hf_client_cb_app(esp_hf_client_cb_event_t event, esp_hf_client_cb_param_t *param)
{
    if (event <= ESP_HF_CLIENT_RING_IND_EVT) {
        ESP_LOGI(TAG, "APP HFP event: %s", c_hf_evt_str_app[event]);
    } else {
        ESP_LOGE(TAG, "APP HFP invalid event %d", event);
    }

    switch (event) {
    case ESP_HF_CLIENT_CONNECTION_STATE_EVT:
        ESP_LOGI(TAG, "--Connection state %s, peer feats 0x%" PRIx32 ", chld_feats 0x%" PRIx32,
                 c_connection_state_str_app[param->conn_stat.state],
                 param->conn_stat.peer_feat,
                 param->conn_stat.chld_feat);
        break;
    case ESP_HF_CLIENT_AUDIO_STATE_EVT:
        ESP_LOGI(TAG, "--Audio state %s",
                 c_audio_state_str_app[param->audio_stat.state]);
        if ((param->audio_stat.state == ESP_HF_CLIENT_AUDIO_STATE_CONNECTED)
            || (param->audio_stat.state == ESP_HF_CLIENT_AUDIO_STATE_CONNECTED_MSBC)) {
            if(hfp_stream_user_callback.user_hfp_open_cb != NULL) {
                if (param->audio_stat.state == ESP_HF_CLIENT_AUDIO_STATE_CONNECTED) {
                    hfp_stream_user_callback.user_hfp_open_cb(HF_DATA_CVSD);
                } else {
                    hfp_stream_user_callback.user_hfp_open_cb(HF_DATA_MSBC);
                }
            }
            esp_hf_client_register_data_callback(bt_app_hf_client_incoming_cb_app,
                                                 bt_app_hf_client_outgoing_cb_app);
        } else if (param->audio_stat.state == ESP_HF_CLIENT_AUDIO_STATE_DISCONNECTED) {
            if (hfp_stream_user_callback.user_hfp_close_cb != NULL) {
                hfp_stream_user_callback.user_hfp_close_cb();
            }
        }
        break;
    case ESP_HF_CLIENT_BVRA_EVT:
        ESP_LOGI(TAG, "--VR state %s",
                 c_vr_state_str_app[param->bvra.value]);
        break;
    case ESP_HF_CLIENT_CIND_SERVICE_AVAILABILITY_EVT:
        ESP_LOGI(TAG, "--NETWORK state %s",
                 c_service_availability_status_str_app[param->service_availability.status]);
        break;
    case ESP_HF_CLIENT_CIND_ROAMING_STATUS_EVT:
        ESP_LOGI(TAG, "--ROAMING: %s",
                 c_roaming_status_str_app[param->roaming.status]);
        break;
    case ESP_HF_CLIENT_CIND_SIGNAL_STRENGTH_EVT:
        ESP_LOGI(TAG, "--Signal strength: %d",
                 param->signal_strength.value);
        break;
    case ESP_HF_CLIENT_CIND_BATTERY_LEVEL_EVT:
        ESP_LOGI(TAG, "--Battery level %d",
                 param->battery_level.value);
        break;
    case ESP_HF_CLIENT_COPS_CURRENT_OPERATOR_EVT:
        ESP_LOGI(TAG, "--Operator name: %s",
                 param->cops.name);
        break;
    case ESP_HF_CLIENT_CIND_CALL_EVT:
        ESP_LOGI(TAG, "--Call indicator %s",
                 c_call_str_app[param->call.status]);
        break;
    case ESP_HF_CLIENT_CIND_CALL_SETUP_EVT:
        ESP_LOGI(TAG, "--Call setup indicator %s",
                 c_call_setup_str_app[param->call_setup.status]);
        break;
    case ESP_HF_CLIENT_CIND_CALL_HELD_EVT:
        ESP_LOGI(TAG, "--Call held indicator %s",
                 c_call_held_str_app[param->call_held.status]);
        break;
    case ESP_HF_CLIENT_BTRH_EVT:
        ESP_LOGI(TAG, "--Response and hold %s",
                 c_resp_and_hold_str_app[param->btrh.status]);
        break;
    case ESP_HF_CLIENT_CLIP_EVT:
        ESP_LOGI(TAG, "--Clip number %s",
                 (param->clip.number == NULL) ? "NULL" : (param->clip.number));
        break;
    case ESP_HF_CLIENT_CCWA_EVT:
        ESP_LOGI(TAG, "--Call_waiting %s",
                 (param->ccwa.number == NULL) ? "NULL" : (param->ccwa.number));
        break;
    case ESP_HF_CLIENT_CLCC_EVT:
        ESP_LOGI(TAG, "--Current call: idx %d, dir %s, state %s, mpty %s, number %s",
                 param->clcc.idx,
                 c_call_dir_str_app[param->clcc.dir],
                 c_call_state_str_app[param->clcc.status],
                 c_call_mpty_type_str_app[param->clcc.mpty],
                 (param->clcc.number == NULL) ? "NULL" : (param->clcc.number));
        break;
    case ESP_HF_CLIENT_VOLUME_CONTROL_EVT:
        ESP_LOGI(TAG, "--Volume_target: %s, volume %d",
                 c_volume_control_target_str_app[param->volume_control.type],
                 param->volume_control.volume);
        break;
    case ESP_HF_CLIENT_AT_RESPONSE_EVT:
        ESP_LOGI(TAG, "--AT response event, code %d, cme %d",
                 param->at_response.code, param->at_response.cme);
        break;
    case ESP_HF_CLIENT_CNUM_EVT:
        ESP_LOGI(TAG, "--Subscriber type %s, number %s",
                 c_subscriber_service_type_str_app[param->cnum.type],
                 (param->cnum.number == NULL) ? "NULL" : param->cnum.number);
        break;
    case ESP_HF_CLIENT_BSIR_EVT:
        ESP_LOGI(TAG, "--Inband ring state %s",
                 c_inband_ring_state_str_app[param->bsir.state]);
        break;
    case ESP_HF_CLIENT_BINP_EVT:
        ESP_LOGI(TAG, "--Last voice tag number: %s",
                 (param->binp.number == NULL) ? "NULL" : param->binp.number);
        break;
    default:
        ESP_LOGI(TAG, "HF_CLIENT EVT: %d", event);
        break;
    }
}





static void a2dp_sink_blufi_start(coex_handle_t *handle)
{
    if (handle == NULL) {
        return;
    }
    ESP_LOGI(TAG, "[4.1] Init Bluetooth");
    esp_bt_controller_config_t bt_cfg = BT_CONTROLLER_INIT_CONFIG_DEFAULT();
    esp_bt_controller_init(&bt_cfg);
    esp_bt_controller_enable(ESP_BT_MODE_BTDM);
    esp_bluedroid_init();
    esp_bluedroid_enable();
    
    ESP_LOGI(TAG, "[4.2] init gatts");
    // ble_gatts_module_init();
    wifi_server_init();

    esp_err_t set_dev_name_ret = esp_bt_dev_set_device_name(SAMPLE_DEVICE_NAME);
    if (set_dev_name_ret) {
        ESP_LOGE(TAG, "Set BT device name failed, error code = %x, line(%d)", set_dev_name_ret, __LINE__);
    }
    ESP_LOGI(TAG, "[4.3] Create Bluetooth peripheral");
    handle->bt_periph = bt_create_periph();

    ESP_LOGI(TAG, "[4.4] Start peripherals");
    esp_periph_start(handle->set, handle->bt_periph);
    
    ESP_LOGI(TAG, "[4.5] init hfp_stream");
    hfp_open_and_close_evt_cb_register(bt_app_hf_client_audio_open, bt_app_hf_client_audio_close);
    // hfp_service_init();

    esp_hf_client_register_callback(bt_hf_client_cb_app);
    esp_hf_client_init();

#if (ESP_IDF_VERSION >= ESP_IDF_VERSION_VAL(4, 0, 0))
    esp_bt_gap_set_scan_mode(ESP_BT_CONNECTABLE, ESP_BT_GENERAL_DISCOVERABLE);
#else
    esp_bt_gap_set_scan_mode(ESP_BT_SCAN_MODE_CONNECTABLE_DISCOVERABLE);
#endif

    handle->player = setup_player();
}

void bt_hf_client_audio_Init(void)
{
    esp_err_t err = nvs_flash_init();
    if (err == ESP_ERR_NVS_NO_FREE_PAGES) {
        // NVS partition was truncated and needs to be erased
        // Retry nvs_flash_init
        ESP_ERROR_CHECK(nvs_flash_erase());
        err = nvs_flash_init();
    }
#if (ESP_IDF_VERSION >= ESP_IDF_VERSION_VAL(4, 1, 0))
    ESP_ERROR_CHECK(esp_netif_init());
#else
    tcpip_adapter_init();
#endif

    // esp_log_level_set("*", ESP_LOG_WARN);
    // esp_log_level_set(TAG, ESP_LOG_DEBUG);
    
    ESP_LOGI(TAG, "[ 1 ] Create coex handle for a2dp-gatt-wifi");
    g_coex_handle = (coex_handle_t *)audio_malloc(sizeof(coex_handle_t));
    AUDIO_MEM_CHECK(TAG, g_coex_handle, return);
    g_coex_handle->work_mode = NONE_MODE;
    
    ESP_LOGI(TAG, "[ 2 ] Initialize peripherals");
    esp_periph_config_t periph_cfg = DEFAULT_ESP_PERIPH_SET_CONFIG();
    periph_cfg.extern_stack = true;
    g_coex_handle->set = esp_periph_set_init(&periph_cfg);

    // ESP_LOGI(TAG, "[ 3 ] create and start input key service");
    // audio_board_key_init(g_coex_handle->set);
    // input_key_service_info_t input_key_info[] = INPUT_KEY_DEFAULT_INFO();
    // input_key_service_cfg_t input_cfg = INPUT_KEY_SERVICE_DEFAULT_CONFIG();
    // input_cfg.handle = g_coex_handle->set;
    // input_cfg.based_cfg.task_stack = 2048;
    // input_cfg.based_cfg.extern_stack = true;
    // periph_service_handle_t input_ser = input_key_service_create(&input_cfg);
    // input_key_service_add_key(input_ser, input_key_info, INPUT_KEY_NUM);
    // periph_service_set_callback(input_ser, &input_key_service_cb, (void *)g_coex_handle);

    ESP_LOGI(TAG, "[ 4 ] Start a2dp and blufi network");
    a2dp_sink_blufi_start(g_coex_handle);
    
    ESP_LOGI(TAG, "[ 5 ] Create audio pipeline for playback");
    audio_pipeline_cfg_t pipeline_cfg = DEFAULT_AUDIO_PIPELINE_CONFIG();
    audio_pipeline_handle_t pipeline_out = audio_pipeline_init(&pipeline_cfg);
    
    ESP_LOGI(TAG, "[5.1] Create i2s stream to read data from codec chip");
    i2s_stream_cfg_t i2s_cfg = I2S_STREAM_CFG_DEFAULT_WITH_PARA(CODEC_ADC_I2S_PORT, 44100, 16, AUDIO_STREAM_READER);
    audio_element_handle_t i2s_stream_reader = i2s_stream_init(&i2s_cfg);
    
    rsp_filter_cfg_t rsp_cfg = DEFAULT_RESAMPLE_FILTER_CONFIG();
    rsp_cfg.src_rate = 44100;
    rsp_cfg.src_ch = 2;
    rsp_cfg.dest_rate = HFP_RESAMPLE_RATE;
    rsp_cfg.dest_ch = 1;
    audio_element_handle_t filter = rsp_filter_init(&rsp_cfg);

    ESP_LOGI(TAG, "[5.2] Create hfp stream");
    hfp_stream_config_t hfp_config;
    hfp_config.type = OUTGOING_STREAM;
    audio_element_handle_t hfp_out_stream = hfp_stream_init(&hfp_config);
    
    ESP_LOGI(TAG, "[5.3] Register i2s reader and hfp outgoing to audio pipeline");
    audio_pipeline_register(pipeline_out, i2s_stream_reader, "i2s_reader");
    audio_pipeline_register(pipeline_out, filter, "filter");
    audio_pipeline_register(pipeline_out, hfp_out_stream, "outgoing");
    
    ESP_LOGI(TAG, "[5.4] Link it together [codec_chip]-->i2s_stream_reader-->filter-->hfp_out_stream-->[Bluetooth]");
    const char *link_out[3] = {"i2s_reader", "filter", "outgoing"};
    audio_pipeline_link(pipeline_out, &link_out[0], 3);

    ESP_LOGI(TAG, "[5.5] Start audio_pipeline out"); 
    audio_pipeline_run(pipeline_out);
}
