
#include "app_Ble_User.h"
#include "gatts_table_creat_demo.h"
#include <stdint.h>
#include <stdio.h>
#include <stdlib.h>
#include "string.h"
#include "freertos/FreeRTOS.h"
#include "freertos/task.h"
#include "freertos/event_groups.h"
#include "gatts_table_creat_demo.h"
#include "main_user.h"
#include "Protocol_CRC16.h"
#include "Protocol_User.h"
#include "bt_app_main.h"
#include "app_BT_User.h"

#include "freertos/FreeRTOS.h"
#include "freertos/task.h"
#include "esp_system.h"
#include "esp_log.h"
#include "driver/uart.h"
#include "string.h"
#include "driver/gpio.h"
#include "MCU_Core_Protocol.h"
#include "Protocol_Lib.h"
#include "app_Ble_User.h"
#include "app_BT_User.h"
#include "bt_app_hf.h"


#define TAG "MAIN_USER"
extern esp_bd_addr_t peer_addr;

uint32_t Sys_1ms_Cnt;

#define SYS_RUN_TASK_1MS (1) 
#define SYS_RUN_TASK_10MS (Sys_1ms_Cnt % 10 == 1) 
#define SYS_RUN_TASK_20MS (Sys_1ms_Cnt % 20 == 2) 
#define SYS_RUN_TASK_50MS (Sys_1ms_Cnt % 50 == 3) 
#define SYS_RUN_TASK_100MS (Sys_1ms_Cnt % 100 == 4) 
#define SYS_RUN_TASK_1000MS (Sys_1ms_Cnt % 1000 == 5) 



uint32_t testcnt;

static void Sys_Run_Tasks(void *arg)
{
    uint8_t i = 0;
    while(1)
    {
        if(Sys_1ms_Cnt < 499)
        {
            Sys_1ms_Cnt ++ ;
        }
        else
        {
            Sys_1ms_Cnt = 0;
        }


        if(SYS_RUN_TASK_10MS)
        {
            Protocol_Send_Service();
            Protocol_Service();

            BT_User_Process();
        }

        if(SYS_RUN_TASK_20MS)
        {
            
        }

        if(SYS_RUN_TASK_50MS)
        {
            Prot_Send_Msg_Process();
        }

        if(SYS_RUN_TASK_100MS)
        {
            Ble_MsgRec_Navi_Timeout();
        }

        if(SYS_RUN_TASK_1000MS)
        {
            
            simple_ota_service();

            testcnt++;
            if(testcnt >= 10)
            {
                testcnt = 0;

                // printf("BT_User.BT_Sts = %d\r\n", BT_User.BT_Sts);
                // printf("Ble_User.Ble_Sts = %d\r\n", Ble_User.Ble_Sts);

                // esp_log_buffer_hex(TAG, peer_addr, 6);

                // printf("Ble_User.Navi_Updat = %d\r\n", Ble_User.Navi_Updat);

                // printf("RecCtrl.Sts = %d\r\n", RecCtrl.Sts);


                // Ble_Msg_RequestNavi_RLY();



                // if(Prot_User.State < Prot_Normal)
                // {
                //     Prot_User.State = Prot_Normal;

                //     printf("Prot_Normal \r\n");
                // }


            }
        }

        vTaskDelay(1);
    }
    vTaskDelete(NULL);
}

void app_main(void)
{
    Protocol_User_Ctrl_Init();
    BT_User_Init();
    Ble_User_Init();
    Get_Mac_Init();
    bsp_BT_Init();
    // bsp_Ble_Init();
    bsp_Uart_Init();

    // printf("KL30 INIT OVER~~~~~~\r\n");

    xTaskCreatePinnedToCore(Sys_Run_Tasks, "Sys_Run_Tasks", 4096, NULL, 3, NULL, 1);
}



