
#include "RTE_ADC_INTERIM_VERSION.h"
#include "adc.h"
#include "cgc.h"
#include "gpio.h"
#include "isr.h"
#include "Analog\Analog_Signals.h"

// uint8_t u8NewChNum[4] = {2, 3, 7, 5};

void RTC_ADC_Interrupt(void *msg)
{
	INTC_ClearPendingIRQ(ADC_IRQn);     //clear INTAD interrupt flag

}

void RTE_ADC_Init(const uint8_t u8ChList[], uint8_t u8ChNum)
{
	GPIO_InitTypeDef      GPIO_InitStructure = {0};
	ADC_InitTypeDef       ADC_InitStructure = {0};

	
	if(u8ChNum<=7)
	{
		GPIO_InitStructure.GPIO_Pin  = 1U << u8ChNum;  
		GPIO_InitStructure.GPIO_Ctrl = GPIO_Control_ANA; 
		GPIO_Init(GPIO_PORT2, &GPIO_InitStructure);
	}
	else if((u8ChNum==8)||(u8ChNum==9))
	{
		GPIO_InitStructure.GPIO_Pin  = 1U << u8ChNum;  
		GPIO_InitStructure.GPIO_Ctrl = GPIO_Control_ANA; 
		GPIO_Init(GPIO_PORT1, &GPIO_InitStructure);
	}
	else if((u8ChNum==10)||(u8ChNum==11)||(u8ChNum==13))
	{
		GPIO_InitStructure.GPIO_Pin  = 1U << u8ChNum;  
		GPIO_InitStructure.GPIO_Ctrl = GPIO_Control_ANA; 
		GPIO_Init(GPIO_PORT0, &GPIO_InitStructure);
	}
	else if((u8ChNum==12)||(u8ChNum==15))
	{
		GPIO_InitStructure.GPIO_Pin  = 1U << u8ChNum;  
		GPIO_InitStructure.GPIO_Ctrl = GPIO_Control_ANA; 
		GPIO_Init(GPIO_PORT14, &GPIO_InitStructure);
	}
	else if(u8ChNum==14)
	{
		GPIO_InitStructure.GPIO_Pin  = 1U << u8ChNum;  
		GPIO_InitStructure.GPIO_Ctrl = GPIO_Control_ANA; 
		GPIO_Init(GPIO_PORT12, &GPIO_InitStructure);
	}
	else
	{
		;
	}

	ADC_InitStructure.ADC_Mode = ADC_Mode_Select; 
	ADC_InitStructure.ADC_ConvSpeed = ADC_ConvSpeed_High; 
	ADC_InitStructure.ADC_Prescaler = ADC_Prescaler_Div32;
	ADC_InitStructure.ADC_RefVoltage = ADC_Ref_Extern; 
	ADC_InitStructure.ADC_ExternalTrigConv = ADC_ExternalTrig_Software; 
	ADC_InitStructure.ADC_ContinuousConvMode = ADC_Conv_Continuous;
	ADC_InitStructure.ADC_TwoSamplingDelay = ADC_TwoSamplingDelay_13p5Cycles; 
	ADC_InitStructure.ADC_UpLimit = ADC_UpLimit_Setting; 
	ADC_InitStructure.ADC_LowLimit = ADC_LowLimit_Setting; 
	ADC_Init(&ADC_InitStructure);

	ISR_Register(ADC_IRQn, RTC_ADC_Interrupt); 
//	ISR_DisRegister(ADC_IRQn, RTC_ADC_Interrupt); 
	
}

void RTE_ADC_DeInit(void)
{	
	ADC->ADM0  = 0x00U;                 // disable AD conversion and clear ADM0 register 
	CGC_PER0PeriphClockCmd(CGC_PER0Periph_ADC,DISABLE);
	INTC_DisableIRQ(ADC_IRQn);          // disable INTAD interrupt 
	INTC_ClearPendingIRQ(ADC_IRQn);     // clear INTAD interrupt flag    
	NVIC_ClearPendingIRQ(ADC_IRQn);     // clear INTAD interrupt flag 
}

void RTE_ADC_Start_Conversion(void)
{
    /*A/D conversion for SG1 is completed*/
	INTC_ClearPendingIRQ(ADC_IRQn); // clear INTAD interrupt flag	 
	NVIC_ClearPendingIRQ(ADC_IRQn); // clear INTAD interrupt flag 
	INTC_EnableIRQ(ADC_IRQn);		 // enable INTAD interrupt 
	NVIC_EnableIRQ(ADC_IRQn);		 // enable INTAD interrupt

	if((ADC->ADTRG >> 6) != 3)		// write ADCS except for hardwait mode 
	{
		ADC->ADM0 |= (1<<7);            // enables conversion operation 
	}
}
void RTE_ADC_Stop_Conversion(void)
{
    ADC_Stop();
}
/*****************************************************************************/ 
/**
* \brief      Get ADC conversion status
* \retval     0 - ADC is idle
*             1 - ADC is busy
******************************************************************************/
uint8_t RTE_ADC_Get_Conversion_Status(void)
{
    uint8_t u8Status = 0U;

    if ( ADC->ADFLG & 0x01U )
    {
        u8Status = 1U;
    }
    else /*A/D conversion for SG1 is completed*/
    {
        u8Status = 0U;
    }
    return u8Status;
}

void RTE_ADC_Get_Conversion_Result(uint16_t *pu16Data, uint8_t u8ChNum)
{
/* //	uint8_t i;

	if ((pu16Data != 0U) && (u8ChNum > 0U) && (u8ChNum <= 16U))
	{
		if (RTE_ADC_Get_Conversion_Status() == 0U)
		{
//			for (i = 0U; i < u8ChNum; i++)
//			{
				ADC_Converse(u8ChNum, 1, pu16Data);
//			}
		}
	} */

	uint8_t i;

	if ((pu16Data != 0U) && (u8ChNum > 0U) && (u8ChNum <= ADC_TOTAL_CH_NUMBER))
	{
		if (RTE_ADC_Get_Conversion_Status() == 0U)
		{
			for (i = 0U; i < u8ChNum; i++)
			{
				ADC_Converse((ADC_Channel_t)u8ADCChList[i], 1, pu16Data);
				pu16Data++;
			}
		}
	}
}
