#include "Can_App.h"

uint8_t Msg0x17ALostFlag = 0U;
uint8_t Msg0x38ELostFlag = 0U;
uint8_t Msg0x339LostFlag = 0U;

void Can_Set_Buff_3A2(canlib_uint8_t CopyData[])
{
    CANMsg3A2Union *p3A2;
    uint8_t i = 0;
    for (i = 0; i < 8; i++)
    {
        CopyData[i] = 0xFFU;
    }
    p3A2 = (CANMsg3A2Union *)CopyData;
    if (p3A2 != (void *)0)
    {
        #if (PART_NUMBER == RMR42E_60)
            p3A2->Sig.ICU_POWERStateFB = Get_CAN_Power_State();
            p3A2->Sig.ICU_KL15State = (Get_CAN_Power_State() != KEY_OFF);
            p3A2->Sig.ICU_LEDLightState = Get_LINE_IN_BigLED();
            p3A2->Sig.ICU_BuzzerState = BUZZER_ON;//蜂鸣器
            p3A2->Sig.Res0 = 0;
            p3A2->Sig.ICU_IndicatorLightState = Get_Interact_Light_State();
            p3A2->Sig.ICU_IndicatorLightPowerState = 1;
            p3A2->Sig.ICU_GrassFullState = Get_LINE_IN_GrassFull();
            p3A2->Sig.Res1 = 0x0;
            p3A2->Sig.Res2 = 0x00;
            p3A2->Sig.Res3 = 0x00;
            p3A2->Sig.Res4 = 0x00;
            p3A2->Sig.Res5 = 0x00;
            p3A2->Sig.Res6 = 0x00;
            p3A2->Sig.Res7 = 0x00;
            // p3A2->Sig.ICU_MasterBMSCommunicatlost = 1;
            // p3A2->Sig.ICU_SlaveBMSCommunicatlost = (CAN_MSG_Status(&CAN_CH0_CanMsgOp, Co_Can_ConvertSubID_CAN_CH0(CAN_CH0_ID_CAN_0x18200A21_Msg)) == CAN_SIG_NORMAL);
            // p3A2->Sig.ICU_MCUCommunicatlost = (CAN_MSG_Status(&CAN_CH0_CanMsgOp, Co_Can_ConvertSubID_CAN_CH0(CAN_CH0_ID_CAN_0x157_Msg)) == CAN_SIG_NORMAL);
            // p3A2->Sig.ICU_VCUCommunicatlost = (CAN_MSG_Status(&CAN_CH0_CanMsgOp, Co_Can_ConvertSubID_CAN_CH0(CAN_CH0_ID_CAN_0x125_Msg)) == CAN_SIG_NORMAL);
            // p3A2->Sig.Res0 = 0x0;
            // p3A2->Sig.Res1 = 0x00;
            // p3A2->Sig.Res2 = 0x00;
            // p3A2->Sig.Res3 = 0x00;
            // p3A2->Sig.Res4 = 0x00;
            // p3A2->Sig.Res5 = 0x00;
            // p3A2->Sig.Res6 = 0x00;
            // p3A2->Sig.Res7 = 0x00;
        #else
            if (Get_CAN_Power_State() == KEY_ACC)
            {
                p3A2->Sig.ICU_PowerEnable = 0x1U;
            }
            else
            {
                p3A2->Sig.ICU_PowerEnable = 0x0U;
            }

            p3A2->Sig.ICU_LEDLightState = Get_TelltalesLedSts(em_LED_LED_Open_W);

            p3A2->Sig.ICU_BuzzerState = Get_Buzzer_Status();

            p3A2->Sig.ICU_GrassFullState = Get_TelltalesLedSts(em_LED_Grass_Full_R);

            p3A2->Sig.Res0 = 0U;
            p3A2->Sig.Res1 = 0U;
            p3A2->Sig.Res2 = 0U;
            p3A2->Sig.Res3 = 0U;
            p3A2->Sig.Res4 = 0U;
            p3A2->Sig.Res5 = 0U;
            p3A2->Sig.Res6 = 0U;
            p3A2->Sig.Res7 = 0U;
            p3A2->Sig.Res8 = 0U;
            p3A2->Sig.Res9 = 0U;

        #endif
    }
}
void Can_Set_Buff_3A7(canlib_uint8_t CopyData[])
{
    #if (PART_NUMBER == RMR42E_60)
    CANMsg3A7Union *p3A7;
    uint8_t i = 0;
    for (i = 0; i < 8; i++)
    {
        CopyData[i] = 0xFFU;
    }
    p3A7 = (CANMsg3A7Union *)CopyData; 
    if (p3A7 != (void *)0)
    {
            p3A7->Sig.ICU_MasterBMSCommunicatlost = (CAN_MSG_Status(&CAN_CH0_CanMsgOp, Co_Can_ConvertSubID_CAN_CH0(CAN_CH0_ID_CAN_0x18200A20_Msg)) == CAN_SIG_NORMAL);
            p3A7->Sig.ICU_SlaveBMSCommunicatlost = (CAN_MSG_Status(&CAN_CH0_CanMsgOp, Co_Can_ConvertSubID_CAN_CH0(CAN_CH0_ID_CAN_0x18200A21_Msg)) == CAN_SIG_NORMAL);
            p3A7->Sig.ICU_MCUCommunicatlost = (CAN_MSG_Status(&CAN_CH0_CanMsgOp, Co_Can_ConvertSubID_CAN_CH0(CAN_CH0_ID_CAN_0x157_Msg)) == CAN_SIG_NORMAL);
            p3A7->Sig.ICU_VCUCommunicatlost = (CAN_MSG_Status(&CAN_CH0_CanMsgOp, Co_Can_ConvertSubID_CAN_CH0(CAN_CH0_ID_CAN_0x125_Msg)) == CAN_SIG_NORMAL);
            p3A7->Sig.Res0 = 0x0;
            p3A7->Sig.Res1 = 0x00;
            p3A7->Sig.Res2 = 0x00;
            p3A7->Sig.Res3 = 0x00;
            p3A7->Sig.Res4 = 0x00;
            p3A7->Sig.Res5 = 0x00;
            p3A7->Sig.Res6 = 0x00;
            p3A7->Sig.Res7 = 0x00;
    }
    #endif
}

void Can_Set_Buff_393(canlib_uint8_t CopyData[])
{
    #if (PART_NUMBER == RMR42E_60)
    CANMsg393Union *p393;
    uint8_t i = 0;
    for (i = 0; i < 8; i++)
    {
        CopyData[i] = 0xFFU;
    }
    p393 = (CANMsg393Union *)CopyData;
    if (p393 != (void *)0)
    {
        p393->Sig.ICU_HardVer = 1;
        p393->Sig.ICU_SubHardVer = 0;
        p393->Sig.ICU_SoftVer = 1;
        p393->Sig.ICU_SubSoftVer = 0;
        p393->Sig.ICU_SoftPhaseVer = 0;
        p393->Sig.Res0 = 0x0;
        p393->Sig.ICU_ProtoVer = 0;
        p393->Sig.ICU_ProtoSubVer = 7;
        p393->Sig.Res1 = 0x00;
    }
    #endif
}

void Can_Set_Buff_3D4(canlib_uint8_t CopyData[])
{
    #if (PART_NUMBER == G54_A01)
        CANMsg3D4Union *p3D4;
        uint8_t i = 0;
        for (i = 0; i < 8; i++)
        {
            CopyData[i] = 0xFFU;
        }
        p3D4 = (CANMsg3D4Union *)CopyData;
        if (p3D4 != (void *)0)
        {
            p3D4->Sig.ICU_MasterBMSCommunicatlost = 0;
            if (Msg0x17ALostFlag)
            {
                p3D4->Sig.ICU_SlaveBMSCommunicatlost = 1U;
            }
            else 
            {
                p3D4->Sig.ICU_SlaveBMSCommunicatlost = 0;
            }
            if (Msg0x339LostFlag)
            {
                p3D4->Sig.ICU_MCUCommunicatlost = 1U;
            }
            else 
            {
                p3D4->Sig.ICU_MCUCommunicatlost = 0;
            }
            if (Msg0x38ELostFlag)
            {
                p3D4->Sig.ICU_BMCUCommunicatlost = 1U;
            }
            else 
            {
                p3D4->Sig.ICU_BMCUCommunicatlost = 0;
            }
            p3D4->Sig.ICU_VCUCommunicatlost = 0;
            p3D4->Sig.Res0 = 0x0;
            p3D4->Sig.Res1 = 0x00;
            p3D4->Sig.Res2 = 0x00;
            p3D4->Sig.Res3 = 0x00;
            p3D4->Sig.Res4 = 0x00;
            p3D4->Sig.Res5 = 0x00;
            p3D4->Sig.Res6 = 0x00;
            p3D4->Sig.Res7 = 0x00;
            p3D4->Sig.Res8 = 0x00;
        }
    #endif
}
